/***********************************************************************************

  Module :	Controller.h

  Description :	

  Last Modified $Date: $

  $Revision: $

  Copyright (C) 29 May 2005 T Swann

***********************************************************************************/

#ifndef _CONTROLLER_H_
#define _CONTROLLER_H_

//**********************************************************************************
//   Include Files
//**********************************************************************************
#include "Types.h"

//**********************************************************************************
//   Macros
//**********************************************************************************

//**********************************************************************************
//   Types
//**********************************************************************************

//**********************************************************************************
//   Constants
//**********************************************************************************
enum EKey
{
	KEY_UP			= 0x0010,
	KEY_DOWN		= 0x0040,
	KEY_LEFT		= 0x0080,
	KEY_RIGHT		= 0x0020,
	KEY_SELECT		= 0x0001,
	KEY_START		= 0x0008,
	KEY_LTRIGGER	= 0x0100,
	KEY_RTRIGGER	= 0x0200,
	KEY_TRIANGLE	= 0x1000,
	KEY_SQUARE		= 0x8000,
	KEY_CIRCLE		= 0x2000,
	KEY_CROSS		= 0x4000,
};

enum EAnalogAxis
{
	ANALOG_X		= 0,
	ANALOG_Y		= 1,
};

//**********************************************************************************
//   Class definitions
//**********************************************************************************
void	CTRL_Init();
u32		CTRL_GetKey();
u8		CTRL_GetAnalogAxis( u32 axis );

//**********************************************************************************
//   Externs
//**********************************************************************************

//**********************************************************************************
//   Prototypes
//**********************************************************************************

#endif /* _CONTROLLER_H_ */
