;*****************************************************************
;**            Gameboy full screen distortion demo              **
;**                  (c) Anders Granlund 1997                   **
;**                                                             **
;**                      Converted to RGBDS                     **
;**                      2002 by DuoDreamer                     **
;**            Original source code included in the             **
;**                    commented lines below.                   **
;**                                                             **
;*****************************************************************
;** The gameboy seems to be able to do the most cool things.	**
;** This is just a simple example of what can be done with the	**
;** interrupts..                                                **
;** It makes use of a sine-table, so there's not any realtime	**
;** calculations.                                               **
;**                                                             **
;** Credits to Dr. Pan of anthrox for his Sine-table generator  **
;** "Rolleroaster" !                                            **
;*****************************************************************


;*************** Start of Original TASM Source Code **************

;memvar				.EQU $CC00
;distpos			.EQU memvar
;ypos				.EQU memvar+1
;bary				.EQU memvar+2
;
;.org	0
;
;.org $40
;  jp Vblank_interrupt
;  reti
;.org $48
;  jp lcd_interrupt
;  reti
;.org $50
;  reti
;.org $58
;  reti
;.org $60
;  reti
;
;
;.org $100
;  nop
;  jp begin
;
;;Nintendo Scrolling Title Graphic
;;***********************************************
;.byte	0ceh,0edh,66h,66h,0cch,13,0,11,3,73h
;.byte	0,83h,0,12,0,13,0,8,17,31,88h,89h,0
;.byte	14,0dch,0cch,6eh,0e6h,0ddh,0ddh,0d9h
;.byte	99h,0bbh,0bbh,67h,63h,6eh,0eh,0ech,0cch
;.byte	0ddh,0dch,99h,09fh,0bbh,0b9h,33h,3eh
;;***********************************************
;
;.byte   "Distortion      "              ;Title of the game
;.byte	0,0,0				;Not used
;.byte	0 				;Cartridge type: Rom only
;					; 0 - Rom only      3 - ROM+MBC1+RAM+Battery
;					; 1 - ROM+MBC1      5 - ROM+MBC2
;					; 2 - ROM+MBC1+RAM  6 - ROM+MBC2+Battery
;.byte	0				;Rom Size:
;					; 0 - 256kBit =  32kB =  2 banks
;					; 1 - 512kBit =  64kB =  4 banks
;					; 2 -   1MBit = 128kB =  8 banks
;					; 3 -   2MBit = 256kB = 16 banks
;					; 4 -   4MBit = 512kB = 32 banks
;.byte   0				;Ram Size:
;					; 0 - None
;					; 1 -  16kBit =  2kB = 1 bank
;					; 2 -  64kBit =  8kB = 1 bank
;					; 3 - 256kBit = 32kB = 4 banks
;.byte	"Vi","ka"			;Manufacturer code:
;.byte	1				;Version Number
;.byte	0ah				;Complement check
;.word	0				;Checksum
;
;;***********
;;** SETUP **
;;***********
;begin:
;  di
;  ld a,20
;  ld (bary),a
;  ld a,0
;  ld (distpos),a
;  ld (ypos),a
;  ldh ($42),a			;Scroll X
;  ldh ($43),a			;Scroll Y
;
;
;  ld a,%10010011
;  ldh ($40),a			;Turn screen on
;
;
;  ld a,%11100100		;"normal" colours
;  ldh ($47),a			;BG palette
;  ldh ($48),a			;OBJ0 palette
;  ldh ($49),a			;OBJ1 palette
;  ld a,0			;First ldc-int at Y=0
;  ldh ($45),a
;  ld a,%01000100		;set lcdc int
;  ldh ($41),a
;  ld a,%00000011
;  ldh ($FF),a			;We want LCDC int + Vblank
; 
;  call load_map			;Load the background map
;  call load_tiles		;Load tiles
;
;  ei				;Enable those int's!
;
;
;;***************
;;** MAIN LOOP **
;;***************
;
;
;main:
;  jp main
;
;
;
;;********************
;;** LCDC-INTERRUPT **
;;********************
;
;lcd_interrupt:
;  push af				;Save A + flags
;;  push bc
;;  push de
;;  push hl
;  ld hl,distdata			;Set HL at first X-value
;  ld a,(ypos)				;What line are we at?
;  ld b,0
;  ld d,b
;  ld e,a
;  add hl,de				;Set HL to point at right value
;
;  ld a,(distpos)
;  ld b,0
;  ld d,b
;  ld e,a
;  add hl,de
;
;  ld a,(hl)
;  srl a
;  ldh ($43),a				;Scroll line
;  ld a,(ypos)
;  inc a
;  cp 144
;  call z,resetA
;  ld (ypos),a
;  ldh ($45),a				;Set next ldc-int to occur at next line
;
;  ld a,(ypos)
;  ld b,a
;  ld a,(bary)
;  cp b
;  jr z,bar1
;  inc a
;  cp b
;  jr z,bar2
;  inc a
;  cp b
;  jr z,bar3
;  inc a
;  cp b
;  jr z,bar4
;  inc a
;  cp b
;  jr z,bar5
;  inc a
;  cp b
;  jr z,bar6
;  inc a
;  cp b
;  jr z,bar7
;  inc a
;  cp b
;  jr z,endbar
;end_lcdcint:
;;  pop hl
;;  pop de
;;  pop bc
;  pop af				;restore a + flags
;  reti
;bar1:
;  ld a,%11111111
;  ldh ($47),a
;  jr end_lcdcint
;bar2:
;  ld a,%10101010
;  ldh ($47),a
;  jr end_lcdcint
;bar3:
;  ld a,%01010101
;  ldh ($47),a
;  jr end_lcdcint
;bar4:
;  ld a,%00000000
;  ldh ($47),a
;  jr end_lcdcint
;bar5:
;  ld a,%01010101
;  ldh ($47),a
;  jr end_lcdcint
;bar6:
;  ld a,%10101010
;  ldh ($47),a
;  jr end_lcdcint
;bar7:
;  ld a,%11111111
;  ldh ($47),a
;  jr end_lcdcint
;endbar:
;  ld a,%11100100
;  ldh ($47),a
;  jr end_lcdcint
;resetA:
;  ld a,0
;  ret
;
;
;
;;**********************
;;** VBLANK-INTERRUPT **
;;**********************
;
;Vblank_interrupt:
;  push af
;
;  ld hl,distdata2		;Move the rasterbar
;  ld a,(distpos)
;  ld d,0
;  ld e,a
;  add hl,de
;  ld a,(hl)
;  ld (bary),a   
;
;  ld a,(distpos)
;  inc a
;  cp 145
;  jr nz,end_vblankint
;  ld a,0
;end_vblankint:
;  ld (distpos),a
;  pop af
;  reti
;
;
;
;
;;******************
;;** SUB-ROUTINES **
;;******************
;
;load_map:
;  ld de,$9800			;Mapmem location
;  ld hl,map			;Mapdata
;  ld c,32			;Height=32
;ldmap1:
;  ld b,32			;Width=32
;ldmap2:
;  ld a,(hli)
;  call wrAtode
;  inc de
;  dec b
;  jr nz,ldmap2
;  dec c
;  jr nz,ldmap1
;  ret
;
;
;load_tiles:
;  ld de,$8000			;BG-tiles position
;  ld hl,tiles			;Tile-data to load
;  ld c,5			;Nr. of tiles
;loadtiles:
;  ld b,16			;16 bytes per tile 
;loadonetile:
;  ld a,(hli)
;  call wrAtode
;  inc de
;  dec b
;  jr nz,loadonetile
;  dec c
;  jr nz,loadtiles
;  ret
;
;
;wrAtode:		;Writes A to HL at the right time
;  push af		;Save reg A and flags
;wral2:
;  ldh a,($41)
;  and 2
;  jr nz,wral2
;  pop af		;Restore reg A and flags
;  ld (de),a		;write a to hl
;  ret
;
;
;;**********
;;** DATA **
;;**********
;
;tiles:
;.byte $55,$01,$AB,$55,$41,$3F,$8D,$67
;.byte $5D,$27,$9D,$7F,$41,$3F,$FF,$FF
;.byte $55,$00,$AA,$55,$40,$3F,$87,$7F
;.byte $48,$38,$90,$72,$52,$32,$90,$70
;.byte $54,$34,$90,$74,$53,$30,$88,$78
;.byte $47,$38,$80,$7F,$55,$7F,$FF,$FF
;.byte $55,$01,$AB,$57,$01,$FF,$E3,$FF
;.byte $11,$0F,$0B,$47,$49,$47,$0B,$07
;.byte $29,$27,$0B,$27,$C9,$07,$13,$0F
;.byte $E1,$1F,$03,$FF,$55,$FF,$FF,$FF
;
;
;;*************
;;The sin-table
;;*************
;distdata:
;.db   30,  31,  32,  33,  35,  36,  37,  39
;.db   40,  41,  42,  43,  44,  46,  47,  48
;.db   49,  50,  51,  52,  52,  53,  54,  55
;.db   55,  56,  57,  57,  58,  58,  58,  59
;.db   59,  59,  59,  59,  59,  59,  59,  59
;.db   59,  59,  58,  58,  58,  57,  57,  56
;.db   56,  55,  54,  53,  53,  52,  51,  50
;.db   49,  48,  47,  46,  45,  43,  42,  41
;.db   40,  39,  37,  36,  35,  34,  32,  31
;.db   30,  28,  27,  26,  24,  23,  22,  21
;.db   19,  18,  17,  16,  15,  14,  12,  11
;.db   10,  9,  8,  7,  7,  6,  5,  4
;.db   4,  3,  2,  2,  1,  1,  1,  0
;.db   0,  0,  0,  0,  0,  0,  0,  0
;.db   0,  0,  0,  1,  1,  2,  2,  3
;.db   3,  4,  5,  6,  6,  7,  8,  9
;.db   10,  11,  12,  13,  14,  15,  17,  18
;.db   19,  20,  21,  23,  24,  25,  27,  28
;.db   29,  31,  32,  33,  34,  36,  37,  38
;.db   40,  41,  42,  43,  44,  45,  46,  48
;.db   49,  50,  51,  51,  52,  53,  54,  55
;.db   55,  56,  57,  57,  58,  58,  58,  59
;.db   59,  59,  59,  59,  59,  59,  59,  59
;.db   59,  59,  59,  58,  58,  57,  57,  56
;.db   56,  55,  54,  54,  53,  52,  51,  50
;.db   49,  48,  47,  46,  45,  44,  43,  41
;.db   40,  39,  38,  36,  35,  34,  33,  31
;.db   30,  29,  27,  26,  25,  23,  22,  21
;.db   20,  18,  17,  16,  15,  14,  13,  12
;.db   11,  10,  9,  8,  7,  6,  5,  4
;.db   4,  3,  2,  2,  1,  1,  1,  0
;.db   0,  0,  0,  0,  0,  0,  0,  0
;.db   0,  0,  0,  1,  1,  2,  2,  3
;.db   3,  4,  5,  5,  6,  7,  8,  9
;.db   10,  11,  12,  13,  14,  15,  16,  18
;.db   19,  20,  21,  23,  24,  25,  26,  28
;
;
;
;;*******************
;;Table for rasterbar
;;*******************
;distdata2:
;.db  136,  135,  133,  132,  130,  129,  127,  126
;.db  124,  123,  121,  120,  119,  117,  116,  114
;.db  113,  112,  110,  109,  107,  106,  105,  103
;.db  102,  101,  100,  98,  97,  96,  95,  94
;.db  93,  91,  90,  89,  88,  87,  86,  85
;.db  84,  83,  82,  81,  81,  80,  79,  78
;.db  77,  77,  76,  75,  75,  74,  73,  73
;.db  72,  72,  71,  71,  70,  70,  70,  69
;.db  69,  69,  69,  68,  68,  68,  68,  68
;.db  68,  68,  68,  68,  68,  68,  68,  69
;.db  69,  69,  69,  70,  70,  70,  71,  71
;.db  72,  72,  73,  73,  74,  75,  75,  76
;.db  77,  77,  78,  79,  80,  81,  81,  82
;.db  83,  84,  85,  86,  87,  88,  89,  90
;.db  91,  93,  94,  95,  96,  97,  98,  100
;.db  101,  102,  104,  105,  106,  107,  109,  110
;.db  112,  113,  114,  116,  117,  119,  120,  121
;.db  123,  124,  126,  127,  129,  130,  132,  133
;.db  135
;
;
;;**************
;;Screen mapdata
;;**************
;map:
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;.db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
;
;
;.end

;********** End of original source code *********************


;****************** Start of RGBASM Source Code ****************


distpos EQU	$CC00
ypos	EQU distpos + 1
bary	EQU distpos + 2


SECTION "ORG$0000", HOME[0]
	reti
	
SECTION "V-Blank Interrupt", HOME[$0040]
	jp Vblank_interrupt
	reti

SECTION "LCD Interrupt", HOME[$0048]
	jp lcd_interrupt
	reti

SECTION "Int $50", HOME[$0050]
	reti

SECTION "Int $58", HOME[$0058]
	reti

SECTION "Int $60", HOME[$0060]
	reti

SECTION "Header", HOME[$0100]
  nop
  jp begin

;Nintendo Scrolling Title Graphic
;***********************************************
DB $ce,$ed,$66,$66,$cc,13,0,11,3,$73
DB 0,$83,0,12,0,13,0,8,17,31,$88,$89,0
DB 14,$dc,$cc,$6e,$e6,$dd,$dd,$d9
DB $99,$bb,$bb,$67,$63,$6e,$0e,$ec,$cc
DB $dd,$dc,$99,$9f,$bb,$b9,$33,$3e
;***********************************************

DB	"Distortion      "              ;Title of the game
DB	0,0,0				;Not used
DB	0 				;Cartridge type: Rom only
					; 0 - Rom only      3 - ROM+MBC1+RAM+Battery
					; 1 - ROM+MBC1      5 - ROM+MBC2
					; 2 - ROM+MBC1+RAM  6 - ROM+MBC2+Battery
DB	0				;Rom Size:
					; 0 - 256kBit =  32kB =  2 banks
					; 1 - 512kBit =  64kB =  4 banks
					; 2 -   1MBit = 128kB =  8 banks
					; 3 -   2MBit = 256kB = 16 banks
					; 4 -   4MBit = 512kB = 32 banks
DB	0				;Ram Size:
					; 0 - None
					; 1 -  16kBit =  2kB = 1 bank
					; 2 -  64kBit =  8kB = 1 bank
					; 3 - 256kBit = 32kB = 4 banks
DB	0,0				;Manufacturer code:
DB	1				;Version Number
DB	0				;Complement check
DW	0				;Checksum

;***********
;** SETUP **
;***********
begin:
  di
  ld a,20
  ld [bary],a
  ld a,0
  ld [distpos],a
  ld [ypos],a
  ldh [$42],a			;Scroll X
  ldh [$43],a			;Scroll Y


  ld a,%10010011
  ldh [$40],a			;Turn screen on


  ld a,%11100100		;"normal" colours
  ldh [$47],a			;BG palette
  ldh [$48],a			;OBJ0 palette
  ldh [$49],a			;OBJ1 palette
  ld a,0			;First ldc-int at Y=0
  ldh [$45],a
  ld a,%01000100		;set lcdc int
  ldh [$41],a
  ld a,%00000011
  ldh [$FF],a			;We want LCDC int + Vblank
 
  call load_map			;Load the background map
  call load_tiles		;Load tiles

  ei				;Enable those int's!


;***************
;** MAIN LOOP **
;***************


main:
  jp main



;********************
;** LCDC-INTERRUPT **
;********************

lcd_interrupt:
  push af				;Save A + flags
;  push bc
;  push de
;  push hl
  ld hl,distdata			;Set HL at first X-value
  ld a,[ypos]				;What line are we at?
  ld b,0
  ld d,b
  ld e,a
  add hl,de				;Set HL to point at right value

  ld a,[distpos]
  ld b,0
  ld d,b
  ld e,a
  add hl,de

  ld a,[hl]
  srl a
  ldh [$43],a				;Scroll line
  ld a,[ypos]
  inc a
  cp 144
  call z,resetA
  ld [ypos],a
  ldh [$45],a				;Set next ldc-int to occur at next line

  ld a,[ypos]
  ld b,a
  ld a,[bary]
  cp b
  jr z,bar1
  inc a
  cp b
  jr z,bar2
  inc a
  cp b
  jr z,bar3
  inc a
  cp b
  jr z,bar4
  inc a
  cp b
  jr z,bar5
  inc a
  cp b
  jr z,bar6
  inc a
  cp b
  jr z,bar7
  inc a
  cp b
  jr z,endbar
end_lcdcint:
;  pop hl
;  pop de
;  pop bc
  pop af				;restore a + flags
  reti
bar1:
  ld a,%11111111
  ldh [$47],a
  jr end_lcdcint
bar2:
  ld a,%10101010
  ldh [$47],a
  jr end_lcdcint
bar3:
  ld a,%01010101
  ldh [$47],a
  jr end_lcdcint
bar4:
  ld a,%00000000
  ldh [$47],a
  jr end_lcdcint
bar5:
  ld a,%01010101
  ldh [$47],a
  jr end_lcdcint
bar6:
  ld a,%10101010
  ldh [$47],a
  jr end_lcdcint
bar7:
  ld a,%11111111
  ldh [$47],a
  jr end_lcdcint
endbar:
  ld a,%11100100
  ldh [$47],a
  jr end_lcdcint
resetA:
  ld a,0
  ret



;**********************
;** VBLANK-INTERRUPT **
;**********************

Vblank_interrupt:
  push af

  ld hl,distdata2		;Move the rasterbar
  ld a,[distpos]
  ld d,0
  ld e,a
  add hl,de
  ld a,[hl]
  ld [bary],a   

  ld a,[distpos]
  inc a
  cp 145
  jr nz,end_vblankint
  ld a,0
end_vblankint:
  ld [distpos],a
  pop af
  reti




;******************
;** SUB-ROUTINES **
;******************

load_map:
  ld de,$9800			;Mapmem location
  ld hl,map			;Mapdata
  ld c,32			;Height=32
ldmap1:
  ld b,32			;Width=32
ldmap2:
  ld a,[hl+]
  call wrAtode
  inc de
  dec b
  jr nz,ldmap2
  dec c
  jr nz,ldmap1
  ret


load_tiles:
  ld de,$8000			;BG-tiles position
  ld hl,tiles			;Tile-data to load
  ld c,5			;Nr. of tiles
loadtiles:
  ld b,16			;16 bytes per tile 
loadonetile:
  ld a,[hl+]
  call wrAtode
  inc de
  dec b
  jr nz,loadonetile
  dec c
  jr nz,loadtiles
  ret


wrAtode:		;Writes A to HL at the right time
  push af		;Save reg A and flags
wral2:
  ldh a,[$41]
  and 2
  jr nz,wral2
  pop af		;Restore reg A and flags
  ld [de],a		;write a to hl
  ret



;**********
;** DATA **
;**********

tiles::
DB $55,$01,$AB,$55,$41,$3F,$8D,$67
DB $5D,$27,$9D,$7F,$41,$3F,$FF,$FF
DB $55,$00,$AA,$55,$40,$3F,$87,$7F
DB $48,$38,$90,$72,$52,$32,$90,$70
DB $54,$34,$90,$74,$53,$30,$88,$78
DB $47,$38,$80,$7F,$55,$7F,$FF,$FF
DB $55,$01,$AB,$57,$01,$FF,$E3,$FF
DB $11,$0F,$0B,$47,$49,$47,$0B,$07
DB $29,$27,$0B,$27,$C9,$07,$13,$0F
DB $E1,$1F,$03,$FF,$55,$FF,$FF,$FF


;*************
;The sin-table
;*************
distdata::
DB   30,  31,  32,  33,  35,  36,  37,  39
db   40,  41,  42,  43,  44,  46,  47,  48
db   49,  50,  51,  52,  52,  53,  54,  55
db   55,  56,  57,  57,  58,  58,  58,  59
db   59,  59,  59,  59,  59,  59,  59,  59
db   59,  59,  58,  58,  58,  57,  57,  56
db   56,  55,  54,  53,  53,  52,  51,  50
db   49,  48,  47,  46,  45,  43,  42,  41
db   40,  39,  37,  36,  35,  34,  32,  31
db   30,  28,  27,  26,  24,  23,  22,  21
db   19,  18,  17,  16,  15,  14,  12,  11
db   10,  9,  8,  7,  7,  6,  5,  4
db   4,  3,  2,  2,  1,  1,  1,  0
db   0,  0,  0,  0,  0,  0,  0,  0
db   0,  0,  0,  1,  1,  2,  2,  3
db   3,  4,  5,  6,  6,  7,  8,  9
db   10,  11,  12,  13,  14,  15,  17,  18
db   19,  20,  21,  23,  24,  25,  27,  28
db   29,  31,  32,  33,  34,  36,  37,  38
db   40,  41,  42,  43,  44,  45,  46,  48
db   49,  50,  51,  51,  52,  53,  54,  55
db   55,  56,  57,  57,  58,  58,  58,  59
db   59,  59,  59,  59,  59,  59,  59,  59
db   59,  59,  59,  58,  58,  57,  57,  56
db   56,  55,  54,  54,  53,  52,  51,  50
db   49,  48,  47,  46,  45,  44,  43,  41
db   40,  39,  38,  36,  35,  34,  33,  31
db   30,  29,  27,  26,  25,  23,  22,  21
db   20,  18,  17,  16,  15,  14,  13,  12
db   11,  10,  9,  8,  7,  6,  5,  4
db   4,  3,  2,  2,  1,  1,  1,  0
db   0,  0,  0,  0,  0,  0,  0,  0
db   0,  0,  0,  1,  1,  2,  2,  3
db   3,  4,  5,  5,  6,  7,  8,  9
db   10,  11,  12,  13,  14,  15,  16,  18
db   19,  20,  21,  23,  24,  25,  26,  28



;*******************
;Table for rasterbar
;*******************
distdata2::
db  136,  135,  133,  132,  130,  129,  127,  126
db  124,  123,  121,  120,  119,  117,  116,  114
db  113,  112,  110,  109,  107,  106,  105,  103
db  102,  101,  100,  98,  97,  96,  95,  94
db  93,  91,  90,  89,  88,  87,  86,  85
db  84,  83,  82,  81,  81,  80,  79,  78
db  77,  77,  76,  75,  75,  74,  73,  73
db  72,  72,  71,  71,  70,  70,  70,  69
db  69,  69,  69,  68,  68,  68,  68,  68
db  68,  68,  68,  68,  68,  68,  68,  69
db  69,  69,  69,  70,  70,  70,  71,  71
db  72,  72,  73,  73,  74,  75,  75,  76
db  77,  77,  78,  79,  80,  81,  81,  82
db  83,  84,  85,  86,  87,  88,  89,  90
db  91,  93,  94,  95,  96,  97,  98,  100
db  101,  102,  104,  105,  106,  107,  109,  110
db  112,  113,  114,  116,  117,  119,  120,  121
db  123,  124,  126,  127,  129,  130,  132,  133
db  135


;**************
;Screen mapdata
;**************
map::
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4
db 2,4,2,4,2,4,2,4,2,4,2,4,2,4,2,4


;This part is here to make RGBASM output a 32K file, 
;the minimum valid rom image size.
SECTION "padding", DATA, BANK[1]
db 0




;EOF
