
#include <sys/types.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>
#include <libcd.h>
#include <kernel.h>

#include "hitmod.h"
#include "ccinv320.h"
#include "spacedel.h"/*Space Deliria-Dr. Awesome*/
#include "bbaminot.h"
#include "apple5.h"
#include "sinstuff.h"/*720 point +-32 sintable*/


#define OT_LENGTH  14  
GsOT WorldOT[2];
GsOT_TAG OTTags[2][1<<OT_LENGTH]; 

#define PACKETMAX 10000
PACKET GpuPacketArea[2][PACKETMAX*24];


#define SCREEN_WIDTH	320
#define SCREEN_HEIGHT	240

#define BALLWALLX (SCREEN_WIDTH-32)
#define BALLWALLY (SCREEN_HEIGHT-32)

/*  Ball pattern movement related variables */
typedef struct {
	u_short x, y;			/* Location */
	u_short dx, dy;		/* Speed */
} POS;


POS amigaball;


GsIMAGE LogoIm;/*CC logo*/
GsSPRITE LogoSp;

u_long PadData;

GsIMAGE logoimg;
GsSPRITE logospr[120];

GsIMAGE 	fontimg;
GsSPRITE	fontspr[64+8];/*64 chars+1amiball+3notes+4bars*/


GsSPRITE notestar1[20];
GsSPRITE notestar2[16];
GsSPRITE notestar3[12];


GsIMAGE appleimg;
GsSPRITE applespr[5];


GsSPRITE	scroll[44];
GsSPRITE scroll2[44];



int actBuffer=0,dmode=MODE_NTSC;
u_long	pad, oldPad;


char txt,txt2;

char scrolltext[]="                                                  "\
"crazy cellist presents 'playstation opus one'  'space deliria' mod by dr.awesome"\
"  player by silpheed  font derived from beagle bros apple mechanic typefaces"\
" disk...  greets to danzig, ddt, madman, nik, silpheed, brainwalker, nagra,"\
" jihad, groepaz, van helsing, scorpion, yums, loser, bufferman, now3d, anttih,"\
" middy, jackripper, icepic, alfa, duke, da swieep, ayatollah, heaven, airia,"\
" hunkpapa, gabriel knight, yobemag, wigwam, samnova, snake, mcbain & the rest of the psxdev-addicts...  "\
"                                                                        ";


char scrolltext2[]="                                                  "\
"hello's out to some of the people responsible for the music that runs through"\
" my head: ofra harnoy, jacqueline du pre, rush, vanessa-mae, ragin, jean-luc ponty,"\
" clara ponty, apocalyptica, the great kat, jean-michel jarre, scorpions, yeah right,"\
" rasputina, cello, candy dulfer, thalia, ofra haza, tangerine dream, kmfdm, vangelis,"\
" cecilia bartoli, shania twain, lords of acid, jethro tull, styx, dokken, UFO,"\
" sammy hagar, loreena mckennitt, joe satriani & kate bush to name a few...      "\
" special thanks to my wonderful wife for letting me interrupt her 'skullmonkeys'"\
" sessions to screw around with demos :-)  love ya!  "\
"                                                                        ";


int i=0,j=0,delay=0;
int step=0,scrpos=0,sincount=0,sincount2=0;
int step2=0,scrpos2=0;


void	setup_System(void);
void	init_Sprite(GsIMAGE*, GsSPRITE*);

void	DisplayAll(int);
void	main(void);

void init_Font(void);
void init_LogoSprites(void);
void init_AppleSprites(void);

void	do_Info(void);

void	set_ModePAL(void);
void	set_ModeNTSC(void);


void dointrospin(void);
void movescroll1(void);
void movescroll2(void);
void movestars(void);
void movelogo(void);
void movemusicbars(void);
void moveball(void);


int scrollspeed=0;
int scrollspeed2=0;


int appleindex=0;
int appleframe=0;
int applespinnum=0;

int amiball=0;

int speeds[]={0,1,2,4,8,16};

int star1x[]={-5,240,100,45,270,-2,20,132,300,190,75,36,140,290,7,242,150,200,42,167};/*20:-8/320*/
int star2x[]={125,42,320,212,76,5,280,-2,25,176,54,265,80,10,242,150};/*16:-7/320*/
int star3x[]={300,67,188,280,125,-2,200,42,175,100,5,225};/*12:-5/320*/

int logosinoff=0;/*720 points*/
int savedlogosin=0;

void main()
{
/*send blurb out comm*/

  printf("\n\n\n\n");
  printf("            CRAZY CELLIST\n\n");
  printf("             PSX - OP.1\n\n\n");
/*         987654321098765432101234567890123456789*/
  printf("  'SPACE DELIRIA' MOD BY DR.AWESOME\n");
  printf("         PLAYER BY SILPHEED\n\n");
/*         987654321098765432101234567890123456789*/
  printf("'CHOMP' FONT DERIVED FROM BEAGLE BROS.\n");
  printf("    APPLE MECHANIC TYPEFACES DISK\n\n\n\n\n");
               
	setup_System();


   PadData=0;
   
   do_Info();/*text stuff*/


init_AppleSprites();
dointrospin();/*APPLE ][*/





MOD_Init();

   
   init_Font();/*font+amigaball+notestars*/

   init_LogoSprites();/*CC*/


	scrollspeed=2; //5=faaaast
   scrollspeed2=2; //1=slow


   amigaball.x=rand();
   amigaball.y=rand();

   amigaball.dx=1;
   amigaball.dy=1;


for (i=0;i<20;i++)
   {
   notestar1[i]=fontspr[65];
   notestar1[i].y=i*12;
   notestar1[i].x=star1x[i];//i*16;
   }
for (i=0;i<16;i++)
   {
   notestar2[i]=fontspr[66];
   notestar2[i].y=i*15;
   notestar2[i].x=star2x[i];//i*20;
   }
for (i=0;i<12;i++)
   {
   notestar3[i]=fontspr[67];
   notestar3[i].y=i*20;
   notestar3[i].x=star3x[i];//i*26;
   }


	MOD_Load((unsigned char*)&spacedeliria);
   MOD_Start();


	for(;;)
	{
		actBuffer=GsGetActiveBuff();						// get the current buffer
		GsSetWorkBase((PACKET*)GpuPacketArea[actBuffer]);	// Setup the packet workbase
		GsClearOt(0,0,&WorldOT[actBuffer]);					// clear the ordering table


  
movescroll1();
movescroll2();
movelogo();
moveball();
movestars();
movemusicbars();



	DisplayAll(actBuffer);
//	PadData=PadRead(0);
	}

ResetGraph(0);
PadStop();
return;

}



void movestars()
{

for (j=0;j<5;j++)
   {
   for (i=0;i<20;i++)
      {
      notestar1[i].x--;
      if (notestar1[i].x==-8) notestar1[i].x=320;
      }
   }

for (j=0;j<3;j++)
   {
   for (i=0;i<16;i++)
      {
      notestar2[i].x--;
      if (notestar2[i].x==-7) notestar2[i].x=320;
      }
   }

for (i=0;i<12;i++)
   {
   notestar3[i].x--;
   if (notestar3[i].x==-5) notestar3[i].x=320;
   }


   for (i=0;i<20;i++)
      GsSortFastSprite(&notestar1[i], &WorldOT[actBuffer], 0);
   for (i=0;i<16;i++)
      GsSortFastSprite(&notestar2[i], &WorldOT[actBuffer], 0);
   for (i=0;i<12;i++)
      GsSortFastSprite(&notestar3[i], &WorldOT[actBuffer], 0);

   
}




void dointrospin()
{
appleindex=0;
appleframe=0;
applespinnum=0;

for(;;)
  {
   actBuffer=GsGetActiveBuff();						// get the current buffer
   GsSetWorkBase((PACKET*)GpuPacketArea[actBuffer]);	// Setup the packet workbase
   GsClearOt(0,0,&WorldOT[actBuffer]);					// clear the ordering table


         applespr[appleindex].x=105;
         applespr[appleindex].y=20;
         GsSortFastSprite(&applespr[appleindex], &WorldOT[actBuffer], 0);

appleframe++;
if (appleframe==4)
   {
   if (applespinnum==4) break;

   appleframe=0;
   appleindex++;
   if (appleindex==5)
      {
      appleindex=1;
      applespinnum++;
      if (applespinnum==4)
         {
         appleindex=0;
         }
      }
   }



	DisplayAll(actBuffer);
	PadData=PadRead(1);
   }



}

void movescroll1()
{
for(i=0;i<42;i++)
   {
   txt=scrolltext[scrpos+i];
   if(txt!=0)
      {
      if (txt>=0x61&&txt<0x7b) txt-=0x20;
      /*A=0x41/65  fontsprite [0x21/33]*/
      j=txt-0x20;
      scroll[i]=fontspr[j];
      scroll[i].x=((16*i)-step);
      scroll[i].y=20;
      GsSortFastSprite(&scroll[i], &WorldOT[actBuffer], 0);
      }
   else
      {
      scrpos=0;
      }
   }
step+=speeds[scrollspeed];
if (step==16)
   {
   scrpos++;
   step=0;
   }
}
void movescroll2()
{
for(i=0;i<42;i++)
   {
   txt2=scrolltext2[scrpos2+i];
   if(txt2!=0)
      {
      if (txt2>=0x61&&txt2<0x7b) txt2-=0x20;
      /*A=0x41/65  fontsprite [0x21/33]*/
      j=txt2-0x20;
      scroll2[i]=fontspr[j];
      scroll2[i].x=((16*i)-step2);
      scroll2[i].y=204;
      GsSortFastSprite(&scroll2[i], &WorldOT[actBuffer], 0);
      }
   else
      {
      scrpos2=0;
      }
   }
step2+=speeds[scrollspeed2];
if (step2==16)
   {
   scrpos2++;
   step2=0;
   }
}

void movelogo()
{
/*
for (i=0;i<119;i++)
   {
   logospr[i].x=70;
   logospr[i].y=60+i;
   GsSortFastSprite(&logospr[i], &WorldOT[actBuffer], 0);
   }
*/

logosinoff=savedlogosin;

for (i=0;i<119;i++)
   {
   logospr[i].r=fadesin[logosinoff];
   logospr[i].g=fadesin[logosinoff];
   logospr[i].b=fadesin[logosinoff];/*64 128*/
   logospr[i].x=logosin[logosinoff];/*64 -32 70 +32*/
   logospr[i].y=60+i;
   GsSortFastSprite(&logospr[i], &WorldOT[actBuffer], 0);

   logosinoff++;
   if (logosinoff==360) logosinoff=0;
   }
savedlogosin++;
if (savedlogosin==360) savedlogosin=0;


}



void moveball()
{
int ballx,bally;

if ((ballx = (amigaball.x += amigaball.dx) % BALLWALLX*2) >= BALLWALLX)
	ballx = BALLWALLX*2 - ballx;
if ((bally = (amigaball.y += amigaball.dy) % BALLWALLY*2) >= BALLWALLY)
	bally = BALLWALLY*2 - bally;

/* Set new coordinate value for sprite primitive */
fontspr[64].x = ballx;
fontspr[64].y = bally;

   GsSortFastSprite(&fontspr[64], &WorldOT[actBuffer], 0);
   
}

void movemusicbars()
{
/*

FntPrint("ORDER: %3d    PATTERN: %3d    ROW: %2d\n", *MOD_CurrentOrder, *MOD_CurrentPattern, *MOD_CurrentRow);
FntPrint("0: %3d  1: %3d  2: %3d  3: %3d\n",
  MOD_Volume[0],MOD_Volume[1],MOD_Volume[2],MOD_Volume[3]);

FntPrint("0: %3d  1: %3d  2: %3d  3: %3d\n",
  MOD_Freq[0],MOD_Freq[1],MOD_Freq[2],MOD_Freq[3]);

FntPrint("0: %3d  1: %3d  2: %3d  3: %3d\n",
  MOD_LastSample[0],MOD_LastSample[1],MOD_LastSample[2],MOD_LastSample[3]);

*/

fontspr[68].r=MOD_Volume[0]*2;/*max volume is 0x40...brightness 0x80...*/
fontspr[68].g=0;
fontspr[68].b=0;
   GsSortFastSprite(&fontspr[68], &WorldOT[actBuffer], 0);

fontspr[69].r=0;
fontspr[69].g=MOD_Volume[1]*2;
fontspr[69].b=0;
   GsSortFastSprite(&fontspr[69], &WorldOT[actBuffer], 0);

fontspr[70].r=0;
fontspr[70].g=0;
fontspr[70].b=MOD_Volume[2]*2;
   GsSortFastSprite(&fontspr[70], &WorldOT[actBuffer], 0);

fontspr[71].r=MOD_Volume[3]*2;
fontspr[71].g=0;
fontspr[71].b=MOD_Volume[3]*2;
   GsSortFastSprite(&fontspr[71], &WorldOT[actBuffer], 0);

}



void init_Font()
{
int i=0,j=0,k=0,savek=0;

GsGetTimInfo((u_long *)(bbaminot+4), &fontimg);
init_Sprite(&fontimg, &fontspr[0]);
fontspr[0].w=16;
fontspr[0].h=15;
fontspr[0].u=0;
fontspr[0].v=0;
j=16;
k=0;
for(i=1;i<16;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=16;
   }
j=0;
k+=16;
for(i=16;i<32;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=16;
   }
j=0;
k+=16;
for(i=32;i<48;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=16;
   }
j=0;
k+=16;
for(i=48;i<64;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=16;
   }

j=0;
k+=16;


savek=k;/*for different heights of notes*/

fontspr[64]=fontspr[0];/*amiball*/
fontspr[64].w=32;
fontspr[64].h=32;
fontspr[64].u=j;
fontspr[64].v=k;
j+=32;

k+=9;
fontspr[65]=fontspr[0];/*bignote*/
fontspr[65].w=8;
fontspr[65].h=23;
fontspr[65].u=j;
fontspr[65].v=k;
j+=8;

k+=5;
fontspr[66]=fontspr[0];/*mednote*/
fontspr[66].w=7;
fontspr[66].h=18;
fontspr[66].u=j;
fontspr[66].v=k;
j+=7;

k+=4;
fontspr[67]=fontspr[0];/*litnote*/
fontspr[67].w=5;
fontspr[67].h=14;
fontspr[67].u=j;
fontspr[67].v=k;
j+=5;

k=savek;

fontspr[68]=fontspr[0];/*bar1*/
fontspr[68].w=128;
fontspr[68].h=8;
fontspr[68].u=j;
fontspr[68].v=k;
fontspr[68].r=0x80;
fontspr[68].g=0;
fontspr[68].b=0;
fontspr[68].x=96;
fontspr[68].y=40;
k+=8;

fontspr[69]=fontspr[0];/*bar2*/
fontspr[69].w=128;
fontspr[69].h=8;
fontspr[69].u=j;
fontspr[69].v=k;
fontspr[69].r=0;
fontspr[69].g=0x80;
fontspr[69].b=0;
fontspr[69].x=96;
fontspr[69].y=50;
k+=8;

fontspr[70]=fontspr[0];/*bar3*/
fontspr[70].w=128;
fontspr[70].h=8;
fontspr[70].u=j;
fontspr[70].v=k;
fontspr[70].r=0;
fontspr[70].g=0;
fontspr[70].b=0x80;
fontspr[70].x=96;
fontspr[70].y=182;
k+=8;

fontspr[71]=fontspr[0];/*bar4*/
fontspr[71].w=128;
fontspr[71].h=8;
fontspr[71].u=j;
fontspr[71].v=k;
fontspr[71].r=0x80;
fontspr[71].g=0;
fontspr[71].b=0x80;
fontspr[71].x=96;
fontspr[71].y=192;
k+=8;

}

void init_LogoSprites()
{
int i=0,j=0,k=0;

GsGetTimInfo((u_long *)(cclogopics+4), &logoimg);
init_Sprite(&logoimg, &logospr[0]);
logospr[0].w=180;
logospr[0].h=1;
logospr[0].u=0;
logospr[0].v=0;

for(i=1;i<119;i++)
   {
   logospr[i]=logospr[0];
   logospr[i].u=0;
   logospr[i].v=i;
   }
}




void init_AppleSprites()
{
int i=0,j=0,k=0;
j=0;k=1;
GsGetTimInfo((u_long *)(apple5+4), &appleimg);
init_Sprite(&appleimg, &applespr[0]);
applespr[0].w=110;
applespr[0].h=15;
applespr[0].u=j;
applespr[0].v=k;
j=0;
k=33;
   applespr[1]=applespr[0];
   applespr[1].u=j;
   applespr[1].v=k;
k+=32;
   applespr[2]=applespr[0];
   applespr[2].u=j;
   applespr[2].v=k;
k+=32;
   applespr[3]=applespr[0];
   applespr[3].u=j;
   applespr[3].v=k;
k+=32;
   applespr[4]=applespr[0];
   applespr[4].u=j;
   applespr[4].v=k;


}


void do_Info()
{

 for(;;)
  {
actBuffer=GsGetActiveBuff();						// get the current buffer
GsSetWorkBase((PACKET*)GpuPacketArea[actBuffer]);	// Setup the packet workbase
GsClearOt(0,0,&WorldOT[actBuffer]);					// clear the ordering table

  FntPrint("\n\n\n\n\n\n");
  FntPrint("            CRAZY CELLIST\n\n");
  FntPrint("             PSX - OP.1\n\n\n");
/*         987654321098765432101234567890123456789*/
  FntPrint("  'SPACE DELIRIA' MOD BY DR.AWESOME\n");
  FntPrint("         PLAYER BY SILPHEED\n\n");
/*         987654321098765432101234567890123456789*/
  FntPrint("'CHOMP' FONT DERIVED FROM BEAGLE BROS.\n");
  FntPrint("    APPLE MECHANIC TYPEFACES DISK\n\n\n\n");
  FntPrint("  PRESS (X) FOR PAL OR (O) FOR NTSC\n\n");

	DisplayAll(actBuffer);
	PadData=PadRead(1);

	if(PadData&PADRdown)
		{
      set_ModePAL();
		break;
		}
	if(PadData&PADRright)
		{
      set_ModeNTSC();
		break;
		}

   }

}




void set_ModePAL()
{
	if(dmode!=MODE_PAL)
	{
		DrawSync(0);
		VSync(0);
		SetVideoMode(MODE_PAL);
		ResetGraph(0);
		GsInitGraph(SCREEN_WIDTH, SCREEN_HEIGHT, GsNONINTER|GsOFSGPU, 0,0);
		GsDefDispBuff(0,0,0,SCREEN_HEIGHT);
		dmode=MODE_PAL;
//		printf("...displaymode changed to PAL...\n");
	}
}
void set_ModeNTSC()
{
	if(dmode!=MODE_NTSC)
	{
		DrawSync(0);
		VSync(0);
		SetVideoMode(MODE_NTSC);
		ResetGraph(0);
		GsInitGraph(SCREEN_WIDTH, SCREEN_HEIGHT, GsNONINTER|GsOFSGPU, 0,0);
		GsDefDispBuff(0,0,0,SCREEN_HEIGHT);
		dmode=MODE_NTSC;
//		printf("...displaymode changed to NTSC...\n");
	}
}

void setup_System()
{
/*peek at the BIOS for region code...*/
if (*(char *)0xbfc7ff52=='E') dmode=MODE_PAL;
else dmode=MODE_NTSC;

SetVideoMode(dmode);

ResetGraph(0);

GsInitGraph(SCREEN_WIDTH, SCREEN_HEIGHT, GsNONINTER|GsOFSGPU, 0,0);
GsDefDispBuff(0,0,0,SCREEN_HEIGHT);
	
WorldOT[0].length=OT_LENGTH;
WorldOT[0].org=OTTags[0];
WorldOT[1].length=OT_LENGTH;
WorldOT[1].org=OTTags[1];
 
GsClearOt(0,0,&WorldOT[0]);
GsClearOt(0,0,&WorldOT[1]);
	               
FntLoad(960, 256);
FntOpen(8, 0, 312, 248, 0, 512);	

SetDispMask(1);
PadInit(0);

}

void DisplayAll(int mybuffer)
{
	FntFlush(-1);
	DrawSync(0);									// Wait for all drawing to finish
	VSync(0);										// wait for V_BLANK interrupt
	GsSwapDispBuff();								// flip double buffers
	GsSortClear(0,0,0,&WorldOT[mybuffer]);				// Clear the Ordering Table with a background color
	GsDrawOt(&WorldOT[mybuffer]);						// Draw the ordering table for the actBuffer
}
void init_Sprite(GsIMAGE *im, GsSPRITE *sp)
{
	int bits;
	int widthCompression;
	RECT myRect;
		
	bits=im->pmode&0x03;
	if (bits==0) widthCompression=4;
	else if (bits==1) widthCompression=2;
	else if (bits==2) widthCompression=1;
	else if (bits==3) { printf("\nunsupported file format (24bit tim)!\n"); exit(-1);}
	
	myRect.x = im->px;
	myRect.y = im->py;
	myRect.w = im->pw;
	myRect.h = im->ph;
	LoadImage( &myRect, im->pixel );		//loads image data to frame buffer

	sp->attribute = (bits<<24);
	sp->x = SCREEN_WIDTH/2-((im->pw*widthCompression)/2);	//center sprite's x value
	sp->y = SCREEN_HEIGHT/2-im->ph/2;			//center sprite's y value
	sp->w = im->pw*widthCompression;
	sp->h = im->ph;
	sp->tpage=GetTPage(bits, 0, im->px, im->py);
	sp->u=0;
	sp->v=0;
	if (bits==0||bits==1) {
		//checks if image is 4 or 8 bit
		myRect.x = im->cx;
		myRect.y = im->cy;
		myRect.w = im->cw;
		myRect.h = im->ch;
		LoadImage( &myRect, im->clut );		//loads clut to frame buffer if needed
		sp->cx=im->cx;
		sp->cy=im->cy;
	}
	sp->r=128;
	sp->g=128;
	sp->b=128;
	sp->mx=(im->pw*widthCompression)/2;
	sp->my=im->ph/2;
	sp->scalex=ONE;
	sp->scaley=ONE;
	sp->rotate=0*ONE;
}

