/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.UniPixelViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CPCPlusColorChooser
extends JPanel {
    public int selectedPen = 0;
    UniPixelViewer viewer;
    BufferedImage prev = new BufferedImage(384, 272, 1);
    JFrame frame;
    int xpos = 0;
    int ypos = 0;
    private JSlider blue;
    private JLabel display;
    private JSlider green;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSlider red;

    public void setPen(int pen) {
        this.selectedPen = pen;
        this.prev.createGraphics().drawImage((Image)this.viewer.display, 0, 0, this);
        this.display.setIcon(new ImageIcon(this.prev));
    }

    public void setInk(int rgb) {
        Color col = new Color(rgb);
        int r = col.getRed() / 17;
        int g = col.getGreen() / 17;
        int b = col.getBlue() / 17;
        this.jPanel1.setBackground(col);
        this.red.setValue(r);
        this.green.setValue(g);
        this.blue.setValue(b);
    }

    public void setPos(int x, int y) {
        this.xpos = x;
        this.ypos = y;
    }

    public void putChooser() {
        if (this.frame == null) {
            this.frame = new JFrame();
            this.frame.setUndecorated(true);
            this.frame.setLayout(new BorderLayout());
            this.frame.add(this);
            this.setBackground(Color.black);
            this.frame.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    CPCPlusColorChooser.this.frame.setVisible(false);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.frame.pack();
        }
        this.frame.setLocation(this.xpos, this.ypos);
        this.frame.setVisible(true);
        this.frame.requestFocus();
    }

    public CPCPlusColorChooser(UniPixelViewer viewer) {
        this.viewer = viewer;
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.red = new JSlider();
        this.green = new JSlider();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.blue = new JSlider();
        this.jButton2 = new JButton();
        this.display = new JLabel();
        this.jPanel2 = new JPanel();
        this.setBackground(new Color(0, 0, 0));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setFocusable(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.jButton1.setText("Cancel");
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPCPlusColorChooser.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setBackground(new Color(0, 0, 0));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("R");
        this.jLabel1.setOpaque(true);
        this.red.setBackground(new Color(0, 0, 0));
        this.red.setForeground(new Color(255, 255, 255));
        this.red.setMaximum(15);
        this.red.setMinorTickSpacing(1);
        this.red.setPaintTicks(true);
        this.red.setSnapToTicks(true);
        this.red.setFocusable(false);
        this.red.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CPCPlusColorChooser.this.blueStateChanged(evt);
            }
        });
        this.green.setBackground(new Color(0, 0, 0));
        this.green.setForeground(new Color(255, 255, 255));
        this.green.setMaximum(15);
        this.green.setMinorTickSpacing(1);
        this.green.setPaintTicks(true);
        this.green.setSnapToTicks(true);
        this.green.setFocusable(false);
        this.green.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CPCPlusColorChooser.this.blueStateChanged(evt);
            }
        });
        this.jLabel2.setBackground(new Color(0, 0, 0));
        this.jLabel2.setForeground(new Color(255, 255, 255));
        this.jLabel2.setText("G");
        this.jLabel2.setOpaque(true);
        this.jLabel3.setBackground(new Color(0, 0, 0));
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText("B");
        this.jLabel3.setOpaque(true);
        this.blue.setBackground(new Color(0, 0, 0));
        this.blue.setForeground(new Color(255, 255, 255));
        this.blue.setMaximum(15);
        this.blue.setMinorTickSpacing(1);
        this.blue.setPaintTicks(true);
        this.blue.setSnapToTicks(true);
        this.blue.setFocusable(false);
        this.blue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CPCPlusColorChooser.this.blueStateChanged(evt);
            }
        });
        this.jButton2.setText("Ok");
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPCPlusColorChooser.this.jButton2ActionPerformed(evt);
            }
        });
        this.display.setOpaque(true);
        this.display.setPreferredSize(new Dimension(384, 272));
        this.display.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                CPCPlusColorChooser.this.displayMouseMoved(evt);
            }
        });
        this.display.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                CPCPlusColorChooser.this.displayMouseReleased(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setFocusable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.blue, -2, 128, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.red, -2, 128, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.green, -2, 128, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1)).addComponent(this.display, -2, 384, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.red, -2, 22, -2).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.green, -2, 22, -2).addComponent(this.jLabel2, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.blue, -2, 22, -2).addComponent(this.jLabel3, -2, 22, -2))).addComponent(this.jPanel2, -2, -1, -2)).addGap(9, 9, 9).addComponent(this.display, -2, 272, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.frame.setVisible(false);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int r = this.red.getValue() * 17;
        int g = this.green.getValue() * 17;
        int b = this.blue.getValue() * 17;
        Color rgb = new Color(r, g, b);
        UniPixelViewer.GateArrayPalette[this.selectedPen] = rgb.getRGB() & 0xFFFFFF;
        UniPixelViewer.mode0palette[this.selectedPen] = rgb.getRGB() & 0xFFFFFF;
        if (this.selectedPen < 4) {
            UniPixelViewer.mode1palette[this.selectedPen] = rgb.getRGB() & 0xFFFFFF;
        }
        this.frame.setVisible(false);
        this.viewer.keepLastPalette.setSelected(true);
        this.viewer.defineCPCPal();
        this.viewer.draw();
    }

    private void blueStateChanged(ChangeEvent evt) {
        int r = this.red.getValue() * 17;
        int g = this.green.getValue() * 17;
        int b = this.blue.getValue() * 17;
        Color rgb = new Color(r, g, b);
        this.jPanel1.setBackground(rgb);
    }

    private void displayMouseMoved(MouseEvent evt) {
        int xpos = evt.getX();
        int ypos = evt.getY();
        Color rgb = new Color(this.prev.getRGB(xpos, ypos));
        this.jPanel2.setBackground(rgb);
    }

    private void displayMouseReleased(MouseEvent evt) {
        Color rgb = new Color(this.prev.getRGB(evt.getX(), evt.getY()));
        UniPixelViewer.GateArrayPalette[this.selectedPen] = rgb.getRGB() & 0xFFFFFF;
        UniPixelViewer.mode0palette[this.selectedPen] = rgb.getRGB() & 0xFFFFFF;
        if (this.selectedPen < 4) {
            UniPixelViewer.mode1palette[this.selectedPen] = rgb.getRGB() & 0xFFFFFF;
        }
        this.frame.setVisible(false);
        this.viewer.keepLastPalette.setSelected(true);
        this.viewer.defineCPCPal();
        this.viewer.draw();
    }
}

