/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.VP8StatusCode;
import com.luciad.imageio.webp.WebPDecoderOptions;
import com.luciad.imageio.webp.WebPEncoderOptions;
import java.io.IOException;
import java.nio.ByteOrder;
import org.scijava.nativelib.NativeLibraryUtil;

final class WebP {
    private static boolean NATIVE_LIBRARY_LOADED = false;

    static synchronized void loadNativeLibrary() {
        if (!NATIVE_LIBRARY_LOADED) {
            NATIVE_LIBRARY_LOADED = true;
            NativeLibraryUtil.loadNativeLibrary(WebP.class, "webp-imageio");
        }
    }

    private WebP() {
    }

    public static int[] decode(WebPDecoderOptions aOptions, byte[] aData, int aOffset, int aLength, int[] aOut) throws IOException {
        if (aOptions == null) {
            throw new NullPointerException("Decoder options may not be null");
        }
        if (aData == null) {
            throw new NullPointerException("Input data may not be null");
        }
        if (aOffset + aLength > aData.length) {
            throw new IllegalArgumentException("Offset/length exceeds array size");
        }
        int[] pixels = WebP.decode(aOptions.fPointer, aData, aOffset, aLength, aOut, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
        VP8StatusCode status = VP8StatusCode.getStatusCode(aOut[0]);
        switch (status) {
            case VP8_STATUS_OK: {
                break;
            }
            case VP8_STATUS_OUT_OF_MEMORY: {
                throw new OutOfMemoryError();
            }
            default: {
                throw new IOException("Decode returned code " + (Object)((Object)status));
            }
        }
        return pixels;
    }

    private static native int[] decode(long var0, byte[] var2, int var3, int var4, int[] var5, boolean var6);

    public static int[] getInfo(byte[] aData, int aOffset, int aLength) throws IOException {
        int[] out = new int[2];
        int result = WebP.getInfo(aData, aOffset, aLength, out);
        if (result == 0) {
            throw new IOException("Invalid WebP data");
        }
        return out;
    }

    private static native int getInfo(byte[] var0, int var1, int var2, int[] var3);

    public static byte[] encodeRGBA(WebPEncoderOptions aOptions, byte[] aRgbaData, int aWidth, int aHeight, int aStride) {
        return WebP.encodeRGBA(aOptions.fPointer, aRgbaData, aWidth, aHeight, aStride);
    }

    private static native byte[] encodeRGBA(long var0, byte[] var2, int var3, int var4, int var5);

    public static byte[] encodeRGB(WebPEncoderOptions aOptions, byte[] aRgbaData, int aWidth, int aHeight, int aStride) {
        return WebP.encodeRGB(aOptions.fPointer, aRgbaData, aWidth, aHeight, aStride);
    }

    private static native byte[] encodeRGB(long var0, byte[] var2, int var3, int var4, int var5);

    static {
        WebP.loadNativeLibrary();
    }
}

