; *pBitmap = agdCreateBitmap(*ptr pAsset)
;       d0                        a1  
agdCreateBitmap:
	movem.l	d5-d6/a1,-(a7)

	move.l	#tBitmap,d0				; Create a new Bitmap handle
	bsr	agdCreateNewHandle	
	
	move.l	#512-1,d7				; Seek canary					
.loop_bmhd:
	cmp.l	#"BMHD",(a1)
	beq.s	.bmhd
	addq.w	#2,a1
	dbf	d7,.loop_bmhd
	moveq	#-1,d1
	bra	.exit
	
; Parse Bitmap Header here
.bmhd:	
	move.l	a1,hAddress(a0)				; Save address of asset
	move.l	4(a1),hSize(a0)				; Save Length of asset
	move.l	#tBitmap,hType(a0)			; Save type of resource	
	move.l	d0,hIndex(a0)				; Save handle for this type

	addq.w	#8,a1	
	move.w	(a1),hBitmapWidth(a0)	
	move.w	2(a1),hBitmapDepth(a0)	
; Save number of Bitplanes
	moveq	#0,d6	
	move.b	8(a1),d6
	move.w	d6,hBitmapPlanes(a0)

; Work out the modulo
	moveq	#0,d5
	move.w	hBitmapWidth(a0),d5
	lsr.w	#3,d5					; Divide by 8
	subq.w	#1,d6
	mulu	d5,d6
	move.w	d6,hBitmapModulo(a0)

	move.b	8(a1),d6				; Save full scan line length
	mulu	d5,d6
	move.w	d6,hBitmapScanLength(a0)
	
; Get number of colours
	moveq	#0,d5
	moveq	#0,d6
	move.b	8(a1),d5
	bset	d5,d6
	move.w	d6,hBitmapColours(a0)

.loop_body:
	cmp.l	#"BODY",(a1)
	beq.s	.body
	addq.w	#2,a1
	dbf	d7,.loop_body	
	
.body:	move.l	a1,hBitmapBody(a0)			; Save 
	move.l	a0,d0					; Return pointer to handle	
	bra.s	.exit
	
.error_handle_fail:
	moveq	#-1,d0
.exit:	movem.l	(a7)+,d5-d6/a1
	rts
	

; d0=Bitmap structure pointer	
; a0=VRam Pointer 0=allocate Amiga Chip Ram instead (create screen for it).
agdCreateBitmapMask:
	movem.l	d1-d7/a0-a3,-(a7)
	move.l	d0,a2
	move.l	hBitmapBody(a2),a1
; a1 = pointer to "BODY"
	move.l	4(a1),d0				; size to allocate
	addq.l	#8,d0					; Keep "BODY" and $SIZE.l
	
	cmp.l	#0,a0
	bne.s	.vram
	
; Allocate from Amiga Chip RAM
	move.l	d0,d7
	moveq	#MEMF_CHIP,d1				; Chip ram
	move.l	a6,-(a7)
	move.l  ExecBase,a6
        jsr     _LVOAllocMem(a6)
	move.l	(a7)+,a6
	tst.l	d0
	beq	.error
	
	ADDSEG_SIZE_D7
	
	move.l	d0,d6				; Save the allocated buffer origin in d6	
	bra.s	.a

; Allocate screen in VRAM
.vram:		
	move.l	a2,a1
	moveq	#-1,d1
	bsr	agdCreateScreen			; Get a segment of VRAM

	move.l	hVramNumScreens(a0),d1
	subq.l	#1,d1
	;bmi.s	.error
	move.l	d0,a0
	move.l	hAddress(a0),d6
	move.l	hSize(a0),d7
	
.a:	move.l	#tBitmapMask,d0
	bsr	agdCreateNewHandle
	tst.l	d0
	bmi	.error
	
	move.l	d0,hIndex(a0)				; Save handle for this type
	move.l	#tBitmapMask,hType(a0)			; Save type of resource
	move.l	d6,hAddress(a0)
	move.l	d7,hSize(a0)
	
	move.l	d6,a3
	move.l	#"BODY",(a3)+
	move.l	d7,(a3)+

	move.w	hBitmapWidth(a2),hBitmapMaskWidth(a0)
	move.w	hBitmapDepth(a2),hBitmapMaskDepth(a0)
	move.w	hBitmapPlanes(a2),hBitmapMaskPlanes(a0)
	move.w	#1,hBitmapMaskColours(a0)
	move.w	hBitmapModulo(a2),hBitmapMaskModulo(a0)
	move.w	hBitmapScanLength(a2),hBitmapMaskScanLength(a0)	
	move.l	d6,hBitmapMaskBody(a0)
	move.w	hBitmapMaskPlanes(a0),d6	

; lines in outer loop
; bitplanes on inner loop
	moveq	#0,d3

	moveq	#0,d5
	move.w	hBitmapMaskDepth(a2),d5			; Get number of lines
	subq.w	#1,d5
	
.depth:
	moveq	#0,d6
	move.w	hBitmapMaskWidth(a2),d6			
	lsr.w	#4,d6					; Number of words wide
	move.l	d6,d2
	subq.w	#1,d6
	
.line:
	move.l	hBitmapMaskBody(a0),a1			; Destination
	move.l	hBitmapBody(a2),a3			; Source
	addq.l	#8,a1
	addq.l	#8,a3
	add.l	d3,a1
	add.l	d3,a3
	
	move.l	d5,d1			
	mulu	hBitmapScanLength(a2),d1		; Full Scan line length
	add.l	d1,a1					; Start at bottom in source
	add.l	d1,a3					; Start at bottom in dest

	moveq	#0,d7					;Number of bitplanes
	move.w	hBitmapMaskPlanes(a2),d7
	subq.w	#1,d7
	
	move.w	(a3),d4	
.loop_get:
	add.l	d2,a3
	add.l	d2,a3
	or.w	(a3),d4
	dbf	d7,.loop_get

	move.w	hBitmapMaskPlanes(a0),d7
	subq.w	#1,d7
.loop_set:
	move.w	d4,(a1)
	add.l	d2,a1
	add.l	d2,a1
	dbf	d7,.loop_set
	
	addq.w	#2,d3
	
	dbf	d6,.line
	
	moveq	#0,d3
	
	dbf	d5,.depth

	move.l	a0,d0
	bra.s	.exit

.error:	moveq	#-1,d0

.exit:	movem.l	(a7)+,d1-d7/a0-a3
	rts
	


; d0=Bitmap structure pointer	
; a0=VRam Pointer 0=allocate Amiga Chip Ram instead (create screen for it).
agdCreateBitmapSingleMask:
	movem.l	d1-d7/a0-a3,-(a7)
	move.l	d0,a2
	move.l	hBitmapBody(a2),a1
; a1 = pointer to "BODY"
	move.l	4(a1),d0				; size to allocate
	divu.w	hBitmapPlanes(a2),d0			; Divide by number of planes to get single size
	
	addq.l	#8,d0					; Keep "BODY" and $SIZE.l
	
	cmp.l	#0,a0
	bne.s	.vram
	
; Allocate from Amiga Chip RAM
	move.l	d0,d7
	moveq	#MEMF_CHIP,d1				; Chip ram
	move.l	a6,-(a7)
	move.l  ExecBase,a6
        jsr     _LVOAllocMem(a6)
	move.l	(a7)+,a6
	tst.l	d0
	beq	.error
	
	ADDSEG_SIZE_D7
	
	move.l	d0,d6				; Save the allocated buffer origin in d6	
	bra.s	.a

; Allocate screen in VRAM
.vram:		
	move.l	a2,a1
	moveq	#-1,d1
	bsr	agdCreateScreen			; Get a segment of VRAM

	move.l	hVramNumScreens(a0),d1
	subq.l	#1,d1
	;bmi.s	.error
	move.l	d0,a0
	move.l	hAddress(a0),d6
	move.l	hSize(a0),d7
	
.a:	move.l	#tBitmapMask,d0
	bsr	agdCreateNewHandle
	tst.l	d0
	bmi	.error
	
	move.l	d0,hIndex(a0)				; Save handle for this type
	move.l	#tBitmapMask,hType(a0)			; Save type of resource
	move.l	d6,hAddress(a0)
	move.l	d7,hSize(a0)
	
	move.l	d6,a3
	move.l	#"BODY",(a3)+
	move.l	d7,(a3)+

	move.w	hBitmapWidth(a2),hBitmapMaskWidth(a0)
	move.w	hBitmapDepth(a2),hBitmapMaskDepth(a0)
	move.w	#1,hBitmapMaskPlanes(a0)
	move.w	#1,hBitmapMaskColours(a0)
	
	move.w	#0,hBitmapMaskModulo(a0)
	
	moveq	#0,d3
	move.w	hBitmapScanLength(a2),d3
	divu.w	hBitmapPlanes(a2),d3
	move.w	d3,hBitmapMaskScanLength(a0)	
	
	move.l	d6,hBitmapMaskBody(a0)
	;moveq	#0,d6
	;move.w	hBitmapMaskPlanes(a0),d6	

; lines in outer loop
; bitplanes on inner loop
	moveq	#0,d3

	moveq	#0,d5
	move.w	hBitmapMaskDepth(a2),d5			; Get number of lines
	subq.w	#1,d5
	
.depth:
	moveq	#0,d6
	move.w	hBitmapMaskWidth(a2),d6			
	lsr.w	#4,d6					; Number of words wide
	move.l	d6,d2
	subq.w	#1,d6
	
.line:
	move.l	hBitmapMaskBody(a0),a1			; Destination
	move.l	hBitmapBody(a2),a3			; Source
	addq.l	#8,a1
	addq.l	#8,a3
	add.l	d3,a3					; Index to word in source
	add.l	d3,a1					; Index to word in dest

; Index to line in source
	move.l	d5,d1			
	mulu	hBitmapScanLength(a2),d1		; Full Scan line length
	add.l	d1,a3					; Start at bottom in source
	
; Index to line in dest
	move.l	d5,d1			
	mulu	hBitmapScanLength(a0),d1		; Full Scan line length
	add.l	d1,a1					; Start at bottom in dest

	moveq	#0,d7					;Number of bitplanes
	move.w	hBitmapMaskPlanes(a2),d7
	subq.w	#1,d7
	
	move.w	(a3),d4	
.loop_get:
	add.l	d2,a3
	add.l	d2,a3
	or.w	(a3),d4
	dbf	d7,.loop_get
	
	move.w	d4,(a1)				; Set the mask word in dest
	addq.w	#2,d3				; Next word
	dbf	d6,.line
	
	moveq	#0,d3				; Reset back to first word
	dbf	d5,.depth

	move.l	a0,d0
	bra.s	.exit

.error:	moveq	#-1,d0

.exit:	movem.l	(a7)+,d1-d7/a0-a3
	rts
	


