maxMemorySegments:	equ	80		; Number of Allocs in the game
maxTypes:		equ	20		; Number of types

; Resource Types Here
tUnpackedAsset:		equ	0		; UNPPTR_= Unpacked Asset File handle
tRes:			equ	1		; MEMPTR = Memory Resource handle
tBitmap:		equ	2		; BTMPTR = Bitmap handle
tPalette:		equ	3		; PALPTR = Palette handle
tScreen:		equ	4		; SCRPTR = Screen Buffer
tTilesheet:		equ	5		; TLSPTR = Tile Sheet
tBitmapMask:		equ	6		; MSKPTR = Bitmap Mask
tSpriteSheet:		equ	7		; SPSPTR = Sprite Sheet
tTilemap:		equ	8		; TLMPTR = Tile Map
tPseudoScreen:		equ	9		; PSCPTR = Pseudo Screen 
tAttSpriteSheet:	equ	10		; ASSPTR = Attached Sprite Sheet 
tSoundSample:		equ	11		; SPLPTR = Sound Sample
tBobSprite:		equ	12		; BOBPTR = Game Bobs
tDbuffScreen:		equ	13		; DBSPTR = Pseudo Screen 
tVideoRam:		equ	14		; VRMPTR = Video Ram
tPackedAsset:		equ	15		; RNCPTR_= Packed Asset File handle
tLacedSpriteSheet:	equ	16		; LACPTR_= Interlaced Sprite Sheet Combo
tBlitQueue:		equ	17		; BLTPTR_= Blit

sizeStructRes:		equ	32		; Size of assets and resource handle
sizeStructBitmap:	equ	64		; Size of Bitmap handle
sizeStructPalette:	equ	256+16		; 16 for header + 128 for palette
sizeStructScreen:	equ	64		; Size of Screen structure
sizeStructTilesheet:	equ	24		; Size of tilesheet structure
sizeStructBitmapMask:	equ	32		; Size of Bitmap Mask handle
sizeStructSpriteSheet:	equ	32		; Size of Spritesheet handle
sizeStructTilemap:	equ	32	
sizeStructPseudoScreen:	equ	32		
sizeStructAttSpriteSheet:	equ	32	; Size of Attached Spritesheet handle
sizeStructSoundSample:	equ	32		; Size of Sound Sample struct
sizeStructBobSprite:	equ	400		; Size of Bob Sprite struct
sizeStructDbuffScreen:	equ	32
sizeStructVideoRam:	equ	64
sizeStructPackedAsset:	equ	32
sizeStructLacedSpriteSheet:	equ	32

; Maximum Handles for each type
maxResourceStructs:	equ	64		; Maximum number of structures
maxBitmapStructs:	equ	16		; Maximum bitmap structures
maxPaletteStructs:	equ	12		; Maximum bitmap structures
maxScreenStructs:	equ	16		; Maximum bitmap structures
maxTilesheetStructs:	equ	16		; Maximum bitmap structures
maxBitmapMaskStructs:	equ	16		; Maximum bitmap structures
maxSpriteSheetStructs:	equ	16		; Maximum bitmap structures
maxTilemapStructs:	equ	8		;
maxPseudoScreenStructs:	equ	16		;
maxAttSpriteSheetStructs:	equ	8		; Maximum bitmap structures
maxSoundSampleStructs:		equ	20
maxBobSpriteStructs:		equ	24	; Onscreen Bob Sprites.
maxDbuffScreenStructs:	equ	16
maxVideoRamStructs:	equ	2
maxPackedAssetStructs:	equ	20
maxLacedSpriteSheetStructs:	equ	8

; Global structure offsets
hAddress:		equ	0		; Address of resource or asset in RAM
hSize:			equ	4		; Length of resource or asset in RAM
hType:			equ	8		; Resource type (see above)	
hIndex:			equ	12		; Index of handle	

; Bitmap structure offsets
hBitmapWidth:		equ	16		; Word for Width in pixels
hBitmapDepth:		equ	18		; Word for Depth in pixels
hBitmapPlanes:		equ	20		; Word for Bitplanes
hBitmapColours:		equ	22		; Word number of colours in image
hBitmapModulo:		equ	24		; Word for plane modulo
hBitmapScanLength:	equ	26		; Word total length of a scan line
hBitmapBody:		equ	28		; LongWord Body Pointer

; Palette structure offsets
hPalette:		equ	16		; Start of palette words

; Screen structure offsets
hScreenWidth:		equ	16		; Word for Width in pixels
hScreenDepth:		equ	18		; Word for Depth in pixels
hScreenPlanes:		equ	20		; Word for Bitplanes
hScreenColours:		equ	22		; Word number of colours in image
hScreenModulo:		equ	24		; Word for plane modulo
hScreenScanline:	equ	26		; Word total length of a scan line
hScreenOffset:		equ	28		; Offset to start of screen origin.
hScreenHScroll:		equ	30		; HPOS Scroll
hScreenPalette:		equ	32		; Palette struct for screen
hScreenPointers:	equ	36		; Screen pointers * 8

; Tilesheet structure offsets
hTilesheetRowModulo:	equ	16		; Amount of bytes between each row
hTilesheetTileWidth:	equ	18		; Block size width x16		1=16 pixels
hTilesheetBlitSize:	equ	20		; Tilesheet depth
hTilesheetBlitModulo:	equ	22		; Blitter modulo
hTilesheetPlanes:	equ	24		; Tilesheet bitplanes
hTilesheetTilesPerRow:	equ	26		; Number of tiles per row.
hTilesheetBitmapAddress	equ	28		; Address of Tile Bitmap


; Tilemap structure
hTilemapWidth:		equ	16		; Width of the tilemap
hTilemapDepth:		equ	18		; Depth of the tilemap
hTilemapBits:		equ	20		; Number of bits per tile
hTilemapTilesheet:	equ	22		; Tilesheet Address
hTilemapXPos:		equ	26		; Current Xposition
hTilemapYPos:		equ	28		; Current Yposition

; Bitmap Mask structure
hBitmapMaskWidth:	equ	16		; Word for Width in pixels
hBitmapMaskDepth:	equ	18		; Word for Depth in pixels
hBitmapMaskPlanes:	equ	20		; Word for Bitplanes
hBitmapMaskColours:	equ	22		; Word number of colours in image
hBitmapMaskModulo:	equ	24		; Word for plane modulo
hBitmapMaskScanLength:	equ	26		; Word total length of a scan line
hBitmapMaskBody:	equ	28		; LongWord Body Pointer

; Sprite sheet structure
hSpriteSheetBitmap:	equ	16		; Bitmap pointer 
hSpriteSheetCols:	equ	20		; Number of sprites in columns
hSpriteSheetRows:	equ	22		; Number of sprites in rows
hSpriteSheetAmount:	equ	24		; Amount of sprites in sheet
hSpriteSizeWidth:	equ	26		; Bytes width
hSpriteSizeDepth:	equ	28		; Lines depth

;Pseudo screen structure
hPseudoScreenPost:	equ	16		; Pristine Screen
hPseudoScreen1:		equ	20		; First Screen
hPseudoScreen2:		equ	24		; Second Screen
hPseudoXPos:		equ	28		; XPosition
hPseudoYPos:		equ	30		; XOffset

; Attached Sprite sheet structure
hAttSpriteSheetPlane12:	equ	16		; Planes 1 & 2 pointer 
hAttSpriteSheetPlane34:	equ	20		; Planes 3 & 4 pointer
hAttSpriteSheetXSize:	equ	24		; X Size in Pixels
hAttSpriteSheetYSize:	equ	28		; Y Size in Pixels		

; Interlaced Sprite sheet combo
hLacedOddSpriteSheet:	equ	16		; 
hLacedEvenSpriteSheet:	equ	20

hSoundSampleBody:	equ	16
hSoundSampleLen:	equ	20
hSoundSamplePeriod:	equ	22

; Bob Sprites that are onscreen
hBobSpriteSheet:	equ	16
hBobSpriteNumber:	equ	20		; Sprite Number allocated
hBobSpriteXpos:		equ	24		; Xposition
hBobSpriteYpos:		equ	28		; Yposition
hBobSpriteXsize:	equ	32
hBobSpriteYsize:	equ	36
hBobSpriteModSize:	equ	40
hBobSpriteBlitSize:	equ	42
hBobSpriteThisOffset:	equ	44		; Screen offset for this frame
hBobSpriteLastOffset:	equ	48		; Screen offset for last frame
hBobSpriteCurrentFrame:	equ	52		; Current Animation Frame
hBobSpriteDelayFrames:	equ	58		; Frames between each animation
hBobSpriteHandler:	equ	62
hBobSpriteMoveX:	equ	66
hBobSpriteMoveY:	equ	68
hBobSpriteState:	equ	72
hBobSpriteLastModSize:	equ	76
hBobSpriteLastBlitSize:	equ	78
hBobSpriteCookie:	equ	80
hBobSpriteGridXPos:	equ	84
hBobSpriteGridYPos:	equ	88
hBobSpriteTimer:	equ	92
hBobSpriteTerrainPtr:	equ	96
hBobSpriteIndex:	equ	100
hBobSpriteBobNumber:	equ	104
hBobSpriteBitmapLevel:	equ	108
hBobSpriteTrackLevel:	equ	110
hBobSpriteCarNumber:	equ	112		.long
hBobSpriteArg0:		equ	116
hBobSpriteArg1:		equ	120
hBobSpriteSampleReplay:	equ	124



hBobSpriteBitmapLevel0:	equ	136
hBobSpriteBitmapLevel1:	equ	138
hBobSpriteTrackRestore1	equ	140
hBobSpriteTrackRestore2	equ	144
hBobSpriteTrackRestore3	equ	148
hBobSpriteTrackRestore4	equ	152
hBobSpriteTrackRestore5	equ	156
hBobSpriteTrackRestore6	equ	160
hBobSpriteTrackRestore7	equ	164
hBobSpriteTrackRestore8	equ	168
hBobSpriteTrackRestore9	equ	172
hBobSpriteTrackRestore10	equ	176
hBobSpriteTrackRestore11	equ	180
hBobSpriteTrackRestore12	equ	184

hBobSpriteGuidesPtr:	equ	200
hBobSpriteAnimFrames:	equ	212 ;		32 max number of frames 

;Dbuff screen structure
hDbuffScreenPost:	equ	16		; Pristine Screen
hDbuffScreen1:		equ	20		; First Screen
hDbuffScreen2:		equ	24		; Second Screen
hDbuffXPos:		equ	28		; XPosition
hDbuffYPos:		equ	30		; XOffset

hVramNumScreens:	equ	16		; Number of allocated screen
hVramRemainingRam:	equ	20		; Remaining Bytes of VRAM
hVramScreens:		equ	24		; Pointers to Allocated Screens

hPackedAssetUnpackSize:	equ	16		; Unpacked size of asset
hPackedAssetUnpackCRC:	equ	20		; CRC of Unpacked file
hPackedAssetUnpackKey:	equ	24		; Pack Key

; Blit on screen
hBlitQueueStatus:	equ	16		; Last.
hBlitQueueType:		equ	18		; Cookie, Copy or Clear
hBlitQueueCon0:		equ	20
hBlitQueueCon1:		equ	22
hBlitQueueAFWM:		equ	24
hBlitQueueALWM:		equ	26
hBlitQueueCPTH:		equ	30
hBlitQueueBPTH:		equ	34
hBlitQueueAPTH:		equ	38
hBlitQueueDPTH:		equ	42
hBlitQueueCMOD:		equ	44
hBlitQueueBMOD:		equ	46
hBlitQueueAMOD:		equ	48
hBlitQueueDMOD:		equ	50	
