intVectorLevel1:	equ	$64
intVectorLevel2:	equ	$68
intVectorLevel3:	equ	$6c
intVectorLevel4:	equ	$70
intVectorLevel5:	equ	$74
intVectorLevel6:	equ	$78
intVectorLevel7:	equ	$7c


InstallScreenInterrupt:
	tst.w	INT3_INSTALLED(a6)
	bmi	.exit
	move.w	#-1,INT3_INSTALLED(a6)
	
	move.l	a6,-(a7)
	move.l	a5,-(a7)

; Get the VB Base
	lea	getvbr(pc),a5 
	move.l	ExecBase,a6
	jsr	_LVOSupervisor(a6)			; returns vbr in d0 
	lea	vbroffset,a0 
	move.l	d0,(a0)			
	move.l	d0,a0					; VB Base in a0
 
	lea 	Level3IntHandler(pc),a1 
	move.l	intVectorLevel3(a0),saveLevel3
	move.l	a1,intVectorLevel3(a0)

	move.l	(a7)+,a5
	move.l	(a7)+,a6
.exit	rts 

InstallKeyboardInterrupt
	tst.w	INT2_INSTALLED(a6)
	bmi	.exit
	move.w	#-1,INT2_INSTALLED(a6)
	
	move.l	a6,-(a7)
	move.l	a5,-(a7)

; Get the VB Base
	lea	getvbr(pc),a5 
	move.l	ExecBase,a6
	jsr	_LVOSupervisor(a6)			; returns vbr in d0 
	lea	vbroffset,a0 
	move.l	d0,(a0)			
	move.l	d0,a0					; VB Base in a0
 
	lea 	Level2IntHandler(pc),a1 
	move.l	intVectorLevel2(a0),saveLevel2
	move.l	a1,intVectorLevel2(a0)
	
	lea 	CIAA,a1	
	move.b	#CIAICRF_SETCLR!CIAICRF_SP,ciaicr(a1); Interrupt control register 
;clear all ciaa-interrupts
	tst.b	ciaicr(a1)
;set input mode
	and.b	#~(CIACRAF_SPMODE),ciacra(a1)		; 

	move.l	(a7)+,a5
	move.l	(a7)+,a6
.exit	rts 


RemoveScreenInterrupt:
	tst.w	INT3_INSTALLED(a6)
	beq	.exit
	clr.w	INT3_INSTALLED(a6)

	move.l	a6,-(a7)
	move.l	a5,-(a7)
;--- get the vbr which is most probably somewhere in fast-ram 
	lea	getvbr(pc),a5 
	move.l	ExecBase,a6
	jsr	_LVOSupervisor(a6)			; returns vbr in d0 
	move.l	d0,a0

;--- register our own level 3 interrupt (vertical blanc and blitter) 
	move.l	saveLevel3,intVectorLevel3(a0)
	move.l	(a7)+,a5
	move.l	(a7)+,a6
.exit:	rts

RemoveKeyboardInterrupt:
	tst.w	INT2_INSTALLED(a6)
	beq	.exit
	clr.w	INT2_INSTALLED(a6)

	move.l	a6,-(a7)
	move.l	a5,-(a7)
;--- get the vbr which is most probably somewhere in fast-ram 
	lea	getvbr(pc),a5 
	move.l	ExecBase,a6
	jsr	_LVOSupervisor(a6)			; returns vbr in d0 
	move.l	d0,a0

;--- register our own level 3 interrupt (vertical blanc and blitter) 
	move.l	saveLevel2,intVectorLevel2(a0)
	move.l	(a7)+,a5
	move.l	(a7)+,a6
.exit:	rts



;--- get the vector base register 
getvbr:	movec	vbr,d0 
	rte 
	
	cnop	0,4

; Blitter, Copper and Vertical Blanking Interupt Routine
Level3IntHandler: 
	movem.l	d0-d7/a0-a6,-(a7)
	lea	CHIPBASE,a5
	lea	DATA_MID,a6
	move.w	INTREQR(a5),d0			
	btst	#INTB_BLIT,d0			
	bne.s	.blitter
	btst	#INTB_VERTB,d0			
	bne.s	.vertb 
	btst	#INTB_COPER,d0			
	bne	.copper 
	bra	.exit 

.blitter:
	move.w	#(INTF_INTEN!INTF_BLIT),INTREQ(a5)   		
	move.w	#(INTF_INTEN!INTF_BLIT),INTREQ(a5)   		
	bra	.exit

.vertb:	
	move.w	#-1,VBL_BUSY(a6)
	bsr	.scene_interlacer

	bsr	agdReadInputs
	move.w	#(INTF_INTEN!INTF_VERTB),INTREQ(a5)   		
	move.w	#(INTF_INTEN!INTF_VERTB),INTREQ(a5)   
	clr.w	VBL_BUSY(a6)
	bra	.exit 

.copper:

	
	move.w	CLXDAT(a5),d0
	and.w	#%0111111000000000,d0
	rol.w	#7,d0
	move.w	d0,CLXDAT_STATE(a6)
	move.w	#(INTF_INTEN!INTF_COPER),INTREQ(a5)   		
	move.w	#(INTF_INTEN!INTF_COPER),INTREQ(a5)   		
	bra	.exit
	
.scene_interlacer:
	moveq	#0,d1
	move.w	VPOSR(a5),d1
	rol.w	#1,d1
	not.w	d1
	and.w	#1,d1
	lea	INTERLACE_TABLE(pc),a1	
	moveq	#0,d5	
	
	moveq	#0,d0
	move.w	CURRENT_SCENE(a6),d0
	bmi.s	.lace_end				; -1 if loader
	beq.s	.lace_dual_playfield			; 0 if dual playfield
	bra.s	.lace_single_playfield			
	
.lace_dual_playfield:
	move.l	0(a1,d0*4),a0
	tst.w	d1
	beq.s	.dpf
	move.l	4(a1,d0*4),d5
.dpf:	moveq	#0,d0
	moveq	#0,d1
	bsr	ssUpdateDualPlayfield

	bsr	ssAnimateCars
	
	bsr	ssRaceHandleCars
	
; Cast any game sprites that are ready on this frame.
	bra.s	.lace_end
	
.lace_single_playfield:
	move.l	0(a1,d0*8),a0				; Screen 
	move.l	(a0),a0
	tst.w	d1
	beq.s	.spf
	move.l	4(a1,d0*8),d5				; Interlace
.spf:		
	bsr	ssUpdateSinglePlayfield

	;cmp.w	#sceneWinningCars,CURRENT_SCENE(a6)
	;beq	ssWinningCarsUpdate

.lace_end:	rts
	
	
.exit: movem.l	(a7)+,d0-d7/a0-a6
	nop 
	rte 
	
	
	
; Keyboard handler routine.	
Level2IntHandler:	
	movem.l	d0-d7/a0-a6,-(a7)

	lea	CHIPBASE,a5
	move.w	INTREQR(a5),d0
	btst	#INTB_PORTS,d0
	beq	.end
	
; Ports generated
	lea	CIAA,a1
	btst	#CIAICRB_SP,ciaicr(a1)
	beq	.end

;read key and store him
	moveq	#0,d0
	move.b	ciasdr(a1),d0			; Serial Shift Data Register, Keycode is dumped into here
						; and then an IRQ2 generated.
	or.b	#CIACRAF_SPMODE,ciacra(a1)
	not.b	d0
	ror.b	#1,d0
	spl	d1
	and.b	#$7f,d0
	
	lea	KEYARRAY,a2
	move.b	d1,(a2,d0.w)			; Set key code into the array

;Wait 3 lines for handshake.
	moveq	#3-1,d1
.wait1	move.b	VHPOSR(a5),d0
.wait2	cmp.b	VHPOSR(a5),d0
	beq.s	.wait2
	dbf	d1,.wait1 

;set input mode
	and.b	#~(CIACRAF_SPMODE),ciacra(a1)

.end	move.w	#INTF_PORTS,INTREQ(a5)
	tst.w	INTREQR(a5)
	movem.l	(a7)+,d0-d7/a0-a6
	rte



;a0 = Screen Handle
;d0 = xpos
;d1 = ypos
ssUpdateSinglePlayfield:
	move.w	hScreenPlanes(a0),d7			; d7 = Number of planes
	subq.w	#1,d7	
	lea	hScreenPointers(a0),a0
	move.l	#BPL0PTH<<16,d3
	move.l	COPPTR_BPL0PTH(a6),a1
.fg:	move.l	(a0)+,d1
	add.l	d5,d1
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3	
	dbf	d7,.fg	
	rts
		

;a0 = Screen Handle
;d0 = xpos
;d3 = ypos d5
ssUpdateDualPlayfield:
	movem.l	d0-d7/a0-a1,-(a7)
	move.l	COPPTR_BPL0PTH(a6),a1
	moveq	#4-1,d7
	
	move.l	DBSPTR_LOWER_TRACK(a6),a0
	moveq	#0,d4
	move.w	VPOSR(a5),d4
	rol.w	#1,d4
	not.w	d4
	and.w	#1,d4
	
	move.l	hDbuffScreen1(a0,d4*4),a0
	
	lea	hScreenPointers(a0),a0
	move.l	#BPL0PTH<<16,d3
.bplow:	move.l	(a0)+,d1
	add.l	d5,d1
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	add.l	#$40000,d3
	dbf	d7,.bplow	
	
	move.l	COPPTR_BPL1PTH(a6),a1
	moveq	#4-1,d7
	move.l	DBSPTR_UPPER_TRACK(a6),a0
	moveq	#0,d4
	move.w	VPOSR(a5),d4
	rol.w	#1,d4
	not.w	d4
	and.w	#1,d4
	
	move.l	hDbuffScreen1(a0,d4*4),a0
	
	lea	hScreenPointers(a0),a0
	move.l	#BPL1PTH<<16,d3
.bpupp:	move.l	(a0)+,d1

	IFNE	DEBUG_COLLISION_MAP
	move.l	SCRPTR_LOWER_TRACK_MASK(a6),a0
	move.l	hAddress(a0),d1
	moveq	#0,d5

	IFNE	DEBUG_COLLISION_UPPER_MAP
	move.l	SCRPTR_UPPER_TRACK_MASK(a6),a0
	move.l	hAddress(a0),d1
	moveq	#0,d5
	ENDC
	ENDC

	add.l	d5,d1
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	swap	d1
	move.w	d1,d3
	move.l	d3,(a1)+
	add.l	#$2<<16,d3
	add.l	#$40000,d3
	dbf	d7,.bpupp
	
	movem.l	(a7)+,d0-d7/a0-a1
	rts
	
INTERLACE_TABLE:	dc.l	0,DualPlayfieldInterlaceOffset				; 0
			dc.l	SCRPTR_TITLE_SCREEN,TitleScreenInterlaceOffset		; 1
			dc.l	SCRPTR_HISCORE_SCREEN,HiScoresInterlaceOffset		; 2
			dc.l	SCRPTR_TRACK_SELECT,TrackSelectInterlaceOffset		; 3
			dc.l	SCRPTR_UPGRADE_CAR,UpgradeCarInterlaceOffset		; 4
			dc.l	SCRPTR_WINNING_CARS,WinningCarsInterlaceOffset		; 5
			dc.l	SCRPTR_PREPARE_RACE,PrepareRaceInterlaceOffset		; 6
			dc.l	SCRPTR_CREDITS_SCREEN,CreditsInterlaceOffset		; 7
			
	CNOP	0,4

	data
	
level2InterruptStruct: 
	dc.l	0,0	; LN_SUCC, LN_PRED
	dc.b	0,0	; LN_TYPE, LN_PRI
	dc.l	0	; LN_NAME
	dc.l	0,0	; IS_DATA, IS_CODE
	
	cnop 	0,4
	
level2InterruptName	dc.b "Keyboard Handler",0
	cnop 0,4
	
level2InterruptDataSeg:	dc.l	0

	code




	
	