ssTitleDelayTime:	equ	60*8

OPT_DESELECTED:		equ	%1010		; 10
OPT_SELECTED:		equ	%1100		; 12
OPT_CLEAR:		equ	0

ssTitleInitialise:
	lea	RNC_TITLE_SCREEN,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_TITLE_SCREEN(a6)
	rts
	
ssTitleInitHandles:
; Destroy all Vram chunks
	move.l	VRMPTR_SCREENS(a6),a0	
	bsr	agdDestroyAllVramScreens
	move.l	UNPPTR_TITLE_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_TITLE_SCREEN(a6)
	move.l	BMPPTR_TITLE_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_TITLE_SCREEN(a6)
	move.l	PALPTR_TITLE_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	PALPTR_TITLE_SCREEN(a6)
	move.l	SCRPTR_TITLE_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	SCRPTR_TITLE_SCREEN(a6)
	rts
	
ssTitleCreateHandles:
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_TITLE_SCREEN(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_TITLE_SCREEN(a6)
	
; Create a Bitmap Handle and work out dimensions
	move.l	UNPPTR_TITLE_SCREEN(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_TITLE_SCREEN(a6)	
	
; Get the palette of the Bitmap
	move.l	UNPPTR_TITLE_SCREEN(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdGetBitmapPalette			;
	move.l	d0,PALPTR_TITLE_SCREEN(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	BMPPTR_TITLE_SCREEN(a6),a1
	bsr	agdCreateScreenFromBitmap
	move.l	d0,SCRPTR_TITLE_SCREEN(a6)
	move.l	d0,a0
	move.l	PALPTR_TITLE_SCREEN(a6),hScreenPalette(a0)	; Assign palette to screen
.exit:	
	rts
	
ssTitleCrash:	bra.s	ssTitleCrash
	
ssTitle:
	move.w	#sceneTitle,CURRENT_SCENE(a6)
	move.w	#ssTitleDelayTime,SCENE_DELAY_TIME(a6)
	clr.l	FRAME_COUNT(a6)
	
	bsr	ssTitleInitHandles
	bsr	ssTitleCreateHandles
	tst.l	d0
	bmi.s	ssTitleCrash
	
; Create a copper resource
	move.l	SCRPTR_TITLE_SCREEN(a6),a0
	move.l	COPPTR_COPPER_1(a6),a1
	bsr	ssUniCopper
	
	lea	$dff000,a5	
	IFEQ	ENABLE_DEBUG
	INIT_DMA_INT
	START_COPPER
	SET_PARALLEL_PORT
	move.w	#(DMAF_SETCLR!DMAF_MASTER!DMAF_RASTER!DMAF_COPPER!DMAF_SPRITE),DMACON(a5)
	move.w	#(INTF_SETCLR!INTF_EXTER!INTF_INTEN!INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)
	ENDC
	
	IFEQ	ENABLE_DEBUG
	moveq	#0,d0
	bsr	_mt_musicmask
	
	moveq	#64,d0
	bsr	agdSetVolume
	
	move.b	#-1,_mt_Enable
	
	moveq	#SONG_COIN,d0
	move.l	UNPPTR_MODS2(a6),a0
	bsr	agdPlayModule
	
	ENDC
	
; Copy a bitmap to a screen
	move.l	BMPPTR_TITLE_SCREEN(a6),d0
	move.l	SCRPTR_TITLE_SCREEN(a6),d1
	bsr	agdTransitionBitmapToScreen
	
	bsr	ssPlotMenuItem
	
	clr.l	FRAME_COUNT(a6)

	bsr	ssSetAllDrones			; All cars to drones.
	
	IFNE	ENABLE_PROTECTION
	moveq	#-1,d3
	moveq	#1,d3
	move.l	#(46-8)*8,d0
	move.l	#(45*8),d1	
	lea	DEMO_TEXT1(a6),a1
	bsr	agdSmallFont
	ENDC
	
	move.l	#(46-8)*8,d0
	move.l	#(47*8),d1	
	lea	DEMO_TEXT2(a6),a1
	bsr	agdSmallFont

	move.w	#60*3,COIN_TIMER(a6)
	
.frame:	
	bsr	WaitVbl
	IFNE	DEBUG_COLOURS
	move.w	#$770,$dff180
	ENDC
		
	IFNE	NO_INPUT_INTERUPTS
	bsr	agdReadInputs
	ENDC
	
	bsr	ssTitleTextColourCycle
	bsr	ssTitleMenuHandler

	tst.w	COIN_TIMER(a6)
	bne.s	.coin
	bsr	agdStopModule	
	
.coin:	subq.w	#1,COIN_TIMER(a6)
	
; Debugging stuff here.
	IFNE	DEBUGGING_OSD
	bsr	agdDebugWindow
	ENDC
	
	tst.w	MENU_ACTIVE(a6)
	bne.s	.frame
	
	subq.w	#1,SCENE_DELAY_TIME(a6)
	bmi.s	.timeout
	
	tst.w	START_GAME(a6)
	bmi	.start
	tst.w	END_GAME(a6)
	bmi	.end
	
	bra	.frame
	
.start:	bsr	ssGetFirstPlayerCar
	tst.w	d0
	bmi.s	.frame
	and.l	#$ffff,d0
	
	move.l	d0,GAME_FIRST_PLAYER(a6)
	moveq	#0,d1
	move.w	d0,d1
	GET_CAR_CONTEXT
	clr.w	carIsDrone(a4)				; This car no longer a drone.
	move.w	#-1,carIsDroneLast(a4)
	move.w	#-1,START_GAME(a6)


.end:
.timeout:
	move.l	SCRPTR_TITLE_SCREEN(a6),d0
	bsr	agdTransitionBitmapFromScreen
	move.w	#sceneLoad,CURRENT_SCENE(a6)
	
; Kill VBL
	IFEQ	ENABLE_DEBUG
		END_SCENE
	ENDC
	
	bsr	ssTitleInitHandles
	
.error:	rts

;d0 = Colour reg 0-3
;d1 = Car select colour
	near	a6
	
ssTitleTextColourCycle:
	moveq	#4,d1
	lea	.tab(pc),a0
	move.l	(a0,d1*4),a0
	move.l	COPPTR_TITLE_TEXT1(a6),a1
	moveq	#0,d0
.reset:	move.w	.pos(a6),d0
	tst.w	2(a0,d0*2)
	bpl.s	.ok
	clr.w	.pos
	bra.s	.reset
	
.ok:	move.w	(a0,d0*2),6(a1)
	
	
	moveq	#0,d1
	move.w	SELECTED_CAR(a6),d1
	lea	.tab(pc),a0
	move.l	(a0,d1*4),a0
	move.w	(a0,d0*2),14(a1)	
	add.l	#$6000,.pos(a6)
.exit:	rts

.tab:	dc.l	.blue,.red,.yell,.green,.grey
.grey:	dc.w	$bbb,$aaa,$999,$888,$777,$666,$555,$444,$333,$444,$555,$666,$777,$888,$999,$aaa,-1

.red:	dc.w	$f52,$e52,$d52,$c52,$b41,$a41,$941,$841,$730,$630,$530,$430,$320,$430,$530,$630,$730,$841,$941,$a41,$b41,$c52,$d52,$e52,$f52,-1
	even
.blue:	dc.w	$88f,$88e,$77d,$77c,$66b,$66a,$559,$558,$447,$446,$335,$334,$223,$334,$335,$446,$447,$558,$559,$66a,$66b,$77c,$77d,$88e,$88f,-1
	even
.green:	dc.w	$0f0,$0e0,$0d0,$0c0,$0b0,$0a0,$090,$080,$700,$060,$050,$040,$030,$040,$050,$060,$070,$080,$090,$0a0,$0b0,$0c0,$0d0,$0e0,$0f0,-1
	even
.yell:	dc.w	$ff2,$ee2,$dd2,$cc2,$bb2,$aa2,$992,$882,$772,$662,$552,$442,$332,$442,$552,$662,$772,$882,$982,$aa2,$bb2,$cc2,$dd2,$ee2,$ff2,-1
	even

	data
.pos:	dc.l	0
	
	code
	

MENU_PRINT:	equ	-1
MENU_SELECT:	equ	0

DEFAULT_MENU_TOP:	equ	0
DEFAULT_SELECT_CAR:	equ	0

TYPE_OPTIONS:		equ	0
TYPE_SELECT:		equ	-1

	even
	dc.b	"This section of menu handling code is crap and "
	dc.b	"needs to be re-written.  Do not under any circumstances "
	dc.b	"attempt to debug this code as it will give you "
	dc.b	"full uncontrollable rage. "
	dc.b	"--- MENU CODE STARTS HERE ---",0
	even
	
	
ssTitleMenuHandler: 
	moveq	#maxCars-1,d7
	
	lea	menu_table(pc),a3
	moveq	#0,d0
	move.l	(a3,d0*4),a3
	move.l	4(a3),DEBUG_OPT1
	move.l	8(a3),DEBUG_OPT2
	
.loop:	move.l	d7,d1
	GET_CAR_CONTEXT
	tst.w	carFrameDirection(a4)
	bne.s	.input
	tst.w	carFrameButton(a4)
	bne.s	.input
	dbf	d7,.loop
	bra	.exit
	
.input:

	
	cmp.w	#TURN_LEFT,carFrameDirection(a4)	; Needs to be selected car
	beq	.right					; who fired first!
	cmp.w	#TURN_RIGHT,carFrameDirection(a4)
	beq	.left
	tst.w	carFrameButton(a4)
	bne	.select
	bra	.exit
	
.select:	
	moveq	#sampleCountdown,d0
	bsr	agdPlaySample
	
	cmp.w	#0,MENU_ACTIVE(a6)
	bne.s	.1
	
; On first menu so either, Start, Controls or credits.
	lea	menu_table(pc),a3
	moveq	#0,d0
	move.l	(a3,d0*4),a3
	
	cmp.l	#0,4(a3)		; position 0 = START
	beq.s	.start_game
	cmp.l	#1,4(a3)
	beq.s	.1
	cmp.l	#2,4(a3)
	beq.s	.end_game
	bra	.exit
	
.start_game:
	move.w	#-1,START_GAME(a6)	
	clr.w	END_GAME(a6)
	;moveq	#sampleRevs,d0
	;bsr	agdPlaySample
	bra	.exit

.end_game:
	move.w	#-1,END_GAME(a6)
	clr.w	START_GAME(a6)
	bra	.exit	
	
.1:	cmp.w	#1,MENU_ACTIVE(a6)
	bne	.hhh
	
; Menu active has to be 1

; car select
	lea	menu_table(pc),a3
	moveq	#1,d0
	move.l	(a3,d0*4),a3
	cmp.l	#4,4(a3)		; Exit?
	bne	.hhh

; Exit selected..
	move.l	#0,4(a3)
	
	move.l	SCRPTR_TITLE_SCREEN(a6),a0
	lea	txt_car_blank(pc),a1
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	moveq	#-1,d3
	move.w	#OPT_DESELECTED,d3	
	bsr	agdSmallFont	

	subq.w	#1,MENU_ACTIVE(a6)
	cmp.w	#0,MENU_ACTIVE(a6)
	beq	.plot
; Menu active now 0.	
	
.hhh:	cmp.w	#2,MENU_ACTIVE(a6)			; Set car mapping
	beq	.set_car_mapping
	addq.w	#1,MENU_ACTIVE(a6)
	bra	.plot
	

; If exit then go back 1
; If not then set control then exit.
.set_car_mapping:
	lea	menu_table(pc),a3
	moveq	#1,d0
	move.l	(a3,d0*4),a3
	move.l	4(a3),d4		; selected car
	
	lea	menu_table(pc),a3
	moveq	#2,d0
	move.l	(a3,d0*4),a3
	move.l	4(a3),d5		; selected interface mapping
	
	lea	DEFAULT_INTERFACE_MAP(a6),a3
	move.l	d5,(a3,d4*4)
	
	subq.w	#1,MENU_ACTIVE(a6)	
	cmp.w	#1,MENU_ACTIVE(a6)			; Set inputs if back to car select
	bne	ssPlotMenuItem
; Came out of menu so set all controls.
	bsr	ssTitleSetInputs
	bra	ssPlotMenuItem
		
	
.left:	moveq	#0,d0
	move.w	MENU_ACTIVE(a6),d0
	lea	menu_table(pc),a3
	move.l	(a3,d0*4),a3			; menu_top in a3
	cmp.l	#0,4(a3)			; At left?
	beq.s	.exit
	subq.l	#1,4(a3)			; subtract
	
	moveq	#sampleCountdown,d0
	bsr	agdPlaySample
	
	bra.s	.plot

.right:	moveq	#0,d0
	move.w	MENU_ACTIVE(a6),d0
	lea	menu_table(pc),a3
	move.l	(a3,d0*4),a3			; menu_top in a3
	move.l	4(a3),d0			; position in d0
	addq.w	#1,d0
	tst.l	8(a3,d0*4)			; is position (-1)?
	bmi.s	.exit
	addq.l	#1,4(a3)
	
	moveq	#sampleCountdown,d0
	bsr	agdPlaySample
	
.plot:	bsr	ssPlotMenuItem
.exit:	rts


; display a menu item
; a3=menu ptr
ssPlotMenuItem:
	move.w	#ssTitleDelayTime,SCENE_DELAY_TIME(a6)
; Always plot the top menu item
	moveq	#0,d0
	move.w	MENU_ACTIVE(a6),d0
	lea	menu_table(pc),a3
	move.l	(a3,d0*4),a3
	bsr	text_plotter
	
; Plot the car colour
	cmp.w	#1,MENU_ACTIVE(a6)		; Cars shown?
	beq	.show_car_mapping
	
	move.w	MENU_ACTIVE(a6),d7

	bra	.exit
	
.show_car_mapping:
; Get current car shown
	lea	menu_table(pc),a3
	moveq	#1,d0
	move.l	(a3,d0*4),a3	
	move.l	4(a3),d5		; Current Car
	
	move.w	d5,SELECTED_CAR(a6)
	
	cmp.l	#4,d5			; Exit?
	bne	.x
; blank car mapping because exit shown
	move.l	SCRPTR_TITLE_SCREEN(a6),a0
	lea	txt_iface_blank(pc),a1
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	moveq	#-1,d3
	move.w	#OPT_DESELECTED,d3
	cmp.w	#1,MENU_ACTIVE(a6)		; Cars shown?
	bne	.1
	move.w	#OPT_SELECTED,d3
.1:	bsr	agdSmallFont
	bra	.exit

.x:
	lea	DEFAULT_INTERFACE_MAP(a6),a3
	move.l	(a3,d5*4),d5
	
; Show current car to interface mapping.
	lea	menu_table(pc),a3
	moveq	#2,d0
	move.l	(a3,d0*4),a3

	moveq	#-1,d3
	move.w	#OPT_CLEAR,d3
	move.l	d5,4(a3)		; Set current mapping
	bsr	text_plotter	
.exit:	rts
	

	
text_plotter:
	move.l	a3,-(a7)
	cmp.l	#TYPE_OPTIONS,(a3)
	beq.s	.menu
	cmp.l	#TYPE_SELECT,(a3)
	beq.s	.sel
	bra	.exit
	
.menu:	addq.l	#4,a3
	moveq	#0,d6
	move.l	(a3)+,d7			; Get highlight position
.m:	move.l	SCRPTR_TITLE_SCREEN(a6),a0	
	move.l	(a3)+,a1			; Get item to display
	cmp.l	#-1,a1				; Last one?
	beq	.exit
	
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	moveq	#-1,d3
	move.w	#OPT_DESELECTED,d3					; Colour 1 is car colour.
	cmp.w	d6,d7
	bne.s	.m1
	move.w	#OPT_SELECTED,d3
.m1:	
	bsr	agdSmallFont
	addq.w	#1,d6
	bra.s	.m

; Select code.
.sel:	addq.l	#4,a3
	move.l	(a3)+,d7
	
.s:	move.l	SCRPTR_TITLE_SCREEN(a6),a0	
	move.l	(a3,d7*4),a1
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	moveq	#-1,d3
	move.w	#OPT_DESELECTED,d3
	cmp.w	#2,MENU_ACTIVE(a6)
	bne.s	.h
	move.w	#OPT_SELECTED,d3
.h:	bsr	agdSmallFont
	bra	.exit
	
.exit:	
	move.l	(a7)+,a3
	rts
	
ssTitleSetInputs:
	movem.l	d0-d1/a0-a2,-(a7)
	lea	DEFAULT_INTERFACE_MAP(a6),a0
	lea	IFACE_INPUTS(a6),a1
	lea	INPUTS_TAB(a6),a2
	moveq	#3,d1
.loop:	move.l	(a0)+,d0
	move.l	(a1,d0*8),(a2)+		; Set direction
	move.l	4(a1,d0*8),(a2)+	; Set button.
	dbf	d1,.loop
	movem.l	(a7)+,d0-d1/a0-a2
.exit:	rts

menu_table:	dc.l	menu_top
		dc.l	select_car
		dc.l	iface
		
menu_top:	
	dc.l	TYPE_OPTIONS,DEFAULT_MENU_TOP			; << This long word gets updated for highlight position
	dc.l	txt_start,txt_controls,txt_credits,-1

select_car:	
	dc.l	TYPE_SELECT,DEFAULT_SELECT_CAR			; << This long word gets updated for select position
	dc.l	txt_car_blue,txt_car_red,txt_car_yellow,txt_car_green,txt_car_back,-1


iface:	dc.l	TYPE_SELECT,0					; << This long word gets updated for select position
	dc.l	txt_iface0,txt_iface1,txt_iface2,txt_iface3
	dc.l	txt_iface4,txt_iface5,txt_iface6,txt_iface7
	dc.l	-1
	
iface_blank:	
	dc.l	TYPE_SELECT,0					; select position
	dc.l	txt_iface_blank
	dc.l	-1

txt_start:
	dc.w	39*8,38*8
	dc.b	"START",0
	even
	
txt_controls:
	dc.w	46*8,38*8
	dc.b	"CONTROLS",0
	even
	
txt_credits:
	dc.w	56*8,38*8
	dc.b	"EXIT    ",0
	even
	
txt_car_blue:
	dc.w	47*8,40*8
	dc.b	"BLUE CAR  ",0
	even

txt_car_red:
	dc.w	47*8,40*8
	dc.b	"RED CAR   ",0
	even	

txt_car_yellow:
	dc.w	47*8,40*8
	dc.b	"YELLOW CAR",0
	even
	
txt_car_green:
	dc.w	47*8,40*8
	dc.b	"GREEN CAR ",0
	even	

txt_car_back:
	dc.w	47*8,40*8
	dc.b	"BACK      ",0
	even
	
txt_car_blank:
	dc.w	47*8,40*8
	dc.b	"          ",0
	even
	
txt_iface0:
	dc.w	47*8,42*8
	dc.b	"JOYSTICK PORT 1",0
	even

txt_iface1:
	dc.w	47*8,42*8
	dc.b	"JOYSTICK PORT 2",0
	even	

txt_iface2:
	dc.w	47*8,42*8
	dc.b	"HYBRID PORT 1  ",0
	even	

txt_iface3:
	dc.w	47*8,42*8
	dc.b	"HYBRID PORT 2  ",0
	even	

txt_iface4:
	dc.w	47*8,42*8
	dc.b	"PARALLEL PORT 1",0
	even	

txt_iface5:
	dc.w	47*8,42*8
	dc.b	"PARALLEL PORT 2",0
	even	
	
txt_iface6:
	dc.w	47*8,42*8
	dc.b	"KEYS  Q+W+SPACE",0
	even	
	
txt_iface7:
	dc.w	47*8,42*8
	dc.b	"KEYS   O+P+M   ",0
	even	

txt_iface_blank:
	dc.w	47*8,42*8
	dc.b	"               ",0
	even	
	
	even
	dc.b	"--- MENU CODE ENDS HERE ---",0
	even
		
	data
	
COIN_TIMER:	dc.w	0
	
DEMO_TEXT1:	dc.b	"5 MINUTE TIME LIMITED PLAY",0
		even
DEMO_TEXT2:	
		VERSION
		

		code
