ssTrackSelectInitilise:
	lea	RNC_TRACK_SELECT_SCENE,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_TRACK_SELECT_SCENE(a6)
	
	lea	RNC_TRACK_SELECT_SPRITES,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_TRACK_SELECT_SPRITES(a6)
	rts
	
ssTrackSelectInitHandles:
; Destroy all Vram chunks
	move.l	VRMPTR_SCREENS(a6),a0	
	bsr	agdDestroyAllVramScreens
	move.l	UNPPTR_TRACK_SELECT(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_TRACK_SELECT(a6)
	move.l	BMPPTR_TRACK_SELECT(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_TRACK_SELECT(a6)
	move.l	PALPTR_TRACK_SELECT(a6),a0
	bsr	agdDestroyHandle
	clr.l	PALPTR_TRACK_SELECT(a6)
	move.l	UNPPTR_TRACK_SELECT_SPRITES(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_TRACK_SELECT_SPRITES(a6)
	move.l	BMPPTR_TRACK_SELECT_SPRITES(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_TRACK_SELECT_SPRITES(a6)
	move.l	MSKPTR_TRACK_SELECT_SPRITES(a6),a0
	bsr	agdDestroyHandle
	clr.l	MSKPTR_TRACK_SELECT_SPRITES(a6)
	move.l	SPSPTR_TRACK_SELECT_SPRITES(a6),a0
	bsr	agdDestroyHandle
	clr.l	SPSPTR_TRACK_SELECT_SPRITES(a6)
	move.l	SCRPTR_TRACK_SELECT(a6),a0
	bsr	agdDestroyHandle
	clr.l	SCRPTR_TRACK_SELECT(a6)
	rts

ssTrackSelectCreateHandles:
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_TRACK_SELECT_SCENE(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_TRACK_SELECT(a6)

	move.l	UNPPTR_TRACK_SELECT(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_TRACK_SELECT(a6)		
	
	move.l	UNPPTR_TRACK_SELECT(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdGetBitmapPalette			;
	move.l	d0,PALPTR_TRACK_SELECT(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_TRACK_SELECT_SPRITES(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_TRACK_SELECT_SPRITES(a6)
	
	move.l	UNPPTR_TRACK_SELECT_SPRITES(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_TRACK_SELECT_SPRITES(a6)

	move.l	VRMPTR_SCREENS(a6),a0	
	move.l	BMPPTR_TRACK_SELECT_SPRITES(a6),d0
	bsr	agdCreateBitmapMask
	move.l	d0,MSKPTR_TRACK_SELECT_SPRITES(a6)	

	move.l	VRMPTR_SCREENS(a6),a0	
	move.l	BMPPTR_TRACK_SELECT_SPRITES(a6),d0
	move.l	MSKPTR_TRACK_SELECT_SPRITES(a6),d1
	move.l	#$4040,d2				; 16x16 Font
	moveq	#0,d3
	bsr	agdCreateSpriteSheet
	move.l	d0,SPSPTR_TRACK_SELECT_SPRITES(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	BMPPTR_TRACK_SELECT(a6),a1
	bsr	agdCreateScreenFromBitmap
	move.l	d0,SCRPTR_TRACK_SELECT(a6)
	move.l	d0,a0
	move.l	PALPTR_TRACK_SELECT(a6),hScreenPalette(a0)	; Assign palette to screen
.exit:	rts


ssTrackSelectCrash:	bra.s	ssTrackSelectCrash
	
ssTrackSelect:
	move.w	#sceneTrackSelect,CURRENT_SCENE(a6)
	bsr	ssTrackSelectInitHandles
	bsr	ssTrackSelectCreateHandles
	tst.l	d0
	bmi.s	ssTrackSelectCrash
	
	clr.w	SELECT_INIT(a6)

	bsr	ssRaceInitCars		; Clear car scores and attributes

; Create a copper resource
	move.l	SCRPTR_TRACK_SELECT(a6),a0
	move.l	COPPTR_COPPER_1(a6),a1
	bsr	ssUniCopper
	
	IFEQ	ENABLE_DEBUG
	INIT_DMA_INT
	START_COPPER
	SET_PARALLEL_PORT
	move.w	#(DMAF_SETCLR!DMAF_MASTER!DMAF_RASTER!DMAF_COPPER!DMAF_BLITTER),DMACON(a5)
	move.w	#(INTF_SETCLR!INTF_INTEN!INTF_EXTER!INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)
	ENDC
	
	IFEQ	ENABLE_DEBUG
	
	moveq	#%1,d0
	bsr	_mt_musicmask
	
	moveq	#SONG_TRACK_SELECT,d0
	move.l	UNPPTR_MODS1(a6),a0
	bsr	agdPlayModule
	ENDC
	
; Copy a bitmap to a screen
	move.l	BMPPTR_TRACK_SELECT(a6),d0
	move.l	SCRPTR_TRACK_SELECT(a6),d1
	bsr	agdTransitionBitmapToScreen
	
	move.l	SCRPTR_TRACK_SELECT(a6),a0
	moveq	#%00011,d2
	bsr	ssDisplayScorePanel
	
	moveq	#0,d3
	
; Display Traction Level

	bsr	ssDisplayText

	clr.l	FRAME_COUNT(a6)
	
.frame:	
	move.l	#-1,OSD_SCREEN_UPDATE(a6)
	bsr	WaitVbl
	
	IFNE	DEBUG_COLOURS
	move.w	#$707,$dff180
	ENDC

	IFNE	NO_INPUT_INTERUPTS
	bsr	agdReadInputs
	ENDC
	
	bsr	ssSetDroneToPlayerInput
	bsr	ssTrackSelectMoveWheel
	bsr	ssTrackSelectColourCycle
	
	move.l	SCRPTR_TRACK_SELECT(a6),a0
	moveq	#-1,d2
	move.w	#%00011,d2
	bsr	ssDisplayScorePanel
	
; Debugging stuff here.
	IFNE	DEBUGGING_OSD
	bsr	agdDebugWindow
	ENDC

.no_update:
	move.l	GAME_FIRST_PLAYER(a6),d1
	GET_CAR_CONTEXT		
	tst.w	carStateButton(a4)			
	beq	.frame
	
	bsr	ssLevelToTrack
	
	lea	CHIPBASE,a5
	clr.b	_mt_Enable
	move.w	#$700f,DMACON(a5)	;Disable Audio DMA
	moveq	#0,d0
	bsr	agdSetVolume
	
	move.l	SCRPTR_TRACK_SELECT(a6),d0
	bsr	agdTransitionBitmapFromScreen
	move.w	#sceneLoad,CURRENT_SCENE(a6)

; Kill VBL
	IFEQ	ENABLE_DEBUG
		END_SCENE
	ENDC
	
	bsr	ssTrackSelectInitHandles
	moveq	#0,d0
.error:	rts

ssLevelToTrack:
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	CURRENT_LEVEL(a6),d0			; This will be the track.
	move.w	d0,d2
	lea	LEVELS(a6),a0
.loop:	cmp.w	4(a0),d0				; is this the track?
	beq.s	.found
	addq.w	#1,d1
	addq.l	#8,a0					; Next track
	bra.s	.loop
.found:	move.w	d1,CURRENT_LEVEL(a6)
	
	lsr.w	#1,d2					; will either be 0,1,2,3
	move.l	d2,d3
	mulu.l	#10,d3
	lsr.l	#1,d3
	add.l	#10,d3
	
.d1:	moveq	#CAR_1,d1
	GET_CAR_CONTEXT
	move.l	#10,carScoreMultiplier(a4)
	tst.w	carIsDrone(a4)
	bmi.s	.d2
	move.w	d2,carSpanners(a4)
	move.l	d3,carScoreMultiplier(a4)

.d2:	moveq	#CAR_2,d1
	GET_CAR_CONTEXT
	move.l	#10,carScoreMultiplier(a4)
	tst.w	carIsDrone(a4)
	bmi.s	.d3
	move.w	d2,carSpanners(a4)
	move.l	d3,carScoreMultiplier(a4)
	
.d3:	moveq	#CAR_3,d1
	GET_CAR_CONTEXT
	move.l	#10,carScoreMultiplier(a4)
	tst.w	carIsDrone(a4)
	bmi.s	.d4
	move.w	d2,carSpanners(a4)
	move.l	d3,carScoreMultiplier(a4)
	
.d4:	moveq	#CAR_4,d1
	GET_CAR_CONTEXT
	move.l	#10,carScoreMultiplier(a4)
	tst.w	carIsDrone(a4)
	bmi.s	.exit
	move.w	d2,carSpanners(a4)	
	move.l	d3,carScoreMultiplier(a4)
.exit:	rts
	

ssDisplayText:
	movem.l	d0-d7/a0-a5,-(a7)
	move.l	SCRPTR_TRACK_SELECT(a6),a0	
	lea	.TABLE_CAR_TEXT(pc),a1
	move.l	GAME_FIRST_PLAYER(a6),d0
	move.l	(a1,d0*4),a1
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	moveq	#1,d3					; Colour 1 is car colour.
	bsr	agdSmallFont
	movem.l	(a7)+,d0-d7/a0-a5	
	
	movem.l	d0-d7/a0-a5,-(a7)
	moveq	#0,d0
	moveq	#0,d1
	move.l	SCRPTR_TRACK_SELECT(a6),a0	
	lea	.TEXT_CHOOSE_A_TRACK(pc),a1
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	moveq	#1,d3					; Colour 1 is car colour.
	bsr	agdSmallFont
.exit:	movem.l	(a7)+,d0-d7/a0-a5
	rts
	
.TABLE_CAR_TEXT:	dc.l	.TEXT_BLUE_CAR,.TEXT_RED_CAR,.TEXT_YELLOW_CAR,.TEXT_GREEN_CAR

.TEXT_BLUE_CAR:	dc.w	224,152
		dc.b	"BLUE CAR",0
		even

.TEXT_RED_CAR:	dc.w	232,152
		dc.b	"RED CAR",0
		even

.TEXT_YELLOW_CAR:	
		dc.w	216,152
		dc.b	"YELLOW CAR",0
		even

.TEXT_GREEN_CAR:	
		dc.w	216,152
		dc.b	"GREEN CAR",0
		even
		
.TEXT_CHOOSE_A_TRACK:	
		dc.w	200,168
		dc.b	"CHOOSE A TRACK",0
		even
	
	

; d0=0-8 Track number to highlight
; d1=-1 Set, d1=0Unset
ssTrackSelectHighlightTrack:
; Print spaces over difficulty

; Print difficulty text
	movem.l	d0-d7/a0-a5,-(a7)			; Clear difficulty text with space
	move.l	SCRPTR_TRACK_SELECT(a6),a0	
	lea	.TEXT_SPACES(pc),a1
	moveq	#0,d0
	moveq	#0,d1
	move.w	#224,d0
	move.w	#248,d1
	moveq	#-1,d3					
	bsr	agdSmallFont
			
	move.l	SCRPTR_TRACK_SELECT(a6),a0	
	lea	.TEXT_SPACES(pc),a1
	moveq	#0,d0
	moveq	#0,d1
	move.w	#192,d0
	move.w	#264,d1
	moveq	#-1,d3					
	bsr	agdSmallFont
	movem.l	(a7)+,d0-d7/a0-a5	
	
; Now plot 'EASY','MEDIUM','HARD' or 'VERY HARD'
	movem.l	d0-d7/a0-a5,-(a7)	
	lea	.difficulty(pc),a1
	lsl.l	#3,d0
	add.l	d0,a1
	move.l	(a1),a1
	move.l	SCRPTR_TRACK_SELECT(a6),a0	
	moveq	#0,d0
	moveq	#0,d1
	move.w	#224,d0
	move.w	#248,d1
	moveq	#29,d3					; Colour 1 is car colour.
	bsr	agdSmallFont
	movem.l	(a7)+,d0-d7/a0-a5

; Now plot 'BONUS WRENCHES'
	movem.l	d0-d7/a0-a5,-(a7)
	lea	.difficulty(pc),a1
	lsl.l	#3,d0
	add.l	d0,a1
	move.l	4(a1),a1
	move.l	SCRPTR_TRACK_SELECT(a6),a0	
	moveq	#0,d0
	moveq	#0,d1
	move.w	#192,d0
	move.w	#264,d1
	moveq	#29,d3					; Colour 1 is car colour.
	bsr	agdSmallFont
	movem.l	(a7)+,d0-d7/a0-a5	

	move.l	SCRPTR_TRACK_SELECT(a6),a0
	move.l	a0,a1
	lea	hScreenPointers(a1),a1
	move.l	16(a1),a1				; 5th Bitplane

	lea	.tracks(pc),a2
	add.l	(a2,d0*4),a1				; Highlight track select
	
	move.w	hScreenPlanes(a0),d7			; d7 = Number of planes
	and.l	#$f,d0
	moveq	#102-1,d7
.hl:
	move.l	d1,(a1)
	move.l	d1,4(a1)
	move.l	d1,8(a1)
	move.l	d1,12(a1)
	move.l	d1,16(a1)
	add.w	hScreenScanline(a0),a1
	dbf	d7,.hl
.exit:	rts

.tracks:
	dc.l	((64*5))*48+22			; Track 1
	dc.l	((64*5))*48+42			; Track 2
	dc.l	((64*5))*154+42			; Track 3
	dc.l	((64*5))*264+42			; Track 4
	dc.l	((64*5))*264+22			; Track 5
	dc.l	((64*5))*264+2			; Track 6
	dc.l	((64*5))*154+2			; Track 7
	dc.l	((64*5))*52+2			; Track 8
	dc.l	((64*5))*48+2			; Track 9  --- not used.
	
.difficulty:
	dc.l	.TEXT_EASY,.TEXT_SPACES
	dc.l	.TEXT_EASY,.TEXT_SPACES
	dc.l	.TEXT_MEDIUM,.TEXT_1BONUS_WRENCH	
	dc.l	.TEXT_MEDIUM,.TEXT_1BONUS_WRENCH		
	dc.l	.TEXT_HARD,.TEXT_2BONUS_WRENCHES		
	dc.l	.TEXT_HARD,.TEXT_2BONUS_WRENCHES	
	dc.l	.TEXT_VERY_HARD,.TEXT_3BONUS_WRENCHES		
	dc.l	.TEXT_VERY_HARD,.TEXT_3BONUS_WRENCHES	
		
.TEXT_EASY:	
		dc.b	"  EASY   ",0
		even
			
.TEXT_MEDIUM:	
		dc.b	" MEDIUM  ",0
		even

.TEXT_HARD:	
		dc.b	"  HARD   ",0
		even

.TEXT_VERY_HARD:	
		dc.b	"VERY HARD",0
		even
		
.TEXT_SPACES:	
		dc.b	"                ",0
		even

.TEXT_1BONUS_WRENCH:
		dc.b	" 1 BONUS WRENCH ",0
		even

.TEXT_2BONUS_WRENCHES:
		dc.b	"2 BONUS WRENCHES",0
		even

.TEXT_3BONUS_WRENCHES:
		dc.b	"3 BONUS WRENCHES",0
		even
	
;d0 = Sprite number
ssTrackSelectPlotWheel:
	move.l	d0,-(a7)
	move.l	d1,-(a7)
	move.l	SPSPTR_TRACK_SELECT_SPRITES(a6),a0
	move.l	hAddress(a0),a0
	move.l	(a0,d0*8),a1			; Get Sprite
	move.l	SCRPTR_TRACK_SELECT(a6),a2
	move.l	hScreenPointers(a2),a2
	
	add.l	#(176*64)*5,a2
	add.l	#224/8,a2
	
	moveq	#63,d7
	move.l	#40*3,d5
	move.l	#64*5,d6
	
.copy:	move.l	(a1),(a2)
	move.l	4(a1),4(a2)
	move.l	40(a1),64(a2)
	move.l	44(a1),68(a2)
	move.l	80(a1),128(a2)
	move.l	84(a1),132(a2)
	add.l	d5,a1
	add.l	d6,a2
	dbf	d7,.copy

	move.l	(a7)+,d1
	move.l	(a7)+,d0
	rts
	

; Move the steering wheel around.
	near	a6
ssTrackSelectMoveWheel:
	tst.w	SELECT_INIT(a6)
	bne.s	.zero
	move.w	#-1,SELECT_INIT(a6)
	clr.b	.angle
	bsr	.set
	
.zero:	
	move.l	GAME_FIRST_PLAYER(a6),d1
	GET_CAR_CONTEXT
	
	cmp.w	#TURN_LEFT,carStateDirection(a4)	; Needs to be selected car
	beq.s	.left					; who fired first!
	cmp.w	#TURN_RIGHT,carStateDirection(a4)
	beq.s	.right
	bra.s	.exit
	
.left:	
	bsr.s	.clear
	addq.b	#4,.angle(a6)
	bsr.s	.set
	bra.s	.exit
	
.right:	
	bsr.s	.clear
	subq.b	#4,.angle(a6)
	bsr.s	.set
	bra.s	.exit

.clear:
	moveq	#0,d1
	bsr.s	.highlight
	bra.s	.exit
	
.set:	moveq	#-1,d1
	bsr.s	.highlight
	movem.l	d0-d7/a0-a6,-(a7)
	moveq	#sampleCountdown,d0
	bsr	agdPlaySample
	movem.l	(a7)+,d0-d7/a0-a6
	bra.s	.exit
	
.highlight:
	moveq	#0,d0
	move.b	.angle(a6),d0
	lsr.w	#3,d0
	bsr	ssTrackSelectPlotWheel
	
; Range 0-31
	moveq	#0,d0
	move.b	.angle(a6),d0
	add.b	#$10,d0
	lsr.w	#5,d0
	move.w	d0,CURRENT_LEVEL(a6)
	bsr	ssTrackSelectHighlightTrack	
.exit:	rts
	
	data
	
.angle:	dc.b	0
	even
	
	code
	;near	a6
ssTrackSelectColourCycle:
	lea	.carcols(pc),a0
	move.l	COPPTR_TRACK_SELECT_PLAYER(a6),a1
	move.l	GAME_FIRST_PLAYER,d0
	move.w	(a0,d0*2),6(a1)
	move.w	(a0,d0*2),10(a1)
	
	lea	.cycle(pc),a0
	move.l	COPPTR_TRACK_SELECT_PALETTE(a6),a1
	moveq	#0,d0
.reset:	move.w	.pos(a6),d0
	tst.w	2(a0,d0*2)
	bpl.s	.ok
	clr.w	.pos(a6)
	bra.s	.reset
	
.ok:	move.w	(a0,d0*2),d1
	move.w	d1,(29*4)+2(a1)
	move.w	2(a0,d0*2),d1
	move.w	d1,(23*4)+2(a1)
	add.l	#$8000,.pos(a6)
.exit:	rts

.cycle:	dc.w	$f00,$e00,$d00,$c00,$b00,$a00,$900,$800,$900,$a00,$b00,$c00,$d00,$e00,$f00,-1
	even
.carcols:	dc.w	$00f,$f00,$ff0,$0f0

	data
	
.pos:	dc.l	0

	code



	

	data
	
COPPTR_TRACK_SELECT_PALETTE:	dc.l	0
MSKPTR_TRACK_SELECT_SPRITES:	dc.l	0
SPSPTR_TRACK_SELECT_SPRITES:	dc.l	0
RNCPTR_TRACK_SELECT_SPRITES:	dc.l	0
RNCPTR_TRACK_SELECT_SCENE:	dc.l	0

COPPTR_TRACK_SELECT_PAL:	dc.l	0

SCRPTR_TRACK_SELECT:	dc.l	0		
UNPPTR_TRACK_SELECT:	dc.l	0
BMPPTR_TRACK_SELECT:	dc.l	0
PALPTR_TRACK_SELECT:	dc.l	0		
	
SCRPTR_TRACK_SELECT_SPRITES:	dc.l	0		
UNPPTR_TRACK_SELECT_SPRITES:	dc.l	0
BMPPTR_TRACK_SELECT_SPRITES:	dc.l	0
PALPTR_TRACK_SELECT_SPRITES:	dc.l	0

SELECT_INIT:	dc.w	0

		code