maxUpgradeLevels:	equ	5

ssUpgradeCarInitilise:
	lea	RNC_UPGRADE_CAR_SCENE,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_UPGRADE_CAR_SCENE(a6)
	
	lea	RNC_UPGRADE_CAR_SPRITES,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_UPGRADE_CAR_SPRITES(a6)
	rts

ssUpgradeCarInitHandles
	move.l	VRMPTR_SCREENS(a6),a0	
	bsr	agdDestroyAllVramScreens
	move.l	UNPPTR_UPGRADE_CAR(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_UPGRADE_CAR	
	move.l	BMPPTR_UPGRADE_CAR(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_UPGRADE_CAR	
	move.l	PALPTR_UPGRADE_CAR(a6),a0
	bsr	agdDestroyHandle
	clr.l	PALPTR_UPGRADE_CAR
	move.l	UNPPTR_UPGRADE_CAR_SPRITES(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_UPGRADE_CAR_SPRITES(a6)
	move.l	BMPPTR_UPGRADE_CAR_SPRITES(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_UPGRADE_CAR_SPRITES(a6)	
	move.l	MSKPTR_UPGRADE_CAR_SPRITES(a6),a0
	bsr	agdDestroyHandle
	clr.l	MSKPTR_UPGRADE_CAR_SPRITES(a6)
	move.l	SPSPTR_UPGRADE_CAR_SPRITES(a6),a0
	bsr	agdDestroyHandle
	clr.l	SPSPTR_UPGRADE_CAR_SPRITES(a6)
	move.l	SCRPTR_UPGRADE_CAR(a6),a0
	bsr	agdDestroyHandle
	clr.l	SCRPTR_UPGRADE_CAR(a6)
	rts
	

ssUpgradeCarCreateHandles:
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_UPGRADE_CAR_SCENE(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_UPGRADE_CAR(a6)

; Create a Bitmap Handle and work out dimensions
	move.l	UNPPTR_UPGRADE_CAR(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_UPGRADE_CAR(a6)	
	
; Get the palette of the Bitmap
	move.l	UNPPTR_UPGRADE_CAR(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdGetBitmapPalette			;
	move.l	d0,PALPTR_UPGRADE_CAR(a6)

	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_UPGRADE_CAR_SPRITES(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_UPGRADE_CAR_SPRITES(a6)
	
	move.l	UNPPTR_UPGRADE_CAR_SPRITES(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_UPGRADE_CAR_SPRITES(a6)

	move.l	VRMPTR_SCREENS(a6),a0	
	move.l	BMPPTR_UPGRADE_CAR_SPRITES(a6),d0
	bsr	agdCreateBitmapMask
	move.l	d0,MSKPTR_UPGRADE_CAR_SPRITES(a6)	

	move.l	VRMPTR_SCREENS(a6),a0	
	move.l	BMPPTR_UPGRADE_CAR_SPRITES(a6),d0
	move.l	MSKPTR_UPGRADE_CAR_SPRITES(a6),d1
	move.l	#$4040,d2				; 16x16 Font
	moveq	#0,d3
	bsr	agdCreateSpriteSheet
	move.l	d0,SPSPTR_UPGRADE_CAR_SPRITES(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	BMPPTR_UPGRADE_CAR(a6),a1
	bsr	agdCreateScreenFromBitmap
	move.l	d0,SCRPTR_UPGRADE_CAR
	move.l	d0,a0
	move.l	PALPTR_UPGRADE_CAR(a6),hScreenPalette(a0)
	
.exit:	rts

ssUpgradeCarCrash:	bra	ssUpgradeCarCrash

ssUpgradeCar:
	move.w	#sceneUpgradeCar,CURRENT_SCENE(a6)
	
	bsr	ssUpgradeCarInitHandles
	bsr	ssUpgradeCarCreateHandles
	tst.l	d0
	bmi.s	ssUpgradeCarCrash
	
; Loop through each car and see if they have 3 spanners
	moveq	#CAR_1,d1
.car_loop:
	GET_CAR_CONTEXT
	cmp.l	#maxCars,d1
	beq	.finish
	cmp.w	#3,carSpanners(a4)
	blt.s	.1
	tst.b	carOutOfRace(a4)
	bmi.s	.1
	move.l	d1,-(a7)
	bsr	.3spans
	move.l	(a7)+,d1
.1:	addq.w	#1,d1
	bra.s	.car_loop
	
.3spans:
	move.l	d1,-(a7)	
	move.l	d1,UPGRADE_CAR_NUMBER(a6)	
	
	clr.w	TURN_INIT(a6)
	clr.w	DRONE_UPGRADE_SELECT_TIMER(a6)
	clr.w	DRONE_UPGRADE_THINK_TIMER(a6)
	
	move.l	SCRPTR_UPGRADE_CAR(a6),a0
	move.l	COPPTR_COPPER_1(a6),a1
	bsr	ssUniCopper	
	
	lea	$dff000,a5

	IFEQ	ENABLE_DEBUG
	INIT_DMA_INT	
	START_COPPER
	SET_PARALLEL_PORT
	move.w	#(DMAF_SETCLR!DMAF_MASTER!DMAF_RASTER!DMAF_COPPER!DMAF_BLITTER!DMAF_SPRITE),DMACON(a5)
	move.w	#(INTF_SETCLR!INTF_INTEN!INTF_EXTER!INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)
	ENDC
	
	moveq	#63,d0
	bsr	agdSetVolume
	
	move.l	BMPPTR_UPGRADE_CAR(a6),d0
	move.l	SCRPTR_UPGRADE_CAR(a6),d1
	bsr	agdTransitionBitmapToScreen
	
	move.l	SCRPTR_UPGRADE_CAR(a6),a0
	moveq	#OSD_UPDATE_INIT,d0
	bsr	ssUpdateOSD
	
; Display Upgrade Car Large Text
	move.l	SCRPTR_UPGRADE_CAR(a6),a0
	move.l	UPGRADE_CAR_NUMBER(a6),d0			; "BLUE CAR"
	moveq	#%00011,d2				; "CHOOSE AN ITEM FOR YOUR CAR"
	bsr	ssUpgradeCarText			; "INCREASE TRACTION, INCREASE SPEED" etc.

	move.l	UPGRADE_CAR_NUMBER(a6),d1
	GET_CAR_CONTEXT

	bsr	ssUpgradeDisplayText

	lea	$dff000,a5
.lof:	move.w	VPOSR(a5),d1
	bpl.s	.lof

	clr.l	FRAME_COUNT(a6)
	
.frame:	
	bsr	WaitVbl

	IFNE	ENABLE_DEBUG
	bsr	agdReadInputs
	ENDC
	
	bsr	ssUpgradeCarTurnWheel
	
	bsr	ssUpgradeCarDroneControl
	
; Debugging stuff here.
	IFNE	DEBUGGING_OSD
	bsr	agdDebugWindow
	ENDC

	move.l	UPGRADE_CAR_NUMBER(a6),d1
	GET_CAR_CONTEXT
	tst.w	carFrameButton(a4)			
	beq	.frame
; What was chosen????
; Get the angle and work it out.

	bsr	ssUpgradeCarAttribute
	tst.l	d0				; If too many.
	bmi	.frame
	
	bsr	ssUpgradeDeductSpanners
	
	bsr	agdStopChannels
	
	moveq	#SONG_UPGRADE_BLUE,d0
	move.l	UNPPTR_MODS1(a6),a0
	bsr	agdPlayModule
	
	moveq	#60-1,d7
.1sec:	bsr	WaitVbl
	dbf	d7,.1sec
	
	move.l	SCRPTR_UPGRADE_CAR(a6),d0
	bsr	agdTransitionBitmapFromScreen

	bsr	agdStopChannels
	
	IFEQ	ENABLE_DEBUG
	END_SCENE
	ENDC
	
	move.l	(a7)+,d1
	addq.w	#1,d1
	bra	.car_loop
	
.finish:
	;bsr	ssUpgradeCarInitHandles
	
	move.w	#sceneLoad,CURRENT_SCENE(a6)
.error:	rts

TEXT_LEVEL_TAB:	dc.l	TEXT_LEVEL_0,TEXT_LEVEL_1,TEXT_LEVEL_2,TEXT_LEVEL_3,TEXT_LEVEL_4,TEXT_LEVEL_5

TEXT_LEVEL:	dc.b	"LEVEL 1 2 3 4 5",0
		even
		
TEXT_LEVEL_0:	dc.b	"LEVEL",0
		even
		
TEXT_LEVEL_1:	dc.b	"LEVEL 1",0
		even
		
TEXT_LEVEL_2:	dc.b	"LEVEL 1 2",0
		even
		
TEXT_LEVEL_3:	dc.b	"LEVEL 1 2 3",0
		even
		
TEXT_LEVEL_4:	dc.b	"LEVEL 1 2 3 4",0
		even
		
TEXT_LEVEL_5:	dc.b	"LEVEL 1 2 3 4 5",0
		even
		
ssUpgradeDisplayText:
; Display Traction Level
	move.l	#64,d0
	move.l	#184,d1
	move.l	SCRPTR_UPGRADE_CAR(a6),a0	
	lea	TEXT_LEVEL(pc),a1
	moveq	#7,d3					; Colour 7 is White.
	bsr	agdSmallFont
	lea	TEXT_LEVEL_TAB(pc),a1
	moveq	#0,d3
	move.b	carAttrTraction(a4),d3
	move.l	(a1,d3*4),a1
	moveq	#1,d3					; Colour 1 is Blue/Red/Yellow 
	bsr	agdSmallFont
	
	
; Display Higher Speed Level
	move.l	#320,d0
	move.l	#184,d1
	move.l	SCRPTR_UPGRADE_CAR(a6),a0	
	lea	TEXT_LEVEL(pc),a1
	moveq	#7,d3
	bsr	agdSmallFont
	lea	TEXT_LEVEL_TAB(pc),a1
	moveq	#0,d3
	move.b	carAttrSpeed(a4),d3
	move.l	(a1,d3*4),a1
	moveq	#1,d3
	bsr	agdSmallFont


; Display Turbo Level
	move.l	#64,d0
	move.l	#288,d1
	move.l	SCRPTR_UPGRADE_CAR(a6),a0	
	lea	TEXT_LEVEL(pc),a1
	moveq	#7,d3
	bsr	agdSmallFont
	lea	TEXT_LEVEL_TAB(pc),a1
	moveq	#0,d3
	move.b	carAttrTurbo(a4),d3
	move.l	(a1,d3*4),a1
	moveq	#1,d3
	bsr	agdSmallFont
	rts

ssUpgradeCarAttribute:
	moveq	#0,d0
	move.w	SELECTED_UPGRADE(a6),d0
	cmp.w	#0,d0
	beq.s	.speed
	cmp.w	#1,d0
	beq.s	.score
	cmp.w	#2,d0
	beq.s	.turbo
	cmp.w	#3,d0
	beq.s	.traction
	bra	.exit

.traction:
	moveq	#-1,d0
	cmp.b	#maxUpgradeLevels,carAttrTraction(a4)
	beq.s	.exit
	moveq	#0,d0
	addq.b	#1,carAttrTraction(a4)
	bra.s	.exit

.turbo:
	moveq	#-1,d0
	cmp.b	#maxUpgradeLevels,carAttrTurbo(a4)
	beq.s	.exit
	moveq	#0,d0
	addq.b	#1,carAttrTurbo(a4)
	bra.s	.exit
	
.speed:
	moveq	#-1,d0
	cmp.b	#maxUpgradeLevels,carAttrSpeed(a4)
	beq.s	.exit
	moveq	#0,d0
	addq.b	#1,carAttrSpeed(a4)
	bra.s	.exit
	
.score:	moveq	#0,d0
	add.l	#3000,carScore(a4)
	move.w	#-1,carUpdateScore(a4)
	
.exit:	rts


ssUpgradeCarDroneControl:
	tst.w	carIsDrone(a4)
	beq.s	.exit
	
	clr.w	carStateDirection(a4)
	clr.w	carFrameButton(a4)
	
	cmp.w	#120,DRONE_UPGRADE_THINK_TIMER(a6)
	bge.s	.go

	addq.w	#1,DRONE_UPGRADE_THINK_TIMER(a6)
	bra.s	.exit
	
.go:	cmp.w	#24,DRONE_UPGRADE_SELECT_TIMER(a6)
	bgt.s	.select
	addq.w	#1,DRONE_UPGRADE_SELECT_TIMER(a6)
	
.right:	
	move.w	#TURN_LEFT,carStateDirection(a4)
	bra.s	.exit
	
.select:
	move.w	#-1,carFrameButton(a4)	
.exit:	rts




; a0=Screen Pointer
; d2=Bits to set ..... must be two bits set. (i.e. d2=%00011 for first two bitplanes).
ssUpgradeCarText:
	moveq	#0,d3
	move.l	SPRPTR_LARGE_FONT(a6),a1

	lea	.tab(pc),a2
	move.l	(a2,d0*4),a2
	moveq	#0,d0
	moveq	#0,d1
	bsr.s	.display
	
	lea	.line1(pc),a2
	moveq	#0,d0			; In 8x8 blocks
	moveq	#0,d1
	bsr.s	.display
	
	lea	.line2(pc),a2
	moveq	#0,d0			; In 8x8 blocks
	moveq	#0,d1
	bsr.s	.display

	lea	.line3(pc),a2
	moveq	#0,d0			; In 8x8 blocks
	moveq	#0,d1
	bsr.s	.display

	lea	.line4(pc),a2
	moveq	#0,d0			; In 8x8 blocks
	moveq	#0,d1
	bsr.s	.display
	
	lea	.line5(pc),a2
	moveq	#0,d0			; In 8x8 blocks
	moveq	#0,d1
	bsr.s	.display
	bra.s	.exit
	
.display:
	move.b	(a2)+,d0
	move.b	(a2)+,d1
	add.w	d1,d1
	
.loop:	move.b	(a2)+,d3			
	beq.s	.exit
	bsr	agdLargeFont
	add.w	#16,d0
	bra.s	.loop
	
.exit:	rts

.tab:	dc.l	.blue,.red,.yellow,.green

.blue:	dc.b	0,48>>1,"            BLUE CAR            ",0
	even

.red:	dc.b	8,48>>1,"            RED CAR             ",0
	even

.yellow	dc.b	0,48>>1,"           YELLOW CAR           ",0
	even

.green:	dc.b	8,48>>1,"           GREEN CAR            ",0
	even

.line1:	dc.b	8,80>>1,"  CHOOSE AN ITEM FOR YOUR CAR   ",0
	even

.line2:	dc.b	16,136>>1,"  SUPER           HIGHER      ",0
	even

.line3:	dc.b	16,160>>1,"  TRACTION        TOP SPEED   ",0
	even
	
.line4:	dc.b	16,240>>1,"  TURBO           INCREASE    ",0
	even

.line5:	dc.b	16,264>>1,"  ACCELERATION    SCORE       ",0
	even
	



; Build of a simple copper list
; a1 = Buffer of chip ram to build copper.
; d0 = Palette Structure
; d1 = Screen Structure

; Move the steering wheel around.
	near	a6
	
ssUpgradeCarTurnWheel:
	tst.w	TURN_INIT(a6)
	bne.s	.zero
	move.w	#-1,TURN_INIT(a6)
	clr.b	.angle(a6)
; During the first frame we save the background where the wheel is placed.
	move.l	SCRPTR_UPGRADE_CAR(a6),a2
	move.l	hScreenPointers(a2),a2
	;move.l	RAWPTR_WORKBUFFER(a6),a3
	move.l	MEMPTR_TRACK_PACK_BUFFER(a6),a3
	move.l	(a3),a3
	add.l	#(176*64)*4,a2		; centre y
	add.l	#224/8,a2		; centre x

	moveq	#64-8,d2
	moveq	#0,d3
	move.w	#(64*4)<<6+4,d0			; 
	
	WAIT_FOR_BLITTER
	move.l	#$09f00000,BLTCON0(a5)
	move.l	#-1,BLTAFWM(a5)
	move.w	d2,BLTAMOD(a5)
	move.w	d3,BLTDMOD(a5)
	move.l	a2,BLTAPTH(a5)
	move.l	a3,BLTDPTH(a5)
	move.w	d0,BLTSIZE(a5)	
	
.zero:	
	move.l	UPGRADE_CAR_NUMBER(a6),d1
	GET_CAR_CONTEXT
	
	;bsr	ssUpgradeCarDroneControl
	
	cmp.w	#TURN_LEFT,carStateDirection(a4)
	beq.s	.left
	cmp.w	#TURN_RIGHT,carStateDirection(a4)
	beq.s	.right
	bra.s	.plot
	
.left:	
	addq.b	#4,.angle(a6)
	bra.s	.plot
	
.right:	
	subq.b	#4,.angle(a6)
	bra.s	.plot
	nop

.plot:					; We restore 
	move.l	SCRPTR_UPGRADE_CAR(a6),a3
	move.l	hScreenPointers(a3),a3
	add.l	#(176*64)*4,a3		; centre y
	add.l	#224/8,a3		; centre x
	
	;move.l	RAWPTR_WORKBUFFER(a6),a2
	move.l	MEMPTR_TRACK_PACK_BUFFER(a6),a2
	move.l	(a2),a2
	
	moveq	#0,d2
	moveq	#64-8,d3
	move.w	#(64*4)<<6+4,d0
	
	lea	$dff000,a5
	WAIT_FOR_BLITTER
	move.l	#$09f00000,BLTCON0(a5)
	move.l	#-1,BLTAFWM(a5)
	move.w	d2,BLTAMOD(a5)
	move.w	d3,BLTDMOD(a5)
	move.l	a2,BLTAPTH(a5)
	move.l	a3,BLTDPTH(a5)
	btst	#6,$bfe001
	beq	.1

.loop	move.l	$dff004,d2
	and.l	#$1ff00,d2
	cmp.l	#100<<8,d2
	bne.b	.loop	
	
	move.w	d0,BLTSIZE(a5)	

.1
	moveq	#0,d0
	move.b	.angle(a6),d0
	lsr.w	#3,d0					; 0-31 0-4
	bsr	ssUpgradeCarPlotWheel
	
; Range 0-31 to 0-3
	lsr.w	#3,d0
	move.w	d0,SELECTED_UPGRADE(a6)
	lea	.order(pc),a0
	move.b	(a0,d0),d0
	move.l	UPGRADE_CAR_NUMBER(a6),d1
	bsr	ssUpgradeCarColourCycle	
.exit:	rts
	
.order:	dc.b	1,3,2,0

	data
	
.angle:	dc.b	0
	even
	
	code



; d0=0-8 Track number to highlight


;d0 = Sprite number
ssUpgradeCarPlotWheel:
	movem.l	d0-d2,-(a7)
	
	move.l	SPSPTR_UPGRADE_CAR_SPRITES(a6),a0
	move.l	hAddress(a0),a0
	move.l	(a0,d0*8),a1			; Get Sprite
	move.l	4(a0,d0*8),a3			; Get Mask
	
	move.l	SCRPTR_UPGRADE_CAR(a6),a2
	move.l	hScreenPointers(a2),a2
	add.l	#(176*64)*4,a2		; centre y
	add.l	#224/8,a2		; centre x
	
	moveq	#63,d7			; lines depth
	move.l	#40*3,d5		; Next scanline in source
	move.l	#64*4,d6		; Next scanline in dest
	
.copy:
	move.l	(a3),d2			; Get the mask	
	not.l	d2
	move.l	4(a3),d3
	not.l	d3
		
	and.l	d2,(a2)			; Plane 1
	and.l	d3,4(a2)
	
	and.l	d2,64(a2)		; Plane 2
	and.l	d3,68(a2)
	
	and.l	d2,128(a2)		; Plane 3
	and.l	d3,132(a2)
	
	and.l	d2,192(a2)		; Plane 4
	and.l	d3,196(a2)
	
	move.l	(a1),d3
	or.l	d3,(a2)
	move.l	4(a1),d3
	or.l	d3,4(a2)
	
	move.l	40(a1),d3	
	or.l	d3,64(a2)
	move.l	44(a1),d3
	or.l	d3,68(a2)		
	
	move.l	80(a1),d3	
	or.l	d3,128(a2)
	move.l	84(a1),d3
	or.l	d3,132(a2)

	add.l	d5,a1			; Next sprite plane
	add.l	d5,a3			; Next mask plane
	add.l	d6,a2

	dbf	d7,.copy

	movem.l	(a7)+,d0-d2
	rts
	
;d0 = Colour reg 0-3
;d1 = Car select colour
	near	a6
ssUpgradeCarColourCycle:
	move.l	d0,-(a7)
	move.l	d0,d2
	
	cmp.l	.old(a6),d0
	beq.s	.samepos
	
	move.l	d0,.old(a6)
	
	movem.l	d0-d7/a0-a6,-(a7)
	moveq	#sampleCountdown,d0
	bsr	agdPlaySample
	movem.l	(a7)+,d0-d7/a0-a6
	
.samepos:
	
	lea	.tab(pc),a0
	move.l	(a0,d1*4),a0
	move.l	COPPTR_UPGRADE_CAR_PALETTE(a6),a1
	moveq	#0,d0
.reset:	move.w	.pos(a6),d0
	tst.w	2(a0,d0*2)
	bpl.s	.ok
	clr.w	.pos(a6)
	bra.s	.reset
	
.ok:	
	addq.w	#2,a1
	
	move.w	#$eee,40(a1)			; Set all outlines to white
	move.w	#$eee,44(a1)
	move.w	#$eee,48(a1)
	move.w	#$eee,52(a1)
	
	move.l	COPPTR_WHEEL_POINTER(a6),a2
	
	move.w	0(a0),2(a2)			; Set wheel pointer colour
	move.w	26(a0),6(a2)
	move.w	(a0,d0*2),d1	
	add.l	#10,d2
	move.w	d1,(a1,d2*4)
	add.l	#$9000,.pos(a6)
.exit:	move.l	(a7)+,d0
	rts
	
.tab:	dc.l	.blue,.red,.yell,.green
.red:	dc.w	$f52,$e52,$d52,$c52,$b41,$a41,$941,$841,$730,$630,$530,$430,$320,$430,$530,$630,$730,$841,$941,$a41,$b41,$c52,$d52,$e52,$f52,-1
	even
.blue:	dc.w	$88f,$88e,$77d,$77c,$66b,$66a,$559,$558,$447,$446,$335,$334,$223,$334,$335,$446,$447,$558,$559,$66a,$66b,$77c,$77d,$88e,$88f,-1
	even
.green:	dc.w	$0f0,$0e0,$0d0,$0c0,$0b0,$0a0,$090,$080,$700,$060,$050,$040,$030,$040,$050,$060,$070,$080,$090,$0a0,$0b0,$0c0,$0d0,$0e0,$0f0,-1
	even
.yell:	dc.w	$ff2,$ee2,$dd2,$cc2,$bb2,$aa2,$992,$882,$772,$662,$552,$442,$332,$442,$552,$662,$772,$882,$982,$aa2,$bb2,$cc2,$dd2,$ee2,$ff2,-1
	even

	data
	
.pos:	dc.l	0
.old:	dc.l	0

	code

	CNOP	0,4
	
ssUpgradeDeductSpanners:
	moveq	#%0000,d0
	jsr	_mt_musicmask
	;move.b	#-1,_mt_Enable
	bsr	agdStopModule

	moveq	#3,d2
	
.frame:
	move.l	UPGRADE_CAR_NUMBER(a6),d1
	GET_CAR_CONTEXT
	
	subq.w	#1,carSpanners(a4)
	subq.w	#1,d2
	clr.w	carUpdateSpanners(a4)
		
	move.l	d2,-(a7)
	move.l	SCRPTR_UPGRADE_CAR(a6),a0
	moveq	#-1,d0
	move.l	UPGRADE_CAR_NUMBER(a6),d1
	bsr	ssUpdateOSD
	
	moveq	#sampleChime,d0
	bsr	agdPlaySample
	
	bsr	.delay
	
	move.l	(a7)+,d2
	
	tst.w	d2
	beq	.exit
	
	bra	.frame
	
	
.delay:	
	moveq	#30-1,d7
.1:	bsr	WaitVbl
	dbf	d7,.1
	bra.s	.exit
	nop
.exit:	rts
	
	data
	
	CNOP	0,4

COPPTR_WHEEL_POINTER:	dc.l	0
TURN_INIT:	dc.w	0
SELECTED_UPGRADE:	dc.w	0
DRONE_UPGRADE_SELECT_TIMER:	dc.w	0
DRONE_UPGRADE_THINK_TIMER:	dc.w	0

SCRPTR_UPGRADE_CAR:	dc.l	0		
UNPPTR_UPGRADE_CAR:	dc.l	0
BMPPTR_UPGRADE_CAR:	dc.l	0
PALPTR_UPGRADE_CAR:	dc.l	0		
	
SCRPTR_UPGRADE_CAR_SPRITES:	dc.l	0		
UNPPTR_UPGRADE_CAR_SPRITES:	dc.l	0
BMPPTR_UPGRADE_CAR_SPRITES:	dc.l	0
PALPTR_UPGRADE_CAR_SPRITES:	dc.l	0		
	
UPGRADE_CAR_NUMBER:	dc.l	0	
COPPTR_UPGRADE_CAR_PALETTE:	dc.l	0
MSKPTR_UPGRADE_CAR_SPRITES:	dc.l	0
SPSPTR_UPGRADE_CAR_SPRITES:	dc.l	0
RNCPTR_UPGRADE_CAR_SCENE:	dc.l	0
RNCPTR_UPGRADE_CAR_SPRITES:	dc.l	0

COPPTR_UPGRADE_CAR_PAL:	dc.l	0

	code