;-----------------------------------------------------------------------------------------------
; Master Blaster
;
; Menu-Parts
;
;-----------------------------------------------------------------------------------------------

Global Frame.T_Frame				; Frame to click on...
Global InfoText.T_InfoText	; Chatmessages
Global B_PlayerTeam
Global B_PlayerHero = 0
Global B_PlayerDevice
Global B_PlayerName$
Global Cursor_Counter				; Cursor blink...
Global Cursor_mode					; 0-chat, 1-playername


Type T_InfoText
	Field Txt$
	Field Counter
End Type

Type T_NetComp
	Field Nr
	Field Name$
	Field NetID
	Field IsHost
	Field Ready
End Type

Type T_Frame
	Field x1,y1
	Field x2,y2
	Field name$
	Field txt$
	Field cr,cg,cb
	field kind
	field locked
	field TextOffset
End Type

Type T_NetPlayer
	Field name$
	Field Nr
	Field CompName$
	Field CompID
	Field Hero
	Field Team
	Field Device
	field DevCodeLeft1
	field DevCodeLeft2
	field DevCodeLeft3
	field DevCodeLeft4
	field DevCodeRight1
	field DevCodeRight2
	field DevCodeRight3
	field DevCodeRight4
	field DevCodeUp1
	field DevCodeUp2
	field DevCodeUp3
	field DevCodeUp4
	field DevCodeDown1
	field DevCodeDown2
	field DevCodeDown3
	field DevCodeDown4
	field DevCodeBomb1
	field DevCodeBomb2
	field DevCodeBomb3
	field DevCodeBomb4
	field DevCodePause1
	field DevCodePause2
	field DevCodePause3
	field DevCodePause4
End Type


;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------- Menu_Main
Function Menu_Main()
	
	MaxPlayer=0
	Net_Type=0
	Mouse_Click$=""
	Net_CompCount=1
	Net_MyNetID=1
	SetStatus(C___MAIN)
  B_PlayerName$ = "New-Player"

	Im_Image=LoadImage("gfx\title.png")
	Im_Buttons=LoadanimImage("gfx\title_buttons.png",290,50,0,12)

  SetBuffer BackBuffer()
	Playsong("music\other\east.mp3")
	
	SetFont Font_24
	Color 255,255,255	

	Menu_CreateFrame(1,3,51,34,"QUIT","",7)
	Menu_CreateFrame(1,300,92,335,"CREDITS","",7)
	Menu_CreateFrame(656,402,792,438,"HIGHSCORES","",7)
	If (REGVERSION) Then
		Menu_CreateFrame(  4,553,280,588,"JOINGAME","",7)
		Menu_CreateFrame(507,553,792,591,"STARTSERVER","",7)
		Menu_CreateFrame(568,  3,792, 35,"STARTLOCAL","",7)
	EndIf
	
	starfield_init()
	While (Left$(LSet$(Mouse_Click$,40),1)=" ") Or (Mouse_Click$="")

  	cls
  	starfield_update()
  	
		Drawimage Im_Image,0,0

		Menu_DrawFrames()

		Menu_HandleMouse()

		waittimer(Timer)
		
		Flip 0

		
		
		If Mouse_Click$="STARTSERVER" Then
			cls
			setfont font_24
			color 255,255,255
			Text 400,300,"Please wait...",true
			flip
			If hostNetGame("MB"+VERSYEAR)<>2 Then
;				MsgWindow(100,100,100,100,"Error creating TCP/IP game !")
				PlayWav(WAV_MouseError,0,0)
				Mouse_Click$=""
			Else
				Net_MyName$="Comp 1"
				Net_Comp = New T_NetComp
				Net_Comp\Name$=Net_MyName$
				Net_Comp\NetId=CreateNetPlayer("MB"+VERSYEAR)
				Net_Comp\IsHost=True
				Net_CompCount=1
				Net_MyNetID=Net_Comp\NetId
				Net_Type=2
				PlayWav(WAV_MouseClick,0,0)
			EndIf
		EndIf

		If Mouse_Click$="JOINGAME" Then
			Cursor_Mode=2
			SetFont Font_24
			Repeat
				cls
				Color 255,255,255
				Menu_ReadKeyboard()
				Flip True
			Until Cursor_mode<>2
			
			If Cursor_mode=0 Then
				Color 255,255,255
				Text 400,300,"Connecting...",True
				Flip True
				If JoinNetGame("MB"+VERSYEAR,IPAddress$)<>1 Then
					StopNetGame
					PlayWav(WAV_MouseError,0,0)
					Mouse_Click$=""
				Else
					Net_MyName$="Comp 2"
					Net_Comp = New T_NetComp
					Net_Comp\Name$=Net_MyName$
					Net_Comp\NetID=CreateNetPlayer("MB"+VERSYEAR)
					Net_Comp\IsHost=False
					Net_CompCount=1
					Net_MyNetID=Net_Comp\NetID
					Net_Type=1
					PlayWav(WAV_MouseClick,0,0)
				EndIf
			EndIf

			If Cursor_Mode=99 Then
				Repeat
				Until KeyDown(1)=False
				Mouse_Click$=""
			EndIf

		EndIf

		If Mouse_Click$="STARTLOCAL" Then
			Net_MyName$="local"
			Net_Type=0
			PlayWav(WAV_MouseClick,0,0)
		EndIf


		If Mouse_Click$="CREDITS" Then
			
			cls
			flip
			Playsong("")
			CREDITS()
			cls
			flip
			Playsong("music\other\east.mp3")
			Mouse_Click$=""
		EndIf

		If Mouse_Click$="HIGHSCORES" Then
			cls
			flip
			Playsong("")
			ShowHighscores()
			cls
			flip
			Playsong("music\other\east.mp3")
		EndIf

		If KeyDown(1) Then Mouse_Click$="QUIT"
		
	Wend
	
	Playsong("")
	
	starfield_destroy()
	
	If Mouse_Click$="QUIT" Then	PlayWav(WAV_MouseError,0,0)
		
	Delete Each T_Frame							; remove frames
	FreeImage Im_Image	
	FreeImage Im_Buttons
	cls
	flip
	
End Function


;---------------------------------------------------------------------------------- Menu_Network
Function Menu_Network()

	HandleConfig("LoadNames")
	SetStatus(C___NET)
	LoadMenuPlayerImages()
	Im_Image=LoadImage("gfx\menu_background.png")
  Im_Buttons=LoadanimImage("gfx\menu_buttons.png",72,28,0,6)
	Menu_DrawBombs("init")
	
	Playsong("sfx\space.mp3")	
	
	SetFont Font_24
	Color 255,255,255
	SetBuffer BackBuffer()

	Delete Each T_InfoText
	Menu_InfoText("Welcome to MB"+VERSYEAR+"...")
	
	Menu_Create("Network")

	Cursor_Mode=0						; Chatmode
	Mouse_Click$=""

	While (Mouse_Click$<>"START") And (Mouse_Click$<>"ESCAPE") And (Mouse_Click$<>"QUIT") And (GameStatus=C___NET)

  	if GetJoy then
  		port =100
  		repeat
  			cls
				Drawimage Im_Image,0,0 			;Background
				Menu_DrawBombs("update")		;Background
				Menu_DrawForeground()       ;Foreground
				color 255,255,255
				rect 540,2,221,21,1
				color 0,0,0
				text 650,10,"Press a Joy Button or ESC",1,1
				Waittimer(Timer)
				Flip false
				for i=0 to 14
					for j=0 to 7
						if joydown(j,i) then port = i
					next
				next				   		
  		until keydown(1) or port <> 100
  		if port <=14
				B_PlayerDevice = port+1
				LoadDefaultInput(0)
				PlayWav(WAV_MouseClick,0,0)
			endif
  		movemouse xmouse,ymouse
  		GetJoy = False
  	endif
  	
		cls
		
		Drawimage Im_Image,0,0 			;Background

		Menu_DrawBombs("update")		;Background
		
		Menu_DrawForeground()       ;Foreground

		Menu_HandleMouse()

		Menu_ReadKeyboard()

		NET_Listen()

		Menu_SendToNetwork()
		
		SCREENSHOT()

		flushkeys()
    Waittimer(Timer)
		Flip false
		
		If (Mouse_Click$="START")  Then
			team = $FF
			if Game_Mode<>0
				Net_Player = first T_NetPlayer
				team = Net_Player\Team
				For Net_Player=Each T_NetPlayer
					If Net_Player\Team<>team Then
						team = $FF
						exit
					endif
				Next
			endif
			if (MaxPlayer<2) or team<>$FF
				PlayWav(WAV_MouseError,0,0)
				Mouse_Click$=""
			endif
		EndIf

		If (Mouse_Click$="INP_CONFIG")  Then
			PlayWav(WAV_MouseClick,0,0)
			For Frame = Each T_Frame
				if Frame\Name$="P_NAME" then	B_PlayerName$ = Frame\Txt$
				Delete Frame.T_Frame					; remove frames
			next
			Menu_InputConfig()
			Menu_Create("Network")
		endif	
	Wend
  if  Net_Type=1 and GameStatus <> C___BEGINGAME and Mouse_Click$ <> "QUIT" Then Mouse_Click$ = "ESCAPE"



  if Mouse_Click$="QUIT" then end
  
	If Mouse_Click$<>"ESCAPE"
		SetStatus(C___BEGINGAME)
		Menu_DrawBombs("update","explodeall")
		PlayWav(Wav_MouseStartGame,0,0)
		for x = 0 to 75
			cls
			Menu_DrawBombs("update","explodeallupdate")
			Waittimer(Timer)
			flip
		next
		Menu_DrawBombs("cleanup")
	else
		PlayWav(WAV_MouseClick,0,0)
		Menu_DrawBombs("cleanup")
	EndIf
	
	cls
	flip

  Playsong("")
		
	FreeImage Im_Image

	FreeImage	Im_Buttons

	freeimage Im_Player_Menu
	For Frame = Each T_Frame
		if Frame\Name$="P_NAME" then	B_PlayerName$ = Frame\Txt$
		Delete Frame.T_Frame					; remove frames
	next
End Function



;---------------------------------------------------------------------------------- Menu_InputConfig
Function Menu_InputConfig()

	Menu_Create("InputConfig")
	Mouse_Click$=""
	
	for i=0 to C_MAX_INP_CODES-1
		InpDeviceCode(i,1) = InpDeviceCode(i,0)
	next
	
	While Mouse_Click$<>"INPUT_OK" and Mouse_Click$<>"INPUT_CANCEL" and GameStatus=C___NET

  	if GetInput then
  		code =300
  		repeat
  			cls
				Drawimage Im_Image,0,0 			;Background
				Menu_DrawBombs("update")		;Background
				Menu_DrawForeground("InputConfig")
				if B_PlayerDevice = 0
					color 255,255,255
					rect 5,203,350,21,1
					color 0,0,0
					text 10,200,"Press a Key (ESC to cancel, DEL to delete)"
					for i=2 to 250
						if keydown(i)
							code = i
							InpDeviceCode(GetInput-1,1)=code
						 endif
					next					
				else
					color 255,255,255
				 	rect 5,203,400,21,1
			  	color 0,0,0
				 	text 10,200,"Press Joy Button (ESC to cancel, DEL to delete)"
				 	for i=0 to 14
					 	if joydown(i,B_PlayerDevice-1)
							code = i
							InpDeviceCode(GetInput-1,1)=code+19
						endif						
					next
					if abs(joyx(B_PlayerDevice-1)) > 0.1
							code = 0
							InpDeviceCode(GetInput-1,1) =1
					elseif abs(joyY(B_PlayerDevice-1)) > 0.1
							code = 0
							InpDeviceCode(GetInput-1,1) = 2	
					elseif abs(joyZ(B_PlayerDevice-1)) > 0.1
							code = 0
							InpDeviceCode(GetInput-1,1)=3
					elseif abs(joyroll(B_PlayerDevice-1)) > 10
							code = 0
							InpDeviceCode(GetInput-1,1)=4	
					elseif joyhat(B_PlayerDevice-1) = 90 or joyhat(B_PlayerDevice-1) = 270
							code = 0
							InpDeviceCode(GetInput-1,1)=5
					elseif joyhat(B_PlayerDevice-1) = 180 or joyhat(B_PlayerDevice-1) = 0
							code = 0
							InpDeviceCode(GetInput-1,1)=6
					elseif Keydown(211)
							code = 0
							InpDeviceCode(GetInput-1,1)=0
					endif	
				endif
				Waittimer(Timer)
				Flip false
						   		
  		until keydown(1) or code <> 300
  		if code<>300 then PlayWav(WAV_MouseClick,0,0)
  		movemouse xmouse,ymouse
  		GetInput = False
  	endif
  	
  	cls
  	
  	Drawimage Im_Image,0,0 			;Background
		Menu_DrawBombs("update")		;Background

    Menu_DrawForeground("InputConfig")
    
		Menu_HandleMouse()

		NET_Listen()

		Menu_SendToNetwork()
		SCREENSHOT()

    flushkeys()
    Waittimer(Timer)
		Flip false
	
	wend	

  PlayWav(WAV_MouseClick,0,0)
  
	if Mouse_Click$ = "INPUT_OK"
		for i=0 to C_MAX_INP_CODES-1
			InpDeviceCode(i,0) = InpDeviceCode(i,1)
		next		
	endif
	
	Delete Each T_Frame					; remove frames

End Function


;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------

;---------------------------------------------------------------------------------- ReadKeyboard
Function Menu_ReadKeyboard()
	
	If Cursor_Counter=0 Then
		Cursor_Counter=60
	Else
		Cursor_Counter=Cursor_Counter-1
	EndIf
	
	If Cursor_Mode=3 and ConfigEntryChoosed=0 Then Cursor_Mode=0			; Config-Name
  		
	key=GetKey()
 	If key Then
	
		If Cursor_Mode=0 Then			; Chat
			If key=13 Then
				If Net_chat$<>"" Then 
					Menu_InfoText(Net_MyName$+": "+Net_Chat$)
					If Net_Type<>0 Then
						NET_Broadcast("CHAT")
					EndIf
				EndIf
				Net_chat$=""
			EndIf
			If key=8 Then
				If Len(Net_chat$)>0 Then Net_chat$=Left$(Net_chat$,Len(Net_chat$)-1)
			EndIf
			If (key>=32) And (key<255) Then
				If StringWidth(Net_Chat$+Chr$(key))<190 Then Net_chat$=Net_chat$+Chr$(key)
			EndIf
		EndIf

		If Cursor_Mode=1 Then			; Playername
			Menu_FindFrame("P_NAME")
			name$=Frame\Txt$
			If key=13 Then 
				Cursor_Mode=0
				Return
			EndIf
			If key=8 Then
				If Len(name$)>0 Then name$=Left$(Name$,Len(Name$)-1)
			EndIf
			If (key>=32) And (key<255) Then
				If StringWidth(Name$+Chr$(key))<150 Then Name$=Name$+Chr$(key)
			EndIf
			Frame\Txt$=Name$
		EndIf

		If Cursor_Mode=2 Then			; IP-Address
			name$=IPAddress$
			If key=13 Then 				; Return
				Cursor_Mode=0
				Return
			EndIf
			If key=27 Then 				; Esc
				Cursor_Mode=99
				Return
			EndIf
			If key=8 Then
				If Len(name$)>0 Then name$=Left$(Name$,Len(Name$)-1)
			EndIf
			If ((key>=32) And (key<127)) Then
				If StringWidth(Name$+Chr$(key))<160 Then Name$=Name$+Chr$(key)
			EndIf
			IPAddress$=Name$
		EndIf

  	If Cursor_Mode=3 Then			; Config-Name
  		Menu_FindFrame("CONFIG-"+ConfigEntryChoosed)
			name$=Frame\Txt$
			If key=8 Then
				If Len(name$)>0 Then name$=Left$(Name$,Len(Name$)-1)
			EndIf
			If (key>=32) And (key<255) Then
				If StringWidth(Name$+Chr$(key))<200 Then Name$=Name$+Chr$(key)
			EndIf
			Frame\Txt$=name$
		EndIf
	EndIf
	

  Color 255,255,255
	If Cursor_mode=2 Then
		If Cursor_Counter<30 Then
			Text 260,280,"Enter IP-Address : "+IPAddress$+"_",False,True
		Else
			Text 260,280,"Enter IP-Address : "+IPAddress$,False,True
		EndIf
	EndIf
	
End Function


;--------------------------------------------------------------------------------- SendToNetwork
Function Menu_SendtoNetwork()

	;If Net_Type=2 Then NET_Broadcast("MOUSEDATA")
	
	Net_Counter=Net_Counter + 1
	If Net_Counter<30 Then Return
	Net_Counter=0

	If Net_Type=2 Then
		NET_Broadcast("HOSTDATA")
		NET_Broadcast("GAMEDATA")
	EndIf

End Function


;-------------------------------------------------------------------------------------- FindComp
Function Menu_FindComp.T_NetComp( id )
	For Net_Comp.T_NetComp=Each T_NetComp
		If Net_Comp\NetID=Id Then Return Net_Comp
	Next
End Function


;-------------------------------------------------------------------------------------- InfoText
Function Menu_InfoText(txt$)
	InfoText.T_InfoText=New T_InfoText
	InfoText\Txt$=Txt$
	InfoText\Counter=1000
	Insert InfoText Before First T_InfoText
End Function


;------------------------------------------------------------------------------------- PrintInfo
Function Menu_PrintInfo()
	y=(FontHeight()*20)+10
	r=6
	Color 255,255,255
	For InfoText.T_InfoText=Each T_InfoText
		If r>0
			Text 545,y,InfoText\txt$
			y=y-FontHeight()
			r=r-1
		Else
			Delete InfoText
		EndIf
	Next
End Function


;----------------------------------------------------------------------------------- CreateFrame
Function Menu_CreateFrame(x1,y1,x2,y2,name$,txt$,kind=0,locked=0,TextOffset=0)
	Frame = New T_Frame
	Frame\x1=x1
	Frame\y1=y1
	Frame\x2=x2+1
	Frame\y2=y2+1
	Frame\Name$=Name$
	Frame\Txt$=Txt$
	Frame\kind=kind
	Frame\locked=locked
	Frame\TextOffset=TextOffset
	Insert Frame Before First T_Frame
End Function


;------------------------------------------------------------------------------------ DrawForeground
Function Menu_DrawForeground(menu$="Network")
		
		
		if wobblescreen_cnt
		  origin wobblescreen_cnt*0.3*rnd(-1,1),wobblescreen_cnt*0.3*rnd(-1,1)
			;origin wobblescreen_cnt*0.1*sin(60*wobblescreen_angle)+wobblescreen_cnt*0.05*cos(50*wobblescreen_angle),wobblescreen_cnt*0.1*sin(40*wobblescreen_angle)+wobblescreen_cnt*0.02*cos(80*wobblescreen_angle)
			wobblescreen_angle = wobblescreen_angle+1
			wobblescreen_cnt = wobblescreen_cnt-1
		endif
		
		select menu
		case "Network"
			color 202,15,43
			text 20,20,"Name"
			text 200,20,"@"
			text 267,20,"Team"
			text 333,20,"Hero"
			text 445,20,"Input"
			text 630,190,"Configs"
			color 255,255,255
			rect 190,270,1,330,1
			rect 0,270,533,1,1
			rect 533,0,1,600,1
			rect 533,365,267,1,1
			rect 533,189,267,1,1
			rect 533,555,267,1,1
			Menu_PrintInfo()
		
		case "InputConfig"
			color 202,15,43
			text 35,250+0*30,"Action"
			if B_PlayerDevice then
				text 175,250+0*30,"Joy Input"
			else
				text 150,250+0*30,"Keyboard Input"
			endif
			text 306,250+0*30,"Alternative Input 1"
			text 472,250+0*30,"Alternative Input 2"
			text 639,250+0*30,"Alternative Input 3"
			text 10,250+1*30,"Move Left"
			text 10,250+2*30,"Move Right"
			text 10,250+3*30,"Move Up"
			text 10,250+4*30,"Move Down"
			text 10,250+5*30,"Drop Bomb"
			text 10,250+6*30,"Pause Game"
			color 255,255,255
			rect 0,248+0*30,800,1,1
			rect 0,248+1*30,800,1,1
			rect 0,248+2*30,800,1,1
			rect 0,248+3*30,800,1,1
			rect 0,248+4*30,800,1,1
			rect 0,248+5*30,800,1,1
			rect 0,248+6*30,800,1,1
			rect 0,248+7*30,800,1,1
			
			rect 0  ,248,1,210,1
			rect 130,248,1,210,1
			rect 298,248,1,210,1
			rect 466,248,1,210,1
			rect 633,248,1,210,1
			rect 799,248,1,210,1
		end select

		Menu_DrawFrames()
    origin 0,0
		
end function



;------------------------------------------------------------------------------------ DrawFrames
Function Menu_DrawFrames()

	For Frame = Each T_Frame
	
		if Frame\locked=1
			Color 202,15,43
			active = 0
		elseIf (xmouse>=Frame\x1) And (xmouse<=Frame\x2) And (ymouse>=Frame\y1) And (ymouse<=Frame\y2) then
			Color 122,44,252
			active = 1
		else
			color 255,255,255
			active = 0
		endif
		
		select Frame\kind
		case 1
			if Frame\name="SHOP" and Shop_On Then	
				Text frame\x1+2,frame\y1-8,"x"
			elseif Frame\name="SHRINKING" and Menu_Shrinking_On	Then	
				Text frame\x1+2,frame\y1-8,"x"
			elseif Frame\name="WHEEL"     and Wheel_On 			Then	
				Text frame\x1+2,frame\y1-8,"x"
			elseif Frame\name="SPECIAL"   and Special_On 		Then	
				Text frame\x1+2,frame\y1-8,"x"
			elseif Frame\name="MUSIC"     and Music_On 			Then	
				Text frame\x1+2,frame\y1-8,"x"
			elseif Frame\name="PITCH"     and Pitch_On 			Then	
				Text frame\x1+2,frame\y1-8,"x"
			elseif Frame\name="VIDEO"     and Video_On 			Then	
				Text frame\x1+2,frame\y1-8,"x"
			elseif Frame\name="ALARM"     and Menu_Alarm_On Then	
				Text frame\x1+2,frame\y1-8,"x"
			endif
			
			Rect frame\x1-1,frame\y1-1,frame\x2-frame\x1+2,frame\y2-frame\y1+2,0
			Rect frame\x1,frame\y1,frame\x2-frame\x1,frame\y2-frame\y1,0
			Color 202,15,43
			text frame\x1+frame\TextOffset,frame\y1-8,frame\txt$
		case 2
			mitte = (frame\x2-frame\x1)/2+frame\x1
			
			line frame\x1-1,frame\y2,mitte,frame\y1
			line frame\x1,frame\y2,mitte,frame\y1+1
			line frame\x2+1,frame\y2,mitte,frame\y1
			line frame\x2,frame\y2,mitte,frame\y1+1
			line frame\x1,frame\y2,frame\x2,frame\y2
			line frame\x1,frame\y2-1,frame\x2,frame\y2-1
;			Rect frame\x1-1,frame\y1-1,frame\x2-frame\x1+2,frame\y2-frame\y1+2,0
;			Rect frame\x1,frame\y1,frame\x2-frame\x1,frame\y2-frame\y1,0
;			line frame\x1,frame\y2,mitte+1,frame\y1
;			line frame\x1-1,frame\y2,mitte,frame\y1
;			line frame\x2-1,frame\y2,mitte-2,frame\y1
;			line frame\x2,frame\y2,mitte-1,frame\y1
			if(Frame\locked = 0)
				frame = before frame
				If (xmouse>=Frame\x1) And (xmouse<=Frame\x2) And (ymouse>=Frame\y1) And (ymouse<=Frame\y2) then Color 122,44,252
				frame = after frame
			endif
			
      if frame\name = "P_HERO_UP"   then
				Text frame\x1+20,frame\y1-3,Im_Player(B_PlayerHero)\Name$
				DrawImage Im_Player_Menu,frame\x1+154,frame\y1+22,B_PlayerHero
			elseif frame\name = "TIME_UP" then
							f# =  B_Time
      	Tempstring$ = (f/2)+" min"
      	if B_Time > 2 then Tempstring$ =	Tempstring$+"s"
				Text frame\x1+20,frame\y1-3,Tempstring$
			elseif frame\name = "P_TEAM_UP"   then
				Text frame\x1+20,frame\y1-3,Array_Team$(B_PlayerTeam)
      elseif frame\name = "P_DEVICE_UP" then
				Text frame\x1+20,frame\y1-3,Array_Device$(B_PlayerDevice)
      elseif frame\name = "GAME_UP"     then
				Text frame\x1+20,frame\y1-3,Array_Game$(Game_Mode)
			elseif frame\name = "LEVEL_UP"		then
				Text frame\x1+20,frame\y1-3,Array_Level$(Level)
			elseif frame\name = "LEVEL_UP"		then
				Text frame\x1+20,frame\y1-3,Array_Level$(Level)
			elseif frame\name = "WINS_UP"		  then
				Text frame\x1+20,frame\y1-3,WinsNeeded
				
			elseIf Left$(frame\name,1)="!" Then
				drawimage(Im_Items,frame\x1-25,frame\y1+8,Anim_Items(frame\TextOffset)\Frame)			
				z%=Mid$(frame\name,2,2)
				Menu_PrintItem(frame\x1+20,frame\y1-3,z)
      endif

			If Left$(frame\name,1)<>"!" Then	
				Color 202,15,43
				text frame\x1+frame\TextOffset,frame\y1-3,frame\txt$
			endif
		case 3
			mitte = (frame\x2-frame\x1)/2+frame\x1
			line frame\x1-1,frame\y1,mitte,frame\y2
			line frame\x1,frame\y1,mitte,frame\y2-1
			line frame\x2+1,frame\y1,mitte,frame\y2
			line frame\x2,frame\y1,mitte,frame\y2-1
			line frame\x1,frame\y1,frame\x2,frame\y1
			line frame\x1,frame\y1+1,frame\x2,frame\y1+1
;			
;			Rect frame\x1-1,frame\y1-1,frame\x2-frame\x1+2,frame\y2-frame\y1+2,0
;			Rect frame\x1,frame\y1,frame\x2-frame\x1,frame\y2-frame\y1,0
;			line frame\x1,frame\y1-1,mitte+1,frame\y2-1
;			line frame\x1-1,frame\y1-1,mitte,frame\y2-1
;			line frame\x2-1,frame\y1-1,mitte-2,frame\y2-1
;			line frame\x2,frame\y1-1,mitte-1,frame\y2-1
		case 4
			if frame\name ="INP_CONFIG"
				if B_PlayerDevice=0 then
					frame\txt="KeyConfig"
				else
				 	frame\txt="JoyConfig"
				endif
			endif	
			Rect frame\x1-1,frame\y1-1,frame\x2-frame\x1+2,frame\y2-frame\y1+2,0
			Rect frame\x1,frame\y1,frame\x2-frame\x1,frame\y2-frame\y1,0
			text frame\x1+2,frame\y1-2,frame\txt$
		case 5
		  Rect frame\x1-1,frame\y1-1,frame\x2-frame\x1+2,frame\y2-frame\y1+2,0
			Rect frame\x1,frame\y1,frame\x2-frame\x1,frame\y2-frame\y1,0
			if frame\name$ = "ALARMVOLUME" then vol# = alarmvolume
			if frame\name$ = "MUSICVOLUME" then vol# = musicvolume
			Rect frame\x1+1,frame\y1+1,vol#*(frame\x2-frame\x1-2),frame\y2-frame\y1-2,1
		case 6
			FrameLenght# = (frame\y2-1)-(frame\y1+1)
		  Rect frame\x1-1,frame\y1-1,frame\x2-frame\x1+2,frame\y2-frame\y1+2,0
			Rect frame\x1,frame\y1,frame\x2-frame\x1,frame\y2-frame\y1,0

			if frame\name$ = "CONFIG_BAR"  then
				BarLenght# = FrameLenght#/(C_MaxConfigs/float(C_MaxConShown))
				vol# = ConfigEntryOffset/(C_MaxConfigs-float(C_MaxConShown))
			endif 			     			
			Rect frame\x1+1,frame\y1+1+(FrameLenght#-BarLenght#)*vol,frame\x2-frame\x1-2,BarLenght#,1
		case 7
			If Left$(frame\name,6)="PLAYER" Then					
				z%=Mid$(frame\name,8,1)
				Menu_PrintPlayers(z-1,frame\x1,frame\y1)
			elseIf Left$(frame\name,6)="CONFIG" Then					
				z%=right$(frame\name,1)
				if ConfigEntryChoosed=z then
					color 69,152,117
					if Cursor_Counter<30 then	
						Text frame\x1+30,frame\y1, frame\txt$+"|"
					else
						Text frame\x1+30,frame\y1, frame\txt$
					endif
				else
					Text frame\x1+30,frame\y1, Array_Configs(ConfigEntryOffset+z-1)
				endif
				Text frame\x1,frame\y1, (ConfigEntryOffset+z)
			elseif Frame\Name$="P_NAME"
				if (Cursor_Mode=1) then color 69,152,117
				if Cursor_Counter<30 and (Cursor_Mode=1) then
					Text frame\x1+20,frame\y1-2,Frame\txt$+"|"
				else
					text frame\x1+20,frame\y1-2,frame\txt$		
				endif
				Color 202,15,43
				text frame\x1+frame\TextOffset,frame\y1-2,"Name"
			elseif Frame\Name$="NETCHAT"
				If Cursor_Mode=0 Then
	      	color 69,152,117	
					If Cursor_Counter<30 Then
						Text frame\x1,frame\y1,">"+Net_chat$+"_"
					Else
						Text frame\x1,frame\y1,">"+Net_chat$
					endif
				else
					Text frame\x1,frame\y1,">"+Net_chat$
				EndIf
			elseif Frame\Name$="START" or Frame\Name$="STARTLOCAL"
				DrawImage Im_Buttons,frame\x1,frame\y1,2+active
			elseif Frame\Name$="ESCAPE" or Frame\Name$="CREDITS"
				DrawImage Im_Buttons,frame\x1,frame\y1,4+active	
			elseif Frame\Name$="QUIT"
				DrawImage Im_Buttons,frame\x1,frame\y1,0+active
			elseif Frame\Name$="HIGHSCORES"
				DrawImage Im_Buttons,frame\x1,frame\y1,6+active
			elseif Frame\Name$="STARTSERVER"
				DrawImage Im_Buttons,frame\x1,frame\y1,8+active
			elseif Frame\Name$="JOINGAME"
				DrawImage Im_Buttons,frame\x1,frame\y1,10+active
			endif
		
		case 8
			Text frame\x1+5,frame\y1+2,GetInputAscii(Frame\Name$)
		end select
	Next
	
End Function


;------------------------------------------------------------------------------------- FindFrame
Function Menu_FindFrame( name$ )
	For Frame.T_Frame=Each T_Frame
		If Frame\Name=name$ Then 
			Return True
		EndIf
	Next
	Return False
End Function


;----------------------------------------------------------------------------------- B_AddPlayer
Function Menu_AddPlayer(name$,Comp$,CompId,Team,Hero,Device)
	Name$=Trim$(Name$)

	If (MaxPlayer>=9) Then Return False
		
	For Net_Player=Each T_NetPlayer
		If Net_Player\Name$=Name$ Then Return False
	Next
	Net_Player=New T_NetPlayer
	Net_Player\Name$=name$
	Net_Player\CompName=Comp$
	Net_Player\CompID=CompId
	Net_Player\Hero=Hero
	Net_Player\Team=Team
	Net_Player\Device=Device
	
	Net_Player\DevCodeLeft1 = InpDeviceCode(0,0)
	Net_Player\DevCodeLeft2 = InpDeviceCode(6,0)
	Net_Player\DevCodeLeft3 = InpDeviceCode(12,0)
	Net_Player\DevCodeLeft4 = InpDeviceCode(18,0)
	
	Net_Player\DevCodeRight1 = InpDeviceCode(1,0)
	Net_Player\DevCodeRight2 = InpDeviceCode(7,0)
	Net_Player\DevCodeRight3 = InpDeviceCode(13,0)
	Net_Player\DevCodeRight4 = InpDeviceCode(19,0)
	
	Net_Player\DevCodeUp1 = InpDeviceCode(2,0)
	Net_Player\DevCodeUp2 = InpDeviceCode(8,0)
	Net_Player\DevCodeUp3 = InpDeviceCode(14,0)
	Net_Player\DevCodeUp4 = InpDeviceCode(20,0)
	
	Net_Player\DevCodeDown1 = InpDeviceCode(3,0)
	Net_Player\DevCodeDown2 = InpDeviceCode(9,0)
	Net_Player\DevCodeDown3 = InpDeviceCode(15,0)
	Net_Player\DevCodeDown4 = InpDeviceCode(21,0)

	Net_Player\DevCodeBomb1 = InpDeviceCode(4,0)
	Net_Player\DevCodeBomb2 = InpDeviceCode(10,0)
	Net_Player\DevCodeBomb3 = InpDeviceCode(16,0)
	Net_Player\DevCodeBomb4 = InpDeviceCode(22,0)

	Net_Player\DevCodePause1 = InpDeviceCode(5,0)
	Net_Player\DevCodePause2 = InpDeviceCode(11,0)
	Net_Player\DevCodePause3 = InpDeviceCode(17,0)
	Net_Player\DevCodePause4 = InpDeviceCode(23,0)
		
	MaxPlayer=MaxPlayer + 1
	
	Return True
End Function


;----------------------------------------------------------------------------------- HandleMouse
Function Menu_HandleMouse()
	xmouse=MouseX():ymouse=MouseY()
	
	Mouse_Click$=""


  
	if click_lock > 0
		click_lock = click_lock-1
	else
		If MouseDown(1) = 0 : first_click = true
	  elseIf MouseDown(1) and ((millisecs()-mouse_oldtime) > mouse_time or first_click) Then
			For Frame = Each T_Frame
				If (xmouse>=Frame\x1) And (xmouse<=Frame\x2) And (ymouse>=Frame\y1) And (ymouse<=Frame\y2)
					if (Frame\locked = 0) then Mouse_Click$=Frame\Name$
				endif				
			Next		
			MouseHitx = xmouse
			MouseHity = ymouse
			if first_click
				mouse_time = 700
				first_click = false
			else mouse_time = 80
		endif  		
					
		mouse_oldtime = millisecs()
		EndIf
	endif
	
	Color 255,255,255
	DrawImage Im_Mouse,xmouse,ymouse
	Color 100,100,100
	Line 0,ymouse,800,ymouse
	Line xmouse,0,xmouse,600
;	if Net_Type = 1
;		Color 202,15,43
;		text xmouse_host+13,ymouse_host,"Host",0,1
;		Line xmouse_host,ymouse_host,xmouse_host+10,ymouse_host
;		Line xmouse_host,ymouse_host,xmouse_host+5,ymouse_host+3
;		Line xmouse_host,ymouse_host,xmouse_host+5,ymouse_host-3
;		if(mouseclick_host)
;			mouseclick_host = false	
;			MouseHitx = xmouse_host
;			MouseHity = ymouse_host
;		endif
;	endif
	
	If Mouse_Click$<>"" Then Menu_HandleEvent(Mouse_Click$)
	
End Function


;------------------------------------------------------------------------------------ HandleEvent
Function Menu_HandleEvent(Event$)

	If Left$(Event,1)="!" Then					; Change MaxItems?
		z%=Mid$(Event,2,2)
		If Right$(Event,2)="UP" Then
			If MaxItems(z)=99 Then
				MaxItems(z)=0
			elseIf MaxItems(z)>=50 Then
				MaxItems(z)=99
			Else
				MaxItems(z)=MaxItems(z)+1
			EndIf
		Else
			If MaxItems(z)<=0 Then
				MaxItems(z)=99
			elseif MaxItems(z)>=99
				MaxItems(z)=50
			Else
				MaxItems(z)=MaxItems(z)-1
			EndIf
		EndIf
		PlayWav(WAV_MouseClick,0,0)
		
	elseIf Left$(Event$,6)="PLAYER" Then			; Kill a Player?

		z%=Right$(Event$,1)
		For Net_Player= Each T_NetPlayer
			If (z=1) And (Net_Player\CompID=Net_MyNetID) Then
;				If Net_Type=2 Then SendNetMsg(9,Event$,Net_MyNetID,0,0)
				If Net_Type<>0 Then
					dat$=LSet(Net_Player\CompID,10)
					dat$=dat$+LSet(Net_Player\CompName$,10)
					dat$=dat$+LSet(Net_Player\Name$,40)

					SendNetMsg(11,dat$,Net_MyNetID,0,True)

				EndIf
				PlayWav(WAV_MouseClick,0,0)
				menu_findframe("P_NAME")
				frame\txt$     = Net_Player\name$
				B_PlayerTeam   = Net_Player\team
				B_PlayerHero   = Net_Player\hero
				B_PlayerDevice = Net_Player\device
				
				InpDeviceCode(0,0) = Net_Player\DevCodeLeft1
				InpDeviceCode(6,0) = Net_Player\DevCodeLeft2
				InpDeviceCode(12,0)= Net_Player\DevCodeLeft3
				InpDeviceCode(18,0)= Net_Player\DevCodeLeft4
	
				InpDeviceCode(1,0) = Net_Player\DevCodeRight1
				InpDeviceCode(7,0) = Net_Player\DevCodeRight2
				InpDeviceCode(13,0)= Net_Player\DevCodeRight3
				InpDeviceCode(19,0)= Net_Player\DevCodeRight4
	
				InpDeviceCode(2,0) = Net_Player\DevCodeUp1
				InpDeviceCode(8,0) = Net_Player\DevCodeUp2
				InpDeviceCode(14,0)= Net_Player\DevCodeUp3
				InpDeviceCode(20,0)= Net_Player\DevCodeUp4
	
				InpDeviceCode(3,0) = Net_Player\DevCodeDown1
				InpDeviceCode(9,0) = Net_Player\DevCodeDown2
				InpDeviceCode(15,0)= Net_Player\DevCodeDown3
				InpDeviceCode(21,0)= Net_Player\DevCodeDown4

				InpDeviceCode(4,0) = Net_Player\DevCodeBomb1
				InpDeviceCode(10,0)= Net_Player\DevCodeBomb2
				InpDeviceCode(16,0)= Net_Player\DevCodeBomb3
				InpDeviceCode(22,0)= Net_Player\DevCodeBomb4

				InpDeviceCode(5,0) = Net_Player\DevCodePause1
				InpDeviceCode(11,0)= Net_Player\DevCodePause2
				InpDeviceCode(17,0)= Net_Player\DevCodePause3
				InpDeviceCode(23,0)= Net_Player\DevCodePause4
				
				SetBuffer BackBuffer()
				Delete Net_Player
				MaxPlayer=MaxPlayer-1
				z=99
				Exit
			EndIf
			z=z-1
		Next
	
	elseIf Left$(Event,7)="INPCODE" Then					
		PlayWav(WAV_MouseClick,0,0)
		i=1
		if right(Event,5)="RIGHT"
			i=2
		else if right(Event,2)="UP"
			i=3
		else if right(Event,4)="DOWN"
			i=4
		else if right(Event,4)="BOMB"
			i=5
		else if right(Event,5)="PAUSE"
			i=6	
		endif
			
		j=mid(Event,9,1)
		GetInput	=	(j-1)*6+i
		
	elseIf Left$(Event,12)="INPUT_DEF_LD" Then					
		PlayWav(WAV_MouseClick,0,0)
		LoadDefaultInput(1,right(Event,1))
	elseIf Left$(Event,12)="INPUT_DEF_SV" Then					
		if SaveDefaultInput(right(Event,1))
			PlayWav(WAV_MouseClick,0,0)
		else
			PlayWav(WAV_MouseError,0,0)
		endif	
		
	else	
		Select Event$
		
			case "CONFIG_DELETE"
				if ConfigEntryChoosed<>0
					if HandleConfig("Delete")
						PlayWav(WAV_MouseClick,0,0)
					else
						PlayWav(WAV_MouseError,0,0)
					endif
				else
					PlayWav(WAV_MouseError,0,0)
				endif
				
			case "CONFIG_SAVE"
				if ConfigEntryChoosed<>0
					if HandleConfig("Save")
						PlayWav(WAV_MouseClick,0,0)
					else
						PlayWav(WAV_MouseError,0,0)
					endif
				else
					PlayWav(WAV_MouseError,0,0)
				endif
				
			case "CONFIG_LOAD"
				if ConfigEntryChoosed<>0
					if HandleConfig("Load")
						PlayWav(WAV_MouseClick,0,0)
					else
						PlayWav(WAV_MouseError,0,0)
					endif
				else
					PlayWav(WAV_MouseError,0,0)
				endif
				
			Case "RESET"
				For x=0 To 20				; Set all Items to AUTO
					MaxItems(x)=99
				Next
				PlayWav(WAV_MouseClick,0,0)
			
			Case "GAME_UP"
				Game_Mode=Game_Mode+1
				PlayWav(WAV_MouseClick,0,0)
				If Game_Mode=3 Then Game_Mode=0
	
			Case "GAME_DOWN"
				If Game_Mode=0 Then Game_Mode=3
				Game_Mode=Game_Mode-1
				PlayWav(WAV_MouseClick,0,0)
	
			Case "LEVEL_UP"
				Level=Level+1
				PlayWav(WAV_MouseClick,0,0)
				If Level=3 Then Level=0
	
			Case "LEVEL_DOWN"
				If Level=0 Then Level=3
				Level=Level-1
				PlayWav(WAV_MouseClick,0,0)
	
			Case "WINS_UP"
				WinsNeeded=WinsNeeded+1
				PlayWav(WAV_MouseClick,0,0)
				If WinsNeeded=11 Then WinsNeeded=2
	
			Case "WINS_DOWN"
				If WinsNeeded=2 Then WinsNeeded=11
				WinsNeeded=WinsNeeded-1
				PlayWav(WAV_MouseClick,0,0)
				
			Case "TIME_DOWN"
				If B_Time<=2 Then B_Time=16
				B_Time=B_Time - 1
				PlayWav(WAV_MouseClick,0,0)
	
			Case "TIME_UP"
				B_Time=B_Time + 1
				PlayWav(WAV_MouseClick,0,0)
				If B_Time=16 Then B_Time=1
				
			Case "SHOP"
				Shop_On=Not Shop_On
				PlayWav(WAV_MouseClick,0,0)
				If Wheel_On Then Wheel_On=False
				
			Case "SHRINKING"	
				PlayWav(WAV_MouseClick,0,0)
				Menu_Shrinking_On=Not Menu_Shrinking_On
	
			Case "MUSIC"	
				PlayWav(WAV_MouseClick,0,0)
				Music_On=Not Music_On
			
			Case "MUSICVOLUME"	
				PlayWav(WAV_MouseClick,0,0)
				Menu_FindFrame(event$)
				musicvolume = (float(xmouse)-frame\x1)/(frame\x2-frame\x1-2)
			
			Case "ALARMVOLUME"	
				PlayWav(WAV_MouseClick,0,0)
				Menu_FindFrame(event$)
				alarmvolume = (float(xmouse)-frame\x1)/(frame\x2-frame\x1-2)
					
	    Case "PITCH"	
				PlayWav(WAV_MouseClick,0,0)
				Pitch_On=Not Pitch_On
			
			Case "VIDEO"	
				PlayWav(WAV_MouseClick,0,0)
				Video_On=Not Video_On
				
			Case "ALARM"	
				PlayWav(WAV_MouseClick,0,0)
				Menu_Alarm_On=Not Menu_Alarm_On
				
			Case "SPECIAL"
				PlayWav(WAV_MouseClick,0,0)
				Special_On=Not Special_On
	
			Case "WHEEL"
				If Shop_On Then
					Wheel_On=Not Wheel_On
					PlayWav(WAV_MouseClick,0,0)
				Else
					PlayWav(WAV_MouseError,0,0)
				EndIf
			
			Case "ADD_PLAYER"
				Cursor_Mode=0
				Menu_FindFrame("P_NAME")
				If Menu_AddPlayer(Frame\Txt$,Net_MyName$,Net_MyNetId,B_PlayerTeam,B_PlayerHero,B_PlayerDevice) Then
					
					dat$=LSet(Net_Player\CompID,10)
					dat$=dat$+LSet(Net_Player\CompName$,10)
					dat$=dat$+LSet(Net_Player\Name$,40)
					dat$=dat$+LSet(Net_Player\Team,1)
					dat$=dat$+LSet(Net_Player\Device,1)
					dat$=dat$+LSet(Im_Player(Net_Player\Hero)\File$,30)
					If Net_Type<>0 Then	SendNetMsg(10,Dat$,Net_MyNetID,0,True)
					
					nr 			=  Int(Right$(Frame\Txt$,1))
					lenght 	=  len(Frame\Txt$)
					if nr>0 and nr<=9 then
						if nr = 9 then nr = 0
						lenght = lenght-1
					endif					
					Frame\Txt$=Left$(Frame\Txt$,lenght)+(nr+1)
					PlayWav(WAV_MouseClick,0,0)
					
				Else
					PlayWav(WAV_MouseError,0,0)
				EndIf
	
	    Case "GET_JOY"
				PlayWav(WAV_MouseClick,0,0)
				GetJoy=True
				
			Case "P_NAME"
				if Cursor_Mode<>1
					PlayWav(WAV_MouseClick,0,0)
					Cursor_Mode=1
				endif
				
			Case "P_TEAM_UP"
				PlayWav(WAV_MouseClick,0,0)
				B_PlayerTeam=B_PlayerTeam + 1
				If B_PlayerTeam=4 Then B_PlayerTeam=0
	
			Case "P_TEAM_DOWN"
				If B_PlayerTeam=0 Then B_PlayerTeam=4
				PlayWav(WAV_MouseClick,0,0)
				B_PlayerTeam=B_PlayerTeam - 1
	
			Case "P_HERO_UP"
				PlayWav(WAV_MouseClick,0,0)
				B_PlayerHero=B_PlayerHero + 1
				If B_PlayerHero>MaxPlayerImage Then B_PlayerHero=0
	
			Case "P_HERO_DOWN"
				PlayWav(WAV_MouseClick,0,0)
				If B_PlayerHero=0 Then B_PlayerHero=MaxPlayerImage+1
				B_PlayerHero=B_PlayerHero - 1
	
			Case "P_DEVICE_UP"
				PlayWav(WAV_MouseClick,0,0)
				B_PlayerDevice=B_PlayerDevice + 1
				If B_PlayerDevice = 1
					LoadDefaultInput(0)
				elseIf B_PlayerDevice>=10
					B_PlayerDevice=0
					LoadDefaultInput(0)
				endif
	
			Case "P_DEVICE_DOWN"
				PlayWav(WAV_MouseClick,0,0)
				B_PlayerDevice=B_PlayerDevice - 1
				if B_PlayerDevice=0
					LoadDefaultInput(0)
				elseIf B_PlayerDevice<0
					B_PlayerDevice=9
					LoadDefaultInput(0)
				endif
				
				
			Case "CONFIG_UP"
				if ConfigEntryOffset<=0 then
					PlayWav(WAV_MouseError,0,0)
				else
					ConfigEntryOffset = ConfigEntryOffset-1
					PlayWav(WAV_MouseClick,0,0)
				endif
				
			Case "CONFIG_DOWN"
				if ConfigEntryOffset>=C_MaxConfigs-C_MaxConShown then
					PlayWav(WAV_MouseError,0,0)
				else
					ConfigEntryOffset = ConfigEntryOffset+1
					PlayWav(WAV_MouseClick,0,0)
				endif
			
			Case "CONFIG_BAR"
				PlayWav(WAV_MouseClick,0,0)
	      Menu_FindFrame(event$)
				FrameLenght# = (frame\y2-1)-(frame\y1+1)
				BarLenght# = FrameLenght#/(C_MaxConfigs/float(C_MaxConShown))
					
				ConfigEntryOffset = (ymouse-(frame\y1+BarLenght#/2))/(FrameLenght#-BarLenght#)*(C_MaxConfigs-C_MaxConShown)
				if ConfigEntryOffset<0 then
					ConfigEntryOffset=0
				elseif ConfigEntryOffset > (C_MaxConfigs-C_MaxConShown)
					ConfigEntryOffset=(C_MaxConfigs-C_MaxConShown)
				endif
				
			Case "NETCHAT"
				if Cursor_Mode<>0
					PlayWav(WAV_MouseClick,0,0)
					Cursor_Mode=0
				endif	
		End Select
	endif
	
	If Left$(Event$,7)="CONFIG-" Then
		if ConfigEntryChoosed <> Right$(Event$,1)	
			ConfigEntryChoosed = Right$(Event$,1)
			PlayWav(WAV_MouseClick,0,0)
			menu_findframe("CONFIG-"+ConfigEntryChoosed)
			frame\txt$=Array_Configs$(ConfigEntryChoosed+ConfigEntryOffset-1)
			Cursor_Mode = 3
		endif
	else
		ConfigEntryChoosed = 0	
	endif
	
	
	If Net_Type=2 Then NET_Broadcast("GAMEDATA")

End Function


;---------------------------------------------------------------------------------- PrintPlayers
Function Menu_PrintPlayers(nr,xpos,ypos)

	Net_Player = first T_NetPlayer
	
	if Net_Player <> null
		for x=1 to nr
			Net_Player = after Net_Player
			if Net_Player = null then return
		next
		If Net_Player\CompId=Net_MyNetID Then Text xpos+2,ypos-3,"*"
		Text xpos+12,ypos-3,Net_Player\Name$
		Text xpos+192,ypos-3,Net_Player\CompName$
		Text xpos+259,ypos-3,Array_Team$(Net_Player\Team)
		Text xpos+325,ypos-3,Im_Player(Net_Player\Hero)\Name$
		Text xpos+437,ypos-3,Array_Device$(Net_Player\Device)
	endif

End Function


;------------------------------------------------------------------------------------- PrintItem
Function Menu_PrintItem(x,y,z)
	If MaxItems(z)=99 Then
		Text x,y,"auto"
	Else
		Text x,y,MaxItems(z)
	EndIf
End Function

;------------------------------------------------------------------------------------- DrawBombs
Function Menu_DrawBombs(action$,action2$="")

	if action = "init" then ;Create Bomb Data
	
		;Blue
		MenuBlue  = new T_MenuBlue
		MenuBlue\posx  = -20
		MenuBlue\posy  = rand(C_ScreenY)
		MenuBlue\frame = 0
		MenuBlue\timer = millisecs()
		MenuBlue\explode  = 0
		MenuBlue\want_explode  = 0
		
		MenuBlue\Image = loadanimimage("gfx\menu_blue.png",25, 25,0,8)
		maskimage MenuBlue\Image,0,128,0
		midhandle MenuBlue\Image
		
		MenuBlue\Sound = loadsound("player\blue.mp3")
		
		;Red Bomb
		MenuRedBomb  = new T_MenuRedBomb
		MenuRedBomb\posx  = -30
		MenuRedBomb\posy  = rand(C_ScreenY)
		MenuRedBomb\speedx= 2
		MenuRedBomb\speedy= 0
		MenuRedBomb\accx  = 0
		MenuRedBomb\accy  = 0
		MenuRedBomb\anim  = I_Bomb2Right
		MenuRedBomb\timer = millisecs()
		MenuRedBomb\explode  	= 0	
		
		Im_MenuRedBombExplode = loadanimimage("gfx\explosion 150x150x19.png",150,150,0,19)
		scaleimage 	Im_MenuRedBombExplode,2,2
	  midhandle   Im_MenuRedBombExplode
	  
		;Bombs
		For x=0 To C_MaxMenuBombs-1
			MenuBomb(x) = New T_MenuBomb
			MenuBomb(x)\posx  = rand(C_ScreenX)
			MenuBomb(x)\posy  = rand(C_ScreenY)
			MenuBomb(x)\frame = rand(7)
			MenuBomb(x)\dist  = ((6) * (1-1.04^-x))  +1
		next
		
		Im_MenuBomb = loadanimimage("gfx\menubombs.png",33,33,0,56)
		maskimage Im_MenuBomb,0,128,0
		midhandle Im_MenuBomb
		
		Im_MenuBombExplode(0) = loadanimimage("gfx\explosion 150x150x19.png",150,150,0,19)
		Im_MenuBombExplode(1) = loadanimimage("gfx\explosion 120x120x19.png",120,120,0,19)
		Im_MenuBombExplode(2) = loadanimimage("gfx\explosion 90x90x19.png",   90, 90,0,19)
		Im_MenuBombExplode(3) = loadanimimage("gfx\explosion 60x60x19.png",   60, 60,0,19)
		Im_MenuBombExplode(4) = loadanimimage("gfx\explosion 45x45x19.png",   45, 45,0,19)
		Im_MenuBombExplode(5) = loadanimimage("gfx\explosion 30x30x19.png",   30, 30,0,19)
		Im_MenuBombExplode(6) = loadanimimage("gfx\explosion 15x15x19.png",   15, 15,0,19)
		
		for x=0 to 6
			midhandle Im_MenuBombExplode(x)
		next
		
		BombSound    = loadsound("sfx\implosion.mp3")
		BombSoundRed = loadsound("sfx\redexplode.mp3")
		
		;Mousepointer
		Im_MousePointer		    = createimage(1,1,1,1)
		maskimage Im_MousePointer,255,255,255
		


	elseif action = "update"
	
			
		;Blue
		draw_blue = true
		for x = C_MaxMenuBombs-1 to 0 step -1	
			
			if draw_blue = true and MenuBomb(x)\dist = 3 and MenuBlue\timer +50000 < millisecs() then
				draw_blue = False
				
				if MenuBlue\want_explode
					if channelplaying (MenuBlue\SoundID) = False
						MenuBlue\frame    = 0
						MenuBlue\explode  = true
						MenuBlue\want_explode  = False
						MenuBlue\SoundID=Playsound (BombSound)
					endif	
				endif
				
				if MenuBlue\explode
					DrawImage Im_MenuBombExplode(3),MenuBlue\posx,MenuBlue\posy,MenuBlue\frame
				else
					DrawImage MenuBlue\Image, MenuBlue\posx,MenuBlue\posy,MenuBlue\frame
				endif
				
				if MenuBlue\posx > C_ScreenX + 20 or MenuBlue\frame >= 18 then
					MenuBlue\posx 		= -20
					MenuBlue\posy 		= rand(C_ScreenY)
			    MenuBlue\frame		= 0
			    MenuBlue\timer    = millisecs()
			    MenuBlue\explode  = 0
			    MenuBlue\want_explode  = 0
				else
					MenuBlue\posx  = MenuBlue\posx  + 1.7
				endif
								
			endif
		  
			if MenuBomb(x)\explode
				DrawImage Im_MenuBombExplode(MenuBomb(x)\dist-1),MenuBomb(x)\posx,MenuBomb(x)\posy,MenuBomb(x)\frame
			else
			  if action2<>"explodeallupdate" THEN DrawImage Im_MenuBomb,MenuBomb(x)\posx,MenuBomb(x)\posy,MenuBomb(x)\frame+(MenuBomb(x)\dist-1)*8
			endif
		  if MenuBomb(x)\dist = 7 then
				MenuBomb(x)\posx = MenuBomb(x)\posx + 0.15
			else
				MenuBomb(x)\posx = MenuBomb(x)\posx + 2.0/MenuBomb(x)\dist
			endif
      if MenuBomb(x)\posx > C_ScreenX + 70 or MenuBomb(x)\frame >= 18 then
				MenuBomb(x)\posx 		= rand(-40,-100)
				MenuBomb(x)\posy 		= rand(C_ScreenY)
		    MenuBomb(x)\frame		= rand(7)
		    MenuBomb(x)\explode = false
			endif				
		next

		;Red
		if MenuRedBomb\timer +40000 < millisecs()
			if MenuRedBomb\explode
				DrawImage Im_MenuRedBombExplode,MenuRedBomb\posx,MenuRedBomb\posy,MenuRedBomb\Anim
				MenuRedBomb\speedx=0
				MenuRedBomb\speedy=0
			else
		  	if action2<>"explodeallupdate" THEN DrawImage Im_Items,MenuRedBomb\posx,MenuRedBomb\posy,Anim_Items(MenuRedBomb\anim)\Frame
			endif
			diffx# = xmouse - MenuRedBomb\posx
			diffy# = ymouse - MenuRedBomb\posy
			abstand# = sqr(diffx^2 + diffy^2)
			if abstand < 50 and abstand <>0
				MenuRedBomb\accx = MenuRedBomb\accx - 0.005*(diffx/abstand*(50-abstand))
				MenuRedBomb\accy = MenuRedBomb\accy - 0.005*(diffy/abstand*(50-abstand))
			else
				MenuRedBomb\accx = 0
				MenuRedBomb\accy = 0
			endif
			MenuRedBomb\speedx = MenuRedBomb\speedx + MenuRedBomb\accx
			MenuRedBomb\speedy = MenuRedBomb\speedy + MenuRedBomb\accy
			
			MenuRedBomb\posx = MenuRedBomb\posx + MenuRedBomb\speedx
			MenuRedBomb\posy = MenuRedBomb\posy + MenuRedBomb\speedy
			
	    if MenuRedBomb\posx > C_ScreenX + 100 or MenuRedBomb\posx < -100 or MenuRedBomb\posy > C_ScreenY + 100 or MenuRedBomb\posy < -100 or (MenuRedBomb\Anim >= 18 and MenuRedBomb\explode = true) then
					MenuRedBomb\posx  = -30
					MenuRedBomb\posy  = rand(C_ScreenY)
					MenuRedBomb\speedx= 2
					MenuRedBomb\speedy= 0
					MenuRedBomb\accx  = 0
					MenuRedBomb\accy  = 0
					MenuRedBomb\timer = millisecs()
					MenuRedBomb\explode  	= 0
					MenuRedBomb\anim  = I_Bomb2Right
			endif
		endif		
		

    if MouseHitx <> -1 or action2="explodeall" then
			for x = 0 to C_MaxMenuBombs-1
				if MenuBomb(x)\explode = 0
					if (MouseHitx < MenuBomb(x)\posx+15  and MouseHitx > MenuBomb(x)\posx-15  and	MouseHity < MenuBomb(x)\posy+15  and 	MouseHity > MenuBomb(x)\posy-15) or action2="explodeall" then
				  	if imagescollide(Im_MenuBomb,MenuBomb(x)\posx,MenuBomb(x)\posy,MenuBomb(x)\frame+(MenuBomb(x)\dist-1)*8,Im_MousePointer,MouseHitx,MouseHity,0)  or action2="explodeall"
							MenuBomb(x)\frame    = 0
	      			MenuBomb(x)\explode  = true
							if action2<>"explodeall" then
								BombSoundID=Playsound (BombSound)
	      				channelvolume BombSoundID,1.0/(MenuBomb(x)\dist)
								exit
							endif
						endif
					endif
				endif
			next
			if MenuBlue\explode = 0 and MenuBlue\want_explode = 0
				if action2<>"explodeall"
					if imagescollide(MenuBlue\Image,MenuBlue\posx,MenuBlue\posy,MenuBlue\frame,Im_MousePointer,MouseHitx,MouseHity,0)  or action2="explodeall"
      			MenuBlue\want_explode  = true
						MenuBlue\SoundID=Playsound (MenuBlue\Sound)
					endif
				else
				 	MenuBlue\explode=true
				 	MenuBlue\frame    = 0
				endif
			endif
			if MenuRedBomb\explode = 0
				if sqr((MenuRedBomb\posx -MouseHitx)^2 + (MenuRedBomb\posy -MouseHity)^2) < 15 or action2="explodeall"
						MenuRedBomb\explode  = true
						MenuRedBomb\Anim		 = 0
						if action2<>"explodeall" then
							playsound BombSoundRed
							wobblescreen_cnt = 120
						endif						
				endif
			endif			
		MouseHitx = -1
		endif	

		;Frames				
		if bomb_frametimer+60 < millisecs()
			bomb_frametimer = millisecs()
			;Bombs
			for x = 0 to C_MaxMenuBombs-1
				MenuBomb(x)\frame = MenuBomb(x)\frame +1
				if MenuBomb(x)\frame >= 8 and MenuBomb(x)\explode = false then MenuBomb(x)\frame = 0
			next
			;Blue
			MenuBlue\frame = MenuBlue\frame+1
			if MenuBlue\frame >= 8 and MenuBlue\explode = false then MenuBlue\frame = 0
			
			;Red Bomb
			if MenuRedBomb\explode
				if MenuRedBomb\anim < 18
					MenuRedBomb\anim = MenuRedBomb\anim+1
				endif
			else
				MenuRedBomb\anim = Anim_Items(MenuRedBomb\anim)\NextItem
			endif
		endif
		
	elseif action="cleanup"
		freeimage Im_MenuBomb
		for x = 0 to 7
			freeimage Im_MenuBombExplode(x)
		next
		freeimage Im_MenuRedBombExplode
		freeimage MenuBlue\Image
		FreeImage Im_MousePointer
		freesound BombSound
		freesound BombSoundRed
		freesound MenuBlue\Sound
		Delete Each T_MenuBomb
		Delete Each T_MenuBlue
		Delete Each T_MenuRedBomb 	
	endif
End Function	
	
	
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
Function Shop_Shop()


	ShopPlayer=Player\Nr

	Player\X=400
	Player\Y=200
	Mouse_Click$=""
	gSubtract=0
	
	Im_Image=LoadImage("gfx\Shop2.png")
	SetFont Font_24
	Color 255,255,255
	SetBuffer BackBuffer()

	Menu_CreateFrame(650,20,710,80,"START","")

	Menu_CreateFrame(50,100,83,133,"FIRE","")
	Menu_CreateFrame(50,150,83,183,"FIST","")
	Menu_CreateFrame(50,200,83,233,"BOMB","")
	Menu_CreateFrame(50,250,83,283,"KICKIT","")
	Menu_CreateFrame(50,300,83,333,"SUPERMAN","")

	Menu_CreateFrame(666,100,700,133,"SPEED","")
	Menu_CreateFrame(666,150,700,183,"GHOST","")
	Menu_CreateFrame(666,200,700,233,"CONTROLLER","")
	Menu_CreateFrame(666,250,700,283,"TIMEBOMB","")
	Menu_CreateFrame(666,300,700,333,"YINYANG","")
	
	Menu_CreateFrame( 20,520, 60,570,"PLAYER1","")
	Menu_CreateFrame(110,520,150,570,"PLAYER2","")
	Menu_CreateFrame(200,520,240,570,"PLAYER3","")
	Menu_CreateFrame(290,520,330,570,"PLAYER4","")
	Menu_CreateFrame(380,520,420,570,"PLAYER5","")
	Menu_CreateFrame(470,520,510,570,"PLAYER6","")
	Menu_CreateFrame(560,520,600,570,"PLAYER7","")
	Menu_CreateFrame(650,520,690,570,"PLAYER8","")
	Menu_CreateFrame(740,520,780,570,"PLAYER9","")

	
	Font=LoadFont("Comic Sans MS",15,False)
	SetFont Font
	

  
	flushkeys
	While (Mouse_Click$<>"START" Or (gSubtract>0)) and (not keyhit(1))

  	Color 255,255,255
		DrawBlock Im_Image,0,0
    ;update_fire()
    
		Menu_DrawFrames()
		
		For z=0 To MaxPlayer-1
			If z+1<>Player\Nr Then
				For P.T_Player=Each T_Player
					If P\Nr=Z+1 Then 
						DrawImage Im_Player(P\Image)\Image,40+(z*90),540,0
						Text 40+(z*90),567,P\Name$,True
						Text 40+(z*90),582,P\Coins,True
						Exit
					EndIf
				Next
			EndIf
		Next

		fy#=0								; Draw Coins !
		fH#=0
		While Player\Coins>fY
			fH#=fH+1
			fy#=(fH / 2)*(fH+1)
		Wend
		Z=fH;3

		fY#=0
		fH#=0
		q=Player\Coins
		While fH<=Z
			F=Z-fH
			For x=1 To F
				If q>0 Then 
					DrawImage Im_Items,383-(F*(C_ItemX/2))+(x*C_ItemX),460-(fH*C_ItemY),98
					q=q-1
				EndIf
			Next
			fH#=fH+1
			fy#=(fH / 2)*(fH+1)
		Wend

		
		DrawImage Im_Player(Player\Image)\Image,400,100,0
		Text 400,50,Player\Name$,True
					
		Shop_HandleCursor()

		Shop_HandleIO()
		SCREENSHOT()


		Flip True;Net_Type<>1

		If gSubtract>1 Then
			PlayWav(Wav_PUp_Coin,0,0)
			Player\Coins=Player\Coins-1
			If Net_Type=2 Then 
				NET_Broadcast("SHOPDATA")
				NET_Broadcast("PLAYERS")
			EndIf
		EndIf
		If gSubtract>0 Then
			gSubtract=gSubtract-1
			;Sleep(300)
		EndIf
		
;		If KeyDown(1) Then 
;			Mouse_Click$="START"
;			If Net_Type<>0 Then	SendNetMsg(99,"START",Net_MyNetID)
;		EndIf
		
		If Player\Coins=0 Then Mouse_Click$="START"
		
	Wend

	PlayWav(WAV_MouseClick,0,0)
	

	
	Delete Each T_Frame					; remove frames

	FreeImage Im_Image
	FreeFont Font
  
End Function

;------------------------------------------------------------------------------------------ Shop
Function Shop_Joiner()

	SetStatus(C___SHOP)
	If Wheel_On=False
  	Playsong("music\other\spring_jump.mp3")
	endif
	
	Mouse_Click$=""

	Im_Image=LoadImage("gfx\Shop2.png")
	SetFont Font_24
	Color 255,255,255
	SetBuffer BackBuffer()

	Font=LoadFont("Comic Sans MS",15,False)
	SetFont Font

	While (GameStatus=C___SHOP)

		DrawBlock Im_Image,0,0

		Menu_DrawFrames()

		Player=Null
		For Player=Each T_Player
			If Player\Nr=ShopPlayer Then Exit
		Next

		If Player<>Null Then

			Color 255,255,255
			DrawImage Im_Player(Player\Image)\Image,400,50,0
			Text 400,90,Player\Name$,True

			For z=0 To MaxPlayer-1
				If z+1<>Player\Nr Then
					For P.T_Player=Each T_Player
						If P\Nr=Z+1 Then 
							DrawImage Im_Player(P\Image)\Image,40+(z*90),540,0
							Text 40+(z*90),567,P\Name$,True
							Text 40+(z*90),582,P\Coins,True
							Exit
						EndIf
					Next
				EndIf
			Next

			fy#=0								; Draw Coins !
			fH#=0
			While Player\Coins>fY
				fH#=fH+1
				fy#=(fH / 2)*(fH+1)
			Wend
			Z=fH;3
	
			fY#=0
			fH#=0
			q=Player\Coins
			While fH<=Z
				F=Z-fH
				For x=1 To F
					If q>0 Then 
						DrawImage Im_Items,383-(F*(C_ItemX/2))+(x*C_ItemX),460-(fH*C_ItemY),98
						q=q-1
					EndIf
				Next
				fH#=fH+1
				fy#=(fH / 2)*(fH+1)
			Wend
				
			Shop_HandleCursor()

		EndIf
		
		Shop_HandleIO()

		Flip False;Net_Type=0
		WaitTimer(Timer)

	Wend

	PlayWav(WAV_MouseClick,0,0)

	Playsong("")	
	
	Delete Each T_Frame					; remove frames

	FreeImage Im_Image
	FreeFont Font

	ShopPlayer=0

End Function


;----------------------------------------------------------------------------------- HandleInput
Function Shop_HandleCursor()

	If gSubtract<>0 Then Return
	
	If Net_Type<>1 Then				; Host ?
		If (Player\Keys And 1) Then 
			Player\y = Player\y - Player\yy
			If Player\yy<10 Then Player\yy=Player\yy + 1
		Else
			If (Player\Keys And 4) Then 
				Player\y = Player\y + Player\yy
				If Player\yy<10 Then Player\yy=Player\yy + 1
			Else
				Player\yy=0
			EndIf
		EndIf

		If (Player\Keys And 2) Then 
			Player\x = Player\x + Player\xx
			If Player\xx<10 Then Player\xx=Player\xx + 1
		Else
			If (Player\Keys And 8) Then 
				Player\x = Player\x - Player\xx
				If Player\xx<10 Then Player\xx=Player\xx + 1
			Else
				Player\xx=0
			EndIf
		EndIf
	
		If Player\x>C_ScreenX Then Player\X=C_ScreenX
		If Player\x<0 Then Player\X=0
		If Player\y>C_ScreenY Then Player\Y=C_ScreenY
		If Player\y<0 Then Player\Y=0


		x=Player\X
		y=Player\Y
		B=Player\Keys And 16
	
		If Mouse_Click$<>"" Then
			If Left$(Mouse_Click$,1)<>" " Then Mouse_Click$=""
		EndIf
	
		If B Then
			For Frame = Each T_Frame
				If (x>=Frame\x1) And (x<=Frame\x2) And (y>=Frame\y1) And (y<=Frame\y2) Then Mouse_Click$=Frame\Name$
			Next
		EndIf

		Color 255,255,255
		DrawImage Im_Mouse,x,y
		Color 100,100,100
		Line 0,y,800,y
		Line x,0,x,600

		If Mouse_Click$<>"" Then Mouse_Click$=" "+Trim$(Mouse_Click$)
		If (B=0) And (Mouse_Click$<>"") Then
			Mouse_Click$=Trim$(Mouse_Click$)
		EndIf
	
		Select Mouse_Click$
			Case "BOMB"									; PowerUp - Bomb
				If Player\Coins>=2 Then
					gSubtract=2
					If Player\BombKind<>0 Then
						Player\BombKind=0
						Player\TimeBomb=0
					EndIf
					PlayWav(Wav_PUp_Bomb,0,Player\X)
					Player\Bombs = Player\Bombs + 1
				EndIf

			Case "FIRE"									; PowerUp - Fire
				If Player\Coins>=1 Then
					gSubtract=1
					PlayWav(Wav_PUp_Fire,0,Player\X)
					Player\Fire = Player\Fire + 1
				EndIf

			Case "SPEED"								; PowerUp - Speed
				If Player\Coins>=3 Then
					gSubtract=3
					If Player\Speed<Player_MaxSpeed Then
						PlayWav(Wav_PUp_Speed,0,Player\X)
						Player\Speed = Player\Speed + 1
					EndIf
				EndIf

			Case "KICKIT"								; PowerUp - KickBomb
				If Player\Coins>=2 Then
					gSubtract=2
					Player\CanKickBombs=(Player\CanKickBombs*19)+1
					PlayWav(Wav_PUp_KickBomb,0,Player\X)
				EndIf

			Case "TIMEBOMB"								; PowerUp - TimeBomb
				If Player\Coins>=4 Then
					gSubtract=4
				If Player\BombKind<>1 Then
					Player\BombKind=1
					Player\TimeBomb=0
				EndIf
				PlayWav(Wav_PUp_TimeBomb,0,Player\X)
			EndIf

			Case "YINYANG"								; PowerUp - YinYang
				If Player\Coins>=5 Then
					gSubtract=5
					Player\YinYang=1
					Player\YinYangAnimTimer=0
					Player\YinYangFrame=0
					PlayWav(Wav_PUp_YinYang,0,Player\X)
				EndIf

			Case "FIST"									; PowerUp - Fist
				If Player\Coins>=1 Then
					gSubtract=1
					If Player\Fisttimer=0 Then 
						Player\FistTimer = 200
					Else
						Player\FistTimer = Player\FistTimer + 100
					EndIf
					PlayWav(Wav_PUp_Fist,0,Player\X)
				EndIf

			Case "GHOST"								; PowerUp - Ghost
				If Player\Coins>=3 Then
					gSubtract=3
					Player\YinYang=0
					Player\YinYangAnimTimer=0
					Player\YinYanGFrame=0
					Player\Ghost=141
					Player\GhostFrame=0
					PlayWav(Wav_PUp_Ghost,0,Player\X)
				EndIf

			Case "CONTROLLER"							; PowerUp - Controller
				If Player\Coins>=4 Then
					gSubtract=4
					Player\BombKind=2
					Player\TimeBomb=0
					PlayWav(Wav_PUp_ControlBomb,0,Player\X)
				EndIf

			Case "SUPERMAN"								; PowerUp - Superman
				If Player\Coins>=2 Then
					gSubtract=2
					Player\CanPushWalls=(Player\CanPushWalls*20)+1
					PlayWav(Wav_PUp_Superman,0,Player\X)
				EndIf
		
			Default
				If Player\Coins>0 Then 
					If Left$(Mouse_Click$,6)="PLAYER" Then	; Trade Coins
						z%=Int(Right$(Mouse_Click$,1))
						If z<>Player\Nr Then
							For P.T_Player=Each T_Player
								If P\Nr=z Then
									P\Coins=P\Coins+1
									Player\Coins=Player\Coins-1
									PlayWav(Wav_PUp_Coin,0,0)
									gTraded=True
								EndIf
							Next
						EndIf
					EndIf
				EndIf
		End Select
		If gSubtract<>0 Then gSubtract = gSubtract + 1

	EndIf

	If Net_Type=1 Then						; JOINER
		x=Player\X
		y=Player\Y
		B=Player\Keys And 16
		Color 255,255,255
		DrawImage Im_Mouse,x,y
		Color 100,100,100
		Line 0,y,800,y
		Line x,0,x,600
	EndIf
	
End Function


;----------------------------------------------------------------------------------- HandleIO
Function Shop_HandleIO()

	NET_Listen()
	
	Net_Counter=Net_Counter + 1
	If Net_Counter<3 Then Return		;3
	Net_Counter=0

    If Player<>Null Then
		If Player\NetID=Net_MyNetID Then 			; LOCAL PLAYER ?
			Player\Keys=GetDevice("SHOP")			; get Input
			If Net_Type=1 Then 						; JOINER
				dat$=LSet$(Player\Nr,2)				; build NetString
				dat$=dat$+LSet$(Player\Keys,3)
				SendNetMsg(50,Dat$,Net_MyNetID,Net_HostID,False) ; Send Keycodes to HOST
			EndIf
		EndIf
	EndIf

	If Net_Type=2 Then							; HOST ?
		NET_Broadcast("SHOPDATA")
		NET_Broadcast("PLAYERS")
	EndIf

End Function






;----------------------------------------------------------------------------------- Menu_Create
Function Menu_Create(menu$)

	if Net_Type = 1
		x=1
	else
		x=0
	endif
	select menu
	case "Network"
		Menu_CreateFrame(632,566,702,592,"ESCAPE","",7)
		Menu_CreateFrame(545,566,615,592,"QUIT","",7)
		Menu_CreateFrame(704,156,794,180,"ADD_PLAYER","Add Player",4)
		Menu_CreateFrame(538,156,603,180,"GET_JOY","GetJoy",4)
		Menu_CreateFrame(611,156,696,180,"INP_CONFIG","JoyConfig",4)
		Menu_CreateFrame(615,31,784,56,"P_NAME",B_PlayerName$,7,0,-52)
		Menu_CreateFrame(545,520,780,547,"NETCHAT","",7)
		Menu_CreateFrame(615,58      ,612+16,58+7    ,"P_HERO_UP","Hero",2,0,-52)
		Menu_CreateFrame(615,58+10+1 ,612+16,58+20-2 ,"P_HERO_DOWN","",3)
		Menu_CreateFrame(615,58+20+7 ,612+16,58+30+4 ,"P_TEAM_UP","Team",2,0,-52)
		Menu_CreateFrame(615,58+30+8 ,612+16,58+40+5 ,"P_TEAM_DOWN","",3)
		Menu_CreateFrame(615,58+40+14,612+16,58+50+11,"P_DEVICE_UP","Input",2,0,-52)
		Menu_CreateFrame(615,58+50+15,612+16,58+60+12,"P_DEVICE_DOWN","",3)
	
	  Menu_CreateFrame(784,194      ,797,201    ,"CONFIG_UP","",2)
	  Menu_CreateFrame(784,353      ,797,360    ,"CONFIG_DOWN","",3)
	  Menu_CreateFrame(784,207      ,797,347,"CONFIG_BAR","",6)
	  
	  Menu_CreateFrame(538,340,538+59,340+20,"CONFIG_DELETE","Delete",4)
	  Menu_CreateFrame(684,340,684+42,340+20,"CONFIG_LOAD","Load",4)
	  Menu_CreateFrame(734,340,734+42,340+20,"CONFIG_SAVE","Save",4)
	  Menu_CreateFrame(540,190+(24*1),760,210+(24*1),"CONFIG-1","",7)
	  Menu_CreateFrame(540,190+(24*2),760,210+(24*2),"CONFIG-2","",7)
	  Menu_CreateFrame(540,190+(24*3),760,210+(24*3),"CONFIG-3","",7)
	  Menu_CreateFrame(540,190+(24*4),760,210+(24*4),"CONFIG-4","",7)
	  Menu_CreateFrame(540,190+(24*5),760,210+(24*5),"CONFIG-5","",7)
	
		Menu_CreateFrame(8, 48+(24*0),530, 68+(24*0),"PLAYER_1","",7)
		Menu_CreateFrame(8, 48+(24*1),530, 68+(24*1),"PLAYER_2","",7)
		Menu_CreateFrame(8, 48+(24*2),530, 68+(24*2),"PLAYER_3","",7)
		Menu_CreateFrame(8, 48+(24*3),530, 68+(24*3),"PLAYER_4","",7)
		Menu_CreateFrame(8, 48+(24*4),530, 68+(24*4),"PLAYER_5","",7)
		Menu_CreateFrame(8, 48+(24*5),530, 68+(24*5),"PLAYER_6","",7)
		Menu_CreateFrame(8, 48+(24*6),530, 68+(24*6),"PLAYER_7","",7)
		Menu_CreateFrame(8, 48+(24*7),530, 68+(24*7),"PLAYER_8","",7)
		Menu_CreateFrame(8, 48+(24*8),530, 68+(24*8),"PLAYER_9","",7)
	
		Menu_CreateFrame(720,566,792,592,"START","",7,x)

		Menu_CreateFrame(157,396      ,169,408,"SHOP","Shop",1,x,-155)
		Menu_CreateFrame(157,423      ,169,435,"SHRINKING","Shrinking",1,x,-155)
		Menu_CreateFrame(157,450      ,169,462,"WHEEL","Wheel of Fortune",1,x,-155)
		Menu_CreateFrame(157,477      ,169,489,"SPECIAL","Special Rounds",1,x,-155)
		Menu_CreateFrame(157,504      ,169,516,"ALARM","Alarm",1,x,-155)
		Menu_CreateFrame(157,531      ,169,543,"MUSIC","Music",1,0,-155)
		Menu_CreateFrame(157,558      ,169,570,"PITCH","MusicPitch",1,0,-155)
		Menu_CreateFrame(157,585      ,169,597,"VIDEO","Video",1,x,-155)
		
		Menu_CreateFrame(70,507      ,135,513,"ALARMVOLUME","",5)
		Menu_CreateFrame(70,534      ,135,540,"MUSICVOLUME","",5)
										
		Menu_CreateFrame( 63,284      , 76,284+7      ,"GAME_UP","Game",2,x,-61)
		Menu_CreateFrame( 63,284+11   , 76,284+11+7   ,"GAME_DOWN","",3,x)
		Menu_CreateFrame( 63,284+54   , 76,284+54+7   ,"TIME_UP","Time",2,x,-61)
		Menu_CreateFrame( 63,284+54+11, 76,284+54+11+7,"TIME_DOWN","",3,x)
		Menu_CreateFrame( 63,284+81   , 76,284+81+7   ,"LEVEL_UP","Level",2,x,-61)
		Menu_CreateFrame( 63,284+81+11, 76,284+81+11+7,"LEVEL_DOWN","",3,x)


		If (REGVERSION) Then					; REGISTRATION

			Menu_CreateFrame(432,556      ,482,580,"RESET","Reset",4,x)

			Menu_CreateFrame( 63,284+27    , 76,284+27+7   ,"WINS_UP","Wins",2,x,-61)
			Menu_CreateFrame( 63,284+27+11 , 76,284+27+11+7,"WINS_DOWN","",3,x)
	
			Menu_CreateFrame(240+116*0  ,294+53*0    ,240+116*0+13  ,294+53*0+7     ,"!00_UP","",2,x,I_PUpBomb)
			Menu_CreateFrame(240+116*0  ,294+53*0+11 ,240+116*0+13  ,294+53*0+11+7  ,"!00_DO","",3,x)
			Menu_CreateFrame(240+116*1  ,294+53*0    ,240+116*1+13  ,294+53*0+7     ,"!10_UP","",2,x,I_PUpSuperman)
			Menu_CreateFrame(240+116*1  ,294+53*0+11 ,240+116*1+13  ,294+53*0+11+7  ,"!10_DO","",3,x)			
			Menu_CreateFrame(240+116*2  ,294+53*0    ,240+116*2+13  ,294+53*0+7     ,"!09_UP","",2,x,I_PUpStop)
			Menu_CreateFrame(240+116*2  ,294+53*0+11 ,240+116*2+13  ,294+53*0+11+7  ,"!09_DO","",3,x)

      Menu_CreateFrame(240+116*0  ,294+53*1    ,240+116*0+13  ,294+53*1+7     ,"!01_UP","",2,x,I_PUpFire)
			Menu_CreateFrame(240+116*0  ,294+53*1+11 ,240+116*0+13  ,294+53*1+11+7  ,"!01_DO","",3,x)
     	Menu_CreateFrame(240+116*1  ,294+53*1    ,240+116*1+13  ,294+53*1+7     ,"!14_UP","",2,x,I_PUpKickBomb)
			Menu_CreateFrame(240+116*1  ,294+53*1+11 ,240+116*1+13  ,294+53*1+11+7  ,"!14_DO","",3,x)			
			Menu_CreateFrame(240+116*2  ,294+53*1    ,240+116*2+13  ,294+53*1+7     ,"!15_UP","",2,x,I_PUpFist)
			Menu_CreateFrame(240+116*2  ,294+53*1+11 ,240+116*2+13  ,294+53*1+11+7  ,"!15_DO","",3,x)
			
      Menu_CreateFrame(240+116*0  ,294+53*2    ,240+116*0+13  ,294+53*2+7     ,"!02_UP","",2,x,I_PUpSpeed)
			Menu_CreateFrame(240+116*0  ,294+53*2+11 ,240+116*0+13  ,294+53*2+11+7  ,"!02_DO","",3,x)
     	Menu_CreateFrame(240+116*1  ,294+53*2    ,240+116*1+13  ,294+53*2+7     ,"!07_UP","",2,x,I_PUpTimeBomb)
			Menu_CreateFrame(240+116*1  ,294+53*2+11 ,240+116*1+13  ,294+53*2+11+7  ,"!07_DO","",3,x)			
			Menu_CreateFrame(240+116*2  ,294+53*2    ,240+116*2+13  ,294+53*2+7     ,"!08_UP","",2,x,I_PUpControl)
			Menu_CreateFrame(240+116*2  ,294+53*2+11 ,240+116*2+13  ,294+53*2+11+7  ,"!08_DO","",3,x)
						
			Menu_CreateFrame(240+116*0  ,294+53*3    ,240+116*0+13  ,294+53*3+7     ,"!05_UP","",2,x,I_PUpYinYang)
			Menu_CreateFrame(240+116*0  ,294+53*3+11 ,240+116*0+13  ,294+53*3+11+7  ,"!05_DO","",3,x)
     	Menu_CreateFrame(240+116*1  ,294+53*3    ,240+116*1+13  ,294+53*3+7     ,"!11_UP","",2,x,I_PUpCoin)
			Menu_CreateFrame(240+116*1  ,294+53*3+11 ,240+116*1+13  ,294+53*3+11+7  ,"!11_DO","",3,x)			
			Menu_CreateFrame(240+116*2  ,294+53*3    ,240+116*2+13  ,294+53*3+7     ,"!16_UP","",2,x,I_PUpBag)
			Menu_CreateFrame(240+116*2  ,294+53*3+11 ,240+116*2+13  ,294+53*3+11+7  ,"!16_DO","",3,x)
									
		  Menu_CreateFrame(240+116*0  ,294+53*4    ,240+116*0+13  ,294+53*4+7     ,"!06_UP","",2,x,I_PUpGhost)
			Menu_CreateFrame(240+116*0  ,294+53*4+11 ,240+116*0+13  ,294+53*4+11+7  ,"!06_DO","",3,x)
     	Menu_CreateFrame(240+116*1  ,294+53*4    ,240+116*1+13  ,294+53*4+7     ,"!12_UP","",2,x,I_PUpAnkh)
			Menu_CreateFrame(240+116*1  ,294+53*4+11 ,240+116*1+13  ,294+53*4+11+7  ,"!12_DO","",3,x)			
			Menu_CreateFrame(240+116*2  ,294+53*4    ,240+116*2+13  ,294+53*4+7     ,"!04_UP","",2,x,I_PUpUnknown)
			Menu_CreateFrame(240+116*2  ,294+53*4+11 ,240+116*2+13  ,294+53*4+11+7  ,"!04_DO","",3,x)
												
			Menu_CreateFrame(240+116*0  ,294+53*5    ,240+116*0+13  ,294+53*5+7     ,"!18_UP","",2,x,I_PUpDeath)
			Menu_CreateFrame(240+116*0  ,294+53*5+11 ,240+116*0+13  ,294+53*5+11+7  ,"!18_DO","",3,x)
				
		EndIf

		
	case "InputConfig"
		Menu_CreateFrame(5,470,128,490,  "INPUT_DEF_LD1","Load Default 1",4)
		Menu_CreateFrame(136,470,260,490,"INPUT_DEF_LD2","Load Default 2",4)
		Menu_CreateFrame(268,470,392,490,"INPUT_DEF_LD3","Load Default 3",4)
		Menu_CreateFrame(400,470,524,490,"INPUT_DEF_LD4","Load Default 4",4)
		Menu_CreateFrame(5,500,128,520,  "INPUT_DEF_SV1","Save Default 1",4)
		Menu_CreateFrame(136,500,260,520,"INPUT_DEF_SV2","Save Default 2",4)
		Menu_CreateFrame(268,500,392,520,"INPUT_DEF_SV3","Save Default 3",4)
		Menu_CreateFrame(400,500,524,520,"INPUT_DEF_SV4","Save Default 4",4)
		
	  Menu_CreateFrame(701,470,756,490,"INPUT_CANCEL","Cancel",4)
		Menu_CreateFrame(764,470,792,490,"INPUT_OK","OK",4)
		
		Menu_CreateFrame(131,249+1*30,297,247+2*30,"INPCODE_1_LEFT","",8)
	  Menu_CreateFrame(131,249+2*30,297,247+3*30,"INPCODE_1_RIGHT","",8)
	  Menu_CreateFrame(131,249+3*30,297,247+4*30,"INPCODE_1_UP","",8)
	  Menu_CreateFrame(131,249+4*30,297,247+5*30,"INPCODE_1_DOWN","",8)
	  Menu_CreateFrame(131,249+5*30,297,247+6*30,"INPCODE_1_BOMB","",8)
	  Menu_CreateFrame(131,249+6*30,297,247+7*30,"INPCODE_1_PAUSE","",8)
	  
		Menu_CreateFrame(300,249+1*30,465,247+2*30,"INPCODE_2_LEFT","",8)
	  Menu_CreateFrame(300,249+2*30,465,247+3*30,"INPCODE_2_RIGHT","",8)
	  Menu_CreateFrame(300,249+3*30,465,247+4*30,"INPCODE_2_UP","",8)
	  Menu_CreateFrame(300,249+4*30,465,247+5*30,"INPCODE_2_DOWN","",8)
	  Menu_CreateFrame(300,249+5*30,465,247+6*30,"INPCODE_2_BOMB","",8)
	  Menu_CreateFrame(300,249+6*30,465,247+7*30,"INPCODE_2_PAUSE","",8)
		
		Menu_CreateFrame(467,249+1*30,632,247+2*30,"INPCODE_3_LEFT","",8)
	  Menu_CreateFrame(467,249+2*30,632,247+3*30,"INPCODE_3_RIGHT","",8)
	  Menu_CreateFrame(467,249+3*30,632,247+4*30,"INPCODE_3_UP","",8)
	  Menu_CreateFrame(467,249+4*30,632,247+5*30,"INPCODE_3_DOWN","",8)
	  Menu_CreateFrame(467,249+5*30,632,247+6*30,"INPCODE_3_BOMB","",8)
	  Menu_CreateFrame(467,249+6*30,632,247+7*30,"INPCODE_3_PAUSE","",8)

		Menu_CreateFrame(634,249+1*30,798,247+2*30,"INPCODE_4_LEFT","",8)
	  Menu_CreateFrame(634,249+2*30,798,247+3*30,"INPCODE_4_RIGHT","",8)
	  Menu_CreateFrame(634,249+3*30,798,247+4*30,"INPCODE_4_UP","",8)
	  Menu_CreateFrame(634,249+4*30,798,247+5*30,"INPCODE_4_DOWN","",8)
	  Menu_CreateFrame(634,249+5*30,798,247+6*30,"INPCODE_4_BOMB","",8)
	  Menu_CreateFrame(634,249+6*30,798,247+7*30,"INPCODE_4_PAUSE","",8)			
					
	end select
end function
	




;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------















	
