;-----------------------------------------------------------------------------------------------
; Master Blaster
;
; GAME
;
;-----------------------------------------------------------------------------------------------

;--- Types --------------

Type T_firework		;Generate Firework Type
	Field x#		;Firework X Position
	Field y#		;Firework Y Position
	Field xspeed#	;Firework X Speed
	Field yspeed#	;Firework Y Speed
	Field Farbe
	Field Kind
	Field Life#
	Field maxlife#
	Field Power
End Type

type starskydata
	field xpos
	field ypos
	field brightness
	field dir
end type

Type T_Item
	Field Anim
	Field x
	Field y
	Field AnimTimer
	Field Owner
	Field LifeForce
	Field Range
	Field xx
	Field yy
	Field Move
	Field MoveTimer
	Field MaxMoveTime
	Field Kind
	Field PUp
	Field Nr
	Field BombType
End Type

Type T_Map
	Field Ground
	Field Surface
	Field Item
	Field PUp
	Field AnimTimer
	Field Owner
End Type
	
Type T_PlayerAnim
	Field Frame
	Field AnimTime
	Field NextAnim
End Type

Type T_ItemAnim
	Field Frame
	Field Kind
	Field PUp
	Field AnimTime
	Field NextItem
End Type


Type T_Player
	Field Nr					; No.
	Field Drawn					; already drawn to screen ?
	Field Name$					; name
	Field Image					; No. of Image
	Field Wins
	
	Field Score					; Score
	
	Field x,y					; Position in PIXEL
	Field fx,fy					; Forces pushing Player
	Field tx,ty					; Movement-forces by Inputdevice
	Field xx,yy					; Sum

	Field Dies					; Counter for Death ?!?

	Field Bombs					; No. of bombs
	Field Fire					; range for detonation
	Field Speed#				; SPEED????
	Field SpeedCounter#
	Field Facing				; up-right-down-left = 1-2-4-8

	Field Disease				;
	Field DiseaseTimer			;
	Field BombKind				; 0=normal, 1=TimeBomb, 2=Rollerbomb
	Field BombTicks				; No. of ticks before detonation
	Field LastBomb				; No. of Item, which was last bomb and Player sits on it
	Field CanPushWalls			; Superman ?
	Field CanKickBombs			; Kickbomb ?
	Field StopTimer				; Stopped ?
	Field Coins					; No.of coins
	Field FistTimer   			; Can Fist Walls ?
	Field Mines					; No.of mines

	Field TimeBomb				; Timebomb Item

	Field Anim					; Animation
	Field AnimTimer				; Timer for anim.
	
	Field YinYang
	Field YinYangFrame
	Field YinYangAnimTimer

	Field Ghost
	Field GhostFrame

	Field ul,ur,dl,dr			; Temp
	Field c,cr,cl,cu,cd			;

	Field Team
	Field NetID

	Field InputDev				;
	field DevCodeLeft1
	field DevCodeLeft2
	field DevCodeLeft3
	field DevCodeLeft4
	field DevCodeRight1
	field DevCodeRight2
	field DevCodeRight3
	field DevCodeRight4
	field DevCodeUp1
	field DevCodeUp2
	field DevCodeUp3
	field DevCodeUp4
	field DevCodeDown1
	field DevCodeDown2
	field DevCodeDown3
	field DevCodeDown4
	field DevCodeBomb1
	field DevCodeBomb2
	field DevCodeBomb3
	field DevCodeBomb4
	field DevCodePause1
	field DevCodePause2
	field DevCodePause3
	field DevCodePause4
	Field Keys					; up-right-down-left-b1-b2 = 1-2-4-8-16-32
End Type


Type T_PlayerImage
	Field Name$
	Field Image
	Field DeathAnims
	Field DeathCry
	Field File$
End Type

type pixeldata
	field xpos#
	field ypos#
	field xspeed#
	field yspeed#
	field rgb
	field r
	field g
	field b
	field flashrgb
	field brightness#
	field brightnessdir#
	field sinangle
	field sinfreq#
	field nr
end type

type swarmdata
	field kind
	field state
	field counter
	field maxbrightness#
	field screenh
	field screenw
end type

type logopixeldata
	field xpos#
	field ypos#
	field rgb
end type

Type star
	Field xpos#
	Field ypos#
	Field zpos#
End Type

Type shooting_star
	Field xpos#
	Field ypos#
	Field lifetime
	field xspeed#
	field yspeed#
	field speed_angle#
End Type

type glitterdata
	field xpos
	field ypos
	field timeout
	field speed
	field alpha	
end type



;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------


;---------------------------------------------------------------------------------- PLAYONEROUND
Function PLAYONEROUND()

If Shop_On Then
	;init_fire()
	If Wheel_On=False
  	Playsong("music\other\spring_jump.mp3")
	endif
	
	Repeat
		gTraded=False
		For Player=Each T_Player				; SHOP !!!
			If Player\Coins>0 Then 
				If GameStatus<>C___SHOP Then SetStatus(C___SHOP)
				Shop_Shop()
			EndIf
		Next
	Until gTraded=False
	Playsong("")
	;destroy_fire()
EndIf
	
SetStatus(C___GAME)
	
InitRound()

If Net_Type=2 Then
	NET_Broadcast("PLAYERS")					; Host ?
EndIf

SetFont Font_24
SetBuffer BackBuffer()

RoundTime=0


ShrinkX=1
ShrinkY=1
ShrinkXX=17
ShrinkYY=0
ShrinkTimer=0
ShrinkStep=0
Darkness=0
Lightning=0
EndTime=0

Action$=""
Paused=0

Alive=MaxPlayer							; Awake all Players

FlushMouse
FlushJoy
FlushKeys

If Net_Type<>1 Then 					; GAMELOOP
	GAMELOOP_HOST()
	If Net_Type=2 Then
		;NET_Broadcast("KILLS")
		Sleep(250)
	EndIf
EndIf

GAME_CleanUp()

End Function


;-----------------------------------------------------------------------------------------------
Function GAME_CleanUp()

ClsColor 0,0,0
For Player=Each T_Player
	Player\Bombs=1
	Player\Fire=2
	Player\Speed=Player_StartSpeed
	Player\Facing=0
	Player\Disease=0
	Player\BombKind=0
	Player\LastBomb=0
	Player\CanPushWalls=0
	Player\CanKickBombs=0
	Player\BombTicks=BombTicks/1000*C_FPS
	Player\StopTimer=0
	Player\FistTimer=0
	Player\Mines=0
	Player\TimeBomb=0
	Player\Anim=A_P_StandDown
	Player\AnimTimer=0
	Player\YinYang=0
	Player\YinYangFrame=0
	Player\YinYangAnimTimer=0
	Player\Ghost=0
	Player\GhostFrame=0
	Player\Keys=0
	Player\tx=0
	Player\ty=0
	Player\xx=0
	Player\yy=0
	Player\fx=0
	Player\fy=0
Next

If Game_Mode=2 Then 						; Teamgame easy ?
	For Player=Each T_Player
		If Player\Dies=0 Then
			For P.T_Player=Each T_Player
				If Player\Team=P\Team Then P\Dies=0
			Next
			Exit
		EndIf
	Next
EndIf

StopAllSounds()


FlushKeys
FlushMouse
FlushJoy

If Wav(0)<>0 Then FreeSound Wav(0)			; unload music

End Function


;-----------------------------------------------------------------------------------------------


;------------------------------------------------------------------------------- GAMELOOP_JOINER
Function GAMELOOP_JOINER()

	HandleInput()							; get local movement
	If (Test_terminal=False) Then

		If ((Darkness=0) Or (Lightning>0)) And (gGotPlayer) And (gGotMap) Then
		
			DrawMap()
			Z=(C_ScreenY * RoundTime)/MaxRoundTime
			DrawBlockRect Im_TimeRamp,750,z, 0,z, 5,600-z
			DrawBlockRect Im_TimeRamp,48,z, 0,z, 5,600-z
			DrawPlayers()
		EndIf

    If Paused=0 Then MusicTime=MusicTime + 1

	 	if musicvolume_changed
			musicvolume_changed =false
			channelvolume wav_id(0),musicvolume
		endif

		If Paused<>0 Then
			If wav_id(0)<>0 and MusicPlays Then
				pauseChannel wav_id(0)
				PlayWav(Wav_Pause,0,0)
				MusicPlays = false
			endif
		elseIf wav_id(0)<>0 and MusicPlays = false then
			resumechannel(wav_id(0))
			MusicPlays = true
		EndIf
	
	  If (MusicTime=(MaxRoundTime/28)) and Pitch_on Then		; increase Musicpitch
			MusicTime=0
			MusicPitch=MusicPitch + 1
			If Wav(0)<>0 Then ChannelPitch wav_id(0), MusicPitch * (1 * WavPitch(0)) /100
		EndIf

		If Paused<>0 Then
			Color 0,0,0;50,50,255
			Text 400,300,"PAUSE",True,True
		EndIf
		
	EndIf
	Flip True;False
	WaitTimer(timer)
	
	
	x=0
	If Roundtime>=AlarmTime and Alarm_on Then				;Set alarm off ?
		x=RoundTime Mod 100
		if channelplaying (wav_id(Wav_Alarm)) = 0 Then
			wav_id(Wav_Alarm) = Playsound (Wav(Wav_Alarm))
			channelvolume wav_id(Wav_Alarm),alarmvolume
		endif
		If x>50 Then x=100-x
		x=x*4
	EndIf
	
	ClsColor x,0,0
	Cls											; Clear Screen

End Function


;--------------------------------------------------------------------------------- GAMELOOP_HOST
Function GAMELOOP_HOST()

For Player=Each T_Player
		Player\Keys = 0
Next
	
Repeat	;****************************************************************************** MAINLOOP
	If Paused=0 Then 
		RoundTime=RoundTime + 1					; Increase Timers
		MusicTime=MusicTime + 1
		If Darkness>0 Then Darkness=Darkness-1
		If Lightning>0 Then Lightning=Lightning-1
	EndIf

	if musicvolume_changed
		musicvolume_changed =false
		channelvolume wav_id(0),musicvolume
	endif
	
	If Paused<>0 Then
		If wav_id(0)<>0 and MusicPlays Then
			pauseChannel wav_id(0)
			PlayWav(Wav_Pause,0,0)
			MusicPlays = false
		endif
	elseIf wav_id(0)<>0 and MusicPlays = false then
		resumechannel(wav_id(0))
		MusicPlays = true
	EndIf
	
	
	If (MusicTime=(MaxRoundTime/28)) and Pitch_on Then		; increase Musicpitch
		MusicTime=0
		MusicPitch=MusicPitch + 1
		If Wav(0)<>0 Then ChannelPitch wav_id(0), MusicPitch * (1 * WavPitch(0)) /100
	EndIf

	If Shrinking_On Then 	
		If RoundTime = ShrinkTime Then 			; Shrinking Start ?
			ShrinkStep=17
			PlayWav(Wav_ShrinkingStart,0,0)
		EndIf
		If (ShrinkStep<>0) And (Paused=0) Then	; Shrinking ?
			If ShrinkTimer=0 Then
				ShrinkLevel()
				ShrinkTimer=10
			EndIf
			ShrinkTimer=ShrinkTimer-1
		EndIf
	EndIf


	NET_HandleNetwork(False)					; check Network
	HandleInput()
	NET_HandleNetwork(False)					; check Network

	If (Test_Terminal=False) And ((Darkness=0) Or (Lightning>0)) Then
		DrawMap()
		Z=(C_ScreenY * RoundTime)/MaxRoundTime
		DrawBlockRect Im_TimeRamp,750,z, 0,z, 5,600-z
		DrawBlockRect Im_TimeRamp,48,z, 0,z, 5,600-z
	EndIf


	If Paused=0 Then HandleMap()
	NET_HandleNetwork(False)					; check Network

 	If Paused=0 Then AnimatePlayers()
	NET_HandleNetwork(True)						; check Network + SYNC

	If Paused=0 Then MovePlayer()

	If (Test_terminal=False) And ((Darkness=0) Or (Lightning>0)) Then
		DrawPlayers()
		If Paused<>0 Then
			Color 0,0,0;50,50,255
			Text 400,300,"PAUSE",True,True
			If Net_Type=2 Then NET_Broadcast("TIMER")
		EndIf
	EndIf


;If MouseDown(1) Then Delay(200)

	SCREENSHOT()

	WaitTimer(Timer)
	Flip True
	
	x=0
	If Roundtime>=AlarmTime and Alarm_on Then				;Set alarm off ?
		x=RoundTime Mod 100
		if channelplaying (wav_id(Wav_Alarm)) = 0 Then
			wav_id(Wav_Alarm) = Playsound (Wav(Wav_Alarm))
			channelvolume wav_id(Wav_Alarm),alarmvolume
		endif
		If x>50 Then x=100-x
		x=x*4
	EndIf

	ClsColor x,0,0

	Cls											; Clear Screen

	NET_HandleNetwork(False)					; check Network

	If (KeyDown(1)) And (Net_Type<>1) Then Action$="ESC"

	If (Action="ESC") And (Net_Type=2) Then SendNetMsg(99,"ESC",Net_MyNetID)

	Ok=True
	If Game_Mode<>0 Then						; Teamgame ???
		z=999
		For Player=Each T_Player
			If Player\Dies=0 Then
				If z=999 Then
					z=Player\Team
				Else
					If z<>Player\Team Then Ok=False
				EndIf
			EndIf
		Next
	Else										; single Player game ???
		If Alive>1 Then Ok=False
	EndIf

	If Ok=False Then							; Round Over ?
		EndTime=0
	Else
		If EndTime=0 Then EndTime=150
		If EndTime=1 Then Action$="END"
		If Paused=0 Then EndTime=EndTime-1
	EndIf

	If RoundTime>=MaxRoundTime Then Action$="END"


Until (Action$="ESC") Or (Action$="END")


End Function


;----------------------------------------------------------------------------------- ShrinkLevel
Function ShrinkLevel()

	If Shrinking_On=False Then Return

	x=(Map(ShrinkX,ShrinkY)\Ground And I_Iron)
	While (x<>0) And (ShrinkStep>5)
		If ShrinkXX>0 Then 
			ShrinkXX=ShrinkXX-1
			ShrinkX=ShrinkX + 1
			If ShrinkXX=0 Then
				ShrinkYY=ShrinkStep
				ShrinkX=ShrinkX-1
			EndIf
		EndIf
		If ShrinkYY>0 Then 
			ShrinkYY=ShrinkYY-1
			ShrinkY=ShrinkY + 1
			If ShrinkYY=0 Then
				ShrinkXX=((-1) * ShrinkStep)
				ShrinkY=ShrinkY-1
			EndIf
		EndIf
		If ShrinkXX<0 Then 
			ShrinkXX=ShrinkXX+1
			ShrinkX=ShrinkX - 1
			If ShrinkXX=0 Then
				ShrinkYY=((-1) * ShrinkStep)+1
				ShrinkX=ShrinkX+1
			EndIf			
		EndIf
		If ShrinkYY<0 Then 
			ShrinkYY=ShrinkYY+1
			ShrinkY=ShrinkY - 1
			If ShrinkYY=0 Then 
				ShrinkStep=ShrinkStep - 2
				ShrinkXX=ShrinkStep
				ShrinkY=ShrinkY+1
				ShrinkX=ShrinkX+1
			EndIf
		EndIf
		x=(Map(ShrinkX,ShrinkY)\Ground And I_Iron)
	Wend
	
	q=Map(ShrinkX,ShrinkY)\Item
	If q<>0 Then
		If ((Item(q)\Kind)=I_Bomb) Or ((Item(q)\Kind)=I_Bomb2) Or ((Item(q)\Kind)=I_Bomb3) Then
			IgniteBomb(q)
		Else
			Item(q)\LifeForce=1
			Item(q)\Move=0
		EndIf
	EndIf

	PutInMap(ShrinkX,ShrinkY,I_Shrinking,0)

	PlayWav(WAV_ShrinkSound,0,ShrinkX*C_ItemX)

	If ShrinkStep=1 Then ShrinkStep=0			; Stop shrinking

	If ShrinkXX>0 Then 
		ShrinkXX=ShrinkXX-1
		ShrinkX=ShrinkX + 1
		If ShrinkXX=0 Then
			ShrinkYY=ShrinkStep
			ShrinkX=ShrinkX-1
		EndIf
	EndIf
	If ShrinkYY>0 Then 
		ShrinkYY=ShrinkYY-1
		ShrinkY=ShrinkY + 1
		If ShrinkYY=0 Then
			ShrinkXX=((-1) * ShrinkStep)
			ShrinkY=ShrinkY-1
		EndIf
	EndIf
	If ShrinkXX<0 Then 
		ShrinkXX=ShrinkXX+1
		ShrinkX=ShrinkX - 1
		If ShrinkXX=0 Then
			ShrinkYY=((-1) * ShrinkStep)+1
			ShrinkX=ShrinkX+1
		EndIf			
	EndIf
	If ShrinkYY<0 Then 
		ShrinkYY=ShrinkYY+1
		ShrinkY=ShrinkY - 1
		If ShrinkYY=0 Then 
			ShrinkStep=ShrinkStep - 2
			ShrinkXX=ShrinkStep
			ShrinkY=ShrinkY+1
			ShrinkX=ShrinkX+1
			If ShrinkStep=5 Then PlayWav(Wav_Goodbye,0,0)	; say "good bye"
		EndIf
	EndIf

End Function


;-----------------------------------------------------------------------------------------------


;------------------------------------------------------------------------------------ MovePlayer
Function MovePlayer()

	For Player = Each T_Player
		If Player\Disease=5 Then Player\Keys=(Player\Keys Or 16)	; Bombshit
		If Player\Disease=4 Then Player\Keys=(Player\Keys And 15)	; No bomb

		
		If (Player\Keys And 1) or (Player\Keys And 2) or (Player\Keys And 4) or (Player\Keys And 8)

			If Player\Disease=6
				Player\SpeedCounter = Player\SpeedCounter+1.0
			else
				Player\speedcounter = Player\speedcounter + Player\Speed
			endif
			x = floor(Player\SpeedCounter)
			
			If (Player\Keys And 1) Then Player\ty = Player\ty - x
			If (Player\Keys And 2) Then Player\tx = Player\tx + x
			If (Player\Keys And 4) Then Player\ty = Player\ty + x
			If (Player\Keys And 8) Then Player\tx = Player\tx - x
			Player\speedcounter = Player\speedcounter - x
		else
			Player\speedcounter = 0
		endif
		
		
	Next

	   For Player = Each T_Player
	
       If Player\Dies=0 Then
           Player\xx = Player\fx + Player\tx
           Player\yy = Player\fy + Player\ty
           Player\tx = 0
           Player\ty = 0
           heading=0

           If (Player\BombKind=3) Then
               ControlBomb()
               Heading=16
           Else



               While ((Player\xx<>0) Or (Player\yy<>0)) And (Player\Dies=0)

                   oldx=Player\xx                                ; remember old location
                   oldy=Player\yy
                   movement = 0

                   If (Player\xx>0) Then                     ; RIGHT ????

                       Player\xx = Player\xx - 1

                       Heading=2
                       
                       
                       ; freie Bahn?
                       If (Probe(+17, 0)=0) And (Probe(+17, -16)=0) And (Probe(+17, +16)=0) Then
                           Player\x  = Player\x  + 1
													 movement = 1
													 
                       ElseIf (Probe(+17,+SlideValue)=0) and (Probe(+17,+17)=0) And (Probe(0,+17)=0 and oldy=0) Then        ; slide down
                           If (Player\yy=0) Then Player\y=Player\y + 1
                           Heading=4
                           movement = 2
                           
                       ElseIf (Probe(+17,-SlideValue)=0) And (Probe(0,-17)=0 and oldy=0) Then        ; slide up
                           If (Player\yy=0) Then Player\y=Player\y - 1
                           Heading=1
                           movement = 3
                           
                       Else
                           TryToDoSomething(2)
                           movement = 4
                       EndIf
                       
                   elseIf (Player\xx<0) Then                     ; LEFT ????

                       Player\xx = Player\xx + 1

											 Heading=8

											
                       ; freie Bahn?
                       If (Probe(-17,0)=0) And (Probe(-17,+16)=0) And (Probe(-17,-16)=0) Then
                           Player\x  = Player\x  - 1
                           movement = 5
                       ElseIf (Probe(-17,+SlideValue)=0) and (Probe(-17,+17)=0) And (Probe(0,+17)=0 and oldy=0) Then        ; slide down
                           If (Player\yy=0) Then Player\y=Player\y + 1
                           Heading=4
                           movement = 6
                       ElseIf (Probe(-17,-SlideValue)=0) And (Probe(0,-17)=0 and oldy=0 ) Then        ; slide up
                           if (Player\yy=0) Then Player\y=Player\y - 1
                           Heading=1
                           movement = 7
                       Else
                           TryToDoSomething(4)
                           movement = 8
                       EndIf
                       
                   EndIf




                   If (Player\yy<0) Then                     ; UP ????

                       Player\yy = Player\yy + 1


                       ; freie Bahn?
                       If (Probe(0,-17)=0) And (Probe(+16,-17)=0) And (Probe(-16,-17)=0) Then
                           Player\y  = Player\y  - 1
                           Heading=1
                       ElseIf (Probe(+SlideValue,-17)=0) and (Probe(+17,-17)=0) And (Probe(+17,0)=0 and oldx=0)Then        ; slide right
                           If (Player\xx=0) Then Player\x=Player\x + 1
                           Heading=2
                       ElseIf (Probe(-SlideValue,-17)=0) And (Probe(-17,0)=0 and oldx=0) Then        ; slide left
                           If (Player\xx=0) Then Player\x=Player\x - 1
                           Heading=8
                       Else
                           TryToDoSomething(1)
                           if (movement<>1 and movement<>5) then Heading=1
                       EndIf


                   elseIf (Player\yy>0) Then                     ; DOWN ????

                       Player\yy = Player\yy - 1


                       ; freie Bahn?
                       If (Probe(0,+17)=0) And (Probe(+16,+17)=0) And (Probe(-16,+17)=0)Then
                           Player\y  = Player\y  + 1
                           Heading=4
                       ElseIf (Probe(+SlideValue,+17)=0) and (Probe(+17,+17)=0) And (Probe(+17,0)=0 and oldx=0) Then        ; slide right
                           If (Player\xx=0) Then Player\x=Player\x + 1
                           Heading=2
                       ElseIf (Probe(-SlideValue,+17)=0) And (Probe(-17,0)=0 and oldx=0) Then        ; slide left
                           If (Player\xx=0) Then Player\x=Player\x - 1
                           Heading=8
                       Else
                           TryToDoSomething(3)
                           if (movement<>1 and movement<>5) then Heading=4
                       EndIf

                   EndIf

               Wend

       EndIf ; Controller?



       Player\c =            Anim_Items(Map((Player\x+16)/C_ItemX,(Player\y+26)/C_ItemY)\Surface)\Kind
       Player\c =Player\c Or Anim_Items(Map((Player\x+16)/C_ItemX,(Player\y+26)/C_ItemY)\Ground)\Kind
       z=Map( (Player\x+16)/C_ItemX, (Player\y+26-0)/C_ItemY)\Item
       Killer=Map( (Player\x+16)/C_ItemX, (Player\y+26-0)/C_ItemY)\Owner
       If (z<>0) And (z<>Player\LastBomb) Then
           If Item(z)<>Null Then
               Player\c=Player\c Or Anim_Items(Item(z)\Anim)\Kind
               Killer=Item(z)\Owner
           EndIf
       EndIf

       If (Player\Ghost=0) Then                             ; Visible ?
           If (Player\c And Is_PUp) Then CollectItem()        ; PowerUp touched ?
           If (Player\c And Is_Flame) Then                    ; Explosion touched ?
               PlayerShouldDie(Killer)
           EndIf
           If (Player\c And (Is_Wall Or Is_Wall0 Or Is_Wall1 Or Is_Wall2)) Then
               PlayerShouldDie(Killer)                        ; stuck in Wall ?
           EndIf
           If (Player\c And Is_Iron) Then                    ; stuck in Iron ?
               PlayerShouldDie(Player\Nr)
           EndIf
       EndIf

       If Player\Dies=0 Then                                ; Still alive ?

           If (Player\Keys And 16) Then                    ; Button Pressed ?
               TryToDropBomb()
           Else
               If Player\TimeBomb<>0 Then Item(Player\TimeBomb)\LifeForce=1
           EndIf
           
           If (Heading<>Player\Facing) And (Heading<>0) Then     ; Direction changed?
               Player\Facing=Heading
               Select Heading
               Case 1 Player\Anim=A_P_Up
               Case 2 Player\Anim=A_P_Right
               Case 4 Player\Anim=A_P_Down
               Case 8 Player\Anim=A_P_Left
               Case 16 Player\Anim=A_P_Controling
               End Select
               Player\AnimTimer=1;Anim_Player(Player\Anim,1)
           Else
               If (Heading=0) Then
                   Select Player\Facing
                   Case 1 Player\Anim=A_P_StandUp
                   Case 2 Player\Anim=A_P_StandRight
                   Case 4 Player\Anim=A_P_StandDown
                   Case 8 Player\Anim=A_P_StandLeft
                   Case 16 Player\Anim=A_P_StandDown
                   End Select
                   Player\Facing=0
                   Player\AnimTimer=1;Anim_Player(Player\Anim,1)
               EndIf
           EndIf

       EndIf

                                   ; Player left LastBombs'place
       z=Map( (Player\x+16)/C_ItemX ,(Player\y+26)/C_ItemY)\Item
       If (z<>Player\LastBomb) Then Player\LastBomb=0

     EndIf ; Dead

   Next ; next Player
End Function



Function Probe(aX , aY)

   vX = aX + Player\x + 16
   vY = aY + Player\y + 26

   Filter = Is_PUp+Is_Flame+Is_Ice

   If Player\Ghost<>0 Then Filter=Filter + Is_wall + Is_Bomb + Is_wall0 + Is_wall1 + Is_wall2

   Erg=Anim_Items(Map((vX)/C_ItemX,(vY)/C_ItemY)\Ground)\Kind
   Erg=Erg Or Anim_Items(Map((vX)/C_ItemX,(vY)/C_ItemY)\Surface)\Kind

                           ; Any Items there ?
   z=Map( vX/C_ItemX ,vY/C_ItemY)\Item
   z2=Map( (Player\x+16)/C_ItemX ,(Player\y+26-0)/C_ItemY)\Item
   If (z<>0) And (z<>z2) Then Erg=Erg Or Anim_Items(Item(z)\Anim)\Kind

   Filter=65535 - Filter

   Erg=Erg And Filter
     Return Erg

End Function



;----------------------------------------------------------------------------------- ControlBomb
Function ControlBomb()

	q=Player\TimeBomb
	If q=0 Then Return
	If (Item(q)\move<>0) Then Return

	If (Player\Keys And 1) Then yy= -1
	If (Player\Keys And 2) Then xx= +1
	If (Player\Keys And 4) Then yy= +1
	If (Player\Keys And 8) Then xx= -1
	
	mx=(Item(q)\x+16)/C_ItemX
	my=(Item(q)\y+16)/C_ItemY

	If (xx<>0) And (yy<>0) Then xx=0
	If (xx<>0) Or (yy<>0) Then TryToPushBomb(mx,my,xx,yy,1)
	
End Function


;----------------------------------------------------------------------------------- CollectItem
Function CollectItem()

	y=Anim_Items(Map((Player\x+16)/C_ItemX,(Player\y+26)/C_ItemY)\Surface)\PUp

	If y=5 Then										; ????????

		Player\Score=Player\Score + C_ScoreQuestion

		Repeat										; Shop active ?
			ok=Shop_On
			x=Rand(1,20)
			If (x<18) Then ok=True
			if (x<=8)
				ok2 = QuestionItems
				ok2 = (ok2 and 2^(x-1))
			else
				ok2 = true
			endif
		Until (ok>=1 and ok2>=1)
		
		Select x
			Case 1:									; Darkness
			Darkness=1000
			PlayWav(Wav_PUp_Q_Darkness,0,Player\X)

			Case 2:
			Player\Disease=1						; Input Inverted
			Player\DiseaseTimer=1000
			PlayWav(Wav_PUp_Q_InputInverted,0,Player\X)
			
			Case 3:
			Player\Disease=2						; Small Bomb
			Player\DiseaseTimer=1000
			PlayWav(Wav_PUp_Q_SmallBomb,0,Player\X)

			Case 4:
			Player\Disease=3						; WallBomb
			Player\DiseaseTimer=1000
			PlayWav(Wav_PUp_Q_WallBomb,0,Player\X)
				
			Case 5:
			Player\Disease=4						; no Bomb
			Player\DiseaseTimer=1000
			PlayWav(Wav_PUp_Q_NoBomb,0,Player\X)

			Case 6:
			Player\Disease=5						; Bombshit
			Player\DiseaseTimer=1000
			Player\BombKind=0
			If Player\TimeBomb<>0 Then Item(Player\TimeBomb)\LifeForce=1
			PlayWav(Wav_PUp_Q_Bombshit,0,Player\X)

			Case 7:
			Player\Disease=6						; Slow down
			Player\DiseaseTimer=1000
			PlayWav(Wav_PUp_Q_SlowDown,0,Player\X)

			Case 8:
			PlayWav(Wav_PUp_Stop,0,Player\X)		; personal Stop
			Player\StopTimer=200
			
			Case 9,10: y=3							; Speed
			Case 11,12:y=8							; YinYang
			Case 13:y=12							; Stop
			Case 14,15								; Fullbomb
			PlayWav(Wav_PUp_Q_FullBomb,0,Player\X)
			Player\Fire=20

			Case 16,17								; Nukebomb
			PlayWav(Wav_PUp_Q_NukeBomb,0,Player\X)
			Player\Disease=7
			Player\DiseaseTimer=1500
;			Player\BombKind=0
;			If Player\TimeBomb<>0 Then Item(Player\TimeBomb)\LifeForce=1

			Case 18,19:y=14							; Coin
			Case 20:   y=17							; Bag

		End Select
	EndIf


	Select y
		Case 1											; PowerUp - Bomb
			If Player\TimeBomb<>0 Then Item(Player\TimeBomb)\LifeForce=1
			If Player\BombKind<>0 Then
				Player\BombKind=0
				Player\TimeBomb=0
			EndIf
			PlayWav(Wav_PUp_Bomb,0,Player\X)
			Player\Bombs = Player\Bombs + 1

		Case 2											; PowerUp - Fire
			PlayWav(Wav_PUp_Fire,0,Player\X)
			Player\Fire = Player\Fire + 1

		Case 3											; PowerUp - Speed
			If Player\Speed<Player_MaxSpeed Then
				PlayWav(Wav_PUp_Speed,0,Player\X)
				Player\Speed = Player\Speed + Player_IncSpeed
				if Player\Speed < 0 then Player\Speed = 0
			EndIf

		Case 4											; PowerUp - KickBomb
			Player\CanKickBombs=(Player\CanKickBombs*19)+1
			PlayWav(Wav_PUp_KickBomb,0,Player\X)

		Case 6											; PowerUp - TimeBomb
			If Player\BombKind<>1 Then
				Player\BombKind=1
				Player\TimeBomb=0
			EndIf
			PlayWav(Wav_PUp_TimeBomb,0,Player\X)

		Case 7											; PowerUp - Death
			PlayerShouldDie(Player\Nr)

		Case 8											; PowerUp - YinYang
			Player\YinYang=1
			Player\YinYangAnimTimer=0
			Player\YinYangFrame=0
			PlayWav(Wav_PUp_YinYang,0,Player\X)

		Case 9											; PowerUp - Fist
			Player\FistTimer = Player\FistTimer + 200
			PlayWav(Wav_PUp_Fist,0,Player\X)

		Case 10											; PowerUp - Ghost
			If RoundTime<AlarmTime Then					; only if no Alarm
				Player\YinYang=0
				Player\YinYangAnimTimer=0
				Player\YinYanGFrame=0
				Player\Ghost=141
				Player\GhostFrame=0
				PlayWav(Wav_PUp_Ghost,0,Player\X)
			EndIf

		Case 11											; PowerUp - Controller
			If Player\TimeBomb<>0 Then Item(Player\TimeBomb)\LifeForce=1
			Player\BombKind=2
			Player\TimeBomb=0
			PlayWav(Wav_PUp_ControlBomb,0,Player\X)

		Case 12											; PowerUp - Stop
			PlayWav(Wav_PUp_Stop,0,Player\X)
			For P.T_Player=Each T_Player
				ok = True
				If P\Nr=Player\Nr Then ok=False
				If P\Dies<>0 Then ok=False
				If (Game_Mode>0) Then					; Teammode ?
					If P\Team=Player\Team Then Ok=False
				EndIf
				If Ok Then P\StopTimer=200
			Next

		Case 13											; PowerUp - Superman
			Player\CanPushWalls=(Player\CanPushWalls*20)+1
			PlayWav(Wav_PUp_Superman,0,Player\X)

		Case 14											; PowerUp - Coin
			Player\Coins=Player\Coins + 1
			PlayWav(Wav_PUp_Coin,0,Player\X)

		Case 15											; PowerUp - Ankh
			For P.T_Player=Each T_Player
				If (P\Team=Player\Team) And (P\Dies=1) Then	; Ressurect
					Player\Score=Player\Score + C_ScoreAnkh
					P\Dies=0
					P\Speed=Player_StartSpeed
					P\Bombs=1
					P\Fire=2
					P\BombKind=0
					P\CanPushWalls=0
					P\CanKickBombs=0
					P\BombTicks=BombTicks/1000*C_FPS
					P\Anim=A_P_StandDown
					P\Ghost=0
					P\X=Player\X
					P\Y=Player\Y
					P\YinYang=10
					P\Disease=0
					P\DiseaseTimer=0
					Alive=Alive + 1
					PlayWav(Wav_PUp_Ankh,0,Player\X)
				EndIf
			Next

		Case 16											; PowerUp - Sword
			PlayWav(Wav_PUp_Sword,0,Player\X)

		Case 17											; PowerUp - Bag
			Player\Coins=Player\Coins + 3
			PlayWav(Wav_PUp_Bag,0,Player\X)

		Case 18											; PowerUp - Mine
			Player\Mines = Player\Mines + 3
			PlayWav(Wav_PUp_Mine,0,Player\X)

		Case 19											; PowerUp - 
			PlayWav(Wav_PUp_Stop,0,Player\X)

		Case 20											; PowerUp - 
			PlayWav(Wav_PUp_Stop,0,Player\X)

		Case 21											; PowerUp - 
			PlayWav(Wav_PUp_Stop,0,Player\X)

		Case 22											; PowerUp - 
			PlayWav(Wav_PUp_Stop,0,Player\X)

		Case 23											; PowerUp -
			PlayWav(Wav_PUp_Stop,0,Player\X)

	End Select

;	If Anim_Items(Map((Player\x+16)/C_ItemX,(Player\y+26)/C_ItemY)\Surface)\PUp<>7 Then
	If y<>7 Then										; Remove PowerUp
		Map((Player\x+16)/C_ItemX,(Player\y+26)/C_ItemY)\Surface=0
	EndIf
	
End Function


;------------------------------------------------------------------------------- PlayerShouldDie
Function PlayerShouldDie(Killer)

;Return

	If Player\YinYang=1 Then Player\YinYang=12

	If Player\YinYang<>0 Then Return

	Player\Dies=100
	Player\Anim=A_P_Death
	Player\AnimTimer=Anim_Player(A_P_Death)\AnimTime
	Player\StopTimer=0

	If Player\Nr<>Killer Then
		Player\Score=Player\Score - C_ScoreKilled
		For P.T_Player = Each T_Player
			If P\Nr=Killer Then P\Score=P\Score + C_ScoreKill
			If P\Dies=0 Then P\Score=P\Score + C_ScoreSurviver
		Next
	Else
		Player\Score=Player\Score - C_ScoreSuicide
	EndIf
	
	If Im_Player(Player\Image)\DeathCry<>0 Then PlaySound(Im_Player(Player\Image)\DeathCry)

	Kills(Player\Nr,Killer)=Kills(Player\Nr,Killer) + 1

End Function


;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------


;------------------------------------------------------------------------------ CheckPlayerColli
Function CheckPlayerColli(Filter)

If Player\Ghost<>0 Then Filter=Filter + Is_wall + Is_Bomb + Is_wall0 + Is_wall1 + Is_wall2

	Player\dl=0
	Player\dr=0
	Player\ul=0
	Player\ur=0
	Player\cl=0
	Player\cr=0
	Player\cu=0
	Player\cd=0
	
	Player\dl=Player\dl Or Anim_Items(Map((Player\x+00)/C_ItemX,(Player\y+26+16)/C_ItemY)\Ground)\Kind
	Player\dr=Player\dr Or Anim_Items(Map((Player\x+32)/C_ItemX,(Player\y+26+16)/C_ItemY)\Ground)\Kind
	Player\ul=Player\ul Or Anim_Items(Map((Player\x+00)/C_ItemX,(Player\y+26-16)/C_ItemY)\Ground)\Kind
	Player\ur=Player\ur Or Anim_Items(Map((Player\x+32)/C_ItemX,(Player\y+26-16)/C_ItemY)\Ground)\Kind

	Player\dl=Player\dl Or Anim_Items(Map((Player\x+00)/C_ItemX,(Player\y+26+16)/C_ItemY)\Surface)\Kind
	Player\dr=Player\dr Or Anim_Items(Map((Player\x+32)/C_ItemX,(Player\y+26+16)/C_ItemY)\Surface)\Kind
	Player\ul=Player\ul Or Anim_Items(Map((Player\x+00)/C_ItemX,(Player\y+26-16)/C_ItemY)\Surface)\Kind
	Player\ur=Player\ur Or Anim_Items(Map((Player\x+32)/C_ItemX,(Player\y+26-16)/C_ItemY)\Surface)\Kind



	Player\cr=Player\cr Or Anim_Items(Map((Player\x+32)/C_ItemX,(Player\y+26-0)/C_ItemY)\Ground)\Kind
	Player\cl=Player\cl Or Anim_Items(Map((Player\x+00)/C_ItemX,(Player\y+26-0)/C_ItemY)\Ground)\Kind
	Player\cd=Player\cd Or Anim_Items(Map((Player\x+16+0)/C_ItemX,(Player\y+26+16)/C_ItemY)\Ground)\Kind
	Player\cu=Player\cu Or Anim_Items(Map((Player\x+16+0)/C_ItemX,(Player\y+26-16)/C_ItemY)\Ground)\Kind

	Player\cr=Player\cr Or Anim_Items(Map((Player\x+32)/C_ItemX,(Player\y+26-0)/C_ItemY)\Surface)\Kind
	Player\cl=Player\cl Or Anim_Items(Map((Player\x+00)/C_ItemX,(Player\y+26-0)/C_ItemY)\Surface)\Kind
	Player\cd=Player\cd Or Anim_Items(Map((Player\x+16+0)/C_ItemX,(Player\y+26+16)/C_ItemY)\Surface)\Kind
	Player\cu=Player\cu Or Anim_Items(Map((Player\x+16+0)/C_ItemX,(Player\y+26-16)/C_ItemY)\Surface)\Kind


							; Any Items there ?
	z=Map( (Player\x+32)/C_ItemX ,(Player\y+26-0)/C_ItemY)\Item
	z2=Map( (Player\x+16)/C_ItemX ,(Player\y+26-0)/C_ItemY)\Item
	If (z<>0) And (z<>z2) Then Player\cr=Player\cr Or Anim_Items(Item(z)\Anim)\Kind
;	If (z<>0) And (z<>Player\LastBomb) Then Player\cr=Player\cr Or Anim_Items(Item(z)\Anim)\Kind
	z=Map( (Player\x+00)/C_ItemX ,(Player\y+26-0)/C_ItemY )\Item
	If (z<>0) And (z<>z2) Then Player\cl=Player\cl Or Anim_Items(Item(z)\Anim)\Kind
;	If (z<>0) And (z<>Player\LastBomb) Then Player\cl=Player\cl Or Anim_Items(Item(z)\Anim)\Kind
	z=Map( (Player\x+16)/C_ItemX ,(Player\y+26+16)/C_ItemY )\Item
	If (z<>0) And (z<>z2) Then Player\cd=Player\cd Or Anim_Items(Item(z)\Anim)\Kind
;	If (z<>0) And (z<>Player\LastBomb) Then Player\cd=Player\cd Or Anim_Items(Item(z)\Anim)\Kind
	z=Map( (Player\x+16)/C_ItemX ,(Player\y+26-16)/C_ItemY )\Item
	If (z<>0) And (z<>z2) Then Player\cu=Player\cu Or Anim_Items(Item(z)\Anim)\Kind
;	If (z<>0) And (z<>Player\LastBomb) Then Player\cu=Player\cu Or Anim_Items(Item(z)\Anim)\Kind


	Filter=65535 - Filter

	Player\cr=Player\cr And Filter
	Player\cl=Player\cl And Filter
	Player\cu=Player\cu And Filter
	Player\cd=Player\cd And Filter

	Player\ul=Player\ul And Filter
	Player\ur=Player\ur And Filter
	Player\dl=Player\dl And Filter
	Player\dr=Player\dr And Filter

End Function


;---------------------------------------------------------------------------- TryToPushSomething
; Tries to Push,Kick,Fist etc. something in the given direction
Function TryToDoSomething(Heading)

	If (Player\Ghost<>0) Then Return					; Invisible ?

	If Heading=1 Then
		x=(Player\x+16+00+0) / C_ItemX
		y=(Player\y+26-16-1) / C_ItemY
		xx=0
		yy=-1
	EndIf
	If Heading=2 Then
		x=(Player\x+16+16+1) / C_ItemX
		y=(Player\y+26-00-0) / C_ItemY
		xx=1
		yy=0
	EndIf
	If Heading=3 Then
		x=(Player\x+16+00+0) / C_ItemX
		y=(Player\y+26+16+1) / C_ItemY
		xx=0
		yy=1
	EndIf
	If Heading=4 Then
		x=(Player\x+16-16-1) / C_ItemX
		y=(Player\y+26+00+0) / C_ItemY
		xx=-1
		yy=0
	EndIf

	q=     Anim_Items(Map(x,y)\Ground)\Kind
	q=q Or Anim_Items(Map(x,y)\Surface)\Kind
	w=GetMap(x,y,0)
	
	If (q And Is_Wall) Then						; Wall hit !
		If Player\FistTimer>0 Then 				; Can Player fist it ?
			PutInMap(x, y, I_Wall_Burns,0)
			Map(x,y)\PUp=Map(x,y)\PUp+100		; reveal PUp
			PlayWav(Wav_HittingWall,0,x)
		Else
			TryToPushWall( x,y,xx,yy, Player\Nr)
		EndIf
	EndIf

	If (Player\FistTimer>0) Then
		If (q And Is_Wall0) Then 
			PutInMap(x, y,  I_CrumbleWall1,0) 	; Wall0 hit !
			PlayWav(Wav_HittingWall,0,x)
		EndIf
		If (q And Is_Wall1) Then
			PutInMap(x, y,  I_CrumbleWall2,0)  	; Wall1 hit !
			Map(x,y)\PUp=Map(x,y)\PUp+100		; reveal PUp
			PlayWav(Wav_HittingWall,0,x)
		EndIf
		If (q And Is_Wall2) Then
			PutInMap(x, y,  I_Wall_Crumbles,0) 	; Wall2 hit !
			PlayWav(Wav_HittingWall,0,x)
		EndIf
	EndIf

	If (Player\CanKickBombs>0) Then
		If (w And Is_Bomb) Then					; Bomb hit !
			If TryToPushBomb(x,y,xx,yy,Player\CanKickBombs)=1 Then
				PlayWav(Wav_Kickbomb,0,x)
			EndIf
		EndIf
	EndIf
	
	
End Function


;--------------------------------------------------------------------------------- TryToPushBomb
Function TryToPushBomb(mx,my,xx,yy,amount)

	If Map(mx,my)\Item<>0 Then 				; Bombitem found !
		q=Map(mx,my)\Item
	Else
		Return 0
	EndIf

	If (Item(q)\move<>0) Then Return 0		; still moving ? Then forget it


	w=GetMap2(mx+xx,my+yy,Is_Ice)			; what's next to me ?
	If (w And Is_Flame) Then				; Fire  Then explode right now
		IgniteBomb(q)
		Return 0
	EndIf

	If w<>0 Then Return 0					; no space ? Forget it !

											; Controllerbomb move always ONE field
	If (Item(q)\BombType=2) Or (Item(q)\BombType=12) Or (Item(q)\BombType=22) Then amount=1

	If (Map(mx+xx,my+yy)\Item=0) Then

		If Item(q)\Bombtype<10 Then
			If xx>0 Then Item(q)\Anim=I_BombRight
			If xx<0 Then Item(q)\Anim=I_BombLeft
			If yy>0 Then Item(q)\Anim=I_BombDown
			If yy<0 Then Item(q)\Anim=I_BombUp
		Elseif Item(q)\Bombtype<20
			If xx>0 Then Item(q)\Anim=I_Bomb2Right
			If xx<0 Then Item(q)\Anim=I_Bomb2Left
			If yy>0 Then Item(q)\Anim=I_Bomb2Down
			If yy<0 Then Item(q)\Anim=I_Bomb2Up
		Else
			If xx>0 Then Item(q)\Anim=I_Bomb3Right
			If xx<0 Then Item(q)\Anim=I_Bomb3Left
			If yy>0 Then Item(q)\Anim=I_Bomb3Down
			If yy<0 Then Item(q)\Anim=I_Bomb3Up
		EndIf


		Item(q)\xx=xx*2
		Item(q)\yy=yy*2

		Item(q)\Move=16 * amount
		Item(q)\MoveTimer=1        			; MoveTimer

											; Controllerbomb move SLOW
		If (Item(q)\BombType=2) Or (Item(q)\BombType=12) or (Item(q)\BombType=22) Then
			Item(q)\MoveTimer=2
;			For P.T_Player=Each T_Player	; find owner
;				If Item(q)\Owner=P\Nr Then
			If Player\Speed>CBombSpeed Then Item(q)\MoveTimer=1
;					Exit
;				EndIf
;			Next
		EndIf

		Item(q)\MaxMoveTime=Item(q)\MoveTimer
		
		Return 1
	EndIf
End Function


;--------------------------------------------------------------------------------- TryToPushWall
Function TryToPushWall(mx,my,xx,yy,owner)

	If Player\CanPushWalls=0 Then Return
	
	If ((Anim_Items(Map(mx+xx,my+yy)\Ground)\Kind And (65535-Is_Ice))=0) And (Anim_Items(Map(mx+xx,my+yy)\Surface)\Kind=0) Then
		If (Map(mx+xx,my+yy)\Item=0) Then
			q = BuildItem(mx, my, I_Wall, Player\Nr)
			Item(q)\LifeForce=6.6*Player\CanPushWalls	; LifeForce
			Item(q)\Move=6.6*Player\CanPushWalls
			Item(q)\xx=xx*5
			Item(q)\yy=yy*5
			Item(q)\MoveTimer=1             			; MoveTimer
			Item(q)\MaxMoveTime=Item(q)\MoveTimer
			Item(q)\Kind=I_Wall
			Item(q)\PUp=Map(mx,my)\PUp
			Item(q)\Owner=Owner

			Map(mx,my)\Surface=0
			Map(mx,my)\AnimTimer=0
			Map(mx,my)\PUp = 0

		EndIf
	EndIf
End Function


;--------------------------------------------------------------------------------------- DrawMap
Function DrawMap()
		
		
	For y=0 To Levely
		For x=0 To LevelX

											; Ground
			DrawBlock Im_Items,C_OffX + (x*C_ItemX),(y*C_ItemY),Anim_Items(Map(x,y)\Ground)\Frame

			If Map(x,y)\PUp>100 Then 
				DrawImage Im_Items,C_OffX + (x*C_ItemX),(y*C_ItemY),Anim_Items(Map(x,y)\PUp - 100 )\Frame
			EndIf

											; Surface
			If Map(x,y)\Surface<>0 Then
				DrawImage Im_Items,C_OffX + (x*C_ItemX),(y*C_ItemY),Anim_Items(Map(x,y)\Surface)\Frame
			EndIf

		Next
	Next

	For Thing.T_Item = Each T_Item
		If Thing<>Null Then					; in use ?
			DrawImage Im_Items,C_OffX + Thing\x, Thing\y, Anim_Items(Thing\Anim)\Frame
		EndIf
	Next

End Function



;------------------------------------------------------------------------------------- HandleMap
Function HandleMap()

	For y=0 To Levely
		For x=0 To LevelX

			If Map(x,y)\Surface<>0 Then							; Surface
				If Map(x,y)\AnimTimer>0 Then 					; Animated ?
					If Map(x,y)\AnimTimer=1 Then				; Yes - New Frame ?
						If Anim_Items(Map(x,y)\Surface)\nextItem=0 Then 
							PUp=Map(x,y)\PUp					; Reveals a PowerUP ???
							If (PUp<>0) And (PUp<>100) Then		; yes !
								If PUp>100 Then PUp=PUp-100
								PutInMap(x,y,PUp,0)

								If PUp=I_PUpStop Then PlayWav(Wav_Danger,0,0)

								Map(x,y)\PUp=0
							Else				; No...
								Map(x,y)\Surface=Anim_Items(Map(x,y)\Surface)\NextItem	; Set Frame
								Map(x,y)\AnimTimer=Anim_Items(Map(x,y)\Surface)\AnimTime	; Set Timer
							EndIf
						Else					; next Frame
							Map(x,y)\Surface=Anim_Items(Map(x,y)\Surface)\nextItem		; Set Frame
							Map(x,y)\AnimTimer=Anim_Items(Map(x,y)\Surface)\AnimTime	; Set Timer
						EndIf
					Else					; Yes - no new frame !
						Map(x,y)\AnimTimer=Map(x,y)\AnimTimer-1
					EndIf
				EndIf
			EndIf
		Next

;		HandleNetInput(False)

	Next


;	For z=1 To C_MaxItems							; Items
	For Thing.T_Item=Each T_Item

;	  If Thing<>Null Then 01.10.
		q=0
		If (Thing\AnimTimer=0) And (Thing\Move=0) And (Thing\Lifeforce=0) Then
			If Map(Thing\x/C_ItemX,Thing\y/C_ItemY)\Item<>Thing\Nr Then q=1
		EndIf
		If q=1 Then
			Delete Thing
		Else
;		If Item(z)\Anim<>0 Then						; in use ?
			If Thing\AnimTimer>0 Then				; Animated ?
				If Thing\AnimTimer=1 Then 			; animated - New Frame ?	
					If Anim_Items(Thing\Anim)\NextItem=0 Then	; Item must be removed
						Thing\Anim=0
						Map(Thing\x/C_ItemX,Thing\y/C_ItemY)\Item=0
					Else
						Thing\Anim=Anim_Items(Thing\Anim)\NextItem		; Set Frame
						Thing\AnimTimer=Anim_Items(Thing\Anim)\AnimTime	; Set Timer
					EndIf
				Else								; animated - no new frame !
					Thing\AnimTimer=Thing\AnimTimer-1
				EndIf
			EndIf



			If Thing\move<>0 Then							; Mover Set ?

				If Thing\MoveTimer>1 Then					; wait for movetimer
					Thing\MoveTimer=Thing\MoveTimer - 1
				Else
					If Thing\MoveTimer=1 Then 				; Let's move...
						Thing\Move=Thing\Move - 1
						x=Thing\x
						y=Thing\y
						Select Thing\Kind					; Move what ?

						Case I_Bomb,I_Bomb2,I_Bomb3				; BOMB - MOVES
							If Map((x+16)/C_ItemX,(y+16)/C_ItemY)\Item=Thing\Nr Then
								Map((x+16)/C_ItemX,(y+16)/C_ItemY)\Item=0
							EndIf
							Thing\x=Thing\x + Thing\xx
							If Thing\x<0 Then Thing\x=0
							Thing\y=Thing\y + Thing\yy
							If Thing\y<0 Then Thing\y=0
							Thing\MoveTimer=Thing\MaxMoveTime	; Restart Mover
							If Thing\xx>0 Then xx=16
							If Thing\xx<0 Then xx=-16
							If Thing\yy>0 Then yy=16
							If Thing\yy<0 Then yy=-16
							q=GetMap((Thing\x+16+xx)/C_ItemX,(Thing\y+16+yy)/C_ItemY, 0) And (65535-Is_Ice)
							If (q)<>0 Then
								If q And Is_Flame Then
									Thing\Anim=I_Wall_Burns
									q=q-1
								EndIf
								PlayWav(Wav_RollingBombBlocked,0,Thing\x)
								Thing\Move=0
;								Thing\LifeForce=1
								Thing\x=x
								Thing\y=y
							Else
								If ((Thing\x+16)/C_ItemX <> (X+16)/C_ItemX) Or ((Thing\y+16)/C_ItemY <> (Y+16)/C_ItemY) Then
									PlayWav(Wav_RollingBomb,0,Thing\x)
								EndIf
							EndIf
							Map((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY)\Item=Thing\Nr
							If Thing\Move=0 Then					; Round x/y to fit in map
								Thing\x=(Thing\x+16)/C_ItemX
								Thing\y=(Thing\y+16)/C_ItemY
								Thing\x=Thing\x*C_ItemX
								Thing\y=Thing\y*C_ItemY
								If Thing\Bombtype>=20 Then
									Thing\Anim=I_Bomb3
								elseIf Thing\Bombtype>=10 Then
									Thing\Anim=I_Bomb2
								Else
									Thing\Anim=I_Bomb
								EndIf
							EndIf

	
						Case I_Wall     					; WALL - MOVES
							If Map((x+16)/C_ItemX,(y+16)/C_ItemY)\Item=Thing\Nr Then
								Map((x+16)/C_ItemX,(y+16)/C_ItemY)\Item=0
							EndIf
							Thing\x=Thing\x + Thing\xx
							If Thing\x<0 Then Thing\x=0
							Thing\y=Thing\y + Thing\yy
							If Thing\y<0 Then Thing\y=0
							Thing\MoveTimer=Thing\MaxMoveTime	; Restart Mover
														
							If Thing\xx>0 Then xx=16
							If Thing\xx<0 Then xx=-16
							If Thing\yy>0 Then yy=16
							If Thing\yy<0 Then yy=-16
							q=GetMap((Thing\x+16+xx)/C_ItemX,(Thing\y+16+yy)/C_ItemY, 0) And (65535-Is_Ice)
							If (q)<>0 Then
								If q And Is_Flame Then
									Thing\Anim=I_Wall_Burns
									q=q-1
								EndIf
								Thing\Move=0
								Thing\LifeForce=1
								Thing\x=x
								Thing\y=y
							Else
								If ((Thing\x+16)/C_ItemX <> (X+16)/C_ItemX) Or ((Thing\y+16)/C_ItemY <> (Y+16)/C_ItemY) Then
									PlayWav(Wav_SlidingWall,0,Thing\x)
								EndIf
							EndIf
							Map((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY)\Item=Thing\Nr
	
	
	;						If ((Item(z,1)+16)/C_ItemX<>(x+16)/C_ItemX) Or ((Item(z,2)+16)/C_ItemY<>(y+16)/C_ItemY) Then
	;							PutInMap((Item(z,1)+16)/C_ItemX, (Item(z,2)+16)/C_ItemY, I_Explosion)
	;						EndIf
	
	
						
	
						Case I_Explosion					; EXPLOSION - SPREADS

							If Map((x+16)/C_ItemX,(y+16)/C_ItemY)\Item=Thing\Nr Then
								Map((x+16)/C_ItemX,(y+16)/C_ItemY)\Item=0
							EndIf

; DEBUG*********************
							If Thing\BombType=99 Then 
							If Thing\yy<>0 Then
								If (Thing\y Mod C_ItemY)=0 Then
									q = BuildItem((Thing\x+16)/C_ItemX,(Thing\y+16)/C_ItemY,I_RootExplosion,Thing\Owner)
									Item(q)\LifeForce=1 * C_ItemX / gBoomSpeed2
									Item(q)\Move=1 * C_ItemX / gBoomSpeed2
									Item(q)\xx=gBoomSpeed
									Item(q)\yy=0
									Item(q)\MoveTimer=1
									Item(q)\MaxMoveTime=Item(q)\MoveTimer
									Item(q)\Kind=I_Explosion
;									Item(q)\BombType=99
									q = BuildItem((Thing\x+16)/C_ItemX,(Thing\y+16)/C_ItemY,I_RootExplosion,Thing\Owner)
									Item(q)\LifeForce=1 * C_ItemX / gBoomSpeed2
									Item(q)\Move=1 * C_ItemX / gBoomSpeed2
									Item(q)\xx=-gBoomSpeed
									Item(q)\yy=0
									Item(q)\MoveTimer=1
									Item(q)\MaxMoveTime=Item(q)\MoveTimer
									Item(q)\Kind=I_Explosion
;									Item(q)\BombType=99
								EndIf
							EndIf
							If Thing\xx<>0 Then
								If (Thing\x Mod C_ItemX)=0 Then
									q = BuildItem((Thing\x+16)/C_ItemX,(Thing\y+16)/C_ItemY,I_RootExplosion,Thing\Owner)
									Item(q)\LifeForce=1 * C_ItemX / gBoomSpeed2
									Item(q)\Move=1 * C_ItemX / gBoomSpeed2
									Item(q)\xx=0
									Item(q)\yy=gBoomSpeed
									Item(q)\MoveTimer=1
									Item(q)\MaxMoveTime=Item(q)\MoveTimer
									Item(q)\Kind=I_Explosion
;									Item(q)\BombType=99
									q = BuildItem((Thing\x+16)/C_ItemX,(Thing\y+16)/C_ItemY,I_RootExplosion,Thing\Owner)
									Item(q)\LifeForce=1 * C_ItemX / gBoomSpeed2
									Item(q)\Move=1 * C_ItemX / gBoomSpeed2
									Item(q)\xx=0
									Item(q)\yy=-gBoomSpeed
									Item(q)\MoveTimer=1
									Item(q)\MaxMoveTime=Item(q)\MoveTimer
									Item(q)\Kind=I_Explosion
;									Item(q)\BombType=99
								EndIf
							EndIf
							EndIf

							Thing\x=Thing\x + Thing\xx
							If Thing\x<0 Then Thing\x=0
							Thing\y=Thing\y + Thing\yy
							If Thing\y<0 Then Thing\y=0
							Thing\MoveTimer=Thing\MaxMoveTime	; Restart Mover
							q=GetMap((Thing\x+16)/C_ItemX,(Thing\y+16)/C_ItemY, Is_PUp+Is_Flame) And (65535-Is_Ice)



							If (q)<>0 Then
								If (q And Is_Wall) Then		; Wall hit !
									PutInMap((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY, I_Wall_Burns,0)
									PUp=Map((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY)\PUp
									If PUp<>0 Then PUp=PUp+100
									Map((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY)\PUp=PUp
								EndIf
	
								If (q And Is_Wall0) Then	; Crumblewall0 hit !
									PutInMap((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY, I_CrumbleWall1,0)
								EndIf
	
								If (q And Is_Wall1) Then	; Crumblewall1 hit !
									PutInMap((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY, I_CrumbleWall2,0)
									Map((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY)\PUp=Map((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY)\PUp+100
								EndIf
	
								If (q And Is_Wall2) Then	; Crumblewall2 hit !
									PutInMap((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY, I_Wall_Crumbles,0)
								EndIf
	
								If (q And Is_Bomb) Then 	; Bomb hit !
									IgniteBomb(Map((Thing\x+16)/C_ItemX,(Thing\y+16)/C_ItemY)\Item)
								EndIf

								Thing\Move=0
								Thing\LifeForce=1
								Thing\x=x
								Thing\y=y
							EndIf
							Map((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY)\Item=z
							If ((Thing\x+16)/C_ItemX<>(x+16)/C_ItemX) Or ((Thing\y+16)/C_ItemY<>(y+16)/C_ItemY) Then
								PutInMap((Thing\x+16)/C_ItemX, (Thing\y+16)/C_ItemY, I_Explosion, Thing\Owner)
							EndIf
						End Select
					EndIf
				EndIf
			EndIf



			If Thing\LifeForce>1 Then 				; LifeForce set ?
				Thing\Lifeforce=Thing\LifeForce - 1
			Else
				If (Thing\LifeForce=1) And (Thing\MoveTimer=Thing\MaxMoveTime) Then	; LifeForce runs out
 					x=Thing\x
					y=Thing\y
					Select Thing\Kind					; of what ?

					Case I_Bomb,I_Bomb2,I_Bomb3					; BOMB - EXPLODES
						IgniteBomb(Thing\Nr)

					Case I_Explosion					; EXPLOSION - DIES
						Thing\Anim=0					; remove Flame
						Map((x+16)/C_ItemX,(y+16)/C_ItemY)\Item=0
						Delete Thing

					Case I_Wall							; WALL - STOPS
						PutInMap((x+16)/C_ItemX, (y+16)/C_ItemY, Thing\Anim, Thing\Owner)
						Map((x+16)/C_ItemX, (y+16)/C_ItemY)\PUp = Thing\PUp
						Thing\Anim=0					; remove Wall
						Map((x+16)/C_ItemX,(y+16)/C_ItemY)\Item=0
						Delete Thing

					End Select
				EndIf
			EndIf

;			If Thing\Anim=0 Then Delete Thing
		EndIf
	Next

End Function


;-------------------------------------------------------------------------------------- SHOWWINS
Function ShowWins()

	SetStatus(C___WINS)
	MaskImage Im_Other,0,0,0
 	create_blurballs()
  Font1=LoadFont( "Comic Sans MS",34,False )
  Font2=LoadFont( "Comic Sans MS",15,False )
  state = 0
  time = millisecs()
	fadegamma("init")
	
	;Glitter Cups
	cls
	z=558 / MaxPlayer
	y=70
	For Player=Each T_Player
		For x=1 To Player\Wins
			xx=75+(x*65)			
			DrawImage Im_Other,xx,y,12
			color 0,0,0
			rect xx-8,y-12,16,18,1
			GlitterInit(50,xx-30,xx+30,y-30,y+30)
		Next
		y=y + z
	Next

	;is there a winner?
	Winner=false
	For Player=Each T_Player
		If Player\Dies=0 Then Winner=Winner+1
	Next
	if Winner=MaxPlayer then Winner=false	
	
	;a little Joke
	if Net_Type = 0 and Winner=False and Rand(1,100)=50
		Joke = true
		JokePlayer=rand(1,MaxPlayer)
		i=1
		For Player=Each T_Player
			if i=JokePlayer then
				Player\Dies=0
			endif
			i=i+1
		next
	endif	
		
	;PixelSwarm missing cups
	cls
	z=558 / MaxPlayer
	y=70
	For Player=Each T_Player
		k=1
		If Player\Dies=0 Then k=2
		For x=Player\Wins+k To WinsNeeded
			DrawImage Im_Other,75+(x*65),y,14
		Next
		y=y + z
	Next
	PixelSwarmInit(0,0,0,0,0,2,1,800,600,2)
	
	;PixelSwarm winning cup
	cls
	z=558 / MaxPlayer
	y=70
	For Player=Each T_Player
		If Player\Dies=0 Then
			DrawImage Im_Other,75+((Player\Wins+1)*65),y,14
		endif
		y=y + z
	Next
	PixelSwarmInit(1,0,0,0,0,2,1,800,600,2)
	if Joke then PixelSwarmInit(2,0,0,0,0,2,1,800,600,0)
	
  repeat
  	NET_Listen()
  	cls	
		select state
			case 0:
			if (fadegamma("lighten"))			
				PlayWav(WAV_Fanfare,0,0)
				state = 10
			endif			
			case 10:			
			if (CHANNELPLAYING(wav_id(WAV_Fanfare)) = 0)
				If Winner or Joke Then
					PlayWav(WAV_GotCup,0,0)
					
					PixelSwarmSetState(1,"explode")
					z=558 / MaxPlayer
					y=70
					For Player=Each T_Player
						If Player\Dies=0 Then							
							if Winner then Player\Score=Player\Score+C_ScoreWin 							
							Player\Wins=Player\Wins + 1
							xx=75+(Player\Wins*65)
							DrawImage Im_Other,xx,y,12
							color 0,0,0
							rect xx-8,y-12,16,18,1
							GlitterInit(50,xx-30,xx+30,y-30,y+30)
						EndIf
						y=y+z
					Next	
				else
					PlayWav(WAV_DrawnGame,0,0)	
				EndIf
				state = 20
			endif
			
			case 20:
			For Player=Each T_Player
				if Net_Type <> 1
					Player\Keys=GetDevice("")
			  	if Player\Keys And 16
						if Joke
					  	state = 21
					  	time = millisecs()
							PlayWav(Wav_PUp_Q_InputInverted,0,0)		
						else	
							state = 30
							fadegamma("init")
							SetStatus(C___BEGINGAME)
						endif			
					endif
				elseif GameStatus<>C___WINS
					state = 30
					fadegamma("init")
				endif
			next

			case 21:
			if (time + 4000  < millisecs())
				state = 23
				time=millisecs()			
			endif

			case 23:
			z=558 / MaxPlayer
			y=70
			For Player=Each T_Player
				If Player\Dies=0 Then							
					Player\Dies=1 							
					Player\Wins=Player\Wins-1
					PixelSwarmSetState(2,"activate2")
					PlayWav(WAV_DrawnGame,0,0)
					xx=75+((Player\Wins+1)*65)
					GlitterDestroy(xx-30,xx+30,y-30,y+30)
				EndIf
				y=y+z
			Next
			
			if (time + 2000  < millisecs()) 	
				state = 30
				fadegamma("init")	
			endif
												
			case 30:
			if fadegamma("darken")  then state = 500	
				
		end select
		
		draw_blurballs()
		SetFont Font1
		Color 255,255,255
		Text 400,5,"Standings",True
		SetFont Font2
		
		z=558 / MaxPlayer
		y=70
		For Player=Each T_Player
			DrawImage Im_Player(Player\Image)\Image,48,y-10,0
			Text 48,y+12,Player\Name$,True
			For x=1 To Player\Wins
				DrawImage Im_Other,75+(x*65),y,12
			Next
			y=y + z
		Next
		glitterupdate()
		PixelSwarmUpdate()
		if state = 21
			SetFont Font1
			color 0,0,0
			rect 150,275,500,50,1
			color 255,255,255
			rect 150,275,500,50,0
			text 400,300,"Hey guys, it was only a joke, so cool down!!!",1,1
		endif
		
		WaitTimer(Timer)
  	flip
  	
  	
  until state > 400
 	
  destroy_blurballs()
  GlitterDestroy()
  PixelSwarmSetState(0,"destroyall")
  
  freefont Font1
  Freefont Font2
	MaskImage Im_Other,43,108,3
	
  clscolor 0,0,0
  cls
  flip 0
	cls
	
	fadegamma("init")
End Function


;------------------------------------------------------------------------------------- SHOWKILLS
Function ShowKills()

	SetStatus(C___KILLS)

  FlushMouse
  create_blurballs(1)
		
	Font1=LoadFont( "Comic Sans MS",34,False )
	Font2=LoadFont( "Comic Sans MS",15,False )
	
	color 255,255,255
	state = 0	
	fadegamma("init")
	
	Repeat
		cls
		draw_blurballs()
		SetFont Font1
		Text 400,5,"Killboard",True
		For x=1 To MaxPlayer
			For y=1 To MaxPlayer
			Text 77+(x*75),87+(y*52),Kills(x,y),True
			Next
		Next
		
	  SetFont Font2
		Text 40+40,80   ,"Victim"
		Text 40   ,80+30,"Killer"
	
		y=150
		For Player=Each T_Player
			DrawImage Im_Player(Player\Image)\Image,100,y,0
			Text 50,y,Player\Name$,True
			Text 50,y+15,Player\Score,True
			y=y + 52
		Next
	
		x=70
		For Player=Each T_Player
			DrawImage Im_Player(Player\Image)\Image,80+x,100,0
			Text x+80,65,Player\Name$,True
			x=x+75
		Next
		
		select state
		case 0:
			if fadegamma("lighten") and (Net_Type<>1 And (MouseDown(1) Or KeyDown(1)) Or (GameStatus<>C___KILLS))
				state = 10
				fadegamma("init")	
			endif
		case 10:
			if fadegamma("darken")	state = 500
		end select		
		
		WaitTimer(Timer)
		flip
			
		NET_Listen()

	Until state > 400	
	
  destroy_blurballs()
	FreeFont Font1
	FreeFont Font2

	ClsColor 0,0,0
  cls
  flip
	cls
	
	fadegamma("init")

	Action$=""	

End Function


;------------------------------------------------------------------------------------ ShowWinner
Function ShowWinner()

	dim video_name$(C_MaxPlVideos)
	
	SetStatus(C___WINNER)
	;PlayWav(Wav_Crowd,0,0)

	SetBuffer BackBuffer()
	Color 0,0,0
	Cls
	
	Font=LoadFont( "Comic Sans MS",15,False )


	z=0												; how much winner are there ?
	maxscore = 0
	movie = 0
	For Player=Each T_Player
		If Player\Wins=WinsNeeded Then
			
			if Video_on
				if Player\Score > maxscore then
					maxscore = Player\Score
					dir=ReadDir("video\")
					video_count = 0
					Repeat
						name$=NextFile$(dir)
						If name$="" Then Exit
						low_name$=Lower$(name$)
						If Instr(low_name$,Lower$(player\name$),1)<>0
							video_name$(video_count) = name$
							video_count = video_count+1					
						EndIf
					until video_count >=C_MaxPlVideos
				  closedir dir
				
				  if video_count > 0 then
						video_nr = Rand(1,video_count)
					  if movie <> 0 then CLOSEMOVIE movie
						movie=OPENMOVIE("Video\"+video_name$(video_nr-1))
					endif
				endif
			endif
		  		
			z=z+1
			Player\X=400
			Player\Y=340
			Player\AnimTimer=10
			Player\Anim=A_P_Down
			Player\Speed=5
			Player\Score=Player\Score+C_ScoreWinner
		EndIf
		HS_Insert(Player\Name$,Player\Score,CURRENTDATE$())
	Next
	
	if movie <> 0 and Video_on then
		flushmouse
		repeat
			DRAWMOVIE movie,0,0,C_ScreenX,C_ScreenY
			flip
			NET_Listen()
			Action$=""
			If (Mousehit(1)) Then Action$="ESC"
		until movieplaying (movie) = 0  or (Action$="ESC") Or (GameStatus<>C___WINNER)
		CLOSEMOVIE movie
		flushmouse			
	endif

  Playsong("music\other\my_butterfly.mp3")	
  
  color 255,255,255
	TempFont=LoadFont("font\Highlight LET.ttf",200,1 )
	SetFont TempFont
	cls
	text 400,200,"WINNER",1,1
	PixelSwarmInit(0,400,300,15,$ffffffff,0,0.5)
	PixelSwarmInit(1,400,300,15,$ffffffff,1,0.5)
	freefont TempFont
	cls	
	PixelSwarmSetState(0)
	PixelSwarmSetState(1)
	
	init_starsky()
	PlayWav(Wav_Crowd,0,0)
	
	Repeat
		
		update_starsky()
		PixelSwarmUpdate()
		
		color 255,255,255
		SetFont Font
		x=0
		For Player=Each T_Player
			If Player\Wins=WinsNeeded Then
				Player\x=450-(Z*50)+(x*100)-C_OFFX
				DrawThisPlayer(Player)
				Text Player\X+C_OffX,Player\Y+26,Player\Name,True
				Select Rand(100*Z)
				Case 1
					Player\Anim=A_P_UP
					Player\AnimTimer=0
				Case 2
					Player\Anim=A_P_Right
					Player\AnimTimer=0
				Case 3
					Player\Anim=A_P_Down
					Player\AnimTimer=0
				Case 4
					Player\Anim=A_P_Left
					Player\AnimTimer=0
				End Select
				x=x+1
			EndIf
		Next
		
		AnimatePlayers()

   	If Rockets<4 Then
			If Rand(0,10)=0 Then
				If Rand(0,2)=0 Then PlayWav(Wav_FireWorxStart,0,0)
				Rockets=Rockets+1
				i.T_firework=New T_firework		;Generate a new Firework
				i\x=150+(Rand(0,1)*500)
				i\y=600
				i\xspeed#=Rnd(-1.5,1.5)			;Give Random X Speed
				i\yspeed#=Rnd(-4,-6)			;Give Random Y Speed

				i\Farbe=Rand(0,8)
				i\Kind=1
				i\Life=255
				i\Power=Rnd(75,105)
				i\maxlife=i\life
			EndIf
		EndIf

		For i.T_firework=Each T_firework
			i\X#=i\X#+i\xspeed#				;Move X Position
			i\y#=i\y#+i\yspeed#				;Move Y Position
			If i\Power=0 Then
				i\Yspeed#=i\YSpeed#+0.1		;Add Gravity Acceleration
			Else
				i\Power=i\Power-1
			EndIf

			c=(220*(i\Life/i\MaxLife))+25
			s#=i\farbe
			If s=8 Then s=Rand(1,6)
			Select s
			Case 0,7	Color c,c,c
			Case 1		Color c,20,20
			Case 2		Color 20,c,20
			Case 3		Color 20,20,c
			Case 4		Color c,c,20
			Case 5		Color c,20,c
			Case 6		Color 20,c,c
			End Select

			Select i\Kind
			Case 1
				Plot i\x  ,i\y
				Plot i\x  ,i\y+1
				Plot i\x  ,i\y-1
				Plot i\x+1,i\y+1
				Plot i\x-1,i\y+1
				j.T_firework=New T_firework			;Generate a new Firework
				j\x=i\x
				j\y=i\y
				j\xspeed#=Rnd(-0.3,0.3);(i\xspeed / 3)+Rnd(-0.4,0.4)
				j\yspeed#=-2+Rnd(-0.5,0.5)
				j\farbe=i\farbe
				j\Kind=2
				j\Power=0
				j\Life=Rnd(15,20)
				j\maxlife=j\life


				If i\Power=0 Then				; EXPLODE
					PlayWav(Wav_FireWorxBoom,0,0)
					s#=Rnd(0.1,0.6)
					t#=Rnd(0,0.01)*50
					For zz#=0 To 359 Step 4
						si#=Sin(zz)*3
						co#=Cos(zz)*3
						j.T_firework=New T_firework			;Generate a new Firework
						j\x=i\x+(si*2)
						j\y=i\y+(co*2)
						j\xspeed#=(i\xspeed/2)+(si*t)+Rnd(-s,s)
						j\yspeed#=(i\yspeed/2)+(co*t)+Rnd(-s,s)
						j\farbe=i\farbe
						j\Kind=3
						j\Power=0
						j\Life=Rand(60,120)
						j\maxlife=j\life
					
						zz#=zz#+Teil
					Next

					Delete i	;Delete firework
					rockets=rockets-1
				EndIf

			Case 2
				Plot i\x  ,i\y

				If (i\Life>0) And (i\y>0) Then
					i\Life=i\Life-1
				Else
					Delete i	;Delete firework
				EndIf

			Case 3
				If (i\Life>0) And (i\y<600) Then
					i\Life=i\Life-1
					If (i\life<30) And ((i\Farbe=0) Or (i\Farbe=7)) Then
						If Rand(30+(i\Life*4))=3 Then
							Color 255,255,255
							Line i\x-3,i\y,i\x+3,i\y
							Line i\x,i\y-3,i\x,i\y+3
							Line i\x-3,i\y+1,i\x+3,i\y+1
							Line i\x+1,i\y-3,i\x+1,i\y+3
							Delete i
						Else
							Plot i\x  ,i\y
							Plot i\x  ,i\y+1
							Plot i\x  ,i\y-1
							Plot i\x+1,i\y
							Plot i\x-1,i\y
						EndIf
					Else
						Plot i\x  ,i\y
						Plot i\x  ,i\y+1
						Plot i\x  ,i\y-1
						Plot i\x+1,i\y
						Plot i\x-1,i\y
					EndIf
				Else
					Delete i	;Delete firework
				EndIf
		
			End Select
		Next


		Flip False;False ;Net_Type=0
		If (Debug_Fast=False) Then WaitTimer(Timer)

		Cls
		
		NET_Listen()

		Action$=""
		If (Net_Type<>1) And (MouseDown(1)) Then Action$="ESC"

	Until (Action$="ESC") Or (GameStatus<>C___WINNER)
	
	destroy_starsky()
	PixelSwarmSetState(0,"destroyall")
	For i.T_firework=Each T_firework
		delete i
	next
	rockets = 0
	FreeFont Font
	
	Action$=""
	
	StopAllSounds()

End Function



;-------------------------------------------------------------------------------- ShowHighscores
Function ShowHighscores()

	
	Font=LoadFont("Arial",120,1 )
	SetFont Font
	
	sleep(500)

	state	= 0
	
	cls
	flip
	cls
	
	color 255,255,255
	text 400,80,"HIGHSCORES",1,1
	PixelSwarmInit(0,C_ScreenX/2,30,200,0,0,0.6)
	
	cls
	Im_Image2 = loadimage("gfx\blue.png")
	midhandle Im_Image2
	ScaleIMAGE Im_Image2,1.5,1.5
	drawimage Im_Image2,400,300
	
	Rotating_Logo_Init()
	freeimage Im_Image2
	
	Font=LoadFont( "Comic Sans MS",34,False )
	SetFont Font
	

	PixelSwarmSetState(0)
	;PixelSwarmSetState(1)
	;PixelSwarmSetState(2)
	;UpdateSwarms(1000)

	Playsong("music\other\fehler.mp3")
	time 	= millisecs()
		
	t =millisecs()
	x = 1
	repeat
		cls
		select state
			case 0:
	 			if time+4200<millisecs() then state = 10
			case 10:
				if time+485<millisecs() then
	 				time = millisecs()
	 				CreateTxt( 107,120+(x*40),x+".",255,25*x,25*x)
	 				CreateTxt( 160,120+(x*40),HSName$(x),15*x,15*x,255)
					CreateTxt( 415,120+(x*40),HSScore(x),15*x,255,15*x)
					CreateTxt( 545,120+(x*40),HSDate$(x),255,255,15*x)
					x=x+1
					if x > 10 then state = 20
	 			endif
	 		case 20:
	 			if time+11500<millisecs() then
				 	state = 30
					x			=400
				endif
	 		case 30:
	 			if(x>9) then x=x-20
	 			Rotating_Logo_Update(200*sin(logo_angle2*0.1)+100*sin(logo_angle2*0.2)+x,100*cos(logo_angle2*0.2+logo_angle/10)+100*sin(logo_angle2*0.5))
				logo_angle3 = logo_angle3 + rand(5) 			
		end select
		
		text_update()
		PixelSwarmUpdate()
    	
	 	waittimer(Timer)
	 	flip 0
		 	 	
	 	NET_Listen()
	 	Action$=""
	 	If (Net_Type<>1) And (mousedown(1)) and t+500<millisecs() Then Action$="ESC"
	 	
	Until (Action$="ESC") Or (GameStatus<>C___HIGHSCORES)
	
	PixelSwarmSetState(0,"destroyall")
	text_destroy()
	Rotating_Logo_destroy()
	
	FreeFont Font
	SetFont Font_24
	
	Action$=""
	Mouse_Click$=""
	click_lock = 30
	
End Function


;-------------------------------------------------------------------------------- WheelofFortune

Function WheelOfFortune()

	If Wheel_On=False Then Return

  Playsong("music\other\spring_jump.mp3")
  
	If Net_Type <> 1 Then ;not the joiner?
  	Brake=Rand(50,200)
  	Wheel_Value=Rand(MaxPlayer*4)
  	If Net_Type = 2 then ;Host?
  		dat$=lset(Brake,3)+lset(Wheel_Value,2)
			SendNetMsg(56,dat$,Net_MyNetID,0,True)			; Send Status
		endif
	endif
	SetStatus(C___WHEEL)
	
	SetBuffer BackBuffer()
	Color 0,0,0
	
	MaskImage Im_Other,0,0,0

  color 255,255,255
	Font=LoadFont("Arial",100,1 )
	SetFont Font
	cls
	text 400,200,"WHEEL",1,1
	text 400,300,"OF",1,1
	text 400,400,"FORTUNE",1,1
	PixelSwarmInit(0,400,300,50,$FF88FF88,0,0.5)
	;PixelSwarmInit(1,400,300,15,$FF88FF88,1,0.5)
	freefont Font
	cls	
	PixelSwarmSetState(0)
	;PixelSwarmSetState(1)
	
	Font=LoadFont( "Comic Sans MS",15,False )
	SetFont Font
	
	Color 255,255,255

	
	Part=360/MaxPlayer

	Speed#=500
	Angle#=Part*Wheel_Value
	LastPing=0
	starfield_init()
	ready=0
	Repeat
		cls
		PixelSwarmUpdate()
		If Brake=0 Then
			If Speed>35 Then Speed=Speed - 2
		Else
			Brake=Brake - 1
		EndIf
		Angle=Angle + (Speed/50)
;		If Angle>360 Then Angle=Angle-360

		If (Angle-LastPing)>Part Then
			PlayWav(Wav_WheelofFortune,0,0)
			LastPing = Int(Angle/Part)*Part
		EndIf

		NET_Listen()

    starfield_update()
    
;		Cls
		For Player=Each T_Player			; Draw Players
			z1= 250*Sin(Angle+(Player\Nr*Part))
			z2=-250*Cos(Angle+(Player\Nr*Part))
            z1=400+(z1)
            z2=300+(z2)
			DrawImage Im_Player(Player\Image)\Image,z1,z2,0
			SetFont Font
			Text z1,z2+27,Player\Name$,True;+" "+Player\Coins,True
			If (Z1>=390) And (Z1<=400) And (Z2<55) And (Speed<50) Then
				speed=(400-Z1)*5
				Winner=Player\Nr
			EndIf
		Next

		DrawImage Im_Other,400,120,13

    if (ready>0) then
			ready=ready+1
			DrawImage Im_Items,400,50,98
		endif
		
		
		If Net_Type=0 Then
			Flip True
		Else
			Flip False
			WaitTimer(Timer)
		EndIf
		
		if (speed=0 and ready=0)
			For Player=Each T_Player
				If Player\Nr=Winner Then Player\Coins=Player\Coins+1
			Next
			PlayWav(Wav_PUp_Coin,0,0)
			ready = 1
		endif	
		
	Until (ready>100)

	cls
	flip 0
	
  starfield_destroy()
  PixelSwarmSetState(0,"destroyall")
	MaskImage Im_Other,43,108,3
	FreeFont Font
	
End Function


;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------

Include "GameStuff.bb"

Include "MBData.bb"

;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
