;-----------------------------------------------------------------------------------------------
; Master Blaster
;
; Game-Functions
;
;-----------------------------------------------------------------------------------------------


;------------------------------------------------------------------------------------- SetStatus
Function WaitTimer(vTimer)
		Repeat
		Until (WaitEvent()=$4001) And (EventSource()=vTimer)
End Function

;------------------------------------------------------------------------------------- SetStatus
Function SetStatus(NewStatus)
	GameStatus=NewStatus
	NET_SendStatus(0)
End Function


;------------------------------------------------------------------------------------ Screenshot
Function Screenshot()
If KeyDown(59) Then							;F1 SCREENSHOT
	Image=CreateImage(800,600,1,1)
	GrabImage Image,0,0
	x=0
	Repeat
		x=x+1
	Until FileType("C:\"+"CAP"+X+".bmp")=0
	SaveImage (Image,"C:\"+"CAP"+X+".bmp")
	FreeImage Image
	Print "SAVING......."
	Sleep(300)
EndIf
End Function

;--------------------------------------------------------------------------------------- NetSync
Function NET_SendStatus(ID)
	If Net_Type<>2 Then Return					; not the Host ?

	Select GameStatus
		Case C___MAIN

		Case C___NET

		Case C___GAME
    	NET_Broadcast("GAMEDATA")
		Case C___WHEEL

		Case C___SHOP
			NET_Broadcast("SHOPDATA")

		Case C___WINS

		Case C___WINNER

		Case C___KILLS
			NET_Broadcast("KILLS")

	End Select

	dat$=lset(GameStatus,2)+lset(gSpecialRound,2)
	SendNetMsg(2,Dat$,Net_MyNetID,ID,True)			; Send Status

End Function


;----------------------------------------------------------------------------------- HandleInput
Function HandleInput()

	If Net_Type<>1 Then
	
		i = 0
		For Player = Each T_Player
			x = GetDevice("")
			i = i or (x and 32)
		next
		
		Select Paused										; Pause key ?
		Case 0: If i    Then Paused=1
		Case 1:	If i=0 	Then Paused=2
		Case 2: If i 		Then Paused=3
		Case 3: If i=0 	Then Paused=0
		End Select
	EndIf
	
	;Music Volume
	if keydown(53) and keydown(27) = 0 and mv_oldtime + 100 < millisecs() then
		mv_oldtime = millisecs()
		musicvolume_changed = true
	 	musicvolume = musicvolume-0.05
	 	if musicvolume < 0 then musicvolume = 0
	endif
	
	if keydown(27) and keydown(53) = 0 and mv_oldtime + 100 < millisecs() then
		mv_oldtime = millisecs()
		musicvolume_changed = true
	 	musicvolume = musicvolume+0.05
	 	if musicvolume > 1 then musicvolume = 1
	endif
	 	


;	If IOTimer<3 Then
;		IOTimer=IOTimer + 1
;		;Return
;	EndIf
;	IOTimer=0


	dat$=""
	For Player = Each T_Player
		If Player\NetID=Net_MyNetID Then 					; LOCAL PLAYER ?
			If (Player\StopTimer<>0) Then
				Player\Keys=(Player\Keys And 16)			; Stoped ? Remember Button !
			Else
				If ((player\c And Is_Ice)=0) Then
					If Player\Disease=1 Then				; Inverted ?
						y=0
						x=GetDevice("")						; get Input
						If (x And 1) Then y=(y Or 4)
						If (x And 2) Then y=(y Or 8)
						If (x And 4) Then y=(y Or 1)
						If (x And 8) Then y=(y Or 2)
						If (x And 16) Then y=(y Or 16)
						Player\Keys=y
					Else
						Player\Keys=GetDevice("")			; get Input
					EndIf
				EndIf
			EndIf
			dat$=dat$+LSet$(Player\Nr,2)					; build NetString
			dat$=dat$+LSet$(Player\Keys,3)
		EndIf
	Next
	
	If Net_Type=1 Then										; JOINER ?
		SendNetMsg(50,Dat$,Net_MyNetID,Net_HostID,False)	; Send Keycodes to HOST
	EndIf

End Function


;-------------------------------------------------------------------------------- HandleNetInput
Function NET_HandleNetwork(Sync)
	If Net_Type=0 Then Return					; No Multiplayer ?

	NET_Listen()								; Listen to Network...
	
	If (Net_Type=2) And (Sync) Then				; Send Data to network...
		If (Roundtime Mod 2)=0 Then
			NET_Broadcast("MAP")				; Send Map
		Else
			NET_Broadcast("ITEMS")  			; Send Items
			NET_Broadcast("PLAYERS")			; Send Players
			NET_Broadcast("TIMER")				; Send Timers,etc.
		EndIf
	EndIf	
End Function


;------------------------------------------------------------------------------------- GetDevice
Function GetDevice(Mode$)
	
	
	if Player\InputDev = 0 then ;KEYBOARD
	
		
		Keys = 0
		Keys = Keys Or ( (KeyDown(Player\DevCodeUp1)    or KeyDown(Player\DevCodeUp2)    or KeyDown(Player\DevCodeUp3)    or KeyDown(Player\DevCodeUp4))    * 1) ;up
		Keys = Keys Or ( (KeyDown(Player\DevCodeRight1) or KeyDown(Player\DevCodeRight2) or KeyDown(Player\DevCodeRight3) or KeyDown(Player\DevCodeRight4)) * 2)
		Keys = Keys Or ( (KeyDown(Player\DevCodeDown1)  or KeyDown(Player\DevCodeDown2)  or KeyDown(Player\DevCodeDown3)  or KeyDown(Player\DevCodeDown4))  * 4)
		Keys = Keys Or ( (KeyDown(Player\DevCodeLeft1)  or KeyDown(Player\DevCodeLeft2)  or KeyDown(Player\DevCodeLeft3)  or KeyDown(Player\DevCodeLeft4))  * 8)
		Keys = Keys Or ( (KeyDown(Player\DevCodeBomb1)  or KeyDown(Player\DevCodeBomb2)  or KeyDown(Player\DevCodeBomb3)  or KeyDown(Player\DevCodeBomb4))  * 16)
		Keys = Keys Or ( (KeyDown(Player\DevCodePause1)  or KeyDown(Player\DevCodePause2)  or KeyDown(Player\DevCodePause3)  or KeyDown(Player\DevCodePause4))  * 32)

	else 		 										;JOYSTICK
	
  	joy_number = Player\InputDev-1
  	
  	
		x = 0
		if (JoyGet(joy_number,Player\DevCodeLeft1) +JoyGet(joy_number,Player\DevCodeLeft2) +JoyGet(joy_number,Player\DevCodeLeft3) +JoyGet(joy_number,Player\DevCodeLeft4)) < 0
  		x = -1
  	endif
  	if (JoyGet(joy_number,Player\DevCodeRight1)+JoyGet(joy_number,Player\DevCodeRight2)+JoyGet(joy_number,Player\DevCodeRight3)+JoyGet(joy_number,Player\DevCodeRight4))> 0
      x = x+1
    endif
    
		y = 0
		if (JoyGet(joy_number,Player\DevCodeUp1)   +JoyGet(joy_number,Player\DevCodeUp2)   +JoyGet(joy_number,Player\DevCodeUp3)   +JoyGet(joy_number,Player\DevCodeUp4))   < 0
  		y = -1
  	endif
  	
  	if (JoyGet(joy_number,Player\DevCodeDown1) +JoyGet(joy_number,Player\DevCodeDown2) +JoyGet(joy_number,Player\DevCodeDown3) +JoyGet(joy_number,Player\DevCodeDown4)) > 0
      y = y+1
		endif
   		
		B1 = JoyGet(joy_number,Player\DevCodeBomb1) or JoyGet(joy_number,Player\DevCodeBomb2) or JoyGet(joy_number,Player\DevCodeBomb3) or JoyGet(joy_number,Player\DevCodeBomb4)
		
		B2 = JoyGet(joy_number,Player\DevCodePause1) or JoyGet(joy_number,Player\DevCodePause2) or JoyGet(joy_number,Player\DevCodePause3) or JoyGet(joy_number,Player\DevCodePause4)

		Keys = 0
		Keys = Keys Or ((y=-1) * 1)
		Keys = Keys Or ((x=1) * 2)
		Keys = Keys Or ((y=1) * 4)
		Keys = Keys Or ((x=-1) * 8)
		Keys = Keys Or (B1 * 16)
		Keys = Keys Or (B2 * 32)
		
	endif

	Return Keys
End Function




function JoyGet(joy_number,devcode)

	i=0
	if devcode < 20
		select devcode
		case 1
			if joyx(joy_number) > 0.1
				i = 1
			elseif joyx(joy_number) < -0.1
				i = -1
			endif
		case 2
			if joyY(joy_number) > 0.1
				i = 1
			elseif joyY(joy_number) < -0.1
				i = -1
			endif  	
		case 3
			if joyZ(joy_number) > 0.1
				i = 1
			elseif joyZ(joy_number) < -0.1
				i = -1
			endif
		case 4
			if joyroll(joy_number) > 10
				i = 1
			elseif joyroll(joy_number) < -10
				i = -1
			endif
		case 5
			if joyhat(joy_number) = 90
				i = 1
			elseif joyhat(joy_number) = 270
				i = -1
			endif
		case 6
			if joyhat(joy_number) = 180
				i = 1
	 		elseif joyhat(joy_number) = 0
	 			i = -1
	  	endif			
		default
			i = 0
		end select
	else
		if joydown(devcode-19,joy_number) then i = 1
	endif
				
	return i

end function


;------------------------------------------------------------------------------------------Sleep
Function Sleep(msec)
	xx=MilliSecs()
	While MilliSecs()<xx+msec
		If ((MilliSecs()-xx) Mod 50)=0 Then NET_Listen()
	Wend
End Function

;------------------------------------------------------------------------------------ NET_Listen
Function NET_Listen()
	If Net_Type=0 Then Return					; No Multiplayer ?


	Net_Timer=Net_Timer + 1
	If Net_Timer>=100 Then	;100
		Net_Timer=0
		If Net_Type=1 Then						; Joiner
			NET_Broadcast("JOINERSTATUS")
		EndIf
	EndIf


	Counter=0
	While (RecvNetMsg()) And (Counter<15)
		Counter=Counter+1
		ID=NetMsgFrom()
		Dat$=NetMsgData$()
		Select NetMsgType()

		Case 1										; Set Sender to HOST
			TempComp.T_NetComp=Menu_FindComp(ID)
			If TempComp<>Null
				TempComp\isHost=True
				Net_HostID=TempComp\NetID
			EndIf
			While dat$<>""
				X=Int(Left(dat$,10))
				TempComp.T_NetComp=Menu_FindComp(X)
				If TempComp<>Null Then
					TempComp\Name$=Trim$(Mid$(dat$,11,10))
				EndIf
				If x=NetMyNetID Then Net_MyName$=Trim$(Mid$(dat$,11,10))
				dat$=Mid$(dat$,21)
			Wend
			

		Case 2										; Got Hoststatus
			HisStatus=Left$(Dat$,2)
			gSpecialRound=right$(Dat$,2);!!!
			If HisStatus<>GameStatus Then			; wrong condition ??

				Select HisStatus					; change Status...
				Case C___GAME
					P.T_Player=First T_Player		; if Players are up
					If P<>Null Then GameStatus=HisStatus
					
				Case C___SHOP
					If ShopPlayer<>0 Then GameStatus=HisStatus

				Case C___KILLS						; if Kills are up
					If Kills(0,0)=1 Then GameStatus=HisStatus

				Default
					GameStatus=HisStatus

				End Select
			EndIf
			

		Case 3										; Got a Joinerstatus
			HisStatus=Left$(Dat$,1)
;			HisPlayer=Mid$(dat$,2,1)
			If HisStatus<>GameStatus Then			; wrong condition ??
				NET_SendStatus(ID)
;			Else
;				If (HisStatus=C___SHOP) And (HisPlayer<>ShopPlayer) Then
;					NET_Broadcast("SHOPDATA")
;				EndIf
			EndIf
			

		Case 10										; Add Player
			TempComp=Menu_FindComp(Left$(dat$,10))	;NetMsgFrom() )
			TempComp\Name$=Trim$(Mid$(dat$,11,10))
			dat$=Mid$(dat$,21)
			a$=Trim$(Mid$(dat$,43,30))
			x=0
			For y=0 To MaxPlayerImage
				If Upper$(Im_Player(y)\file$)=Upper$(a$) Then x=y
			Next
			Menu_AddPlayer(Left$(Dat$,40),TempComp\Name$,TempComp\NetID,Mid$(Dat$,41,1),x,Mid$(Dat$,42,1))


		Case 11										; Kill Player
			TempComp=Menu_FindComp(Left$(dat$,10));NetMsgFrom() )
			Temp=Trim$(Mid$(dat$,11,10))
			dat$=Trim$(Mid$(dat$,21))
			For Net_Player= Each T_NetPlayer
				If (Net_Player\Name$=dat$) Then
					Delete Net_Player
					MaxPlayer=MaxPlayer-1
					Exit
				EndIf
			Next

		Case 31								; Shopdata
;			If (GameStatus=C___SHOP) Then	; only in shop
				If ShopPlayer<>Dat$ Then
;DebugLog Shopplayer+"->"+dat$
					ShopPlayer=Dat$
				EndIf
				
;			EndIf
;				Player=Null
;				For Player=Each T_Player
;					If Player\Nr=ShopPlayer Then Exit
;				Next
;				If Player=Null Then RuntimeError "FUCKSHIT"
				
;					If Player\Nr<>Left$(Dat$,2) Then
;						For Player=Each T_Player
;							If Player\Nr=Left$(Dat$,2) Then Exit
;						Next
;					EndIf
;				EndIf
;				If (Player<>Null) Then
;					If (Player\Nr=ShopPlayer) Then
;						Player\X=Mid$(Dat$,3,3)
;						Player\Y=Mid$(Dat$,6,3)
;					EndIf
;				EndIf
;			EndIf

		Case 40								; GAMEDATA
			RandomSeed			=Left(dat$,10)
			Game_Mode		=Mid$(dat$,11,1)
			WinsNeeded		=Mid$(dat$,12,2)
			Shop_On			=Mid$(Dat$,14,1)
			Menu_Shrinking_On	=Mid$(Dat$,15,1)
			Wheel_On		=Mid$(Dat$,16,1)
			B_Time			=Mid$(Dat$,17,2)
			Menu_Alarm_On			=Mid$(Dat$,19,1)
			Video_On			=Mid$(Dat$,20,1)
			Level			=Mid$(Dat$,21,1)
			Special_On		=Mid$(Dat$,22,1)

			For x=0 To 20
				MaxItems(x)=Mid$(dat$,23+2*x,2)
			Next


;		Case 42								; MOUSEDATA
;			xmouse_host			=Left(dat$,3)
;			ymouse_host 		=Mid$(dat$,4,3)
;			mouseclick_host =Mid$(dat$,7,1)
			
		Case 44
			For x=0 To 10							; Killermatrix
				For y=0 To 10
					Kills(x,y)=Mid$(Dat$,1+(x*22)+(y*2),2)
				Next
			Next


		Case 50 									; Movement received
			If (GameStatus=C___SHOP) Or (GameStatus=C___GAME) Then ; only in game/shop
				While dat$<>""
					who=Mid$(dat$,1,2)
					keys=Mid$(dat$,3,3)
					dat$=Mid$(dat$,6)
					Ok=False
					For P.T_Player=Each T_Player	; find Player
						If who=P\Nr Then
							P\Keys=Keys
							Ok=True
						EndIf
					Next
					If Ok=False Then
						RuntimeError "NETWORK ERROR"+Chr(13)+"Netplayer "+who+" not found !"
					EndIf
				Wend
			EndIf


		Case 51	
								; Map received
			For y=0 To Levely
				For x=0 To LevelX
					Map(x,y)\Ground	=Mid$(Dat$,1+(y*(Levelx+1)*9)+(x*9)  ,3)
					Map(x,y)\Surface=Mid$(Dat$,1+(y*(Levelx+1)*9)+(x*9)+3,3)
					Map(x,y)\PUp	=Mid$(Dat$,1+(y*(Levelx+1)*9)+(x*9)+6,3)
				Next
			Next
			gGotMap=True


		Case 52										; Items received
			Delete Each T_Item						; remove all Items
			If (GameStatus=C___GAME) Then			; Only in game
				While dat$<>""
					While Item(ItemCounter)<>Null
						ItemCounter=ItemCounter + 1
						If ItemCounter>C_MaxItems Then ItemCounter=1
						If (ItemCounter=Check) Then	RuntimeError "NETWORK ERROR"+Chr(13)+"Item stack overflow !"
					Wend
					Item(ItemCounter)=New T_Item
					Item(ItemCounter)\Anim=Mid$(dat$,7,3)
					Item(ItemCounter)\x=Mid$(dat$,1,3)
					Item(ItemCounter)\y=Mid$(Dat$,4,3)
					Item(ItemCounter)\Nr=ItemCounter
					ItemCounter=ItemCounter + 1
					If ItemCounter>C_MaxItems Then ItemCounter=1
					dat=Mid$(dat$,10)
				Wend
			EndIf
				

		Case 53										; Player received
			While dat$<>""
				who=Mid$(dat$,1,1)
				Ok=False
				For P.T_Player=Each T_Player		; find Player
					If who=P\Nr Then
						P\Score=Mid$(dat$,2,4)
						P\x=Mid$(dat$,6,3)
						P\y=Mid$(dat$,9,3)
						P\Dies=Mid$(dat$,12,3)
						P\Disease=Mid$(dat$,15,1)
						P\DiseaseTimer=Mid$(dat$,16,5)
						P\StopTimer=Mid$(dat$,21,3)
						P\Coins=Mid$(dat$,24,2)
						P\Anim=Mid$(dat$,26,3)
						P\AnimTimer=Mid$(dat$,29,3)
						P\YinYang=Mid$(dat$,32,1)
						P\YinYangFrame=Mid$(dat$,33,3)
						P\YinYangAnimTimer=Mid$(dat$,36,3)
						P\Ghost=Mid$(dat$,39,1)
						P\GhostFrame=Mid$(dat$,40,3)
						P\wins=Mid$(dat$,43,2)
						Exit
					EndIf
				Next
				dat$=Mid$(dat$,45)
			Wend
			gGotPlayer=True
				
	
		Case 54										; Time received
			Darkness =Mid$(Dat$,1,1)
			Paused	 =Mid$(Dat$,2,1)
			Roundtime=Mid$(Dat$,3)
			
		Case 55										; Wave received
			x =	Dat$
			if (GameStatus = C___GAME or GameStatus = C___SHOP) then PlayWav(x,0,0)


		Case 56										; values for wheel of fortune
			Brake		 			=Mid$(Dat$,1,3)
			Wheel_Value	 	=Mid$(Dat$,4,2)
					
		Case 98										; Chat-message
			TempComp.T_NetComp=Menu_FindComp(ID)
			If TempComp<>Null
				Menu_InfoText(TempComp\Name$+": "+Dat$ )
			EndIf


;		Case 99										; ESC/END
;			Action$=Dat$


		Case 100									; New Computer joined
			If (Net_Type=2) Then 					; If HOST -> Get a free name...
				vX = 0
				Repeat
					vX = vX + 1
					vOk = True
					name$="Comp "+vX
					For TestComp.T_NetComp = Each T_NetComp
						If TestComp\Name$=name$ Then vOk = False
					Next
				Until (vOk)
					
				For Net_Player=Each T_NetPlayer		; Send all Player to new computer
					dat$=LSet(Net_Player\CompID,10)
					dat$=dat$+LSet(Net_Player\CompName$,10)
					dat$=dat$+LSet(Net_Player\Name$,40)
					dat$=dat$+LSet(Net_Player\Team,1)
					dat$=dat$+LSet(Net_Player\Device,1)
					dat$=dat$+LSet(Im_Player(Net_Player\Hero)\File$,30)
					SendNetMsg(10,Dat$,Net_MyNetID,ID,True)
				Next

			EndIf
			
			TempComp=Net_Comp
			Net_Comp = New T_NetComp
			Net_Comp\NetID=NetMsgFrom()
			Net_Comp\Name$=name$
			Net_Comp\IsHost=False
			Net_CompCount=Net_CompCount + 1
			If name$<>"" Then Menu_InfoText( Net_Comp\name$+" has joined the game." )
			Net_Comp=TempComp

		Case 101									; Computer left the game
			TempComp=Menu_FindComp( NetMsgFrom() )
			If TempComp<>Null
				For Net_Player=Each T_NetPlayer
					If Net_Player\CompID=TempComp\NetID Then
						Delete Net_Player
						MaxPlayer=MaxPLayer-1
					EndIf
				Next
				Menu_InfoText( TempComp\name$+" has left the game. " )
				Delete TempComp
				Net_CompCount=Net_CompCount - 1
			Else
				Menu_InfoText("!!! UNKNOWN COMPUTER LEFT THE GAME !!!")
			EndIf

		Case 102
			GameStatus=C___Main
			Return
			RuntimeError "NETWORK ERROR"+Chr$(13)+"Host is lost !"
			TempComp=Menu_FindComp(Net_MyNetID)
			Net_Type=2
			TempComp\IsHost=True
			Menu_InfoText( "Host aborts the game..." )
			Mouse_Click$="ESCAPE"

		Case 200
			RuntimeError "NETWORK ERROR"+Chr$(13)+"The session has been lost!"
			End

		End Select
	Wend
	
End Function

;-------------------------------------------------------------------------------- NET_Breoatcast
Function NET_Broadcast(what$)
If Net_Type=0 Then Return						; No Multiplayer ?

Select what$


Case "HOSTDATA"
	dat$=""
	For Net_Comp = Each T_NetComp
		Dat$=dat$+LSet$(Net_Comp\NetID,10)
		Dat$=Dat$+LSet$(Net_Comp\Name$,10)
	Next
	SendNetMsg(1,Dat$,Net_MyNetID,0,True)


Case "JOINERSTATUS"
	Dat$=LSet$(GameStatus,1);+LSet$(ShopPlayer,1)
	SendNetMsg(3,Dat$,Net_MyNetID,Net_HostID,False)
	

Case "SHOPDATA"
	Dat$=ShopPlayer
;DebugLog "SHOPDATA:"+Dat$
	SendNetMsg(31,dat$,Net_MyNetID,0,False)		; SEND THIS PLAYER


Case "MAP"
	dat$=""
	For y=0 To Levely
		For x=0 To LevelX
			Dat$=Dat$+lset(Map(x,y)\Ground,3)+lset(Map(x,y)\Surface,3)+lset(Map(x,y)\PUp,3)
		Next
	Next
	SendNetMsg(51,Dat$,Net_MyNetID,0,False)		; Broadcast


Case "ITEMS"
	dat$=""
	For Thing.T_Item = Each T_Item				; send Items
		dat$=dat$+LSet(Thing\x,3)
		dat$=dat$+LSet(Thing\y,3)
		dat$=dat$+LSet(Thing\Anim,3)
	Next
	SendNetMsg(52,Dat$,Net_MyNetID,0,False)		; Broadcast


Case "PLAYERS"
	dat$=""
	For P.T_Player=Each T_Player				; Send Player
		dat$=dat$+LSet(P\Nr,1)
		dat$=Dat$+LSet(P\Score,4)
		dat$=Dat$+LSet(P\x,3)
		dat$=dat$+LSet(P\y,3)
		dat$=dat$+LSet(P\Dies,3)
		dat$=dat$+LSet(P\Disease,1)
		dat$=dat$+LSet(P\DiseaseTimer,5)
		dat$=dat$+LSet(P\StopTimer,3)
		dat$=dat$+lset(P\Coins,2)
		dat$=dat$+lset(P\Anim,3)
		dat$=dat$+LSet(P\AnimTimer,3)
		dat$=dat$+LSet(P\YinYang,1)
		dat$=dat$+LSet(P\YinYangFrame,3)
		dat$=dat$+LSet(P\YinYangAnimTimer,3)
		dat$=dat$+LSet(P\Ghost,1)
		dat$=dat$+LSet(P\GhostFrame,3)
		dat$=dat$+lset(P\Wins,2)
	Next
	SendNetMsg(53,Dat$,Net_MyNetID,0,False)		; Broadcast


Case "TIMER"
	If (Darkness=0) Or (Lightning>0) Then		; Send Timers
		dat$="0"
	Else
		dat$="1"
	EndIf
	If Paused=0 Then
		Dat$=Dat$+"0"
	Else
		Dat$=Dat$+"1"
	EndIf
	dat$=Dat$+LSet(RoundTime,6)
	SendNetMsg(54,Dat$,Net_MyNetID,0,False)		; Broadcast
	

Case "GAMEDATA"
	RandomSeed=MilliSecs()
	SeedRnd RandomSeed
	dat$=LSet(RandomSeed,10)
	dat$=dat$+LSet(Game_mode,1)
	dat$=dat$+LSet(WinsNeeded,2)
	dat$=dat$+LSet(Shop_On,1)
	dat$=dat$+LSet(Menu_Shrinking_On,1)
	dat$=dat$+LSet(Wheel_On,1)
	dat$=dat$+LSet(B_Time,2)
	dat$=dat$+LSet(Menu_Alarm_On,1)
	dat$=dat$+LSet(Video_On,1)
	dat$=dat$+LSet(Level,1)
	dat$=dat$+LSet(Special_On,1)

	For x=0 To 20
		dat$=dat$+LSet(MaxItems(x),2)
	Next
	SendNetMsg(40,dat$,Net_MyNetID,0,True)		; SEND RANDOM-SEED,etc

;Case "MOUSEDATA"
;	dat$=LSet(xmouse,3)
;	dat$=dat$+LSet(ymouse,3)
;	if MouseHitx<>-1
;		dat$=dat$+"1"
;	else
;	  dat$=dat$+"0"
;	endif
;	SendNetMsg(42,dat$,Net_MyNetID,0,True)
	
	

Case "KILLS"
	dat$=""
	For x=0 To 10
		For y=0 To 10
			dat$=dat$+LSet(Kills(x,y),2)
		Next
	Next
;	debuglog dat$
	SendNetMsg(44,dat$,Net_MyNetID,0,False)		; Broadcast


;Case "READY"
;	SendNetMsg(96,"+",Net_MyNetID,Net_HostID,True); READY from JOINER


;Case "GO"
;	SendNetMsg(97,"GO",Net_MyNetID,0,True)		; GO from SERVER


Case "CHAT"										; Chat-Messages
	SendNetMsg(98,Net_chat$,Net_MyNetID,0,True)


;Case "ESC"
;	SendNetMsg(99,"ESC",Net_MyNetID,0,True)		; ESC


;Case "END"
;	SendNetMsg(99,"END",Net_MyNetID,0,True)		; END


;Case "START"
;	SendNetMsg(99,"START",Net_MyNetID,0,True)	; START


Default
	RuntimeError "NETWORK ERROR"+Chr(13)+"Broadcasting '"+what$+"' failed !"
	
End Select

End Function


;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;--------------------------------------------------------------------------------- TryToDropBomb
Function TryToDropBomb()

	mx=(Player\x+16)/C_ItemX
	my=(Player\y+26)/C_ItemY

														; Controller ?
	If (Player\BombKind=2) Then
		If (Player\TimeBomb=0) And (Player\Bombs>0) Then ; enough bombs and space ??
	  		If ((Anim_Items(Map(mx,my)\Ground)\Kind And (65535-Is_Ice))=0) And (Anim_Items(Map(mx,my)\Surface)\Kind=0) Then
				If (Map(mx,my)\Item=0) Then
					If Player\Disease=2 Then			
						z = BuildItem(mx,my,I_Bomb3,Player\Nr)
					elseIf Player\Disease=7 Then			; NUKEBOMB
						z = BuildItem(mx,my,I_Bomb2,Player\Nr)
					Else
						z = BuildItem(mx,my,I_Bomb,Player\Nr)
					EndIf
					Player\lastBomb=z					; remember this Bomb !
					Player\Bombs=Player\Bombs - 1
					Player\TimeBomb=z
					Item(z)\LifeForce=0					; has no lifeforce
					If Player\Disease=2 Then			; Smallbomb ?
						Item(z)\Range=1
					Else
						Item(z)\Range=Player\Fire
					EndIf
					Item(z)\xx=0
					Item(z)\yy=0
					Item(z)\MoveTimer=0
					If Player\Disease=7 Then
						Item(z)\BombType=12
					ElseIf Player\Disease=2 then
					  Item(z)\BombType=22
					else
						Item(z)\BombType=2
					EndIf

					Player\BombKind=3
					Player\Ghost=0
					
					PlayWav(Wav_DropBomb,0,Player\x)	; Play Dropbomb
					
					
				EndIf
			EndIf
		EndIf

		Return

	EndIf


	
	If (Player\Bombs>0) Then							; enough bombs and space ??
		If ((Anim_Items(Map(mx,my)\Ground)\Kind And (65535-Is_Ice))=0) And (Anim_Items(Map(mx,my)\Surface)\Kind=0) Then
		If (Map(mx,my)\Item=0) Then
			
			If Player\BombKind=0 Then							; drop a simple bomb

      	If Player\Disease=2 Then			
					z = BuildItem(mx,my,I_Bomb3,Player\Nr)
				elseIf Player\Disease=7 Then						; NUKEBOMB
					z = BuildItem(mx,my,I_Bomb2,Player\Nr)
				Else
					z = BuildItem(mx,my,I_Bomb,Player\Nr)
				EndIf
				Player\lastBomb=z								; remember this Bomb !
				Player\Bombs=Player\Bombs - 1
				Item(z)\LifeForce=Player\BombTicks
				If Player\Disease=2 Then			; Smallbomb ?
					Item(z)\Range=1
				Else
					Item(z)\Range=Player\Fire
				EndIf
				Item(z)\xx=0
				Item(z)\yy=0
				Item(z)\MoveTimer=0
					If Player\Disease=7 Then
						Item(z)\BombType=10
					ElseIf Player\Disease=2 then
					  Item(z)\BombType=20
					else
						Item(z)\BombType=0
					EndIf

					If Player\Disease<>5 Then
						PlayWav(Wav_DropBomb,0,Player\x)	; Play Dropbomb
					Else
						PlayWav(Wav_ShitBomb,0,Player\x)	; Play Bombshit
					EndIf

				Player\Ghost=0
			EndIf

			If (Player\BombKind=1) And (Player\TimeBomb=0) Then	; drop a Timebomb
				If Player\Disease=2 Then			
						z = BuildItem(mx,my,I_Bomb3,Player\Nr)
				elseIf Player\Disease=7 Then						; NUKEBOMB
					z = BuildItem(mx,my,I_Bomb2,Player\Nr)
				Else
					z = BuildItem(mx,my,I_Bomb,Player\Nr)
				EndIf
				Player\lastBomb=z								; remember this Bomb !
				Player\Bombs=Player\Bombs - 1
				Player\TimeBomb=z
				Item(z)\LifeForce=0								; has no lifeforce
				If Player\Disease=2 Then						; Smallbomb ?
					Item(z)\Range=1
				Else
					Item(z)\Range=Player\Fire
				EndIf
				Item(z)\xx=0
				Item(z)\yy=0
				Item(z)\MoveTimer=0

				If Player\Disease=7 Then
						Item(z)\BombType=11
					ElseIf Player\Disease=2 then
					  Item(z)\BombType=21
					else
						Item(z)\BombType=1
					EndIf

				PlayWav(Wav_DropBomb,0,Player\x)				; Play Dropbomb

				Player\Ghost=0
			EndIf
		EndIf
		EndIf
	EndIf
End Function



;----------------------------------------------------------------------------------- DrawPlayers
Function DrawPlayers()

	For x=1 To MaxPlayer					; SORT PLAYERS
		y=9999
		P.T_Player=Null
		For Player = Each T_Player
			If (Player\y<y) And (Player\Drawn=False) Then
				y=Player\y
				P=Player
			EndIf
		Next
		If P<>Null Then DrawThisPlayer(P)
	Next

	For Player = Each T_Player
		Player\Drawn=False
	Next
	
End Function


;-------------------------------------------------------------------------------- DrawThisPlayer
Function DrawThisPlayer(Player.T_Player)

		If Player\Dies<>1 Then								; only living Players
			
			If Player\Ghost Mod 4=0 Then					; normal Player

				If Player\Anim<>0 Then

;					DrawAlpha(Im_Player(Player\Image),Anim_Player(Player\Anim)\Frame,150+Player\X, Player\y, 0.1)
					If Player\StopTimer<>0 Then
						q=Player\StopTimer Mod 20
						If q< 5 Then
							Player\Anim=A_P_StandUp
						Else
							If q<10 Then
								Player\Anim=A_P_StandRight
							Else
								If q<15 Then
									Player\Anim=A_P_StandDown
								Else
									Player\Anim=A_P_StandLeft
								EndIf
							EndIf
						EndIf
					EndIf
					DrawImage Im_Player(Player\Image)\Image,C_OffX + Player\x,Player\y,Anim_Player(Player\Anim)\Frame

					If Player\YinYang<>0 Then
						If (Player\YinYang Mod 2 )=1 Then		; YinYang ???
							DrawImage Im_Other,C_OffX + Player\x -2,Player\y, Player\YinYangFrame
						EndIf
					EndIf
					
					If Player\Disease<>0 Then					; DISEASE ???
						If Player\Disease=7 Then
							DrawImage(Im_Disease,C_OffX+Player\x,Player\y,10+(Player\DiseaseTimer Mod 20)/2);Rand(10)-1)
						Else
							DrawImage(Im_Disease,C_OffX+Player\x,Player\y,(Player\DiseaseTimer Mod 20)/2);Rand(10)-1)
						EndIf
					EndIf
					
				
				EndIf
			Else											; GHOST

;				DrawAlpha(Im_Ghost,Player\GhostFrame ,150+Player\X, Player\y, 0.4)
				z=Player\GhostFrame
				If z<10 Then
					DrawImage Im_Other,C_OffX+Player\x,Player\y+4, 30+z
				Else
					DrawImage Im_Other,C_OffX+Player\x ,Player\y+4, 30+18-z
				EndIf

				Player\GhostFrame=Player\GhostFrame+1
				If Player\GhostFrame>=18 Then Player\GhostFrame=0;12

			EndIf

		EndIf	; player is dead

		Player\Drawn=True
		
End Function


;-------------------------------------------------------------------------------- AnimatePlayers
Function AnimatePlayers()

	For Player = Each T_Player

		If Player\YinYang>0 Then
			If Player\YinYangAnimTimer=0 Then
				Player\YinYangAnimTimer=2
				Player\YinYangFrame = Player\YinYangFrame + 1
				If Player\YinYangFrame=4 Then
					Player\YinYangFrame = 0
					If Player\YinYang>2 Then Player\yinYang=Player\YinYang - 1
					If Player\YinYang=2 Then Player\YinYang=0
				EndIf
			Else
				Player\YinYangAnimTimer=Player\YinYangAnimTimer - 1
			EndIf
		EndIf

		If (RoundTime>=AlarmTime) And (Player\Ghost>0) Then ; remove Ghosts if alarm
			Player\Ghost=Player\Ghost - 1
		EndIf

		If Player\StopTimer>0 Then Player\StopTimer=Player\StopTimer - 1
		If Player\FistTimer>0 Then Player\fistTimer=Player\Fisttimer - 1

		If Player\AnimTimer=0 Then
			Player\Anim=Anim_Player(Player\Anim)\NextAnim

			If (Player\Dies<>0) And (Player\Anim-A_P_Death)>Im_Player(Player\Image)\DeathAnims Then
				Player\Anim=0
			EndIf
			
			If Player\Dies=0 Then
				Player\AnimTimer=Anim_Player(Player\Anim)\AnimTime + 5 - Player\Speed;3 - (2*Player\Speed)
			Else
				If (Player\Dies=94) And (Shop_On) Then
					mx=(Player\x+16)/C_ItemX
					my=(Player\y+26)/C_ItemY
					q=GetMap(mx,my,Is_Free+Is_Ice)
					If q=0 Then PutInMap(Mx,My,I_PUpCoin,0)
				EndIf
				If Player\Dies=2 Then
					Alive=Alive - 1
				EndIf
				If Player\Dies>1 Then Player\Dies=Player\Dies - 1
				Player\AnimTimer=Anim_Player(Player\Anim)\AnimTime
			EndIf
		Else
			Player\AnimTimer=Player\AnimTimer - 1
		EndIf

		If Player\Disease<>0 Then
			If Player\DiseaseTimer>0 Then Player\DiseaseTimer=Player\DiseaseTimer-1
			If Player\DiseaseTimer=0 Then Player\Disease=0
		Else
			For P.T_Player =Each T_Player		; Player-Player collision
				If (P\Disease<>0) And (P\Dies=0) Then
					If (P\x>Player\X-15) And (P\x<Player\X+15) And (P\y>Player\Y-20) And (P\y<Player\Y+20) Then
						Player\Disease=P\Disease
						Player\DiseaseTimer=1000
						If Player\Disease=6 Then
							Player\BombKind=0
							If Player\TimeBomb<>0 Then Item(Player\TimeBomb)\LifeForce=1
						EndIf
					EndIf
				EndIf
			Next
		EndIf

	Next

End Function


;------------------------------------------------------------------------------------ IgniteBomb
Function IgniteBomb(z)

	x=(Item(z)\x+16)/C_ItemX
	y=(Item(z)\y+16)/C_ItemY
	
	If Darkness>0 Then Lightning=13				; Lightning if Darkness

	WallBomb=False
	For P.T_Player=Each T_Player				; find owner
		If Item(z)\Owner=P\Nr Then
			P\Bombs=P\Bombs + 1
			If P\Disease=3 Then WallBomb=True
			If P\TimeBomb=z Then				; was his Timebomb ?
				P\TimeBomb=0
			EndIf
			If P\BombKind=3 Then				; was his Controllerbomb ?
				P\BombKind=2
			EndIf
			If P\StopTimer<>0 Then P\Keys=0		; Release button if stopped
		EndIf
	Next
	Item(z)\Anim=0								; Kill Bomb
	Map(x,y)\Item=0

	If WallBomb=True Then						; Wallbomb ???
		PlayWav(Wav_BoomSheep,0,Item(z)\x)		; Play Smallbomb
		PutInMap(x,y,I_Wall_Builds,Item(z)\Owner)
		If Shop_On=True Then
			Map(x,y)\PUp=I_PUpCoin
		Else
			Map(x,y)\PUp=I_PUpUnknown
		EndIf
		If GetMap(x-1, y,0)=0 Then
			PutInMap(x-1,y,I_Wall_Builds,Item(z)\Owner)
			Map(x-1,y)\PUp=0
		EndIf
		If GetMap(x+1, y,0)=0 Then
			PutInMap(x+1,y,I_Wall_Builds,Item(z)\Owner)
			Map(x+1,y)\PUp=0
		EndIf
		If GetMap(x, y-1,0)=0 Then
			PutInMap(x,y-1,I_Wall_Builds,Item(z)\Owner)
			Map(x,y-1)\PUp=0
		EndIf
		If GetMap(x, y+1,0)=0 Then
			PutInMap(x,y+1,I_Wall_Builds,Item(z)\Owner)
			Map(x,y+1)\PUp=0
		EndIf
	Else
		If Item(z)\Range<>1 Then
			PlayWav(Wav_Boom+Rand(0,15),0,Item(z)\x); Play a BOOM
		Else
			PlayWav(Wav_BoomSmall,0,Item(z)\x)		; Play Smallbomb
		EndIf
												; Create Center-Explosion
		PutInMap(x,y,I_Explosion,Item(z)\Owner)
												; Create Right-Explosion
		q = BuildItem(x,y,I_RootExplosion,Item(z)\Owner)
		Item(q)\LifeForce=Item(z)\Range * C_ItemX / gBoomSpeed2
		Item(q)\Move=Item(z)\Range * C_ItemX / gBoomSpeed2
		Item(q)\xx=gBoomSpeed
		Item(q)\yy=0
		Item(q)\MoveTimer=1						; MoveTimer
		Item(q)\MaxMoveTime=Item(q)\MoveTimer
		Item(q)\Kind=I_Explosion
		If Item(z)\BombType>=10 and Item(z)\BombType<20 Then Item(q)\BombType=99

												; Create Left-Explosion
		q = BuildItem(x,y,I_RootExplosion,Item(z)\Owner)
		Item(q)\LifeForce=Item(z)\Range * C_ItemX / gBoomSpeed2
		Item(q)\Move=Item(z)\Range * C_ItemX / gBoomSpeed2
		Item(q)\xx=-gBoomSpeed
		Item(q)\yy=0
		Item(q)\MoveTimer=1						; MoveTimer
		Item(q)\MaxMoveTime=Item(q)\MoveTimer
		Item(q)\Kind=I_Explosion
		If Item(z)\BombType>=10 and Item(z)\BombType<20 Then Item(q)\BombType=99
												; Create Up-Explosion
		q = BuildItem(x,y,I_RootExplosion,Item(z)\Owner)
		Item(q)\LifeForce=Item(z)\Range * C_ItemX / gBoomSpeed2
		Item(q)\Move=Item(z)\Range * C_ItemX / gBoomSpeed2
		Item(q)\xx=0
		Item(q)\yy=-gBoomSpeed
		Item(q)\MoveTimer=1						; MoveTimer
		Item(q)\MaxMoveTime=Item(q)\MoveTimer
		Item(q)\Kind=I_Explosion
		If Item(z)\BombType>=10 and Item(z)\BombType<20 Then Item(q)\BombType=99
												; Create Down-Explosion
		q = BuildItem(x,y,I_RootExplosion,Item(z)\Owner)
		Item(q)\LifeForce=Item(z)\Range * C_ItemX / gBoomSpeed2
		Item(q)\Move=Item(z)\Range * C_ItemX / gBoomSpeed2
		Item(q)\xx=0
		Item(q)\yy=gBoomSpeed
		Item(q)\MoveTimer=1						; MoveTimer
		Item(q)\MaxMoveTime=Item(q)\MoveTimer
		Item(q)\Kind=I_Explosion
		If Item(z)\BombType>=10 and Item(z)\BombType<20 Then Item(q)\BombType=99

	EndIf

	Delete Item(z)								; delete bomb
	
End Function


;------------------------------------------------------------------------------------- SetupPlayers
Function SetupPlayers()

	x=1
	For NetPlayer.T_NetPlayer=Each T_NetPlayer
	
		NetPlayer\Nr=X
		x=x+1
		Player.T_Player = New T_Player			; generate standard player
		Player\Name$=NetPlayer\Name$
		Player\InputDev=NetPlayer\Device
		Player\DevCodeLeft1=NetPlayer\DevCodeLeft1
		Player\DevCodeLeft2=NetPlayer\DevCodeLeft2
		Player\DevCodeLeft3=NetPlayer\DevCodeLeft3
		Player\DevCodeLeft4=NetPlayer\DevCodeLeft4
		Player\DevCodeRight1=NetPlayer\DevCodeRight1
		Player\DevCodeRight2=NetPlayer\DevCodeRight2
		Player\DevCodeRight3=NetPlayer\DevCodeRight3
		Player\DevCodeRight4=NetPlayer\DevCodeRight4
		Player\DevCodeUp1=NetPlayer\DevCodeUp1
		Player\DevCodeUp2=NetPlayer\DevCodeUp2
		Player\DevCodeUp3=NetPlayer\DevCodeUp3
		Player\DevCodeUp4=NetPlayer\DevCodeUp4
		Player\DevCodeDown1=NetPlayer\DevCodeDown1
		Player\DevCodeDown2=NetPlayer\DevCodeDown2
		Player\DevCodeDown3=NetPlayer\DevCodeDown3
		Player\DevCodeDown4=NetPlayer\DevCodeDown4
		Player\DevCodeBomb1=NetPlayer\DevCodeBomb1
		Player\DevCodeBomb2=NetPlayer\DevCodeBomb2
		Player\DevCodeBomb3=NetPlayer\DevCodeBomb3
		Player\DevCodeBomb4=NetPlayer\DevCodeBomb4
		Player\DevCodePause1=NetPlayer\DevCodePause1
		Player\DevCodePause2=NetPlayer\DevCodePause2
		Player\DevCodePause3=NetPlayer\DevCodePause3
		Player\DevCodePause4=NetPlayer\DevCodePause4		
				
		Player\Team=NetPlayer\Team
		Player\NetID=NetPlayer\CompID
		Player\Image=NetPlayer\Hero
		Player\Nr=NetPlayer\Nr
		Player\Speed=Player_StartSpeed
		Player\Bombs=1
		Player\Fire=2
		Player\BombKind=0;2
		Player\CanPushWalls=0
		Player\CanKickBombs=0
		Player\BombTicks=BombTicks/1000*C_FPS
		Player\YinYang=0
		Player\Anim=A_P_StandDown
		Player\Ghost=0
		Player\Score=1500
		Player\Wins=0
		
;   debuglog Player\Name$
; 	debuglog Player\Team
;		debuglog Player\NetID
;		debuglog Player\Image
;		debuglog Player\Nr
;		debuglog " "
	Next
		
End Function

;------------------------------------------------------------------------------------- InitRound
Function InitRound()

	Sleep(300)
	If Net_Type<>1 Then 							; HOST ?

	HalfPlayer=Maxplayer / 2
	For x=0 To 20								; No of Items to hide
		If MaxItems(x)=99 Then					; Automatic
			Select x
			Case 0 	z=3+(MaxPlayer * 2)			; Bomb
			Case 1 	z=5+(MaxPlayer * 2)			; Fire
			Case 2 	z=2+(MaxPlayer * 2)	 		; Speed
			Case 3 	z=0      					; ---
			Case 4 	z=MaxPlayer					; Unknown
			Case 5  z=1+(HalfPlayer*1)			; YinYang
			Case 6 	z=1+(HalfPlayer*1)			; Ghost
			Case 7 	z=1+(HalfPlayer*1)			; TimeBomb
			Case 8  z=1+(HalfPlayer*1)			; Controllbomb
			Case 9	z=1;0+(HalfPlayer*1)		; Stop
			Case 10	z=0+(MaxPlayer*1)			; Superman
			Case 11 z=1+(HalfPlayer*1)			; Coin
			Case 12 If Game_mode<>0 Then 		; Ankh ?
						z=MaxPlayer+HalfPlayer
					Else
						z=0
					EndIf
			Case 13 z=0							; Sword
			Case 14 z=1+(HalfPlayer*1)			; KickBomb
			Case 15	z=1+(HalfPlayer*1)			; Fist
			Case 16 z=1							; Bag
			Case 17 z=0							; Mine
			Case 18 z=0+(MaxPlayer *2)			; Death
			Case 19 z=0
			Case 20 z=0
			End Select

			StillItems(x)=z
		Else
			StillItems(x)=MaxItems(x)
		EndIf
		
		If Shop_On=False Then
			 StillItems(11)=0					; no Coins if no Shop !
			 StillItems(16)=0					; no Bag if no Shop !
		EndIf
	Next

	Select MaxPlayer
		Case 0,1,2:	CreateLevel(Array_Level$(Level)+"_2")
		Case 3:		CreateLevel(Array_Level$(Level)+"_3")
		Case 4:		CreateLevel(Array_Level$(Level)+"_4")
		Case 5:		CreateLevel(Array_Level$(Level)+"_5")
		Case 6:		CreateLevel(Array_Level$(Level)+"_6")
		Case 7:		CreateLevel(Array_Level$(Level)+"_7")
		Case 8:		CreateLevel(Array_Level$(Level)+"_8")
		Case 9:		CreateLevel(Array_Level$(Level)+"_9")
	End Select

	For z=1 To MaxPlayer	
		For Player=Each T_Player					; Reset players
			If Player\Nr=z Then
				x=0
				While (Startpoints(x,0)=0) And (x<=10)
					x=x+1
				Wend
				Player\SpeedCounter=0
				Player\X=Startpoints(x,0)
				Player\Y=Startpoints(x,1)
				Player\Dies=0
				Player\Drawn=False
				Startpoints(x,0)=0
				Startpoints(x,1)=0
			EndIf
		Next
	Next
	
	EndIf	;HOST
	
	LevelX = 18
	LevelY = 18
	
	MusicPitch=100
	MusicTime=0
	MusicPlays = true
	
;maxmusic=0
	If (MaxMusic<>0) And (Music_On) Then
		z=Rand(MaxMusic)-1
;DebugLog "loading music :"+MusicFile$(z)
		if(gSpecialRound)
		  LoadSample(0,"music\other\Nils Feske-test.rns.wav")
		else
			LoadSample(0,"music\ingame\"+MusicFile$(z))
		endif
		
		LoopSound Wav(0)
		SoundVolume Wav(0),musicvolume
	EndIf

  MaxRoundTime = B_Time * 1800
	AlarmTime		 = MaxRoundTime - 3300
	ShrinkTime	 = AlarmTime+500
	Alarm_On		 = Menu_Alarm_On
	Shrinking_On = Menu_Shrinking_On
	
	Font=LoadFont("font\Highlight LET.ttf",400,1 )
	SetFont Font
	
	cls
	color 255,255,255
	text 400,300,"3",1,1
	PixelSwarmInit(0,C_ScreenX/2,300,5,$ffffffff,0,0.5)
	PixelSwarmInit(1,C_ScreenX/2,300,5,$ffffffff,1,0.5)
	cls
	text 400,300,"2",1,1
	PixelSwarmInit(2,C_ScreenX/2,300,5,$ffffffff,0,0.5)
	PixelSwarmInit(3,C_ScreenX/2,300,5,$ffffffff,1,0.5)
	cls
	text 400,300,"1",1,1
	PixelSwarmInit(4,C_ScreenX/2,300,5,$ffffffff,0,0.5)
	PixelSwarmInit(5,C_ScreenX/2,300,5,$ffffffff,1,0.5)
	cls
	text 400,300,"GO!",1,1
	PixelSwarmInit(6,C_ScreenX/2,300,5,$ffffffff,0,0.5)
	PixelSwarmInit(7,C_ScreenX/2,300,5,$ffffffff,1,0.5)

			
  If gSpecialRound<>0 Then					; Random Spezial Round

  	Font=LoadFont( "font\Highlight LET.ttf",190,1 )
  	SetFont Font
  	
 		cls
		text 400,150,"SPECIAL",1,1
		PixelSwarmInit(8,C_ScreenX/2,100,10,0,0,0.5)
		PixelSwarmInit(9,C_ScreenX/2,100,10,0,1,0.5)
		
  	cls
		Select gSpecialRound
		Case 1
			text 400,450,"HASTE",1,1
			PixelSwarmInit(10,C_ScreenX/2,500,10,$FF8888FF,0,0.5)
			PixelSwarmInit(11,C_ScreenX/2,500,10,$FF8888FF,1,0.5)
			
			For Player=Each T_Player
				Player\Speed=5
				Player\BombTicks=30
			Next
		Case 2
			text 400,450,"BOOM",1,1
			PixelSwarmInit(10,C_ScreenX/2,500,10,$FF8888FF,0,0.5)
			PixelSwarmInit(11,C_ScreenX/2,500,10,$FF8888FF,1,0.5)
			For Player=Each T_Player
				Player\Fire=20
				Player\Bombs=50
			Next
		Case 3
			text 400,450,"HAHA",1,1
			PixelSwarmInit(10,C_ScreenX/2,500,10,$FF8888FF,0,0.5)
			PixelSwarmInit(11,C_ScreenX/2,500,10,$FF8888FF,1,0.5)
			For Player=Each T_Player
				Player\Disease=2
				Player\DiseaseTimer=29999
			Next
		Case 4
			text 400,450,"NUKE'EM",1,1
			PixelSwarmInit(10,C_ScreenX/2,500,10,$FF8888FF,0,0.5)
			PixelSwarmInit(11,C_ScreenX/2,500,10,$FF8888FF,1,0.5)
			For Player=Each T_Player
				Player\Fire=1
				Player\Disease=7
				Player\DiseaseTimer=29999
				Player\YinYang=1
				Player\YinYangAnimTimer=0
				Player\YinYangFrame=0
				Player\Ghost=0
				Player\GhostFrame=0
			Next
		Case 5
			text 400,450,"SIMPLE",1,1
			PixelSwarmInit(10,C_ScreenX/2,500,10,$FF8888FF,0,0.5)
			PixelSwarmInit(11,C_ScreenX/2,500,10,$FF8888FF,1,0.5)
			For Player=Each T_Player
				Player\Fire=2
				Player\Bombs=1
				Player\BombKind=00
				Player\CanPushWalls=99
				Player\CanKickBombs=99
				Player\Speed=Player_StartSpeed
				Player\YinYang=0
				Player\Ghost=0
			Next
			For x=0 To 20					; Remove Extras
				For y=0 To 20
					Map(x,y)\PUp=0
				Next
			Next
		Case 6
			text 400,350,"ROCK'N'",1,1
			text 400,500,"ROLL",1,1
			PixelSwarmInit(10,C_ScreenX/2,500,5,$FF8888FF,0,0.5)
			PixelSwarmInit(11,C_ScreenX/2,500,5,$FF8888FF,1,0.5)
			For Player=Each T_Player
				Player\Fire=5
				Player\Bombs=1
				Player\BombKind=2
				Player\CanKickBombs=1
				Player\Speed=3
				Player\YinYang=1
				Player\Ghost=0
			Next
			For x=0 To 20					; Remove Extras
				For y=0 To 20
					Map(x,y)\PUp=0
					Map(x,y)\Surface=0
				Next
			Next
			
			Case 7
			text 400,350,"RUNNING",1,1
			text 400,500,"MAN",1,1
			PixelSwarmInit(10,C_ScreenX/2,500,5,$FF8888FF,0,0.5)
			PixelSwarmInit(11,C_ScreenX/2,500,5,$FF8888FF,1,0.5)
			For Player=Each T_Player
				Player\Fire=20
				Player\Bombs=1
				Player\BombKind=1
				Player\CanKickBombs=1
				Player\Speed=5
				Player\Ghost=0
			Next
			For x=0 To 20					; Remove Extras
				For y=0 To 20
					Map(x,y)\PUp=0
				Next
			Next
			
			MaxRoundTime = 1000000
			AlarmTime		 = 0
			ShrinkTime	 = 800
			Alarm_On=1
			Shrinking_On=1
			
		End Select
	endif
	
	FreeFont Font
	
	PlayWav(Wav_Yell3,0,0)	
	PixelSwarmSetState(0)
	PixelSwarmSetState(1)	
	UpdateSwarms(700)
	PixelSwarmSetState(0,"explode")
	
	PlayWav(Wav_Yell2,0,0)
	PixelSwarmSetState(2)
	PixelSwarmSetState(3)	
	UpdateSwarms(700)
  PixelSwarmSetState(2,"explode")
  
	PlayWav(Wav_Yell1,0,0)
  PixelSwarmSetState(4)
	PixelSwarmSetState(5)	
	UpdateSwarms(700)
  PixelSwarmSetState(4,"explode")

  if gSpecialRound

  	If (MaxMusic<>0) And (Music_On)
			wav_id(0)=PlaySound(Wav(0))
  	else
			PlayWav(Wav_YellGo,0,0)
  	endif
			
		PixelSwarmSetState(8)
		PixelSwarmSetState(9)	
		
		PixelSwarmSetState(10)
		PixelSwarmSetState(11)	
		UpdateSwarms(2300)
		
  	PixelSwarmSetState(0,"destroyall")	

	else
		
	  PlayWav(Wav_YellGo,0,0)
	  PixelSwarmSetState(6)
		PixelSwarmSetState(7)	
		UpdateSwarms(700)
	  PixelSwarmSetState(0,"destroyall")
	  
	  If (MaxMusic<>0) And (Music_On)  Then wav_id(0)=PlaySound(Wav(0))
	endif



	

End Function


;------------------------------------------------------------------------------------- BuildItem
Function BuildItem(mx,my,Anim,Owner)								; Returns Itemnumber
	Check=ItemCounter
;	While Item(ItemCounter)\Anim<>0
	While Item(ItemCounter)<>Null
		ItemCounter=ItemCounter + 1
		If ItemCounter>C_MaxItems Then ItemCounter=1
		If (ItemCounter=Check) Then	RuntimeError "GAMEENGINE : Item stack overflow !"
	Wend
	Item(ItemCounter)=New T_Item
	Item(ItemCounter)\Anim=Anim
	Item(ItemCounter)\x=mx*C_ItemX
	Item(ItemCounter)\y=my*C_ItemY
	Item(ItemCounter)\AnimTimer=Anim_Items(Anim)\AnimTime	; Set Timer
	Item(ItemCounter)\Owner=Owner
	Item(ItemCounter)\LifeForce=0
	Item(ItemCounter)\Range=0
	Item(ItemCounter)\xx=0
	Item(ItemCounter)\yy=0
	Item(ItemCounter)\Move=0
	Item(ItemCounter)\MoveTimer=0
	Item(ItemCounter)\MaxMoveTime=0
	Item(ItemCounter)\Kind=Anim
	Item(ItemCounter)\PUp=0
	Item(ItemCounter)\Nr=ItemCounter
;	Item(ItemCounter)\FireType=0
	Map(mx,my)\Item=ItemCounter
	
	ItemCounter=ItemCounter + 1
	If ItemCounter>C_MaxItems Then ItemCounter=1

	Return Check
End Function


;-------------------------------------------------------------------------------------- PutInMap
Function PutInMap(mx,my,Anim,owner)
;If (anim<0) Or (anim>100) Then RuntimeError anim
	Map(mx,my)\Surface=Anim
	Map(mx,my)\AnimTimer=Anim_Items(Anim)\AnimTime
	Map(mx,my)\Owner=Owner
End Function


;---------------------------------------------------------------------------------------- GetMap
Function GetMap(mx,my,Filter)											; returns Type
	q=(Anim_Items(Map(mx,my)\Ground)\Kind) Or (Anim_Items(Map(mx,my)\Surface)\Kind)
	If Map(mx,my)\Item<>0 Then
;		If ITem(Map(mx,my)\Item)=Null Then Stop
		q = q Or (Anim_Items(Item(Map(mx,my)\Item)\Anim)\Kind)
	EndIf
	q = q And (65535-Filter)
	Return q
End Function


;--------------------------------------------------------------------------------------- GetMap2
Function GetMap2(mx,my,Filter)											; returns Type
	q=(Anim_Items(Map(mx,my)\Ground)\Kind) Or (Anim_Items(Map(mx,my)\Surface)\Kind)
	q = q And (65535-Filter)
	Return q
End Function


;----------------------------------------------------------------------------------- CreateLevel
Function CreateLevel(Levelname$)

	ItemCounter=1
	For x=0 To 10
		Startpoints(x,0)=0
		Startpoints(x,1)=0
	Next
	For x=0 To 20
		For y=0 To 20
			Map(x,y)\Ground=0
			Map(x,y)\Surface=0
			Map(x,y)\Item=0
			Map(x,y)\AnimTimer=0
			Map(x,y)\PUp=0
		Next
	Next
	For x=0 To 20
		ItemCount(x)=Stillitems(x)
	Next

	Delete Each T_Item							; remove all Items

	Restore LevelData
	Repeat
		Read vA$
		If vA$<>"END" Then
			Read LevelX
			Read LevelY
			Read MaxWalls
			Read Starts

			For z=1 To Starts					; Shuffle startpoints

				Read x,y
				If vA$=LevelName$ Then
					if PlayerRandomPos
						Repeat
							q=Rand(0,9)
						Until (StartPoints(q,0)=0) Or (KeyDown(1))
						StartPoints(q,0)=(x*33)
						Startpoints(q,1)=(y*33)-10
					else
						StartPoints(z-1,0)=(x*33)
						Startpoints(z-1,1)=(y*33)-10
					endif
				EndIf
			Next
			
			For y=0 To Levely					; read Leveldata to map
				For x=0 To Levelx
					Read z
					If z=0 Then Map(x,y)\Ground=I_Free
					If z=1 Then Map(x,y)\Ground=I_Iron
					If z=9 Then Map(x,y)\Ground=9
				Next
			Next
		EndIf
		
	Until (vA$=LevelName$) Or (vA$="END")

;	z=0											; ICE
;	While z>0
; 		x=Rnd(1,LevelX-1)
;		y=Rnd(1,LevelY-1)
;		If (map(x,y)\Ground=I_Free) Then
;			Map(x,y)\Ground=I_Ice
;			z = z - 1
;		EndIf
;	Wend
	
	zz=0
	For z=0 To 18								; Count ALL PUps to hide
		zz=zz + ItemCount(z)
	Next
	MaxCrumble=(MaxWalls / 5)
	MaxWalls  = MaxWalls - MaxCrumble
	MaxPUpCrumble=(zz / 5)
	MaxPUpWall=zz - MaxPUpCrumble

	z=MaxWalls									; set up the walls
	zz=MaxPUpWall
	While z>0
 		x=Rand(LevelX-1)
		y=Rand(LevelY-1)
		If (map(x,y)\Ground=I_Free) And (Map(x,y)\Surface=0) Then
			z=z-1
			map(x,y)\Surface=I_Wall;I_PUpControl;I_PUpDeath;I_Wall
			If zz>0 Then
				Map(x,y)\PUp=RandomPowerUp()
				zz=zz - 1
			EndIf
		EndIf
	Wend

	z=MaxCrumble								; set up the crumble-walls
	zz=MaxPUpCrumble
	While z>0
 		x=Rand(LevelX-1)
		y=Rand(LevelY-1)
		If (map(x,y)\Ground=I_Free) And (Map(x,y)\Surface=0) Then
			z=z-1
			if CrumbleWalls
				map(x,y)\Surface=I_CrumbleWall0
			else
				map(x,y)\Surface=I_Wall;
			endif
			
			If zz>0 Then
				Map(x,y)\PUp=RandomPowerUp()
				zz=zz - 1
			EndIf
		EndIf
	Wend

	For y=0 To LevelY								; remove spaceholders
		For x=0 To LevelX
			If Map(x,y)\Ground=9 Then Map(x,y)\Ground=I_Free
		Next
	Next

End Function


;--------------------------------------------------------------------------------- RandomPowerUp
Function RandomPowerUp()
	Repeat
		z=Rand(0,18)
	Until ItemCount(z)>0

	ItemCount(z)=ItemCount(z) - 1
	
	Select z
		Case 0 	z=I_PUpBomb
		Case 1 	z=I_PUpFire
		Case 2 	z=I_PUpSpeed
		Case 3 	z=I_PUpTimeBomb
		Case 4 	z=I_PUpUnknown
		Case 5  z=I_PUpYinYang
		Case 6 	z=I_PUpGhost
		Case 7 	z=I_PUpTimeBomb
		Case 8  z=I_PUpControl
		Case 9	z=I_PUpStop
		Case 10	z=I_PUpSuperman
		Case 11 z=I_PUpCoin
		Case 12 z=I_PUpAnkh
		Case 13 z=I_PUpSword
		Case 14 z=I_PUpKickBomb
		Case 15	z=I_PUpFist
		Case 16 z=I_PUpBag
		Case 17 z=I_PUpMine
		Case 18 z=I_PUpDeath
	End Select

	Return z

End Function


;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------




;-------------------------------------------------------------------------------- LoadDefaultInput
Function LoadDefaultInput(tmp,nr=1)

	if B_PlayerDevice = 0
		tmp_str$ = "config\def_inp_keyboard"+nr+".cfg"
	else
		tmp_str$ = "config\def_inp_joy"+nr+".cfg"
	endif
	
	if FileType(tmp_str$)=1 Then
		File=OpenFile(tmp_str$)
		
		for i = 0 to C_MAX_INP_CODES-1
			InpDeviceCode(i,tmp) = readInt(File)
		next
		
		closefile(File)
		return true
		
	else
		if B_PlayerDevice = 0
    	InpDeviceCode(0,tmp) = 	203
			InpDeviceCode(1,tmp) = 	205
			InpDeviceCode(2,tmp) = 	200
			InpDeviceCode(3,tmp) = 	208
			InpDeviceCode(4,tmp) = 	42
			InpDeviceCode(5,tmp) = 	25
	
			for i=6 to C_MAX_INP_CODES-1
				InpDeviceCode(i,tmp) = 0
			next	
		else
			InpDeviceCode(0,tmp) = 	1
			InpDeviceCode(1,tmp) = 	1
			InpDeviceCode(2,tmp) = 	2
			InpDeviceCode(3,tmp) = 	2
			InpDeviceCode(4,tmp) = 	20
	
			for i=5 to C_MAX_INP_CODES-1
				InpDeviceCode(i,tmp) = 0
			next		
		endif
		
		return 0
	ENDIF
	
End Function


;-------------------------------------------------------------------------------- SaveDefaultInput
Function SaveDefaultInput(nr)

		if B_PlayerDevice = 0
			tmp_str$ = "config\def_inp_keyboard"+nr+".cfg"
		else
			tmp_str$ = "config\def_inp_joy"+nr+".cfg"
		endif
		
		
		if FileType(tmp_str$)<>0 Then
			DeleteFile(tmp_str$)
		endif
		
		if FileType(tmp_str$)=0 Then
		
			File=WriteFile(tmp_str$)
			
			if File = 0 then return 0
			
			for i = 0 to C_MAX_INP_CODES-1
				WriteInt(File,InpDeviceCode(i,1))
			next
			
			CloseFile(File)

			return true		
		else
			return false
		endif
	
End Function





;-------------------------------------------------------------------------------- LoadAllPlayers
Function LoadAllPlayers()

	lp_x 						= 0
	lp_y 						= 200
	bar_offsetx			=	200
	bar_pixelx			=	10
	bar_pixely			=	20
	max_bars				=	40
	old_bar_count		=	0	
		
	imageText (lp_x,lp_y,"Loading players...",false,true,frontimage)
	
	for x=0 to max_bars-1
			rect lg_x+bar_offsetx+x*bar_pixelx,lp_y,bar_pixelx-1,bar_pixely,true
	next
	image_flip(frontimage,true)
	Color 100,255,100

	player_count=0
	dir=ReadDir("PLAYER\")
	Repeat
		name$=NextFile$(dir)
		If name$="" Then Exit
		name$=Lower$(name$)
		If (name$<>".") And (name$<>"..") And (Instr(name$,".png",1)<>0) Then
			player_count = player_count+1
		EndIf
	Until player_count >= 100	
	CloseDir(dir)

	divider#				=	max_bars / float(player_count)	


	
	z=0
  dir=ReadDir("PLAYER\")
	Repeat
		name$=NextFile$(dir)
		If name$="" Then Exit
		name$=Lower$(name$)
		If (name$<>".") And (name$<>"..") And (Instr(name$,".png",1)<>0) Then
		
			bar_count = floor((z+1) * divider +0.5)-1
			for x = old_bar_count to bar_count
			imagerect (lp_x+bar_offsetx+x*bar_pixelx,lp_y,bar_pixelx-1,bar_pixely,true,false,true,frontimage)
			next
  		old_bar_count = bar_count+1
  
			Im_Player(z) = New T_PlayerImage
			Im_Player(z)\File$=name$
			Name$=Upper$(Left$(name$,1))+Mid$(Name$,2,Len(name$)-5)
			Im_Player(z)\Name=name$
			Im_Player(z)\DeathAnims=20
			If FileType("PLAYER\"+Name$+".mp3")=1 Then
	 			Im_Player(z)\DeathCry=LoadSound("PLAYER\"+name$+".mp3")
			Else
	 			Im_Player(z)\DeathCry=LoadSound("PLAYER\tele.mp3")
			EndIf
			MaxPlayerImage=z
			z=z+1
		EndIf
	Until z=C_MaxPlayer
	CloseDir(dir)

	Color 255,255,255
End Function


;------------------------------------------------------------------------------- LoadAllGraphics
Function LoadAllGraphics()
TFormFilter 0

	
	lg_x 						= 0
	lg_y 						= 150
	bar_offsetx			=	200
	bar_pixelx			=	10
	bar_pixely			=	20
	max_bars				=	40
	nr_of_graphics	=	6
	graphics_count	=	0
	divider#				=	max_bars / float(nr_of_graphics)
	old_bar_count		=	0	
	
	imageText (lg_x,lg_y,"Loading graphics...",false,true,frontimage)
	
	for x=0 to max_bars-1
			rect lg_x+bar_offsetx+x*bar_pixelx,lg_y,bar_pixelx-1,bar_pixely,true
	next
	image_flip(frontimage,true)
	Color 100,255,100

  Im_Mouse=LoadImage("gfx\mouse.png")			; Load Mousepointer
  graphics_count	=	 graphics_count+1
	bar_count = floor(graphics_count * divider +0.5)-1
	for x = old_bar_count to bar_count
	imagerect (lg_x+bar_offsetx+x*bar_pixelx,lg_y,bar_pixelx-1,bar_pixely,true,false,true,frontimage)
	next
  old_bar_count = bar_count+1

	Im_TimeRamp=LoadImage("gfx\TimeRamp.png")
	graphics_count	=	 graphics_count+1
	bar_count = floor(graphics_count * divider +0.5)-1
	for x = old_bar_count to bar_count
	imagerect (lg_x+bar_offsetx+x*bar_pixelx,lg_y,bar_pixelx-1,bar_pixely,true,false,true,frontimage)
	next
  old_bar_count = bar_count+1
	
	Im_Image=LoadImage("gfx\others.png")
	graphics_count	=	 graphics_count+1
	bar_count = floor(graphics_count * divider +0.5)-1
	for x = old_bar_count to bar_count
	imagerect (lg_x+bar_offsetx+x*bar_pixelx,lg_y,bar_pixelx-1,bar_pixely,true,false,true,frontimage)
	next
  old_bar_count = bar_count+1
	
	SetBuffer ImageBuffer(Im_Image)						; cut the first line/row
	Im_Other=CreateImage(C_PlayerX,C_PlayerY,4*10,1)
	For y=0 To 3
		For x=0 To 9
			GrabImage(Im_Other,1+(x*(C_PlayerX+1)),1+(y*(C_PlayerY+1)),x+(y*10))
		next
	Next
	SetBuffer imagebuffer(frontimage)
	FreeImage Im_Image
	MaskImage Im_Other,43,108,3
	HandleImage Im_Other,26,26

	Im_Ghost=LoadAnimImage("gfx\pghost.bmp",11,11,0,4*4) ; Load Ghostimage
	graphics_count	=	 graphics_count+1
	bar_count = floor(graphics_count * divider +0.5)-1
	for x = old_bar_count to bar_count
	imagerect (lg_x+bar_offsetx+x*bar_pixelx,lg_y,bar_pixelx-1,bar_pixely,true,false,true,frontimage)
	next
  old_bar_count = bar_count+1


	Im_Image=LoadImage("gfx\disease.png")	   			; load Diseasegraphics
	graphics_count	=	 graphics_count+1
	bar_count = floor(graphics_count * divider +0.5)-1
	for x = old_bar_count to bar_count
	imagerect (lg_x+bar_offsetx+x*bar_pixelx,lg_y,bar_pixelx-1,bar_pixely,true,false,true,frontimage)
	next
  old_bar_count = bar_count+1
  
	SetBuffer ImageBuffer(Im_Image)						; cut the first line/row
	Im_Disease=CreateImage(30,40,20,1)
	For x=0 To 9
		GrabImage(Im_Disease,(x*31)+1,0,x)
		GrabImage(Im_Disease,(x*31)+1,41,10+x)
	Next
	SetBuffer imagebuffer(frontimage)
	FreeImage Im_Image
	HandleImage Im_Disease,16,16
	MaskImage Im_Disease,43,108,3

	Im_Image=LoadImage("gfx\items.png")	   			; load Itemgraphics
	graphics_count	=	 graphics_count+1
	bar_count = floor(graphics_count * divider +0.5)-1
	for x = old_bar_count to bar_count
	imagerect (lg_x+bar_offsetx+x*bar_pixelx,lg_y,bar_pixelx-1,bar_pixely,true,false,true,frontimage)
	next
  old_bar_count = bar_count+1
  
	SetBuffer ImageBuffer(Im_Image)						; cut the first line/row
	Im_Items=CreateImage(C_ItemX,C_ItemY,C_ItemCountX*C_ItemCountY,1)
	For y=0 To C_ItemCountY-1
		For x=0 To C_ItemCountX-1
			GrabImage(Im_Items,x*(C_ItemX+1)+1,y*(C_ItemY+1)+1,x+(y*C_ItemCountX))
		next
	Next
	SetBuffer imagebuffer(frontimage)
	FreeImage Im_Image
	HandleImage Im_Items,16,16
;	MaskImage Im_Items,19,55,51
	MaskImage Im_Items,43,108,3

	Color 255,255,255

End Function

;---------------------------------------------------------------------------------------
Function RemovePlayerImages()
	for x = 0 to C_MaxPlayers
		Im_Player_Exists(x) = true
	next
	for Player = each T_Player
		if Im_Player_Exists(Player\Image) = true
		 	freeimage Im_Player(Player\Image)\Image
		 	Im_Player_Exists(Player\Image) = false
		endif
	next
	
End Function

;---------------------------------------------------------------------------------------
Function LoadPlayerImages()

	for x = 0 to C_MaxPlayers
		Im_Player_Exists(x) = false
	next
	
	for Player = each T_Player
		if Im_Player_Exists(Player\Image) = False
			TempImage=LoadImage("PLAYER\"+Im_Player(Player\Image)\File$)
			SetBuffer ImageBuffer(TempImage)			; cut the first line/row
			If TempImage=0 Then
				RuntimeError  "Player file not found :"+Im_Player(z)\File$
			EndIf
			
			Im_Player(Player\Image)\Image=CreateImage(C_PlayerX,C_PlayerY,6*10,1)
			For y=0 To 5
				For x=0 To 9
					GrabImage(Im_Player(Player\Image)\Image,1+(x*(C_PlayerX+1)),1+(y*(C_PlayerY+1)),x+(y*10))
				Next
			Next
			MaskImage Im_Player(Player\Image)\Image,43,108,3
			HandleImage Im_player(Player\Image)\Image,26,26			
	    Im_Player_Exists(Player\Image) = true
	    SetBuffer backBuffer()
			FreeImage TempImage
		endif
	next
	
	
End Function

;---------------------------------------------------------------------------------------
Function LoadMenuPlayerImages()
	
	Im_Player_Menu=CreateImage(C_PlayerX,C_PlayerY,MaxPlayerImage+1,1)
	x=0
	repeat
		TempImage=LoadImage("PLAYER\"+Im_Player(x)\File$)
		SetBuffer ImageBuffer(TempImage)			
		If TempImage=0 Then
			RuntimeError  "Player file not found :"+Im_Player(x)\File$
		EndIf
		GrabImage Im_Player_Menu,1,1,x
		SetBuffer backBuffer()
		FreeImage TempImage
		x=x+1
	until x > MaxPlayerImage
	MaskImage Im_Player_Menu,43,108,3
	HandleImage Im_Player_Menu,26,26	
	
	
End Function


;------------------------------------------------------------------------------------ LoadSample
Function LoadSample(Nr,Name$)
;DebugLog "loading sample "+nr+":"+Name$
	If Nr=0 Then
		File=ReadFile(name$)
		SeekFile(File,24+4)
		WavPitch(Nr)=ReadByte(File) + ( ReadByte(File) * 256)
		CloseFile File
	EndIf
;DebugLog "loading sample "+nr+":"+Name$+" @ "+WavPitch(Nr)
	Wav(Nr)=LoadSound(name$)
End Function


;--------------------------------------------------------------------------------------- PlayWav
Function PlayWav(Nr,Pitch,Pan#)
	If Wav(Nr)=0 Then Return
	
	If Net_Type=2 Then										; Host?
		dat$=Nr								; build NetString
		SendNetMsg(55,dat$,Net_MyNetID,0,True)
	EndIf   	
	
	If Pan<>0 Then Pan=(Pan-400+C_OffX)/400
;	If Pitch<>0 Then
;		SoundPitch Wav(Nr), Pitch * (2 * WavPitch(Nr)) /100
;	EndIf
	If Pan<>0 Then
		SoundPan Wav(Nr),Pan
	EndIf
	wav_id(Nr)= PlaySound (Wav(Nr))
End Function


;--------------------------------------------------------------------------------------- StopAllSounds
Function StopAllSounds()
	for x = 0 to C_MaxSounds
		If wav_id(x)<>0 Then StopChannel wav_id(x)
	next
End Function



;--------------------------------------------------------------------------------- LoadAllSounds
Function LoadAllSounds()

	imageText (0,50,"Loading music list...",false,true, frontimage)
	
	MaxMusic=0
;	File=ReadFile("music.txt")
;	SeekFile (file,0)
;	Repeat
;		name$=ReadLine$(File)
;		MusicFile$(maxmusic)=name$
;		maxmusic = maxmusic + 1
;	Until (Eof(File)) Or (maxmusic=100) Or (name$="!END!")
;	MusicFile$(maxmusic-1)=""
;	MaxMusic=MaxMusic - 1
;	CloseFile(File)

	dir=ReadDir("music\ingame\")
	Repeat
		name$=NextFile$(dir)
		If name$="" Then Exit
		name$=Lower$(name$)
		If (name$<>".") And (name$<>"..") And ( (Instr(name$,".wav",1)<>0) or (Instr(name$,".mp3",1)<>0) )  Then
			;DebugLog name$
			MusicFile$(MaxMusic)=Name$
			MaxMusic=MaxMusic+1
		EndIf
	Until MaxMusic >= 100
	CloseDir(dir)

  Color 100,255,100
  if MaxMusic = 1
		outtext$ = " file"
  else
		outtext$ = " files"
  endif
	imageText (200,50,MaxMusic + outtext$,false,true, frontimage)
	Color 255,255,255

	If test_Terminal Then Return
;Return



	ls_x 						= 0
	ls_y 						= 100
	bar_offsetx			=	200
	bar_pixelx			=	10
	bar_pixely			=	20
	max_bars				=	40
	nr_of_sounds		=	69
	bar_count				=	0
	sound_count			=	0
	divider#				=	max_bars / float(nr_of_sounds)
	
	imageText (ls_x,ls_y,"Loading sounds...",false, true,frontimage)
	
	for x=0 to max_bars-1
			rect ls_x+bar_offsetx+x*bar_pixelx,ls_y,bar_pixelx-1,bar_pixely,true
	next
	image_flip(frontimage,true)
	Color 100,255,100

	File=ReadFile("data\Sound.txt")
		
	sound_nr=1
	SeekFile(file,0)
	name$=ReadLine$(File)
	Repeat
		name$=ReadLine$(File)
		If Left$(name$,1)<>";" Then
			LoadSample(sound_nr,"sfx\"+name$)
			name$=ReadLine$(File)
			sound_count = sound_count+1
			
			bar_count = floor(sound_count * divider +0.5)-1
			imagerect (ls_x+bar_offsetx+bar_count*bar_pixelx,ls_y,bar_pixelx-1,bar_pixely,true,false,true,frontimage)
				
		EndIf
		sound_nr = sound_nr + 1		
	Until (Eof(File)) Or (sound_nr=100) Or (name$=";!END!")
	CloseFile(File)

	Color 255,255,255

End Function


;-----------------------------------------------------------------------------------------------
;Function DrawAlpha(image, frame, x, y, alpha#)
;	nalpha# = 1 - alpha#
;    LockBuffer BackBuffer()
;    LockBuffer ImageBuffer(image,frame)
;    For xx = 0 To 9
;    	For yy = 0 To 9
;        	rgb1% = ReadPixelFast(xx,yy,ImageBuffer(image,frame))
            ;If (rgb1% <> 2845669.0) And (rbg1%<>2845443.0) Then
;			r1% = ((rgb1 And 16711680) Shr 16)
;			g1% = ((rgb1 And 65280) Shr 8)
;			b1% = (rgb1 And 255)
;			If (g1%<>108) And (g1%<>107) Then
				;rgb2% = ReadPixelFast(xx + x-5, yy + y, BackBuffer())
				;r2% = ((rgb2 And 16711680) Shr 16)
				;g2% = ((rgb2 And 65280) Shr 8)
				;b2% = (rgb2 And 255)
				;r3 = r1%*alpha# + r2%*nalpha#
				;g3 = g1%*alpha# + g2%*nalpha#
				;b3 = b1%*alpha# + b2%*nalpha#
;				r3=r1
;				g3=g1
;				b3=b1
;				WritePixelFast(xx + x-5, yy + y, ((r3 Shl 16) + (g3 Shl 8) + b3), BackBuffer())
;			EndIf
;		Next
;	Next
;	UnlockBuffer ImageBuffer(image,frame)
;	UnlockBuffer BackBuffer()
;End Function
;
;
;-----------------------------------------------------------------------------------------------
;Function TEST_ImageCrypt(ImgBuf,Key1,Key2,Key3)
;	h=ImageHeight(ImgBuf)
;	w=ImageWidth(ImgBuf)
;	SetBuffer ImageBuffer(ImgBuf)
;	LockBuffer
;	For y=0 To h-1
;		For x=0 To w-1
;			If x=0 And y=0
;				rgb=ReadPixelFast(0,y)
;				kr=rgb Shr 16
;				kg=(rgb Shr 8) And $ff
;				kb=rgb And $ff
;			Else
;				rgb=ReadPixelFast(x,y)
;				r=(rgb Shr 16) Xor ((x+kr) Mod 256)
;				g=((rgb Shr 8) And $ff) Xor kg
;				b=(rgb And $ff) Xor ((y+kb) Mod 256)
;				kr=(kr+key1) Mod 255
;				kg=(kg+key2) Mod 255
;				kb=(kb+key3) Mod 255
;				rgb=(r Shl 16) + (g Shl 8) + b
;				WritePixelFast x,y,rgb	
;			EndIf
;		Next
;	Next
;	UnlockBuffer
;	SetBuffer FrontBuffer()
;End Function


;-----------------------------------------------------------------------------------------------
;Function FillPoly(vcount)
;	Local   a,b,c,d,t
;    Local   x0,x1,g0,g1
;    Local   x,y,w,h
;    buffer=GraphicsBuffer()
;    width=GraphicsWidth()
;    height=GraphicsHeight()
;    b=vcount-1
;    y=yval(0)
;    ; find top point
;    While c<>b
;	    c=c+1
;        yy=yval(c)
;        If yy<y y=yy d=c
;    Wend
;    c=d
;    t=c
;    ; draw top to bottom
;    While y<height
;    ; get left gradient
;	    If y=yval(c)
;		    While y=yval(c)
;    		    x0=xval(c) Shl 16
;	            c=c+1
;	            If c>b c=a
;	            If c=t Return
;	            If y>yval(c) Return
;	        Wend
;	        h=yval(c)-y
;	        g0=((xval(c) Shl 16)-x0)/h
;	    EndIf
;    ; get right gradient
;	    If y=yval(d)
;		    While y=yval(d)
;		        x1=xval(d) Shl 16
;	            d=d-1
;	            If d<a d=b
;	            If y>yval(d) Return
;	        Wend
;	        h=yval(d)-y
;	        g1=((xval(d) Shl 16)-x1)/h
;	    EndIf
;    ; calc horizontal span
;	    x=x1 Sar 16
;	    w=((x0 Sar 16)-x)+1
;    ; draw down to next vert
;	    If (w>0 And y>-1 And x<width And x+w>0)
;		    If x<0 w=w+x x=0        ;crop left
;		    If x+w>width w=width-x  ;crop right
;		    Rect x,y,w,1
;    ;DebugLog "hlin:"+x+","+y+","+w
;		EndIf
;	; Next
;	    x0=x0+g0
;    	x1=x1+g1
;	    y=y+1
;    Wend
;End Function


;-----------------------------------------------------------------------------------------------
;Function CrunchImage(Im)
;	TEST_ImageCrypt(Im,212,93,147)
;End Function

;-----------------------------------------------------------------------------------------------
Function imagetext(xpos,ypos,outtext$,clearscreen,vsync,image)

	oldbuffer = SetBuffer (ImageBuffer(image))
	
	if clearscreen then cls
	     	
	text xpos,ypos,outtext$

	image_flip(image,vsync)
	
	setbuffer oldbuffer
	
End Function


;-----------------------------------------------------------------------------------------------
Function imagerect(xpos,ypos,width, hight,fill,clearscreen,vsync,image)

	oldbuffer = SetBuffer (ImageBuffer(image))
	
	if clearscreen then cls
	
	rect xpos,ypos,width,hight,fill

	image_flip(image,vsync)
	
	setbuffer oldbuffer
	
End Function

;-----------------------------------------------------------------------------------------------
Function image_flip(image,vsync)

	oldbuffer = SetBuffer (BackBuffer())
	
	drawBlock image,0,0
	
	flip vsync
	
	setbuffer oldbuffer
	
End Function



;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
function PixelSwarmInit(nr,xstart,ystart,startsteps#=25,flashrgb=$ffffffff,kind=0,brightness#=0.5,screenw=800,screenh=600,state=0)

	PixelSwarmSetState(nr,"destroy")
	swarm(nr) = new swarmdata
	swarm(nr)\kind           = kind
	swarm(nr)\state          = state
	swarm(nr)\counter        = startsteps
	swarm(nr)\maxbrightness# = brightness#
	swarm(nr)\screenw        = screenw
	swarm(nr)\screenh        = screenh
	
	lockbuffer backbuffer()
	
	k=2
	if (kind <> 2) then k=5
	i=0
	while (i < screenw)
		j=0
		while (j < screenh)
		
			rgb= readpixelfast (i,j)
			if (rgb <> $ff000000) then
				pixel.pixeldata = new pixeldata
				pixel\nr             = nr
				if (kind = 2)
					pixel\xpos           = i
					pixel\ypos           = j
				else
					pixel\xpos           = xstart
					pixel\ypos           = ystart
				endif
				pixel\xspeed#        = (i - xstart)/startsteps#
				pixel\yspeed#        = (j - ystart)/startsteps#
				if flashrgb = 0
					pixel\flashrgb	   = rand($ff000000,$ffffffff)
				else
					pixel\flashrgb	   = flashrgb
				endif
				pixel\sinangle       = rand (360)
				pixel\sinfreq#       = Rnd(3,15)
				pixel\brightness#    = rnd(brightness#)
	      pixel\brightnessdir# = rnd(0.03,0.05)*((-1)^Rand(1,2))
				pixel\r              = (rgb shr 16) and $FF
				pixel\g              = (rgb shr 8)  and $FF	
				pixel\b              =  rgb         and $FF
			endif
			j=j+k
		wend
		i=i+k
 	wend
	unlockbuffer backbuffer()
		
end function



;-----------------------------------------------------------------------------------------------
function PixelSwarmUpdate()

	lockbuffer backbuffer()
		
		nr =100
		for pixel.pixeldata = each pixeldata			
			if swarm(pixel\nr)\state<>0
				if swarm(pixel\nr)\state=1 and swarm(pixel\nr)\kind <> 2
			  	if pixel\nr<>nr
						swarm(pixel\nr)\counter = swarm(pixel\nr)\counter-1
						nr=pixel\nr
						if swarm(pixel\nr)\counter = 0	
							swarm(pixel\nr)\state=2
			  		endif
					endif
			 	endif
			 	
			  if swarm(pixel\nr)\kind=1 or swarm(pixel\nr)\state=1
			  	pixel\xpos = pixel\xpos+pixel\xspeed
					pixel\ypos = pixel\ypos+pixel\yspeed
					if swarm(pixel\nr)\kind=2
						pixel\yspeed = pixel\yspeed+0.1
					endif
				endif
				
				
				pixel\brightness#       = pixel\brightness#+pixel\brightnessdir#
				if pixel\brightness#    > swarm(pixel\nr)\maxbrightness# then
					pixel\brightness#     = swarm(pixel\nr)\maxbrightness#
					pixel\brightnessdir#  = -rnd(0.03,0.05)
				elseif (swarm(pixel\nr)\kind = 2 and pixel\brightness#< 0.06) or (pixel\brightness#< -0.06) then
					pixel\brightnessdir#  = rnd(0.03,0.05)
				endif
				
				BigStar=FALSE	
				if pixel\brightness# <0
					if rand(5)=3
						BigStar=true
						pixel\rgb = $ffffffff
					elseif pixel\rgb <>$ffffffff
						pixel\rgb = pixel\flashrgb
					endif
				else
					pixel\rgb = $ff000000
					cl = pixel\r*pixel\brightness#
					cl = cl shl 16
					pixel\rgb = pixel\rgb + cl
					cl = pixel\g*pixel\brightness#
					cl = cl shl 8
					pixel\rgb = pixel\rgb + cl
					cl = pixel\b*pixel\brightness#
					pixel\rgb = pixel\rgb + cl
				endif
				
				pixel\sinangle=pixel\sinangle+1

				xpos = pixel\xpos
				ypos = pixel\ypos
        if (swarm(pixel\nr)\kind <> 2)
        	xpos = xpos+3*sin(pixel\sinfreq*pixel\sinangle)+sin(pixel\sinfreq*2*pixel\sinangle)
          ypos = ypos+3*sin(pixel\sinfreq*1.5*pixel\sinangle)+sin(pixel\sinfreq*3*pixel\sinangle)
        endif

				if xpos>swarm(pixel\nr)\screenw-4 or xpos<3 or ypos>swarm(pixel\nr)\screenh-4 or ypos<3
					delete pixel.pixeldata
				else
				
					writepixelfast xpos+0,ypos+0,pixel\rgb
					writepixelfast xpos+1,ypos+0,pixel\rgb
					writepixelfast xpos-1,ypos+0,pixel\rgb
					if (swarm(pixel\nr)\kind <> 2)
						writepixelfast xpos+0,ypos+1,pixel\rgb
						writepixelfast xpos+0,ypos-1,pixel\rgb
					endif
					if BigStar
						writepixelfast xpos-2,ypos+0,pixel\rgb
						writepixelfast xpos+2,ypos+0,pixel\rgb
						writepixelfast xpos+0,ypos+2,pixel\rgb
						writepixelfast xpos+0,ypos-2,pixel\rgb
						writepixelfast xpos+1,ypos+1,pixel\rgb
						writepixelfast xpos+1,ypos-1,pixel\rgb
						writepixelfast xpos-1,ypos+1,pixel\rgb
						writepixelfast xpos-1,ypos-1,pixel\rgb
						writepixelfast xpos-3,ypos+0,pixel\rgb
						writepixelfast xpos+3,ypos+0,pixel\rgb
						writepixelfast xpos+0,ypos+3,pixel\rgb
						writepixelfast xpos+0,ypos-3,pixel\rgb
					endif
				endif
			endif
		next
				
		unlockbuffer backbuffer()

end function





;-----------------------------------------------------------------------------------------------
function PixelSwarmSetState(nr,method$="activate1")

;swarm lschen, wenn alle pixel auerhalb
	select method$
		case "destroy"
			for pixel.pixeldata = each pixeldata
				if pixel\nr = nr
					delete pixel.pixeldata
				endif
			next
			delete swarm.swarmdata(nr)
			
		case "destroyall"
	  	for pixel.pixeldata = each pixeldata
				delete pixel.pixeldata
			next
			for i=0 to CMAXSWARMS-1
				if swarm(i) <> null then	delete swarm.swarmdata(i)
			next
			
		case "explode"
			swarm(nr)\state = 1
			for pixel.pixeldata = each pixeldata
				if pixel\nr = nr
					if swarm(nr)\kind <> 2
						if abs(pixel\xspeed) < 0.1 and abs(pixel\yspeed) < 0.1
							delete pixel.pixeldata
						endif
					else
						pixel\xspeed = rnd(-3,3)
						pixel\yspeed = rnd(-5,1)
					endif
				endif
			next
		
		case "explodeall"
			for i=0 to CMAXSWARMS-1
				if swarm(i) <> null then	swarm(i)\kind = 1
			next
			for pixel.pixeldata = each pixeldata
				if abs(pixel\xspeed) < 0.1 and abs(pixel\yspeed) < 0.1
					delete pixel.pixeldata
				endif
			next
		
		case "activate1"
			swarm(nr)\state = 1
			
		case "activate2"
			swarm(nr)\state = 2
	end select
	
end function


;-----------------------------------------------------------------------------------------------
function UpdateSwarms(time)
	x=millisecs()	
	Repeat
		cls
		PixelSwarmUpdate()
		WaitTimer(timer)
		flip
	until x+time<millisecs()
  
end function


;-----------------------------------------------------------------------------------------------
function starfield_init()
	For i=0 To 10000
		starfield.star = New star
		starfield\xpos = Rnd(-10000,10000)
		starfield\ypos = Rnd(-10000,10000)
		starfield\zpos = Rnd(1,30)
	Next
end function



;-----------------------------------------------------------------------------------------------
function starfield_update()
	LockBuffer BackBuffer
			
	For starfield.star = Each star	
		col  = starfield_calc_color(320,starfield\zpos)
		col2 = starfield_calc_color(200,starfield\zpos)
		col3 = starfield_calc_color(150,starfield\zpos)
		col4 = starfield_calc_color(100,starfield\zpos)

		xpos = (starfield\xpos*Sin(starfield_angle)+starfield\ypos*Cos(starfield_angle))/starfield\zpos+C_HalfScreenX
		ypos = (starfield\ypos*Sin(starfield_angle)-starfield\xpos*Cos(starfield_angle))/starfield\zpos+C_HalfScreenY
		
		drawpixel(xpos+0,ypos+0,col)
		drawpixel(xpos+1,ypos+0,col2)
		drawpixel(xpos-1,ypos+0,col2)
		drawpixel(xpos+0,ypos+1,col2)
		drawpixel(xpos+0,ypos-1,col2)
		drawpixel(xpos+1,ypos-1,col3)
		drawpixel(xpos+1,ypos+1,col3)
		drawpixel(xpos-1,ypos-1,col3)
		drawpixel(xpos-1,ypos+1,col3)
		drawpixel(xpos+2,ypos+0,col4)
		drawpixel(xpos-2,ypos+0,col4)
		drawpixel(xpos+0,ypos+2,col4)
		drawpixel(xpos+0,ypos-2,col4)
		
		
		starfield\zpos = starfield\zpos-0.05
		If starfield\zpos <= 0
			starfield\zpos = 30
			starfield\xpos = Rnd(-10000,10000)
			starfield\ypos = Rnd(-10000,10000)
		End If
	Next
  starfield_angle=starfield_angle+0.2
  
  if rand(30)=10

  	star.shooting_star = New shooting_star
  	star\xpos=rand(C_ScreenX)
  	star\ypos=rand(C_ScreenY)
  	star\xspeed=rnd(-5,5)
  	star\yspeed=rnd(-5,5)
  	star\speed_angle=rnd(-3,3)
  	star\lifetime = Rand(20,40)
	endif
	
	For star.shooting_star = Each shooting_star
		star\lifetime = star\lifetime-1
		if star\lifetime = 0
			delete star.shooting_star
		else
		  star\xpos=star\xpos+star\xspeed
		  star\ypos=star\ypos+star\yspeed
		  if star\xspeed>0
		  	star\xspeed=star\xspeed+0.2
		  else
		  	star\xspeed=star\xspeed-0.2
		  endif
		  if star\yspeed>0
		  	star\yspeed=star\yspeed+0.2
		  else
		  	star\yspeed=star\yspeed-0.2
		  endif
		  xspeed#=cos(star\speed_angle)*star\xspeed+sin(star\speed_angle)*star\yspeed
		  yspeed#=cos(star\speed_angle)*star\yspeed-sin(star\speed_angle)*star\xspeed

		  star\xspeed=xspeed
		  star\yspeed=yspeed
		
		  col  = starfield_calc_color(300,star\lifetime*0.6)
			col2 = starfield_calc_color(250,star\lifetime*0.6)
			col3 = starfield_calc_color(200,star\lifetime*0.6)
			col4 = starfield_calc_color(150,star\lifetime*0.6)
		
			drawpixel(star\xpos+0,star\ypos+0,col)
			drawpixel(star\xpos+1,star\ypos+0,col)
			drawpixel(star\xpos+2,star\ypos+0,col3)
			drawpixel(star\xpos+3,star\ypos+0,col4)
			drawpixel(star\xpos-1,star\ypos+0,col)
			drawpixel(star\xpos-2,star\ypos+0,col3)
			drawpixel(star\xpos-3,star\ypos+0,col4)
			drawpixel(star\xpos+0,star\ypos+1,col)
			drawpixel(star\xpos+1,star\ypos+1,col2)
			drawpixel(star\xpos-1,star\ypos+1,col2)
			drawpixel(star\xpos+0,star\ypos-1,col)
			drawpixel(star\xpos+1,star\ypos-1,col2)
			drawpixel(star\xpos-1,star\ypos-1,col2)
      drawpixel(star\xpos+0,star\ypos+2,col3)
      drawpixel(star\xpos+0,star\ypos+3,col4)
      drawpixel(star\xpos+0,star\ypos-2,col3)
      drawpixel(star\xpos+0,star\ypos-3,col4)

		endif		
	next
	
	UnlockBuffer BackBuffer
end function
	
	
	
;-----------------------------------------------------------------------------------------------	
function starfield_destroy()
	For starfield.star = each star
		delete starfield.star
	Next
	For star.shooting_star = Each shooting_star
		delete star.shooting_star
	next
end function	
	
	
	
	
;-----------------------------------------------------------------------------------------------	
Function drawpixel(xpos,ypos,col)
	If xpos>=0 And xpos<C_ScreenX And ypos>=0 And ypos<C_ScreenY And col>$FF222222
		WritePixelFast xpos,ypos,col
	End If
End Function



;-----------------------------------------------------------------------------------------------
Function starfield_calc_color(offset,zpos)
	col  = -10*zpos+offset
	If col  > 255 Then
		col = 255
	ElseIf col < 0 Then
		col = 0
	EndIf
	col  = $FF000000+col *$10000+col *$100+col
	Return col
End Function




function GetInputAscii$(Name$)

	i=0
if right(Name$,5)="RIGHT"
	i=1
else if right(Name$,2)="UP"
	i=2
else if right(Name$,4)="DOWN"
	i=3
else if right(Name$,4)="BOMB"
	i=4
else if right(Name$,5)="PAUSE"
	i=5	
endif
			
j=mid(Name$,9,1)

tmp = InpDeviceCode((j-1)*6+i,1)

;Keyboard
if B_PlayerDevice = 0
	
	select tmp
	
	case 2
	txt$="1"
	case 3
	txt$="2"
	case 4
	txt$="3"
	case 5
	txt$="4"
	case 6
	txt$="5"
	case 7
	txt$="6"
	case 8
	txt$="7"
	case 9
	txt$="8"
	case 10
	txt$="9"	
	case 11
	txt$="0"	
	case 12
	txt$=""	
	case 13
	txt$=""
	case 14
	txt$="Backspace"
	case 15
	txt$="Tabulator"
	case 16
	txt$="Q"
	case 17
	txt$="W"
	case 18
	txt$="E"
	case 19
	txt$="R"
	case 20
	txt$="T"
	case 21
	txt$="Z"	
	case 22
	txt$="U"	
	case 23
	txt$="I"	
	case 24
	txt$="O"
	case 25
	txt$="P"
	case 26
	txt$=""
	case 27
	txt$="+"
	case 28
	txt$="Enter"
	case 29
	txt$="CTRL LEFT"
	case 30
	txt$="A"
	case 31
	txt$="S"	
	case 32
	txt$="D"	
	case 33
	txt$="F"		
	case 34
	txt$="G"
	case 35
	txt$="H"
	case 36
	txt$="J"
	case 37
	txt$="K"
	case 38
	txt$="L"
	case 39
	txt$=""
	case 40
	txt$=""
	case 41
	txt$="^"	
	case 42
	txt$="Shift Left"	
	case 43
	txt$="#"
	case 44
	txt$="Y"
	case 45
	txt$="X"
	case 46
	txt$="C"
	case 47
	txt$="V"
	case 48
	txt$="B"
	case 49
	txt$="N"
	case 50
	txt$="M"
	case 51
	txt$=","	
	case 52
	txt$="."	
	case 53
	txt$="-"	
	case 54
	txt$="Shift Right"
	case 55
	txt$="Num *"
	case 56
	txt$="Alt Left"
	case 57
	txt$="Space"
	case 58
	txt$="Shift Lock"
	case 59
	txt$="F1"
	case 60
	txt$="F2"
	case 61
	txt$="F3"	
	case 62
	txt$="F4"	
	case 63
	txt$="F5"
	case 64
	txt$="F6"
	case 65
	txt$="F7"
	case 66
	txt$="F8"
	case 67
	txt$="F9"
	case 68
	txt$="F10"
	case 69
	txt$="Num Lock"
	case 70
	txt$="Roll"
	case 71
	txt$="Num 7"	
	case 72
	txt$="Num 8"	
	case 73
	txt$="Num 9"
	case 74
	txt$="Num -"
	case 75
	txt$="Num 4"
	case 76
	txt$="Num 5"
	case 77
	txt$="Num 6"
	case 78
	txt$="Num +"
	case 79
	txt$="Num 1"
	case 80
	txt$="Num 2"
	case 81
	txt$="Num 3"	
	case 82
	txt$="Num 0"	
	case 83
	txt$="Num ,"		
	case 86
	txt$="<>"
	case 87
	txt$="F11"
	case 88
	txt$="F12"
	case 156
	txt$="Num Enter"
	case 157
	txt$="Ctrl Right"
	case 181
	txt$="Num /"	
	case 183
	txt$="Print"	
	case 184
	txt$="Alt Right"
	case 197
	txt$="Pause"	
	case 199
	txt$="Pos1"	
	case 200
	txt$="Cursor Up"		
	case 201
	txt$="Up"
	case 203
	txt$="Cursor Left"
	case 205
	txt$="Cursor Right"
	case 207
	txt$="End"
	case 208
	txt$="Cursor Down"
	case 209
	txt$="Down"	
	case 210
	txt$="Insert"	
	case 219
	txt$="Windows Left"
	case 220
	txt$="Windows Right"																					
	default
	txt$ = ""
	InpDeviceCode((j-1)*6+i,1)=0
	end select
	
;Joypad
else

	if tmp < 7 and tmp > 0
		select tmp	
		case 1
		txt$="X-Axis 1"
		case 2
		txt$="Y-Axis 1"
		case 3
		txt$="X-Axis 2"
		case 4
		txt$="Y-Axis 2"
		case 5
		txt$="X-Axis 3"
		case 6
		txt$="Y-Axis 3"
		default
		end select
	elseif tmp > 19
		txt$="Button "+(tmp-19)
	else
		txt$=""
		InpDeviceCode((j-1)*6+i,1)=0
	ENDIF
	
endif

return txt$

end function


;-----------------------------------------------------------------------------------------------	
Function create_blurballs(direction=0)

blurpage = CreateImage(BLUR_W,BLUR_H,1,1)
;Create divide table
For t = 0 To DIV_NUM-1
	div(t) = t / 5
Next
;give random values for speed, position etc
For c=0 To MAX_BALL
	b.ball 	 =		New ball
	b.ball\x = 		Rnd(0,BLUR_W-1)
	b.ball\y = 		Rnd(0,BLUR_H-1)
	if direction = 1 then
		b.ball\x_s = 	Rnd(0.5,1.5)
	else
		b.ball\x_s = 	Rnd(-1,1)
	endif
	b.ball\y_s = 	Rnd(-1,1)
	;pick a color for the pixel
	r = Rand(0,1)
	Select r
		Case 0 b.ball\r = 255 : b.ball\g = Rand(30,100)
		Case 1 b.ball\r = Rand(36,255)
	End Select
Next
End Function

;-----------------------------------------------------------------------------------------------	
Function destroy_blurballs()

freeimage blurpage

For b.ball = Each ball
		delete b.ball
next

End Function

;-----------------------------------------------------------------------------------------------	


Function draw_blurballs()
	For b.ball = Each ball
	;Move Pixels
	b.ball\x = b.ball\x + b.ball\x_s
	b.ball\y = b.ball\y + b.ball\y_s
	;Check position
	If b.ball\x < 0 Then
		b.ball\x = BLUR_W-1
	ElseIf b.ball\x >= BLUR_W Then
		b.ball\x = 0
	EndIf
	If b.ball\y < 0 Then
		b.ball\y = BLUR_H-1
	ElseIf b.ball\y >= BLUR_H Then
		b.ball\y = 0
	EndIf
	;add the pixels color val to the col values in the array
	cr = b.ball\r + (in(b.ball\x,b.ball\y) Shr 16)
	If cr > 255 Then cr = 255
	cg = b.ball\g + (in(b.ball\x,b.ball\y) And 65280)Shr 8
	If cg > 255 Then cg = 255
	cb = b.ball\b + (in(b.ball\x,b.ball\y) And 255)
	If cb > 255 Then cb = 255
	in(b.ball\x,b.ball\y) = cr Shl 16 Or cg Shl 8 Or cb
	Next     	
	;set buffer to page then lock the buffer
	SetBuffer ImageBuffer(blurpage)
	LockBuffer ImageBuffer(blurpage)
	;Start X loop
	For x = 0 To BLUR_W - 1
		xm = x - 1 : xp = x + 1
		;Check we dont go outside X array bounderies
		If xm < 0 Then
			xm = BLUR_W-1
		ElseIf xp > BLUR_W-1 Then
			xp = 0
		EndIf
		;start y loop
		For y = 0 To BLUR_H - 1
			ym = y - 1 : yp = y + 1
			;Check Y array bounds
			If ym < 0 Then
				ym = BLUR_H - 1
			ElseIf yp > BLUR_H - 1 Then
				yp = 0
			EndIf
			;Add together 5 pixel red values and divide by 5
			;for average
			cr = in(x,y) Shr 16
			cr = cr + (in(x,ym) Shr 16)
			cr = cr + (in(x,yp) Shr 16)
			cr = cr + (in(xm,y) Shr 16)
			cr = cr + (in(xp,y) Shr 16)
			cr = div(cr) - 1
			If(cr < 0)cr = 0
			cg = (in(x,y) And 65280)Shr 8
			cg = cg + (in(x,ym) And 65280)Shr 8
			cg = cg + (in(x,yp) And 65280)Shr 8
			cg = cg + (in(xm,y) And 65280)Shr 8
			cg = cg + (in(xp,y) And 65280)Shr 8
			cg = div(cg) - 1
			If(cg < 0)cg = 0
			cb = (in(x,y) And 255)
			cb = cb + (in(x,ym) And 255)
			cb = cb + (in(x,yp) And 255)
			cb = cb + (in(xm,y) And 255)
			cb = cb + (in(xp,y) And 255)
			cb = div(cb) - 1
			If(cb < 0)cb = 0
			;Write back values to IN array
			in(x,y) = cr Shl 16 Or cg Shl 8 Or cb
			WritePixelFast x,y,in(x,y)
		Next
	Next
	
UnlockBuffer ImageBuffer(blurpage)
setbuffer backbuffer()
tileimage blurpage,0,0
End Function



;-----------------------------------------------------------------------------------------------	
Function fadegamma(action$)

	select action$
	case "init":
	  gamma_cnt = 0
	  for i = 0 to 255
	  	setgamma i,i,i,i,i,i
	  next
	  updategamma
	  return 1
	case "darken":
		if gamma_cnt < 255
			for i=0 to 255
	  		gamma =i-gamma_cnt
	  		if gamma < 0 then gamma = 0
	  		setgamma i,i,i,gamma,gamma,gamma
			next
			gamma_cnt = gamma_cnt +8
			updategamma
			return 0
		else
			return 1
		endif	
	case "lighten":
		if gamma_cnt > -255
			for i=0 to 255
	  		gamma =i-gamma_cnt-255
	  		if gamma < 0 then gamma = 0
	  		setgamma i,i,i,gamma,gamma,gamma
			next
			gamma_cnt = gamma_cnt -8
			updategamma
			return 0
		else
			return 1
		endif	
	end select
end function



;-----------------------------------------------------------------------------------------------
function init_starsky()
	for i=0 to 350
	starsky.starskydata = new starskydata
	starsky\xpos = rand (C_ScreenX)
	starsky\ypos = rand (C_ScreenY)
	starsky\brightness = rand(70,220)
	starsky\dir = rand (3,6)
	next
end function


;-----------------------------------------------------------------------------------------------


function update_starsky()

	lockbuffer backbuffer()
	
	for starsky.starskydata = each starskydata
		
			starsky\brightness = starsky\brightness-starsky\dir
			if (starsky\brightness < 70)
				starsky\brightness = 70
			  starsky\dir = rand(-6,-3)
			elseif (starsky\brightness > 220)
				starsky\brightness = 220
			  starsky\dir = rand(3,6)
			endif

		rgb = $ff000000+(starsky\brightness shl 16) + (starsky\brightness shl 8) + starsky\brightness
		writepixelfast starsky\xpos,starsky\ypos,rgb
	next
	
	unlockbuffer backbuffer()
	
end function

;-----------------------------------------------------------------------------------------------


function destroy_starsky()
	For starsky.starskydata = each starskydata
		delete starsky.starskydata
	Next
end function


;-----------------------------------------------------------------------------------------------
;
;
;function init_fire()
;
;	dim fire(firew,fireh)
;	fireimg=CreateImage(firew+1,fireh*2+2,1,1)
;	For x=0 To firew
;  	fire(x,fireh)=70
;	Next
;  For i=0 To 30
;    For y=0 To fireh-1
;    	For x=0 To firew
;      	fire(x,y)=fire(x,y+1)-2
;			Next
;  	Next
;  	For x=0 To firew
;    	fire(x,fireh)=fire(x,fireh)+Rand(20)-10
;  	Next
;  	For x=1 To firew-1
;    	fire(x,fireh)=(fire(x-1,fireh)+fire(x,fireh)*3+fire(x+1,fireh))/5
;  	Next
;  	For x=0 To firew
;    	If fire(x,fireh)>127 Then fire(x,fireh)=127
;  	Next
;	Next
;end function
;
;-----------------------------------------------------------------------------------------------
;
;function update_fire()
;  Color 0,0,0
;	Rect firex,firey,firew+1,fireh*2+2,1
;  LockBuffer backbuffer()
;  For y=0 To fireh-1
;    For x=0 To firew
;      fire(x,y)=fire(x,y+1)-2
;      If fire(x,y)=>0 Then WritePixelFast firex+x,firey+y*2,fire(x,y)*$20000
;    Next
;  Next
;  For x=0 To firew
;    fire(x,fireh)=fire(x,fireh)+Rand(20)-10
;  Next
;  For x=1 To firew-1
;    fire(x,fireh)=(fire(x-1,fireh)+fire(x,fireh)*3+fire(x+1,fireh))/5
;  Next
;  For x=0 To firew
;    If fire(x,fireh)>127 Then fire(x,fireh)=127
;    If fire(x,fireh)>0 Then WritePixelFast firex+x,firey+fireh*2,fire(x,fireh)*$20100
;  Next
;  UnlockBuffer backbuffer()
;  GrabImage fireimg,firex,firey,0
;  DrawImage fireimg,firex,firey+1
;
;end function
;
;
;-----------------------------------------------------------------------------------------------
;
;function destroy_fire()
;	
;	Dim fire(0,0)
;	FreeImage fireimg
;	
;end function
;




;-----------------------------------------------------------------------------------------------
function GlitterInit(anzahl=100,xstart=0,xend=800,ystart=0,yend=600)

	k=anzahl
	lockbuffer backbuffer()
	while k <> 0
		i=rand(xstart,xend)
		j=rand(ystart,yend)
		rgb= readpixelfast (i,j)
		if (rgb <> $ff000000) then
			glitter.glitterdata = new glitterdata
			glitter\xpos = i
			glitter\ypos = j
			glitter\timeout = rand(500)
			glitter\alpha = 0
			glitter\speed = rand(30,50)
			k=k-1
		endif
	wend
	unlockbuffer backbuffer()
		
end function

;-----------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------
function GlitterUpdate()

	lockbuffer backbuffer()
	for glitter.glitterdata = each glitterdata
		if glitter\timeout = 0 then
			for i=-5 to 5
				DrawPixelAlpha(glitter\xpos+i, glitter\ypos, glitter\alpha-abs(i)*30)
				DrawPixelAlpha(glitter\xpos, glitter\ypos+i, glitter\alpha-abs(i)*30)
			next			
			glitter\alpha = glitter\alpha + glitter\speed
			if glitter\alpha > 255 then
				glitter\alpha = 255
				glitter\speed = glitter\speed * -1
			elseif glitter\alpha < 0 then
				glitter\timeout = rand(200,1000)
				glitter\alpha = 0
				glitter\speed = rand(30,50)
			endif
		else
			glitter\timeout = glitter\timeout-1
		endif
	next
	unlockbuffer backbuffer()
end function

;-----------------------------------------------------------------------------------------------



;-----------------------------------------------------------------------------------------------	
Function GlitterDestroy(xstart=0,xend=800,ystart=0,yend=600)

For glitter.glitterdata = Each glitterdata
		if glitter\xpos > xstart and glitter\xpos < xend and glitter\ypos > ystart and glitter\ypos < yend
			delete glitter.glitterdata
		endif
next

End Function



;-----------------------------------------------------------------------------------------------	
Function DrawPixelAlpha(xpos,ypos,alpha)

	rgb2= readpixelfast (xpos,ypos)
	r2  = ((rgb2 And 16711680) Shr 16)
	g2  = ((rgb2 And 65280) Shr 8)
	b2  = (rgb2 And 255)
	
	if(alpha < 0) then alpha = 0
	nalpha = 255-alpha
  r3  = (255*alpha + r2*nalpha) shr 8
  g3  = (255*alpha + g2*nalpha) shr 8
  b3  = (255*alpha + b2*nalpha) shr 8

	WritePixelFast xpos,ypos,((r3 Shl 16) + (g3 Shl 8) + b3)

End Function


			
;-----------------------------------------------------------------------------------------------

function PlaySong(dir$)
  if backmusic
;  	x# = 1.0
;  	for i=0 to 100
;  		channelvolume backmusic_chn,x
;  		x = x-0.05
;  		waittimer(Timer)
;  	next
		freesound backmusic
		backmusic = 0
	endif
	if dir <> ""
		backmusic = loadsound(dir)
		if backmusic
			loopsound backmusic
			backmusic_chn = playsound (backmusic)
		endif
	endif
end function		



;-----------------------------------------------------------------------------------------------
function Rotating_Logo_Init()
	
	logo_state = 0
	logo_angle = 0	
	logo_angle2= 0
	
	lockbuffer backbuffer()
	i=0
	while (i < 800)
		j=0
		while (j < 600)
			rgb= readpixelfast (i,j)
			if (rgb <> $ff000000) then	
				logopixel.logopixeldata = new logopixeldata
				logopixel\xpos          = i-400
				logopixel\ypos          = j-300
				logopixel\rgb           = rgb
			endif
			j=j+1
 		wend
 		i=i+1
 	wend
 	unlockbuffer backbuffer()
end function

;-----------------------------------------------------------------------------------------------
function Rotating_Logo_Update(xoff=0,yoff=0)

	lockbuffer backbuffer()
	
	for logopixel.logopixeldata = each logopixeldata

		xpos2 = logopixel\xpos*sin(logo_angle2)
								
		xpos = (xpos2*cos(logo_angle)+logopixel\ypos*sin(logo_angle))/1.5+400+xoff
		ypos = (logopixel\ypos*cos(logo_angle)-xpos2*sin(logo_angle))/1.5+300+yoff
		
	  if (xpos < 800 and xpos > 0 and ypos <600 and ypos > 0) then
			writepixelfast xpos,ypos,logopixel\rgb
		endif
	next
							
	unlockbuffer backbuffer()
  logo_angle = 360*cos (logo_angle2*0.15)
  logo_angle2=logo_angle2-5.75
end function

;-----------------------------------------------------------------------------------------------
function Rotating_Logo_destroy()

	for logopixel.logopixeldata = each logopixeldata
		delete logopixel.logopixeldata
	next
	
end function

;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------


;function debug(txt$)
;	repeat
;		cls
;		color 255,255,255
;  	setfont debugfont
;		text 20,20,availvidmem()+"/"+totalvidmem()
;		text 20,40,txt
;		waittimer(Timer)
;		flip
;	until Keyhit(1)
;end function
