#include <gb/gb.h>
#include <gb/sample.h>

extern const unsigned char Atomic_P[];

void FCAtom(){
    play_sample(Atomic_P, 7200/16);
}

const UBYTE Atomic_P[] =
{
	0x89,0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x9A,0xA9,0x99,
	0x99,0x99,0x99,0x99,0x99,0x99,0x99,0xA9,0x99,0x99,0x99,
	0x99,0x99,0x99,0x99,0x99,0x98,0x88,0x88,0x88,0x88,0x88,
	0x88,0x88,0x88,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
	0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x76,0x67,
	0x76,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,
	0x67,0x66,0x66,0x66,0x66,0x67,0x77,0x77,0x77,0x77,0x78,
	0x78,0x88,0x88,0x88,0x88,0x88,0x98,0x99,0x99,0x99,0x98,
	0x89,0x88,0x88,0x88,0x88,0x89,0x88,0x98,0x99,0x99,0x99,
	0x99,0x98,0x88,0x88,0x88,0x88,0x88,0x87,0x77,0x77,0x77,
	0x77,0x77,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x55,
	0x65,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
	0x66,0x56,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x67,0x77,
	0x77,0x66,0x67,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
	0x77,0x88,0x78,0x89,0xA9,0x87,0x77,0x8A,0xCA,0xAB,0x98,
	0x9A,0xBA,0x99,0xA9,0x9B,0xDC,0xB9,0x99,0x9A,0xBB,0xCB,
	0xBA,0x99,0xA9,0x99,0x99,0xAA,0x99,0x98,0x98,0x9A,0xA9,
	0x98,0x89,0x98,0x99,0x76,0x66,0x78,0x79,0xA7,0x77,0x44,
	0x45,0x7A,0x78,0x96,0x46,0x76,0x67,0x66,0x77,0x88,0x98,
	0x64,0x34,0x56,0x89,0x88,0x76,0x66,0x66,0x87,0x78,0x87,
	0x87,0x67,0x88,0x88,0x76,0x66,0x78,0x88,0x65,0x56,0x67,
	0xAA,0x87,0x54,0x35,0x79,0xA8,0x87,0x55,0x68,0x66,0x56,
	0x78,0x9A,0xB9,0x64,0x44,0x89,0x9A,0xA8,0x77,0x78,0x88,
	0x99,0x99,0x88,0x89,0x99,0xAA,0xA9,0x89,0x99,0xA8,0x8A,
	0x86,0xAC,0xA9,0x84,0x33,0x47,0xBA,0xA8,0x54,0x57,0x77,
	0x75,0x66,0x79,0x98,0x52,0x22,0x36,0x77,0x76,0x43,0x34,
	0x66,0x76,0x65,0x56,0x66,0x67,0x77,0x76,0x66,0x56,0x77,
	0x79,0xB9,0x87,0x33,0x35,0x7A,0xA9,0x97,0x66,0x88,0x89,
	0x88,0xAB,0xBC,0xA7,0x55,0x58,0xBB,0xA9,0x76,0x78,0x9A,
	0x99,0x88,0x78,0x9A,0xBA,0x99,0x76,0x78,0x79,0xDD,0xAA,
	0x54,0x45,0x8A,0xBA,0xA9,0x66,0x79,0x78,0x88,0xAB,0xBB,
	0x97,0x55,0x68,0x9A,0x98,0x76,0x78,0x88,0x87,0x77,0x77,
	0x88,0x88,0x87,0x55,0x75,0x7A,0xC9,0x95,0x33,0x36,0xA9,
	0x87,0x65,0x44,0x65,0x45,0x58,0x99,0x98,0x53,0x46,0x78,
	0x97,0x66,0x66,0x67,0x66,0x65,0x67,0x78,0x88,0x86,0x69,
	0x78,0xDD,0xBA,0x65,0x44,0x8A,0xBA,0xA8,0x76,0x78,0x67,
	0x89,0xBC,0xCA,0x87,0x66,0x8A,0xAB,0x97,0x77,0x78,0x98,
	0x87,0x67,0x78,0x89,0x65,0x98,0x6C,0xCA,0x86,0x74,0x37,
	0x88,0xA9,0x66,0x54,0x66,0x58,0xBB,0xA9,0x75,0x66,0x57,
	0x89,0x88,0x64,0x56,0x78,0x87,0x66,0x66,0x77,0x64,0x67,
	0x7B,0xA8,0x64,0x53,0x48,0x77,0xA8,0x64,0x53,0x46,0x58,
	0x99,0x88,0x75,0x55,0x45,0x89,0x87,0x64,0x57,0x88,0x77,
	0x77,0x76,0x54,0x58,0x9C,0xDB,0x95,0x67,0x57,0xB9,0xBE,
	0xC7,0x76,0x57,0x9B,0xAB,0xCA,0xBB,0x85,0x78,0xAD,0xD8,
	0x99,0x88,0xAA,0x7A,0xA9,0x88,0x54,0x79,0x9D,0xCB,0x85,
	0x66,0x46,0x98,0xBD,0xA7,0x53,0x35,0x98,0x79,0xB8,0x87,
	0x42,0x68,0x99,0x96,0x89,0x75,0x65,0x69,0x97,0x55,0x34,
	0x59,0xAA,0xB9,0x36,0x73,0x48,0x9B,0xDB,0x65,0x75,0x58,
	0x54,0x9D,0x97,0x95,0x37,0x84,0x79,0x89,0x97,0x46,0x98,
	0x88,0x64,0x54,0x47,0xBB,0x9B,0x73,0x65,0x26,0x7A,0xAB,
	0xA4,0x9A,0x54,0x77,0x6C,0xD8,0x7A,0x76,0x98,0x59,0xB9,
	0x78,0x87,0x99,0x87,0x87,0x56,0x79,0xCB,0xBA,0x86,0x83,
	0x36,0x9C,0xAB,0x86,0xA8,0x44,0x68,0x7C,0x96,0x99,0x85,
	0x65,0x57,0x86,0x79,0x86,0x66,0x66,0x74,0x34,0x6A,0x78,
	0xB9,0x47,0x31,0x38,0xB4,0x9A,0x49,0x83,0x16,0x93,0x79,
	0x79,0xB9,0x56,0x85,0x66,0x68,0xAA,0x77,0x78,0x66,0x43,
	0x6B,0xA5,0xBD,0x78,0x93,0x29,0xC5,0x5B,0xA7,0xB9,0x35,
	0xB7,0x37,0xAA,0xAC,0x96,0xA9,0x55,0x89,0x8B,0xA7,0x9A,
	0x86,0x55,0x7A,0x87,0xAC,0xB6,0xB5,0x26,0x85,0x5B,0xB7,
	0xB9,0x64,0x97,0x48,0xA9,0x8B,0xA7,0x97,0x55,0x87,0x79,
	0x98,0x87,0x77,0x55,0x89,0x57,0xAC,0x66,0xC6,0x46,0x83,
	0x39,0x95,0x9B,0x57,0xA5,0x34,0x96,0x5B,0x98,0x9A,0x65,
	0x75,0x57,0x98,0x88,0x76,0x45,0xA5,0x6A,0xC9,0x4C,0x94,
	0x5A,0x72,0x99,0x69,0xB9,0x5B,0xA7,0x58,0xA5,0x9B,0xA8,
	0x88,0x58,0x86,0x89,0x97,0x89,0x74,0x5B,0x75,0x7A,0xB4,
	0x9C,0x52,0x8B,0x26,0x95,0x59,0xA4,0x9B,0x65,0x7B,0x45,
	0xAA,0x87,0xA6,0x66,0x67,0x78,0x77,0x97,0x53,0x99,0x48,
	0xBC,0x48,0xC6,0x26,0xB3,0x5A,0x77,0x8A,0x57,0xA6,0x57,
	0xB6,0x7B,0xA7,0x69,0x87,0x66,0x78,0x76,0x68,0x74,0x49,
	0x75,0x8A,0xB3,0x6C,0x63,0x6A,0x44,0xA7,0x58,0xB8,0x69,
	0x65,0x6A,0x75,0x9A,0x96,0x99,0x76,0x68,0x88,0x88,0x99,
	0x64,0x8B,0x57,0xCD,0x95,0xBB,0x65,0xBA,0x49,0x97,0x8A,
	0xA8,0xBA,0x86,0x9A,0x67,0xAC,0x87,0xA8,0x75,0x78,0x77,
	0x78,0x87,0x55,0x85,0x48,0xBB,0x38,0xA5,0x17,0x94,0x69,
	0x75,0x78,0x58,0x97,0x58,0xA5,0x58,0x97,0x58,0x98,0x77,
	0x98,0x66,0x78,0x87,0x56,0xA7,0x48,0xBA,0x38,0xC6,0x39,
	0xB4,0x68,0x75,0x9A,0x78,0xA7,0x67,0xA7,0x58,0xA8,0x68,
	0x97,0x65,0x88,0x78,0x88,0x86,0x34,0x97,0x59,0xBA,0x37,
	0xC6,0x27,0xB5,0x5A,0x65,0x9B,0x68,0xA7,0x67,0xB6,0x59,
	0xB9,0x79,0xA8,0x77,0x88,0x89,0x89,0x99,0x55,0x89,0x67,
	0xAC,0x95,0xAA,0x45,0xA8,0x38,0x95,0x6A,0xA6,0x89,0x54,
	0x7A,0x66,0xA9,0x66,0x86,0x56,0x66,0x78,0x65,0x88,0x75,
	0x45,0x87,0x48,0xAA,0x26,0xC7,0x48,0xB3,0x5A,0x64,0x8B,
	0x97,0xA8,0x45,0xA8,0x48,0xB9,0x68,0x96,0x67,0x78,0x89,
	0x77,0x88,0x76,0x57,0x98,0x79,0xBB,0x47,0xB6,0x48,0x94,
	0x5C,0x84,0x9C,0x96,0xA9,0x56,0xB7,0x37,0xBA,0x89,0x85,
	0x67,0x66,0x8A,0x77,0x89,0x77,0x45,0x69,0x77,0xAC,0xB5,
	0xB9,0x35,0xA6,0x38,0xB9,0x5A,0xC8,0x8A,0x74,0x6A,0x75,
	0xAB,0x88,0x98,0x46,0x76,0x69,0xB6,0x77,0x86,0x64,0x36,
	0xA9,0x58,0xBA,0x59,0x73,0x49,0x63,0x6A,0xA4,0x9B,0x78,
	0x85,0x36,0xB6,0x6B,0xB9,0x99,0x54,0x68,0x67,0xAB,0x88,
	0x87,0x68,0x63,0x58,0xA6,0x7A,0xC8,0x89,0x23,0x9A,0x46,
	0x9B,0x89,0x96,0x59,0x72,0x59,0xA7,0xBB,0x89,0x96,0x25,
	0x87,0x79,0xB9,0x88,0x65,0x67,0x53,0x68,0xB8,0x7B,0xB7,
	0x96,0x23,0x7A,0x77,0xA9,0x89,0x63,0x59,0x85,0x58,0x89,
	0xC8,0x78,0x85,0x36,0x78,0xAA,0x87,0x77,0x66,0x68,0x86,
	0x56,0x7A,0x87,0xBA,0x68,0x62,0x56,0xB7,0x7A,0x79,0x97,
	0x35,0x86,0x58,0x87,0x9C,0x97,0x77,0x66,0x87,0x69,0xB9,
	0x77,0x76,0x89,0x88,0x75,0x67,0x9A,0x9C,0xC7,0x8A,0x25,
	0x79,0x97,0xC8,0x6B,0x96,0x57,0x55,0xAA,0x78,0xC9,0x88,
	0x75,0x59,0x97,0x88,0x88,0x97,0x67,0x76,0x78,0x63,0x57,
	0x7A,0xAB,0xA7,0x69,0x42,0x67,0x79,0xC9,0x68,0x86,0x55,
	0x33,0x79,0x99,0xA8,0x68,0x85,0x45,0x78,0xA9,0x77,0x77,
	0x66,0x67,0x67,0x88,0x65,0x88,0x9B,0xC9,0x66,0x86,0x58,
	0x77,0x9B,0x96,0x77,0x67,0x86,0x68,0x88,0xAA,0x89,0x97,
	0x67,0x75,0x79,0xA8,0x88,0x76,0x67,0x77,0x77,0x98,0x55,
	0x66,0x8B,0xDA,0x87,0x64,0x77,0x77,0x9A,0x89,0x96,0x67,
	0x65,0x69,0x9A,0x98,0x77,0x87,0x78,0x77,0x77,0x88,0x88,
	0x86,0x67,0x77,0x77,0x67,0x65,0x67,0x68,0xAC,0x98,0x65,
	0x46,0x89,0x98,0x76,0x66,0x69,0x97,0x55,0x56,0x88,0x99,
	0x87,0x68,0x98,0x88,0x75,0x68,0x77,0x78,0x66,0x78,0x78,
	0x88,0x76,0x67,0x89,0xAB,0xB9,0x87,0x66,0x88,0x99,0x77,
	0x65,0x67,0x88,0x78,0x77,0x89,0x89,0x98,0x87,0x88,0x77,
	0x77,0x77,0x88,0x87,0x77,0x66,0x77,0x78,0x88,0x89,0x88,
	0x98,0x89,0x98,0x89,0x88,0x88,0x77,0x77,0x87,0x67,0x76,
	0x66,0x76,0x78,0x88,0x89,0x87,0x89,0x87,0x88,0x76,0x77,
	0x77,0x77,0x65,0x66,0x77,0x77,0x77,0x77,0x88,0x89,0x88,
	0x88,0x88,0x88,0x87,0x76,0x67,0x77,0x87,0x66,0x76,0x66,
	0x88,0x88,0x88,0x89,0xA9,0x77,0x76,0x67,0x98,0x78,0x85,
	0x67,0x76,0x78,0x77,0x88,0x78,0x98,0x89,0x98,0x89,0x99,
	0x99,0x99,0x87,0x77,0x66,0x76,0x77,0x67,0x98,0x78,0x87,
	0x78,0x88,0xAA,0x88,0x87,0x77,0x87,0x77,0x66,0x77,0x77,
	0x76,0x66,0x67,0x89,0x89,0x98,0x89,0x88,0x88,0x87,0x88,
	0x87,0x76,0x56,0x66,0x67,0x76,0x67,0x77,0x87,0x78,0x88,
	0x89,0x88,0x78,0x76,0x67,0x76,0x77,0x77,0x87,0x66,0x76,
	0x67,0x88,0x99,0x97,0x78,0x88,0x89,0x98,0x88,0x78,0x87,
	0x66,0x65,0x68,0x77,0x77,0x77,0x78,0x98,0x98,0x88,0x88,
	0x9A,0x98,0x87,0x77,0x77,0x78,0x77,0x67,0x77,0x77,0x77,
	0x88,0x89,0x89,0x98,0x88,0x98,0x88,0x77,0x88,0x77,0x78,
	0x76,0x76,0x77,0x66,0x77,0x77,0x87,0x78,0x77,0x88,0x99,
	0x88,0x77,0x86,0x68,0x77,0x67,0x66,0x66,0x76,0x67,0x76,
	0x67,0x77,0x99,0x99,0x98,0x88,0x77,0x78,0x88,0x88,0x76,
	0x77,0x77,0x77,0x66,0x66,0x78,0x97,0x78,0x87,0x99,0x98,
	0x89,0x98,0x88,0x77,0x76,0x68,0x87,0x89,0x75,0x67,0x66,
	0x88,0x78,0xA9,0x88,0x87,0x99,0x88,0x88,0x78,0x98,0x77,
	0x76,0x77,0x77,0x76,0x66,0x76,0x78,0x87,0x78,0x88,0x99,
	0x98,0x78,0x87,0x88,0x88,0x87,0x66,0x66,0x77,0x66,0x77,
	0x77,0x77,0x88,0x87,0x78,0x77,0x99,0x88,0x98,0x77,0x77,
	0x66,0x77,0x77,0x77,0x66,0x66,0x67,0x77,0x88,0x77,0x77,
	0x88,0x89,0x98,0x88,0x88,0x77,0x77,0x77,0x77,0x77,0x77,
	0x76,0x77,0x77,0x78,0x88,0x88,0x99,0x89,0x98,0x88,0x88,
	0x88,0x88,0x87,0x77,0x77,0x67,0x88,0x77,0x76,0x67,0x78,
	0x88,0x88,0x98,0x88,0x87,0x78,0x88,0x88,0x87,0x77,0x66,
	0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x78,0x88,0x99,0x88,
	0x98,0x77,0x88,0x88,0x87,0x77,0x76,0x66,0x66,0x67,0x67,
	0x77,0x77,0x77,0x77,0x88,0x87,0x88,0x89,0x98,0x88,0x77,
	0x77,0x67,0x88,0x77,0x86,0x67,0x76,0x68,0x98,0x89,0x87,
	0x89,0x99,0x99,0x88,0x87,0x67,0x87,0x87,0x77,0x66,0x77,
	0x87,0x77,0x78,0x77,0x77,0x78,0x88,0x88,0x99,0x88,0x87,
	0x78,0x78,0x88,0x87,0x77,0x76,0x77,0x77,0x66,0x67,0x88,
	0x88,0x88,0x88,0x77,0x88,0x88,0x99,0x77,0x87,0x67,0x76,
	0x78,0x77,0x77,0x77,0x77,0x67,0x87,0x67,0x87,0x88,0x77,
	0x78,0x88,0x98,0x88,0x77,0x78,0x87,0x87,0x77,0x77,0x77,
	0x67,0x78,0x88,0x87,0x77,0x78,0x89,0x89,0x98,0x77,0x88,
	0x88,0x88,0x87,0x87,0x77,0x76,0x67,0x77,0x78,0x78,0x87,
	0x78,0x88,0x88,0x88,0x99,0x88,0x87,0x77,0x77,0x77,0x77,
	0x87,0x76,0x67,0x77,0x78,0x88,0x77,0x87,0x89,0x97,0x78,
	0x77,0x77,0x67,0x78,0xA8,0x66,0x65,0x57,0x76,0x78,0x88,
	0x87,0x77,0x66,0x77,0x78,0x88,0x8A,0x98,0x76,0x55,0x67,
	0x78,0x99,0x77,0x66,0x66,0x66,0x68,0x99,0x99,0x87,0x89,
	0x88,0x88,0x89,0x86,0x87,0x77,0xAA,0x77,0x65,0x46,0x88,
	0x87,0x88,0x88,0x88,0x77,0x67,0x99,0xAA,0xA8,0x77,0x76,
	0x67,0x76,0x8A,0x99,0x87,0x55,0x57,0x89,0x99,0x98,0x77,
	0x67,0x89,0x99,0x98,0x77,0x76,0x77,0x78,0x9B,0x88,0x64,
	0x45,0x68,0x88,0x99,0x87,0x77,0x77,0x55,0x7A,0xAB,0xA8,
	0x65,0x65,0x67,0x77,0x79,0x99,0x96,0x44,0x46,0x79,0xA9,
	0x87,0x66,0x78,0x98,0x87,0x88,0x87,0x67,0x66,0x8B,0xB8,
	0x85,0x34,0x57,0xA8,0x89,0x76,0x67,0x77,0x87,0x78,0x9A,
	0xBA,0x86,0x56,0x78,0x99,0x88,0x88,0x77,0x65,0x56,0x78,
	0x9A,0x97,0x77,0x78,0x9A,0x87,0x88,0x97,0x79,0x77,0x9B,
	0xA9,0x84,0x33,0x36,0xA9,0xA9,0x76,0x56,0x87,0x67,0x88,
	0x9A,0xBA,0x96,0x44,0x67,0x79,0x88,0x77,0x76,0x56,0x66,
	0x78,0x88,0x86,0x67,0x88,0x99,0x87,0x77,0x57,0x87,0x8A,
	0xB9,0x85,0x34,0x44,0x9A,0x9A,0x96,0x55,0x68,0x76,0x78,
	0x9A,0xAA,0x97,0x44,0x66,0x8A,0x99,0x97,0x65,0x55,0x67,
	0x9A,0x99,0x86,0x56,0x79,0xAA,0x98,0x65,0x78,0x8A,0xDA,
	0xA8,0x43,0x44,0x7B,0xAB,0xA8,0x55,0x67,0x76,0x88,0x9B,
	0xAA,0x97,0x44,0x55,0x79,0xA9,0x99,0x76,0x55,0x56,0x89,
	0x99,0x86,0x45,0x88,0x9A,0x96,0x45,0x67,0x9E,0xC9,0x94,
	0x34,0x57,0xAA,0x99,0x86,0x55,0x67,0x66,0x79,0xAA,0xA9,
	0x76,0x54,0x68,0x89,0xA9,0x97,0x65,0x55,0x79,0x9A,0x97,
	0x65,0x57,0x9B,0xB9,0x45,0x65,0x7C,0xDA,0xA6,0x34,0x57,
	0xBB,0x98,0x87,0x66,0x77,0x67,0x68,0xAA,0xBA,0x86,0x56,
	0x67,0x78,0xAA,0x98,0x75,0x55,0x79,0x9A,0xA7,0x55,0x67,
	0x9B,0xA5,0x57,0x68,0xDE,0xA8,0x54,0x35,0x89,0x99,0x99,
	0x86,0x75,0x55,0x66,0x8B,0xBA,0x97,0x55,0x66,0x79,0x89,
	0x99,0x77,0x65,0x56,0x78,0x98,0x75,0x56,0x89,0x95,0x56,
	0x57,0xCC,0x99,0x74,0x36,0x66,0x88,0x9A,0x97,0x76,0x55,
	0x66,0x79,0xAA,0x98,0x76,0x56,0x77,0x88,0x9A,0x98,0x76,
	0x67,0x89,0x87,0x66,0x79,0xA8,0x56,0x85,0x8D,0xB8,0x98,
	0x55,0x75,0x57,0x99,0xAA,0x77,0x77,0x56,0x56,0x8B,0xBA,
	0x98,0x76,0x65,0x56,0x79,0xAA,0x87,0x65,0x78,0x78,0x87,
	0x78,0x97,0x47,0x87,0x9B,0x97,0x89,0x66,0x75,0x56,0x89,
	0x88,0x78,0x98,0x65,0x66,0x8A,0xA8,0x78,0x99,0x76,0x54,
	0x68,0x88,0x88,0x88,0x86,0x56,0x76,0x78,0x63,0x78,0x7A,
	0xDA,0x89,0x96,0x56,0x34,0x79,0x98,0x89,0xA9,0x75,0x44,
	0x79,0x87,0x98,0x9B,0xA8,0x65,0x45,0x68,0x78,0xAA,0xA8,
	0x65,0x67,0x78,0x86,0x58,0x78,0xA9,0xA9,0x9A,0x74,0x56,
	0x67,0x87,0x66,0x8A,0x9A,0x96,0x79,0x76,0x77,0x79,0xA8,
	0x77,0x87,0x76,0x55,0x68,0x98,0x87,0x78,0x87,0x77,0x75,
	0x68,0x99,0xAC,0x95,0x89,0x54,0x77,0x67,0x97,0x68,0x87,
	0x68,0x87,0x89,0x98,0x88,0x88,0x89,0x76,0x75,0x67,0x87,
	0x78,0x87,0x77,0x77,0x77,0x78,0x87,0x77,0x78,0x87,0x89,
	0x89,0x98,0x77,0x76,0x67,0x88,0xA9,0x87,0x76,0x57,0x87,
	0x78,0x87,0x8A,0x97,0x87,0x77,0x87,0x78,0x88,0x77,0x77,
	0x77,0x76,0x77,0x77,0x88,0x78,0x88,0x77,0x77,0x88,0x88,
	0x76,0x66,0x79,0x98,0x87,0x66,0x77,0x67,0x86,0x57,0x97,
	0x8A,0x86,0x78,0x67,0x88,0x89,0x97,0x77,0x55,0x66,0x78,
	0x88,0x77,0x87,0x77,0x88,0x87,0x67,0x78,0x98,0x99,0x89,
	0x86,0x76,0x77,0x65,0x68,0x89,0x99,0x77,0x87,0x77,0x78,
	0x9A,0x87,0x77,0x78,0x87,0x77,0x87,0x76,0x77,0x89,0x87,
	0x67,0x77,0x76,0x79,0x99,0x9A,0x88,0x9A,0x66,0x75,0x68,
	0x75,0x77,0x78,0x98,0x78,0x88,0x87,0x67,0x89,0x87,0x88,
	0x98,0x86,0x66,0x88,0x87,0x78,0x87,0x76,0x77,0x67,0x55,
	0x78,0x9A,0xA9,0x79,0xC8,0x68,0x44,0x78,0x56,0x78,0x9A,
	0x86,0x79,0x87,0x75,0x58,0x99,0x88,0x77,0x88,0x66,0x78,
	0x99,0x87,0x78,0x88,0x77,0x78,0x86,0x68,0x79,0xAB,0xA8,
	0x9A,0x65,0x76,0x57,0x76,0x68,0x89,0xA8,0x78,0x98,0x88,
	0x66,0x89,0x78,0x87,0x89,0x85,0x56,0x68,0x88,0x88,0x87,
	0x76,0x57,0x89,0x65,0x88,0x89,0xBB,0x78,0xB8,0x58,0x54,
	0x78,0x55,0x78,0x89,0x97,0x78,0x87,0x66,0x69,0xA9,0x88,
	0x76,0x77,0x66,0x78,0x88,0x77,0x66,0x66,0x77,0x68,0x99,
	0x54,0x78,0x89,0xCA,0x8B,0xC6,0x55,0x35,0x87,0x68,0x88,
	0x88,0x65,0x67,0x88,0x97,0x8A,0xA8,0x86,0x78,0x88,0x87,
	0x68,0x87,0x76,0x77,0x77,0x77,0x78,0x89,0x85,0x78,0x89,
	0xAC,0x77,0xC9,0x57,0x64,0x88,0x66,0x77,0x69,0x97,0x88,
	0x87,0x98,0x68,0x98,0x88,0x77,0x88,0x88,0x65,0x77,0x77,
	0x76,0x67,0x77,0x77,0x78,0x99,0x76,0x88,0x8A,0xA7,0x89,
	0x76,0x87,0x58,0x85,0x57,0x55,0x88,0x88,0x98,0x88,0x77,
	0x88,0x89,0x88,0x87,0x78,0x76,0x67,0x77,0x77,0x66,0x66,
	0x67,0x77,0x89,0x99,0x98,0x88,0x88,0x88,0x89,0x98,0x77,
	0x66,0x66,0x67,0x77,0x88,0x77,0x77,0x77,0x88,0x89,0x99,
	0x99,0x88,0x88,0x77,0x87,0x77,0x76,0x67,0x76,0x77,0x77,
	0x87,0x78,0x88,0x89,0x89,0x99,0x88,0x88,0x88,0x77,0x66,
	0x77,0x77,0x76,0x67,0x66,0x78,0x88,0x99,0x88,0x88,0x88,
	0x88,0x87,0x77,0x77,0x77,0x77,0x66,0x66,0x77,0x77,0x88,
	0x88,0x88,0x88,0x88,0x88,0x98,0x86,0x77,0x77,0x77,0x77,
	0x76,0x66,0x67,0x88,0x79,0x98,0x87,0x88,0x89,0x98,0x88,
	0x77,0x78,0x76,0x76,0x66,0x76,0x78,0x88,0x88,0x78,0x98,
	0x88,0x89,0x88,0x88,0x78,0x87,0x67,0x66,0x77,0x77,0x77,
	0x77,0x88,0x89,0x98,0x89,0x88,0x89,0x77,0x88,0x77,0x76,
	0x66,0x76,0x67,0x77,0x77,0x78,0x77,0x88,0x8A,0x98,0x99,
	0x88,0x87,0x78,0x75,0x77,0x57,0x76,0x67,0x77,0x67,0x77,
	0x78,0x99,0x9A,0x98,0x88,0x77,0x77,0x77,0x77,0x66,0x66,
	0x66,0x77,0x88,0x98,0x57,0x99,0xAC,0xA8,0xA8,0x67,0x75,
	0x78,0x76,0x76,0x67,0x86,0x67,0x77,0x89,0x88,0x9A,0xA9,
	0x88,0x77,0x77,0x76,0x77,0x77,0x76,0x66,0x66,0x78,0x78,
	0x87,0x79,0x96,0x89,0x87,0xAB,0x79,0x87,0x76,0x66,0x77,
	0x67,0x75,0x78,0x77,0x77,0x88,0xA9,0x99,0x89,0x97,0x66,
	0x66,0x88,0x77,0x76,0x66,0x55,0x67,0x88,0x88,0x77,0x78,
	0x99,0x68,0x98,0x89,0x97,0x99,0x87,0x66,0x46,0x86,0x77,
	0x68,0x97,0x77,0x77,0x9A,0x88,0xA9,0x9A,0x75,0x56,0x67,
	0x88,0x78,0x87,0x66,0x55,0x77,0x78,0x88,0x99,0x88,0x97,
	0x58,0x88,0x9B,0xA8,0x88,0x75,0x54,0x46,0x88,0x88,0x77,
	0x77,0x66,0x77,0x99,0x89,0x99,0x9A,0x85,0x56,0x68,0x86,
	0x78,0x77,0x75,0x56,0x66,0x77,0x78,0x99,0x99,0xA8,0x59,
	0x77,0x7B,0xA8,0x98,0x85,0x64,0x36,0x66,0x88,0x78,0x99,
	0x77,0x66,0x89,0x89,0x99,0xAA,0x96,0x56,0x66,0x97,0x68,
	0x88,0x76,0x55,0x68,0x78,0x88,0x99,0x99,0xA9,0x65,0x87,
	0x89,0xB9,0x99,0x98,0x66,0x55,0x75,0x69,0x78,0xA8,0x78,
	0x78,0x9A,0x88,0x97,0x79,0x98,0x87,0x87,0x78,0x65,0x67,
	0x86,0x67,0x68,0x87,0x77,0x88,0x88,0x87,0x97,0x57,0x88,
	0x8A,0x87,0x87,0x77,0x65,0x56,0x56,0x66,0x69,0x98,0x88,
	0x88,0x98,0x87,0x77,0x88,0x77,0x77,0x77,0x87,0x67,0x78,
	0x76,0x77,0x77,0x77,0x78,0x88,0x88,0x89,0x89,0x97,0x79,
	0x77,0x98,0x78,0x76,0x78,0x67,0x86,0x56,0x77,0x78,0x88,
	0x89,0x98,0x99,0x89,0x88,0x78,0x87,0x77,0x77,0x77,0x66,
	0x76,0x78,0x88,0x88,0x88,0x88,0x97,0x78,0x87,0x88,0x88,
	0x99,0x77,0x87,0x77,0x76,0x77,0x77,0x77,0x77,0x77,0x77,
	0x88,0x77,0x88,0x78,0x87,0x78,0x77,0x88,0x77,0x87,0x67,
	0x88,0x88,0x87,0x77,0x76,0x78,0x88,0x77,0x77,0x78,0x87,
	0x77,0x77,0x87,0x88,0x97,0x77,0x77,0x88,0x88,0x88,0x88,
	0x76,0x67,0x88,0x88,0x77,0x77,0x87,0x87,0x88,0x77,0x78,
	0x88,0x88,0x88,0x99,0x88,0x87,0x77,0x77,0x77,0x88,0x87,
	0x77,0x77,0x77,0x87,0x78,0x87,0x78,0x88,0x88,0x77,0x77,
	0x88,0x88,0x88,0x76,0x67,0x77,0x88,0x88,0x87,0x77,0x77,
	0x88,0x87,0x77,0x77,0x88,0x77,0x88,0x76,0x77,0x88,0x77,
	0x78,0x77,0x77,0x78,0x88,0x88,0x88,0x87,0x77,0x77,0x77,
	0x77,0x87,0x77,0x67,0x77,0x78,0x87,0x88,0x88,0x88,0x77,
	0x77,0x76,0x67,0x88,0x77,0x77,0x77,0x67,0x77,0x88,0x77,
	0x88,0x88,0x88,0x88,0x88,0x88,0x77,0x78,0x77,0x88,0x78,
	0x87,0x67,0x88,0x88,0x87,0x77,0x87,0x77,0x88,0x88,0x88,
	0x77,0x77,0x77,0x77,0x78,0x88,0x87,0x67,0x77,0x78,0x88,
	0x99,0x88,0x87,0x77,0x77,0x78,0x88,0x87,0x76,0x67,0x77,
	0x78,0x88,0x88,0x77,0x77,0x88,0x88,0x88,0x77,0x77,0x78,
	0x77,0x76,0x77,0x77,0x77,0x78,0x88,0x77,0x87,0x78,0x88,
	0x88,0x87,0x88,0x77,0x77,0x77,0x88,0x77,0x77,0x67,0x88,
	0x88,0x87,0x78,0x78,0x88,0x77,0x78,0x88,0x88,0x77,0x77,
	0x67,0x77,0x88,0x88,0x88,0x87,0x78,0x88,0x88,0x88,0x88,
	0x88,0x78,0x87,0x77,0x77,0x77,0x77,0x77,0x88,0x77,0x77,
	0x78,0x77,0x87,0x88,0x87,0x77,0x77,0x77,0x77,0x77,0x87,
	0x87,0x77,0x77,0x78,0x88,0x78,0x87,0x88,0x87,0x88,0x77,
	0x77,0x77,0x77,0x78,0x88,0x77,0x77,0x77,0x77,0x88,0x78,
	0x88,0x87,0x77,0x77,0x77,0x78,0x88,0x87,0x78,0x77,0x77,
	0x78,0x88,0x88,0x78,0x87,0x78,0x88,0x88,0x77,0x87,0x67,
	0x77,0x78,0x87,0x78,0x77,0x78,0x87,0x78,0x78,0x88,0x88,
	0x87,0x77,0x77,0x77,0x88,0x88,0x77,0x77,0x77,0x78,0x88,
	0x87,0x78,0x78,0x78,0x86,0x88,0x68,0x78,0x78,0x87,0x86,
	0x77,0x69,0x77,0x88,0x78,0x87,0x77,0x87,0x87,0x88,0x78,
	0x87,0x88,0x77,0x77,0x68,0x88,0x77,0x87,0x87,0x87,0x78,
	0x78,0x88,0x88,0x87,0x77,0x78,0x98,0x88,0x77,0x77,0x77,
	0x88,0x87,0x77,0x78,0x88,0x77,0x88,0x88,0x77,0x88,0x77,
	0x77,0x78,0x87,0x87,0x78,0x87,0x78,0x87,0x88,0x77,0x88,
	0x88,0x88,0x77,0x87,0x77,0x77,0x78,0x77,0x78,0x77,0x76,
	0x77,0x88,0x88,0x87,0x87,0x77,0x77,0x87,0x78,0x87,0x77,
	0x77,0x87,0x77,0x78,0x87,0x77,0x88,0x87,0x88,0x87,0x77,
	0x77,0x78,0x88,0x88,0x87,0x77,0x87,0x78,0x78,0x77,0x77,
	0x88,0x87,0x88,0x78,0x87,0x77,0x87,0x78,0x88,0x78,0x87,
	0x87,0x88,0x78,0x78,0x78,0x87,0x78,0x77,0x88,0x88,0x77,
	0x87,0x88,0x77,0x77,0x77,0x78,0x77,0x88,0x88,0x88,0x77,
	0x78,0x87,0x88,0x77,0x77,0x78,0x87,0x77,0x77,0x88,0x88,
	0x87,0x77,0x77,0x78,0x77,0x77,0x88,0x88,0x88,0x78,0x87,
	0x77,0x77,0x88,0x88,0x77,0x77,0x77,0x87,0x89,0x88,0x77,
	0x77,0x77,0x88,0x88,0x87,0x76,0x67,0x78,0x87,0x88,0x88,
	0x77,0x77,0x88,0x78,0x87,0x88,0x77,0x87,0x78,0x87,0x77,
	0x77,0x88,0x78,0x88,0x88,0x88,0x88,0x87,0x77,0x78,0x77,
	0x87,0x78,0x77,0x77,0x77,0x88,0x88,0x77,0x77,0x87,0x87,
	0x77,0x77,0x77,0x77,0x87,0x77,0x77,0x78,0x88,0x87,0x78,
	0x77,0x88,0x97,0x77,0x66,0x78,0x77,0x88,0x87,0x66,0x76,
	0x67,0x88,0x88,0x88,0x87,0x78,0x87,0x78,0x77,0x77,0x67,
	0x77,0x77,0x77,0x77,0x88,0x97,0x88,0x68,0xAC,0xA8,0x87,
	0x56,0x77,0x78,0x89,0x97,0x66,0x64,0x67,0x79,0x89,0x9A,
	0x98,0x76,0x77,0x69,0x99,0x87,0x66,0x67,0x78,0x86,0x56,
	0x78,0x96,0x67,0x68,0xCE,0xB8,0x65,0x35,0x76,0x9A,0x9A,
	0x86,0x55,0x54,0x66,0x8A,0xA9,0x99,0x89,0x86,0x67,0x67,
	0x89,0x98,0x76,0x54,0x57,0x77,0x77,0x79,0x95,0x66,0x59,
	0xED,0xB9,0x54,0x45,0x78,0xA8,0x99,0x75,0x55,0x46,0x76,
	0x9B,0xA9,0x98,0x67,0x86,0x77,0x77,0x88,0x87,0x77,0x67,
	0x77,0x76,0x66,0x88,0x57,0x97,0x9E,0xCA,0x95,0x53,0x57,
	0x9B,0xA9,0x97,0x65,0x55,0x56,0x8A,0xAA,0x98,0x77,0x87,
	0x78,0x76,0x68,0x88,0x87,0x66,0x76,0x77,0x77,0x79,0x65,
	0x97,0x6C,0xEA,0xA7,0x65,0x46,0x89,0x99,0x97,0x56,0x66,
	0x67,0x78,0xA9,0x98,0x78,0x88,0x98,0x76,0x77,0x67,0x87,
	0x87,0x65,0x67,0x77,0x87,0x47,0x87,0xBD,0xBA,0x86,0x64,
	0x47,0x9A,0xAA,0x75,0x55,0x65,0x67,0x9A,0x98,0x86,0x67,
	0x78,0x99,0x88,0x76,0x77,0x77,0x76,0x56,0x67,0x77,0x56,
	0x87,0xAF,0xCA,0x95,0x54,0x46,0xAB,0xAB,0x86,0x55,0x55,
	0x67,0x8A,0xA9,0x97,0x66,0x67,0x99,0x98,0x87,0x88,0x77,
	0x76,0x66,0x66,0x67,0x54,0x76,0x9F,0xCA,0x95,0x54,0x45,
	0x9C,0xAA,0x96,0x45,0x55,0x67,0x79,0x97,0x88,0x78,0x88,
	0x88,0x76,0x76,0x78,0x99,0x98,0x67,0x55,0x67,0x44,0x87,
	0x8D,0xDB,0xA5,0x45,0x46,0x9B,0xAA,0x96,0x45,0x66,0x67,
	0x8A,0xA9,0x98,0x66,0x67,0x8A,0xA8,0x76,0x67,0x87,0x77,
	0x66,0x77,0x78,0x63,0x67,0x8D,0xEC,0x96,0x65,0x46,0x9A,
	0xA9,0x86,0x66,0x88,0x65,0x57,0x89,0x9A,0x97,0x78,0x77,
	0x89,0x88,0x88,0x88,0x87,0x55,0x66,0x77,0x75,0x57,0x89,
	0xBC,0xA7,0x77,0x78,0x9A,0x97,0x65,0x56,0x89,0x87,0x76,
	0x77,0x78,0x98,0x88,0x87,0x78,0x88,0x88,0x87,0x77,0x66,
	0x77,0x77,0x76,0x66,0x78,0x77,0x89,0x89,0xA9,0x99,0x99,
	0x77,0x77,0x67,0x87,0x66,0x66,0x67,0x77,0x78,0x99,0x99,
	0x88,0x87,0x88,0x87,0x87,0x67,0x87,0x66,0x65,0x56,0x77,
	0x67,0x99,0x89,0xA9,0x87,0x97,0x68,0x87,0x67,0x77,0x78,
	0x76,0x77,0x88,0x89,0x88,0x88,0x77,0x77,0x66,0x77,0x77,
	0x87,0x67,0x76,0x68,0x87,0x89,0x98,0x89,0x87,0x89,0x76,
	0x78,0x77,0x87,0x67,0x87,0x77,0x77,0x78,0x88,0x88,0x88,
	0x88,0x77,0x78,0x77,0x77,0x66,0x77,0x56,0x88,0x78,0x99,
	0x89,0x98,0x77,0x88,0x79,0x97,0x67,0x76,0x78,0x86,0x89,
	0x88,0x88,0x77,0x77,0x87,0x78,0x88,0x76,0x77,0x78,0x77,
	0x87,0x68,0x76,0x78,0x88,0x99,0x97,0x79,0x86,0x89,0x76,
	0x77,0x56,0x98,0x78,0x98,0x78,0x87,0x79,0x87,0x78,0x77,
	0x78,0x76,0x77,0x66,0x67,0x88,0x89,0x87,0x88,0x88,0x99,
	0x87,0x89,0x87,0x98,0x66,0x77,0x57,0x98,0x78,0x98,0x68,
	0x87,0x78,0x88,0x89,0x87,0x67,0x76,0x77,0x65,0x68,0x77,
	0x88,0x77,0x99,0x79,0xA9,0x76,0x76,0x78,0x98,0x78,0x78,
	0x76,0x57,0x87,0x88,0x77,0x98,0x56,0x78,0x88,0x87,0x88,
	0x76,0x67,0x76,0x57,0x88,0x89,0x88,0x89,0x86,0x7B,0x95,
	0x66,0x58,0xA8,0x79,0xB8,0x69,0x78,0x88,0x57,0x98,0x89,
	0x86,0x88,0x55,0x88,0x67,0x76,0x77,0x66,0x88,0x55,0x89,
	0x79,0x98,0x9A,0xA7,0x7B,0x83,0x59,0x55,0xA7,0x49,0xA6,
	0x6B,0x96,0x88,0x57,0xC7,0x58,0xA6,0x68,0x77,0x98,0x56,
	0x97,0x68,0x66,0x78,0x85,0x4A,0x95,0x9C,0xA9,0x9B,0x77,
	0xB7,0x46,0x83,0x39,0x95,0x9A,0x56,0xA8,0x7A,0x96,0x7A,
	0x74,0x89,0x56,0xA8,0x79,0x97,0x79,0x65,0x77,0x66,0x88,
	0x41,0x59,0x69,0xCB,0xA8,0xBA,0x78,0x86,0x67,0x43,0x98,
	0x46,0xB9,0x69,0xA9,0x79,0x77,0x98,0x56,0x97,0x46,0x98,
	0x57,0x88,0xA8,0x7A,0x95,0x57,0x86,0x32,0xBA,0x4A,0xCA,
	0x99,0xBA,0x88,0x88,0x75,0x45,0x87,0x45,0xA8,0x68,0xA9,
	0x9A,0x9A,0xA7,0x68,0x63,0x36,0x75,0x47,0x98,0x89,0xBB,
	0x87,0x88,0x66,0x45,0xB3,0x3A,0xA9,0x9B,0xB8,0x68,0xB8,
	0x58,0x77,0x54,0x58,0x95,0x7A,0xA7,0x9B,0xBA,0x68,0x86,
	0x45,0x75,0x44,0x69,0x66,0x8A,0x98,0x9B,0x96,0x87,0x46,
	0x93,0x49,0x95,0x9B,0xB7,0x7B,0xA4,0x5A,0x75,0x57,0x56,
	0x66,0x8A,0x85,0x8C,0xA6,0x9C,0xA6,0x68,0x73,0x36,0x63,
	0x46,0xA7,0x48,0xB9,0x79,0xA7,0x79,0x67,0xA6,0x59,0xB4,
	0x59,0xA6,0x5B,0xB6,0x2B,0xB5,0x49,0x97,0x67,0x98,0x66,
	0xAC,0xA8,0xAB,0x95,0x79,0x74,0x58,0x84,0x49,0xA4,0x48,
	0x96,0x59,0xA7,0x69,0xA7,0x69,0xB9,0x6A,0x97,0x68,0x86,
	0x79,0x96,0x6A,0x84,0x6A,0x73,0x59,0x85,0x69,0x86,0x7A,
	0x96,0x7A,0xA8,0x87,0x98,0x66,0x87,0x57,0x86,0x55,0x66,
	0x66,0x89,0x87,0x99,0x78,0x98,0x88,0x78,0x88,0x88,0x88,
	0x78,0x87,0x66,0x67,0x78,0x76,0x77,0x78,0x87,0x78,0x86,
	0x78,0x88,0x88,0x87,0x77,0x78,0x77,0x89,0x88,0x87,0x76,
	0x78,0x76,0x77,0x77,0x77,0x78,0x98,0x87,0x77,0x77,0x88,
	0x88,0x88,0x89,0x88,0x88,0x77,0x88,0x88,0x87,0x66,0x67,
	0x77,0x77,0x77,0x88,0x77,0x77,0x77,0x88,0x78,0x87,0x78,
	0x87,0x88,0x78,0x87,0x88,0x77,0x77,0x77,0x77,0x66,0x77,
	0x88,0x88,0x98,0x88,0x88,0x78,0x88,0x76,0x78,0x67,0x77,
	0x77,0x77,0x88,0x77,0x77,0x77,0x78,0x78,0x88,0x88,0x88,
	0x87,0x78,0x87,0x78,0x77,0x78,0x78,0x77,0x67,0x87,0x89,
	0x98,0x87,0x87,0x77,0x76,0x77,0x77,0x67,0x87,0x77,0x77,
	0x77,0x88,0x89,0x88,0x87,0x78,0x88,0x98,0x88,0x67,0x77,
	0x78,0x88,0x76,0x76,0x78,0x88,0x88,0x88,0x77,0x77,0x76,
	0x78,0x88,0x87,0x76,0x68,0x77,0x88,0x88,0x87,0x77,0x77,
	0x78,0x88,0x88,0x87,0x77,0x77,0x77,0x77,0x77,0x77,0x76,
	0x78,0x87,0x88,0x77,0x78,0x77,0x78,0x88,0x77,0x77,0x87,
	0x88,0x88,0x88,0x77,0x87,0x77,0x88,0x78,0x88,0x88,0x87,
	0x88,0x77,0x77,0x78,0x88,0x78,0x77,0x78,0x88,0x77,0x87,
	0x77,0x77,0x77,0x87,0x77,0x78,0x87,0x78,0x88,0x88,0x88,
	0x78,0x88,0x77,0x87,0x78,0x87,0x78,0x87,0x77,0x77,0x87,
	0x77,0x88,0x89,0x88,0x87,0x77,0x77,0x78,0x88,0x87,0x77,
	0x76,0x77,0x68,0x87,0x78,0x88,0x77,0x78,0x88,0x88,0x77,
	0x77,0x77,0x78,0x87,0x77,0x77,0x78,0x77,0x88,0x87,0x78,
	0x87,0x77,0x77,0x88,0x89,0x87,0x77,0x66,0x77,0x77,0x78,
	0x76,0x77,0x77,0x88,0x88,0x87,0x67,0x88,0x88,0x88,0x87,
	0x77,0x67,0x77,0x78,0x88,0x88,0x76,0x67,0x77,0x88,0x88,
	0x87,0x77,0x77,0x77,0x87,0x77,0x77,0x67,0x77,0x78,0x87,
	0x77,0x77,0x77,0x88,0x88,0x88,0x77,0x88,0x78,0x88,0x77,
	0x77,0x77,0x77,0x87,0x78,0x77,0x78,0x87,0x88,0x88,0x88,
	0x77,0x77,0x88,0x88,0x88,0x77,0x77,0x77,0x78,0x77,0x88,
	0x88,0x77,0x88,0x78,0x88,0x77,0x87,0x67,0x87,0x78,0x87,
	0x77,0x78,0x77,0x87,0x88,0x78,0x87,0x77,0x88,0x78,0x98,
	0x78,0x76,0x78,0x77,0x87,0x77,0x77,0x77,0x88,0x78,0x87,
	0x78,0x87,0x78,0x87,0x78,0x76,0x77,0x78,0x87,0x89,0x87,
	0x77,0x77,0x78,0x88,0x87,0x77,0x76,0x78,0x87,0x88,0x77,
	0x77,0x76,0x78,0x87,0x78,0x77,0x78,0x88,0x88,0x87,0x77,
	0x77,0x77,0x88,0x88,0x88,0x77,0x78,0x78,0x88,0x87,0x77,
	0x77,0x88,0x78,0x88,0x88,0x87,0x77,0x77,0x78,0x77,0x87,
	0x77,0x78,0x77,0x78,0x77,0x87,0x77,0x88,0x88,0x87,0x77,
	0x87,0x88,0x88,0x87,0x67,0x76,0x77,0x78,0x88,0x77,0x87,
	0x77,0x87,0x77,0x87,0x77,0x87,0x77,0x77,0x77,0x88,0x77,
	0x87,0x77,0x77,0x77,0x78,0x77,0x88,0x78,0x98,0x78,0x76,
	0x77,0x77,0x78,0x88,0x77,0x77,0x76,0x77,0x78,0x88,0x77,
	0x77,0x77,0x88,0x88,0x88,0x88,0x87,0x77,0x77,0x77,0x77,
	0x78,0x88,0x78,0x88,0x78,0x87,0x78,0x87,0x77,0x88,0x87,
	0x77,0x88,0x88,0x87,0x77,0x88,0x77,0x88,0x77,0x87,0x77,
	0x88,0x88,0x88,0x87,0x77,0x77,0x77,0x77,0x87,0x88,0x87,
	0x78,0x87,0x88,0x87,0x78,0x87,0x78,0x77,0x77,0x77,0x88,
	0x88,0x77,0x77,0x76,0x78,0x78,0x88,0x78,0x88,0x78,0x87,
	0x77,0x88,0x78,0x77,0x77,0x77,0x78,0x88,0x77,0x77,0x78,
	0x87,0x87,0x78,0x77,0x78,0x77,0x87,0x77,0x87,0x77,0x87,
	0x87,0x88,0x78,0x87,0x88,0x88,0x88,0x88,0x77,0x67,0x77,
	0x88,0x88,0x88,0x77,0x78,0x77,0x87,0x88,0x87,0x88,0x77,
	0x78,0x88,0x77,0x87,0x67,0x87,0x78,0x77,0x77,0x78,0x87,
	0x88,0x87,0x89,0x77,0x77,0x77,0x87,0x88,0x87,0x66,0x77,
	0x78,0x87,0x88,0x87,0x77,0x77,0x88,0x88,0x87,0x77,0x77,
	0x87,0x77,0x77,0x78,0x77,0x77,0x78,0x88,0x88,0x77,0x77,
	0x68,0x87,0x88,0x77,0x88,0x77,0x77,0x87,0x77,0x77,0x77,
	0x87,0x78,0x88,0x77,0x77,0x78,0x77,0x78,0x78,0x87,0x77,
	0x87,0x78,0x88,0x87,0x77,0x78,0x88,0x77,0x88,0x87,0x88,
	0x88,0x88,0x78,0x87,0x77,0x77,0x78,0x88,0x88,0x77,0x77,
	0x77,0x88,0x88,0x87,0x77,0x77,0x88,0x88,0x87,0x77,0x77,
	0x78,0x88,0x77,0x77,0x78,0x88,0x78,0x88,0x78,0x87,0x77,
	0x77,0x77,0x78,0x77,0x77,0x88,0x77,0x78,0x77,0x77,0x77,
	0x88,0x87,0x77,0x77,0x78,0x88,0x88,0x87,0x77,0x77,0x77,
	0x78,0x88,0x87,0x78,0x77,0x77,0x77,0x88,0x76,0x78,0x78,
	0x97,0x78,0x76,0x88,0x88,0x98,0x88,0x87,0x88,0x87,0x77,
	0x77,0x78,0x77,0x88,0x88,0x77,0x87,0x79,0x89,0x87,0x87,
	0x68,0xA8,0x89,0x54,0x55,0x68,0xB9,0x89,0x77,0x9A,0x99,
	0x86,0x57,0x66,0x88,0x77,0x88,0x9A,0x96,0x46,0x56,0x89,
	0xB9,0x99,0x56,0x98,0x77,0x42,0x46,0x7A,0xCD,0x98,0x65,
	0x78,0x87,0x78,0x66,0x78,0x88,0x87,0x78,0x89,0x85,0x46,
	0x58,0x9C,0x98,0xA5,0x46,0x76,0x55,0x44,0x7C,0xBC,0xD9,
	0x66,0x64,0x79,0x78,0xA7,0x66,0x67,0x77,0x78,0x99,0x83,
	0x46,0x59,0xDF,0xA9,0x86,0x34,0x62,0x36,0x58,0xCA,0xAA,
	0x97,0x46,0x66,0x8A,0xAA,0x88,0x66,0x77,0x78,0x89,0x98,
	0x54,0x66,0x8D,0xEA,0x98,0x65,0x45,0x42,0x67,0x9C,0xBA,
	0x88,0x85,0x66,0x59,0xAA,0x99,0x86,0x77,0x55,0x77,0x99,
	0x84,0x56,0x5A,0xEC,0x87,0x86,0x24,0x51,0x39,0xBA,0xAB,
	0x98,0x85,0x35,0x69,0xAB,0x97,0x88,0x87,0x55,0x78,0x99,
	0x85,0x38,0x89,0xBD,0x98,0x99,0x52,0x43,0x39,0xB8,0x7A,
	0xA8,0x96,0x35,0x8A,0xA9,0x99,0xA9,0x75,0x46,0x89,0x97,
	0x66,0x45,0x68,0x8C,0xD9,0x89,0x61,0x36,0x46,0x79,0x8A,
	0xC9,0x76,0x57,0x78,0x78,0xAC,0xA9,0x87,0x67,0x78,0x77,
	0x88,0x44,0x67,0x9A,0xBB,0xAA,0x94,0x05,0x56,0x67,0x87,
	0xDB,0x86,0x89,0x67,0x76,0x9C,0xB8,0x66,0x87,0x67,0x68,
	0x99,0x42,0x69,0xA7,0xAD,0xD9,0xA5,0x05,0x73,0x14,0x79,
	0xDB,0x67,0xBB,0x44,0x78,0x9A,0x76,0x9A,0x85,0x78,0x88,
	0x86,0x36,0x98,0x78,0xAD,0x98,0xA4,0x36,0x62,0x27,0x88,
	0xBA,0x9A,0xC9,0x58,0x87,0x67,0x78,0x88,0x67,0x88,0x79,
	0x63,0x69,0x76,0xBB,0xD4,0x9A,0x24,0x85,0x13,0x72,0x49,
	0xA8,0xAE,0x78,0xBB,0x65,0x76,0x67,0x87,0x8A,0x87,0xA5,
	0x27,0x96,0x8C,0xD9,0x3C,0xA2,0x69,0x51,0x86,0x24,0xA7,
	0x5A,0xB8,0x8D,0xD6,0x6A,0x84,0x77,0x57,0x87,0x6B,0xA2,
	0x4A,0xA4,0xAC,0xE6,0x7D,0x71,0x89,0x14,0x85,0x17,0xB6,
	0x6C,0xB5,0x9E,0xC7,0x8E,0x74,0x66,0x55,0x66,0x7A,0x93,
	0x4A,0xC5,0x8C,0xD6,0x3C,0xB4,0x3A,0x64,0x54,0x36,0xA5,
	0x6A,0xC6,0x6C,0xD9,0x5B,0xC5,0x46,0x74,0x35,0x68,0x87,
	0x66,0x9B,0x49,0xBC,0x83,0xAB,0x42,0x98,0x44,0x65,0x68,
	0x45,0xAC,0x69,0xDD,0x95,0xAC,0x64,0xAA,0x43,0x56,0x68,
	0x88,0x65,0xB8,0x6A,0xAB,0x58,0xD7,0x17,0xB4,0x26,0x75,
	0x75,0x48,0xB7,0x7C,0xCC,0x97,0xEA,0x47,0xA6,0x32,0x86,
	0x56,0xAB,0x63,0xCC,0x5A,0xCD,0x65,0xC9,0x17,0xB4,0x35,
	0x73,0x66,0x57,0x89,0x5A,0xDB,0x97,0xDB,0x56,0x96,0x32,
	0x68,0x66,0x9B,0x94,0x39,0xB4,0x7B,0xD7,0x2C,0xA4,0x49,
	0x92,0x49,0x37,0x66,0x87,0xC4,0x9D,0xB9,0x6B,0xD6,0x49,
	0x94,0x26,0x66,0x36,0xAA,0x53,0x5D,0xB5,0xAB,0xD4,0x5C,
	0x92,0x1C,0x91,0x69,0x46,0x69,0x67,0x84,0xAC,0x9A,0x9B,
	0xD9,0x69,0x94,0x24,0x65,0x45,0xA9,0xA8,0x66,0xBA,0x39,
	0xAB,0x65,0xB9,0x31,0xAB,0x24,0xC8,0x64,0x87,0x27,0x89,
	0xD9,0xCA,0xAD,0x87,0x66,0x43,0x45,0x85,0x78,0x9A,0x99,
	0x53,0xAC,0x39,0x99,0x95,0x98,0x93,0x8C,0x31,0x88,0x43,
	0x8C,0x65,0x8B,0xA8,0xB9,0xBC,0xBA,0x65,0x76,0x44,0x66,
	0x66,0x67,0x89,0x96,0x36,0xCB,0x59,0xAA,0x77,0x84,0x66,
	0xCA,0x26,0x66,0x64,0x68,0x68,0x9A,0x78,0xCC,0xBB,0xBB,
	0x87,0x75,0x43,0x55,0x45,0x78,0x89,0x9A,0x98,0x55,0x78,
	0x79,0xBA,0x67,0x76,0x76,0x78,0x76,0x78,0x88,0x89,0x98,
	0x88,0x88,0x86,0x68,0x76,0x88,0x98,0x99,0x77,0x75,0x56,
	0x66,0x88,0x77,0x76,0x76,0x88,0x87,0x77,0x78,0x89,0xA9,
	0x9A,0x98,0x77,0x76,0x66,0x76,0x89,0x87,0x67,0x67,0x88,
	0x77,0x98,0x88,0x88,0x87,0x77,0x77,0x67,0x76,0x67,0x88,
	0x88,0x76,0x66,0x67,0x78,0x88,0x9A,0x9A,0x98,0x86,0x76,
	0x78,0x89,0x77,0x87,0x66,0x77,0x87,0x66,0x67,0x77,0x79,
	0x98,0x87,0x77,0x87,0x76,0x68,0x97,0x78,0x87,0x67,0x77,
	0x77,0x88,0x99,0x99,0x99,0x99,0x87,0x77,0x76,0x66,0x88,
	0x78,0x86,0x67,0x88,0x67,0x88,0x66,0x77,0x77,0x87,0x78,
	0x88,0x87,0x77,0x88,0x88,0x88,0x76,0x67,0x66,0x77,0x87,
	0x89,0x87,0x99,0x99,0x89,0x86,0x77,0x67,0x86,0x78,0x76,
	0x67,0x76,0x68,0x77,0x78,0x88,0x77,0x77,0x88,0x88,0x98,
	0x99,0x76,0x68,0x76,0x68,0x76,0x68,0x87,0x78,0x88,0x89,
	0x87,0x78,0x78,0x99,0x98,0x87,0x66,0x66,0x67,0x77,0x78,
	0x87,0x77,0x77,0x88,0x78,0x88,0x87,0x88,0x78,0x88,0x88,
	0x88,0x77,0x77,0x76,0x89,0x88,0x77,0x77,0x78,0x87,0x88,
	0x88,0x88,0x88,0x88,0x98,0x78,0x86,0x65,0x77,0x78,0x98,
	0x77,0x77,0x66,0x78,0x88,0x99,0x88,0x87,0x77,0x78,0x88,
	0x88,0x88,0x87,0x78,0x76,0x76,0x67,0x77,0x78,0x88,0x98,
	0x88,0x88,0x78,0x87,0x78,0x98,0x78,0x77,0x66,0x76,0x66,
	0x67,0x78,0x87,0x78,0x88,0x87,0x68,0x87,0x78,0x98,0x88,
	0x87,0x89,0x87,0x77,0x67,0x77,0x77,0x76,0x77,0x77,0x77,
	0x77,0x88,0x89,0x98,0x89,0x87,0x77,0x87,0x66,0x77,0x77,
	0x78,0x87,0x77,0x77,0x87,0x78,0x77,0x88,0x88,0x88,0x98,
	0x78,0x87,0x88,0x88,0x88,0x77,0x76,0x78,0x87,0x78,0x76,
	0x88,0x78,0x88,0x89,0x86,0x78,0x77,0x89,0x87,0x88,0x76,
	0x57,0x76,0x76,0x77,0x68,0x66,0x87,0x89,0x99,0x99,0x98,
	0x86,0x67,0x55,0x67,0x77,0x79,0x88,0x89,0x98,0x99,0x87,
	0x68,0x66,0x66,0x78,0x89,0x89,0x97,0x87,0x77,0x87,0x77,
	0x89,0x67,0x65,0x75,0x77,0x78,0x88,0x66,0x88,0xAA,0xAB,
	0xA9,0x96,0x54,0x35,0x35,0x77,0xA8,0x8A,0x8B,0x88,0x97,
	0x66,0x55,0x57,0x87,0x88,0x89,0x89,0x99,0xA8,0x66,0x67,
	0x77,0x77,0xAA,0x68,0x84,0x65,0x57,0x57,0x99,0x84,0x9A,
	0x9A,0xBC,0xCA,0x96,0x54,0x23,0x33,0x57,0x9B,0x9B,0xBA,
	0xA8,0x76,0x55,0x55,0x67,0x88,0x9B,0x9A,0xAA,0xA8,0x89,
	0x64,0x44,0x67,0x88,0x9C,0xC7,0x75,0x45,0x45,0x55,0x88,
	0x99,0x7A,0xA9,0xDB,0xAA,0x87,0x54,0x42,0x35,0x57,0x88,
	0xAB,0xCA,0x99,0x76,0x65,0x55,0x67,0x88,0x78,0x97,0x89,
	0x9A,0x99,0x99,0x74,0x44,0x57,0x89,0x8B,0xC9,0xA7,0x36,
	0x66,0x65,0x78,0x98,0x69,0x98,0xBC,0xBB,0x97,0x64,0x42,
	0x35,0x68,0xA9,0xAA,0xA9,0x98,0x66,0x64,0x55,0x76,0x69,
	0xA9,0x99,0x99,0x89,0x87,0x78,0x97,0x45,0x56,0x88,0x89,
	0xAC,0xA9,0x84,0x46,0x24,0x47,0x98,0xA7,0x7A,0x79,0xBA,
	0xBA,0x97,0x54,0x32,0x44,0x79,0x99,0xAB,0xA9,0x96,0x66,
	0x55,0x56,0x78,0xAA,0x99,0x99,0x99,0x89,0x98,0x87,0x76,
	0x65,0x56,0x67,0x78,0x89,0xAB,0x77,0x53,0x53,0x45,0x6A,
	0x9A,0xA7,0x99,0x9A,0x9A,0xA9,0x86,0x65,0x34,0x44,0x78,
	0xAA,0xAC,0xA8,0x87,0x76,0x56,0x67,0x88,0x87,0x9A,0x99,
	0x99,0x88,0x87,0x76,0x66,0x66,0x57,0x66,0x88,0x88,0xAB,
	0x98,0x84,0x56,0x45,0x78,0x98,0xA8,0x8A,0x89,0xAA,0xAA,
	0x86,0x55,0x33,0x54,0x68,0x8A,0x9A,0xA8,0x98,0x66,0x66,
	0x67,0x78,0x99,0x89,0x87,0x67,0x88,0x88,0x77,0x87,0x88,
	0x97,0x56,0x56,0x78,0x88,0xAC,0x88,0x64,0x65,0x45,0x57,
	0x89,0x97,0x9A,0x9B,0xCA,0xA9,0x75,0x44,0x13,0x55,0x8A,
	0xCC,0xBB,0x98,0x86,0x67,0x66,0x66,0x77,0x88,0x98,0x67,
	0x99,0x99,0x98,0x87,0x77,0x77,0x76,0x55,0x57,0x88,0x9A,
	0xCC,0x98,0x73,0x34,0x24,0x69,0x9A,0xB9,0x8B,0x99,0xA9,
	0x88,0x76,0x55,0x45,0x77,0x9B,0xAA,0x89,0x75,0x65,0x66,
	0x68,0x78,0x87,0x88,0x77,0x88,0x78,0x99,0x88,0x76,0x66,
	0x77,0x88,0x87,0x56,0x67,0x89,0x89,0xBB,0x97,0x52,0x45,
	0x45,0x7B,0xBA,0xA7,0x8A,0x9A,0xB9,0x87,0x64,0x33,0x34,
	0x79,0xAA,0xAB,0x99,0x96,0x77,0x65,0x45,0x46,0x99,0xAB,
	0x98,0x87,0x87,0x87,0x77,0x67,0x66,0x78,0x88,0x99,0x97,
	0x55,0x55,0x79,0x8B,0xDB,0x97,0x52,0x45,0x45,0x8B,0x97,
	0x86,0x8A,0xAB,0xA9,0x75,0x43,0x36,0x79,0xBA,0x98,0x86,
	0x47,0x76,0x98,0x65,0x77,0x79,0xA9,0x87,0x65,0x67,0x89,
	0xA9,0x88,0x87,0x88,0x87,0x66,0x66,0x67,0x65,0x78,0x78,
	0x8A,0xCA,0xA7,0x34,0x35,0x56,0x99,0xB7,0x68,0x79,0xBB,
	0xA7,0x74,0x26,0x68,0xBB,0xA8,0x65,0x35,0x77,0x98,0x76,
	0x55,0x58,0xBB,0xBA,0x75,0x45,0x69,0xA9,0x97,0x64,0x67,
	0x78,0x87,0x66,0x77,0x68,0x86,0x65,0x47,0x78,0x9A,0xDC,
	0x99,0x42,0x42,0x47,0xAA,0x9A,0x77,0xBB,0xBB,0x96,0x13,
	0x34,0x9D,0xBA,0x87,0x45,0x87,0x89,0x85,0x45,0x57,0xBB,
	0x99,0x85,0x59,0x98,0xA9,0x76,0x77,0x78,0x96,0x67,0x88,
	0x9A,0x87,0x76,0x66,0x79,0x89,0x63,0x67,0x79,0xCF,0xA9,
	0x83,0x06,0x66,0xB9,0x73,0x78,0x5B,0xEC,0x74,0x62,0x5B,
	0xBC,0xCA,0x44,0xA8,0x69,0x75,0x36,0x88,0xAC,0x96,0x66,
	0x47,0xBB,0x99,0x86,0x67,0x75,0x76,0x67,0x9A,0x89,0x86,
	0x57,0x76,0x77,0x67,0x88,0x89,0x98,0x86,0x46,0x67,0x9D,
	0xA9,0x98,0x22,0x97,0x79,0x97,0x5C,0xB9,0xB9,0x64,0x36,
	0x78,0xA9,0x76,0x97,0x7A,0x65,0x56,0x97,0xBC,0x76,0x55,
	0x45,0x87,0x78,0xBA,0xAC,0x85,0x55,0x45,0x78,0x69,0xB9,
	0x89,0x85,0x66,0x77,0x78,0x77,0x87,0x78,0x87,0x86,0x37,
	0x77,0x9E,0xA6,0x47,0x70,0x8A,0x46,0x9C,0x87,0xD6,0x6A,
	0x85,0x49,0x75,0x9C,0x97,0xA9,0x45,0x74,0x27,0xA9,0x8B,
	0x95,0x68,0x64,0x67,0x68,0xAA,0x89,0x85,0x67,0x75,0x79,
	0x89,0xB9,0x65,0x64,0x58,0x99,0x9A,0x87,0x77,0x55,0x87,
	0x77,0x77,0x46,0x89,0x9B,0xD9,0x57,0xA5,0x17,0x85,0x8D,
	0xB6,0x8B,0xA6,0x66,0x35,0x9B,0x99,0xB9,0x77,0x62,0x16,
	0x88,0x9A,0x97,0x9B,0x95,0x45,0x67,0x89,0x88,0xBB,0x87,
	0x66,0x67,0x86,0x57,0x99,0x88,0x76,0x78,0x75,0x67,0x89,
	0xA8,0x78,0x98,0x78,0x87,0x78,0x86,0x45,0x7B,0x89,0xC8,
	0x7B,0x92,0x27,0x95,0x7A,0x77,0xCE,0x72,0x67,0x75,0x87,
	0x6A,0xCA,0x78,0x87,0x67,0x64,0x6A,0xA6,0x58,0x87,0x79,
	0x76,0x89,0x66,0x78,0x88,0x97,0x68,0x97,0x68,0x86,0x78,
	0x87,0x99,0x97,0x78,0x77,0x89,0x88,0x88,0x76,0x77,0x89,
	0x66,0x76,0x88,0x69,0xA7,0x89,0x53,0x6A,0x75,0x89,0x88,
	0x88,0x78,0xB9,0x57,0x89,0x88,0x87,0x67,0x63,0x47,0x76,
	0x68,0xA9,0x99,0x77,0x77,0x66,0x78,0x99,0x87,0x79,0x87,
	0x77,0x87,0x77,0x77,0x78,0x76,0x68,0x89,0x87,0x87,0x77,
	0x78,0x88,0x77,0x77,0x77,0x78,0x88,0x77,0x79,0x96,0x77,
	0x66,0x87,0x57,0xA8,0x67,0x99,0x89,0x98,0x76,0x67,0x78,
	0x77,0x78,0x87,0x77,0x77,0x77,0x77,0x78,0x77,0x78,0x88,
	0x99,0x88,0x77,0x88,0x87,0x89,0x88,0x88,0x77,0x87,0x78,
	0x88,0x87,0x77,0x78,0x77,0x77,0x77,0x88,0x88,0x98,0x88,
	0x87,0x66,0x77,0x77,0x88,0x88,0x98,0x78,0x87,0x66,0x66,
	0x77,0x87,0x89,0x89,0x87,0x87,0x77,0x77,0x77,0x77,0x87,
	0x78,0x87,0x87,0x76,0x67,0x78,0x88,0x89,0x87,0x77,0x77,
	0x77,0x88,0x88,0x77,0x88,0x77,0x87,0x78,0x87,0x78,0x88,
	0x77,0x66,0x77,0x89,0x99,0x99,0x77,0x66,0x67,0x67,0x77,
	0x87,0x87,0x78,0x86,0x78,0x76,0x89,0x77,0x98,0x78,0x88,
	0x68,0x87,0x77,0x77,0x78,0x88,0x88,0x87,0x67,0x77,0x78,
	0x88,0x88,0x88,0x77,0x77,0x76,0x77,0x88,0x89,0x88,0x77,
	0x67,0x77,0x78,0x78,0x78,0x87,0x88,0x76,0x66,0x77,0x78,
	0x99,0x88,0x87,0x77,0x77,0x65,0x78,0x77,0x88,0x88,0x98,
	0x77,0x77,0x77,0x67,0x87,0x77,0x77,0x78,0x87,0x77,0x77,
	0x88,0x78,0x88,0x87,0x77,0x67,0x66,0x77,0x89,0x98,0x77,
	0x76,0x67,0x77,0x88,0x88,0x99,0x88,0x87,0x67,0x76,0x67,
	0x77,0x88,0x98,0x88,0x77,0x77,0x67,0x88,0x77,0x77,0x77,
	0x87,0x88,0x88,0x88,0x77,0x98,0x78,0x87,0x77,0x77,0x78,
	0x87,0x88,0x87,0x78,0x77,0x88,0x87,0x88,0x87,0x77,0x76,
	0x67,0x88,0x88,0x88,0x78,0x77,0x78,0x88,0x88,0x88,0x87,
	0x78,0x88,0x87,0x67,0x88,0x77,0x77,0x78,0x87,0x89,0x87,
	0x88,0x77,0x87,0x57,0x77,0x79,0x98,0x88,0x76,0x78,0x87,
	0x88,0x77,0x87,0x67,0x87,0x67,0x88,0x79,0x97,0x78,0x77,
	0x77,0x77,0x88,0x78,0x88,0x67,0x87,0x67,0x98,0x77,0x87,
	0x67,0x78,0x78,0x88,0x87,0x67,0x77,0x78,0x87,0x78,0x88,
	0x88,0x98,0x87,0x67,0x66,0x78,0x97,0x77,0x77,0x78,0x77,
	0x88,0x88,0x87,0x68,0x88,0x78,0x87,0x77,0x66,0x77,0x78,
	0x88,0x88,0x87,0x77,0x77,0x77,0x77,0x87,0x77,0x87,0x78,
	0x87,0x88,0x87,0x88,0x77,0x77,0x77,0x77,0x78,0x88,0x77,
	0x88,0x87,0x68,0x76,0x88,0x77,0x78,0x77,0x78,0x87,0x88,
	0x78,0x88,0x88,0x87,0x77,0x77,0x78,0x87,0x77,0x66,0x77,
	0x78,0x88,0x88,0x88,0x78,0x87,0x78,0x76,0x77,0x66,0x78,
	0x88,0xA9,0x87,0x77,0x67,0x76,0x77,0x77,0x78,0x87,0x89,
	0x87,0x78,0x77,0x77,0x77,0x88,0x77,0x88,0x88,0x88,0x88,
	0x87,0x77,0x77,0x77,0x77,0x88,0x88,0x78,0x77,0x77,0x77,
	0x78,0x87,0x88,0x88,0x87,0x88,0x77,0x89,0x87,0x88,0x76,
	0x77,0x77,0x88,0x88,0x87,0x77,0x87,0x78,0x77,0x78,0x87,
	0x78,0x88,0x88,0x77,0x88,0x78,0x87,0x77,0x77,0x78,0x87,
	0x88,0x77,0x77,0x67,0x87,0x78,0x88,0x88,0x77,0x88,0x77,
	0x77,0x67,0x87,0x88,0x88,0x77,0x87,0x77,0x77,0x78,0x67,
	0x88,0x77,0x88,0x77,0x98,0x77,0x87,0x67,0x67,0x88,0x78,
	0x98,0x77,0x88,0x78,0x86,0x77,0x77,0x78,0x88,0x88,0x77,
	0x88,0x78,0x87,0x77,0x77,0x78,0x88,0x88,0x87,0x77,0x77,
	0x78,0x88,0x88,0x88,0x77,0x77,0x87,0x77,0x88,0x78,0x88,
	0x77,0x87,0x78,0x77,0x78,0x87,0x88,0x87,0x77,0x67,0x78,
	0x77,0x88,0x79,0x98,0x88,0x86,0x78,0x76,0x88,0x77,0x89,
	0x88,0x87,0x77,0x66,0x78,0x77,0x87,0x77,0x76,0x78,0x77,
	0x77,0x77,0x87,0x77,0x87,0x76,0x77,0x78,0x77,0x78,0x77,
	0x77,0x78,0x98,0x77,0x76,0x67,0x66,0x78,0x88,0x88,0x87,
	0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x88,0x88,0x88,0x88,
	0x88,0x88,0x87,0x77,0x77,0x88,0x88,0x88,0x77,0x88,0x78,
	0x88,0x88,0x87,0x88,0x88,0x88,0x77,0x88,0x77,0x78,0x88,
	0x88,0x88,0x88,0x88,0x77,0x77,0x78,0x88,0x88,0x87,0x76,
	0x78,0x77,0x88,0x88,0x88,0x88,0x87,0x66,0x66,0x78,0x88,
	0x88,0x88,0x88,0x88,0x77,0x77,0x66,0x77,0x88,0x88,0x78,
	0x77,0x77,0x78,0x88,0x88,0x88,0x87,0x77,0x76,0x67,0x77,
	0x78,0x88,0x88,0x88,0x77,0x66,0x77,0x78,0x87,0x78,0x77,
	0x78,0x87,0x77,0x77,0x77,0x88,0x87,0x78,0x77,0x78,0x77,
	0x77,0x77,0x77,0x77,0x88,0x77,0x88,0x88,0x88,0x78,0x76,
	0x77,0x77,0x77,0x78,0x88,0x88,0x88,0x77,0x76,0x77,0x77,
	0x88,0x87,0x88,0x77,0x88,0x76,0x77,0x78,0x88,0x78,0x87,
	0x78,0x77,0x88,0x77,0x88,0x77,0x87,0x77,0x88,0x79,0x97,
	0x78,0x77,0x78,0x77,0x88,0x77,0x77,0x77,0x88,0x88,0x88,
	0x88,0x77,0x77,0x77,0x78,0x88,0x88,0x87,0x78,0x77,0x77,
	0x77,0x88,0x88,0x87,0x88,0x77,0x88,0x77,0x88,0x77,0x78,
	0x87,0x88,0x77,0x77,0x77,0x77,0x78,0x87,0x78,0x88,0x78,
	0x88,0x88,0x88,0x77,0x78,0x87,0x77,0x77,0x78,0x88,0x88,
	0x87,0x77,0x78,0x87,0x77,0x87,0x89,0x87,0x78,0x77,0x77,
	0x77,0x88,0x88,0x88,0x88,0x77,0x78,0x77,0x78,0x77,0x88,
	0x78,0x88,0x88,0x77,0x66,0x77,0x78,0x88,0x87,0x88,0x77,
	0x78,0x88,0x88,0x88,0x78,0x77,0x77,0x77,0x77,0x77,0x88,
	0x88,0x88,0x77,0x77,0x77,0x88,0x88,0x88,0x77,0x87,0x77,
	0x77,0x88,0x87,0x87,0x77,0x77,0x77,0x88,0x77,0x78,0x77,
	0x77,0x87,0x89,0x88,0x77,0x77,0x67,0x77,0x88,0x87,0x77,
	0x78,0x88,0x87,0x88,0x77,0x77,0x77,0x87,0x77,0x68,0x88,
	0x88,0x88,0x87,0x78,0x87,0x89,0x87,0x78,0x76,0x67,0x87,
	0x78,0x78,0x88,0x88,0x87,0x78,0x87,0x77,0x76,0x67,0x77,
	0x88,0x89,0x88,0x88,0x77,0x78,0x87,0x78,0x77,0x77,0x77,
	0x78,0x77,0x78,0x88,0x88,0x78,0x88,0x87,0x77,0x77,0x77,
	0x77,0x77,0x78,0x89,0x88,0x77,0x77,0x77,0x88,0x77,0x78,
	0x88,0x87,0x77,0x77,0x77,0x78,0x88,0x77,0x87,0x67,0x77,
	0x78,0x87,0x78,0x87,0x78,0x78,0x87,0x78,0x77,0x78,0x77,
	0x88,0x87,0x77,0x77,0x87,0x77,0x87,0x88,0x78,0x88,0x77,
	0x87,0x77,0x87,0x88,0x87,0x87,0x77,0x77,0x88,0x78,0x88,
	0x77,0x78,0x78,0x87,0x78,0x87,0x89,0x88,0x88,0x76,0x67,
	0x77,0x88,0x78,0x77,0x87,0x77,0x88,0x78,0x87,0x88,0x78,
	0x78,0x78,0x78,0x78,0x78,0x78,0x88,0x88,0x78,0x78,0x88,
	0x78,
};