uniform float xmul;

uniform sampler2D tex;

void main()
{
	vec2 tcoords = gl_TexCoord[0].st;
	vec2 tcblur;

	const float n = 15.0;
	const float nhalf = n / 2.0;

	vec4 color_sum = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 tex_color;

	for (float i=0.0; i<=n; i++)
	{
		float si = xmul * i;

		tcblur.s = tcoords.s + si;
		tcblur.y = tcoords.t;

		tex_color = texture2D(tex, tcblur);

		color_sum.r = color_sum.r + tex_color.r;
		color_sum.g = color_sum.g + tex_color.g;
		color_sum.b = color_sum.b + tex_color.b;
		color_sum.a = color_sum.a + tex_color.a;
	}

	vec4 color;
	color.r = color_sum.r / n;
	color.g = color_sum.g / n;
	color.b = color_sum.b / n;
	color.a = color_sum.a / n;

	gl_FragColor = color;
}
