varying vec3 coord;
uniform float ptimer;

void main()
{
	float t = ptimer / 256.0;

	float x = coord.x;
	float y = coord.y;

	const float rad = 64.0;
	float z = (rad*rad + x*x + y*y) / 24.0;

	float testx = sin(t / 7.0) * 8.0;
	float testy = cos(t / 11.0) * 8.0;

	float u = ((x*testx) / z) * rad;
	float v = ((y*testy) / z) * rad;

	float sn = 0.0;
	const float n = 4.0;

	for (float i=1.0; i<=n; i++)
		sn = sn + (sin((u + t) / (4.0 / i)) * (1.0 / i) + sin((v + 2.0 * t) / (6.0 / i)) * (1.25 / i) + sin((u + v + 2.5 * t) / (12.0 / i)) * (1.5 / i)) * 0.5;

	float c = mod(sn, 1.0);

	if (c<0.125) c = c * 8.0;
		else if (c<0.25) c = (0.25 - c) * 8.0;
			else c = 0.0;

	float a = (z*z) / (16.0*262144.0);

	float r = (c / 1.0);
	float g = (c / 1.5);
	float b = (0.05 + c * 0.95 * a);

	vec4 color = vec4(r, g, b, a);
	gl_FragColor = color;
}
