uniform float ptimer;

uniform float rmul;
uniform float gmul;
uniform float bmul;
uniform float amul;

uniform float per;


varying vec3 coord;

void main()
{
	float x0 = coord.x * 2.0;
	float y0 = coord.y * 2.0;

	float tt1 = ptimer / 256.0;
	float tt2 = ptimer / 320.0;
	float tt3 = ptimer / 3144.0;

	float rad = pow(x0,2.0) + pow(y0,2.0);
	float angle = atan(y0, x0);

	float ang0 = angle * 7.0;

	float angg = sin((angle + tt3) * 3.0) * per + (1.0 - per) * 1.0;
	if (angg > 1.0) angg = 2.0 - angg;
	if (angg < 0.0) angg = 0.0;

	float angmorph = sin(ang0 + tt1)*1.425 + sin(ang0 + 1.5 * tt2)*0.925 - 1.85;
	float rad0 = rad  + angmorph;
	if (rad0 > 1.0) rad0 = 2.5 - rad0;
	if (rad0 < 0.0) rad0 = 0.0;

	float r = rmul * rad0 * angg;
	float g = gmul * rad0 * angg;
	float b = bmul * rad0 * angg;
	float a = amul * rad0 * angg;

	vec4 color = vec4(r, g, b, a);
	gl_FragColor = color;
}
