uniform float ribanim;

varying vec3 vcoord;
varying float vcol;

void main()
{
	vec4 v = vec4(gl_Vertex);

	float t = ribanim;
	if (t > 256.0) t = 256.0;
	float tz = v.y * t;
	float yy = v.y;

	const float dax = 0.5;
	const float day = 0.4;
	const float daz = 1.0;

	float rr1 = 128.0 * ribanim;
	float rr2 = 96.0 * ribanim;
	float rr3 = 256.0 * ribanim;

	float sinx = v.x + (sin((tz + rr1)/68.0) * 56.0 + sin(tz/44.0) * 44.0 + sin((tz + rr3)/56.0) * 32.0) * dax;
	float siny = (sin((tz + rr1)/32.0) * 24.0 + sin((tz + rr2)/28.0) * 36.0 + sin(tz/80.0) * 44.0) * day;
	float sinz = (sin(tz/64.0) * 42.0 + sin(tz/92.0) * 88.0 + sin((tz + rr3)/60.0) * 28.0) * daz;

	v.x = sinx;
	v.y = siny;
	v.z = sinz;

	gl_Position = gl_ModelViewProjectionMatrix * v;
	vcoord = vec3(v);

	vcol = sin(yy / 16.0); // + sin(v.x * v.y * v.z);
	if (vcol<0.25) vcol = 0.25;
	if (vcol>1.0) vcol = 1.0;
}
