uniform float ptimer;
varying vec3 vcoord;

void main()
{
	vec4 v = vec4(gl_Vertex);

	const float nh = 4.0;

	float t = ptimer / 8.0;
	float vx = v.x;
	float vtx = sin(t/64.0) * 24.0;
	float vz = v.z - t;

	float h = 0.0;
	for (float n=1.0; n<nh; n++)
		h = h + sin((vx + vtx + vz) / (224.0 / n)) * (64.0 / n) + sin((vx + vtx) / (25.0 / n)) * (32.0 / n) + sin(vz / (35.0 / n)) * (18.0 / n) + sin((vx+vtx+vz) / (16.0 / n)) * (24.0 / n) + sin((vx+vtx-vz) / (24.0 / n)) * (20.0 / n);

	v.x = v.x * 1.5;
	v.y = h / 1.5;
	v.z = v.z * 1.5;

	gl_Position = gl_ModelViewProjectionMatrix * v;

	vcoord = vec3(v);
}
