  /*  LIFExx.C,  1D Cellular Automota, Pattern generator.
  
 HISTORY - Take SHELL00.C (From BLOK16),
   write GENLIFE func & bits, -> LIFE10.C, 22.2.92
   Experiment with new params, new ADSCREENS, tidy TITLESCREENS, imp DEMOMODE
    -> LIFE12.C, 17.5.92
   Imp HELPSCREENS. -> LIFE14.C, 18.5.92 (Send WtPC)
   Imp CLRCOL (COLOUR) - set TXT mode colr -> LIFE15.C, 18-19.5.92
  -> LIFE17.C, (6.1992) last old version.
   Tidy up a bit for GPL, remove ads, etc.
  -> LIFE20.C, (6.5.2025)

*/

#include <stdio.h>
#include <dos.h>	/* Defines union REGS, INT86,  */

void helpscreen ();
void syncfly ();

#define Noload 1

int charx = 3;
int chary = 18;
int topy = 2;		/* Top of board */
int topx = 1;
int diskerror = 0;

int kcmd;		/* Command key hit */
int inkey;
int cmdkey;
int nprint;

int xpos,ypos;		/* General pos */
int temp;
int pickmode1,pickmode2;
int fxmode = 0;

long xtime;

char far *Vdu;		/* Pointer to CGA screen */

#if Noload
  #include "minidat.c"
#else
  char sprites [5000];	/* Sprite data */
#endif

#define Msprite 4900
int Ssize = 216;	/* Sprite size */

#define Beep click();

#define Setink(Ink) getpal(Ink)

  /* GRAPHxx.C Graphics function module for PC's */
  /* Copyright A.Millett, PC Solutions 1990 */
  /* This is a simpler, more economical alternative to using the stuff */
  /* in GRAPHICS.H, when writing CGA code */

/* #include <dos.h>	/* Defines union REGS, INT86.  */
/* char far *Vdu;	/* Pointer to CGA screen */
/* Vdu = 0xb8000000;	/* Pointer to CGA screen */
union REGS inr,outr;	/* Define register access */
char prbuffer [10];	/* Buffer for int-print */
long far *timeptr;

typedef unsigned char BYTE;     /* A convenient new data type */
	/* Color usage is complex - lo = planes to effect, hi= SET/RESET pattern */
	/* for col on black use lo = not (ink), hi = 0 */

int xgamode = 0;	/* Graphic adapter 0 = CGA, 1 = EGA, 2 = VGA.. */

long readtime ()		/* Read 32 bit system clock in 1/18 secs */
{
	timeptr = (long far *) 0x0000046c;
	return ( *timeptr);
}

void pause (int ticks)
{
	long temp = readtime () + ticks;
	while ( readtime () < temp);
}

void graphmode(int mode)	/* Set Screen Graphics mode */
				/* 0=40x25BW,1=40COL,2=80BW,3=80COL */
				/* 4=320x200COL,5=320BW,6=640BW */
{
	inr.x.ax = mode;
	int86 (0x10,&inr,&outr);	/* INT 10, function 0 */
}

void plot (int xpos, int ypos, int color)	/* Plot graphics */
					/* XOR if bit 7 COLOR set */
{
	inr.h.ah = 0x0c;
	inr.x.cx = xpos;
	inr.x.dx = ypos;
	inr.h.al = color;
	int86 (0x10,&inr,&outr);	/* INT 10, function 0c */
}

int pointis (int xpos, int ypos)		/* Read color of point */
						/* call pointis(x,y; */
{
	inr.h.ah = 0x0d;
	inr.x.cx = xpos;
	inr.x.dx = ypos;
	int86 (0x10,&inr,&outr);	/* INT 10, function 0d */
	return (outr.h.al);
}

int lpointis (int xpos, int ypos)		/* Legal check */
{
	if (xpos < 0 || ypos < 0)
	  return (0);
	return (pointis (xpos, ypos));
}

#define Setmode(Cmode) outport (0x03ce,Cmode);

void setmode (int cmode)	/* lo = register, hi = data */
{
	Setmode (cmode)
}

#define Setplanes(Cplane) 	/* Specify write planes */\
	outport (0x03c4,Cplane);

	/* Setplanes (0x0302);  Set reg 2 = 3 */

int getpal (int pal)
{
	if (xgamode == 0) return (1);	/* CGA.. */
	inr.h.ah = 16;
	inr.h.al = 7;
	inr.h.bl = pal;
	int86 (0x10,&inr,&outr);	/* INT 10, function 16 */
	return (outr.h.bh);
}


void palette (int pal, int col)
{
	if (xgamode < 1) return ;	/* CGA.. */
	inr.h.ah = 16;
	inr.h.al = 0;
	inr.h.bl = pal;
	inr.h.bh = col;
	int86 (0x10,&inr,&outr);	/* INT 10, function 16 */
	return ;
}

void paloff ()
{
	int cpal;
	for (cpal = 0; cpal < 16; cpal ++) {
	  palette (cpal,0);
	}
}

int normpal [] = {0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63};

void palon ()
{
	int cpal;
	  for (cpal = 0; cpal < 16; cpal ++) {
	    palette (cpal,normpal [cpal] );
	  }
}

void object (int xtop, int ytop, int xlen, int ylen, char *objarray)
	/* Place an object on screen */
	/* color is complex - lo = planes to effect, hi= SET/RESET pattern */
{
	int xpos,ypos;
	int cobj = 0;
	int yoff;
	int ploff,cplane,xpl;
	if (xgamode) {		/* EGA/VGA... */
	  /* Setmode (color & 0xff00)	/* RESET/SET fix pattern - reg 0 */
	  /* Setmode ((color << 8) | 1)	/* Bit planes to effect - reg 1 */
	  ploff = 0; xpl = 256;
	  for (cplane = 0; cplane < 4; cplane ++) {
	    Setplanes (xpl + 2)	/* Reg 2 = plane */
	    xpl = (xpl << 1);
	    for (ypos = ytop; ypos < ytop + ylen; ypos ++) {
	      yoff = ypos * 80;
	      for (xpos = xtop; xpos < xtop + xlen; xpos ++) {
	        Vdu [yoff + xpos] = objarray [cobj];
	        cobj ++;
	      }
	    }
	    ploff += (Ssize >> 2);
	  }
	  return ;
	}
	for (ypos = ytop; ypos < ytop + ylen; ypos ++) {
	  yoff = (ypos >> 1) * 80 + ((ypos & 1) << 13);
	  for (xpos = xtop; xpos < xtop + xlen; xpos ++) {
	    Vdu [yoff + xpos] = objarray [cobj];
	    cobj ++;
	  }
	}
}

int anyfly = 1;
void testfly ()		/* Test for hardware flyback */
{
	long temp = readtime () + 3;
	int test = inport (0x3da) & 8;
	while ( readtime () < temp) {
	  if (test != ( inport (0x3da) & 8)) return;
	}
	anyfly = 0;
}

void syncfly ()		/* 03da bit 3 set during flyback - bot to top bdr */
{
	if (anyfly) {
	  while (inport (0x3da) & 8);
	  while ((inport (0x3da) & 8) == 0);
	}
}

int savesound;
void soundon ()
{
	savesound = inportb (0x61);		/* Keep setting */
	outportb (0x61, savesound | 3);		/* Speaker on */
}

void setfreq (int hertz)
{
	int outfreq = 1331000/hertz;	/* Calc port val */
        outportb (0x43, 0xb6);		/* Set mode */
	outportb (0x42, outfreq & 0xff);	/* Write lo */
	outportb (0x42, outfreq >> 8);		/* Write hi */
}

void soundoff ()
{
	outportb (0x61,savesound);	/* Restore setting */
}

void soundit (int hertz, int ticks)
{
	setfreq (hertz);
	soundon ();
	pause (ticks);
	soundoff ();
}

void click ()
{
	soundit (500,1); soundit (1000,1);
	soundit (750,1);
}

void glide ()
{
	int cfreq;
	if (anyfly == 0) {
	  click ();
	  return ;
	}
	soundon ();
	for (cfreq = 50; cfreq < 1500; cfreq += 100) {
	  setfreq (cfreq);
	  syncfly ();
	}
	soundoff ();
}

void clrvdu ()		/* Wipe hires screen */
{
	if (xgamode) {
	  Vdu = (BYTE far *) 0xa0000000;	/* Ptr to EGA/VGA screen */
	  graphmode (16);	/* Mode 14 = 640*200 16col */
	  Setink (15);		/* Wht ink */
	} else {
	  Vdu = (BYTE far *) 0xb8000000;	/* Pointer to CGA screen */
	  graphmode (6);
	}
}

void clrcol (int col, int cline)	/* Set text scr colors,0=whole scr */
{
	int xpos;
	Vdu = (BYTE far *) 0xb8000000;	/* Pointer to CGA screen */
	if (cline) {
	  cline = cline * 160 - 159;
	  for (xpos = cline; xpos < cline + 160; xpos += 2) {
	    Vdu [xpos] = col;
	  }
	} else {
	  graphmode (3);
	  for (xpos = 1; xpos < 4000; xpos += 2) {
	    Vdu [xpos] = col;
	  }
	}
}

void gotoxy (int xloc, int yloc)	/* Goto to loc X,Y on VDU */
{
	inr.h.bh = 0;
	inr.h.dl = xloc - 1;
	inr.h.dh = yloc - 1;
	inr.h.ah = 0x02;
	int86 (0x10,&inr,&outr);	/* INT 10, function 02 */
}

void printc (char ichr)		/* Print a Char */
{
	nprint ++;
	inr.h.ah = 0x0e;
	inr.h.al = ichr;
	int86 (0x10,&inr,&outr);	/* INT 10, function 0e */
}

void prints (char *istr)	/* Print a null-term string */
{
	int cchr;
        for (cchr = 0; istr [cchr]; cchr ++) {
	  printc ( istr [cchr]);
	  if (istr [cchr] == 10) printc (13);
	}
}

void printi (int iint)		/* Print a signed int */
{
	int cchr;
	if (iint == 0) {
	  printc ('0');
	  return;
	}
	if (iint < 0) {
	  printc ('-');
	  iint = -iint;
	}
	for (cchr = 0; iint; cchr ++) {
	  prbuffer [cchr] = 48 + (iint % 10);
	  iint /= 10;
	}
	prbuffer [cchr] = 0;
	while (cchr) {
	  cchr --;
	  printc ( prbuffer [cchr]);
	}
}

printsi (char *istr, int iint)		/* Composite short cut */
{
	prints (istr);
	printi (iint);
}

int getkey ()
{
	inr.h.ah = 0x06;
	inr.h.dl = 0xff;
	int86 (0x21,&inr,&outr);	/* INT 21, function 6 */
	return (outr.h.al);
}

#if (Noload == 0)
void floaddata (char *filename,char *brddata,int datasize)
{						/* Load data from disk */
	int chandle;
	diskerror = 0;
	inr.x.dx = filename;
	inr.h.ah = 0x3d;
	inr.h.al = 0;		/* 0=read,1=write,2=rnd */
	int86 (0x21,&inr,&outr);	/* INT 21, 3d OPEN */
	chandle = outr.x.ax;
	if (outr.x.flags & 1) { 	/* Carry set ? */
	  prints ("Unable to load graphics!\n");
	  diskerror ++;
	  return ;
	}

	inr.x.bx = chandle;
	inr.x.dx = brddata;
	inr.x.cx = datasize;
	inr.h.ah = 0x3f;
	int86 (0x21,&inr,&outr);	/* INT 21, 3f READ */

	inr.x.bx = chandle;
	inr.h.ah = 0x3e;
	int86 (0x21,&inr,&outr);	/* INT 21, 3e CLOSE */
}

#endif

void fsavedata (char *filename,void *brddata,int datasize)
{						/* Load data from disk */
	int chandle;
	diskerror = 0;
	inr.x.dx = (unsigned int) filename;
	inr.h.ah = 0x3c;
	inr.x.cx = 0;
	inr.h.al = 0;
	int86 (0x21,&inr,&outr);	/* INT 21, 3c CREATE */
	chandle = outr.x.ax;
	if (outr.x.flags & 1) { 	/* Carry set ? */
	  prints ("Save Error!\n");
	  diskerror ++;
	  return ;
	}

	inr.x.bx = chandle;
	inr.x.dx = (unsigned int) brddata;
	inr.x.cx = datasize;
	inr.h.ah = 0x40;
	int86 (0x21,&inr,&outr);	/* INT 21, 40 Write */
	inr.x.bx = chandle;
	inr.h.ah = 0x3e;
	int86 (0x21,&inr,&outr);	/* INT 21, 3e CLOSE */
}

int inchr (char *bigstr, char fchr)	/* Find char in BIGSTR (-1 fail) */
{
	int scount;
	for (scount = 0; bigstr [scount] != 0; scount ++)
	  if (bigstr [scount] == fchr)
	    return (scount);
	return (-1);
}

void putat (int xpos, int ypos, int cpiece)
{
	xpos = xpos * charx - charx + topx;
	ypos = ypos * chary - chary + topy;
	object ( xpos, ypos, charx, chary, sprites + cpiece * Ssize);
}

long lasttime = 0;

int rseed = 0;		/* Rand seed */
int tseed ;
int colwrap = 16;	/* Max colors */
int lifex,lifey;	/* Curr pos */
int vdux = 639;		/* Screen size */
int vduy = 300;		/* Screen size */
int colorrange = 4;	/* # colors */
int coloff = 1;
int rules [100];
int lastlife [1000];	/* Last generation */
int newlife [1000];	/* Current gen */
int gmode = 2;		/* 0=320/200, 1=640/200, 2=640/350, 3=640/480 */
int gmx [] = {320,640,640,640,640};
int gmy [] = {200,200,350,480,600};
int gmm [] = {13,  14, 16,18, 106};

void genlife ()
{
	int lifex;
	pickmode1 = (fxmode & 1) + 1;
	pickmode2 = (fxmode & 2) / 2 + 1;
genanew:
	if (xgamode) {
	  graphmode (gmm [gmode]);
	} else {
	  graphmode (4);
	}
	tseed = rseed;
	/* if (rseed == 0) tseed = (rand () + readtime ()) & 32767; */
	srand (tseed + 2);
	gotoxy (1,25);
	printsi ("ESC to Abort, RETURN for new seed..     Seed = ",tseed);
	for (temp = 0; temp < 100; temp ++) {
	  rules [temp] = rand () & 255;
	}
genagain:
	for (lifex = 1; lifex <= vdux; lifex ++) {
	  lastlife [lifex] = rand () % colorrange;
	  plot (lifex, 1, (lastlife [lifex] + coloff) & 15);
	}
	lifey = 2;
	while (lifey < vduy) {
	  for (lifex = 1; lifex <= vdux; lifex ++) {
	    newlife [lifex] = rules [lastlife [lifex - pickmode1]
		+ lastlife [lifex] + lastlife [lifex + pickmode2] ] % colorrange;
	    plot (lifex, lifey, newlife [lifex] + coloff);
	  }
	  for (lifex = 1; lifex <= vdux; lifex ++) {
	    lastlife [lifex] = newlife [lifex];
	  }
	  if ((fxmode > 3) && (rand () & 7) == 0) {	/* Randomise a bit.. */
	    lastlife [temp = rand () % vdux] = rand () % colwrap;
	    lastlife [temp + 1] = rand () % colwrap;
	    /* rules [rand () & 15] ++; */
	  }
	  lastlife [0] = newlife [vdux];	/* Wrap around */
	  lastlife [vdux + 1] = newlife [1];
	  lastlife [vdux + 2] = newlife [2];
	  lastlife [vdux + 3] = newlife [3];
	  lastlife [vdux + 4] = newlife [4];
	  lifey ++;
	  inkey = getkey ();
	  if (inkey == 27) return;
	  if (inkey == 13) {
	    rseed = (rand () + readtime ()) & 32767;
	    goto genanew;
	  }
	}
	gotoxy (1,1);
	if (cmdkey == 13) {
	  printsi ("Seed=",tseed);
	  rseed = tseed;
	  pause (40);
	  if (getkey () == 27) return;
	  rseed = (rand () + readtime ()) & 32767;
	  goto genanew;		/* RET-Demo mode */
	}
	do {
	  inkey = getkey ();
	  if (inkey == 13) {
	    rseed = (rand () + readtime ()) & 32767;
	    goto genanew;
	  }
	  if (inkey == 'a') goto genagain;
	  if (inkey == 27) return;
	  if (inkey == '?') printsi ("Seed=",tseed);
	} while (inkey != ' ');
}

void hitspace ()
{
	click ();
	pause (20);
	prints ("                    Hit SPACE to Continue.");
	while (getkey () != ' ');
}

#define Col1 10
#define Col2 14
#define Col3 15


void frontscreen (int mode)
{
	clrcol (Col2,0);
	clrcol (15,25);
	prints (
	  "  LIFEPIX is released as free software.\n"
	  "  (C) A.Millett 1992-2025. Released as free software under GNU GPL3 license. \n"
	  "  (See: www.gnu.org/licenses/gpl-3.0.html) \n"
	);
	if (mode == 0) {
	  hitspace ();
	  return;
	}
	prints ("  Do you want CGA, EGA or VGA Graphics (Type:- c,e or v) ?");
	click ();
	do {
	  inkey = getkey ();
	  if (inkey < 96) inkey += 32;
	  xgamode = inchr ("cev",inkey);
	} while (xgamode < 0);
}

int byte2nyb (int inchr)
{
	return ((inchr & 1) + ((inchr & 4) >> 1)
	     + ((inchr & 16) >> 2) + ((inchr & 64) >> 3) );
}

	int miniset = 0;

void showmodes ()
{
	Setink (11);
	if (xgamode == 0) {
	  colwrap = 4;
	  gmode = 0;
	}
	if (xgamode == 1 && gmode > 2) {
	  gmode = 2;
	}
	vdux = gmx [gmode]; vduy = gmy [gmode];
	gotoxy (6,22);
	nprint = 6;
	printsi (" # Col:",colorrange);
	printsi (" (F1)  Seed:",rseed);
	printsi (" (+/-)  Start:",coloff);
	prints (" (F2) ");
	if (gmode == 0) prints ("320/200");
	if (gmode == 1) prints ("640/200");
	if (gmode == 2) prints ("640/350");
	if (gmode == 3) prints ("640/480");
	printsi (" (F3)  FX:",fxmode);
	prints (" (F4)");
	while (nprint < 76) printc (' ');
}

void showborder ()
{
	int xpos,ypos;
	if (xgamode == 0) return;
	for (xpos = 1; xpos <= 26; xpos ++) {		/* Edges... */
	  putat ( xpos, 1, rand () % 3);
	  putat ( xpos,19, rand () % 3);
	}
	for (ypos = 1; ypos <= 19; ypos ++) {
	  putat (  1, ypos, rand () % 3);
	  putat ( 26, ypos, rand () % 3);
	}
}

void show1border ()
{
	int xpos,ypos;
	if (xgamode == 0) return;
	xpos = (rand () % 26) + 1;
	ypos = (rand () % 19) + 1;
	syncfly ();
	if (rand () & 1) {
	  putat ( xpos, 1, rand () % 3);
	  putat ( xpos,19, rand () % 3);
	} else {
	  putat (  1, ypos, rand () % 3);
	  putat ( 26, ypos, rand () % 3);
	}
}

void titlescreen ()
{
	long temptime = 99;
titleloop:
	clrvdu ();			/* Clr brd/vdu */
	if (xgamode) {
	  paloff ();
	}
	gotoxy (28,3);
	Setink (14);
	prints ("+   L I F E - P I X   +\n\n");
	Setink (10);
	prints (
 "         If you are fed up with FRACTALS, try LIFE-PIX - a new way of\n"
 "       generating graphical patterns based on 2D LIFE Automota.\n"
 "       Hit the F10 key now for more info on 2D LIFE, or F1 to select\n"
 "       No of colours to use, F2 to select palette-start, F3 to select\n"
 "       graphic resolution, F4 for special FX, and + or - to select a seed\n"
 "       value for the random number generators. Hit '/' to inc seed by 100,\n"
 "       or '*' to reset to zero.\n"
 "         For a continuous demo, hit the RETURN key NOW and sit back..\n\n"
	);
	Setink (15);
	prints ("                    Hit SPACE to Start, ESC to Exit." );

	glide ();
	showmodes ();
	showborder ();
	colwrap = 16;
	palon ();
	do {
	  if ( temptime != (readtime () & 4) ) {
	    temptime = readtime () & 4;
	    show1border ();
	  }
	  cmdkey = getkey ();
	  if (cmdkey == '!') {
	    gotoxy (22,4);
	    prints ("LIFE-PIX is Copyright and Written by A.Millett.");
	  }
	  if (cmdkey == ';') {
	    colorrange = ((colorrange - 1) % 8) + 2;
	  }
	  if (cmdkey == '<') {
	    coloff = (coloff + 1) % 16;
	  }
	  if (cmdkey == '=') {
	    gmode = (gmode + 1) & 3;
	  }
	  if (cmdkey == '>') {
	    fxmode = (fxmode + 1) % 8;
	  }
	  if (cmdkey == '-') {
	    rseed --;
	  }
	  if (cmdkey == '+') {
	    rseed ++;
	  }
	  if (cmdkey == '*') {
	    rseed = 0;
	  }
	  if (cmdkey == '/') {
	    rseed += 100;
	  }
	  if (cmdkey == 'D') {
	    helpscreen ();
	    goto titleloop;	/* GOTO - Yetch! */
	  }
	  if (cmdkey == '&') {
	    fsavedata ("mini.tmp",sprites, Ssize * 4);
	  }
	  if (cmdkey) { showmodes (); }
	}  while (cmdkey != ' ' && cmdkey != 27 && cmdkey != 13 && cmdkey != 3);
}

void helpscreen ()
{
	clrvdu ();			/* Clr brd/vdu */
	gotoxy (1,3);
	Setink (14);
	prints (
 "         2D LIFE patterns are a novel way of generating graphical\n"
 "       patterns. You don't really need to understand the maths to use\n"
 "       it - just experiment with seed-values - however, for the brave,\n"
 "       here is an example:-\n"
 "            0213011210230120...   Generation 1 (640 colour pixels..)\n"
 "             36442443355433....   & then apply RULES (ie. 012301230123)\n"
 "             32002003311033...    Generation 2\n"
 "         The numbers above are displayed as coloured pixels, using the\n"
 "       standard EGA/VGA palette (offset with the Start Colour). The\n"
 "       computer generates 640 numbers between 0 & 3 for the 1st\n"
 "       generation. To generate each pixel in the next row, add together\n"
 "       the three immediatly above, and use that value to look-up a RULES\n"
 "       table (also randomly generated).\n"
 "         The above example uses 4 colours (0 to 3) - this can be changed\n"
 "       by altering the # Colours parameter. The FX parameter also changes\n"
 "       the way the cells behave. If all this is confusing, just experiment\n"
 "       with different Random-Seed values. If you don't like a pattern, you\n"
 "       may hit ESC to abort it early, or RETURN to try another..\n"

	);
	showborder ();
	Setink (15);
	gotoxy (6,22);
	hitspace ();
}

void main ()
{
	testfly ();
	#if (Noload == 0)
	  floaddata ("shell.spr", sprites, Msprite);
	  if (diskerror)
	    return;
	#endif
	frontscreen (1);
	clrvdu ();
	do {
	  titlescreen ();
	  if (cmdkey == 27) break;
	  if (cmdkey == 3) return;
	  genlife ();
	} while (cmdkey != 3);
	clrcol (14,0);
}

