Global envmapsize=256

Function RenderBumpMapper(bumpmap,envmap,lightx,lighty)
	LockBuffer
		yoffs=320
		For y=1 To 238
			For x=1 To 318
				offs=yoffs+x
				nx=PeekShort(bumpmap,(offs Shl 2)  )-(x-lightx)
				ny=PeekShort(bumpmap,(offs Shl 2)+2)-(y-lighty)	
				
				If nx<0 Or nx>255 nx=0
				If ny<0 Or ny>255 ny=0
				
				SHADE=PeekFloat(envmap,((ny*envmapsize)+nx)Shl 2)	
				WritePixelFast x,y,SHADE	
			Next
			yoffs=yoffs+320
		Next
	UnlockBuffer
End Function

Function LoadBumpMapper(file$,free=False)
	bumpmap=CreateBank(320*240)
	IMG=LoadImage(file$)
	SetBuffer ImageBuffer(IMG)
	LockBuffer
		For y=0 To 239
			For x=0 To 319
				RGB=ReadPixelFast(x,y)
				PokeByte(bumpmap,(y*320)+x,(((RGB Shr 16) And $FF)+((RGB Shr 8) And $FF)+(RGB And $FF))/3)
			Next
		Next
	UnlockBuffer
	SetBuffer BackBuffer()
	bumpmap2=CreateBank(320*240*4)
	yoffs=320
	For y=1 To 238
		For x=1 To 318
			offs=yoffs+x
			nx=(PeekByte(bumpmap,offs+1)-PeekByte(bumpmap,offs-1))+(envmapsize/2)
			ny=(PeekByte(bumpmap,offs+320)-PeekByte(bumpmap,offs-320))+(envmapsize/2)
			PokeShort(bumpmap2,offs Shl 2,nx)
			PokeShort(bumpmap2,(offs Shl 2)+2,ny)
		Next
		yoffs=yoffs+320
	Next
	FreeBank bumpmap
	If free FreeImage IMG
	Return bumpmap2
End Function


Function CreatePhongEnvMapForBM(size#,sr#,sg#,sb#,dr#,dg#,db#,spr#,spg#,spb#,n)
	pallettee=CreateBank(256*4)
	For i#=0 To 255
		ang#=(90.00/255.00)*(255-i#)
		R=(sr#+Cos(ang#)*dr#+Cos(ang#)^n*spr#)
		If R>255 R=255
		G=(sg#+Cos(ang#)*dg#+Cos(ang#)^n*spg#)
		If G>255 G=255
		B=(sb#+Cos(ang#)*db#+Cos(ang#)^n*spb#)
		If B>255 B=255
		PokeFloat(pallettee,i#*4,(R Shl 16)+(G Shl 8)+B)
	Next
	
	env_map=CreateBank(size*size*4)
	For y=0 To (size-1)
		For x=0 To (size-1)
			nx#=(Float x-(size/2))/(size/2)
			ny#=(Float y-(size/2))/(size/2)
			nz#=1-Sqr(nx#*nx#+ny#*ny#)
			If nz#<0 nz#=0
			shade=Int(nz#*255)
			PokeFloat(env_map,((y*size)+x)Shl 2,PeekFloat(pallettee,shade Shl 2))
		Next
	Next
	FreeBank pallettee
	Return env_map
End Function