;============================================================================
; BR?-TK-HUE! - Part 1
;
; The second brazilian demo for TK90X 
;
; Authors:  TK90Fan (code and graphics)
;           raphaelgoulart (musics)
; Additional code by: Einar Saukas (FZX driver and ZX7)
;
; Date: 10/06/2014
;============================================================================

;============================================================================
; Labels
;============================================================================

    INCLUDE "Header_Print.asm"

;============================================================================
; Entry point 
;============================================================================
 
    ORG 32768
    JP P1Main               ; Jump to main program. 

;============================================================================
; Variables
;============================================================================

; Delay time constants used to border effect. First value defines amount of time
;during top green border is showed. Second value is for middle yellow border. 

DelayVal1                   ; POKE at 32771/32772. 
    DEFW 1210               ; 50Hz TK90X. 
;    DEFW 962               ; 60Hz TK90X. 
;    DEFW 1186              ; 48K Spectrum.
;    DEFW 1196              ; 128K Spectrum.
;    DEFW 1337              ; Pentagon

DelayVal2                   ; POKE at 32773/32774. 
    DEFW 606                ; 50Hz TK90X. 
;    DEFW 606               ; 60Hz TK90X. 
;    DEFW 594               ; 48K Spectrum.
;    DEFW 606               ; 128K Spectrum.
;    DEFW 594               ; Pentagon

;============================================================================
; Main program
;============================================================================

P1Main
; Prepare IM 2. 
    DI                      ; Turn off interrupts. 
    LD A,0xFE               ; Interrupt vector MSB is 0xFE (254). 
    LD I,A
    IM 2                    ; Interrupt mode 2.
    LD B,0                  ; Make a table of interrupt vector LSB values. 
    LD HL,0xFE00
P1Main.l0
    LD (HL),0xFD
    INC HL
    DJNZ P1Main.l0
    LD (HL),0xFD
    LD A,0xC3               ; Opcode for JP. 
    LD (0xFDFD),A           ; Put "JP IntRoutine" at 0xFDFD (65021). 
    LD HL,IntRoutine
    LD (0xFDFE),HL
; Decompress AY player/data. 
    LD HL,MusMega
    LD DE,49152             ; Initialize music player. 
    CALL dzx7
    CALL 49152
    LD IY,0                 ; Reset interrupt counter. 
    EI
; Wait until all screen colors are changed.
    LD B,32                 ; 32 columns. 
P1Main_Colors
    HALT
    DJNZ P1Main_Colors
; Show first screen. 
    CALL P1_CLS
    LD HL,P1.msg0
    CALL PrintMsg
    LD HL,P1.msg1
    CALL PrintMsg
    LD HL,P1.msg2
    CALL PrintMsg
    CALL WaitKey
; Show second screen. 
    CALL P1_CLS
    LD HL,P1.msg0
    CALL PrintMsg
    LD HL,P1.msg3
    CALL PrintMsg
    LD HL,P1.msg2
    CALL PrintMsg
    CALL WaitKey
; Prepare to return to BASIC. 
    DI
    IM 1
    LD IY,23610
    LD HL,10072
    EXX
    XOR A               ; Open channel 0 (bottom lines of screen). 
    CALL CHAN_OPEN
    LD A,Pr_At          ; PRINT AT 0,0;
    RST 16
    LD A,0
    RST 16
    LD A,0
    RST 16
    LD B,64
P1Main.l1
    LD A," "
    RST 16
    DJNZ P1Main.l1
    LD HL,P1.msg4
    CALL PrintMsg
Mute
    LD A,14             ; Reset all AY registers. 
    LD DE,$BF00         ; D=MSB of AY port, E=0 used to reset register. 
Mute.Loop
    LD BC,$FFFD         ; Select port.
    OUT (C),A           ; Select register.
    LD B,D
    OUT (C),E           ; Reset port. 
    DEC A
    JP P,Mute.Loop      ; Repeat for all ports. 

    XOR A               ; Black border. 
    OUT (254),A
    LD (IY+14),7
    LD (IY+83),7        ; Black paper and white ink. 
    LD HL,22528
    LD (HL),7           ; Black paper and white ink. 
    LD DE,22529
    LD BC,767
    LDIR
    EI
    RET

;============================================================================
; Subroutines
;============================================================================

;----------------------------------------------------------------------------
; P1_CLS
; Clear screen bitmap (16384-22527).
; Registers used: HL=22527, DE=22528, BC=0, F. 
;----------------------------------------------------------------------------

P1_CLS
    LD HL,16384
    LD (HL),L
    LD DE,16385
    LD BC,6143
    LDIR
    RET

;----------------------------------------------------------------------------
; IntRoutine
; Interrupt Service Routine 
;
; Note: maskable interrupt request acknowledgement takes at least 7T to be 
;processed. The jump instruction at 0xFDFD takes another 10T. 
;----------------------------------------------------------------------------

IntRoutine
    DI                      ; (4T)
    PUSH AF                 ; (11T)
    PUSH BC                 ; (11T)
    PUSH DE                 ; (11T)
    PUSH HL                 ; (11T)
    PUSH IX                 ; (15T)
    EX AF,AF'               ; (4T)
    PUSH AF                 ; (11T)
; Make color effect with screen border. 
    LD A,4                  ; (7T)
    OUT (254),A             ; (11T) Green border. 
    LD BC,(DelayVal1)       ; (20T) Time count: 116T. 
    CALL Delay24BC          ; (see comments inside source)
    LD A,6                  ; (7T)
    OUT (254),A             ; (11T) Yellow border. 
    LD BC,(DelayVal2)       ; (20T) Time count: 38T. 
    CALL Delay24BC          ; (see comments inside source)
    LD A,4                  ; (7T)
    OUT (254),A             ; (11T) Green border. 
; Play AY music. 
    CALL 49157
; Make color effect within main screen. 
    LD A,IYl                ; Select a screen column (0-31) where colors will be
    RR A                    ;attributed. This value is taken from IY register
    AND %00011111           ;for synchronization purpose.  
    LD L,A
    LD H,22528/256          ; HL is address of current attribute position. 
    LD DE,32                ; Value to be added when calculating address of
                            ;next line position. 
    LD C,8*1+7              ; Paper 1 (blue) and ink 7 (white). 
    LD A,IYh                ; Bit 9 of interrupt counter is the flag to toggle
    AND %00000010           ;between blue and green+yellow+green colors. 
    JR Z,IntRoutine.j0
    LD C,8*4+0              ; Paper 4 (green) and ink 0 (black). 
IntRoutine.j0
    EX AF,AF'
    LD B,8                  ; Counter for 8 lines. 
IntRoutine.l0
    LD (HL),C               ; Assign attribute value at current address. 
    ADD HL,DE               ; Calculate address of next line. 
    DJNZ IntRoutine.l0      ; Repeat until 8 lines were assigned. 
    EX AF,AF'
    JR Z,IntRoutine.j1
    LD C,8*6+0              ; Paper 6 (yellow) and ink 0 (black). 
IntRoutine.j1
    EX AF,AF'
    LD B,8                  ; Counter for 8 lines. 
IntRoutine.l1
    LD (HL),C               ; Assign attribute value at current address. 
    ADD HL,DE               ; Calculate address of next line. 
    DJNZ IntRoutine.l1      ; Repeat until 8 lines were assigned. 
    EX AF,AF'
    JR Z,IntRoutine.j2
    LD C,8*4+0              ; Paper 4 (green) and ink 0 (black). 
IntRoutine.j2
    EX AF,AF'
    LD B,8
IntRoutine.l2
    LD (HL),C
    ADD HL,DE
    DJNZ IntRoutine.l2
; Update interrupt counter and prepare to exit interrupt routine. 
    INC IY 
    POP AF
    EX AF,AF'
    POP IX
    POP HL
    POP DE
    POP BC
    POP AF
    EI
    RET 

;----------------------------------------------------------------------------
; Delay24BC
;
; Long delay rotine, the main loop delay is 24 T. An overhead of 27 T must be
;accounted for CALL and RET instructions. 
;
; Equation of delay duration: (24*BC+27) T
; Minimum delay (BC=1): 51 T
; Maximum delay (BC=0): 1 572 891 T
; Input: BC=number of cycles
; Output: A=B=C=0
; Registers used: AF, BC. 
;----------------------------------------------------------------------------

    INCLUDE "Delay24BCT.asm"

;----------------------------------------------------------------------------
; dzx7
;
; ZX7 decoder by Einar Saukas
; "Mega" version (244 bytes, 30% faster)
;
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
;----------------------------------------------------------------------------

    INCLUDE "dzx7_mega.asm"

;----------------------------------------------------------------------------
; PrintMsg 
; Description: print a string using FZX proportional font specification. The
;string must be terminated by 255 end marker. 
; Input: HL=string address. 
; Used registers: AF, BC, DE, HL, AF', IX. 
;----------------------------------------------------------------------------

PrintMsg
    LD A,(HL)
    CP 255
    RET Z
    PUSH HL
    CALL FZX_START
    POP HL
    INC HL
    JR PrintMsg

;----------------------------------------------------------------------------
; FZX driver - Copyright (c) 2013 Einar Saukas
; FZX format - Copyright (c) 2013 Andrew Owen
; Modified for BR?-TK-HUE! demo by TK90X Fan.
;----------------------------------------------------------------------------

    INCLUDE "FZXdriver_mod.asm"

;----------------------------------------------------------------------------
; WaitKey
; Description: wait for a key press. 
; Used registers: AF. 
;----------------------------------------------------------------------------

WaitKey
    CALL WaitKey.s1         ; Wait until all keys are released. 
    JR NZ,WaitKey
WaitKey.l1
    CALL WaitKey.s1         ; Wait until a key is pressed. 
    JR Z,WaitKey.l1
WaitKey.l2
    CALL WaitKey.s1         ; Wait until all keys are released. 
    JR Z,WaitKey.l2
    RET 
;
WaitKey.s1
    HALT                    ; Wait for interrupt.
    XOR A                   ; A=0, epnable all key rows.
    IN A,(254)              ; Read keys. 
    CPL                     ; Pressed key will set bit. 
    AND %00011111           ; Mask out unused bits (5-7). 
    RET                     ; End of routine. 
;
;============================================================================
; Data
;============================================================================

;----------------------------------------------------------------------------
; Strings
;----------------------------------------------------------------------------

P1.msg0
    DEFB Pr_At, 3, 90
    DEFM "BR?-TK-HUE!"
    DEFB Pr_At, 4, 84
    DEFM "___________"
    DEFB Enter, Enter
    DEFB 255                ; End of text marker.

P1.msg1
    DEFM " Este  um demo 100% brasileiro."
    DEFB Enter
    DEFM " This is a 100% Brazilian demo."
    DEFB Enter, Enter
    DEFM " Por/by:"
    DEFB Enter
    DEFM "  TK90X Fan (cdigo e grficos/code & graphics)."
    DEFB Enter
    DEFM "  raphaelgoulart (msica/music)."
    DEFB Enter, Enter
    DEFM " Cdigo extra por/additional code by:"
    DEFB Enter
    DEFM "   Einar Saukas (ZX7 driver, FZX)."
    DEFB Enter, Enter
    DEFM " Para TK90X 48K+Explorer+50Hz. Leia documen-"
    DEFB Enter
    DEFM " tao para outros sistemas."
    DEFB Enter
    DEFM " For TK90X 48K+AY interface+50Hz. Read docs"
    DEFB Enter
    DEFM " for another system."
    DEFB Enter
    DEFB 255                ; End of text marker.

P1.msg2
    DEFB Pr_At, 180, 55
    DEFM "Digite uma tecla/press a key."
    DEFB 255                ; End of text marker.

P1.msg3
    DEFM "Saudaes nacionais:"
    DEFB Enter
    DEFM " Belavenuto, Branco, Clvis, Danjovic, Danlucio,"
    DEFB Enter
    DEFM " Einar, Emmerson, Equetus, Favoreto, Francisco,"
    DEFB Enter
    DEFM " Garrett, Jader, Kelly, Kim, Leo Surez, Leonardo"
    DEFB Enter
    DEFM " Rosa, Lisias, Luccas, Luiz Eduardo, Moises,"
    DEFB Enter 
    DEFM " Mugnatto, Nelsinho, Nitrofurano, Nivardo, "
    DEFB Enter
    DEFM " Oscar, Policarpo, Rbson, Rony, Tiago, Trucco e "
    DEFB Enter
    DEFM " Wesley."
    DEFB Enter, Enter
    DEFM "International greetings:"
    DEFB Enter
    DEFM " AER, Alone Coder, aowen, Braytentayle, Gasman,"
    DEFB Enter
    DEFM " Grussu, Hellboj, Introspec, Irrlicht Project, lvd,"
    DEFB Enter 
    DEFM " Mister Beep, nix./site, Piesiu, trixs, Shiru,"
    DEFB Enter 
    DEFM " Utz & Yerzmyey."
    DEFB 255                ; End of text marker.

P1.msg4
    DEFB Pr_At, 180, 64
    DEFM " Carregando.../loading... "
    DEFB 255                ; End of text marker.

;----------------------------------------------------------------------------
; Latin-1 version of Dutch font in FZX format.
; by Andrew Owen and TK90X Fan. 
;----------------------------------------------------------------------------

FONT
    INCBIN "Dutch_Latin1.fzx"

;----------------------------------------------------------------------------
; Compressed AY music player & data
;----------------------------------------------------------------------------

MusMega
    INCBIN "MegaRedoneAY.bin.zx7"


