Const
  CR  = ^M;
  LF  = ^J;
  Tab = ^I;
  HexCode : String[16]  = '0123456789ABCDEF';
  BegReg = 5;
  EndReg = 9;
  // compiler parameters
  OptimizeSTACK = True;
  //ReplaceSHLSHR = True;

Type
  Str32     = String[32];
  Token     = (_Unknown,_string_constant,_numeric_Constant,_name,
               _program,_Var,_Const,_Begin,_While,_do,_repeat,_Until,
               _Random,_Debug,_DrawChar,_DrawSprite,_High,_Low,
               _cls,_scrollleft,_scrollright,_scrolldown,_delay,
               _period,_comma,
               _begarr,_twodot,_endarr,_pointer,  // arrays!!!
               _plus,_minus,_mul,_div,_mod,_xor,_shr,_shl,_and,_or,_lparen,_rparen,_separator,
               _assign,_equal,_greater,_less,_less_eq,_greater_eq,_not_eq,_colon,
               _if,_then,_else,_for,_to,
               _procedure,_function,
               _end);

  ObjCode   = (_Call,_Return,_Clear,_LoadConst,_LoadVar,_Push,_PopAdd,_PopSub,
               _PopMul,_PopDiv,_Store,_Inc_Const,_PutLabel,
               _JumpTo,_IfJumpTo,_IfNotJumpTo,
               _ProgramInit,_ProgramExit,
               _Logical,_Logical_Not,
               Greater,Less,_PutC,_PutWord,_PutCrLf,_PutString,_Pop,_PopSHR,
               _PopSHL,_PopAND,_PopOR,_Logical_Neq,_PopMOD,_LoadPointer,_PopXOR);
Const
  MaxToken  = Ord(_end);
  TokenName : Array[0..MaxToken] of Str32 =
              ('','','','',
               'PROGRAM','VAR','CONST','BEGIN','WHILE','DO','REPEAT','UNTIL',
               'RANDOM','DEBUG','DRAWCHAR','DRAWSPRITE','SETHIGH','SETLOW',
               'CLS','SCROLL_LEFT','SCROLL_RIGHT','SCROLL_DOWN','DELAY',
               '.',',',
               '[','..',']','^', //ARRAYS !!!
               '+','-','*','DIV','MOD','XOR','SHR','SHL','AND','OR','(',')',';',
               ':=','=','>','<','<=','>=','<>',':',
               'IF','THEN','ELSE','FOR','TO',
               'PROCEDURE','FUNCTION',
               'END');

Type
  NameStr   = String;
  LabelStr  = String;
Var
  Look           : Char;
  Current_String : String;
  Current_Token  : Token;
  Current_Number : Longint;
  ispointer : boolean;

  current_stack_num : Word;

  Source,Dest    : Text;
  Name           : String;
  LineCount      : Longint;
  last_var       : String;


Function Dec2Hex(N: Byte): String;
Begin
     Dec2Hex := HexCode[(N shr 4)+1]+HexCode[(N and $F)+1];
End;

function bin2dec(s:string):integer;
var x,i:integer;
begin
  x:=0;
  for i:=1 to length(s) do
     x:=(x + ord(s[i])-$30) shl 1;
bin2dec:= x shr 1;
end;

function  numb(i : integer):string;
var
  s : string;
begin
  str(i,s);
  numb := s;
end;

Procedure Abort(S : String); Forward;

Procedure GetChar;
begin
  if Not Eof(Source) then Read(Source,Look)
                     else Look := '.';
  {                      Abort('Unexpected end of file'); }
  If Look = #13 then Inc(LineCount);
end;

procedure SkipSpace;
begin
  While (look in [Cr,Lf,Tab,' ']) AND (Not Eof(Source)) do
    GetChar;
end;

Procedure GetToken;
label
  restart,
  done;
var
  i,j : word;
  x   : boolean;
  last: char;
  s : String;
begin
RESTART:
  Current_String := '';
  Current_Token  := _Unknown;
  Current_Number := 0;
  SkipSpace;
  Case Look of
{    '['  : begin
            GetChar;
               repeat
                 last := look;
                 getchar;
               until (last = '.') and (look = '.');
            GetChar;
            Goto Restart;
           end;}
    '{'  : begin
             repeat
               GetChar;
             until Look = '}';
             GetChar;
             Goto Restart;
           end;

    '('  : begin
             getchar;
             if look = '*' then
             begin
               getchar;
               repeat
                 last := look;
                 getchar;
               until (last = '*') and (look = ')');
               getchar;

               Goto Restart;
             end
             else
               current_token := _lparen;
           end;

    '''' : begin
             getchar;
             current_string := '';
             x := false;
             repeat
               case look of
                 cr    : abort('String exceeds line');
                 ''''  : begin
                           getchar;
                           if look <> '''' then
                             x := true
                           else
                           begin
                             current_string := current_string + look;
                             getchar;
                           end;
                         end;
               else
                 current_string := current_string + look;
                 getchar;
               end;
             until x;
             current_token := _string_constant;
           end;

    '#'  : begin
             GetChar;
             s := '';
             While UpCase(Look) in ['0'..'1'] do
             begin
                  s := s + Look;
                  GetChar;
             end;
             Current_Number := Bin2Dec(S);
             Current_Token := _numeric_constant;
           end;
    '$'  : begin
             GetChar;
             While (UpCase(Look) in ['0'..'9','A'..'F']) do
             begin
               Current_Number := Current_Number SHL 4 +
                                 Pos(UpCase(Look),HexCode)-1;
               GetChar;
             end;
             Current_Token := _numeric_constant;
           end;
    '0'..'9' : begin
                 while look in ['0'..'9'] do
                 begin
                   Current_Number := Current_Number * 10 +
                                     Pos(Look,HexCode)-1;
                   GetChar;
                 end;
                 current_token := _numeric_constant;
               end;
    '_','A'..'Z',
        'a'..'z'   : begin
                       While UpCase(Look) in ['_','0'..'9',
                                                  'A'..'Z',
                                                  'a'..'z' ] do
                       begin
                         Current_String := Current_String + UpCase(Look);
                         GetChar;
                       end;
                         for i := 0 to MaxToken do
                           if Current_String = TokenName[i] then
                           begin
                             Current_Token := Token(i);
                          {   goto done; }
                           end;
                       If Current_Token = _Unknown then
                         Current_Token := _name;
                     end;
  else
    Current_String := UpCase(Look); GetChar;
    Repeat
      J := 0;
      For i := 0 to MaxToken do
        if (Current_string+UpCase(Look)) = TokenName[i] then
          J := i;
      If J <> 0 then
      begin
        Current_String := Current_String + UpCase(Look);
        GetChar;
      end;
    Until J = 0;

    For i := 0 to MaxToken do
      if Current_String = TokenName[i] then
        J := i;
    Current_Token := Token(j);
  end; { Case Look }

{ If we get here, we have a string that makes no sense! }

DONE:
end;

(*********************
    Error Reporting
 *********************)

procedure Error(s : string);
begin
  WriteLn;
  WriteLn(^G,'(',LineCount+1,') Error: ',s,'.');
end;

procedure Abort(S : String);
begin
  Error(S);
  Halt;
end;

procedure Expected(s : string);
begin
  Abort(s + ' Expected');
end;

(*************************
     Symbol Table Stuff
 *************************)
Const
  _Integer = 0;
  _Byte    = 1;
  _Long    = 2;
  _Void    = 3;
  _Array   = 4;
Type
  TType    = Record
               Name  : String[32];
               Size  : Word;
             End;

  Symbol   = Record
               Name  : String[32];
               Kind  : Integer;
               IsVar : Boolean;
               Sz    : Word; // size of arrays
               ArrDat : String; //array/var data
             End;

Const
  TypeInteger  : TType = (Name : '_INTEGER'; Size :2);
  TypeByte     : TType = (Name : '_BYTE';    Size :1);
  TypeLong     : TType = (Name : '_LONG';    Size :4);
  TypeVoid     : TType = (Name : '_VOID';    Size :0);
  TypeArray    : TType = (Name : '_ARRAY';   Size :0);
Var
  SymbolTable  : Array[0..512] of Symbol;
  SymbolCount  : Integer;

  TypeTable    : Array[0..512] of TType;
  TypeCount    : Integer;

  StringConst  : Array[0..63]  of String;
  StringCount  : Integer;

function ToUpper(S : String):String;
var
      ss : string;
      i : byte;
begin
      ss := '';
      for i := 1 to Length(S) do SS := SS + UpCase(s[i]);
      ToUpper := ss;
end;

function GetName:String;
begin
  If Current_Token = _Name then
    GetName := '_' + ToUpper(Current_String)
  else
    Expected('Name');
  GetToken;
end;

function GetNumber:Integer;
begin
  GetNumber := Current_Number;
  GetToken;
end;

Procedure AddSymbol(_Name : String; _Kind : Integer; _IsVar : Boolean; _Sz : Word; _dat : string );
Begin
  SymbolTable[SymbolCount].Name  := _Name;
  SymbolTable[SymbolCount].Kind  := _Kind;
  SymbolTable[SymbolCount].IsVar := _IsVar;
  SymbolTable[SymbolCount].Sz    := _Sz;
  SymbolTable[SymbolCount].ArrDat:= _dat;
  Inc(SymbolCount);
End; { AddSymbol }

Function LookSymbol(_Name : String):Integer;
{ True if _NAME is in table }
Var
  q,r : Integer;
Begin
  r := -1;
  For q := 0 to SymbolCount-1 do
    If SymbolTable[q].Name = _Name then
      r := q;
  If r <> -1 then
    LookSymbol := SymbolTable[r].Kind
  else
    LookSymbol := -1;
End;

Function CheckSymbol(_Name : String): Integer;
Var
  tmp : integer;
Begin
  tmp := LookSymbol(_Name);
  if tmp = -1 then
    Expected('identifier');
  CheckSymbol := tmp;
End;

Procedure DumpSymbols;
var
  i,j : integer;
Begin
  WriteLn(Dest,'; Variable Area');
  for i := 0 to SymbolCount - 1 do
    If SymbolTable[i].IsVar then
{      WriteLn(Dest,SymbolTable[i].Name,TAB,
                   'DB',TAB,
                   TypeTable[SymbolTable[i].Kind].Size,TAB,
                   'DUP (?)');}
      Begin
      //Val(SymbolTable[i].ArrDat,num,tmp);
      If SymbolTable[i].Sz = 0 then
            WriteLn(Dest,SymbolTable[i].Name+':',TAB,'DB',TAB,'#'+Dec2Hex(Ord(SymbolTable[i].ArrDat[1]))+',#'+Dec2Hex(Ord(SymbolTable[i].ArrDat[2])))
            else
              Begin
                  Write(Dest,SymbolTable[i].Name+':',TAB,'DB',TAB,'#'+Dec2Hex(Ord(SymbolTable[i].ArrDat[1]))+',');
                  for j := 2 to SymbolTable[i].Sz do
                        If (j) mod 10 = 0 then
                          begin
                            If SymbolTable[i].IsVar then
                              WriteLn(Dest,'#'+Dec2Hex(Ord(SymbolTable[i].ArrDat[1])))
                            else
                              WriteLn(Dest,'#'+Dec2Hex(Ord(SymbolTable[i].ArrDat[j])));
                              Write(Dest,TAB+'DB'+TAB);
                          end
                        else
                         If SymbolTable[i].IsVar then
                           Write(Dest,'#'+Dec2Hex(Ord(SymbolTable[i].ArrDat[1])),',')
                         else
                           Write(Dest,'#'+Dec2Hex(Ord(SymbolTable[i].ArrDat[j])),',');
                  WriteLn(Dest,'#'+Dec2Hex(Ord(SymbolTable[i].ArrDat[j])));
              End;
      End;

End;

Function LookType(    _Name : String):Integer;
{ True if _NAME is in table }
Var
  q,r : Integer;
Begin
  r := -1;
  For q := 0 to TypeCount-1 do
    If TypeTable[q].Name = _Name then
      r := q;
  LookType := r;
End;

//Procedure CheckType(_Name : String);
//Begin
//  If (LookType(_Name) = -1) then
//    Expected('type');
//End;

Function DoStringConst(S : String):String;
Begin
  StringConst[StringCount] := S;
  DoStringConst := '_STR'+Numb(StringCount);
  Inc(StringCount);
End;


Procedure DumpStrings;
Var
  i : integer;
  j : byte;
  s : string;
Begin
  WriteLn(Dest,'; String constants');
  for i := 0 to StringCount-1 do
  begin
    s := StringConst[i];
    WriteLn(Dest,'_STR'+Numb(i),TAB,
                 'DD',TAB,
                 Numb(Length(S)));
    Write(Dest,TAB,'DB',TAB,'''');
    For j := 1 to length(s) do
      If S[j] <> '''' then
        Write(Dest,S[j])
      else
        Write(Dest,'''''');
    WriteLn(Dest,'''');
  end;
End;


(*************************
      Code Generator
 *************************)
Var
  LabelCount : Word;

procedure Emit(s : string);
begin
  Write(Dest,'      ', s);
end;

procedure EmitLn(s : string);
begin
  Emit(s);
  WriteLn(Dest);
end;

function  NewLabel:LabelStr;
var
  tmp : string;
begin
  Str(LabelCount,tmp); Inc(LabelCount);
  tmp := 'L'+tmp;
  NewLabel := tmp;
end;

Procedure GetStackVar; // get variable from stack
Begin
      If (Current_Stack_Num-1 in [BegReg..EndReg]) and OptimizeSTACK then
        begin
            EmitLn('mov   r1,r0'+TAB+TAB+'; save V0->V1, get V0 from stack');
            EmitLn('mov   r0,r'+HexCode[Current_Stack_Num])
        end
      else
            EmitLn('CALL  __POPV0');
      Dec(Current_Stack_Num);
End;

// V0 - current
// V1 - from stack
// V2 - logical (save V1), decrement for STACK
// V3,V4 - parameters for standart procedures

Function GenCode(c : ObjCode;
                   n : integer;
                   s : string) : integer;
Var
 Tmp : String;
 x,y : integer;
Begin
  Case c of
    _Call       : EmitLn('call  '+S);
    _Return     : EmitLn('ret');
    _Clear      : EmitLn('LD    V0,0');
    _LoadConst  : EmitLn('ldi   r0,'+Numb(N)+TAB+TAB+'; load const');
    _LoadVar    : begin
                    x := CheckSymbol(s);
                    y := TypeTable[x].Size;
                    Case Y of
                      1 : begin
                            EmitLn('ldm   r0,'+S+TAB+TAB+'; load variable');
                            //EmitLn('LD    V0, [I]');
                          end;
                      2 : begin // integer
                            EmitLn('ldm   r0,'+S+TAB+TAB+'; load INTEGER variable');
                          end;
                      4 : begin
                            //EmitLn('MOV   EAX,DWORD PTR['+S+']');
                            EmitLn('ldm   r0,'+S+TAB+TAB+'; load variable DWORD');
                          end;
                      0 : begin // ARRAYS
                            EmitLn('ldi   r3,'+S+TAB+TAB+'; load array variable');
                            EmitLn('shl   r0,1');
                            EmitLn('add   r3,r0');
                            EmitLn('ldm   r0,r3');
                          end;
                    else
                        Abort('Illegal variable size');
                    end;
                  end;

    _LoadPointer: begin
                    EmitLn('ldi   rf,'+S+TAB+TAB+'; load pointer');
                  end;

    _Push       : begin
                    If (Current_Stack_Num in [BegReg..EndReg]) and OptimizeSTACK then
                      EmitLn('mov   r'+HexCode[Current_Stack_Num+1]+',r0'+TAB+TAB+'; push to stack')
                    else
                       begin
                         EmitLn('push  r0'+TAB+TAB+'; push V0 into stack');
                       end;
                    Inc(Current_Stack_Num);
                  end;

    _Pop        : begin
                    If (Current_Stack_Num-1 in [BegReg..EndReg]) and OptimizeSTACK then
                       EmitLn('mov   r1,r'+HexCode[Current_Stack_Num]+TAB+TAB+'; pop from stack')
                    else
                       begin
                          EmitLn('pop   r1'+TAB+TAB+'; pop V1 from stack');
                       end;
                    Dec(Current_Stack_Num);
                  end;
    _PopAdd     : begin
                    GetStackVar;
                    EmitLn('add   r0,r1'+TAB+TAB+'; make addiction');
                  end;
    _PopSub     : begin
                    GetStackVar;
                    EmitLn('sub   r0,r1'+TAB+TAB+'; make substraction');
                  end;
    _PopOR      : begin
                    GetStackVar;
                    EmitLn('or    r0,r1');
                  end;
    _PopAND     : begin
                    GetStackVar;
                    EmitLn('and   r0,r1');
                  end;
    _PopSHR     : begin
                    GetStackVar;
                    EmitLn('shr   r0,r1');
                  end;

    _PopSHL     : begin
                    GetStackVar;
                    EmitLn('shl   r0,r1');
                  end;

    _PopMOD     : begin
                    GetStackVar;
                    EmitLn('CALL  MOD');
                  end;

    _PopXOR     : begin
                    GetStackVar;
                    EmitLn('xor   r0,r1');
                  end;

    _PopMul     : begin
                    GetStackVar;
                    x := CheckSymbol(s);
                    y := TypeTable[x].Size;
                    Case Y of
                      1: EmitLn('mul   r0,r1');
                      2: EmitLn('call  imul');
                    else
                     Abort('Illegal variable size');
                    end;
                  end;
    _PopDiv     : begin
                    GetStackVar;
                    x := CheckSymbol(s);
                    y := TypeTable[x].Size;
                    Case Y of
                      1: EmitLn('div   r0,r1');
                      2: EmitLn('call  idiv');
                    else
                     Abort('Illegal variable size');
                    end;
                  end;
    _Store      : begin
                    x := CheckSymbol(s);
                    y := TypeTable[x].Size;
                    Case Y of
                      1 : begin
                            EmitLn('stm   r0,'+S+TAB+TAB+'; store variable');
                            //EmitLn('LD    [I], V0');
                          end;
                      2 : EmitLn('stm   r0,'+S+TAB+TAB+'; store variable INTEGER');
                      4 : begin
                            EmitLn('stm   r0,'+S+TAB+TAB+'; store variable WORD');
                          end;
                      0 : begin     // ARRAYS
                            EmitLn('ldi   r3,'+S+TAB+TAB+'; store array variable');
                            EmitLn('shl   r1,1');
                            EmitLn('add   r3,r1');
                            EmitLn('stm   r0,r3');
                          end;
                    else
                      Abort('Illegal variable size');
                    end;
                  end;
    _Inc_Const  : begin
                    if N = 1 then
                      Begin
                        EmitLn('ldm   r0,'+S+TAB+TAB+'; increase var by 1');
                        EmitLn('addi  r0,1');
                        EmitLn('stm   r0,'+S);
                      End
                    else
                      EmitLn('ADD   ['+S+'],'+numb(N) );
                  end;
    _PutLabel   : WriteLn(Dest,S+':');
    _JumpTo     : EmitLn('jmp   '+S);
    _IfJumpTo   : Begin
                    Tmp := NewLabel;
                    EmitLn('or    r0,r0'+TAB+TAB+'; if jump to');
                    EmitLn('jnz   '+S);
                  End;

    _IfNotJumpTo: Begin
                    Tmp := NewLabel;
                    EmitLn('or    r0,r0'+TAB+TAB+'; if NOT jump to');
                    EmitLn('jz    '+S);
                  End;

    _ProgramInit: Begin
                    WriteLn(Dest,';;    C16PASCAL');
                    WriteLn(Dest,';;    Tronix (c) 2011');
                    WriteLn(Dest,'');
                    EmitLn('jmp   MAIN');
                    WriteLn(Dest,'cop:  db    "C16P"');

                    //EmitLn('db     "C16P"');
                  End;

    _ProgramExit: Begin
                    WriteLn(Dest,'_PEND:');
                    EmitLn('jmp  _PEND'+TAB+TAB+'; end program');
                  End;


    _Logical    : Begin
                    //EmitLn('cmp   r0,r1'+TAB+TAB+'; logical true');
                    EmitLn('cmpi  r0,0'+TAB+TAB+'; logical true');
                    //EmitLn('sub    r3,r0');
                    EmitLn('pushf');
                    EmitLn('pop   r3');
                    EmitLn('shl   r3,13');
                    EmitLn('shr   r3,15');
                    EmitLn('ldi   r0,0');
                    EmitLn('sub   r0,r3');
                    //EmitLn('LD      VF,1');
                  End;

    _Logical_Not: Begin
                    EmitLn('cmpi  r0,0'+TAB+TAB+'; logical false');
                    //EmitLn('ldi    r3,0'+TAB+TAB+'; logical false');
                    EmitLn('pushf');
                    EmitLn('pop   r3');
                    EmitLn('shl   r3,13');
                    EmitLn('shr   r3,15');
                    EmitLn('ldi   r0,#ffff');
                    EmitLn('add   r0,r3');
                  End;

    Greater     : Begin
                    GetStackVar;
                    EmitLn('sub   r1,r0'+TAB+TAB+'; logical greater');
                    EmitLn('pushf');
                    EmitLn('pop   r3');
                    EmitLn('shl   r3,14');
                    EmitLn('shr   r3,15');
                    EmitLn('ldi   r0,0');
                    EmitLn('sub   r0,r3');
                  end;

    Less        : Begin
                    GetStackVar;
                    EmitLn('sub   r0,r1'+TAB+TAB+'; logical less');
                    EmitLn('pushf');
                    EmitLn('pop   r3');
                    EmitLn('shl   r3,14');
                    EmitLn('shr   r3,15');
                    EmitLn('ldi   r0,0');
                    EmitLn('sub   r0,r3');
                  end;

    _PutC       : EmitLn('CALL  PUTC');

    _PutWord    : EmitLn('CALL  WriteV0');

    _PutCrLf    : EmitLn('CALL  DoCR');

    _PutString  : Begin
                    EmitLn('LEA   EDX,'+S);
                    EmitLn('CALL  WriteStr');
                  End;

  else
    Abort('Unknown ObjCode');
  end;
End;

(**********************
    Parsing Routines
 **********************)

function IsCompareOp(x : token): boolean;
begin
  IsCompareOp := x in [_equal.._not_eq];
end;

function IsAddOp(x : token): boolean;
begin
  IsAddOp := x in [_plus,_minus];
end;

function IsMulOp(x : token): boolean;
begin
  IsMulOp := x in [_mul.._or];
end;


procedure Match(x : Token);
begin
  If Current_Token <> X then
  begin
    If Ord(X) <= MaxToken then
      Expected(TokenName[ord(x)])
    else
      Abort('Unknown Token expected, compiler error!');
  end
  else
    GetToken;
end;

(*************************
    Expression Parser
 *************************)

function  Expression:integer; Forward;
function  Value:integer;
var
  kind : integer;
  tmp : string;
  cnum : integer;
begin
  kind := -1;
  If Current_Token = _lparen then
  begin
    Match(_lparen);
    kind := Expression;
    Match(_rparen);
  end
  else
  begin
    Case Current_Token of
    //If Current_Token = _name then
      _pointer:
            begin
                  IsPointer := True;
                  Match(_pointer);
                  Expression;
            end;
      _name:
          Begin
            tmp := GetName;
            last_var := tmp;
            If LookSymbol(Tmp) = _Array then
               Begin
                  Match(_begarr);
                  cnum := Current_Number;
                  Expression;
                  If Ispointer then
                        begin
                              GenCode(_LoadPointer,0,Tmp);
                              IsPointer := False;
                        end
                  Else
                        GenCode(_LoadVar,cnum,Tmp);
                  Match(_endarr);
               End
            Else
               begin
               If IsPointer then
                  begin
                        //EmitLn('LD    Iaaa,'+Tmp);
                        GenCode(_LoadPointer,0,Tmp);
                        IsPointer := False;
                        //kind := expression;
                  end
               else
                  Kind := GenCode(_LoadVar,0,Tmp);
               end;
          End;
    //else
      _numeric_constant:
      //If Current_Token = _numeric_constant then
        Kind := GenCode(_LoadConst,GetNumber,'')
      else
        Error('Error in expression');
      End; //case
  end;
end;

procedure Factor;
var
  tmp : token;
  kind : integer;
begin
  kind := Value;
  while IsCompareOp(Current_Token) do
  begin
    GenCode(_Push,kind,'');
    tmp := Current_Token;
    Match(tmp);
    Value;

    case tmp of
      _equal       : begin
                       //GenCode(_PopSub,     kind,'');
                       GenCode(_PopSub,        kind,'');
                       GenCode(_Logical,    kind,'');
                     end;
      _not_eq      : begin
                       //GenCode(_PopSub,     kind,'');
                       GenCode(_PopSub,        kind,'');
                       GenCode(_Logical_Not,kind,'');
                     end;
      _greater     : GenCode(Greater,     kind,'');
      _less        : GenCode(Less,        kind,'');
      _greater_eq  : begin
                       //GenCode(Less,        kind,'');
                       //GenCode(_Logical_Not,kind,'');
                       GenCode(Less,     kind,'');
                       GenCode(_Logical, kind,'');
                     end;
      _less_eq     : begin
                       GenCode(Greater,     kind,'');
                       GenCode(_Logical,kind,'');
                       //GenCode(Less,     kind,'');
                       //GenCode(_Logical_Not,kind,'');
                     end;
    end;
  end;
end;

procedure Multiply;
begin
  Match(_mul);
  Factor;
  GenCode(_PopMul,0,last_var);
end;

procedure Divide;
begin
//  tmp := GetName;
  writeln('TMP = ',last_var);
  Match(_div);
  Factor;
  GenCode(_PopDiv,0,last_var);
end;

procedure DoAnd;
begin
      Match(_and);
      Factor;
      GenCode(_PopAND,0,'');
end;

procedure DoOR;
begin
      Match(_or);
      Factor;
      GenCode(_PopOR,0,'');
end;

procedure DoSHR;
begin
      Match(_shr);
      Factor;
      GenCode(_PopSHR,0,'');
end;

procedure DoSHL;
begin
      Match(_shl);
      Factor;
      GenCode(_PopSHL,0,'');
end;

procedure DoMod;
begin
      Match(_mod);
      Factor;
      GenCode(_PopMOD,0,'');
end;

procedure DoXOR;
begin
      Match(_xor);
      Factor;
      GenCode(_PopXOR,0,'');
end;

procedure Term;
begin
  Factor;
  while IsMulOp(Current_Token) do
  begin
    GenCode(_Push,0,'');
    case Current_Token of
      _mul : Multiply;
      _div : Divide;
      _shr : DoSHR;
      _shl : DoSHL;
      _mod : DoMod;
      _xor : DoXOR;
      _and : DoAnd;
      _or  : DoOR;
    end;
  end;
end;

procedure Add;
begin
  Match(_plus);
  Term;
  GenCode(_PopAdd,0,'');
end;

procedure Subtract;
begin
  Match(_minus);
  Term;
  GenCode(_PopSub,0,'');
end;

Procedure DoRandom;
Begin
      //Match(_lparen);
      Expression;
      EmitLn('LD    V3,V0');
      //Match(_rparen);
End;

function Expression : integer;     { returns expression type }
var
  kind : integer;
begin
  kind := -1;
  If IsAddOp(Current_Token) then GenCode(_Clear,0,'')
                            else Term;
  while IsAddOp(Current_Token) do
  begin
    GenCode(_Push,0,'');
    case Current_Token of
      _plus   : Add;
      _minus  : Subtract;
    end;
  end;
  Expression := kind;
end;

(*************************
     Statement Parser
 *************************)

procedure Statement; Forward;

procedure SysFunction;
Var
  TS : String;
  num : integer;

begin
      Case Current_Token of
      _Random : begin
                  Match(_Random);
                  Match(_lparen);
                  num := Current_Number;
                  Match(_numeric_constant);
                  Str(num,ts);
                  Match(_rparen);
                  EmitLn('RND   V0,'+ts);
                end;
      Else
         Expression;
      End;
end;

procedure Assignment;
var
  tmp : string;
  cnum : integer;
begin
  Tmp := GetName;
  Case LookSymbol(Tmp) of
      _Void:  GenCode(_Call,0,Tmp);
      _Array: begin
                  match(_begarr);
                  cnum := Current_Number;
                  Expression;
                  GenCode(_Push,0,'');
                  match(_endarr);
                  match(_assign);
                  SysFunction;
                  //Expression;
                  GenCode(_Pop,0,'');
                  GenCode(_Store,cnum,Tmp);
              end;
      else
            begin
                  Match(_assign);
                  SysFunction;
                  //Expression;
                  GenCode(_Store,0,Tmp);
            end;
  End;
end;

procedure While_Loop;
var
  TestLabel,
  DoneLabel : LabelStr;
begin
  Match(_While);

  TestLabel := NewLabel;
  DoneLabel := NewLabel;

  GenCode(_PutLabel,0,TestLabel);
  Expression;
  GenCode(_IfNotJumpTo,0,DoneLabel);
  Match(_do);

  Statement;
  GenCode(_JumpTo,0,TestLabel);

  GenCode(_PutLabel,0,DoneLabel);
end;

procedure For_Loop;
var
  DoneLabel,
  TestLabel   : LabelStr;
  Index,Limit : String;
begin
  Match(_For);
  TestLabel  := NewLabel;
  DoneLabel  := NewLabel;

  Index := GetName;
  Limit := 'Lim'+Index;
  AddSymbol(Limit,_Long,True,0,#0);
  Match(_assign);
  Expression;  GenCode(_Store,0,Index);
  Match(_to);
  Expression;  GenCode(_Store,0,Limit);

  GenCode(_PutLabel,0,TestLabel);
  Match(_do);


  Statement;
  GenCode(_LoadVar,0,Index);
  GenCode(_Push,0,'');
  GenCode(_LoadVar,0,Limit);
{  GenCode(Greater,0,'');

  GenCode(_Logical_Not,0,''); // WARNING!!!
  GenCode(_IfJumpTo,0,DoneLabel);}

  GenCode(Less,0,'');

  GenCode(_IfNotJumpTo,0,DoneLabel);

  GenCode(_Inc_Const,1,Index);
  GenCode(_JumpTo,0,TestLabel);

  GenCode(_PutLabel,0,DoneLabel);
end;

procedure If_Then_Else;
var
  ElseLabel,
  DoneLabel  : LabelStr;
begin

  Match(_If);

  ElseLabel := NewLabel;
  DoneLabel := NewLabel;

  Expression;
  Match(_then);
  GenCode(_IfNotJumpTo,0,ElseLabel);

  Statement;

  If Current_Token = _Separator then
    GenCode(_PutLabel,0,ElseLabel)
  else
  begin

    Match(_else);
    GenCode(_JumpTo,0,DoneLabel);
    GenCode(_PutLabel,0,ElseLabel);
    Statement;
  end;

  GenCode(_PutLabel,0,DoneLabel);

end;

procedure BlockStatement;
var
  tmp : NameStr;
begin
  Match(_Begin);

  while Current_Token <> _End do
  begin
    If Current_Token = _Separator then
      GetToken
    else
      Statement;
  end;
  Match(_End);
end;

procedure VarStatement(var kind : integer);
var
  Name : NameStr;
  ArrSize : Word;
begin
    ArrSize := 0;
  Name := GetName;
  If (Current_Token = _Comma) then
  begin
    Match(_Comma);
    VarStatement(kind);
  end
  else
  begin
    Match(_Colon);
    kind := LookType(GetName);
    If Kind = 4 then
         begin //ARRAY
            Match(_begarr);
            Match(_numeric_constant);
            Match(_twodot);
            ArrSize := Current_Number*2;
            Match(_numeric_constant);
            Match(_endarr);
         end;
    If Kind = -1 then Expected('TYPE');
  end;
  AddSymbol(Name,kind,True,ArrSize,#0);
end;

procedure VarBlock;
var
  tmp  : NameStr;
  kind : integer;
begin
  Match(_Var);
  while (Current_Token = _Name) do
  begin
    VarStatement(kind);
    Match(_separator);
  end;
end;

procedure ConstStatement(var kind : integer);
var
  Name : NameStr;
      tmp,
  ArrSize : Word;
  AData : String;
  i : byte;
begin
    ArrSize := 0;
    AData := '';
  Name := GetName;
  If (Current_Token = _Comma) then
  begin
    Match(_Comma);
    ConstStatement(kind);
  end
  else
  begin
    Match(_Colon);
    kind := LookType(GetName);
    Case kind of
    1  : begin
           Match(_equal);
           tmp := GetNumber;
           adata := Chr(tmp);
         end;
    4  :
         begin //ARRAY
            Match(_begarr);
            Match(_numeric_constant);
            Match(_twodot);
            ArrSize := Current_Number;
            Match(_numeric_constant);
            Match(_endarr);
            Match(_equal);
            Match(_lparen);
            for i := 1 to ArrSize+1 do
               begin
                  tmp := GetNumber;
                  adata := adata + chr(tmp);
                  If Current_Token <> _Rparen then
                  Match(_comma);
               end;
            Match(_rparen);
         end;
    end;
    If Kind = -1 then Expected('TYPE');
  end;
  AddSymbol(Name,kind,True,ArrSize,AData);
end;

procedure ConstBlock;      //CONST
var
  kind : integer;
begin
      Match(_Const);
      while Current_Token = _Name do
      begin
         ConstStatement(kind);
         Match(_separator);
      end;
end;

procedure Repeat_Loop;
var
  Start : LabelStr;
begin
  Match(_Repeat);

  Start := NewLabel;
  GenCode(_PutLabel,0,Start);

  repeat
    If Current_Token <> _Until then
    begin
      Statement;
      Match(_separator);
    end;
  until Current_Token = _Until;

  Match(_Until);

  Expression;
//  EmitLn('LD    VF,0');
  GenCode(_Logical_Not,0,''); // WARNING!!!
  GenCode(_IfNotJumpTo,0,Start);
//  GenCode(_IfJumpTo,0,Start);

end;

{Procedure Write_Work;
Var
  sx : string;
Begin
  If Current_Token = _Lparen then
  begin
    Match(_lparen);
    Repeat
      if Current_Token = _String_Constant then
      begin
        sx := DoStringConst(Current_String);
        Match(_String_Constant);
        GenCode(_PutString,0,sx);
      end
      else
      begin
        Expression;
        GenCode(_PutWord,0,'');
      end;
      If Current_Token <> _Rparen then
        Match(_comma);
    Until Current_Token = _Rparen;
    Match(_Rparen);
  end;
End;}

Procedure Debug;
Begin
{      Match(_lparen);
      Expression;
      EmitLn('LD    V3,V0');
      Match(_comma);
      Expression;
      EmitLn('LD    V4,V0');
      Match(_comma);
      Expression;
      GenCode(_PutWord,0,'');}
      EmitLn('db    #c6,#00,#00,#00'+TAB+TAB+'; debug R0');
{      Match(_rparen);}
End;

Procedure DrawChar;
Var
      Num : Byte;
      NS,NSS : String;
Begin
      Match(_lparen);
      Expression;
      EmitLn('LD    VA,V0');
      Match(_comma);
      Expression;
      EmitLn('LD    VB,V0');
      Match(_comma);
      if current_token <> _numeric_Constant then Expected('constant');
      Num := Current_Number;
      Match(_numeric_constant);
      Match(_comma);
      Expression;
      If Num = 5 then
            EmitLn('LD    F,V0')
      else
            EmitLn('LD    HF,V0');
      Str(Num,NS);
      EmitLn('DRW   VA,VB,'+NS);
      Match(_rparen);
End;

Procedure DrawSprite;
Var
      Num : Word;
      NS : String;
Begin
      Match(_lparen);
      Expression;
      EmitLn('mov   ra,r0');
      Match(_comma);
      Expression;
      EmitLn('mov   rb,r0');
      Match(_comma);
      if current_token <> _numeric_Constant then Expected('constant');
      Num := Current_Number;
      Match(_numeric_constant);
      Match(_comma);
      If Current_Token = _pointer then
                  Expression
            else Expected('pointer');
      Str(Num,NS);
      EmitLn('spr   '+NS);
      EmitLn('drw   ra,rb,rf');
      Match(_rparen);
End;

Procedure ScrollDown;
Var
      Num : Byte;
      NS : String;
Begin
      Match(_lparen);
      if current_token <> _numeric_Constant then Expected('constant');
      Num := Current_Number;
      Match(_numeric_constant);
      Str(Num,NS);
      EmitLn('SCD   '+NS);
      Match(_rparen);
End;

Procedure DoDelay;
Var
      Num : Byte;
      NS : String;
Begin
      Match(_lparen);
      Expression;
      EmitLn('LD    DT,V0');
      Match(_rparen);
End;
Procedure DoProcedure;
Var
  ProcName : NameStr;
Begin
  Match(_Procedure);
  ProcName := GetName;
  Match(_Separator);
  GenCode(_PutLabel,0,ProcName);
  AddSymbol(ProcName,_Void,False,0,#0);
  BlockStatement;
  GenCode(_Return,0,'');
End;

procedure Statement;
begin
  Case Current_Token of
    _while  : while_Loop;
    _repeat : repeat_loop;
    _for    : for_loop;
    _if     : if_then_else;
    _begin  : BlockStatement;
{    _emit   : begin
                Match(_emit);
                Match(_lparen);
                Repeat
                  Expression;
                  GenCode(_PutC,0,'');
                  If Current_Token <> _Rparen then
                    Match(_comma);
                Until Current_Token = _Rparen;
                Match(_Rparen);
              end;}
{    _Random:  begin
                Match(_Random);
                DoRandom;
              end;}
    _Debug  : begin
                Match(_Debug);
                Debug;
              end;
{    _WriteLn: begin
                Match(_WriteLn);
                Write_Work;
                GenCode(_PutCrLf,0,'');
              end;}
    _DrawSprite: begin
                   Match(_DrawSprite);
                   DrawSprite;
                 end;
    _DrawChar: begin
                   Match(_DrawChar);
                   DrawChar;
                 end;
    _High:     begin
                   Match(_High);
                   EmitLn('HIGH');
               end;
    _Low:      begin
                   Match(_Low);
                   EmitLn('LO');
               end;
    _Cls:      begin
                   Match(_cls);
                   EmitLn('CLS');
               end;
    _ScrollLeft: begin
                   Match(_scrollleft);
                   EmitLn('SCL');
               end;
    _ScrollRight: begin
                   Match(_scrollleft);
                   EmitLn('SCR');
               end;
    _ScrollDown: begin
                  Match(_scrolldown);
                  ScrollDown;
               end;
    _Delay     : begin
                  Match(_Delay);
                  DoDelay;
                 end;
  else
    Assignment;
  end;
end;

(****************************
         Program Parser
 ****************************)
var
  ProgramName : NameStr;

procedure _Program_;
var
  tmp : NameStr;
  lib : text;
  buf : string;
  done : boolean;
begin
  If Current_Token = _Program then
  begin
    Match(_Program);
    ProgramName := GetName;
    Match(_separator);
  end;

  GenCode(_ProgramInit,0,ProgramName);

  Done := False;
  Repeat
    Case Current_Token of
      _Const     : ConstBlock;
      _Var       : VarBlock;
      _Procedure : DoProcedure;
      _Separator : Match(_Separator);
    else
      Done := True;
    End;
  Until Done;

  GenCode(_PutLabel,0,'MAIN');
  AddSymbol('Main',_Void,False,0,#0);
  BlockStatement;
  GenCode(_ProgramExit,0,'');

  WriteLn(Dest,'; ***** Library Code ***** ');

  Assign(Lib,'LIB.ASM');
{$I-}  Reset(Lib); {$I+}
  If IOresult = 0 then
  begin
    while not eof(lib) do
    begin
      readln(lib,buf);
      writeln(Dest,buf);
    end;
    close(lib);
  end;

  WriteLn(Dest,'; ***** Library Ends *****');

//  WriteLn(Dest,'_EXIT:');
//  WriteLn(Dest,'      JP   _EXIT');
  DumpSymbols;
  DumpStrings;

//  WriteLn(Dest, '; System procedures');
  WriteLn(Dest);
end;

(**************************
     Post Optimization
 **************************)

Procedure PostOptimize;
Begin
  Assign(Source,Copy(Name,1,pos('.',Name))+'ASM');
{$I-} Reset(Source); {$I+}
  If IOresult <> 0 then
  begin
    WriteLn('Error opening input file ', Copy(Name,1,pos('.',Name)),'asm');
    Halt(1);
  end;

End;

(**************************
        Main Program
 **************************)

procedure Init;
begin
  LineCount   := 0;
  LabelCount  := 0;
  SymbolCount := 0;
  StringCount := 0;
  IsPointer := False;
  Current_Stack_Num := BegReg; // V5 to V9

  TypeTable[0] := TypeInteger;
  TypeTable[1] := TypeByte;
  TypeTable[2] := TypeLong;
  TypeTable[3] := TypeVoid;
  TypeTable[4] := TypeArray;
  TypeCount    := 5;

  ProgramName := 'NONAME';
  GetChar;
  GetToken;
end;

procedure usage;
begin
  WriteLn('Usage : C8PASCAL <filename.c8p>');
  Halt(0);
end;

Var
  Err : Byte;
  F   : file;
Begin
  WriteLn('CHIP8 Pascal  Version 0.3 alpha.  Written by Sergey Naydenov (c) 2010');
  WriteLn('e-mail: tronix286@rambler.ru');
  WriteLn;
  If ParamCount = 0 then usage;
  Name := ParamStr(1);
  If Pos('?',name) <> 0 then Usage;

  Assign(Source,Name);
{$I-} Reset(Source); {$I+}
  If IOresult <> 0 then
  begin
    WriteLn('Error opening input file ',Name);
    Halt(1);
  end;

  Assign(Dest,Copy(Name,1,pos('.',Name))+'ASM');
{$I-} ReWrite(Dest); {$I+}
  If IOresult <> 0 then
  begin
    WriteLn('Error opening output file ',Copy(Name,1,pos('.',Name)),'asm');
    Halt(2);
  end;

  Init;
  _Program_;

  Close(Source);
  Close(Dest);
  WriteLn('Total of ',LineCount,' Lines processed');
  PostOptimize;
End.
