;Para512 - 512 byte paratrooper clone

;- originally it was planned as bootsector code named
;  Tiny operating system sadisticly optimized for FASM (TOSSOFF)
;- don't mind the TODOs in Slovak language
;- try to switch few constants below to turn on/off various features.
;  only change first 9, others are not always modificable
;- compiled with FASM
;- thanks to ATV for lots of optimization hints

;TODO - po int16h/1 rovno pouzit AL
;TODO - ked to bude ako bootsektor, dat grafiku na zaciatok a pristup robit po bytoch - usetri sa 5 bytov - 2 pre skok,
;       mozno ani tie ak sa kod d5obre popresuva, object handling na zaciatok a tak
;TODO - presunut X size a Y size niekam na zaciatok struktury, potom zakladnu vrazit pred pole obj ako objekt

GENERATE_HELICOPTERS = 1	; helicopters are generated
GENERATE_PARACHUTES = 1 	; parachutes are generated
COLLISION_DETECTION = 1 	; helicpoters and parachutes are destroyed on collision with bullet

GENERATE_PARACHUTES_MIDDLE = 0	; +3 bytes, parachutes are generated in the middle of helicopter, instead on the left
PARACHUTE_STOP = 1		; +10 bytes, parachutes stop on ground instead of disappearing
SMOOTH_GUN_MOVE = 1		; +1 byte, gun doesn't have two same positions at 90 degrees

ASCII_BELOW_128 = 1		; -1 byte, optimization supposing that all int16h/ah=0 codes will be below 127
PREDICT_AH_0 = 1		; -1 byte, awaits AH=0 on execution
CONSTANT_BACKBUFFER = 1 	; -3 bytes, uses constant address 90000 - 9FFFF for backbuffer

LAND_HEIGHT = 20
SKY_HEIGHT = 200 - LAND_HEIGHT

BASE_WIDTH = 25
BASE_HEIGHT = 15
BASE_X = (320-BASE_WIDTH)/2
BASE_Y = SKY_HEIGHT-BASE_HEIGHT+5 ;150
BASE_COLOR = 8

;gun consists of GUN_LENGTH squares with size 3
GUN_X = BASE_X + (BASE_WIDTH-3)/2 ;position of first (lowest) square
GUN_Y = BASE_Y - 3+1 ;used also as type for bullet, must have odd parity and be >127

;object structure
  ;WORD         y speed
  ;WORD         x speed
  ;WORD         x position
  ;WORD         y position
  ;WORD         x size (should be <127)
  ;WORD         y size (should be <127)
  ;BYTE         type: <0 - bullet, >0 odd parity - parachute, >0 even parity - helicopter
  ;unused BYTE here
  ;WORD         graphics - offset of graphic structure for this object

org 100h

  ;set 320x200x256 video mode
  if PREDICT_AH_0
    mov al,13h
  else
    mov ax,13h
  end if
  int 10h

;============================================================================;
;                            M A I N   L O O P                               ;
;============================================================================;
mainloop:

  ;------------------------------------------------------------------
  ; BP-relative addressing
  ; this trick allows us to use addressing with BP + byte sized displacement,
  ; instead of word sized immediate offset, for example "inc [some_label]"
  ; becomes "inc [bp + some_label - BPVAL]". Only usable for offsets from
  ; BPVAL-128 to BPVAL+127
  BPVAL = 1B0h ;ideal value found by trying
  mov bp, BPVAL

;---------;
; DRAWING ; (and timer...)
;---------;
  ;------------------------------------------------------------------
  ;ES = framebuffer  (backbuffer, whatever you call it)
  if CONSTANT_BACKBUFFER   ;TODO - ES = screen backbufer
    push word 9000h
    pop es
  else
    mov ax,cs
    add ax,1000h
    mov es,ax
  end if

  ;------------------------------------------------------------------
  ;draw backgrouund
  xor di,di
  mov al,1				;TODO - v timeri xor ax,ax, hore pouzit iny register a tu zostane 0, potom len inc
  mov cx, SKY_HEIGHT*320		;TODO - optimalizacia - vrazit konstantu do CH, aby prechod bol za zakladnou,
					;je vcelku tazke si to vsimnut. ale CL sa meni casom :) takze to asi nepjde
					;jedine ze by sa timer drbol inde
  rep stosb
  inc ax
  mov ch,(LAND_HEIGHT*320) shr 8
  rep stosb
  push di				;di = 320*200 (+ little more), used for CX value when moving backbuffer to video ram

  ;------------------------------------------------------------------
  ;draw base
  ;TODO - presunut do objektov pred prvy objekt "dw base", potom vo vykreslovacom cykle prehodit cast od
  ;       "mov bx, [si+8]" na zaciatok cyklu aby sa to vykreslilo, bude treba pridat mov di na zaciatok
  ;CH = 0
  mov ax,_base
  mov di,BASE_X + BASE_Y*320
  call draw_item

  ;------------------------------------------------------------------
  ;draw objs
  ;CH = 0
  mov si,obj+4-14 ;x coordinate is at offset 4, 14 is added at beginning of looop
draw_next_object:
  add si,14 ;we advance SI inside loop by 2 bytes, object has 16bytes, 16-2=14 :-]
  cmp si,[bp + objend - BPVAL]
  ja end_draw_object
  lodsw ;x coordinate
  imul di,[si],320 ;[si]=y coordinate
  add di,ax			;di = y*320 + x

  mov ax, [si + 8]		;graphic of object (set at creation)
  call draw_item

  jmp draw_next_object
  ;angle table - sin:cos (y:x) values are packed in byte (4:4 bits respectively)
  ;table is here because it can be addressed using one-byte-shorter BP relative
  ;addresation [bp+angletab-BPVAL] here
  angletab db 1bh,2bh,3bh,4ah,5ah,69h,79h,78h,87h,97h,96h,0a5h,0a4h,0b3h,0B2h,0b1h
end_draw_object:

  ;------------------------------------------------------------------
  ;timer
  ;AL = 0  (AL left 0 by draw_item)
  cbw ;mov ah,0
timer_wait:
  int 1Ah ;AL= 24 hours overflow flag, CX:DX = 32bit timer
  cmp dl,byte 0
  label time byte at $-1
  jz timer_wait
  mov [bp+time-BPVAL],dl

  ;------------------------------------------------------------------
  ;draw gun
  ;CX = 0 (doesn't??? but it works anyway...), DH = 0
  ;simple line algorithm, sorry, lazy to explain :P
  ;PS: find "_gunbox" to make gun just a one-pixel wide
  ; TODO - prehodit sin a cos, movzx bx..., namiesto BH pouzit SI
  mov si,word 15
  label angle byte at $-2

  mov al,byte [bp + angletab-BPVAL + si]
  aam 10h 
  movzx dx,al	  ;DL = low 4 bits (x gun size), DH=0 (counter of y overlap) 
  xchg ax,bx	  ;BH = y size (counter of Y loops) 
  mov bl,bh	  ;BL = high 4 bits (y gun size)

  mov di,GUN_Y*320 + GUN_X
__y:
  add dh,dl

__x:
  push di
  mov ax, _gunbox
  call draw_item
  pop di
  cmp dh,bl
  jbe @f

  sub dh,bl
  add di,word +1
  label dir word at $-2 ;direction of gun, -1 = left, +1 = right
  jmp __x
@@:
  sub di,320
  dec bh
  jnz __y

  ;------------------------------------------------------------------
  ;draw backbuffer to video ram
  ;[sp]=320*200 (left by background drawing routine)
  pop cx	      ;pushed DI after drawing background into backbuffer
  push ds es 0A000h
  pop es ds
  xor di,di
  xor si,si
  rep movsb
  pop ds

  ;------------------------------------------------------------------
  ;change segment registers back to CS=DS=ES
  push ds
  pop es

  ;------------------------------------------------------------------
  ;set DI to point to end of object table
  mov di,word obj ;initially, object table is empty
  label objend word at $-2 ;same as if there was "objend dw obj" in data

;--------------;
; KEY_HANDLING ;
;--------------;
  ;------------------------------------------------------------------
  ;check keypress
  mov ah,1
  int 16h
  jz no_key

  ;------------------------------------------------------------------
  ;get key from BIOS' keybuffer
  if ASCII_BELOW_128
    cbw
  else
    mov ah, 0
  end if
  int 16h
  cbw

  ;------------------------------------------------------------------
  ;ESC 
  cmp al, 27
  jnz @f
  ret
  @@:

  ;-----------------------------------------------------------------
  ;check left key 
  mov cl,byte [bp+dir-BPVAL] 
  sub al,'k'-1
  jz change_gun_angle

  ;-----------------------------------------------------------------
  ;NUM5 - fire (create bullet object)
  ;DL = gun x (cos(angle)*bullet_velocity), BX = gun y (sin(angle)*bullet_velocity), these remain from gun drawing routine
  ;DI = pointer to end of object array
  dec ax
  jnz @f
  ;create new bullet    AX = 0
  sub ax,bx
  inc ax
  stosw ;bullet.spdy
  movzx ax,dl
  dec ax
  mul [bp+dir-BPVAL]
  stosw ;bullet.spdx
  mov ax,GUN_X
  stosw ;bullet.x
  mov al,GUN_Y
  stosw ;bullet.y
  stosw ;sizes doesn't matter
  stosw
  stosw ;object.type (GUN_Y = <0 odd)
  mov ax, _bullet
  stosw ;graphic = bullet
@@:

  ;-----------------------------------------------------------------
  ;check RIGHT key
  ;CL = [dir]
  dec ax
  jnz no_key
  neg cl

  ;-----------------------------------------------------------------
  ; change gun angle by value in CL
  ; CL = +1 or -1
change_gun_angle:
  mov al,[bp+angle-BPVAL]
  add al,cl
  jns @f ;check lower bound, [angle] cannot go under 0
  inc ax
@@:
  cmp al,15 ;check upper bound, if above 15 change dir and put back to 15
  jna @f
  neg [BP+dir-BPVAL]
  dec ax ;set angle back to 15
  if SMOOTH_GUN_MOVE ;to 14 for "smooth" moving
    dec ax
  end if
@@:
  mov byte [BP+angle-BPVAL],al

;no (more) keys pressed
no_key:

;-------;
; LOGIC ;
;-------;

  ;-----------------------------------------------------------------
  ;generate helicopters
  ;DI = pointer to end of object array
if GENERATE_HELICOPTERS

  ; switch helicopter generating direction and side of screen where they appear
  neg [bp+helicopter_dir-BPVAL]
  xor [bp+helicopter_x-BPVAL],290

  ; check whether to generate helicopter
  rdtsc
  and ax,00111111b ;AX = 0
  jnz @f

  ; create object
  stosw 			;spdy = 0
  mov ax,word 2
label helicopter_dir word at $-2
  stosw 			;spdx = +2 / -2
  mov ax,word 0
label helicopter_x word at $-2
  stosw 			;x = 0 / 290
  mov ax,word 0
label helicopter_y byte at $-2
  add al,10
  stosw 			;y = 10 + (0 to 111111b)
  mov al,23
  stosw 			;x size = 23
  mov al,12 ;1100b
  stosw 			;y size = 12
  stosw 			;type = 12 = 1100b  >0, even parity
  mov ax, _helicopter
  stosw 			;graphics = _helicopter
  jmp after ;TODO - premiestnit _helicopter tak aby dolny byte offsetu bol mensi ako 111111b

;moved here to save 2 bytes - thx to ATV
;this is called after object handling loop ends
end_objects:
  ;save offset of end of object array
  mov [objend],di
  ;continue main loop
  jmp mainloop

@@:

  mov [bp+helicopter_y-BPVAL],al ;may cause helicopter to be created at 10+(_helicopter and 0xFF), if one was
			;created in previous loop, but it's unlikely
			;TODO - move _helicopter to offset 0 to 111111b
after:
end if

  ;-----------------------------------------------------------------
  ; make winch flashing
  mov si, obj ;for object handling, but here we can use SI - relative addressing with byte immediate to save 2 bytes
  if (obj-_helicopter) >= 128  ;check if we really can use byte immediate
    'a kurva....' ;generate error
  end if
  xor byte [si - obj + _helicopter.winch], 12

  ;-----------------------------------------------------------------
  ; handle objects
  ; SI = pointer to beginning of object arrat
  ; DI = pointer to end of object array
next_object:
  cmp si,di
  jae end_objects
  lodsw ;y speed
  add [si+4],ax 		;advance y coordinate
  lodsw ;x speed
  add [si],ax			;advance x coordinate
  lodsw ;x coordinate
  xchg dx,ax			 ;DX = x coordinate
  lodsw ;y coordinate
  xchg bx,ax
if COLLISION_DETECTION
  lodsw ;x size
  xchg bp, ax			 ;BP = x size
  lodsw ;y size
  xchg cx, ax			 ;CX = y size
else
  lodsw
  lodsw
end if
  lodsd ;lodsw / add si, 2      ;AX = type, skip graphics

  ;-----------------------------------------------------------------
  ; destroy object if it's outside screen (not exactly...)
  ; ax = type, dx = x, bx = y
  or bh, bh	     ;if y_coordinate > 256
  jnz remove_object
  cmp dx, 299	     ;if x_coordinate > 299    299 = 320 (screen x size) - 21 (helicopter x size)
  ja remove_object

  ;-----------------------------------------------------------------
  ; check type
  cmp al,0
  jl next_object	; <0                    - bullet
  jnp .parachute	; >0 odd parity         - parachute
			; >0 even parity        - helicopter
  ;-----------------------------------------------------------------
  ; helicopter
.helicopter:

  if GENERATE_PARACHUTES

  ;-----------------------------------------------------------------
  ; generate parachute?  1:64 chance
  push dx
  rdtsc
  pop dx
  and ax, word 00111111b ;sets AH to 0
  jnz check_collision

  ;-----------------------------------------------------------------
  ; create parachute object
  ; AH=0, DX:BX = x:y coordinates
  inc ax
  stosw 		;y speed =   1
  dec ax
  stosw 		;x speed =   0
  mov ax, dx
  if GENERATE_PARACHUTES_MIDDLE
    add ax, 10
  end if
  stosw 		;x coordinate = helicopter's x coordinate (+10 if GENERATE_PARACHUTES_MIDDLE)
  mov ax, bx
  stosw 		;y coordinate = helicopter's y coordinate
  mov al, 13
  stosw 		;x size = 13
  stosw 		;y size = 13
  stosw 		;type = 13 = 1101b, eg. >0 odd parity
  mov ax, _parachute
  stosw 		;graphic = _parachute
  end if

  ;jmp check_collision ;BL (y coordinate) is always below 181 for helicopter, so we can skip over following code

  ;-----------------------------------------------------------------
  ; parachute
.parachute:

  ;-----------------------------------------------------------------
  ; if parachute is at the ground (y>180) then stop or disappear, according to PARACHUTE_STOP)
  ; SI = this object + 16  (eg. following object)
  cmp bl,181
  if PARACHUTE_STOP
    jb check_collision
    if (_parachute shr 8) <> (_man shr 8)
      'Jebal to hroch!!!' ;generate error
    end if
    mov byte [si-2], _man and 0FFh	;graphics = _man (without his parachute)
    mov byte [si-16], 0 		;y speed = 0 (previously it was 1 or 0, so overwriting lower byte is enough)
  else
    jnb remove_object
  end if

  ;-----------------------------------------------------------------
  ; common collision checking for parachute and helicopter
check_collision:

  if COLLISION_DETECTION
    push si
    mov si, obj+4-12-2
  .next1:
    lodsw		;TODO moze sa odstranit, ale treba generovat helikoptery tak, ze Y suradnica je > 13 (PARACHUTE_SIZE),
			;potom skakat na test typu, ktory urobit ako lodsw/cmp al, a tym padom vzdy nevyjde a posunie sa to
  .next2:
    add si, 12
    cmp si, di
    ja .loopdone
    lodsw
    sub ax, dx
    jl .next1
    sub ax, bp
    jge .next1
    lodsw
    sub ax, bx
    jl .next2
    sub ax, cx
    jge .next2
    cmp byte [si],GUN_Y
    jne .next2
  .loopdone:		;if we jump here from "ja .loopdone" then ZF=0, if we continue from "jne .next2" then ZF=1
    pop si
    jne next_object	;so if loop is done we go to next object handling, if collision was detected we continue to remove_object
  else
    jmp next_object
  end if

  ;-----------------------------------------------------------------
  ; remove object - eg. overwrite object at [si-16] with object at [di-16]
  ; and continue with handling this object (which was on DI and is now at SI)
  ; CH=0
remove_object:
  mov cl,16
  sub si,cx
  sub di,cx
  pusha ;push si di
  xchg si,di
  rep movsb
  popa ;pop di si
  jmp next_object



;-----------------------------------------------------------------
;draw_item
;args:
;  AX = pointer to graphics (see further)
;  DI = screen pointer to beginning of first box
;  CH = 0
;ret:
;  BX,SI,BP,DX preserved
;  AH,CX,DI trashed (DI depends on value behind ending "db 0")
;  AL < 7Fh
draw_item:
  push si
  xchg si,ax
.box:
  lodsw
  mov cl,al
  lodsb
.boxline:
  push cx
  rep stosb
  pop cx
  add di,320
  sub di,cx
  dec ah
  jnz .boxline
  lodsw
  add di,ax
  or al,al
  jnz .box
  pop si
  retn

;-----------------------------------------------------------------
;graphics - graphics of object is just set of boxes
;each described like this:
; BYTE x-size of box
; BYTE y-size of box
; BYTE color of box
; WORD displacement - where does next box start, 320*y + x
; in last box, there is no displacement word, instead there is a byte
; with value 0

_parachute db 6,2,15		;parachutist
	   dw (-3*320)+1
	   db 4,1,15
	   dw (+3*320)+1
_man	   db 2,6,6		;since here it's man graphics
	   dw (-4*320)-1
	   db 4,1,6
	   db 0

_gunbox db 3,3,7		;one box of gun (gun is draw as "line" composed from these boxes)
	db 0			;change "3,3" to "1,1" to see result of my line drawing algortihm

_bullet db 1,1,15		;bullet - just simple pixel, but it's smaller this way
	db 0

_helicopter:			;quess what
	db 18,5,4
	dw (-6*320)+2
	db 14,7,4
	dw (-5*320)+8
	db 4,5,0
 .winch:
	dw (-8*320)-13
	db 12,1,7
	db 0

_base db BASE_WIDTH,BASE_HEIGHT,BASE_COLOR   ;25, 15, 8
      db 0

;TODO - brutal napad - nejako odjebat tie "db 0", tak ze prvy byte obrazku budw mat nejaku
; specialnu vlastnost, ktoru nebude mat ziadny dolny byte displacementu, a v draw_item sa
; bude testovat. ale treba si predpocitat displacementy


;object array starts here
align 16 ;aligned for no reason
obj: