// SEGA 32X 256-color example in C
// Mic, 2008

#include <stdlib.h>
#include "32x.h"

/* Create a 5:5:5 RGB color with the MSB set */
#define COLOR(r,g,b)    (((r)&0x1F)|((g)&0x1F)<<5|((b)&0x1F)<<10|0x8000)

const s16 sintb[] = {0,7,15,23,31,39,46,54,61,69,76,84,91,98,105,112,118,125,131,137,143,
149,155,160,165,170,175,180,184,188,192,196,199,202,205,208,211,213,
215,217,218,220,221,221,222,222,223,222,222,222,221,220,219,217,216,
214,212,210,208,206,203,200,198,195,192,188,185,182,178,175,171,167,
163,160,156,152,148,144,140,136,132,128,124,120,116,112,108,104,100,
96,93,89,85,82,78,75,71,68,65,62,59,56,53,50,47,44,42,39,37,34,32,30,
28,26,24,22,20,18,16,14,12,11,9,7,6,4,3,1,0,-2,-4,-5,-7,-8,-10,-12,
-13,-15,-17,-19,-21,-23,-25,-27,-29,-31,-33,-35,-38,-40,-43,-45,-48,
-51,-54,-56,-59,-63,-66,-69,-72,-76,-79,-83,-86,-90,-93,-97,-101,-105,
-109,-113,-117,-121,-125,-129,-133,-137,-141,-145,-149,-153,-157,-160,
-164,-168,-172,-175,-179,-183,-186,-189,-192,-196,-198,-201,-204,-207,
-209,-211,-213,-215,-217,-218,-220,-221,-222,-223,-223,-223,-224,-223,
-223,-222,-222,-221,-219,-218,-216,-214,-212,-209,-207,-204,-200,-197,
-193,-189,-185,-181,-176,-171,-166,-161,-156,-150,-144,-138,-132,-126,
-119,-113,-106,-99,-92,-85,-78,-70,-63,-55,-47,-40,-32,-24,-16,-9};


int main()
{
	uint16 currentFB=0;
	uint16 lineOffs;
	vu16 *frameBuffer16 = &MARS_FRAMEBUFFER;
	vu8 *frameBuffer8 = (vu8*)&MARS_FRAMEBUFFER;
	vu16 *palette = &MARS_CRAM;
	int fbOffs;
	int d,i,j;
	uint8 d2,d3;
	int16 p;

	// Wait for the SH2 to gain access to the VDP
	while ((MARS_SYS_INTMSK & MARS_SH2_ACCESS_VDP) == 0) {}

	// Set 8-bit paletted mode, 224 lines
	MARS_VDP_DISPMODE = MARS_224_LINES | MARS_VDP_MODE_256;

	MARS_VDP_FBCTL = currentFB;

	// Set up the palette
	for (i=0; i<64; i++)
	{
		palette[i] = COLOR(i>>1,0,i>>1);
		palette[i+64] = COLOR(31,i>>1,31);
		palette[i+128] = COLOR(31,31,31-(i>>1));
		palette[i+192] = COLOR(31-(i>>1),31-(i>>1),0);
	}

    for(;;)
    {
		// Flip the framebuffer selection bit and wait for it to take effect
		MARS_VDP_FBCTL = currentFB ^ 1;
		while ((MARS_VDP_FBCTL & MARS_VDP_FS) == currentFB) {}
		currentFB ^= 1;

		// Set up the line table
		lineOffs = 0x100;
		for (i=0; i<256; i++)
		{
			frameBuffer16[i] = lineOffs;
			lineOffs += 160;
		}

		fbOffs = 0x200;
		for (i=0; i<224; i++)
		{
			for (j=0; j<320; j++)
			{
				p = ((i + (sintb[(j+(i>>1)+d)&255]>>4)) ^ (j + (sintb[(i+d)&255]>>4))) & 63;
				p += sintb[(d2+i+j)&255];
				p += sintb[(d3+j)&255];
				p += sintb[(d2+d3+i+j)&255];
				frameBuffer8[fbOffs++] = (p>>2);
			}
		}
		d += 2;
		d2 += 2;
		d3 -= 1;
     }

	return 0;
}
