.286
.model small
.stack 200h
dataseg

include font_mus.inc      ;Vibrants Music Player
include font_fnt.dmp      ;0-9 !"#$%'()*+-./ A-Z ..... Font
include font_pal.dmp      ;Color Map
include font_lin.dmp      ;Two Lines
include font_txt.inc

sine_wave label byte
include font14.sin

twoline dw 320
blank_  dw 2
char_x  dw 8           ;char width
char_y  dw 10          ;char height  
x_out   dw 0           ;output X pos       (0-319)
sine_   dw 0
y_out   dw 0           ;output Y pos       (0-199)
pic_x   dw 320         ;Width of Picture.. eg (320x200) = 320 wide
lines_  dw ?           ;For looping text 
change  dw 0           ;When to Change Text lines
line_o  dw 0           ;Offset of New line
text_x  dw 0           ;Text Variable
text_o  dw 0           ;Text Offset
no_vga  db 'Sorry This Loader needs VGA!$'
end_txt db 'All Programming by Earwax/Myst in ''95',10,13
        db 'Music+Player By Vibrants$'
pal_dat db 5*3 dup (0) ;Fading Data

tmp_pal db 768 dup (0)
fadepal db 768 dup (0)

ends

picsegm segment
picdata label byte
include vtbbsro.pic

palette label byte
include vtbbsro.pal
ends

codeseg

proc    main_program
        mov     ax,@data
        mov     ds,ax

        mov     ax,4a00h
        mov     bx,1000h
        int     21h

        mov     ax,0013h
        int     10h
        mov     ah,0fh
        int     10h
        cmp     al,13h
        jz      tis_cool_we_have_vga
        mov     ah,9
        lea     dx,no_vga
        int     21h
        mov     ax,4c00h
        int     21h

tis_cool_we_have_vga:

;------ Detect Adlib ----------- Start
        mov      ax,@data           
        mov      cs:player[2],ax
        mov      ah,6
        call     playmusic
        jnc      no_card_present
        mov      byte ptr cs:[playm],0C3h 
no_card_present:
        mov      ah,0               
        mov      bx,@data
        mov      cx,2390
        call     playmusic
        mov      ah,2
        mov      bx,0
        call     playmusic
;------ Detect Adlib ----------- End        

        lea     si,paldata
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,256*3
load_pal:
        mov     al,[si]
        out     dx,al
        inc     si
        loop    load_pal

        mov     cx,5*3
        mov     ax,ds
        mov     es,ax
        lea     si,paldata
        lea     di,pal_dat
        rep     movsb

        mov     ax,0a000h
        mov     es,ax

;---- Load picture at top
        push    ds

        mov     ax,picsegm
        mov     ds,ax
        
        lea     si,palette
        mov     dx,3c8h
        mov     al,128
        out     dx,al
        inc     dx
        mov     cx,128*3
load_picture_pal:
        mov     al,[si]
        out     dx,al
        inc     si
        loop    load_picture_pal

        pop     ds

        call    save_palette

        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,768
black_loop:
        xor     al,al
        out     dx,al
        loop    black_loop

        push    ds

        mov     ax,picsegm
        mov     ds,ax

        lea     si,picdata
        mov     cx,320*125
        xor     di,di
load_picture:
        mov     al,[si]
        cmp     al,2
        jnz     draw_ok
        mov     al,19
draw_ok:       
        cmp     al,1
        jnz     draw_ok_
        add     al,17
draw_ok_:
        cmp     al,4
        jnz     draw_ok__
        mov     al,18
draw_ok__:
        mov     es:[di],al
        inc     si
        inc     di
        loop    load_picture

        pop     ds

        mov     cx,63
fade_in_all:
        push    cx
        call    fade_all_in
        call    vertical
        mov     ah,3
        call    playmusic
        pop     cx
        loop    fade_in_all

        mov     cx,50h
delay_one:
        call    vertical
        push    cx
        mov     ah,3
        call    playmusic
        pop     cx
        loop    delay_one

        mov     cx,320/2+30
scroll_lines:
        pusha
        call    draw_lines
        call    vertical
        mov     ah,3                ; play music
        call    playmusic
        popa
        loop    scroll_lines

        mov     cx,63
fade_in_scroller_at_start:
        push    cx
        call    fade_out_scroller
        pop     cx
        loop    fade_in_scroller_at_start


        mov     ax,lines
        mov     lines_,ax
sine_draw:                
        sti
        cmp     lines,0
        jnz     keep_on_going
        mov     line_o,0
        mov     change,0
        mov     ax,lines_
        mov     lines,ax
keep_on_going:        
        push    sine_
        inc     change
        mov     x_out,0        
        mov     ax,line_o
        mov     text_o,ax
        call    load_bitmap
        call    vertical
        cmp     sine_,400*3-85
        jb      okey
        mov     sine_,0
        jmp     okey2
okey:
        pop     sine_
okey2:
        add     sine_,8
        cli
        mov     ah,3                ; play music
        call    playmusic
        sti
        cmp     change,400
        jnz     okey3
        mov     ax,text_o
        mov     line_o,ax
        mov     change,0
        dec     lines
okey3:
        cmp     change,400-63
        jb      dont_start_out
        call    fade_out_scroller
dont_start_out:
        cmp     change,63
        ja      dont_fade_in
        call    fade_in_scroller
dont_fade_in:
        cli
        in      al,60h     
        cmp     al,1       
        jz      dos
        jmp     sine_draw

dos:        
        mov     cx,63
fade_out_end:
        push    cx
        call    fade_out_scroller
        call    vertical
        mov     ah,3
        call    playmusic
        pop     cx
        loop    fade_out_end

        call    save_palette

        mov     cx,64
end_fade:
        push    cx
        call    fade_all_out
        call    vertical
        mov     ah,3
        call    playmusic
        pop     cx
        loop    end_fade

        mov     ah,2
        mov     bx,0
        call    playmusic              ; Stop Music
        
        mov     ax,0003h
        int     10h

        mov     ah,9
        lea     dx,end_txt
        int     21h

        mov     ax,4c00h
        int     21h

endp    main_program

PlayMusic proc near

PlayM     label  near
          nop
          call   dword ptr cs:[player]
          cli
          ret

Player    dw     0,0

PlayMusic ENDP

proc    load_bitmap   ;Sine Wave text Scroller
start_of_proc:
        xor     di,di

        lea     si,sine_wave
        mov     bx,sine_
        mov     cx,[si+bx]
        add     cx,2

y_coor:
        add     di,320
        loop    y_coor
        
        add     di,x_out

        mov     cx,blank_
d2:      
        push    cx
        mov     cx,char_x
d3:
        xor     al,al
        mov     es:[di],al
        inc     di
        loop    d3
        
        add     di,320
        sub     di,char_x
       
        pop     cx
        loop    d2


        lea     si,text
        add     si,text_o
        add     text_o,2
        mov     ax,[si]
        cmp     ax,0
        jnz     t2
        ret
t2:
        sub     ax,32
        mov     text_x,ax

        lea     si,fontdata
        cmp     text_x,40
        jb      no_offset
        add     si,320*9
no_offset:        
        mov     cx,text_x
        cmp     cx,0
        jz      t1

offset_of_char:
        add     si,8
        loop    offset_of_char
t1:
        mov     cx,char_y
        dec     cx
a1:      
        push    cx
        mov     cx,char_x
a2:
        mov     al,[si]
        mov     es:[di],al
        inc     di
        inc     si
        loop    a2

        add     di,320
        sub     di,char_x
        add     si,pic_x
        sub     si,char_x

        pop     cx
        loop    a1

        mov     cx,blank_
d4:      
        push    cx
        mov     cx,char_x
d5:
        xor     al,al
        mov     es:[di],al
        inc     di
        loop    d5
        
        add     di,320
        sub     di,char_x
       
        pop     cx
        loop    d4

        add     x_out,8
        add     sine_,8
        jmp     start_of_proc
endp    load_bitmap

proc    vertical
        mov     dx,3dah
r1:     in      al,dx
        test    al,8
        jz      r1
r2:     in      al,dx
        test    al,8
        jnz     r2
        ret
endp     vertical        

proc    draw_lines
        cmp     twoline,0
        jz      dont_take
        mov     ax,320
        mov     bx,129
        imul    bx
        add     ax,twoline
        mov     di,ax
        lea     si,linedata
        mov     cx,320
draw_top_line:
        cmp     di,41600
        jae     dont_draw_line_no_more
        mov     al,[si]
        mov     es:[di],al
        inc     di
        inc     si
        loop    draw_top_line

dont_draw_line_no_more:
        
        xor     dx,dx
        mov     bx,196
        mov     ax,320
        imul    bx
        sub     ax,twoline
        mov     di,ax
        
        mov     cx,320
        lea     si,linedata
draw_bottom_line:
        cmp     di,62400
        jbe     draw_no_more
        mov     al,[si]
        mov     es:[di],al
        dec     di
        inc     si
        loop    draw_bottom_line
draw_no_more:
        sub     twoline,2
dont_take:
        ret
endp    draw_lines

proc    fade_out_scroller
        lea     si,pal_dat
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,5*3
fade_bit:
        mov     al,[si]
        cmp     al,0
        jz      no_fade
        dec     al
        mov     [si],al
no_fade:
        out     dx,al
        inc     si
        loop    fade_bit
        ret
endp    fade_out_scroller

proc    fade_in_scroller
        push    es
        mov     ax,ds
        mov     es,ax
        lea     si,pal_dat
        lea     di,paldata
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,5*3
fade_in_bit:
        mov     al,[si]
        mov     ah,[di]
        cmp     al,ah
        jz      no_fade_in
        inc     al
        mov     [si],al
no_fade_in:
        out     dx,al
        inc     di
        inc     si
        loop    fade_in_bit
        pop     es
        ret
endp    fade_in_scroller

proc    save_palette
        lea     si,tmp_pal
        mov     dx,3c7h
        xor     al,al
        out     dx,al
        mov     dx,3c9h
        mov     cx,768
save_loop:
        in      al,dx
        mov     [si],al
        inc     si
        loop    save_loop
        ret
endp    save_palette

proc    fade_all_in             ;Has 2 be called 63 times assume 256 all = 0
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        lea     si,tmp_pal
        lea     di,fadepal
        mov     cx,768
        inc     dx
fade_all:
        mov     ah,[si]
        mov     al,[di]
        cmp     ah,al
        jz      no_fade_in_
        inc     al
        mov     [di],al
no_fade_in_:
        out     dx,al
        inc     si
        inc     di
        loop    fade_all
        ret
endp    fade_all_in

proc    fade_all_out
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        lea     si,tmp_pal
        mov     cx,768
fade_all_out_loop:
        mov     al,[si]
        cmp     al,0
        jz      no_fading
        dec     al
        mov     [si],al
no_fading:
        out     dx,al
        inc     si
        loop    fade_all_out_loop
        ret
endp    fade_all_out
ends
end
