
	;Enable these to alter functions

;Debug equ 1		; enable debugging options
;SingleDisk equ 1 	; Disables Disk messages
;ReadOnly equ 1   	; Disable Disk writes - For Cartridge versions!




	; Enable Support64k and Support128k for a core that supports everything
	; Support64k or Support128k for a core that supports one
	;but DO NOT UNTICK BOTH OF THESE AT THE SAME TIME, or you will get
	;a core that supports nothing! also and remember
	;the game will crash if run on a 64k machine with no 64k support
	; or 128k machine with no 128k support (unless CPCVer is set to 64 of course!)

Support64k equ 1  ; enable code only needed by 64k
Support128k equ 1 ; enable code only needed by 128k+ (keep enabled for 256/512k etc)


	;This can be used with or without the two options above
SupportPlus equ 1 ; enable code only needed by CPC Plus


;MinimizeCore equ 1 ; Reduce size of the core at the cost of speed - works on 64k or 128k
		    ; If you have spare space, enable this, if you don't disable it!


	;This no-loger works, I had to remove too many files from disk 2 to remove disk 3
;AllowDisk2 equ 1	;skip optional stuff on disk 1 (allowed starting at level 5 for testing - not useful any more)




ifndef Support128k		;Check some Obakasan didn't ignore my warning above!
	ifndef Support64k 
		Support64k equ 1
	endif
endif



;                                                  ``.......`  ```...;;;;.             
;                                     `#@@@@@@@###++';;;;;;;;;;;.....`                 
;                                      `             ''`     .`                        
;                                                   `+'     ;'.                        
;                                            `'##';`.++`  ;#@@@#@#+';,                 
;                                           +,      .##`    '+.    `;@@;               
;                                          '@'      `++`   `++.,'#@@@@;                
;                                          ,'#@@@@@@@@@@@@@@@@@@@#'.                   
;                                                   #@'    ,#'                         
;                                               ,#@@@; .+@@@#`                         
;                                     .;'#@@@@@@@@@@@@@@@@+;;;,...,;;'+++'.            
;                             `;;;;''+##++'''''''';;;;'';;;;;;,,,,..`                  
;                                             +@@@#.     ,.                            
;                                           '@;`#@;     `;#;         ..                
;                                         `#+` '@@;      ;@+          ,;+.             
;                                        ;@;   ;@@#`    ;@@#.           ;@'            
;                                      ,@'      '@@'    ,',     ,#+`    '@@.           
;                                  `;;.          ;#@@#;..;'#@@@@#.     ,#@+`           
;                       `;,      ;+.              ;'#@@@@+;,,`                         
;                       ,+;     ++,;;;'###+'+###+,                                     
;                       '@;    .+@@@@###',`,#,                                         
;                      ;@+`                '#,                                         
;                 `+@##@@@@@@@@@#`         +@;                                         
;                      ;@'   `+@@,        .@@+`              Akuyou Game Engine                      
;                     `+@;   ,@@@,        ,@@+`              Version 1.06        
;                     .@@;  `#@@+'@@@@@@@#'@@+```                                      
;                    `#@;   `#@@;        `;@@#....,.``                     
;                   `#@+    .@@@;         +@@#,                                        
;                   '@#`    '@@#,        ;@@#@+`      Akuyou@ChibiAkumas.com                                 
;                  `+@@@#;`;@@@;         +@@;+@+                                       
;                   ..;'+@@@@@+`        `@@+ .'@@,                                     
;                        `#@@@@@;`      #@#`   ;+@+`                     ````          
;                       .@@@'`.,;,`   .@@#.     `;+@;             .+@@@@#+'+#@@#,';    
;                     `#@@@;       `+@@@;          ;;#;       `#@@@'` .@@@@'``'@++@@@' 
;                 `+@@@@@@#,    ;@@@@;               `,.` `'@@@@;     +@@@#,  `;`;@@@#.
;               `#@@@@@#';....'@@#;                   ,#@@@@;         +@''#@@#@@@@;;##`
;            .;;,.`           `;'+#@@@@@@@@@@##@@@@@@@#'.             +@;  ;'@+`   ,##`
;                                       `........`                    +@;   ;@+`   ,##`
;                                                                     +@@;  ;@+`  ,@@+`
;                                                                      ;+@@@'@##@@@;   
;                                                                        `;+@@@;`      

;The source code to this game is Creative Commons Licenced under "
; Please see creativecommons.org/licenses/by-nc/4.0/

;You are free to use or modify the code in any way you wish.

;The games main "Hero" character "Chibiko Akuma" is Copyright 2016 Keith Sear - all rights reserved
;You are permitted to freely distribute the graphics files within this game with the, however you are not permitted
;to use these characters in your own works, or derivative works without prior permission

;Please contact me if you wish to reuse the characters - permission will be granted free of charge
; provided derivitive / new works maintain the style of these characters.

;You are welcome to remove this character and distribute your own alternate version of the game.
;Note this does not apply to the level enemies or boss characters , these are all licensed with the same Creative commons
;license as the source code.

; Akuyou means 'Misuse' in japanese - it refers to a total misuse of time, such as writing games for a 30 year old computer!
; the game engine name should be written in japanese with the Kanji Aku (bad) You (from yousei - fairy spirit)


read "BootStrap.asm"
nolist
SprShow_X equ SprShow_X_Plus1-1
SprShow_Y equ SprShow_Y_Plus1-1
SprShow_BankAddr equ SprShow_BankAddr_Plus2-2   ; 
SprShow_SprNum equ SprShow_SprNum_Plus1-1

ObjectArray_Size equ ObjectArray_Size_Plus1-1

ObjectArrayAddress equ ObjectArrayAddress_Plus2-2

Timer_TicksOccured equ Timer_TicksOccured_Plus1-1


;***************************************************************************************************

;					Main Project Code

;***************************************************************************************************




org &A00



;StarArraySize equ 255

;StarY.....,StarX.....,StarMovement.....





limit &A500
org &8000
jp ShowSprite		;8000
jp ExecuteBootStrap	;8003
jp LoadDiscSector	;8006
jp StarArray_Redraw     ;8009
jp SetLevelTime ;	;800C
jp Player_Handler	;800F

jp Background_Clear	;8012

jp objectArray_Redraw   ;8015
jp Event_Stream		;8018
jp Player_StarArray_Redraw ;801B

jp PLY_Init		;801E
jp PLY_Stop		;8021
jp PLY_Play		;8024
jp PLY_SFX_Init		;8027
jp PLY_SFX_Play 	;802A
jp RasterColors_Init 	;802D
jp RasterColors_Reset	;8030
jp RasterColors_Disable	;8033

jp ScreenBuffer_Init	;8036 Init the double buffer
jp ScreenBuffer_Flip	;8039 Flip the buffer
jp ScreenBuffer_Reset 	;803C

jp BankSwitch_128k       ;803F
jp BankSwitch_128k_Reset ;8042
jp BankSwitch_128k_CallHL ;8045

jp StarArrayInit_Enemy 	   	;8048
jp StarArrayInit_Player    	;804B
jp ObjectArray_Init 	   	;804E
jp Event_StreamInit	   	;8051
jp Player_DrawUI		;8054
jp GetLevelTime 		;8057
jp Firmware_Kill		;805A
jp Firmware_Restore 		;805D
jp DrawText_LocateSprite	;8060
jp DrawText_CharSprite		;8063
jp BankSwitch_128k_BankCopy 	;8066
jp DrawText_PrintString		;8069
jp ShowSprite_SetBankAddr	;806C
jp Player_ReadControls 		;806F
jp Music_Restart 		;8072
jp SFX_PlaySfx  		;8075
jp Object_DecreaseLifeShot 	;8078
jp SpritePointerInit		;807B
jp DoSmartBombCall		;807E
jp ScreenBuffer_GetActiveScreen	;8081
jp Timer_UpdateTimer		;8084
jp Player_CheatMode		;8087
jp Timer_GetTimer		;808A
jp ObjectProgram_SpriteBankSwitch ;808D
jp SpriteBank_Font		 ;8090
jp ObjectProgram_HyperFire	;8093
jp Player_GetPlayerVars		;8096
jp DoMoves			;8099
jp RasterColors_SetPointers	;809C
jp Player_Hit_Injure		;809F
jp RasterColors_MusicOnly	;80A2
jp RasterColors_StopMusic	;80A5
jp ShowCompiledSprite		;80A8

ifdef SupportPlus
jp Plus_SetSprite		;80AB
jp Plus_CopySpriteCompressed	;80AE	
jp Plus_SetPalette		;80B1
else
jp null
jp null
jp null
endif
jp ScreenBuffer_Alt		;80B4
jp BankSwitch_128k_SetCurrent   ;80B7
jp Player_GetHighscore		;80BA
jp RasterColors_Blackout	;80BD
jp RasterColors_DefaultSafe	;80C0
list

;***************************************************************************************************

;					Aligned Code

;***************************************************************************************************
SavedSettings:
defb 255	;spare
defb 0		;spare
defb 0		;spare
defb 0		;spare
defb 0		;spare
BlockHeavyPageFlippedColors:defb 64; pos -5 0/255=on  64=off
BlockPageFlippedColors:defb 64; pos -4 0/255=on  64=off
ScreenBuffer_ActiveScreen:	defb &c0; pos -3
ScreenBuffer_VisibleScreen:	defb &c0; pos -2
CPCVer : defb 00; 0  =464 , 128=128 ; 129 = 128 plus ; 192 = 128 plus with 512k; 193 = 128 plus with 512k pos -1
Player_Array:
defb 100;Y 	;0
defb 64 ;X	;1
defb 15	;D1	;2 X------- = Shoot delay / ----XXXX = Drone pos
defb %11111111 	;3 D2	Vars ------XX = Lives / XX------ = Smart Bombs / --XXXX-- spare 

defb %11100000	;4	XXX----- Invincibility / -----XXX not used/ ---XX--- Drones
defb 20		;5 - continues
defb 20		;6 - Continues Reset
defb 0		;7 - Game difficulty (enemy Fire Speed 0= normal, 1=easy, 2=hard)  
defb 0		;8 - ------XX = Turbo mode 0 / 1 / 2
defb 0		;9
defb 0		;10
defb 0		;11
defb 0		;12

KeyMap: 
;Joystick keys
;defb &FE,&09 ;Up
;defb &FD,&09 ;Down
;defb &FB,&09 ;Left
;defb &F7,&09 ;Right
;defb &7F,&08 ;Fire1
;defb &7F,&07 ;Fire2
;defb &7F,&05 ;Fire3
;defb &F7,&03 ;Pause

defb &FE,&00 ;Up	13
defb &FB,&00 ;Down	14
defb &FE,&01 ;Left	15
defb &FD,&00 ;Right	16
defb &7F,&08 ;Fire1	17
defb &7F,&07 ;Fire2	18
defb &7F,&05 ;Fire3	19
defb &F7,&03 ;Pause bit 20


align 16,0
Player_ScoreBytes defb &00,&00,&00,&00,&00,&00,&00,&00	; Player 1 current score
		    ;25
HighScoreBytes defb    &00,&00,&00,&00,&00,&00,&00,&00	; Highscore
Player_ScoreAdd defb 0					; Points to add to player 1 - used to make score 'roll up'
;70 bytes

MusicRestore:defw 0000					; pointer to the function to call to bring back the music - needed by 64k where music is wiped by firmware
nolist
;***************************************************************************************************

;					Rastercolors Aligned Code

;***************************************************************************************************

;Some template rastercolors to use for blackout (when using the screen for temp space) and continue screens and the like with basic colors
align 256,&00
RasterColors_Safe_ForInterrupt:
	defb 1
	defb 1
RasterColors_Safe:
	defb &54,&58,&5F,&4B
RasterColors_Black_ForInterrupt:
	defb 1
	defb 1
RasterColors_Black:
	defb &54,&54,&54,&54


; These are the default memory locations for the rastercolors - note they are memory aligned - they are often overrided by the Level code
RasterColors_ColorArray1:
	defb 1
	defb 1
	defb 64+20,64+24,64+29,64+11
RasterColors_ColorArray2:
	defb 5
	defb 1

	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 12
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray3:
	defb 1
	defb 1
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray4:
	defb 1
	defb 1 
	defb 64+20,64+31,64+14,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11



TranspColors:	; Transparent colors are used by the sprite, if the byte matches it is skipped to effect transparency without an 'alpha map'
defb &00,&F0,&0F,&FF,&AC,&53

; Smartbomb effect shows a flashing background, these are the bytes used
Background_SmartBombColors:
defb &FF,&0,&FF,&0,&FF

; The scrolling background gradient is stored here,
; The first line uses the first two bytes,
; the rest of the bytes are in the format LineNum,Byte
; because the background works in twoline pairs, you cannot have lines 30,31 you have to use 30,32
; also note that the last line should be specified otherwise the line before will not scroll!
BGGradiant: 
; 41 bytes allocation
defb &FF,&DD,190,&77,180,&AA,170,&55,160,&88
defb 150,&22,140,&00,130,&00, 40,&00,35,&20
defb 30, &80,25, &50,20, &A0, 15,&70,10,&D0

defb 05,&F0,255,0,0,0,0,0,0,0,255



;align 40,&0
; table/array for screen addresses for each scan line
ifdef MinimizeCore 
	scr_addr_tableMajor ; BYTES -XXXX--- %01111000
	defw &0000,&0050,&00A0,&00F0,&0140,&0190,&01E0,&0230,&0280,&02D0,&0320,&0370,&03C0,&0410,&0460,&04B0
	scr_addr_tableMinor ; BYTES -----XXX ; do not need aligning
	defb  &00,&08,&10,&18,&20,&28,&30,&38
endif
;RasterColors_TickerEventBlock
;	defs 10


;These are used by Arkostracker
;There are two holes in the list, because the Volume registers are set relatively to the Frequency of the same Channel (+7, always).
;Also, the Reg7 is passed as a register, so is not kept in the memory.
PLY_PSGRegistersArray
PLY_PSGReg0 db 0
PLY_PSGReg1 db 0
PLY_PSGReg2 db 0
PLY_PSGReg3 db 0
PLY_PSGReg4 db 0
PLY_PSGReg5 db 0
PLY_PSGReg6 db 0
PLY_PSGReg8 db 0		;+7
	    db 0
PLY_PSGReg9 db 0		;+9
	    db 0
PLY_PSGReg10 db 0		;+11
PLY_PSGReg11 db 0
PLY_PSGReg12 db 0
PLY_PSGReg13 db 0
PLY_PSGRegistersArray_End





; These are the jump-pointes used by the raster color interrupt routine - to try to save time only one byte is altered, so it must be byte aligned!
align 256,&00
RasterColors_Tick:
	jp RasterColors_1 :RasterColors_TickJump_Plus2

RasterColors_TopOfScreen:
	;di
	ld a,RasterColors_1	
	ld (RasterColors_TickJump_Plus2-2),a
	;ei
Null:	ret

RasterColors_2:
	ld a,RasterColors_3
	ld (RasterColors_TickJump_Plus2-2),a
	ret
RasterColors_3:
	;di
	ld a,RasterColors_4
	ld hl,RasterColors_ColorArray2 :RasterColors_ColorArray2Pointer_Plus2
	jp RasterColors_All
RasterColors_4:
	;di
	ld a,RasterColors_5
	ld hl,RasterColors_ColorArray3 :RasterColors_ColorArray3Pointer_Plus2
	jp RasterColors_All
RasterColors_5:
	;di
	ld a,RasterColors_6
	ld hl,RasterColors_ColorArray4 :RasterColors_ColorArray4Pointer_Plus2
	jp RasterColors_All
RasterColors_6:
	;di
	ld a,RasterColors_1
	ld (RasterColors_TickJump_Plus2-2),a
	
InterruptPlaySound:
	;exx
	;ex af,af'
	ex af,af'
	exx
	push af
	push bc
	push de
	push hl
	push ix
	push iy
;	ld bc, &7F00+	%11000000 +4
;	out (c),c
	;ld a,4
	;call BankSwitch_128k
	call PLY_Play :MusicExec_PerFrame_Plus2	; play the music
;	call BankSwitch_128k_Reset
;	ld bc, &7F00+	%11000000 BankSwitch_128k_CurrentB_Plus2
;	out (c),c
	call null :RasterColors_PerFrameCall_Plus2
	pop iy
	pop ix
	pop hl
	pop de
	pop bc
	pop af
	exx
	ex af,af'


ifdef SupportPlus 
	; The code after this point is only used on the CPC plus
	ld a,0 :FlashPlusSprite_Plus1
	or a
	ret z

	ld a,(BlockPageFlippedColors)
	cpl
	ld (BlockPageFlippedColors),a

	;ex af,af'
	;exx
	ld e,9

	or a
	jr z,FlashPlayer_On
	ld e,0
FlashPlayer_On:


	ld d,0
	ld h,6
	jp Plus_ShowHide
else
	ret
endif

;	call Plus_SetSprite
;	inc d
;	call Plus_SetSprite
;	inc d
;	call Plus_SetSprite
;	inc d
;	call Plus_SetSprite
	; bc = X (0-160) ,Y 
	; d Sprite Num
	; e = Scale (0 = sprite off , 9= normal )


	;ei
;	ret
	

RasterColors_1:
	;di
	ld a,RasterColors_2
	ld hl,RasterColors_ColorArray1 :RasterColors_ColorArray1Pointer_Plus2

	jp RasterColors_All


;***************************************************************************************************
; Virtual Screen pos

	; Input 	B=VitrualX ;C=VirtualY

	; output 	B=ScreenByteX ;C=ScreenY	Y=255 if ofscreen
	;		H X bytes to skip	L	X bytes to remove
	;		D Y lines to skip	E	Y lines to remove
;***************************************************************************************************

nolist
; The virtual screen has a resolution of 160x200, with a 24 pixel border, which is used for clipping
; Y=0 is used by the code to denote a 'dead' object which will be deleted from the list
VirtualPosToScreenByte:


	ld HL,&0000
	ld D,h
	ld e,h

	; we use a virtual screen size
	; X width is 208	(160 onscreen - 2 per byte)
	; Y height is  248	(200 onscreen - 1 per line)

	; this is to allow for partially onscreen sprites	
	; and to keep co-ords in 1 byte
	; X<24 or x>=184 is not drawn
	; Y<24 or Y>=224 is not drawn
	;
	; only works with 24 pixel sprites
	ld a,B	;Check X
	cp 24
	jp NC,VirtualPos_1	; jp is faster if we expect it to be true!
; X<24
	ld a,25
	sub a,B
	RRA
	ld H,A	;move the sprite A left
	ld L,A	;need to plot A less bytes

	ld B,24	;B was offscreen, so move it back on
	jp VirtualPos_2
VirtualPos_1:
	;ld a,B	;Check X
	cp 184-12
	jp C,VirtualPos_2
; X>184
	;push B
	ld a,B
	sub 184-12

	RRA

;	pop B

	add L	;	X pos is ok, but plot A less bytes
	ld L,A
	;ld a,B	;Check X
VirtualPos_2:
	ld a,B	;Check X
	sub 24
	RRA	; halve the result, as we have 80 bytes, but 160 x co-ords
	ld B,a	
;-------------------------------------------------------------------------
	ld a,C	;Check Y
	cp 24
	jp NC,VirtualPos_3
; Y<24
	ld a,24
	sub a,C
	ld D,A	;move the sprite A up
	ld E,A	;need to plot A less lines
	ld C,24
	jp VirtualPos_4
VirtualPos_3:
	;ld a,C	;Check Y
	cp 224-24
	jp C,VirtualPos_4
; Y>224
	ld a,C
	sub 224-24
	ld E,A
VirtualPos_4:
	ld a,C	;Check Y
	sub 24
	ld C,a
	ret	




;***************************************************************************************************

; 					Get Mem Pos

;***************************************************************************************************

;Generic Get next line routine - note most routines have their own to save a call
GetNxtLin:
	;ld de,&800

	jp GetNxtLinMain :GetNxtLinJump_Plus2
	;ld a,(ScreenBuffer_ActiveScreen)
	;cp &c0
	;jr NZ,GetNxtLinAlt
GetNxtLinMain:
	ld a,h
	add a,&08
	ld h,a
	ret nc
	ld de,&c050
	add hl,de
	ret
GetNxtLinAlt:
	ld a,h
	add a,&08
	ld h,a
	bit 7,h
	ret z
	ld de,&c050
	add hl,de
	ret



; This is the LARGE version of GetMemPos - it needs a 400 byte lookup table
ifndef MinimizeCore


GetMemPosQuickA:	; kept for compatibility with the minimal one
GetMemPos:		; This version needs a 400 byte lookup table, but is faster
;	; Input  BC= XY (x=bytes - so 80 across)
;	; output HL= screen mem pos
;	; de is wiped

	ld h,0
	ld l,C
	add hl,hl 		; table is two bytes so double hl

	ld de,scr_addr_table	; get table
	add hl,de		;add line num

	ld a,(hl)		; read the two bytes in		
	inc hl
	ld h,(hl)
	ld l,a	; hl now is the memory loc of the line
	
;	ld a,b	;get the X col
	ld d,&C0 :ScreenBuffer_ActiveScreenDirect_Plus1
	ld e,b

	add hl,de  	; hl = memory line, bc = X pos = hl is now the location on screen
	
	ret ;return memory location in hl

GetMemPosDouble:		; This version needs a 400 byte lookup table, but is faster
;	; Input  BC= XY (x=bytes - so 80 across)
;	; output HL= screen mem pos 1 output DE= screen mem pos 2
;	; BC is wiped

	ld h,0
	ld l,C
	add hl,hl 		; table is two bytes so double hl

	ld de,scr_addr_table	; get table
	add hl,de		;add line num

	ld e,(hl)		; read the two bytes in		
	inc hl
	ld d,(hl)
	inc hl
	ld a,(hl)		; read the two bytes in		
	inc hl
	ld h,(hl)
	ld l,a	; hl now is the memory loc of the line
	
;	ld a,b	;get the X col
	ld c,b
	ld b,&C0 :ScreenBuffer_ActiveScreenDirectB_Plus1


	add hl,bc  	; hl = memory line, bc = X pos = hl is now the location on screen
	ex de,hl
	add hl,bc  	; hl = memory line, bc = X pos = hl is now the location on screen
	ret ;return memory location in hl and de
endif


ifdef MinimizeCore
GetMemPosDouble:
	call GetMemPos
	push hl	
	call GetNxtLin
	ex hl,de
	pop hl
ret
GetMemPos  ; this version uses the smaller tables - but takes longer
	; Input  BC= XY (x=bytes - so 80 across)
	; output HL= screen mem pos
	; de is wiped

	ld a,C
GetMemPosQuickA
	and %01111000
	rra
	rra

	ld hl,scr_addr_tableMajor
	add l
	ld l,a
	ld a,(hl)		; read the two bytes in		
	inc l
	ld h,(hl)
	ld l,a	; hl now is the memory loc of the line
	push hl

		ld a,C
		and %00000111
		ld hl,scr_addr_tableMinor	; get table
		add l
		ld l,a
		ld a,(hl)		; read the two bytes in		
		ld h,a
		ld l,0	; hl now is the memory loc of the line
	pop de
	add hl,de
	ld d,&C0 :ScreenBuffer_ActiveScreenDirect_Plus1
	ld e,B
	add hl,de

	Bit 7,C;ld a,C
	ret z
	ld a,5
	add h
	ld h,a	
	ret ;return memory location in hl
endif


;***************************************************************************************************

; 					Show Sprite

;***************************************************************************************************
SpritePointerInit:	; We have two sprite pointers, one for player sprites (which actually never moves!) and one for level sprites
			; Note.. the second bank of sprites (128k only) is always located in &D000 in memory config C1/C3
	ld (ObjectSpritePointer_Plus2-2),hl
	ld (PlayerSpritePointer_Plus2-2),de

ret

SprShow_W equ SprShow_W_Plus1-1
SprShow_H equ SprShow_H_Plus1-1
SprShow_Xoff equ SprShow_Xoff_Plus1-1
SprShow_Yoff equ SprShow_Yoff_Plus1-1


SprShow_TempX equ SprShow_TempX_Plus1-1
SprShow_TempY equ SprShow_TempY_Plus1-1
SprShow_TempW equ SprShow_TempW_Plus1-1
SprShow_TempH equ SprShow_TempH_Plus1-1
SprShow_OldX equ SprShow_OldX_Plus1-1

;SprShow_TempW defw &00


SprShow_TempAddr equ SprShow_TempAddr_Plus2-2 ; defw &0000

;SprShow_Address  defw &0000

SpriteBank_Font:			;Init the spritefont location
	ld hl,&C000			;The font is located at &C000 in bank C1/C3, or &7000 in the Bootstrap block
ShowSprite_SetBankAddr:
	ld (SprShow_BankAddr),hl
ret

; We can preread a sprite to get the width/height
; This is used for Direct sprites, and was used by the object loop - the object loop now assumes the sprite is 24x24, this was done to save time as 97% of the time - it is
ShowSprite_ReadInfo:
ld a,&0 :SprShow_SprNum_Plus1
	ld c,a
	
	ld b,0
        or a ; only done to clear carry flag
	rl b
	rl c

	ld hl,&4000 :SprShow_BankAddr_Plus2
	ld d,h
	ld e,l
	add hl,bc
	add hl,bc	; 6 bytes per sprite
	add hl,bc

;	add hl,bc
;	add hl,bc
;	add hl,bc

	ld a,(hl)
	ld (SprShow_H),a
	inc hl

	ld a,(hl)
	ld (SprShow_W),a
	inc hl
	ld a,(hl)
	ld (SprShow_Yoff),a
	inc hl

	ld a,(hl)
	ld (SprShow_Xoff),a		; Note Xoffset is never actually used
					; the mem pos is actually sprite attribs
					; such as PSet, Doubleheight and trans color
	inc hl
	;leave with Sprbankaddr in DE 
	;and Xoff in A
	
ret

;ShowSpriteDirect is a cruder version of ShowSprite, it does not use the 'virtual' screen res of (160x200) and cannot do clipping - it was designed for the UI objects 
;which never moved and never needed clipping 
ShowSpriteDirect:
	;ld hl,SprDrawChooseRender;pset
	;ld (ShowSprite_Ready_Return_Plus2-2),hl
	;set draw pos into Temp_X and Temp_Y
	call ShowSprite_ReadInfo
	
	ld a,(SprShow_H)
	ld (SprShow_TempH),a
	or a
	ret z

	ld a,(SprShow_W)
	ld (SprShow_TempW),a


	ld c,(hl)
	inc hl
	ld b,(hl)


	ex de,hl
	add hl,bc
	ld (SprShow_TempAddr),hl
	ex de,hl





	xor a
	ld (TranspBitA_Plus1-1),a
	


	;loald (SprShow_TempX),a



	
;		ld A,B
		
		ld a,(SprShow_Yoff)
		ld c,a
		ld a,(SprShow_TempY)
		add c
		ld (SprShow_TempY),A


	ld hl,SprDrawChooseRender;pset	
	ld a,(SprShow_Xoff_Plus1-1)
	bit 7,a
	jp z,ShowSprite_OK_Xoff2
	ld hl,SprDrawChooseRenderpset


	ShowSprite_OK_Xoff2:

	ld (ShowSprite_Ready_Return_Plus2-2),hl
	jp ShowSprite_Ready

ShowSprite:	
; ShowSprite is the main routine of our program!
	
	;ld hl,SprDrawChooseRender;pset
	;ld (ShowSprite_Ready_Return_Plus2-2),hl


 		; *********  Get Sprite Details *********
	call ShowSprite_ReadInfo


	ld c,(hl)
	inc hl
	ld b,(hl)


	ex de,hl
	add hl,bc
	ld (SprShow_TempAddr),hl
	ex de,hl

	ld bc,TranspColors

	;ld a,(SprShow_Xoff) - we are relying on this still being in A 
	and %00000111
	add a,c
	ld c,a
	ld a,(bc)
	ld (TranspBitA_Plus1-1),a

	ld a,(SprShow_Y)
	or a
	ret Z
	di

 		; *********  show a new sprite *********


ShowSprite_OK:
	ld a,48:SprShow_Y_Plus1
	;ld (SprShow_Y),a
	ld C,a				; load C for the Screen lookup

	ld a,48: SprShow_Yoff_Plus1
	add C
	ld C,a



	;ld (SprShow_TempY),a


	ld a,48 :SprShow_X_Plus1
	ld B,a				; load B for the Screen lookup

	ld a,48: SprShow_Xoff_Plus1


	bit 6,a
	jp z,ShowSprite_OK_NoDoubler
	ld hl,SprDrawChooseRenderLineDoubler ; Doubler gives an interlacing effect, used for faux big sprites without slowdown
	
	bit 7,a
	jp z,ShowSprite_OK_Xoff
	ld hl,SprDrawChooseRenderLineDoublerPset  ;Double height with Pset (no transparency - much faster)

	jp ShowSprite_OK_Xoff
ShowSprite_OK_NoDoubler:			
	;push hl
	ld hl,SprDrawChooseRender;pset		; Normal sprite	
	bit 7,a
	jp z,ShowSprite_OK_Xoff

;	ld hl,SprDrawChooseRenderPsetAligned - Tested code - incomplete
	ld hl,SprDrawChooseRenderpset		; PSET sprite - deletes background, fast no transp


ShowSprite_OK_Xoff:
	and %00000000 ; Bit 7 forces "pset" - wipes background but faster ; Bit 6 doubles height ;123=transp
	add B
	ld B,a
	
	ld (ShowSprite_Ready_Return_Plus2-2),hl
	;pop hl
	
	ld a,(SprShow_W)
	ld (SprShow_TempW),a

	ex af,af'	;	push af 			;store width for later
		ld a,&18 :SprShow_H_Plus1		;(Sprite Height)
		or a
		ret z
		ld (SprShow_TempH),a

		call VirtualPosToScreenByte
		;		H X bytes to skip	L	X bytes to remove
		;		D Y bytes to skip	E	Y bytes to remove

		ld A,B
		ld (SprShow_TempX),A
		ld A,C
		ld (SprShow_TempY),A

		ld a,h
		or l
		or d			; if all are zero, do nothing
		or e
		jp Z,ShowSprite_SkipChanges

	ifdef Debug
		call Debug_NeedEXX
	endif
		exx;push hl
			ld hl,SprDrawLnStartBegin
			ld (ShowSprite_Ready_Return_Plus2-2),hl

		exx;pop hl
	ifdef Debug
		call Debug_ReleaseEXX
	endif

		ld a,h
		ld (SprShow_OldX),a
		push de

			ld a,(SprShow_TempH)
			dec a
			cp E
			jr NC,ShowSprite_HeiNotZero		; check if new width is <0
				;pop af ; use up the pushed val
				pop af
				ei
				ret
			ShowSprite_HeiNotZero:
			ld a,(SprShow_TempH)
			sub E
			ld (SprShow_TempH),a

			ld a,(SprShow_TempW)
			dec a
			cp L
			jr NC,ShowSprite_WidthNotZero		; check if new width is <0
				;pop af ; use up the pushed val
				pop af
				ei
				ret
			ShowSprite_WidthNotZero:
			ld a,(SprShow_TempW)
			sub L
			ld (SprShow_TempW),a

			ld hl,(SprShow_TempAddr)
	
		pop af 		;restore width
		ld d,0
		ld e,a		; store width for loop

	; we can only use the basic slow render - the others cannot clip

	;pop bc  	; Get the counter out the stack
	ex af,af'
	ld b,a
	;ld a,b
	or a
	jr Z,ShowSprite_AddressOK
 
	ShowSprite_AddressDown:
		add hl,de
	djnz ShowSprite_AddressDown

ShowSprite_AddressOK:	;Address does not need changing
	ld b,0
	ld c,&00 :SprShow_OldX_Plus1
;	ld bc,(SprShow_OldX)
	add hl,bc ; add the width to the address

	ld (SprShow_TempAddr),hl ; save the new start address


	jp ShowSprite_Ready
	;we have messed with the co-ords, so can only use the basic render not supefast ones



ShowSprite_SkipChanges:
	; No co-ord tweaks were needed, all sprite is onscreen
	;pop af 		;restore width
	ex af,af'
	jp ShowSprite_Ready

SprDrawChooseRenderLineDoubler:
;	ex af,af'
	rlc c
;	ld a,c
;	add c
;	ld c,a

	ld de,Sprdraw24PxVer_Double
;	ex af,af'
	jp SprDrawTurboPrep

SprDrawChooseRender:	; Pick the render based on width
	cp 6
	jp z,SprDraw24pxInit
	cp 8
	jr z,SprDraw32pxInit
	cp 4
	jr z,SprDraw16pxInit
	cp 2
	jr z,SprDraw8pxInit
	cp 12
	jr z,SprDraw48pxInit
	;cp 255
	;jr z,SprDraw24pxInit

SprDrawLnStartBegin:			; This is our most basic render, its slow, but can do any size and clipping
	ld a,(TranspBitA_Plus1-1)	
	ld (TranspBitB_Plus1-1),a
	push hl
	ld hl, SprDrawLnStart2

	ld a,(SprShow_Xoff)
	bit 6,a
	jp z,SprDrawLn_NoDoubler

	ld hl,SprDrawLnDoubleLine
	;ld a,c
	;add c
	;ld c,a

SprDrawLn_NoDoubler:
	ld (SprDrawLnDoubleLineJump_Plus2-2),hl
	pop hl


SprDrawLnStart2:
	;push bc
	push hl
	

		ld d,IYH
		ld e,IYL



		ld b,&00 :SprShow_TempW_Plus1;a	
		SprDrawPixelLoop:
			ld a,(de)
			cp 1 :TranspBitB_Plus1
			jr z,SprDrawSkipPixelLoop
			ifdef Debug
				or %11000000 ; test code, marks slow sprites so we can see they will be slow
			endif
			ld (hl),a
		SprDrawSkipPixelLoop:
			inc hl
			inc de
		djnz SprDrawPixelLoop	

		ld d,0 
		ld e,0 :SprShow_W_Plus1
		add iy,de
	pop hl


	call GetNxtLin
	dec c
	ei
	ret z
	
	jp SprDrawLnStart2 :SprDrawLnDoubleLineJump_Plus2
SprDrawLnDoubleLine:
	call GetNxtLin

	jr SprDrawLnStart2

SprDrawLineEnd2:

;--------------------Turbo Version! misuse the stack for faster writes ----------------
SprDraw8pxInit:
	ld de,Sprdraw8PxVer
	jp SprDrawTurboPrep
SprDraw16pxInit:
	ld de,Sprdraw16PxVer
	jp SprDrawTurboPrep
SprDraw32pxInit:
	ld de,Sprdraw32PxVer
	jp SprDrawTurboPrep
SprDraw48pxInit:
	ld de,Sprdraw48PxVer
	jp SprDrawTurboPrep
SprDraw24pxInit:
	ld de,Sprdraw24PxVer
	jp SprDrawTurboPrep
SprDrawTurboPrep

	ld (Sprdraw24PxJumpPos_Plus2-2),de
	;ld  	B,0 ;B is ZERO

SprDrawTurboPrep2:
	di
	ld (SprDrawTurbo_StackRestore_Plus2-2),sp
	ld sp,iy
SprDrawTurbo_StartLine:
	ld (SprDrawTurbo_HLrestore_Plus2-2),hl

		Ld a,0	:TranspBitA_Plus1 ; Set A to ZERO / Transp byte
		jp	Sprdraw24PxVer :Sprdraw24PxJumpPos_Plus2	; we change the jump here to alter the width of the sprite quickly

		; ********** A MUST BE the transparent byte for THIS WHOLE LOOP! ***********

Sprdraw24PxVer_Double:	;Line doubler - does two nextlines each time
		
		bit 0,C
		jr z,SprDrawTurbo_LineSkip
		jp Sprdraw24PxVer
Sprdraw48PxVer:
		pop de
		cp e
		jr z,SprDraw24pxW_SkipF
		ld (hl),e
		SprDraw24pxW_SkipF:
		inc hl

		; Byte Start
		cp d
		jr z,SprDraw24pxW_SkipE
		ld (hl),d
		SprDraw24pxW_SkipE:
		inc hl

		pop de
		cp e
		jr z,SprDraw24pxW_SkipC
		ld (hl),e
		SprDraw24pxW_SkipC:
		inc hl

		; Byte Start
		cp d
		jr z,SprDraw24pxW_SkipD
		ld (hl),d
		SprDraw24pxW_SkipD:
		inc hl
Sprdraw32PxVer:
		pop de
		cp e
		jr z,SprDraw24pxW_SkipA
		ld (hl),e
		SprDraw24pxW_SkipA:
		inc hl

		; Byte Start
		cp d
		jr z,SprDraw24pxW_SkipB
		ld (hl),d
		SprDraw24pxW_SkipB:
		inc hl


Sprdraw24PxVer:
		pop de
		cp e
		jr z,SprDraw24pxW_Skip1
		ld (hl),e

		SprDraw24pxW_Skip1:
		inc hl

		cp d
		jr z,SprDraw24pxW_Skip2
		ld (hl),d
		SprDraw24pxW_Skip2:
		inc hl

Sprdraw16PxVer:
		pop de
		cp e
		jr z,SprDraw24pxW_Skip3
		ld (hl),e
		SprDraw24pxW_Skip3:
		inc hl

		; Byte Start
		cp d
		jr z,SprDraw24pxW_Skip4
		ld (hl),d
		SprDraw24pxW_Skip4:
		inc hl

Sprdraw8PxVer:
		pop de
		cp e
		jr z,SprDraw24pxW_Skip5
		ld (hl),e
		SprDraw24pxW_Skip5:
		inc hl

		cp d
		jr z,SprDraw24pxW_Skip6
		ld (hl),d
		SprDraw24pxW_Skip6:
SprDrawTurbo_LineSkip:
	dec c
	jr z,SprDrawTurbo_Done


	ld hl,&6969 :SprDrawTurbo_HLrestore_Plus2
	ld a,h
	add a,&08
	ld h,a
	jp  GetNxtLin24px :SprDrawTurboLineJump_Plus2
GetNxtLin24px:
	jp nc,SprDrawTurbo_AllowInterrupts
	jp SprDrawTurbo_AllowInterruptsB
GetNxtLinAlt24px:
	bit 7,h
	jp z,SprDrawTurbo_AllowInterrupts
SprDrawTurbo_AllowInterruptsB:
	ld de,&c050
	add hl,de

SprDrawTurbo_AllowInterrupts:	; We need to allow interrupts every few lines to keep the raster colors consistant
	;bit 0,c
	ld a,c
	and %00000011
	jp nz,SprDrawTurbo_StartLine

	ld (SprDrawTurbo_StackRestoreSprite_Plus2-2),sp
	ei
	ld sp,&6969 :SprDrawTurbo_StackRestore_Plus2
	di
	ld sp,&6969 :SprDrawTurbo_StackRestoreSprite_Plus2
	jp SprDrawTurbo_StartLine



SprDrawTurbo_Done:
	ld sp,(SprDrawTurbo_StackRestore_Plus2-2)
	ei
	ret




ShowSprite_Ready:
	ld A,&69:SprShow_TempX_Plus1		;xpos
	ld B,A

	ld A,&00 :SprShow_TempY_Plus1 ;(SprShow_TempY)
	ld C,A			; updated ypos
	;call GetMemPos
	call GetMemPosQuickA
	ld a,&00 :SprShow_TempH_Plus1
	ld c,a
	ld iy,&0000 :SprShow_TempAddr_Plus2
	ld a,(SprShow_TempW)
	
	jp SprDrawLnStartBegin :ShowSprite_Ready_Return_Plus2







;--------------------Pset Version! no transparentcy, so fast! ----------------
SprDrawChooseRenderLineDoublerPset:
	di
	
	ex af,af';push af
	ld a,c
	add c
	ld c,a
	ex af,af';pop af
	ld de,SprdrawPset_Double
	jp SprDrawPsetPrep


SprDrawChooseRenderPset:		; Can do any size between 8-48 pixels
	cp 6
	jp z,SprDrawPset24pxInit
	cp 8
	jr z,SprDrawPset32pxInit
	cp 4
	jr z,SprDrawPset16pxInit
	cp 2
	jr z,SprDrawPset8pxInit
	cp 12
	jr z,SprDrawPset48pxInit
	jp SprDrawLnStart2


SprDrawPset8pxInit:
	ld de,SprDrawPset8PxVer
	jr SprDrawPsetPrep
SprDrawPset16pxInit:
	ld de,SprDrawPset16PxVer
	jr SprDrawPsetPrep
SprDrawPset32pxInit:
	ld de,SprDrawPset32PxVer
	jr SprDrawPsetPrep
SprDrawPset48pxInit:
	ld de,SprDrawPset48PxVer
	jr SprDrawPsetPrep
SprDrawPset24pxInit:
	ld de,SprDrawPset24PxVer
SprDrawPsetPrep:

	ld (SprDrawPset24PxJumpPos_Plus2-2),de
	
SprDrawPsetPrep2:

	di
	ld (SprDrawPset_StackRestore_Plus2-2),sp
	ld sp,iy
SprDrawPset_StartLine:
	ld (SprDrawPset_HLrestore_Plus2-2),hl

		ld a,(TranspBitA_Plus1-1) ; Set A to ZERO
		jp	SprDrawPset24PxVer :SprDrawPset24PxJumpPos_Plus2

		; ********** A MUST BE ZERO THIS WHOLE LOOP! ***********

SprdrawPset_Double:				;Line doubler, moves down two lines instead of one
		
		bit 0,C
		jr z,SprDrawPset_LineSkip
		jp SprDrawPset24PxVer
SprDrawPset48PxVer:
		pop de
		ld (hl),e
		inc hl
		ld (hl),d
		inc hl

		pop de
		ld (hl),e
		inc hl
		ld (hl),d
		inc hl
SprDrawPset32PxVer:
		pop de
		ld (hl),e
		inc hl
		ld (hl),d
		inc hl
SprDrawPset24PxVer:
		pop de
		ld (hl),e
		inc hl
		ld (hl),d
		inc hl
SprDrawPset16PxVer:
		pop de
		ld (hl),e
		inc hl
		ld (hl),d
		inc hl
SprDrawPset8PxVer:
		pop de
		ld (hl),e
		inc hl
		ld (hl),d

SprDrawPset_LineSkip:
	dec c
	jr z,SprDrawPset_Done
	ld hl,&6969 :SprDrawPset_HLrestore_Plus2
	;ld de,&800
	;add hl,de
	ld a,h
	add a,&08
	ld h,a
	jp  GetNxtLinPset :SprDrawPsetLineJump_Plus2
GetNxtLinPset:
	jp nc,SprDrawPset_AllowInterrupts
	jp SprDrawPset_AllowInterruptsB
GetNxtLinPsetAlt:
	bit 7,h
	jp z,SprDrawPset_AllowInterrupts
SprDrawPset_AllowInterruptsB:
	ld de,&c050
	add hl,de

SprDrawPset_AllowInterrupts:		; Let interrupts run once every few lines to keep interrupts stable
	ld a,c
	and %00000111
	jp nz,SprDrawPset_StartLine

	ld (SprDrawPset_StackRestoreSprite_Plus2-2),sp
	ei
	ld sp,&6969 :SprDrawPset_StackRestore_Plus2
	di
	ld sp,&6969 :SprDrawPset_StackRestoreSprite_Plus2
	jp SprDrawPset_StartLine	



SprDrawPset_Done:
	ld sp,(SprDrawPset_StackRestore_Plus2-2)
	ei
	ret












;***************************************************************************************************

;				 Star Array

;***************************************************************************************************


StarArraySize_Player equ StarArraySize_Player_Plus1-1
StarArrayMemloc_Player equ StarArrayMemloc_Player_Plus2-2

StarArraySize_Enemy equ StarArraySize_Enemy_Plus1-1
StarArrayMemloc_Enemy equ StarArrayMemloc_Enemy_Plus2-2

Stars_Color2a equ Stars_Color2a_Plus1-1
;Stars_Color2b equ Stars_Color2b_Plus1-1

Stars_Color1a equ Stars_Color1a_Plus1-1
;Stars_Color1b equ Stars_Color1b_Plus1-1
;StarLastGood equ StarLastGood_Plus1-1

;StarArray_Init
;	call Init_BootStrap
;	ld B,StarArraySize
;	ld hl,StarArray

;StarInit:
;	ld de,StarArraySize	
;	push hl
;		ld (hl),100 ;y
;		add hl,de
;		ld (hl),100 ;X
;		add hl,de
;		ld a,b
;		and %01111111
;		ld (hl),a ;Movetype
;	pop hl
;	inc hl
;	djnz StarInit

StarArrayInit_Enemy:				;The star array does enemy fire, and player shots
	ld (StarArraySize_Enemy),a		;so we configure it here before running
	ld (StarArrayMemloc_Enemy),hl
ret
StarArrayInit_Player:
	ld (StarArraySize_Player),a
	ld (StarArrayMemloc_Player),hl
ret
Player_StarArray_Redraw:
	; Redraw the enemy star array
	ld a,36 :StarArraySize_Player_Plus1
	ld B,a ;StarLastGood_Plus1
	
	ld a,&06 :PlayerStarColor_Plus1 ;&12 ;6f
	call StarArray_InitColorsOne

	;configure the loop for the player star array
	ld hl,StarCollisionsDone
	ld (CurrentStarArrayCollisionsB2_Plus2-2),hl
	
	ld hl,(StarArrayMemloc_Player)
	
	jp Starloop2_Start

StarArray_InitColorsOne:
	ld d,a
	ld e,a
StarArray_InitColors:
	ld a,e
	ld (Stars_Color1a),a
	ld a,d
	ld (Stars_Color2a),a
	ret


StarArray_Redraw:
	ld a,(Timer_TicksOccured)
	or a
	ret z	; see if game is paused (TicksOccurred = 0 )

	; Redraw the enemy star array
	ld a, 255 :StarArraySize_Enemy_Plus1
	ld B,a ;StarLastGood_Plus1
	or B
	ret z

	;ld hl,&3333
	ld de,&CC33

	;ld hl,&1221
	;ld de,&4884 
	call StarArray_InitColors

	;configure the loop for the enemy star array
	ld hl,StarLoopP1Hit


	ld iy,Player_Array
	ld a,(iy+4)	;invincibility
	and %11100000	
	jp z,StarArray_PlayerVunrable

	; player invincible
	ld hl,StarLoopP1Skip
StarArray_PlayerVunrable:
	; load player 1 location - do it in advance to save time during the loop

	ld a,(iy+1)
	dec a
	ld (Player1LocX_Plus1-1),a
	inc a
	inc a
	ld (Player1LocXB_Plus1-1),a

	ld a,(iy+0)
	dec a
	ld (Player1LocY_Plus1-1),a
	inc a
	inc a
	ld (Player1LocYB_Plus1-1),a


	ld (CurrentStarArrayCollisionsB2_Plus2-2),hl
	ld hl,&0000 :StarArrayMemloc_Enemy_Plus2

Starloop2_Start:


	ld a,b
	ld (starArraySizeForLoop_Plus1-1),a
	;Reset the star array to allow more stars to be added
	xor a 
	ld (StarArrayFullMarker_Plus1-1),a
Starloop2:

	ld a,(hl)	; Y
	or a
	jr Z,StarArray_Turbo	;Y=0 means a dead object in the array
	ld c,a
	;push bc
	push hl

		;ld de,&6969 CurrentStarArraySize_Plus2
		;add hl,de
		inc h
		ld b,(hl) ; X
		inc h
		;add hl,de

		ld d,(hl) ; M
	
		call DoMovesStars	; Slightly quicker than domoves
		
PlayerCollisions:


		ld a,c
		cp 0:Player1LocY_Plus1
		jp c,StarLoopP1Skip
		cp 0:Player1LocYB_Plus1
		jp nc,StarLoopP1Skip

		ld a,B
		cp 0:Player1LocX_Plus1
		jr c,StarLoopP1Skip
		cp 0:Player1LocXB_Plus1
		jr nc,StarLoopP1Skip

		jp PlayerCollisions :CurrentStarArrayCollisionsB2_Plus2
StarLoopP1Hit:
		call Player_Hit_Injure
		
StarLoopP1Skip:
StarCollisionsDone:
		ld (hl),d ;m
		;ld de,-255 CurrentStarArraySizeNegative_Plus2
		;add hl,de 
		dec h
		ld (hl),b ;X
		;add hl,de 
		dec h
		ld (hl),c ;Y

		;add hl,de
		ld a,24
		cp C
		jr NC,StarArray_Next
		cp B
		jr NC,StarArray_Next 
		call Stars_DrawDot	
		
StarArray_Next:
	pop hl
StarArray_Turbo:
	inc l
	ld a,00:starArraySizeForLoop_Plus1
	cp l
	jp nz,starloop2
	ret

Stars_DrawDot:	; Drawdot is also used for player center
	di
			ld a,b
			sub 24
			bit 0,a

			jr z,Stars_DrawDot_B2
				rra
				ld b,a
				ld a,c	
				sub 24
				ld c,a
				call GetMemPosDouble	;Get a pair of mempos
				;call GetMemPos		
		
			ld a,(hl)	
			and &CC
			;note - there is an intentional bug here - we should really load 
			;the following byte from the screen and OR that as well
			;but we skip it to save speed - the result is 2 pixels are 
			;wiped, but its a speed up with no real noticable difference

			or &33		:Stars_Color1a_Plus1
			ld (hl),a
			ex hl,de
			ld (hl),a
			ei
			ret


;			ex af,af'

;	ld a,h
;	add a,&08
;	ld h,a
;	jp  6969 GetNxtLinStarAJump_Plus2
;GetNxtLinStarA:
;	jp nc,GetNxtLinStarADone
;	jp GetNxtLinStarADoneB
;GetNxtLinStarAltA:
;	bit 7,h
;	jp z,GetNxtLinStarADone
;GetNxtLinStarADoneB:
;	ld de,&c050
;	add hl,de
;GetNxtLinStarADone


;			ex af,af'
;			ld (hl),a
;			ei
;			ret

Stars_DrawDot_B2:
				rra
				ld b,a
				ld a,c	
				sub 24
				ld c,a
				call GetMemPosDouble;GetMemPosQuickA
				;call GetMemPos		
			ld a,(hl)
			and &33
			or &CC		:Stars_Color2a_Plus1
			ld (hl),a

			ex hl,de
			ld (hl),a
			ei
			ret



;			ex af,af'


;	ld a,h
;	add a,&08
;	ld h,a
;	jp  6969 GetNxtLinStarBJump_Plus2
;GetNxtLinStarB:
;	jp nc,GetNxtLinStarBDone
;	jp GetNxtLinStarBDoneB
;GetNxtLinStarAltB:
;	bit 7,h
;	jp z,GetNxtLinStarBDone
;GetNxtLinStarBDoneB:
;	ld de,&c050
;	add hl,de
;GetNxtLinStarBDone
;			ex af,af'
;			ld (hl),a
;			ei
;ret

;bitmap
;defb &CC,&33,&26,&13


;Starbust code - we use RST 6 as an 'add command' to save memory - RST 6 calls IY
;See EventStreamDefinitions for details of how the 'Directions' work
Stars_AddBurst_TopLeft:
	ld hl,&0300
	rst 6
	ld hl,&0b08
	rst 6
	ld hl,&1310
	rst 6
	ld hl,&1b18
	rst 6
	ret

Stars_AddBurst_TopRight:
	ld hl,&0704
	rst 6
	ld hl,&0F0C
	rst 6
	ld hl,&1714
	rst 6
	ld hl,&1F1C
	rst 6
	ret

Stars_AddBurst_BottomLeft:
	ld hl,&2320
	rst 6
	ld hl,&2b28
	rst 6
	ld hl,&3330
	rst 6
	ld hl,&3b38
	rst 6
	ret

Stars_AddBurst_BottomRight:
	ld hl,&2724
	rst 6
	ld hl,&2f2c
	rst 6
	ld hl,&3734
	rst 6
	ld hl,&3f3c
	rst 6
	ret
Stars_AddBurst_Small:
	ld hl,&3631
	rst 6
	ld hl,&2e29
	rst 6
	ld hl,&2621
	rst 6
	ld hl,&1e19
	rst 6
	ld hl,&1611
	rst 6
	ret
Stars_AddBurst_Outer:
	ld hl,&3F38
	rst 6
	ld hl,&0F08
	rst 6


	ld iy,Stars_AddBurstStartOne	; Change RST6 call

	ld h,&37
	rst 6
	ld h,&2F
	rst 6
	ld h,&27
	rst 6
	ld h,&1F
	rst 6
	ld h,&17
	rst 6
	ld h,&31
	rst 6
	ld h,&29
	rst 6
	ld h,&21
	rst 6
	ld h,&19
	rst 6
	ld h,&11
	rst 6

	ret
Stars_AddBurst_Top:
	call Stars_AddBurst_TopLeft
	jr Stars_AddBurst_TopRight
Stars_AddBurst_Bottom:
	call Stars_AddBurst_BottomLeft
	jr Stars_AddBurst_BottomRight
Stars_AddBurst_Left:
	call Stars_AddBurst_TopLeft
	jr Stars_AddBurst_BottomLeft
Stars_AddBurst_Right:
	call Stars_AddBurst_TopRight
	jr Stars_AddBurst_BottomRight


Stars_AddObjectBatch:
	ld iy,Stars_AddBurstStart

	; B= pattern (0-15)
	; C = Y pos, D= X pos
	ld a,b
	cp 16			;radial blast!
	jp nc,Stars_AddObjectBatch2

	push hl			;
	ld hl,Stars_VectorArray

VectorJump_PushHlFirst:	;Jump to address No A at HL  - MUST PUSH HL Before Jumping here!
	push bc
	
		ld b,0
		ld c,a
		add hl,bc	;add twice for a two byte address
		add hl,bc
		ld a,(hl)		; read the two bytes in		
		inc hl
		ld h,(hl)
		ld l,a		; hl now is the memory loc of the line
		ld (VectorJump_Plus2-2),hl
	pop bc
	pop hl
	jp &0000 :VectorJump_Plus2

Stars_VectorArray:
defw	Stars_AddObject			;0 = just one
defw	Stars_AddBurst_TopLeft		;1
defw	Stars_AddBurst_BottomLeft	;2
defw	Stars_AddBurst_TopRight		;3
defw	Stars_AddBurst_BottomRight	;4
defw	Stars_AddBurst_Top		;5
defw	Stars_AddBurst_Bottom		;6
defw	Stars_AddBurst_Left		;7
defw	Stars_AddBurst_Right		;8
defw	Stars_AddBurst_TopWide		;9
defw	Stars_AddBurst_BottomWide	;10
defw	Stars_AddBurst_LeftWide		;11
defw	Stars_AddBurst_RightWide	;12
defw	Stars_AddBurst			;13
defw	Stars_AddBurst_Small		;14
defw	Stars_AddBurst_Outer		;15

Stars_AddToDefault:
	xor a
	ld (StarArrayStartPoint_Plus1-1),a
	ld a,(StarArraySize_Enemy) 
	ld (StarsAddObjectStarArraySize_Plus1-1),a
	ld hl,(StarArrayMemloc_Enemy)	   
	ld (StarsAddObjectStarArrayPointer_Plus2-2),hl
	
	ret
Stars_AddToPlayer:
	xor a
	ld (StarArrayStartPoint_Plus1-1),a
	ld a,(StarArraySize_Player) 
	ld (StarsAddObjectStarArraySize_Plus1-1),a
	ld hl,(StarArrayMemloc_Player)	   
	ld (StarsAddObjectStarArrayPointer_Plus2-2),hl

	ret
Stars_AddBurstStartOne:
	ld a,h
	dec a
	ld l,a
	jr Stars_AddBurstStart
Stars_AddBurst:
	ld hl,&3f07 ; FROM - TO
Stars_AddBurstStart:
	
	push hl
Stars_AddBurstOneOnly:

	ld l,h
	dec l
Stars_AddBurstStart2:
	pop ix
Stars_AddBurstLoop:
	
	push de
		push bc
			ld a,ixh
			ld (StarObjectMoveToAdd_Plus1-1),a
			call Stars_AddObject
		pop bc
	pop de
	dec ixh
	ld a,ixh
	cp &24 
	jr nz,Stars_AddBurstOk	; dont add a static star!
	dec ixh
Stars_AddBurstOk:
	cp ixl
	jr nz,Stars_AddBurstLoop
	ret


Stars_AddObject:
	; C = Y pos, D= X pos
	ld a,0 :StarArrayFullMarker_Plus1
	or a
	ret nz	; If A>0 we cannot add any stars as the loop is full!

	ld b,0		   :StarArrayStartPoint_Plus1
	ld hl,&6969	   :StarsAddObjectStarArrayPointer_Plus2
	
	ld a,l
	add b
	ld l,a

Stars_SeekLoop:	
	ld a,(hl)	; Y check
	or a	
	jp NZ,Stars_SeekLoopNext		; if Y<>0 then this slot is in use
	ld a,b
	ld (StarArrayStartPoint_Plus1-1),a

	;found a free slot!


	ld (hl),c	;Y
	;ld c,d
	;ld d,0
	;ld e,0 StarsAddObjectStarArraySize_Plus1
	inc h	;add hl,de

	ld (hl),d	;X

	
	inc h	;add hl,de
	ld (hl),&0  	:StarObjectMoveToAdd_Plus1	;**** THIS SHOULD BE THE MOVE - need to finish coding!
;	add hl,de

	ret
Stars_SeekLoopNext:
	inc l;inc hl
	inc b
	ld a,0 :StarsAddObjectStarArraySize_Plus1
	cp b 
	jr nz,Stars_SeekLoop
	ld a,1
	ld (StarArrayFullMarker_Plus1-1),a
	ret

Stars_AddBurst_TopWide:
	ld hl,&1d1a
	rst 6
	ld hl,&1512
	rst 6
	ld hl,&0d0a
	rst 6
	ret
Stars_AddBurst_RightWide:
	ld hl,&2f2c
	rst 6
	ld hl,&2725
	rst 6
	ld hl,&1f1c
	rst 6
	ret
Stars_AddBurst_LeftWide:
	ld hl,&1b18
	rst 6
	ld hl,&2220
	rst 6
	ld hl,&2b28
	rst 6
	ret
Stars_AddBurst_BottomWide:
	ld hl,&2d2a
	rst 6
	ld hl,&3532
	rst 6
	ld hl,&3d3a
	rst 6
	ret



Stars_AddObjectBatch2:
	; a= pattern (16+)
	; C = Y pos, D= X pos
	sub 16
	ld hl,StarsOneByteDirs
	push de
		ld d,0
		ld e,a
		add hl,de
	pop de
	ld a,(hl)	
	ld (StarObjectMoveToAdd_Plus1-1),a
	jr Stars_AddObject
StarsOneByteDirs:
defb &21,&09,&0C,&0F,&27,&3F,&3C,&39,&61,&49,&4c,&4f,&67,&7f,&7c,&79
;    16   17  18 19   20  21  22 23   24, 25 ,26, 27,28 , 29,30 , 31


;See EventStreamDirections for details of how DoMoves works
DoMoves: 

	; B=X C=Y D=Move
	;SDYYYXXX	S=1 means 'special move'
	; all others work in the format D = Doubler (speed up move)
	; YYY Y movement bits
	; XXX X movement bits

	bit 7,d			; See if we are using a SPECIAL move pattern
	jr nz,DoMoves_Spec
DoMovesStars: 			
	ld a,D
	and %00111000
	rrca
	rrca
	;rrca

	sub 8
	;sub 4
	bit 6,d
	jr z,DoMoves_NoMult2
	 rlca
	DoMoves_NoMult2:

	add C

;	jp PE,DoMoves_Kill	;overflow
	cp 199+24		;we are at the bottom of the screen
	jr NC,DoMoves_Kill	;over the page
;	cp 0			;we are at the bottom of the screen
;	jr C,DoMoves_Kill	;over the page
	ld c,a


	ld a,D
	and %00000111
	sub 4
	bit 6,d
	jr z,DoMoves_NoMult
		 rlca
	DoMoves_NoMult:
	add b

	cp 160+24		;we are at the bottom of the screen
	jr NC,DoMoves_Kill	;over the page
;	cp 0			;we are at the bottom of the screen
;	jr C,DoMoves_Kill	;over the page
	ld b,a

	
	ret
DoMoves_Kill:			; Object has gone offscreen
	ld C,0
	;ld B,0
	;ld C,b		 ; shouldn't need these! only Y needs to be Zero to mark object as dead
	;ld D,b
	ret
DoMoves_Background:	; Background sprites move much more slowly, and only in 1 direction
	ld a,d
	and %00001111	
	rla
	ld e,a
	;--DDXXXX
	;DD= direction
	;XXXX tick point
	ld a,(Timer_TicksOccured)
	and e
	ret z
	; time for a left move

	dec b		:DoMovesBGShift_Plus1	;check xpos 
	ld a,b
	cp 160+24+24		;we are offscreen
	jr NC,DoMoves_Kill	;over the page
	ret
DoMoves_Spec:	;Special moves - various kinds
	ld a,d
	and %11110000	;
	cp %11000000	;1100XXXX ; Background
	jr z,DoMoves_Background	


;	cp %10010000	;1001XXXX ; Wave
;	jr z,DoMoves_WaveSmall
	cp %10100000	;1010XXXX ; Wave
	jr z,DoMoves_Wave				;Wave pattern - pretty naff, but it seemed a good idea at the time


	; Level specifics are overriden by the code in the level
	cp %10110000 	;1011XXXX ; Level Specific 4
	jp z,null 	:LevelSpecificMoveD_Plus2
	cp %11010000 	;1101XXXX ; Level Specific 3
	jp z,null 	:LevelSpecificMoveC_Plus2
	cp %11100000 	;1110XXXX ; Level Specific 2
	jp z,null 	:LevelSpecificMoveB_Plus2
	cp %11110000 	;1111XXXX ; Level Specific 1
	jp z,null 	:LevelSpecificMove_Plus2

	ld a,d		;1000XXXX
	and %11111100	;101111XX
	cp  %10000100
	jr z,DoMoves_Seeker			; Used by 'Chu attack' - and also coins!
	ret
DoMoves_Wave:
	;		    3210
	; wave pattern  1010DSPP	D = Depth bit, S= Speed, PP Position

	ld a,b
	bit 3,d
	jr nz,DoMoves_TwoShifts
	srl a
	srl a
DoMoves_TwoShifts:
	;srl a	; unrem for speedup
	and %00011111
	cp  %00010000
	jr C,DoMoves_WaveContinue
	xor %00011111
DoMoves_WaveContinue:
	bit 2,d
	jr nz,DoMoves_WaveSlowSpeed
	sll a
	
DoMoves_WaveSlowSpeed
	sll a
	sll a   ; rem to reduce wave depth

	ld C,a
	ld a,d
	and %0000011
DoMoves_WaveEnd
	rrca
	rrca
	rrca		; equivalent to 5 left shifts
	or %00011100

	add C
	ld C,a

	dec B
	;ld a,B
	;sub 1
	;ld B,A
	cp 24			;we are at the bottom of the screen
	jr C,DoMoves_Kill	;over the page
	ret

DoMoves_Seeker:			;Home in on player
	push de
	ld a,d
	and %00000011	; Speed
	sll a
	inc a
	ld d,a
	ld a,r			; Crude randomizer, as we move so fast the object may never hit the player otherwise
	bit 0,a
	jr z,DoMoves_SeekerS
	inc d
DoMoves_SeekerS:
	push iy

		; B=X C=Y D=Move speed

		ld iy,Player_Array


		ld a,(iy)	;Y
		sub 8
		cp C
		jr NC,DoMoves_Seeker_Ylower
		ld a,C
		sub d
		jr DoMoves_Seeker_CheckX
	DoMoves_Seeker_Ylower:
		ld a,C
		add d
	DoMoves_Seeker_CheckX:
		ld C,a
		ld a,(iy+1)	;X
		sub 3
		cp B
		jr NC,DoMoves_Seeker_Xlower
		ld a,B
		sub d
		jr DoMoves_Seeker_Done
	DoMoves_Seeker_Xlower:
		ld a,B
		add d
	DoMoves_Seeker_Done:
		ld B,a

	pop iy
	pop de
	ret
; 
; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			 Keyboard Reader

;***************************************************************************************************
;--------------------------------------------------------------------------------------------


; Don't ask me how this works - someone smarter than me wrote it!


KeyboardScanner_Flush equ &BB03

;This is the raw keypress data
KeyboardScanner_KeyPresses  ds 10  
;map with 10*8 = 80 key status bits (bit=0 key is pressed)

KeyboardScanner_Read:
	di              ;1 ##%%## C P C   VERSION ##%%##
        ld hl,KeyboardScanner_KeyPresses    ;3
        ld bc,#f782     ;3
        out (c),c       ;4
        ld bc,#f40e     ;3
        ld e,b          ;1
        out (c),c       ;4
        ld bc,#f6c0     ;3
        ld d,b          ;1
        out (c),c       ;4
        ld c,0          ;2
        out (c),c       ;4
        ld bc,#f792     ;3
        out (c),c       ;4
        ld a,#40        ;2
        ld c,#4a        ;2 44
KeyboardScanner_Loop
	ld b,d          ;1
        out (c),a       ;4 select line
        ld b,e          ;1
        ini             ;5 read bits and write into KEYMAP
        inc a           ;1
        cp c            ;1
        jr c,KeyboardScanner_Loop       ;2/3 9*16+1*15=159
        ld bc,#f782     ;3
        out (c),c       ;4
        ei              
        ret



KeyboardScanner_ScanForOne:
	call KeyboardScanner_Read

	ld b,10
	ld c,0
	ld hl,KeyboardScanner_KeyPresses
KeyboardScanner_WaitForKey_Check:
	ld a,(hl)
	cp 255
	ret nz
	inc hl
	inc c
	djnz KeyboardScanner_WaitForKey_Check
	ret

KeyboardScanner_WaitForKey:
	call KeyboardScanner_ScanForOne
	cp 255
	jr nz,KeyboardScanner_WaitForKey
KeyboardScanner_WaitForKey2:
	call KeyboardScanner_ScanForOne
	cp 255
	jr z,KeyboardScanner_WaitForKey2
	ret


; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			 Super simple Disk reader

;***************************************************************************************************
;--------------------------------------------------------------------------------------------
LoadDiscSector_NoDiskCheck:	;Skip the disk check, just assume the disk is in
		ld a,c
		add 48
		ld (hl),a

jr LoadDiscSector_NoDiskCheckReturn
LoadDiscSector:				; This was all structured assuming amsdos would be replaced with 
	; H = Track  (41)		; a sector based disk reader however with the success of M4
	; L = Sector (C1)		; and C4CPC - and the fact KL_WALK_ROM seems to restore the
	; I = Disk   (00)		; A600-BF00 block so well, it was never needed
	; B = Size - size is not used at all , no need to pass it
	; C = disk
	;  A  = 128 k memory bank
	;; DE = load address 

	ld (DiskLoadBank_Plus1-1),a	; if asked to load to a mem bank >0 on 64k do nothing
ifdef Support64k
	or a
	jr z,LoadDiscSector_64kOk
	ld a,(CPCVer)
	and 64
	ret nz		; Told to load a file into 128k memory!
endif
LoadDiscSector_64kOk:
;push af

	push hl
	ld hl,DiskFilePos_Plus1-1


	ld a,(SetDiskMessageDisk)
	sub &80+48
	cp c
	ifdef SingleDisk
		jr LoadDiscSector_NoDiskCheck	; The disk is still in
	endif 

	jr z,LoadDiscSector_NoDiskCheck	; Disk Zero means file is assumed to be on 
	;ALL Disks

		ld a,c
		add 48

		ld (hl),a

		add &80

		cp &80+48
		jr z,DiskZero
		ld hl,SetDiskMessageDisk
		;ld a,c
		;add &80+48
		ld (hl),a
		Call ShowDiskMessage
		;call CLS
DiskZero: ;file common to all disks
LoadDiscSector_NoDiskCheckReturn:
	pop hl
;pop af
	; Patch the filename with Sector and track info
	push de
		ld b,h
		ld c,l
		ld a,h
		push bc
			ld a,b
			call SectorFile_Decimal
			ld hl,SectorFileName+1
			ld a,c
			add 48
			ld (hl),a
			inc hl
			ld a,b
			add 48
			ld (hl),a
		pop bc
		ld a,c
		sub &C0-48
		ld bc,&0004
		add hl,bc
		ld (hl),a
	pop de
	ld hl,SectorFileName
	jr LoadDiskFileFromHL

	

SectorFileName: 
	db "T00-SC1 .D"

	db"00":DiskFilePos_Plus1
SetDiskMessage:
	db "Set Disk "
SetDiskMessageDisk:	db  "1"+&80

SectorFile_Decimal:	; Decimal to Ascii converter
	ld c,0
SectorFile_DecimalSubTen:
	cp 10
	jr c,SectorFile_DecimalLessThanTen
	inc c
	sub 10
	jr SectorFile_DecimalSubTen
SectorFile_DecimalLessThanTen:
	ld b,a
	ret


cas_in_open equ &bc77
cas_in_direct equ &bc83
cas_in_close equ &bc7a
txt_set_cursor equ &bb75

LoadDiskFileFromHL:	; Load a file from HL memory loc
	push hl	
	push de
		;push hl
	
		push hl
			ld hl,&0A0F		; Move cursor so errors dont wrap I don't hide them
			call txt_set_cursor	; so we can see if a problem happened
		pop hl

		ld de,&C000	;; address of 2k buffer, this can be any value if the files have a header
		ld b,12		;12 chars

		call cas_in_open	; carry true if sucess
	pop de
	ld h,d
	ld l,e
	jr nc,DiskError1
DiskRetry2:

	ld a,0:DiskLoadBank_Plus1
	push bc
		call BankSwitch_128k	; switch to bank A
	pop bc
	call cas_in_direct	; carry true if sucess

	jr nc,DiskError2
	pop hl
	call BankSwitch_128k_Reset ; Restore the previous bank
	jp cas_in_close
DiskError1:
	;call 	ShowDiskMessage
	;pop hl
	;jr LoadDiskFileFromHL

DiskError2:
	call 	ShowDiskMessage
	pop hl
	jr LoadDiskFileFromHL

ShowDiskMessage:		;Show the error messages
		push bc
		push de


			;ld e,1
			;ld hl,RasterColors_Safe
			;call RasterColors_NoDelay
			call RasterColors_DefaultSafe
			ld a,3*3		;Loading
			call ShowCompiledSprite

			call BankSwitch_128k_Reset ; Restore the previous bank
			;call SpriteBank_Font
			ld hl,&7000			;The font in the Bootstrap
			call ShowSprite_SetBankAddr
		
			ld hl,&160a :SetDiskMessagePos_Plus2
			ld bc,SetDiskMessage
			call DrawText_LocateAndPrintStringUnlimited
			call KeyboardScanner_WaitForKey
			;call CLS

			call ShowCompiledSpriteLoading

		pop de
		pop bc
ret


RasterColors_DefaultSafe:
	ld hl,RasterColors_Safe
	jr RasterColors_Blackoutb

RasterColors_Blackout:
	ld hl,RasterColors_Black
RasterColors_Blackoutb:
	ld e,1
	jp RasterColors_NoDelay

ExecuteBootStrap:		;Run or load the bootstrap - it takes a two part Hex command
	push hl			;ALL Disk ops are done through the bootstrap!
	di
	ifdef SupportPlus
		call Plus_HideSprites
	endif
ExecuteBootStrapSkipPlus:

		call RasterColors_Disable	
		call ply_stop
		
		ifdef Debug
		call Debug_CheckIntOff
		endif 

	
		call ScreenBuffer_Reset	; Screenbuffer reset messes with EXX vars!
		call Firmware_Restore
		call RasterColors_Blackout


		;Screenbuffer reset does this already
		;ld a,0			;Reset to normal memory bank
		;call BankSwitch_128k_SetCurrent



		ld a,(CPCVer)
		and 128
		jr nz,BootstrapInram
ifdef Support64k
		;64k version - load into &4000 every time
		ld de,&4000
		ld hl, BootStrapFile
		call LoadDiskFileFromHL
		;call &4009 ;Bootstrap_FromHL
		jr StartBootstrap
endif 
BootstrapInram:
		ld a,5					;Bootstrap in memory on 128k
		call BankSwitch_128k_SetCurrent

StartBootstrap:
	pop hl 
	ei
	call  &4006 ;Bootstrap_FromHL 
	di
	ld a,0:BootstrapRamRestore_Plus1
	jp BankSwitch_128k_SetCurrent
BootStrapFile:
	db "BootStrp.Aku"



; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			 Text Driver

;***************************************************************************************************
;--------------------------------------------------------------------------------------------

;DrawText_SetPen equ &bb90 ;set pen to A
;DrawText_Locate equ &bb75 ; set location to X=L , Y=H
;DrawText_PrintChar equ &bb5a

; These were designed to mimic firmware functions
DrawText_LocateAndPrintStringUnlimited:
	ld a,255
	ld i,a
DrawText_LocateAndPrintString:
	call DrawText_LocateSprite
DrawText_PrintString:
	; I Limits the number of characters to be show,
	; used for 'typing' effect during the boss sequences, and intro
	ld a,i		
	dec a
	ret z
	ld i,a
	ld a,(bc)
	cp a,&80
	jr nc,DrawText_PrintLastChar
	Call DrawText_CharSpriteProtectBC
	inc bc
	jp DrawText_PrintString
DrawText_PrintLastChar:
	and %01111111
DrawText_CharSpriteProtectBC:
	push bc
		call DrawText_CharSprite; draw char
	pop bc
	ret
	
DrawText_PrintHex:

	push af         ;store original byte value
		rrca            
		rrca
		rrca
		rrca
		call DrawText_PrintHexDigit
	pop af          ;retrieve original byte value

DrawText_PrintHexDigit:
	;	and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
	;	add a,"0"       ;add ASCII for 0. Digits 0...9 become "0"..."9", digits 10..15
	;	cp "9"+1        
	;	jr c,ShowHexDigitNum     ;if number is in digit range 0...9, display digit
	;	add a,"A"-"9"-1 ;modify ASCII value so that digits in the range 10...15
	and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
	cp &a           ;Less than 10?  Set carry if so
	sbc a,&69
	daa             ;Because previous instruction was a subtract operation this
                ;is known as 'das' in x86
DrawText_PrintHexDigitNum:
	jp DrawText_CharSprite  ;display digit







DrawText_LocateSprite:	; this mimics the way the firmare functions work  (DrawText_Locate)

	ld a,l
	add a
	add a
	add a
;	add 24
	ld (SprShow_Y),a
	ld a,h
	add a
;	add 24
	ld (SprShow_X),a

	;ld hl,&C000
	;ld (SprShow_BankAddr),hl
ret


; equiv of DrawText_PrintChar
DrawText_CharSprite:		; Must have already set the correct bank!
	ld b,2

DrawText_CharSpriteDirect:
	sub 33	

	ld (SprShow_SprNum),a
	ld e,a
		ld a,(SprShow_X)
		ld (SprShow_TempX),a		; move the cursor along for next char
		ld d,a
		add b
		ld (SprShow_X),a	
		ld a,(SprShow_Y)
		ld (SprShow_TempY),a
		ld c,a

	ld a,e
	cp 192
	ret NC	; Our font has no space! so dont draw anything below 32 (above 192)

ifdef Support64k
	ld a,(CPCVer)
	and 64
	jr nz,DrawText_CharFirmwareFont
endif
	jp ShowSpriteDirect 
ifdef Support64k
DrawText_CharFirmwareFont:
	ld b,d
	push de
		call GetMemPos
	pop de
	push hl
		ld hl,33*8+&3800

		ld d,0

		rl e
		rl d
		rl e
		rl d
		rl e
		rl d
	;	rlc e
	;	rl d
		add hl,de
		ld d,h
		ld e,l
	pop hl
	di
	ld bc,&7f81	; Reset the firmware to ON
	out (c),c
	ld b,8
DrawText_DicharSprite_NextLine:
	ld a,(de)
	ld c,a
	and &0F
	inc hl
	ld (hl),a
	dec hl
	ld a,c
	and &F0
	rrca
	rrca
	rrca
	rrca
	ld (hl),a


	push de
		call GetNxtLin
	pop de
	inc de
	djnz DrawText_DicharSprite_NextLine

	ld bc,&7f8D	; Reset the firmware to OFF
	out (c),c
	ei
	ret

endif
	


; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			 Music & SFX
;***************************************************************************************************
;--------------------------------------------------------------------------------------------

;
; Note - the version of ArkosTracker has had many of its functions removed,
; if this SFX function can't do what you want, neither can this arkostracker!
;

SFX_PlaySfx:				
	ld a,&00 :Sfx_Sound_Plus1
	or a	
	ret z
	ld l,a

	;di
		;ld e,1	; stop channel 1
		;push hl
		;call PLY_SFX_Stop
		;pop hl
		ld e,&00 :Sfx_Note_Plus1


;		ld c,0		; pitch 0
;		ld b,c		; Pitch 0
;		ld d,0;0	Sfx_Speed_Plus1	; Speed 0
;		ld h,&0F	;Vol
;		ld a,1		;channel - always 1

		call PLY_SFX_Play
	;ei
	xor a
	ld (Sfx_CurrentPriority_Plus1-1),a	; clear the to-do
	ld (Sfx_Sound_Plus1-1),a	; clear the note
ret

;This is our quick 'make a sound' function
SFX_QueueSFX_GenericHighPri:
	ifdef Debug
		call Debug_NeedEXX
	endif

	di
	exx
		ld d,20	; Priority Low
		jr SFX_QueueSFX_GenericPriCustom
SFX_QueueSFX_Generic:
	ifdef Debug
		call Debug_NeedEXX
	endif

	di
	exx
		ld d,10	; Priority Low
SFX_QueueSFX_GenericPriCustom:
		ld b,a	;sfx A
		ld c,70	; pitch 70
		call SFX_QueueSFX
	exx
	ei
	ifdef Debug
		call Debug_ReleaseEXX
	endif

ret

SFX_QueueSFX:
	; D= priority , zero = low, 1=high (replace pending)
	; B = Sfx
	; C = Pitch (70 = middle)

;A = No Channel (0,1,2)
;L = SFX Number (>0)
;H = Volume (0...F)
;E = Note (0...143) (0 is the lowest, 143 the highest)
;D = Speed (0 = As original, 1...255 = new Speed (1 is the fastest))
;BC = Inverted Pitch (-&FFFF -> &FFFF). 0 is no pitch (=the original sound). The higher the pitch, the lower the sound.

	ld a,&00:Sfx_CurrentPriority_Plus1
	;jp z,SFX_PlaySFX_NothingPlaying
	cp d
	ret nc ; we're have queued something already, and this sound is low priority
	ld a,b
	ld (Sfx_Sound_Plus1-1),a
	ld a,c
	ld (Sfx_Note_Plus1-1),a		; queue up the sfx for the playloop
	ld a,d
	ld (Sfx_CurrentPriority_Plus1-1),a
	ret

; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			 Raster Colors

;***************************************************************************************************
;--------------------------------------------------------------------------------------------
RasterColors_SetPointers:			; Pass A, a=0 means reset to defaults
	or a					; A=1 means set to custom mem locations
	jp nz,RasterColors_SetPointersCustom
	ld bc,RasterColors_ColorArray1
	ld de,RasterColors_ColorArray2
	ld hl,RasterColors_ColorArray3
	ld ix,RasterColors_ColorArray4
	ld iy,null

 
RasterColors_SetPointersCustom:
	ld (RasterColors_ColorArray1Pointer_Plus2-2),bc
	ld (RasterColors_ColorArray1PointerB_Plus2-2),bc
	ld (RasterColors_ColorArray2Pointer_Plus2-2),de
	ld (RasterColors_ColorArray3Pointer_Plus2-2),hl
	ld (RasterColors_ColorArray4Pointer_Plus2-2),ix
	ld (RasterColors_PerFrameCallRestore_Plus2-2),iy
ret
RasterColors_Disable:			;Turn off our interrupt
	ld hl,null
	ld (&0039),hl
	jp PLY_Stop

RasterColors_Init:				;Set up our interrupt
	;jr RasterColors_RestoreInterrupt
	;jr RasterColors_Init_Firmware

RasterColors_RestoreInterrupt:

	call RasterColors_DefaultSafe

	ld hl, RasterColors_TickOverrideFirm :RasterColorInterruptHandler_Plus2	; New Custom Interrupt version
	ld (&0039),hl				; Patch in our firmware handler

	ld hl,null:RasterColors_PerFrameCallRestore_Plus2
	ld (RasterColors_PerFrameCall_Plus2-2),hl
RasterColors_Reset:
	di
	ld de,RasterColors_1
	ld (RasterColors_TickJump_Plus2-2),de
	ei
	ret




; These are all due to be deleted, because they no longer do anything
RasterColors_off:
RasterColors_Init_Firmware:
RasterColors_StopMusic:
RasterColors_MusicOnly:
	ifdef debug
		call Debug_ObsoleteCode
	endif
ret

;RasterColors_TickerEventBlock2
;	defs 10
;; this is the function called each 1/300th of a second
;InterruptPlaySoundFirmware
;	di
;	push af
;	push bc
		;ex af,af'
		;exx
;		call InterruptPlaySound
		;ex af,af'
		;exx
;	pop bc
;	pop af
;	ei
;ret
; trying to write an interrupt handler
RasterColors_TickOverrideFirm:
;	di
	exx
	ex af,af'
	;di

	;; test VSYNC state
	ld      b,&f5
	in      a,(c)
	rra     
;	 jr      nc,RasterColors_TickRun

	call c,RasterColors_TopOfScreen

RasterColors_TickRun:
	call RasterColors_Tick


RasterColors_DoneInterrupt:		; end of our interrupt routine

;ifdef debug
;	ld      hl,&b8b4
;TimeUpdateRepeat
;	inc     (hl)		used for stopwatch, but not really needed
;	inc     hl
;	jr      z,TimeUpdateRepeat  
;endif

	ex af,af'
	exx
	ei
	;exx
	ret

RasterColors_All:	; Our color handler

	ld (RasterColors_TickJump_Plus2-2),a
	ld e,(hl)            
	ld a,e
	or a
	ret z;jr z,RasterColors_Done
	inc l
 

RasterColors_MoreColors:
	ld b,(hl)            
	inc l
 	ld a,b
	or a	
	jr z, RasterColors_NoDelay
RasterColors_Delay1:
	push af				;Simple delay routine
	pop af
	djnz RasterColors_Delay1
RasterColors_NoDelay:

;; get colour byte from table

	ld bc,&7f00               ;; [3]

	out (c),c                 ;; [4]
	;ld a,(hl)                 ;; [2]
	;inc l                     ;; [2]
	;out (c),a                 ;; [4]
	outi
	inc b			;Get B back to the way it was before outi messed!
	inc c

	out (c),c                 ;; [4]
	;ld a,(hl)                 ;; [2]
	;inc l                     ;; [2]
	;out (c),a                 ;; [4]
	outi
	inc b
	inc c



	out (c),c                 ;; [4]
	;ld a,(hl)                 ;; [2]
	;inc l                     ;; [2]
	;out (c),a                 ;; [4]
	outi
	inc b
	inc c

	out (c),c                 ;; [4]
	;ld a,(hl)                 ;; [2]
	;inc l                     ;; [2]
	;out (c),a                 ;; [4]
	outi
	;inc b
	;inc c



;; delay so that the next colour change
;; occurs immediatly below this one
	;ld b,2
	;RasterColors_Delay2:
	;djnz RasterColors_Delay2

	dec e     			;Loop if there are more colors
	ret z               
	jp RasterColors_MoreColors
;RasterColors_Done
	;ei
	;ret


; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			Safe Interrupts

;***************************************************************************************************
;--------------------------------------------------------------------------------------------
; These are my 'safe' interrupt controls to stop bugs happening, 
; but they were written after the rest of the code was working so aren't really used!
; I'm sure they were a good idea, I just didn't think of them fast enough!
Interrupts_BlockInterrupts:
	ld a,#f3 ;DI
	di
	jr Interrupts_BlockInterruptsApply
Interrupts_AllowInterrupts:
	ld a,#fb ;EI
	ei
Interrupts_BlockInterruptsApply:
	ld (Interrupts_BlockableCommand_Plus1-1),a
	ret
Interrupts_EnableInterrupts:
	di :Interrupts_BlockableCommand_Plus1
	ret

Interrupts_PauseInterrupts: ; check if interrupts are disabled
	ld a,i
	di
	ld a,#f3 ;DI
	jp po,Interrupts_PauseInterruptsApply
	ld a,#fb ;EI
Interrupts_PauseInterruptsApply:
	ld (Interrupts_ReEnableIfRequiredCommand_Plus1-1),a
	ret

Interrupts_ResumeInterrupts: ; check if interrupts are disabled
	di :Interrupts_ReEnableIfRequiredCommand_Plus1
	ret

; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			Screen Buffer

;***************************************************************************************************
;--------------------------------------------------------------------------------------------

;We have Code which needs to be altered depending on our screen location, we do it all here
;to save time
SetActiveScreenJumps:	;ld a,(ScreenBuffer_ActiveScreen)
	di
	ld (ScreenBuffer_ActiveScreenDirect_Plus1-1),a
ifndef MinimizeCore
	ld (ScreenBuffer_ActiveScreenDirectB_Plus1-1),a
endif
	cp &c0
	jr nz,Player_StarArray_Alt;Player_StarArray_Default
	;jr Player_StarArray_Alt
	;setup our linejumps
Player_StarArray_Default:
;	ld bc,GetNxtLinStarB
;	ld de,GetNxtLinStarA
	ld hl,GetNxtLin24px
	ld ix,GetNxtLinPset
	;ld a,(ScreenBuffer_ActiveScreen)
	
	exx

	ld hl,Background_GetNxtLin
	ld bc,GetNxtLinMain
	jr Player_StarArray_Prep2
Player_StarArray_Alt:
;	ld bc,GetNxtLinStarAltB
;	ld de,GetNxtLinStarAltA
	ld hl,GetNxtLinAlt24px
	ld ix,GetNxtLinPsetAlt

	exx

	ld hl,Background_GetNxtLinAlt
	ld bc,GetNxtLinAlt
Player_StarArray_Prep2:
	ld (GetNxtLinJump_Plus2-2),bc
	ld (Background_NextLineJump_Plus2-2),hl

	exx
;	ld (GetNxtLinStarAJump_Plus2-2), de
;	ld (GetNxtLinStarBJump_Plus2-2), bc
	ld (SprDrawTurboLineJump_Plus2-2), hl
	ld (SprDrawPsetLineJump_Plus2-2), ix

	ei	;ScreenJumpsReEnableInterrupts_Plus1
	ret

ScreenBuffer_GetActiveScreen:
	ld a,(ScreenBuffer_ActiveScreen)
	ret


ScreenBuffer_Reset:	;set everything back up to defaults (no screenbuffer screen at C000
	xor a ;a=0
	call BankSwitch_128k_SetCurrent
	ld a,&c0
ScreenBuffer_Alt:
	ld (ScreenBuffer_ActiveScreen),a
	call SetActiveScreenJumps

	push af
	call SetScreenMemPos


;		ld hl,&0000
;		push hl
;			call mc_screen_offset
;
;		pop hl
;	pop af
;	push af
;		call scr_set_position
	pop af
	ld b,a
	jr ScreenBuffer_SwapDone
SetScreenMemPos: ;basic version of call mc_screen_offset

		rrca    
		rrca    
		and     &30
		 ld      bc,&bc0c			
		 out     (c),c			; select CRTC register 12
		 inc     b				; BC = bd0c
	 	 out     (c),a			; set CRTC register 12 data
		 ;dec     b				; BC = bc0c
		 ;inc     c				; BC = bc0d
		 ;out     (c),c			; select CRTC register 13
		 ;inc     b				; BC = bd0d
		 ;xor a
		 ;out     (c),a			; set CRTC register 13 data
	ret


ScreenBuffer_Init:

	ld a,&40
	ld (ScreenBuffer_VisibleScreen),a
	ld a,&C0
	ld (ScreenBuffer_ActiveScreen),a
ScreenBuffer_Flip:
	call ScreenBuffer_SwapVariables
ScreenBuffer_Apply:
	ld a,(ScreenBuffer_VisibleScreen)
	;ld hl,&0000
	;push hl
;	call mc_screen_offset
	call SetScreenMemPos
	;  push    bc
	 ; rrca    
	 ; rrca    
	 ; and     &30
	 ; ld      c,a
	 ; ld      a,0
	 ; rra     
	 ; and     &03
	 ; or      c

	;; CRTC register 12 and 13 define screen base and offset

	;ld      bc,&bc0c			
	;out     (c),c			; select CRTC register 12
	;inc     b				; BC = bd0c
	;out     (c),a			; set CRTC register 12 data
	
	;dec     b				; BC = bc0c
	;inc     c				; BC = bc0d
	;out     (c),c			; select CRTC register 13
	;inc     b				; BC = bd0d

	;ld      a,h
	;rra     
	;ld      a,l
	;rra     

	;out     (c),a			; set CRTC register 13 data
	;pop     bc
; screen offset command copied from firmware

ifdef Support128k
	ld a,(CPCVer)
	and 128
	jr nz,ScreenBuffer_128k
endif
;	ld hl,&0000
	;64k ver	
ifdef Support64k
	ld a,(ScreenBuffer_ActiveScreen)
	jp SetActiveScreenJumps
endif
	;pop hl
;	jp scr_set_position


	;64k ver	
ifdef Support128k 
ScreenBuffer_128k:
;128 ver Patch in Bank 7 at C000, Flip between Bank 1 and 3 at 4000
;You can always write to 4000 and it will be shown onscreen next time

	;pop hl
	ld a,&40
	ld (ScreenBuffer_ActiveScreen),a
	call SetActiveScreenJumps

ScreenBuffer_128kResetBanks
	ld a,(ScreenBuffer_VisibleScreen)
	cp &c0
	jr z,ScreenBuffer_MemoryDefault
ScreenBuffer_MemoryAlternate:
	ld a,3
	jr BankSwitch_128k_SetCurrent
ScreenBuffer_MemoryDefault:
	ld a,1
	jr BankSwitch_128k_SetCurrent
endif

ScreenBuffer_SwapVariables:
	ld a,(ScreenBuffer_VisibleScreen)
	ld b,a
	cp &c0
	ld a,&40
	jp z,ScreenBuffer_SwapDone
	ld a,&c0
ScreenBuffer_SwapDone:

	ld (ScreenBuffer_VisibleScreen),a

	;ld a,(ScreenBuffer_ActiveScreen)
	;call ScreenBuffer_FlipBytes
	ld a,b
	ld (ScreenBuffer_ActiveScreen),a
	ret

; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			Compiled Sprive Viewer

;***************************************************************************************************
;--------------------------------------------------------------------------------------------
; Compiled sprites are just machine code programs to render loading/continue etc screens
; we run them from here to allow the 64k override to be standardised

CLS:
	; clear the screen
	call ScreenBuffer_GetActiveScreen
	ld d,a
	ld h,a
	ld e,&01
	ld BC,&3FFF
	xor a
	ld l,a
	ld (hl),a
	ldir
ret
ShowCompiledSpriteLoading:
ld a,0*3		;Loading
ShowCompiledSprite:	; show compiled sprite A (multiplied by 3
	;ld a,(BankSwitch_128k_Current_Plus1-1)
	;push af
		ld l,a
ifdef Support64k	
		ld a,(CPCVer)		; 464 can't do comiled sprites, so just CLS
		and 64
		jr nz,cls
endif

		ld a,6			;Compiled sprites are in bank 6
		ld h,&40 
		jr BankSwitch_128k_CallHL
		
		;call CallHL
	;pop af
	;jr BankSwitch_128k_SetCurrent

; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			Bank Call - Call a location in a different bank then return

;***************************************************************************************************
;--------------------------------------------------------------------------------------------
CallHL:
	push hl
	ret

BankSwitch_128k_CallHL:
	call BankSwitch_128k	; switch to bank A
BankSwitch_128k_CallHLDirect:
	call CallHL
	;ld (BankSwitch_128k_Callpoint_Plus2-2),hl
	;call &0000 BankSwitch_128k_Callpoint_Plus2
	jr BankSwitch_128k_Reset ; Restore the previous bank

BankSwitch_128k_BankCopy:
	push bc
		call BankSwitch_128k
	pop bc
	ldir
	jr BankSwitch_128k_Reset ; Restore the previous bank

BankSwitch_128k_SetCurrent:				; This allows us to remember 'current' bank
	ld (BankSwitch_128k_Current_Plus1-1),a
	or %11000000
	LD B,&7F ;Gate array port
;	ld (BankSwitch_128k_CurrentB_Plus2-2),a
	OUT (C),A ;Send it
	ret

	;jr BankSwitch_128k
BankSwitch_128k_Reset:
	ld a,&00:BankSwitch_128k_Current_Plus1
BankSwitch_128k:
	;LD BC,&7F00 ;Gate array port
	LD B,&7F ;Gate array port
	or %11000000 ;Switch to ram config A (A < 7!)
	OUT (C),A ;Send it
	ret
;-Address-	0	1	2	3	4	5	6	7
;0000-3FFF	RAM_0	RAM_0	RAM_4	RAM_0	RAM_0	RAM_0	RAM_0	RAM_0
;4000-7FFF	RAM_1	RAM_1	RAM_5	RAM_3	RAM_4	RAM_5	RAM_6	RAM_7
;8000-BFFF	RAM_2	RAM_2	RAM_6	RAM_2	RAM_2	RAM_2	RAM_2	RAM_2
;C000-FFFF	RAM_3	RAM_7	RAM_7	RAM_7	RAM_3	RAM_3	RAM_3	RAM_3

	
; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			Firmware Switch

;***************************************************************************************************
;--------------------------------------------------------------------------------------------

Firmware_Kill:	; firmwares? we don't need no steenking firmwares!

	di
	call RasterColors_Disable

	;wipe the memory the Firmware had
	ld hl,&A500
	ld de,&A501
	ld bc,&1A00-1	;ld bc,&BFF-1	;
	xor a
	ld (hl),a
	ldir


DoCustomRsts:
	ld hl,&0030		; Set RST 6 to Call IY
	ld  de,&e9FD 
LdHlEd:
	ld (hl),e
	inc hl
	ld (hl),d
	inc hl
ret

;	ret
DoRestoreJumpBlock:
Rst #8
defw &08bd :FirmJumpLoc_Plus2                  ;initialise firmware jumpblock entries

Firmware_Restore:	; About that firmware...
	di	
	call RasterColors_Disable

	;restore colors
	call RasterColors_DefaultSafe

	;reset our raster events
	ld hl,(RasterColors_PerFrameCall_Plus2-2)
	ld (RasterColors_PerFrameCallRestore_Plus2-2),hl
	ld hl,null
	ld (RasterColors_PerFrameCall_Plus2-2),hl

	exx
	ld bc,&7f00+%10001000+1  ;initialise lower rom and select mode
	out (c),c                   ;this routine must be located above &4000
	xor a

	exx
	ex af,af'

	call &0044                  ;initialise lower jumpblock (&0000-&0040)
                            ;and high kernal jumpblock (&b800-&bae4)

	Call DoRestoreJumpBlock
	call &bb00 ; km_initialise          ;initialise keyboard manager
	call &b909 ;kl_l_rom_disable       ;disable lower rom

	ld de,&A500	; first usable byte of memory
	ld hl,&b0ff	; last usable byte of memory

	call &bccb ; KL_ROM_WALK
	;ld c,7	DiskRomNumber_Plus1	; number of AMSDOS ROM
	;call &bcce	; initialise AMSDOS ROM; this also resets drive number to 0 (drive A)

	call &BCB6 ;sound hold
	ei
	;restore Disk operating system Vars here - Please add your own
	;if you have special requirements



	ld hl,&0000:ParadosSettings_Plus2
	ld (&BAFE),hl

	ld a,0:FirwareRestoreDriveNo_Plus1
	ld hl,(&be7d)	; get address where current drive number is held
	ld (hl),a	; set drive number to previous value

	ret

; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			player Handler

;***************************************************************************************************
;--------------------------------------------------------------------------------------------
Player_GetHighscore:
	ld hl,HighScoreBytes
	ret
Player_GetPlayerVars:
	ld iy,Player_Array
ret
Player_ReadControls:
	; returns
	; ixl = Keypress bitmap Player 1
	; ixh = Keypress bitmap Player 2 (TO DO!)
	; HL Direct pointer to the keymap


	call KeyboardScanner_Read
	ld c,0
	ld b,8			
	; We compare the keypresses to the 8 key map, 
	; and store the result as a single byte
	; when 2player support is done, we will do this twice one for
	; each controller
	ld hl,KeyMap
Player_Handler_ReadNext:

	push bc

		ld d,(hl)	;Bitmap
		inc hl
		ld e,(hl)	;line num
		inc hl

		push hl
			ld hl,KeyboardScanner_KeyPresses
			push de
				ld d,0
				add hl,de
			pop de
			ld a,(hl)
			or d
			cp 255
			ld e,1
			jr z,Player_Handler_notPressed

			ld e,0
Player_Handler_notPressed:
		pop hl
	pop bc
	ld a,c
	rlca
	add a,e
	ld c,a
	djnz Player_Handler_ReadNext
	ld ixl,c
	ld hl,KeyboardScanner_KeyPresses	; This is the location of the real memory to do with as you wish!
ret





	; iy = Pointer to player vars

Player_Handler:
;Do the Plus sprites




	call Player_ReadControls


	ld hl,&1000	:PlayerSpritePointer_Plus2
	ld (SprShow_BankAddr),hl

	ld a,ixl


	;Check if the game is paused
	Player_Handler_Pause:
	bit 0,a
	jr nz,Player_Handler_PauseCheckDone
	;0=normal nz=paused
	ld a,(Timer_Pause_Plus1-1)
	cpl 
	ld (Timer_Pause_Plus1-1),a
	push bc
	ld b,50
WaitLoop:halt;KeyboardScanner_ScanForOne
	djnz WaitLoop
	pop bc

Player_Handler_PauseCheckDone:
	ld a,(Timer_TicksOccured)
	or a
	ret z				;abort handler if game paused

	ld iy,Player_Array
	


	ld a,(iy+2)	;D1
	ld c,a
	and %11110000
	ld d,a
	ld a,(Timer_TicksOccured)
	and %00000100 :PlayerShootSpeed_Plus1
	jr z,Player_Handler_Start
	ld a,d
	and %01110000	; Mark that the player can shoot again
	ld d,a


	;Move the drones depending if the player is shooting
Player_Handler_Start:
	ld a,c
	and %00001111
	inc a
	cp 16
	jr c,Player_Handler_DronePosOk
	ld a,15
Player_Handler_DronePosOk:
	ld b,a
	add a
	ld (Player_DroneOffset1_Plus1-1),a
	ld (Player_DroneOffset2_Plus1-1),a
	ld a,b
	add d
	ld (iy+2),a	;D1 - shots and drones
	
	ld c,(iy)	;Y
	ld b,(iy+1)	;X

	ld e,8	; Fast move speed - will be overriden if we're firing

Player_Handler_KeyreadJoy1Fire2:
	ld a,ixl
	bit 2,a
	jr nz,Player_Handler_KeyreadJoy1Fire1
	;fire bullets
	bit 3,a
	jr nz,Player_Handler_NoFireX
	
	call Player_Handler_FireX		; Xfire is a secret feature planned for the sequel
	jr Player_Handler_KeyreadJoy1Up		; it activates when both fire buttons are pressed
Player_Handler_NoFireX:
	xor a
	ld(Player_SprNum_Plus1-1),a	;Sprite 0

	ld a,&67
	call Player_Fire		;Do a fire Right

;Player_ShootSkip
	ld e,2	; slow move speed as we're firing
	ld a,ixl
	jr Player_Handler_KeyreadJoy1Up
Player_Handler_KeyreadJoy1Fire1:
	; Shoot left
	bit 3,a
	jr nz,Player_Handler_KeyreadJoy1Up
	
	ld a,2
	ld(Player_SprNum_Plus1-1),a	;Sprite 2

	;fire bullets
	ld a,&61			;Do a fire Left

	call Player_Fire

;Player_ShootSkip2
	ld e,2	; Slow move speed as we're firing
Player_Handler_KeyreadJoy1Up:
	ld a,e
ifdef SupportPlus
	ld (PlayerMoveSpeed_Plus1-1),a
endif
	ld a,ixl
	bit 7,a
	jr nz,Player_Handler_KeyreadJoy1Down
	ld a,C

	cp 24+16				;Check we're onscreen
	jr C,Player_Handler_KeyreadJoy1DownPre

	sub e
	;add e
	ld C,a
Player_Handler_KeyreadJoy1DownPre:
	ld a,ixl
Player_Handler_KeyreadJoy1Down:

	bit 6,a
	jr nz,Player_Handler_KeyreadJoy1Left
	ld a,C

	cp 200-16+24				;Check we're onscreen
	jr NC,Player_Handler_KeyreadJoy1LeftPre


	add e
	ld C,a
Player_Handler_KeyreadJoy1LeftPre:
	ld a,ixl
Player_Handler_KeyreadJoy1Left:
	bit 5,a
	jr nz,Player_Handler_KeyreadJoy1Right
	ld a,B

	cp 12+24				;Check we're onscreen
	jr C,Player_Handler_KeyreadJoy1RightPre

	sub e
	ld B,a
Player_Handler_KeyreadJoy1RightPre:
	ld a,ixl
Player_Handler_KeyreadJoy1Right:
	bit 4,a
	jr nz,Player_Handler_SmartBomb
	ld a,B

	cp 160-12+24				;Check we're onscreen
	jr NC,Player_Handler_SmartBombPre

	add e
	ld B,a
Player_Handler_SmartBombPre:
	ld a,ixl
Player_Handler_SmartBomb:			;Check if we should fire the smarbomb
	bit 1,a
	jr nz,Player_Handler_KeyreadDone
	ld a,(SmartBomb_Plus1-1)
	or a
	jr nz,Player_Handler_KeyreadDone


	ld a,(iy+3)	; see if we've got any smartbombs left
	and %11000000
	jr z,Player_Handler_KeyreadDone

	ld a,(iy+3)	; Decrease smarbombs
	sub 64
	ld (iy+3),a	


	call DoSmartBomb
	ld a,3
	call DoSmartBombFX

Player_Handler_KeyreadDone:


	ld (iy),c	;Y
	ld (iy+1),b	;X

	ld e,0
	ld a,&F0
	ld (Player_DotColor_Plus1-1),a		; Draw player centre dot
	ld a,(Timer_TicksOccured)
	and %00000010

	jr z,Player_Handler_Frame1
	ld a,&0F
	ld (Player_DotColor_Plus1-1),a
	inc e
Player_Handler_Frame1:	
	push de		;save the frame no
	ld a,B
	sub 4
	ld (SprShow_X),a


	ld a,(iy+4)
	bit 3,a
	jp z,Player_Handler_NoDrones

	push iy
	push bc

		ld a,4 
		add e
		ld (SprShow_SprNum),a

		ld a,(iy+4)
		bit 4,a
		jr z,Player_Handler_OneDrone

		ld d,16:Player_DroneOffset1_Plus1

		ld a,c
		sub d
		sub 12
		ld (SprShow_Y),a
ifdef SupportPlus
		ld a,(CPCVer)
		and %00000001
		jr z,Drone2NoPlus


		ld a,(SprShow_Y)
		sub 24
		ld c,a

		ld a,(SprShow_X)
		sub 24
		ld b,a
	
		ld de,&0409 :DronePlusSpriteA_Plus2
;		di
		call	Plus_SetSpriteInterruptsafe
;		ei
		jr Drone2Plus
endif

Drone2NoPlus:
		call ShowSprite
Drone2Plus:
		pop bc
		push bc
		jr Player_Handler_OneDroneSkip
Player_Handler_OneDrone:
ifdef SupportPlus

		ld a,(CPCVer)
		and %00000001
		jr z,Player_Handler_OneDroneSkip
		ld a,(DronePlusSpriteA_Plus2-1)
		push bc
		ld c,219				; hide the second drone if we only have one onscreen
		ld d,a
		ld e,0
;		di
		call	Plus_SetSpriteInterruptsafe
;		ei
		pop bc
endif
Player_Handler_OneDroneSkip:
		ld d,16:Player_DroneOffset2_Plus1
		ld a,c
		add d
		ld (SprShow_Y),a
		

ifdef SupportPlus
		ld a,(CPCVer)
		and %00000001
		jr z,Drone1NoPlus

		ld a,(SprShow_Y)
		sub 24
		ld c,a

		ld a,(SprShow_X)
		sub 24
		ld b,a
	
		ld de,&0509 :DronePlusSpriteB_Plus2

		ld a,d
		xor %00000001
		ld (DronePlusSpriteB_Plus2-1),a		
		ld a,d
		ld (DronePlusSpriteA_Plus2-1),a			
;		di
		call	Plus_SetSpriteInterruptsafe
;		ei
		jr Drone1PlusRet
endif
Drone1NoPlus:
		call ShowSprite
Drone1PlusRet:
	pop bc
	pop iy
Player_Handler_NoDrones:
	ld a,B
	sub 7
	ld (SprShow_X),a

	pop de	;get back the frame num


	ld a,(iy+4)	;invincibility
	and %11100000	
	jr z,Player_NotInvincible	
	ld a,(Timer_TicksOccured)
	bit 1,a
	jr z,Player_NotInvincible	

	bit 2,a
	jp z,Player_SpriteSkip	
	
	ld a,(iy+4)	;invincibility
	sub %00100000
	ld (iy+4),a	;invincibility
	jr Player_SpriteSkip




Player_NotInvincible:	

push bc
	;draw the player
	ld a,0 :Player_SprNum_Plus1
	add e
	ld (SprShow_SprNum),a


ifdef SupportPlus

	ld a,(CPCVer)
	and %00000001
	jr z,ShowPlayer_NoPlus

;We flash the player when moving slowly, so the player can see bullets in the background as sprites are always at the top
	ld a,0:PlayerMoveSpeed_Plus1
	cp 2
	jp nz,PlayerPlusNoFlash
;	ld a,(CPCVer)
;	cp 129
;	jr c,PlayerPlusNoFlash
	ld a,(BlockPageFlippedColors)
	cp 64
	jr z,PlayerPlusNoFlash
	or e	;make a>0
	jr PlayerPlusNoFlash_Skip
PlayerPlusNoFlash:
	xor a
PlayerPlusNoFlash_Skip:
	ld (FlashPlusSprite_Plus1-1),a





	ld a,(SprShow_SprNum)
	add a
	add a
	ld (PlusSpriteOffsetB_Plus1-1),a
	;push bc
		ld a,c
		sub 24+18
		ld c,a

		ld a,b
		sub 24+8
;		add a
		ld b,a



		ld de,&0009
		di
			call	Plus_SetSprite
			ld a,b
			add &08
			ld b,a
			inc d;ld d,&01
			call	Plus_SetSprite

			ld a,b
			sub &08
			ld b,a

			ld a,c
			add &10
			ld c,a


			inc d;	ld d,&02
			call	Plus_SetSprite


			ld a,b
			add &08
			ld b,a
			inc d;ld d,&03
			call	Plus_SetSprite
		
		;ld a,(BankSwitch_128k_Current_Plus1-1)
		;push af

			;ld a,1	; Load in the bootstrap
			;call BankSwitch_128k_SetCurrent
		
			call CoreExt_PlusSpriteSwapB

;		pop af
;		call BankSwitch_128k_SetCurrent
		ei

	pop bc	
	jr Player_SpriteSkipB	
endif

ShowPlayer_NoPlus:
	ld a,c
	sub 18
	ld (SprShow_Y),a

	call ShowSprite
pop bc
jr Player_SpriteSkipB
Player_SpriteSkip:
ifdef SupportPlus
	ld a,(CPCVer)
	and %00000001
	jr z,Player_SpriteSkipB

	ld de,&0400
	di
Player_SpriteSkip_More:
		dec d
		ex af,af' ;push af
		call	Plus_SetSprite
		ex af,af' ;push af
		jr nz,Player_SpriteSkip_More

	ei
endif

Player_SpriteSkipB

	ld a,&F0	:Player_DotColor_Plus1
	ld d,a

	and &33
	ld e,a

	ld a,d
	and &CC
	ld d,a
	call StarArray_InitColors
	
	jp Stars_DrawDot


Player_Fire_OneBurst:

		push de
		push bc

			ld (StarObjectMoveToAdd_Plus1-1),a
			call Stars_AddObject
		pop bc
		pop de
ret
Player_Handler_FireX:
	ret		;disable this firemode
	ld a,(iy+2)	;D1
	bit 7,a	; check if player is allowed to fire
	ret nz
	or %10000000
	ld (iy+2),a	;D1

	call Stars_AddToPlayer

	push iy
		ld d,b

		ld iy,Player_Fire_OneBurst
		ld a,&49
		rst 6
		ld a,&4F
		rst 6
		ld a,&79
		rst 6
		ld a,&7F
		rst 6
	pop iy


	ld e,2	; move speed

	jr FireSfx


Player_Fire:	; Fire bullets!


	ld (StarObjectMoveToAdd_Plus1-1),a


	push bc

	push de
		ld a,(iy+2)	;D1 Move the drones in when fire is held
		ld d,a
		and %11110000
		ld c,a
		ld a,d
		and %00001111
		dec a
		dec a
		jr nz,Player_Handler_KeyreadJoy1Fire2_DroneLimit
		inc a	; Drone at Max 'innness'!

	Player_Handler_KeyreadJoy1Fire2_DroneLimit:
		add c
		ld (iy+2),a	;D1
	
	pop de
	pop bc

	bit 7,a	; check if player is allowed to fire
	ret nz
	or %10000000
	ld (iy+2),a	;D1
	
	push bc

		call Stars_AddToPlayer
		ld d,b
		push bc

			call Stars_AddObject

	;drone1
		pop bc


		; Add extra stars depending on how many drones we have
		ld a,(iy+4)
		bit 3,a
		jp z,Player_NoDrones

		bit 4,a
		jp z,Player_OneDrone

		push bc
			ld d,b

			ld a,(Player_DroneOffset1_Plus1-1)
			ld b,a

			ld a,c
			sub b
			sub 2
			ld c,a
	;	push iy
			call Stars_AddObject
	;	pop iy
		pop bc
	;drone2

Player_OneDrone:

		ld d,b

		ld a,(Player_DroneOffset1_Plus1-1)
		ld b,a

		ld a,c
		add b
		add 4
		ld c,a
		;push iy
			call Stars_AddObject
	;	pop iy
Player_NoDrones:
	pop bc
FireSfx:
	ld a,1
	jp SFX_QueueSFX_Generic

;ret
DoSmartBombCall:

	; a=2 All FX
	; a=1 no sound, screen flash
	; a=0 No FX
	push af
	call DoSmartBomb
	pop af
	jr DoSmartBombFX


MemoryFlushLDIR:
	ld b,0
	ld c,a

	ld d,h
	ld e,l
	inc de
	ld (hl),b
	ldir
	ret


DoSmartBomb:	


	push de
	push bc
	

	ld a,(StarArraySize_Enemy) 

	ld hl,(StarArrayMemloc_Enemy)	 
	call MemoryFlushLDIR
	
	ld a,(StarArraySize_Player)  
	ld hl,(StarArrayMemloc_Player)
	call MemoryFlushLDIR

	call null :SmartBombSpecial_Plus2	; We can hack in our own smartbomb handler
						; this is needed to wipe omega array for 
						; final boss as it's not handled by
						; normal core code

	ld a,(ObjectArray_Size)
	ld b,a
	ld hl, &6969:ObjectArrayAddress_Plus2

Player_Handler_SmartBombObjLoop:  ; we need special code because we don't want to wipe
				  ; bg objects and boss sprites
	push hl
		;y
		inc h
		;x
		inc h
		;m
		inc h
		;s
		inc h
		ld a,(hl)	;life (0 is background)
		or a 
		jp z,Player_Handler_SmartBombObjMoveNext

		
		inc h
		ld a,(hl)	
		or a
		jr z,SmartBombKill
	
		cp 32			;Program 1-31 are protected from smartbomb
		jp C,Player_Handler_SmartBombObjMoveNext

SmartBombKill

		;if we got here we need to kill this object

	pop hl
	push hl

		inc h		;y
		inc h		;X
		ld (hl),%10000111; Seaker Fast 1000001XX XX=Speed
		inc h	
		ld (hl),128+16	:PointsSpriteB_Plus1; Sprite
		inc h	
		ld (hl),64+63	; Life ; must "hurt" player for hit to be detected
		inc h	
		ld (hl),3	; Program


Player_Handler_SmartBombObjMoveNext:	
	pop hl
	inc l
	djnz Player_Handler_SmartBombObjLoop

	pop bc
	pop de
	
ret
DoSmartBombFX:
push af;	ld i,a
	
;	ld a,i	
	or a
	ret z 

	ld a,5
	ld(SmartBomb_Plus1-1),a

	pop af;	ld a,i	
	dec a;cp 1
	ret z 

	ld a,5
	jp SFX_QueueSFX_GenericHighPri

;ret
; ------------------ Player Hit ---------------
Player_Hit:



		ld a,iyl
		cp 3
		jp nz,Player_Hit_Injure
		; if we got here we hit a powerup
		;

		ld b,0	; remove the powerup
		ld c,b
		ld d,b
;		ld ixl,b

		ld a,iyh 	
		cp 128+38	:DroneSprite_Plus1
		jr z,Player_Hit_PowerupDrone
		cp 128+39	:ShootSpeedSprite_Plus1
		jr z,Player_Hit_PowerupShootSpeed
		cp 128+40	:ShootPowerSprite_Plus1
		jr z,Player_Hit_PowerupShootPower
		cp 128+16	:PointsSprite_Plus1
		jr z,Player_Hit_Points
		ret
Player_Hit_Points:
	
		ld a,6
		call SFX_QueueSFX_GenericHighPri

		; Object is Points for player
		ld a,(Player_ScoreAdd)
			add 5
		ld (Player_ScoreAdd),a
		ret
Player_Hit_PowerupShootSpeed:		
		;ld a,7
		;call SFX_QueueSFX_GenericHighPri

		ld a,(PlayerShootSpeed_Plus1-1)
		srl a	
		or a
		jr nz,Player_Hit_PowerupShootSpeedNZ
	    	inc a ;dont let a=0
Player_Hit_PowerupShootSpeedNZ:				
		
		ld (PlayerShootSpeed_Plus1-1),a
		jr PowerupPlaySfx
Player_Hit_PowerupDrone:

		push iy
			ld iy,Player_Array
			ld a,(iy+4)
			bit 3,a
			jr z,Player_Hit_PowerupDroneOne
			or %00011000
Player_Hit_PowerupDroneOne:
			or %0001000
			ld (iy+4),a
			pop iy 
		jr PowerupPlaySfx
Player_Hit_PowerupShootPower:
		;ld a,7
		;call SFX_QueueSFX_GenericHighPri
		ld a,&96;6f
		ld (PlayerStarColor_Plus1-1),a
		ld a, &3d ;(Dec A)
		ld (PlayerShootPower_Plus1-1),a

PowerupPlaySfx:
		ld a,7
		jp SFX_QueueSFX_GenericHighPri
Player_Hit_Injure:	
	push iy
	ld iy,Player_Array

	ld a,(iy+4)	;invincibility
	and %11100000	
	jr nz,Player_Hit_Done		;>0 if player invincible
	

		ld a,(iy+4)	;invincibility
		or %11100000	
		ld (iy+4),a	;invincibility


		ld a,(iy+3)	
		dec a
		ld (iy+3),a	

		ld a,4
		call SFX_QueueSFX_GenericHighPri
Player_Hit_Done:
	pop iy
	ret


; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			Player UI
;***************************************************************************************************
;--------------------------------------------------------------------------------------------
ifdef SupportPlus
Plus_SetSprite_IfANonzero: ; or <h
	push af
		ld e,0
		or a
		jr z,Plus_SetSprite_IfANonzeroB
		cp h
		jr c,Plus_SetSprite_IfANonzeroB
		ld e,9
Plus_SetSprite_IfANonzeroB:
		call	Plus_SetSpriteInterruptsafe
		;di
;			call Plus_SetSprite
;		ei
		ld a,b
		add 8
		ld b,a
		inc d
	pop af
	ret


Player_DrawUI_PlusVer:
	di
		ld bc,&0008
		ld d,6+3

		ld a,(iy+3)	;D1
		ld h,0
		and %00000011
		call Plus_SetSprite_IfANonzero
		ld h,2
		call Plus_SetSprite_IfANonzero
		ld h,3
		call Plus_SetSprite_IfANonzero

		ld bc,&00B4 ;180 down
		ld d,6
		ld a,(iy+3)	;D1
		and %11000000

		call Plus_SetSprite_IfANonzero
		ld h,%10000000
		call Plus_SetSprite_IfANonzero
		ld h,%11000000
		call Plus_SetSprite_IfANonzero

	ei
	jr Player_DrawUI_PlusAsWell
endif

Player_DrawUI:					; We put PLus sprite anims here, as they
						; have to be run after the playerhandler
						; and mess up practically ALL registers
	ld iy,Player_Array
	
ifdef SupportPlus
	ld a,(CPCVer)
	and %00000001
	jr nz,Player_DrawUI_PlusVer
endif

	xor a
	ld (SprShow_Xoff),a	



	ld a,(iy+3)	;D1
	and %00000011
	ld b,a


	ld a,7
	ld (SprShow_SprNum),a

	ld a,8
	ld (SprShow_Y),a
	;lives
	ld c,0

	push iy
		call Player_DrawUI_IconLoop
	pop iy

	ld a,6
	ld (SprShow_SprNum),a

	ld a,180
	ld (SprShow_Y),a

	ld c,0
	;smart bombs

	ld a,(iy+3)	;D1
	and %11000000
	rlca
	rlca
	ld b,a
	push iy
		call Player_DrawUI_IconLoop
	pop iy



Player_DrawUI_PlusAsWell:
	push iy


		;Draw score digits
		ld hl,&0700
		call DrawText_LocateSprite
		call SpriteBank_Font
		ld hl, Player_ScoreBytes	


Player_DrawUI_NextDigit:
		push hl

			ld a,(hl)		
			add 48 ; Move to the correct digit (first 32 are not in font)
			 ;add 8 
			ld b,-2 ; we are drawing backwards!
			call DrawText_CharSpriteDirect;DrawText_DigitSprite
	;	pop bc
		pop hl
		inc l
		bit 3,l	; repeat until we get to 8
		jp z,Player_DrawUI_NextDigit
	pop iy

	; check if we need to show the continue screen
	ld a,(iy+3)	;See how many lives are left
	and  %00000011	
	jp z,Player_Dead

ScoreAddRepeat:				;This does our rolling up effect on the score!
	call Player_UpdateScore
	ld a,(Player_ScoreAdd)
	cp 30				; if waiting score goes over 30, add faster
	jr nc,ScoreAddRepeat		; this is for the 'coffee time'* effect at the
					; end of level 9  
	; * yeah, I'm ripping off a certain other game - wanted to make this come up
	; on screen as the score fell - probably a new feature in Episode 2
	ld a, &00: CheatMode_Plus1
	or a
	ret z
	; CHEAT MODE!           Sssh, we set cheats here - as some levels steal our powerups,
	; 			done During the level not before
	ld iy,Player_Array
	ld a,(iy+4)

	or %00011000
	ld (iy+4),a

	ld a,&96
	ld (PlayerStarColor_Plus1-1),a
	ld a, &3d ;(Dec A)
	ld (PlayerShootPower_Plus1-1),a
	ld a,%00000001
	ld (PlayerShootSpeed_Plus1-1),a
ret
Player_CheatMode:			;enable cheat mode
	ld (CheatMode_Plus1-1),a
	ret
Player_AddScore:			; add some score to the pending

	ld a,(Player_ScoreAdd)
	add b
	ld (Player_ScoreAdd),a
	ret

Player_UpdateScore:			;Add score to the first digit

	ld hl, Player_ScoreBytes	

	ld a,(Player_ScoreAdd)
	ld c,0
	ld b,a
	cp 0
	ret z ;nothing to add

	dec a
	ld (Player_ScoreAdd),a

	ld a,(hl)
	inc a
	ld (hl),a
	cp 10 
	ret C 	; return if nothing to carry
	inc c	; We've rolled into another digit.
Player_AddScore_NextDigit:
		ld a,c
		or a
		ret z 	; check if C is zero

		ld c,0		
		ld a,(hl)
		inc a
		cp 10
		jp C,Player_AddScore_Inc
		ld a,0
		inc c


Player_AddScore_Inc:
	ld (hl),a
	inc l
	bit 3,l	; repeat until we get to 8 - if so we've run out of digits
	jr z,Player_AddScore_NextDigit
ret

Player_DrawUI_IconLoop:		; Used for Health and Smartbomb icons 

	ld a,b
	or a
	ret z

	ld a,(SprShow_Y)
	ld (SprShow_TempY),a


	ld a,c
	ld (SprShow_TempX),a
	push bc
	call ShowSpriteDirect
	pop bc
	dec b	
	ld a,c
	add a,4
	ld c,a

	jr Player_DrawUI_IconLoop
; --------------------------------------------------

; Reset Powerup

; --------------------------------------------------
ResetPowerup:				; used by levelcode to take our bonuses 
	push iy
		ld iy,Player_Array
		ld a,(iy+4)
		and %11100111
		ld (iy+4),a
	pop iy
	ld a,&06
	ld (PlayerStarColor_Plus1-1),a
	ld a, &00 ;Nop
	ld (PlayerShootPower_Plus1-1),a
	ld a,%00000100
	ld (PlayerShootSpeed_Plus1-1),a
ret
; --------------------------------------------------

; Continue screen

; --------------------------------------------------

Player_Dead:			
	;call Firmware_Restore
	;call ScreenBuffer_Reset
	ld hl,&0001
	call ExecuteBootStrap
	jp ScreenBuffer_Init

; --------------------------------------------------------------------------------------------
;***************************************************************************************************

;			Background 

;***************************************************************************************************
;--------------------------------------------------------------------------------------------
Timer_UpdateTimer: ; The Background also updates the Timer, if you use a custom background
; such as stage 9, you need to do this yourself or nothing will happen!


	ld a,&69 :Timer_CurrentTick_Plus1
	ld b,a
	inc a
	ld (Timer_CurrentTick),a
	xor b
	ld (Timer_TicksOccured),a
	
	ld a,0 :Timer_Pause_Plus1
	or a
	jr z,NotPaused

	xor a
	ld (Timer_TicksOccured),a	
	ret

NotPaused:
	ld a,0 :SmartBomb_Plus1			; Make the background flash with the smartbomb
	or a
	ret z

	dec a					; Smartbomb timer down one
	ld (SmartBomb_Plus1-1),a

	push hl
	ld hl,Background_SmartBombColors
		ld b,0
		ld c,a
		add hl,bc
		ld a,(hl)
		ld ixl,a
		ld ixh,a
		ld a,255
		ld (ScrollNextLineChange),a		;Trick background into never changin
	pop hl


ret
Timer_GetTimer:					;Return current timer in I
	ld a,(Timer_CurrentTick)		; and 'Ticks occured' Xor bitmap
	ld i,a
	ld a, 0:Timer_TicksOccured_Plus1
ret



Background_Clear:
	
Background_Buffer2:
	;ld (Background_NextLineJump_Plus2-2),hl


	ld hl,BGGradiant

	ld a,(hl)				;Load up the first two bytes
	ld ixl,a
	inc hl
	ld a,(hl)
	ld ixh,a
	ld (Background_LastLine),a
	inc hl
	push hl
	pop iy

	ld a,(hl)
	ld (ScrollNextLineChange),a

	
; smart bomb effect

	call Timer_UpdateTimer
	ld a,(ScreenBuffer_ActiveScreen)
	ld h,a
	ld l,&50


	LD B,200			;Lineno - starts at bottom (200)

	ld (Scroll_StackRestore),SP	; Back up the stackpointer
	
Background_NewLine:
	di
	;push hl
	ld a,128		:ScrollNextLineChange_Plus1

	cp b			; b is lineno
	jp nz, Background_NotNextLine 	;jp is faster when true



	;ld hl,&FFFF 	BGGradiantPos_Plus2
	;dec hl
	dec IY

	ld a,&FF	:Background_LastLine_Plus1
	ld c,a
	or a
	jp z,Background_NoShift
	ld a,(Timer_TicksOccured_Plus1-1)
	ld e,a
	ld a,%11111111  :ScrollPosRate1_Plus1		; Scroll rate for 'ground'
	and e
;	cp 0
	jp z,Background_NoShift

	ld a,128		:ScrollPos_Plus1	; 'middle of screen for paralax effect
	cp b
	jp NC,Background_ShiftNow :Background_ShiftJumpB_Plus2

	ld a,%00100000  :ScrollPosRate2_Plus1		; Scroll rate for 'sky'
	and e
	jp z,Background_NoShift
	jp Background_ShiftNow :Background_ShiftJumpA_Plus2
Background_ShiftNow:
	;Shift by one pixel
	ld a,c
	and &88		; Keep leftmost X---
	rrca
	rrca
	rrca
	ld e,a
	ld a,c		; backup for later
      	and &77		; keep -XXX
	rlca		; shift right -XXX
	or e		; add e ---X
	ld (IY+0),a
Background_NoShift:		; No shift
	ld a,c

	ld d,iyh
	ld e,iyl

	inc de
	
	ld ixl,a	; byte 1
	inc de
	ld a,(de)
	ld ixh,a	; byte 2
	ld (Background_LastLine),a	; last
	inc de
	;ld (BGGradiantPos),hl

	ld a,(de)
	ld (ScrollNextLineChange),a	;remember when we need to do it again

	ld iyh,d
	ld iyl,e

Background_NotNextLine:	; No change yet!

;	ld iy,sp
	;pop hl
 

;	di
	ld sp,hl
	ld d,ixh
	ld e,d

repeatr1:		;We use PushDE for fast screenwrite - Faster than CLS!

push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL




; NO 2			- do another line
ld a,h
add a,&08
ld h,a
ld sp,hl

ld d,ixl
ld e,d

dec b
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL
push de;push HL

;ld a,ixh
;ld ixh,ixl
;ld ixl,a

; NO 2

ei			;let the Interrupts run
ld SP,&FFFF		:Scroll_StackRestore_Plus2



dec b
jp z,Background_Done  ; check if b=0


	ld a,h
	add a,&08
	ld h,a
	jp Background_GetNxtLin :Background_NextLineJump_Plus2

Background_GetNxtLin:
	jp nc,Background_NewLine
	ld de,&c050
	add hl,de
	;push hl
	jp Background_NewLine
Background_GetNxtLinAlt:
	bit 7,h
	jp z,Background_NewLine
	ld de,&c050
	add hl,de
	;push hl
	jp Background_NewLine
Background_Done:
	ld SP,(Scroll_StackRestore_Plus2-2)
	ei
	ret
	
	

;SetNewRate
	;These variables are held direct in the code
;	ld a,100
;	ld (ScrollPos),a
;	ld a,%11111111
;	ld (ScrollPosRate1),a
;	ld a,%00000100
;	ld (ScrollPosRate2),a
Background_LeftScroll:			; Alternate scroll routine for Right->Left
	ld a,c
	and &11		; Keep leftmost X---
	rlca
	rlca
	rlca
	ld e,a
	ld a,c		; backup for later
      	and &EE		; keep -XXX
	rrca		; shift right -XXX
	or e		; add e ---X
	ld (IY+0),a
jp Background_NoShift

;Direct code variables
ScrollPos 		equ ScrollPos_Plus1-1
ScrollPosRate1 		equ ScrollPosRate1_Plus1-1
ScrollPosRate2 		equ ScrollPosRate2_Plus1-1
ScrollNextLineChange 	equ ScrollNextLineChange_Plus1-1
Scroll_StackRestore 	equ Scroll_StackRestore_Plus2-2
;BGGradiantPos 		equ BGGradiantPos_Plus2-2
Background_LastLine	equ Background_LastLine_Plus1-1
Timer_CurrentTick  	equ Timer_CurrentTick_Plus1-1





;***************************************************************************************************

;				Object Driver

;***************************************************************************************************

; YYYYYXXXXMMMMSSSLLLLPPP




ObjectArray_Init:
	ld (ObjectArray_Size),a
	ld (ObjectArrayAddress),hl
ret

ObjectArray_Redraw:
	ld a,(Timer_TicksOccured)
	or a
	ret z	; see if game is paused (TicksOccurred = 0 )


ObjectArray_Redraw_UpdatePlayer:
	;ld (Objectloop_DoPlayerCollisions_Plus2-2),hl


	ld iy,Player_Array	;we update player location in advance for fast collision detection
	;ld a,(iy+4)	;invincibility
	;and %11100000	


	ld a,(iy+0)	;PlayerY
	sub 12
	ld (PlayerY1_Plus1-1),a
	add 24
	ld (PlayerY2_Plus1-1),a


	ld a,(iy+1)	;PlayerX
	sub 6
	ld (PlayerX1_Plus1-1),a
	add 12
	ld (PlayerX2_Plus1-1),a

	ld a,00:ObjectArray_Size_Plus1
	ld B,a

	ld d,0
	ld hl,(ObjectArrayAddress)

	xor a ; Zero 
Objectloop2:
	
	
	ld c,(hl)	; Y
	cp c	
	jp Z,ObjectArray_Turbo		;if object Y =0 the object is dead

Objectloop_NotZero:
	ld a,c
	ld (SprShow_Y),a
	push bc
	push hl
		;ld a,(ObjectArray_Size)
		;ld d,0
		;ld e,a
		;add hl,de				;1
		inc h
		ld a,(hl) ; X
		ld (SprShow_X),a
		ld b,a
		;add hl,de				;2
		inc h
		ld a,(hl) ; M
		ld ixh,a
		;add hl,de				;3
		inc h
		ld a,(hl) ; Sprite etc
		push bc	
			ld b,0
			ld iyh,a
			and %10000000
			jr z,Objectloop_OneFrameSprite
			; Flip between Sprite banks every other frame on 128k
			ld a,(Timer_TicksOccured)
			and %00000010
			jr z,Objectloop_OneFrameSprite
			ld a,1
			jr Objectloop_SpriteBankSet
Objectloop_OneFrameSprite:
			xor a
Objectloop_SpriteBankSet:
			ld (ObjectSpriteBank_Plus1-1),a

			ld a,iyh
			and %01111111
			;add b
		pop bc
		ld (SprShow_SprNum),a
		inc h
		;add hl,de 				;4

		ld a,(hl) ; Life etc
		ld ixl,a
		;add hl,de 				;4
		inc h
		ld a,(hl) ; Program Code
		ld iyl,a
	
		
	ld a,ixl
	bit 6,a
	jr z,ObjectLoopP1Skip	; Doesn't hurt player


	;used to modify this, but now we assume the player is alway vunurable
	; we check anyway before deducting a life			
	;Jp Objectloop_PlayerVunrable ;Objectloop_DoPlayerCollisions_Plus2
Objectloop_PlayerVunrable:
;-----------------------------------player collisions---------------------------------
		push bc
			ld a,b
			add 3
			ld b,a
	
			ld a,c
			add 12
			ld c,a
		
			ld a,b

			cp 0 :PlayerX1_Plus1
			jr c,ObjectLoopP1SkipB
			cp 0 :PlayerX2_Plus1
			jr nc,ObjectLoopP1SkipB

			ld a,c		
			cp 0 :PlayerY1_Plus1
			jr c,ObjectLoopP1SkipB
			cp 0 :PlayerY2_Plus1
			jr nc,ObjectLoopP1SkipB


		pop bc
		
		call Player_Hit
		ld a,b
		or a
		jr nz,ObjectLoopP1Skip
					; check if we killed object
		jp ObjectLoop_SaveChanges

ObjectLoopP1SkipB:
		pop bc

ObjectLoopP1Skip:
	;if the object is dead, there is no point checking if its shot


	; Life BPxxxxx 		B=hurt by bullets, P=hurts player, xxxxxx = hit points (if not B then ages over time)


	ld a,ixl
	or a
	jr z,ObjectLoop_Ageless	; doesn't age
;	bit 6,a

	ld a,ixl
	bit 7,a
	jr nz,ObjectLoop_Ageless	; If it can be shot, it doesn't auto age

	
	ld a,(Timer_TicksOccured)	; see if its time to age the sprite
	and %00001000
	jr z,ObjectLoop_Ageless
	
	call Object_DecreaseLife
	ld a,c
	or a
	jr z,ObjectLoop_SaveChanges
;	pop de
ObjectLoop_Ageless:
 	ld a,ixl
	bit 7,a
	jr z,ObjectLoop_NotShot	; cant be shot

	xor a
	ld (ObjectShot_Plus1-1),a	; Set object not shot

;-----------------------------------player bullet collisions---------------------------------
	; B=Obj X
	; C=Obj Y


	ld a,b
	sub 6
	ld (ObjectHitXA_Plus1-1),a
	add 12
	ld (ObjectHitXB_Plus1-1),a
		
	ld a,c
	sub 12
	ld (ObjectHitYA_Plus1-1),a
	add 24
	ld (ObjectHitYB_Plus1-1),a
	


	ifdef Debug
		call Debug_NeedEXX
	endif
	di	
	exx

ObjectLoop_HeightNZ:

		
		ld a,(StarArraySize_Player)
		ld hl,&0000 :StarArrayMemloc_Player_Plus2
		add l
		ld (ObjectLoop_PlayerStarEnd_Plus1-1),a
	ObjectLoop_PlayerStarNext:
		ld a,(hl)	;check Y of star
		cp 00 :ObjectHitYA_Plus1
		jr c,ObjectLoop_PlayerStarSkip
		cp 00 :ObjectHitYB_Plus1
		jr nc,ObjectLoop_PlayerStarSkip
	
		inc h
		ld a,(hl)
		dec h
		cp 00 :ObjectHitXA_Plus1
		jr c,ObjectLoop_PlayerStarSkip
		cp 00 :ObjectHitXB_Plus1
		jr nc,ObjectLoop_PlayerStarSkip
	
	
		ld a,1
		ld (ObjectShot_Plus1-1),a
		ld (hl),0 ; star hit so lets remove it
	
	ObjectLoop_PlayerStarSkip:	
		inc l
		ld a,0:ObjectLoop_PlayerStarEnd_Plus1
		cp l
		jp nz,ObjectLoop_PlayerStarNext

	exx
	ei 
	ifdef Debug
		call Debug_ReleaseEXX
	endif
ObjectLoopP1StarSkip:
		


		ld a,&69 :ObjectShot_Plus1
		or a
		jp z,ObjectLoop_NotShot
		; object was shot by player - can be overriden for 
		; boss and special enemies
		call Object_DecreaseLifeShot :ObjectShotOverride_Plus2

		;jr ObjectLoop_SaveChanges
ObjectLoop_NotShot:

		ld d,ixh
		call DoMoves	:ObjectDoMovesOverride_Plus2
		ld ixh,d
		
ObjectLoop_SaveChanges:
		;ld a,(ObjectArray_Size)
		;cpl
		;ld d,255
		;ld e,a
		;inc de
		;ld de,-ObjectArraySize

		ld a,iyl
		ld (hl),a ; Program Code
		;add hl,de
		dec h
		ld a,ixl 
		ld (hl),a ;Life
		;add hl,de
		dec h
		ld a,iyh 
		ld (hl),a ;spr
		;add hl,de
		dec h
		ld a,ixh
		ld (hl),a ;Move
		;add hl,de 
		dec h
		ld (hl),b ;X
		;add hl,de 
		dec h
		ld (hl),c ;Y
		
		ld a,iyl
		or a
		call nz, ObjectProgram
ObjectLoop_ShowSprite:
		

		ld hl,&2000	:ObjectSpritePointer_Plus2
		ld a,0 :ObjectSpriteBank_Plus1
		or a
		jr z,ObjectLoop_ShowSprite_BankSet
ifdef Support64k
		ld a,(CPCVer)			;64k only has 1 bank
		and 64
		jr nz, ObjectLoop_ShowSprite_BankSet
endif
		;switch to the alternat bank
		;ld a,0
		;call BankSwitch_128k
		ld hl,&D000

ObjectLoop_ShowSprite_BankSet:



		ld (SprShow_BankAddr),hl

		ld a,(SmartBomb_Plus1-1)
		or a
		call z,ShowSprite
		;call BankSwitch_128k_Reset
		
ObjectArray_Next:
	pop hl
	pop bc
	xor a ; Zero 
ObjectArray_Turbo:
	inc l
	dec b
	jp nz,Objectloop2
	ret



ObjectProgram:
	ret z		; return if zero
	cp %00000001
	jp z,ObjectProgram_BitShiftSprite	; Used by background, sprite bank based on X co-ord
	and %11111000

					;00000XXX = Powerup
	jr z,ObjectProgram_PowerUps

	cp %11110000			;11110XXX = Animate every X frames
	jr z,ObjectProgram_FrameAnimate
	and %11100000
	cp  %00100000			;001XXXXX = Fastfire
	jp z,ObjectProgram_FastFire
	cp  %01000000			;010XXXXX = Fastfire
	jp z,ObjectProgram_MidFire
	cp  %01100000			;011XXXXX = Fastfire
	jp z,ObjectProgram_SlowFire
	cp  %10000000			;100XXXXX = Fastfire
	jp z,ObjectProgram_SnailFire
	cp  %11000000			;110XXXXX = Fastfire
	jp z,ObjectProgram_Mid2Fire
	cp  %10100000			;110XXXXX = Fastfire
	jp z,ObjectProgram_HyperFire

	ld a,iyl
	cp %11111100			;Custom 1
	jr z,ObjectProgram_Custom1
	cp %11111101			;Custom 2
	jp z,null :CustomProgram2_Plus2
	cp %11111110			;Custom 3
	jp z,null :CustomProgram3_Plus2
	cp %11111111			;Custom 4
	jp z,null :CustomProgram4_Plus2
	cp 8				;Custom 1
	jr z,ObjectProgram_Custom1
	ret
ObjectProgram_Custom1:
	jp null :CustomProgram1_Plus2
ObjectProgram_PowerUps:
	ld a,iyl
	cp 4
	jr z,ObjectProgram_MovePlayer
	cp 5
	jr z,ObjectProgram_SpriteBankSwitch
	ret
ObjectProgram_MovePlayer:	; Used by end of level code to make player fly to a point
	;b=x ;c=y
	push iy
	ld iy,Player_Array

	ld a,(iy)	;Y
	cp c
	jr z,  ObjectProgram_MovePlayerX
	jr nc, ObjectProgram_MovePlayerYUp
	add 8
	jr ObjectProgram_MovePlayerX
ObjectProgram_MovePlayerYUp:
	sub 8
ObjectProgram_MovePlayerX:
	ld (iy),a
	ld a,(iy+1)	;X
	cp b
	jr z,  ObjectProgram_MovePlayerDone
	jr nc, ObjectProgram_MovePlayerXUp
	add 6
	jr ObjectProgram_MovePlayerDone
ObjectProgram_MovePlayerXUp:
	sub 6
ObjectProgram_MovePlayerDone:
	ld (iy+1),a
	pop iy
	ret
ObjectProgram_FrameAnimate:	; Used To animate spider legs in 1st boss
	push bc
		ld a,iyl
		and %00000111
		ld b,a
		inc b
		ld a,128	; do at least 1 shift, so result is at least 1
ObjectProgram_FrameAnimate_Bitshifts:
		rlca
		djnz ObjectProgram_FrameAnimate_Bitshifts
		ld b,a
		ld a,(Timer_CurrentTick)
		and b
		
	pop bc
	ret z
	jr ObjectProgram_SpriteBankSwitch

ObjectProgram_BitShiftSprite:	; Every other X column uses an alternate sprite - for background anim

	ld a,b
	ld (SprShow_X),a	; Makesure sprite pos is updated for Domoves
	bit 0,b
	ret nz
ObjectProgram_SpriteBankSwitch:		; an object which uses sprite bank 2
	ld a,1				; this is to split one sprite into 2 non animated
					; for basic background objects / enemies
	ld (ObjectSpriteBank_Plus1-1),a	; second anim frame

	ret


ObjectProgram_SnailFire:
	ld iyh,%00010000	:FireFrequencyA_Plus1
	jr ObjectProgram_Fire
ObjectProgram_SlowFire:
	ld iyh,%00001000	:FireFrequencyB_Plus1
	jr ObjectProgram_Fire
ObjectProgram_MidFire:
	ld iyh,%00001000	:FireFrequencyC_Plus1
	jr ObjectProgram_Fire
ObjectProgram_Mid2Fire:
	ld iyh,%00000100;	:FireFrequencyD_Plus1
	jr ObjectProgram_Fire
ObjectProgram_FastFire:
	ld iyh,%00000010;	:FireFrequencyE_Plus1
	jr ObjectProgram_Fire

ObjectProgram_Fire:
	ei	; Why is interrupts disabled here??
	ld a,(Timer_TicksOccured)
	and iyh
	ret z
	
ObjectProgram_HyperFire:
	ld a,2
	call SFX_QueueSFX_Generic

	ld a,c
	add 12
	ld c,a

	ld a,b
	add 3
	ld d,a


	ld a,iyl
	and %00011111
	ld b,a	; top left

FireCustomStar:
	
		call Stars_AddToDefault
		jp Stars_AddObjectBatch



 Object_DecreaseLifeShot:
	ld a,ixl
	and %00111111
	ret z	; if life is zero drop out (For custom hit code callback)

	;Double power shot!
	nop :PlayerShootPower_Plus1 ;dec a
	jr z, Object_DecreaseShotToDeath

	dec a
	jr nz,Object_DecreaseLife_AgeUpdate

 Object_DecreaseShotToDeath:	
	;object has been shot to death

	ld a,3
	call SFX_QueueSFX_Generic

	;create a coin
	ld iyh,128+16 :PointsSpriteC_Plus1	; Sprite
	ld ixh,%10000111; Seaker Fast 1000001XX XX=Speed
	ld ixl,64+63	; Life ; must "hurt" player for hit to be detected
	ld iyl,3	; Program

	ret



Object_DecreaseLife:
	ld a,ixl
	and %00111111
	dec a
	jr nz,Object_DecreaseLife_AgeUpdate
	;object has died of old age
	ld b,0
	ld C,b
	ld ixl,b

	ret
	Object_DecreaseLife_AgeUpdate:
	ifdef Debug
		call Debug_NeedEXX
	endif
	di
	exx
	
		ld d,a
		ld a,ixl
		and %11000000		; Keep the 1st 2 bytes, format is ;MMLLLLLL
		or d			; MM = life mode, LLLLLL = life qty
	exx
	ei
	ifdef Debug
		call Debug_ReleaseEXX
	endif
	ld ixl,a	
ret



;***************************************************************************************************

;				Object Event Array

;***************************************************************************************************
Event_LevelTime equ Event_LevelTime_Plus1-1
Event_LevelSpeed equ Event_LevelSpeed_Plus1-1
Event_NextEventPointer equ Event_NextEventPointer_Plus2-2
Event_NextEventTime equ Event_NextEventTime_Plus1-1
LdAFromHLIncHL:
	ld a,(hl)
	inc hl
ret

DoMovesBackground_ScrollUp:

	ld bc,&790D	;Move Up ; DEC C  (OD)      LD a,C (79)	
	ld de,&F7FE	; CP (FE) F7 (199+24+24=247)
	push de
	ld de,&7A57		;ld a,d// ld d,a
	ld ixl,&57	;ld D,a
	ld hl,&DF0E	;ld C,199+24	;DF


	cp 3
	jr nz, DoMovesBackground_SetScroll2
DoMovesBackground_ScrollDown:
	ld c,&0C	;INC C
	jr DoMovesBackground_SetScroll2_V2
DoMovesBackground_SetScroll:	;A=Direction 0-Left 1-Right 2-Up 3-Down
	push hl
	push ix

		cp 2
		jr nc,DoMovesBackground_ScrollUp


		ld bc,&7805	;Move Left ; INC B  (05)      LD a,B (78)	
		ld de,&D0FE	; CP (FE)  D0 (160+24+24=208)
		push de
	
		ld de,&794F		;ld a,c // ld c,a

		ld ixl,&4F	;ld C,a
		ld hl,&B816	;ld D,160+24

		or a
		jr z,DoMovesBackground_SetScroll2
	
		ld c,&04	;Move Right
DoMovesBackground_SetScroll2_V2:
		ld h,&12	;Start far left

DoMovesBackground_SetScroll2:
		ld a,d
		ld (OBjectStripReprogram_Plus1-1),a
		ld a,e
		ld (OBjectStripReprogram_Plus1+1),a
		ld (DoMovesBGShift_Plus1-1),bc
		pop de
		ld (DoMovesBGShift_Plus1+1),de
		ld a,ixl
		ld (OneObjectQuick_Program),a
		ld (OneObjectQuick_Program+1),hl

	pop ix
	pop hl

ret


set_BackgroundScrollDirection:

	ld (Background_ShiftJumpA_Plus2-2),bc
	ld (Background_ShiftJumpB_Plus2-2),bc
	ret
SetLevelTime: ; This is used for jumping around the event stream
	; Make sure level time is LOWER than the first event, otherwise run Event_GetEventsNow
	ld (Event_LevelTime),a
	ld a,(hl)
	ld (Event_NextEventTime_Plus1-1),a
	inc hl
	ld (Event_NextEventPointer_Plus2-2),hl

	ret
GetLevelTime:		; Return the current level time
	ld a,(Event_NextEventTime)
	ld b,a
	ld a,(Event_LevelTime)
	ld hl,(Event_NextEventPointer)
	dec hl
	ret

;Restart the event stream for a new level
Event_StreamInit:
	ld (Event_SavedSettings_Plus2-2),de	;Store the address of our setting buffer
	xor a
	ld (Event_MultipleEventCount_Plus1-1),a
	call SetLevelTime

	jr Event_GetEventsNow	; process the first batch of events

Event_MoreEventsDec:			;multiple events at the same timepoint
	dec a
	ld (Event_MultipleEventCount_Plus1-1),a
	ld (Event_NextEventPointer),hl
	jr Event_GetEventsNow

;Process the event stream - the eventstream is basically the level map, rather than a
;bitmap which would waste memory, it is a bytestream based around a Time,Event structure.
; Multiple events can be at the same time, and the length of each event varies depending
;upon the event, for this reason, it is only intended that the stream is read forwards
; not backwards.
Event_Stream:
	ld a,(Timer_TicksOccured)
	and %00000100:Event_LevelSpeed_Plus1	; how often ticks occur
	ret z		; no ticks occured
	ld a,&0 :Event_LevelTime_Plus1
	inc a
	ld (Event_LevelTime),a
	ld b,a


Event_MoreEvents:				
	ld a,1 :Event_NextEventTime_Plus1		;The time the event should occur
	cp b
	ret nz	; event does not happen yet
Event_GetEventsNow:

	ld iy,LdAFromHLIncHL	; Set RST 6 to do our bidding
	ld hl,Event_LoadNextEvt
	push hl			;We do a dirty trick to save space, all these actions end in a RET

	ld hl,6969:Event_NextEventPointer_Plus2		; mem pointer of next byte
	ld a,(hl)
	inc hl
	ld d,a
	and %00001111
	ld b,a
	ld a,d 
	and %11110000
	rrca
	rrca
	rrca
	rrca
	push hl			;
	ld hl,Event_VectorArray
	jp VectorJump_PushHlFirst

Event_VectorArray:

defw	Event_OneObj	;0
defw 	Event_MultiObj	;16
defw	Event_ObjColumn	;32
defw 	Event_ObjStrip	;48
defw	Event_StarBust	;64
defw 	null	;80
defw 	null	;96
defw	Event_CoreMultipleEventsAtOneTime	;112
defw	Event_MoveSwitch	;128
defw	Event_CoreSaveLoadSettings	;144
defw 	null		;160
defw 	null		;176
defw 	null		;192
defw 	null		 ;208
defw 	null		;224
defw	Event_CoreReprogram	;240


Event_StarBust:
	ld d,(hl)	;X
	inc hl
	ld C,(hl)	;Y
	inc hl
	push hl
	call Stars_AddToDefault
	call Stars_AddObjectBatch
	pop hl
	ret ;jp Event_LoadNextEvt


;By default each time can only have ONE event, but we can use this commend to declare
;XX events will occur at this time to save memory!
Event_CoreMultipleEventsAtOneTime:
	ld a,b
	ld (Event_MultipleEventCount_Plus1-1),a
	ret;jp Event_LoadNextEvt




Event_SpriteSwitch_0101:			;Set the next sprite
	ld de,EventObjectSpriteToAdd_Plus1-1
	jr Event_CoreReprogram_ByteCopy

Event_ProgramSwitch_0001:			;Set the next program
	ld de,EventObjectProgramToAdd_Plus1-1
	jr Event_CoreReprogram_ByteCopy

Event_MoveSwitch_0011:				;Set the next move
	ld de,EventObjectMoveToAdd_Plus1-1
	jr Event_CoreReprogram_ByteCopy


Event_ProgramMoveLifeSwitch_0100:		;Set Prog,MoveLife
	rst 6	; Jp (IY)
	;ld a,(hl)	;Program Type
	ld (EventObjectProgramToAdd_Plus1-1),a
	;inc hl						;Fall into Move Life code
Event_MoveLifeSwitch_0000:
	rst 6	; Jp (IY)
	;ld a,(hl)	;Move Type
	ld (EventObjectMoveToAdd_Plus1-1),a
	;inc hl						; Fall into Life code

Event_LifeSwitch_0010:
	ld de,EventObjectLifeToAdd_Plus1-1

Event_CoreReprogram_ByteCopy:			
	rst 6	; Jp (IY)			
	;ld a,(hl)	;read in a byte
	ld (de),a		; put it at DE
	;inc hl
	ret;jp Event_LoadNextEvt

; Reconfigure the core for custom actions this level
Event_CoreReprogram:	;1111????
	ld a,b
	cp 16
	ret nc;jp nc,Event_LoadNextEvt	; our array only has 6 entries
	
	push hl
	ld hl,Event_ReprogramVector
	jp VectorJump_PushHlFirst

Event_ReprogramVector:
defw	Event_CoreReprogram_Palette   	;0 		
defw	Event_CoreReprogram_Background	;1
defw	Event_CoreReprogram_ObjectHitHandler ;2
defw	Event_CoreReprogram_Paralax	;3
defw	Event_CoreReprogram_CustomMove1 ;4
defw	Event_CoreReprogram_CustomMove2 ;5
defw	Event_CoreReprogram_PowerupSprites ;6
defw	Event_CoreReprogram_CustomMove3	;7
defw	Event_CoreReprogram_CustomMove4 ;8
defw    Event_CustomProgram1		;9
defw    Event_CustomProgram2		;10
defw    Event_CustomProgram3		;11
defw    Event_CustomProgram4		;12
defw    Event_BackgroundScrollDirection	;13
defw    Event_ObjectFullCustomMoves	;14
defw    Event_SmartBombSpecial		;15

;Powerup objects are defined by their sprite, which changes each level
; OK so I didn't think this through very well!
Event_CoreReprogram_PowerupSprites:
	rst 6	; Jp (IY)
	;ld a,(hl)
	ld (DroneSprite_Plus1-1),a
	;inc hl
	;ld a,(hl)
	rst 6	; Jp (IY)
	ld (ShootSpeedSprite_Plus1-1),a
	;inc hl
	;ld a,(hl)
	rst 6	; Jp (IY)
	ld (ShootPowerSprite_Plus1-1),a
	;inc hl
	;ld a,(hl)
	rst 6	; Jp (IY)
	ld (PointsSprite_Plus1-1),a
	ld (PointsSpriteB_Plus1-1),a
	ld (PointsSpriteC_Plus1-1),a
	;inc hl
	ret;jp Event_LoadNextEvt
Event_BackgroundScrollDirection:
	rst 6	; Jp (IY)


	; 0-Left 1-Right 2-Up 3-Down
	push af
	call DoMovesBackground_SetScroll
	pop af
	cp 2
	jr NC,Background_Static


	ld bc,Background_LeftScroll	;0
	jr Event_BackgroundScrollDirection_2

Background_Static:
	ld bc,Background_NoShift
Event_BackgroundScrollDirection_2:
	jp set_BackgroundScrollDirection
Event_CoreReprogram_CustomMove1:
	ld de,LevelSpecificMove_Plus2-2
	jr SetCustMove
Event_CoreReprogram_CustomMove2:
	ld de,LevelSpecificMoveB_Plus2-2
	jr SetCustMove

; Custom smartbomb handler - needed to wipe Omega array during final boss
Event_SmartBombSpecial:
	ld de,SmartBombSpecial_Plus2-2
	jr SetCustMove

Event_ObjectFullCustomMoves:			; Override whole move handler
	ld de,ObjectDoMovesOverride_Plus2-2
	jr SetCustMove
Event_CoreReprogram_CustomMove3:
	ld de,LevelSpecificMoveC_Plus2-2
	jr SetCustMove
Event_CoreReprogram_CustomMove4:
	ld de,LevelSpecificMoveD_Plus2-2
	jr SetCustMove


Event_CustomProgram1:
	ld de,CustomProgram1_Plus2-2
	jr SetCustMove
Event_CustomProgram2:
	ld de,CustomProgram2_Plus2-2
	jr SetCustMove
Event_CustomProgram3:
	ld de,CustomProgram3_Plus2-2
	jr SetCustMove
Event_CustomProgram4:
	ld de,CustomProgram4_Plus2-2
	jr SetCustMove
SetCustMove:
	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl
	ld a,c
	ld (de),a
	inc de
	ld a,b
	ld (de),a
	ret;	jp Event_LoadNextEvt

Event_CoreReprogram_Paralax:		; set the paralax scroll point in the background
	;ld a,(hl)
	;inc hl
	rst 6	; Jp (IY)
	ld (ScrollPosRate1_Plus1-1),a
	;ld a,(hl)
	;inc hl
	rst 6	; Jp (IY)
	ld (ScrollPos_Plus1-1),a
	;ld a,(hl)
	;inc hl
	rst 6	; Jp (IY)
	ld (ScrollPosRate2_Plus1-1),a
	ret;jp Event_LoadNextEvt

Event_CoreReprogram_ObjectHitHandler:
	ld de,ObjectShotOverride_Plus2-2
	jr SetCustMove

Event_CoreReprogram_Background:			; Set background (41 byte max)
	ld de,BGGradiant
	jr Event_CoreReprogram_DataCopy

; Program raster palette - careful - this can cause all nasty crashes if you
; do it wrong, as you have to specify bytes, offsets and loop counters,
; it's best to copy existing ones from levels and modify them
	
Event_CoreReprogram_Palette:
	;push bc
	;push de

	ld de,RasterColors_ColorArray1 :RasterColors_ColorArray1PointerB_Plus2
Event_CoreReprogram_DataCopy:
	;reads in Offset then Bytecount from (HL) and dumps to destination DE
	push hl
		ld b,0
		ld c,(hl)	;Byte offset
		ld h,d
		ld l,e
		add hl,bc
		ld d,h
		ld e,l
	pop hl
	inc hl


	ld b,0
	ld c,(hl)	;bytecount
	inc hl

	ldir
	;pop de 
	;pop bc
	ret;jp Event_LoadNextEvt
Event_MoveSwitch:
	ld a,b
	cp 13
	ret nc;jp nc,Event_LoadNextEvt	; our array only has 6 entries

	push hl
	ld hl,Event_MoveVector
	jp VectorJump_PushHlFirst



Event_MoveVector:				;128+
defw Event_MoveLifeSwitch_0000		;0
defw Event_ProgramSwitch_0001		;1
defw Event_LifeSwitch_0010		;2
defw Event_MoveSwitch_0011		;3
defw Event_ProgramMoveLifeSwitch_0100	;4
defw Event_SpriteSwitch_0101		;5
defw Event_AddFront_0110		;6
defw Event_AddBack_0111			;7
defw Event_ChangeStreamTime_1000	;8
defw Event_Call_1001			;9
defw Event_LoadLastAddedObjectToAddress_1010;10
defw Event_ClearPowerups		;11
defw Event_ChangeStreamSpeed_1100	;12

Event_LoadLastAddedObjectToAddress_1010:		
; Used to remember boss objects and apply custom animation etc by hacking the 
; object array.
	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl
	push hl
		ld h,b
		ld l,c

		ld bc, &6969:Objects_LastAdded_Plus2

		ld (hl),c
		inc hl
		ld (hl),b	
	pop hl
	ret;jp Event_LoadNextEvt

; call a function - be very careful what you do, as registers must be pretty
; much untouched otherwise a crash will occur on return. it's best to set a flag
; and do some action in your level loop, as that won't corrupt any registers.
Event_Call_1001:
	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl
	call CallBC
	ret;jp Event_LoadNextEvt


Event_ClearPowerups:		; used at the start of each level to take the users powerups
	call ResetPowerup
	ret;jp Event_LoadNextEvt
CallBC:
	push bc
	ret
	
; alter stream time 
Event_ChangeStreamTime_1000:
	;push bc

	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl
	ld a,(hl)

	ld h,b
	ld l,c	

	call SetLevelTime

	pop hl ; we didn't use up the Event_LoadNextEvt on the stack
	jp Event_MoreEvents

; Add to the foreground (top of the object array)
Event_AddFront_0110:	
	ld a,&23	; INC HL
	ld (Event_AddObject_MoveDirection_Plus1-1),a
	xor a
	jr Event_AddXX
	;ld (Event_AddObject_StartOfLoop_Plus1-1),a
	;ret;jp Event_LoadNextEvt

; Add to the background (bottom of the object array)
Event_AddBack_0111:
	ld a,&2B	; Dec HL
	ld (Event_AddObject_MoveDirection_Plus1-1),a
	ld a,(ObjectArray_Size)
	dec a

Event_AddXX:
	ld (Event_AddObject_StartOfLoop_Plus1-1),a
	ret;jp Event_LoadNextEvt

; Change time between events, used on water level when waterlevel changes - it was
; too slow by default
Event_ChangeStreamSpeed_1100:
	rst 6	; Jp (IY)
	ld (Event_LevelSpeed_Plus1-1),a
	ret;jp Event_LoadNextEvt

; we don't have a tile array - this does spikes in stage 7 and 8 - this can work
; horiz or vert depending on scroll
Event_ObjStrip:
	ld d,(hl)	;X
	inc hl
	ld C,(hl)	;Y
	inc hl
	ld E,(hl)	;S space
	inc hl
	;fall into next event
Event_ObjStrip_Next:
	rst 6	; Jp (IY)
	;ld a,(hl)	; sprnum
	;inc hl
	ld (EventObjectSpriteToAdd_Plus1-1),a


	
	push bc
	push de
		call EventoneObjectStrip
	pop de
	pop bc

	ld a,c	:OBjectStripReprogram_Plus1
	add e
	ld c,a
	
	djnz Event_ObjStrip_Next
	ret;jp Event_LoadNextEvt

;
Event_ObjColumn:
	ld d,(hl)	;X
	ld e,b
	inc hl
    Event_ObjColumn_Next:
	rst 6	; Jp (IY)
	;ld a,(hl)	; sprnum
	;inc hl
	ld (EventObjectSpriteToAdd_Plus1-1),a

	push de
	call EventoneObjectColumn
	pop de
	dec e
	jr nz,Event_ObjColumn_Next
	ret;jp Event_LoadNextEvt

Event_MultiObj:		; Type 16 - multiple objects
	push bc
	call EventoneObject
	pop bc
	djnz Event_MultiObj
	ret;jp Event_LoadNextEvt

Event_OneObj:		; Type 0 - one Obj
	ld a,b	

	cp 1
	jr z,Event_OneObjYOnly
	or a
	jr nz,Event_OneObjQuick 
	
	jr EventoneObject
	;ret;jr Event_LoadNextEvt
	
Event_OneObjYOnly:		; Type 1 - Read in Y and dump the same sprite to far right
	ld c,(hl)	;Y
	inc hl
	jr Event_OneObjQuick_GO

Event_OneObjQuick:	; one sprite, same as last time Y * 16 (Y 2-13)
	rla
	rla
	rla
	rla
	sub 8

OneObjectQuick_Program:
	ld C,a		

Event_OneObjQuick_GO:
	ld D,160+24	
	jr EventoneObjectStrip

; Read in the next object
Event_LoadNextEvt:
	ld a,0 :Event_MultipleEventCount_Plus1
	or a
	jp nz,Event_MoreEventsDec		; there are multiple events at this point
	rst 6	; Jp (IY)
	;ld a,(hl)
	;inc hl
	ld (Event_NextEventTime),a
	ld (Event_NextEventPointer),hl
	ld a,(Event_LevelTime)
	ld b,a
	jp Event_MoreEvents
EventoneObject:
	rst 6	; Jp (IY)
	;ld a,(hl)	; sprnum
	ld (EventObjectSpriteToAdd_Plus1-1),a
	;inc hl
	ld d,(hl)	;X
	inc hl
    EventoneObjectColumn:
	ld c,(hl)	;Y
	inc hl
    EventoneObjectStrip:
	;look for a space in the object array
	push hl
	call Event_AddObject	
	pop hl
	ret

Event_AddObject:
	; D=X C=Y
	ld a,(ObjectArray_Size)
	ld b,a
	ld hl,(ObjectArrayAddress)
	ld a,l
	add 0		:Event_AddObject_StartOfLoop_Plus1
	ld l,a

Event_Objectloop:	
	ld a,(hl)	; Y check
	or a	
	jp NZ,Event_ObjectLoopNext

	;found a free slot!
	ld (Objects_LastAdded_Plus2-2),hl

	ld (hl),c	;Y
	ld c,d
	;ld de,0000ObjectArray_Size_Plus2
	;add hl,de
	inc h;
	ld (hl),c	;X

	
	inc h;	add hl,de
	ld (hl),&0  	:EventObjectMoveToAdd_Plus1	;Move
	inc h;	add hl,de
	ld (hl),&0	:EventObjectSpriteToAdd_Plus1	;sprite
	inc h;	add hl,de
	ld (hl),&0	:EventObjectLifeToAdd_Plus1 ; life
	inc h;	add hl,de
	ld (hl),&0	:EventObjectProgramToAdd_Plus1 ; Program code
	ret
Event_ObjectLoopNext:
	;inc l
	inc hl		:Event_AddObject_MoveDirection_Plus1


	djnz,Event_Objectloop
	ret



Event_CoreSaveLoadSettings: ;     1001XXXX Save/Load object settings XXXX bank (0-15 = load . 16 = Save (to bank marked by next byte))
	ld b,0
	ld a,d 
	and %00001111	; bank no
	cp  %00001111
	jr nz,Event_CoreSaveLoadSettings_Load1	;15 means save
	rst 6	; Jp (IY)
	;ld a,(hl)	;Bank no is next byte when saving
	;inc hl
	jr Event_CoreSaveLoadSettings_Part2
Event_CoreSaveLoadSettings_Load1:
	ld d,b
Event_CoreSaveLoadSettings_Part2:
	add a
	add a	; 4 bytes per bank
	;add a

	ld c,a

	push hl
		ld hl,6969 :Event_SavedSettings_Plus2
		add hl,bc	
		;add hl,bc
		;add hl,bc
		;add hl,bc
		bit 7,d		; This will only be 1 if we are saving
		jp nz,Event_CoreSaveLoadSettings_Save ;----1--- = save
Event_CoreSaveLoadSettings_Load:
		rst 6	; Jp (IY)
		;ld a,(hl)
		ld (EventObjectProgramToAdd_Plus1-1),a
		;inc hl
		rst 6	; Jp (IY)
		;ld a,(hl)
		ld (EventObjectMoveToAdd_Plus1-1),a
		;inc hl
		rst 6	; Jp (IY)
		;ld a,(hl)
		ld (EventObjectLifeToAdd_Plus1-1),a
		;inc hl
		rst 6	; Jp (IY)
		;ld a,(hl)
		ld (EventObjectSpriteToAdd_Plus1-1),a
		;inc hl
		jr Event_CoreSaveLoadSettings_Done
Event_CoreSaveLoadSettings_Save:
		ld a,(EventObjectProgramToAdd_Plus1-1)
		ld (hl),a
		inc hl

		ld a,(EventObjectMoveToAdd_Plus1-1)
		ld (hl),a
		inc hl

		ld a,(EventObjectLifeToAdd_Plus1-1)
		ld (hl),a
		inc hl

		ld a,(EventObjectSpriteToAdd_Plus1-1)
		ld (hl),a
		inc hl

Event_CoreSaveLoadSettings_Done:
	pop hl	;reload the stream pointer
	ret;jp Event_LoadNextEvt


;-----------------------------------------------------------

;                         plus Sprites

; --------------------------------------------------------
ifdef SupportPlus 
Plus_SpritesOff:
	ld a,(CPCVer)
	and 1 
	ret z
	ld de,&0000
	ld h,16
Plus_ShowHide:

	ifdef Debug
		call Debug_CheckIntOff
	endif 
	; h = sprite count 
	; d 1st Sprite Num
	; e = Scale (0 = sprite off , 9= normal )

	ld bc,&7fb8
	out (c),c
	ld b,h

	ld a,d
	sla a
	sla a
	sla a
	ld h,&60
	ld l,a
Plus_ShowHideNext:
	inc l
	inc l
	inc l
	inc l
	ld (hl),e
	inc l
	inc l
	inc l
	inc l
	djnz Plus_ShowHideNext

	
	jp Plus_TurnBankOff

Plus_SetSpriteInterruptsafe:
	di
		call Plus_SetSprite
	ei
ret
Plus_CopySpriteCompressed:
; b Sprite Num
; a Source bank
; hl = Source memory Loc
;	push af
		ld a,b
		ld e,&00
		add &41
		ld d,a
	push de
	call Plus_CopySpriteCompressedPlusPart	
	ei
		pop de
		ld e,&80
		dec d
	di
Plus_CopySpriteCompressedPlusPart: 
; We do the plus sprite in 2 parts to not annoy the interrupts

			ld bc,&7fb8	;turn Plus Asic on
			out (c),c
			;ld bc,&0100
			ld b,&20

			ld (Plus_CopySpriteCompressed_StackRestore_Plus2-2),sp

			ex hl,de
			ld sp,hl
			ex hl,de
Plus_CopySpriteCompressed_Loop:
ld a,(hl)
ld e,a
rrca
rrca
rrca
rrca
ld d,a
push de
dec l
ld a,(hl)
ld e,a
rrca
rrca
rrca
rrca
ld d,a
push de
dec l

;			pop de
;			ld a,e
;			ld (hl),a
;			rrca
;			rrca
;			rrca
;			rrca
;			inc l
;			ld (hl),a
;			inc l
;			ld a,d
;			ld (hl),a
;			rrca
;			rrca
;			rrca
;			rrca
;			inc l
;			ld (hl),a
;			inc l


			djnz Plus_CopySpriteCompressed_Loop
			ld sp,&0000:Plus_CopySpriteCompressed_StackRestore_Plus2


			;ldir

			ld bc,&7fa0 ;turn asic off
			out (c),c

;		ld a,i
		;LD BC,&7F00 ;Gate array port
;		or %11000000 ; Switch memory
;		OUT (C),A ;Send it
	
ret
Plus_HideSprites:
	ld a,(CPCVer)
	and %00000001
	ret z
	ld d,15
Plus_HideSpritesNext:	
	
	ld bc,&00DB

	ld e,b
	push de
	call Plus_SetSprite
	pop de
	dec d
	ld a,d
	cp &FF
	jr nz,Plus_HideSpritesNext

	
	; bc = X (0-160) ,Y (0-199 (>220 is negative)
	; d Sprite Num
	; e = Scale (0 = sprite off , 9= normal )
ret
CoreExt_PlusSpriteSwapB:

	ld b,4
NextSpriteSwapperB:
	push bc
		ld a,b
		dec a

		ld b,a
		add &00	:PlusSpriteOffsetB_Plus1 ;memloc

		push af
		and %00000001
		rrca
		add &7F
		ld l,a

		pop af
		srl a
		add &A8	;memloc of sprite bank
		ld h,a

		;ld h,a
		;ld l,&0
		;ld a,2
; b Sprite Num
; a Source bank
		;ld de,&C000	;temp mem loc (in mainmem)
		di
		call Plus_CopySpriteCompressed
		ei
	pop bc
	djnz NextSpriteSwapperB
ret



Plus_SetSprite:
	ifdef Debug
		call Debug_CheckIntOff
	endif 

	; bc = X (0-160) ,Y (0-199 (>220 is negative)
	; d Sprite Num
	; e = Scale (0 = sprite off , 9= normal )
	push bc
		call Plus_TurnBankOn
	pop bc

	ld a,d
	sla a
	sla a
	sla a
	ld h,&60
	ld l,a


	push de
		;; set x coordinate for sprite 0
		ex hl,de

			ld h,0
			ld l,b
			add hl,hl
			add hl,hl
			;add hl,hl
			;add hl,hl
			;add hl,hl
		ex hl,de
		ld (hl),e
		inc hl
		ld (hl),d
		inc hl
		;; set y coordinate for sprite 0
		ld a,c
		ld d,0
		ld e,a
		cp 220
		jr C,Plus_SetSprite_DoY
		ld d,255
Plus_SetSprite_DoY
		ld (hl),e
		inc hl
		ld (hl),d
		inc hl
	pop de

	ld a,e
	ld (hl),a
	push bc
	call Plus_TurnBankOff
	pop bc
ret
Plus_SetPalette:
	;HL = Address of palette
	call Plus_TurnBankOn
	ld de,&6422
	ld bc,15*2
	ldir

Plus_TurnBankOff:
		ld bc,&7fa0
		out (c),c
ret
Plus_TurnBankOn:
		ld bc,&7fb8
		out (c),c
ret
endif



ifdef Debug
	read "debugger.asm"
endif

limit &A500
read "ArkosTracker2.asm"

ifndef MinimizeCore

scr_addr_table:

defb &00,&00,&00,&08,&00,&10,&00,&18,&00,&20,&00,&28,&00,&30,&00,&38;1
defb &50,&00,&50,&08,&50,&10,&50,&18,&50,&20,&50,&28,&50,&30,&50,&38;2
defb &A0,&00,&A0,&08,&A0,&10,&A0,&18,&A0,&20,&A0,&28,&A0,&30,&A0,&38;3
defb &F0,&00,&F0,&08,&F0,&10,&F0,&18,&F0,&20,&F0,&28,&F0,&30,&F0,&38;4
defb &40,&01,&40,&09,&40,&11,&40,&19,&40,&21,&40,&29,&40,&31,&40,&39;5
defb &90,&01,&90,&09,&90,&11,&90,&19,&90,&21,&90,&29,&90,&31,&90,&39;6
defb &E0,&01,&E0,&09,&E0,&11,&E0,&19,&E0,&21,&E0,&29,&E0,&31,&E0,&39;7
defb &30,&02,&30,&0A,&30,&12,&30,&1A,&30,&22,&30,&2A,&30,&32,&30,&3A;8
defb &80,&02,&80,&0A,&80,&12,&80,&1A,&80,&22,&80,&2A,&80,&32,&80,&3A;9
defb &D0,&02,&D0,&0A,&D0,&12,&D0,&1A,&D0,&22,&D0,&2A,&D0,&32,&D0,&3A;10
defb &20,&03,&20,&0B,&20,&13,&20,&1B,&20,&23,&20,&2B,&20,&33,&20,&3B;11
defb &70,&03,&70,&0B,&70,&13,&70,&1B,&70,&23,&70,&2B,&70,&33,&70,&3B;12
defb &C0,&03,&C0,&0B,&C0,&13,&C0,&1B,&C0,&23,&C0,&2B,&C0,&33,&C0,&3B;13
defb &10,&04,&10,&0C,&10,&14,&10,&1C,&10,&24,&10,&2C,&10,&34,&10,&3C;14
defb &60,&04,&60,&0C,&60,&14,&60,&1C,&60,&24,&60,&2C,&60,&34,&60,&3C;15
defb &B0,&04,&B0,&0C,&B0,&14,&B0,&1C,&B0,&24,&B0,&2C,&B0,&34,&B0,&3C;16
defb &00,&05,&00,&0D,&00,&15,&00,&1D,&00,&25,&00,&2D,&00,&35,&00,&3D
defb &50,&05,&50,&0D,&50,&15,&50,&1D,&50,&25,&50,&2D,&50,&35,&50,&3D
defb &A0,&05,&A0,&0D,&A0,&15,&A0,&1D,&A0,&25,&A0,&2D,&A0,&35,&A0,&3D
defb &F0,&05,&F0,&0D,&F0,&15,&F0,&1D,&F0,&25,&F0,&2D,&F0,&35,&F0,&3D;20
defb &40,&06,&40,&0E,&40,&16,&40,&1E,&40,&26,&40,&2E,&40,&36,&40,&3E
defb &90,&06,&90,&0E,&90,&16,&90,&1E,&90,&26,&90,&2E,&90,&36,&90,&3E
defb &E0,&06,&E0,&0E,&E0,&16,&E0,&1E,&E0,&26,&E0,&2E,&E0,&36,&E0,&3E
defb &30,&07,&30,&0F,&30,&17,&30,&1F,&30,&27,&30,&2F,&30,&37,&30,&3F
defb &80,&07,&80,&0F,&80,&17,&80,&1F,&80,&27,&80,&2F,&80,&37,&80,&3F
endif
;,&21




save direct "T37-SC1.D00",&8000,&2500	;address,size...}[,exec_address]
