
read "CoreDefs.asm" ; Remember! Put this first!
limit &E00	
org &50


;
;Rastercolor buffer - 80 bytes (&50
RasterColors_ColorArray1:
	defb 1
	defb 1
	defb 64+20,64+24,64+29,64+11	 :IlluminatedPaletteA_Plus2
RasterColors_ColorArray2:
	defb 1
	defb 1

	defb 64+20,64+12,64+13,64+11	:IlluminatedPaletteB_Plus2
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 12
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray3:
	defb 1
	defb 1
	defb 64+20,64+12,64+13,64+11 :IlluminatedPaletteC_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray4:
	defb 1
	defb 1 
	defb 64+20,64+31,64+14,64+11 :IlluminatedPaletteD_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11



align 256,&00
StarArraySize equ 255
StarArrayPointer: 	
defs StarArraySize*3,&00


ObjectArraySize equ 60
PlayerStarArraySize equ 36

align 256,&00
PlayerStarArrayPointer: 
defs 64,&00
ObjectArrayPointer:
defs 64,&00
align 256,&00
defs 255*5,&00

;defs ObjectArraySize*6,&00
;defs PlayerStarArraySize*3,&00

;align 256,&00

	

Event_SavedSettings:
defs 4*16,&00


RasterColors_ColorArray1Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteAAlt_Plus2
RasterColors_ColorArray2Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteBAlt_Plus2
RasterColors_ColorArray3Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteCAlt_Plus2
RasterColors_ColorArray4Alt:
	defb 1
	defb 1 
	defb &54,&54,&54,&54		 :IlluminatedPaletteDAlt_Plus2



CustomRam:
defs 64 ;  Pos-Tick-Pos-Tick ; enough memory for 16 enemies!



limit &2000
org &1000
;incbin "Sprites\PLAYER.SPR"

limit &FFFF
org &2800
LevelSprites:
;incbin "Sprites\LEVEL1A2.SPR"
incbin "Sprites\LEVEL3.SPR"




evtSettingsBank_Save equ %10010000+15
evtSettingsBank_Load equ %10010000+0
evtMultipleCommands equ %01110000


evtSetMoveLife     equ 128
evtSetProg	   equ 129
evtSetLife	   equ 130
evtSetMove	   equ 131
evtSetProgMoveLife equ 132
evtSetSprite	   equ 133
evtAddToForeground equ 135
evtAddToBackground equ 134
evtJumpToNewTime   equ 136
evtCallAddress	   equ 137
evtSaveLstObjToAdd equ 138
evtResetPowerup    equ 139

evtReprogram_PowerupSprites equ %11110110

evtSingleSprite equ 0

prgSpecial	equ 2
prgBonus 	equ 3
prgMovePlayer	equ 4
prgFireSnail	equ %10000000
prgFireSlow	equ %01100000
prgFireMid	equ %01000000
prgFireMid2	equ %11000000
prgFireFast	equ %00100000


mveStatic 	equ &24
mveSeaker	equ %10000100
mveWave		equ %10100000
;mveWaveSmall	equ %10010000 depricated
mveCustom1	equ %11110000
mveCustom2	equ %11100000
mveCustom3	equ %11010000
mveCustom4	equ %10110000

evtReprogramCustomMove1 equ %11110100
evtReprogramCustomMove2 equ %11110101
evtReprogramCustomMove3 equ %11110111
evtReprogramCustomMove4 equ %11111000

evtReprogramCustomProg1 equ %11111001
evtReprogramCustomProg2 equ %11111010
evtReprogramCustomProg3 equ %11111011
evtReprogramCustomProg4 equ %11111100

lifEnemy	equ %11000000	;HurtByBullets,Hurts Player
lifTimed	equ %00000000	;Doesnt hurt, dies automatically
lifDeadly	equ %01000000	;Deadly and cant be shot
TwoFrameSprite  equ 128




;limit &3000


org &3A00


EventStreamArray:

;defb 1,128,&24,128+64+60		; Move Static


defb 0,evtResetPowerup

defb 0,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		



; Define the background
defb 0,240+3,%11111111,30,%00000010

;defb 0,240+1,0,2*15+1				; (Time,Cmd,Off,Bytes) Load 41 bytes into the background - 41 bytes is the limit

;defb &00,&20	;1; first line
;defb 198,&80	;2; line num, New byte
;defb 190,&20	;3; line num, New byte
;defb 188,&20	;4; line num, New byte
;defb 180,&08	;5; line num, New byte
;defb 160,&02	;6; line num, New byte
;defb 150,&00	;7; line num, New byte
;defb 146,&00	;8

;defb 122,&20	;9; line num, New byte

;defb 78,&0	;10
;defb 76,&0	;10
;defb 24,&02	;12 line num, New byte
;defb 18,&08	;13
;defb 4,&00	;14
;defb 2,&00	;15
;defb 255


defb 0,240+1,0,2*20+1				; (Time,Cmd,Off,Bytes) Load 41 bytes into the background - 41 bytes is the limit


;defb &0D,&0D	;1; first line
;defb 196,&07	;2
;defb 190,&0A	;3
;defb 186,&05	;4
;defb 180,&08	;5
;defb 176,&02	;6

defb &0F,&0F	;1; first line

defb 198,&0D	;2

defb 196,&07	;3
defb 190,&0A	;4
defb 186,&05	;5
defb 180,&08	;6
defb 170,&02	;7; line num, New byte
defb 160,&00	;8
defb 150,&00	;9
defb 120,&20	;10; line num, New byte
defb 110,&80	;11; line num, New byte
defb 108,&20	;12 line num, New byte
defb 90,&0	;13 line num, New byte
defb 80,&0	;14
defb 24,&20	;15
defb 20,&80	;16
defb 16,&A0	;17
defb 12,&02	;18
defb 8,&08	;19
defb 4,&0A	;20
defb 255


;We will use 4 Paralax layers
; ---------()- (sky)		%11001000
; ------------ (Far)		%11000100
; -----X---X-- (mid)		%11000010	Bank 1
; []=====[]=== (foreground) 	%11000001	Bank 0



defb 0,evtReprogram_PowerupSprites,128+27,128+26,128+25,128+24	; Define powerup sprites

; Background L
defb 0,128+4,1,%11000001,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,%10010000+15,0				; Save Object settings to Bank 0

defb 0,128+4,1,%11000010,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,evtSettingsBank_Save,1				; Save Object settings to Bank 1



; Mukadebachi
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,0,mveCustom3+4,lifEnemy+9; Program - Fire Left... Move - wave... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+2				; Sprite 1 Frame animater
defb 	evtSettingsBank_Save,2	

; Kamisagi
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,0,mveCustom1,lifEnemy+5; Program - Fire Left... Move - wave... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,0				; Sprite 1 Frame animater
defb 	evtSettingsBank_Save,3	

; Kamisagi program code
defb 0,evtReprogramCustomMove1
defw CustomMoveBouncer


; GnatPack
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireFast+16,mveWave+%00000001,lifEnemy+3	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+11		
defb 	evtSettingsBank_Save,4		

; Biterfly
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireSlow+13,mveWave+%00000000,lifEnemy+6	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+5		
defb 	evtSettingsBank_Save,5		

; Zombie Salaryman
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireSlow+1,&23,lifEnemy+3	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+4		
defb 	evtSettingsBank_Save,6		

; Zombie Capybara
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireSnail+5,&23,lifEnemy+9	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+6		
defb 	evtSettingsBank_Save,7		

; Shroom Bomber
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireMid+6,&23,lifEnemy+2	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+21		
defb 	evtSettingsBank_Save,8		





; Trunks in background

;Tree Trunk
defb 0,evtMultipleCommands +3							; 2 commands at the same timepoint
defb evtAddToBackground 
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,22,20+24,6*16 -4 

;Tree Trunk
defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,15,60+24,6*16 -4 

;Tree Trunk
;defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,22,120+24,6*16 -4 


;Green
defb 0,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,12,140+24,6*16 -4 
defb 	evtSingleSprite,14,140+24+12,6*16 -4 


;Branch
;defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,7,100+24-12,5*16 -12 
;Branch
;defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,28,100+24,5*16 -12


;Branch
;defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,8,100+24+12,5*16 -12 




;Branch
;defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,7,100+24-12,3*16 -4 
;Branch
;defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,28,100+24,3*16 -4 


;Branch
;defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,8,100+24+12,3*16 -4 



;Grass Tuft
defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,20,70+24,12*16  

;Grass Tuft
defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,17,30+24,11*16  

;Grass Tuft
defb 0,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,18,110+24,11*16  

;mukadebachi
defb 0,evtReprogramCustomMove3
defw CustomMove3





;Palette Change
defb 1,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&44,&40		

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40			











; Load Palette

	defb 2,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&5D,&59,&4B		;Black,DkBlue,LtYellow,White

	;defb 0,240,6,6			; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 5
	;defb 1				
	;defb &54,&55,&43,&4B		;Black,DkBlue,LtYellow,White

	defb 240,26*0+6,5*1+1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1	; Switches
	defb 64	;delay			
	defb &54,&5C,&59,&4B




	defb 240,26*1+6,1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0

	defb 240,26*2+6,5*2+1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1 ; no of switches
	defb 0	;delays			
	defb &54,&58,&52,&4B		;Black,Red,Grey,White
	defb 0
	defb &54,&58,&52,&4B		
	
	
	;defb 1				
	;defb &54,&4C,&56,&4B

; start of level






;Tree Trunk
;defb 10,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,12,80+24,6*16 -4 

;Tree Trunk
;defb 10,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,14,80+24+12,6*16 -4 








; GnatPack
defb 3,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +4							; Load Settings from bank 2
defb 	evtAddToForeground
defb 	evtSingleSprite+7	


; Zombie Salaryman
defb 9,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +6	
defb 	evtSingleSprite+12				; Row 16, last Column, Last Sprite


;TreeTop
;defb 20,evtMultipleCommands +4
;defb evtAddToBackground							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSetSprite,9
;defb 	evtSingleSprite+4	


; Zombie Salaryman
defb 24,evtMultipleCommands +3
defb evtAddToForeground					; 
defb 	evtSettingsBank_Load +6	
defb 	evtSingleSprite+12				


; drone
defb 25,evtMultipleCommands+2			; 2 commands at the same timepoint
defb 	evtSetProgMoveLife,3,&22,64+63	; Program - Bitshift Sprite... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4
defb 	evtSingleSprite,128+ 27,160+24,50+24	; 	; Single Object sprite 11 (animated)


; Bitterfly
;defb 3,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +5							; Load Settings from bank 2
;defb 	evtSingleSprite+7	



;Tree Trunk
;defb 6,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,22,160+24,6*16 -3 



;Leaves 1
;defb 3,evtMultipleCommands +3							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSetSprite,7
;defb 	evtSingleSprite+6	

;Tree 
;defb 9,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSingleSprite,12,160+24,6*16 +4


;Leaves 3
;defb 15,evtMultipleCommands +3							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSetSprite,8
;defb 	evtSingleSprite+6	


; GnatPack
defb 28,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +4							; Load Settings from bank 2
defb 	evtSingleSprite+7	

;Grass
defb 30,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,20
defb 	evtSingleSprite+13	


;TreeTop
;defb 32,evtMultipleCommands +3							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
;defb 	evtSetSprite,10
;defb 	evtSingleSprite+4	



; Shroom Bomber
defb 38,evtMultipleCommands +3
defb evtAddToForeground
defb 	evtSettingsBank_Load +8	
defb 	evtSingleSprite+3


;Grass
defb 40,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,16
defb 	evtSingleSprite+12	

; Zombie Salaryman
defb 45,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +6	
defb 	evtSingleSprite+12				; Row 16, last Column, Last Sprite


; GnatPack
defb 50,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +4							; Load Settings from bank 2
defb 	evtSingleSprite+7	


; Shroom Bomber
defb 60,evtMultipleCommands +2		
defb 	evtSettingsBank_Load +8	
defb 	evtSingleSprite+3


; Zombie Salaryman
;defb 60,evtMultipleCommands +2							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +6	
;defb 	evtSingleSprite+12				; Row 16, last Column, Last Sprite


;Tree Trunk
defb 60,evtMultipleCommands +3							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,22,160+24,6*16 -4 



; Shroom Bomber
;defb 65,evtMultipleCommands +2		
;defb 	evtSettingsBank_Load +8	
;defb 	evtSingleSprite+3


; drone
defb 65,evtMultipleCommands+3			; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSetProgMoveLife,3,&22,64+63	; Program - Bitshift Sprite... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4
defb 	evtSingleSprite,128+ 27,160+24,50+24	; 	; Single Object sprite 11 (animated)

;Grass
defb 70,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,20
defb 	evtSingleSprite+13	

; Shroom Bomber
;defb 70,evtMultipleCommands +2		
;defb 	evtSettingsBank_Load +8	
;defb 	evtSingleSprite+3


; Zombie Capybara
defb 70,evtMultipleCommands +3							; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSettingsBank_Load +7	
defb 	evtSingleSprite+12				; Row 16, last Column, Last Sprite



;Grass
defb 80,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,17
defb 	evtSingleSprite+12	


;Grass
defb 90,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,18
defb 	evtSingleSprite+11	

; Zombie Salaryman
defb 95,evtMultipleCommands +3							; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSettingsBank_Load +6	
defb 	evtSingleSprite+12				; Row 16, last Column, Last Sprite


;Grass
defb 100,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,16
defb 	evtSingleSprite+13	



; MukadeBachi1
defb 100,evtMultipleCommands + 6						; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSettingsBank_Load +2							; Load Settings from bank 2
defb 	evtSetMove,mveCustom3+4
defb 	evtSetSprite,TwoFrameSprite+1
defb 	evtSetProg,prgFireSlow+11
defb 	evtSingleSprite+7	

; MukadeBachi2
defb 103,evtMultipleCommands+4							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +2							; Load Settings from bank 2
defb 	evtSetMove,mveCustom3+4
defb 	evtSetSprite,TwoFrameSprite+2
defb 	evtSingleSprite+7	


; Powerup Rate
defb 105,evtMultipleCommands+2			; 2 commands at the same timepoint
defb 	evtSetProgMoveLife,3,&22,64+63	; Program - Bitshift Sprite... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4
defb 	evtSingleSprite,128+ 26,160+24,50+24	; 	; Single Object sprite 11 (animated)



; MukadeBachi3
defb 106,evtMultipleCommands+5					
defb 	evtSettingsBank_Load +2						
defb 	evtSetMove,mveCustom3+4
defb 	evtSetSprite,TwoFrameSprite+29
defb 	evtSetProg,prgFireSnail+13
defb 	evtSingleSprite+7	

; MukadeBachi4
defb 109,evtMultipleCommands+4							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +2							; Load Settings from bank 2
defb 	evtSetMove,mveCustom3+4
defb 	evtSetSprite,TwoFrameSprite+2
defb 	evtSingleSprite+7	


;Tree Trunk
defb 110,evtMultipleCommands +3							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,23,160+24,6*16 -4 

; MukadeBachi5
defb 112,evtMultipleCommands+6
defb evtAddToForeground
defb 	evtSettingsBank_Load +2						
defb 	evtSetMove,mveCustom3+4
defb 	evtSetSprite,TwoFrameSprite+3
defb 	evtSetProg,prgFireSlow+12
defb 	evtSingleSprite+7	

; Shroom Bomber
defb 118,evtMultipleCommands +2		
defb 	evtSettingsBank_Load +8	
defb 	evtSingleSprite+3


;Grass
defb 120,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,17
defb 	evtSingleSprite+12	

; Zombie Salaryman
defb 130,evtMultipleCommands +3							; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSettingsBank_Load +6	
defb 	evtSingleSprite+12				; Row 16, last Column, Last Sprite


;Grass
defb 140,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,19
defb 	evtSingleSprite+11	


; Kamisagi
defb 145,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSettingsBank_Load +3							; Load Settings from bank 2
defb 	evtSetMove,mveCustom1+8
defb 	evtSingleSprite+12	


; Bitterfly
defb 146,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +5							; Load Settings from bank 2
defb 	evtSingleSprite+7	



;Green
defb 150,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,12,160+24,6*16 -4 
defb 	evtSingleSprite,14,160+24+12,6*16 -4 


; drone
defb 150,evtMultipleCommands+3			; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSetProgMoveLife,3,&22,64+63	; Program - Bitshift Sprite... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4
defb 	evtSingleSprite,128+ 27,160+24,50+24	; 	; Single Object sprite 11 (animated)



; Bitterfly
defb 160,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +5							; Load Settings from bank 2
defb 	evtSingleSprite+7	



;Grass
defb 170,evtMultipleCommands +4
defb evtAddToBackground
defb 	evtSettingsBank_Load +0		
defb 	evtSetSprite,16
defb 	evtSingleSprite+12	



; Zombie Capybara
defb 175,evtMultipleCommands +3
defb evtAddToForeground
defb 	evtSettingsBank_Load +7	
defb 	evtSingleSprite+12				; Row 16, last Column, Last Sprite



;Tree Trunk
defb 180,evtMultipleCommands +3							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,23,160+24,6*16 -4 


; GnatPack
defb 190,evtMultipleCommands +3							; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSettingsBank_Load +4							; Load Settings from bank 2
defb 	evtSingleSprite+7	


;Grass
defb 190,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,17
defb 	evtSingleSprite+12	


; Powerup Rate
defb 195,evtMultipleCommands+3			; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSetProgMoveLife,3,&22,64+63	; Program - Bitshift Sprite... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4
defb 	evtSingleSprite,128+ 25,160+24,50+24	; 	; Single Object sprite 11 (animated)

; Zombie Salaryman
defb 198,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +6	
defb 	evtSingleSprite+12				; Row 16, last Column, Last Sprite


; MukadeBachi1
defb 200,evtMultipleCommands + 5						; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +2							; Load Settings from bank 2
defb 	evtSetMove,mveCustom3+4
defb 	evtSetSprite,TwoFrameSprite+1
defb 	evtSetProg,prgFireMid+11
defb 	evtSingleSprite+7	

; GnatPack
defb 201,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +4							; Load Settings from bank 2
defb 	evtSingleSprite+7	


; Shroom Bomber
defb 202,evtMultipleCommands +2		
defb 	evtSettingsBank_Load +8	
defb 	evtSingleSprite+3

; MukadeBachi2
defb 203,evtMultipleCommands+4							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +2							; Load Settings from bank 2
defb 	evtSetMove,mveCustom3+4
defb 	evtSetSprite,TwoFrameSprite+2
defb 	evtSingleSprite+7	


; Kamisagi
defb 205,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +3							; Load Settings from bank 2
defb 	evtSetMove,mveCustom1+8
defb 	evtSingleSprite+12	


; MukadeBachi3
defb 206,evtMultipleCommands+5					
defb 	evtSettingsBank_Load +2						
defb 	evtSetMove,mveCustom3+4
defb 	evtSetSprite,TwoFrameSprite+29
defb 	evtSetProg,prgFireSlow+13
defb 	evtSingleSprite+7	


; Shroom Bomber
;defb 207,evtMultipleCommands +2		
;defb 	evtSettingsBank_Load +8	
;defb 	evtSingleSprite+3


; GnatPack
defb 207,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +4							; Load Settings from bank 2
defb 	evtSingleSprite+7	

; Zombie Salaryman
defb 208,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +6	
defb 	evtSingleSprite+12				; Row 16, last Column, Last Sprite


; MukadeBachi4
defb 209,evtMultipleCommands+4							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +2							; Load Settings from bank 2
defb 	evtSetMove,mveCustom3+4
defb 	evtSetSprite,TwoFrameSprite+2
defb 	evtSingleSprite+7	


; MukadeBachi5
defb 212,evtMultipleCommands+5					
defb 	evtSettingsBank_Load +2						
defb 	evtSetMove,mveCustom3+4
defb 	evtSetSprite,TwoFrameSprite+3
defb 	evtSetProg,prgFireMid+12
defb 	evtSingleSprite+7	

; Zombie Salaryman
defb 214,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +6	
defb 	evtSingleSprite+12				; Row 16, last Column, Last Sprite


; GnatPack
defb 215,evtMultipleCommands +2							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +4							; Load Settings from bank 2
defb 	evtSingleSprite+7	


;Grass
defb 220,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,20
defb 	evtSingleSprite+13	



; Bitterfly
defb 220,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSettingsBank_Load +5							; Load Settings from bank 2
defb evtSetMove,mveWave+%00000000
defb 	evtSingleSprite+5	


; Bitterfly
defb 220,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +5							; Load Settings from bank 2
defb evtSetMove,mveWave+%0000001
defb 	evtSingleSprite+9	



;Tree Trunk
defb 225,evtMultipleCommands +3							; 2 commands at the same timepoint
defb evtAddToBackground
defb 	evtSettingsBank_Load +1							; Load Settings from bank 2
defb 	evtSingleSprite,22,160+24,6*16 -4

;Grass
defb 230,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,18
defb 	evtSingleSprite+11


;Grass
defb 240,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +0							; Load Settings from bank 2
defb 	evtSetSprite,19
defb 	evtSingleSprite+11







; Bitterfly
defb 250,evtMultipleCommands +4							; 2 commands at the same timepoint
defb evtAddToForeground
defb 	evtSettingsBank_Load +5							; Load Settings from bank 2
defb evtSetMove,mveWave+%00000001
defb 	evtSingleSprite+3	


; Bitterfly
defb 250,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +5							; Load Settings from bank 2
defb evtSetMove,mveWave+%00000010
defb 	evtSingleSprite+10	




; Bitterfly
defb 10,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +5							; Load Settings from bank 2
defb evtSetMove,mveWave+%00000000
defb 	evtSingleSprite+5	


; Bitterfly
defb 10,evtMultipleCommands +3							; 2 commands at the same timepoint
defb 	evtSettingsBank_Load +5							; Load Settings from bank 2
defb evtSetMove,mveWave+%0000001
defb 	evtSingleSprite+9	




LevelEndAnim:
defb 30,%01110000+2			; 3 commands at the same timepoint
defb evtSetProgMoveLife,prgMovePlayer,&24,10
defb 	0,128+	20,140+24,100+24	; 	; Single Object sprite 11 (animated)

defb 30,%10001001			;Call a memory location
defw	ClearBadguys
;Palette Change
defb 32,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&44,&40		

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40			





defb 33,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

defb 33,evtCallAddress			;Call a memory location
defw	EndLevel


EndLevel:
	pop hl	;
	ld hl,	&0104 				;load level 2
	jp	Akuyou_ExecuteBootStrap	; Start the game, no return




; MukadeBachi1
;defb 6,evtMultipleCommands + 5						; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +2							; Load Settings from bank 2
;defb 	evtSetMove,mveCustom3+4
;defb 	evtSetSprite,TwoFrameSprite+1
;defb 	evtSetProg,prgFireSlow+11
;defb 	evtSingleSprite+7	

; MukadeBachi2
;defb 6+3,evtMultipleCommands+4							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +2							; Load Settings from bank 2
;defb 	evtSetMove,mveCustom3+4
;defb 	evtSetSprite,TwoFrameSprite+2
;defb 	evtSingleSprite+7	

; MukadeBachi3
;defb 6+6,evtMultipleCommands+5					
;defb 	evtSettingsBank_Load +2						
;defb 	evtSetMove,mveCustom3+4
;defb 	evtSetSprite,TwoFrameSprite+29
;defb 	evtSetProg,prgFireSnail+13
;defb 	evtSingleSprite+7	

; MukadeBachi4
;defb 6+9,evtMultipleCommands+4							; 2 commands at the same timepoint
;defb 	evtSettingsBank_Load +2							; Load Settings from bank 2
;defb 	evtSetMove,mveCustom3+4
;defb 	evtSetSprite,TwoFrameSprite+2
;defb 	evtSingleSprite+7	

; MukadeBachi5
;defb 6+12,evtMultipleCommands+5					
;defb 	evtSettingsBank_Load +2						
;defb 	evtSetMove,mveCustom3+4
;defb 	evtSetSprite,TwoFrameSprite+3
;defb 	evtSetProg,prgFireSlow+12
;defb 	evtSingleSprite+7	






limit &3ff0


LevelInit:

	; wipe our memory, to clear out any junk from old levels
;	ld de,&51
;	ld hl,&50
;	ld bc,&5FF
;	ld (hl),0
;	ldir 


	;set the palette up
	;Fix up the Palette - not needed if the palette is in the saved level code OR the stream init is done
	;before the rasters start
	;ld hl,&0001
	;ld (RasterColors_ColorArray1),hl
	;ld (RasterColors_ColorArray2),hl
	;ld (RasterColors_ColorArray3),hl
	;ld (RasterColors_ColorArray4),hl
	;ld a,1
	;ld bc,RasterColors_ColorArray1
	;ld de,RasterColors_ColorArray2
	;ld hl,RasterColors_ColorArray3
	;ld ix,RasterColors_ColorArray4
	;ld iy,null
	;call Akuyou_RasterColors_SetPointers



	ld a,1
	ld bc,RasterColors_ColorArray1
	ld de,RasterColors_ColorArray2
	ld hl,RasterColors_ColorArray3
	ld ix,RasterColors_ColorArray4
	ld iy,null
	call Akuyou_RasterColors_SetPointers



	ld a, StarArraySize
	ld hl,StarArrayPointer
	call AkuYou_StarArrayInit_Enemy 

	ld a, PlayerStarArraySize
	ld hl,PlayerStarArrayPointer
	call AkuYou_StarArrayInit_Player 

	ld a,ObjectArraySize
	ld hl,ObjectArrayPointer
	call AkuYou_ObjectArray_Init


	call Akuyou_Music_Restart

	ld hl,LevelSprites	
	ld de,&1000
	call AkuYou_SpritePointerInit


	ld hl,EventStreamArray		;Event Stream
	ld de,Event_SavedSettings	;Saved Settings
	call AkuYou_Event_StreamInit



	call Akuyou_ScreenBuffer_Init
	call Akuyou_RasterColors_Init


	;call RasterColors_Reset
LevelLoop:

	ifdef Debug
		;call Timer_Start ; **** THIS MUST DIE - IT CRASHES THE GAME ***
	endif

	;halt
	call Akuyou_Background_Clear
	;ld l,&08
	;call Timer_Stop
	;ld l,&09
	;call Timer_Stop
	;ld a,"B"
	;call &bb5a 


	call Akuyou_EventStream_Process
	;ld l,&0a
	;call Timer_Stop
	;ld a,"S"
	;call &bb5a 

	;halt
	call Akuyou_ObjectArray_Redraw
	;ld l,&0b
	;call Timer_Stop
	;ld a,"O"
	;call &bb5a 


	;halt
	call Akuyou_Player_Handler
	;ld l,&0c
	;call Timer_Stop
	;ld a,"P"
	;call &bb5a 



	call Akuyou_StarArray_Redraw
	;ld l,&0d
	;call Timer_Stop
	;ld a,"S"
	;call &bb5a 


	call AkuYou_Player_StarArray_Redraw
	;ld l,&0e
	;call Timer_Stop
	;ld a,"F"
	;call &bb5a 

	;halt
	call AkuYou_Player_DrawUI
list
	call Akuyou_PlaySfx

ifdef Debug
;	ld l,&0f
;	call Timer_Stop
	call ShowLevelTimeB
endif

	call Akuyou_ScreenBuffer_Flip
	jp LevelLoop

LevelShutdown:

ret
Timer_Start:
ld      hl,(&b8b4) ;this is the memloc KL_Time_Please actually uses!
;call &BD0D ;KL_TIME_PLEASE
ld a,l
ld (Timer_LastTime_Plus2-2),a
ld a,h
ld (Timer_LastTime_Plus2-1),a
ret

ShowLevelTimeB:
	;ld hl,&C000
	;call Akuyou_ShowSprite_SetBankAddr
	call Akuyou_SpriteBank_Font

	ld hl,&1001
	call Akuyou_DrawText_LocateSprite

	call Akuyou_GetLevelTime
	push bc	
	call ShowHex
	pop bc
	ld a,b
	call ShowHex
ret

Timer_Stop:
	;ld hl,&C000
	;call Akuyou_ShowSprite_SetBankAddr
	call Akuyou_SpriteBank_Font
;	ret
	ld h,&03
	ld l,&10
	call Akuyou_DrawText_LocateSprite ; set location
	;call &BD0D ;KL_TIME_PLEASE
	ld      hl,(&b8b4) ;this is the memloc KL_Time_Please actually uses!
	ld bc,&0000 :Timer_LastTime_Plus2
	;turn BC negative
	ld a,b
	cpl
	ld b,a
	ld a,c
	cpl
	ld c,a
	inc bc

	add hl,bc

	ld a,l
	call ShowHex
	ret

ShowHex:

	push af         ;store original byte value
	rrca            
	rrca
	rrca
	rrca
	call ShowHexDigit
	pop af          ;retrieve original byte value

ShowHexDigit:
;	and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
;	add a,"0"       ;add ASCII for 0. Digits 0...9 become "0"..."9", digits 10..15
;	cp "9"+1        
;	jr c,ShowHexDigitNum     ;if number is in digit range 0...9, display digit
;	add a,"A"-"9"-1 ;modify ASCII value so that digits in the range 10...15
and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
cp &a           ;Less than 10?  Set carry if so
sbc a,&69
daa             ;Because previous instruction was a subtract operation this
                ;is known as 'das' in x86
ShowHexDigitNum:
	jp Akuyou_DrawText_CharSprite   ;display digit


ClearBadguys:
	ld a,1
	ld i,a
	push hl
	call Akuyou_DoSmartBombCall
	pop hl
ret

null:ret

CustomMoveBouncer:
	ld c,190
	push hl

		;ld a,d
		;and %00001111
		;ld hl,CustomRam
		;push de
		;	ld d,0
		;	ld e,a
		;	add hl,de
		;pop de
		;ld a,(hl)
		;inc a
		;ld (hl),a

		; B=X C=Y D=Move
		ld a,b
		cp 184
		call z,CustomMoveBouncer_Init

		call Akuyou_Timer_GetTimer
		ld h,a

		;shift the time
		ld a,i
		ld l,a

		ld a,d
		and %00001111
		add a,l
		ld i,a


		bit 5,a
		jr z,CustomMoveBouncer_Vert
		dec b
		ld iyl,0			; Program - do nothing
		jr CustomMoveBouncer_Done
CustomMoveBouncer_Vert
		;0000D111
		bit 4,a
		jr z,CustomMoveBouncer_DoJump
		xor %00001111
		jr CustomMoveBouncer_DoJump
CustomMoveBouncer_DoJump
		and %00001111
		rlca
		rlca
		rlca
		cpl
		inc a
		add c
		ld c,a
		
		ld a,i
		and %00011111
		cp  %00001110
		jp nz,CustomMoveBouncer_FireNormal
		ld iyl,prgFireFast+13		; Program Fire
		jp CustomMoveBouncer_DoSprite

CustomMoveBouncer_FireNormal	
		ld iyl,prgFireFast+16		; Program Fire

CustomMoveBouncer_DoSprite
		ld a,h
		bit 1,a
		jp z,CustomMoveBouncer_Done
		call Akuyou_ObjectProgram_SpriteBankSwitch
CustomMoveBouncer_Done:
	pop hl
ret
CustomMoveBouncer_Init:
	;ld a,0
	;ld (hl),a
	dec b
ret


CustomMove3:
	di
	exx
	ld hl,CustomMovePatternGeneric
	ld de,CustomMovePatternMiniWave
	ld bc,CustomMovePattern_Init10

jr CustomMovePattern

CustomMovePatternMiniWave:

	;		   
	; WaveSmall pattern  1010SPPP	S= Speed, PPP Position
	ld a,b
	srl a	; unrem for speedup
	srl a	; unrem for speedup
	and %00011111
	cp  %00010000
	jr C,DoMoves_WaveSmallContinue
	xor %00011111
DoMoves_WaveSmallContinue:
	ld C,a
	ld a,%00000011
;	and %00000111
DoMoves_WaveEnd
	rrca
	rrca
	rrca		; equivalent to 5 left shifts
	or %00011100

	add C
	ld C,a

	ld a,B
	sub 1
	ld B,A
	cp 24			;we are at the bottom of the screen
	jp C,CustomMovePatternKill	;over the page
	ret



GetCustomRam:
	and %00001111
		ld hl,CustomRam
			
			ld d,0
			ld e,a
			add hl,de
			add hl,de
			add hl,de
			add hl,de
		push hl
		pop ix
ret

CustomMovePattern:		; B=X C=Y D=Move
	ld (CustomPatternJump_Plus2-2),hl
	ld (CustomPatternbJump_Plus2-2),de
	ld (CustomMovePattern_Init_Plus2-2),bc
	exx



;		ld a,iyl ; Program Code
;		ld a,ixl ;Life  - MOVED INTO af'
;		ld a,iyh ;spr
;		ld (hl),ixh ;Move
;		ld (hl),b ;X
;		ld (hl),c ;Y

		

	ld a,ixl	;lifCustom 
	ex af,af'

	ld a,d
	exx
	push ix


		call GetCustomRam

		call Akuyou_Timer_GetTimer
		ld d,a
		ld a,i	; Level time
		ld e,a


		;dont update more than once per tick! 
		ld a,(ix+1)
		cp e
		jr z,CustomMovePattern_NoTick	
		ld a,e
		ld (ix+1),e

		;see if this is our first run
		ex af,af'
			cp 250
			call nc,CustomMovePattern_Init :CustomMovePattern_Init_Plus2
		ex af,af'


		; here is where we make some moves!
		exx
		call CustomMovePatternGeneric :CustomPatternJump_Plus2
		exx
		;increment the pos
	

CustomMovePattern_NoTick:
		
		; here is where we make some moves!
		exx
		call null :CustomPatternbJump_Plus2


		ld a,b
		cp 160+24
		call NC,CustomMovePatternKill
		exx
		;increment the pos
	


	;	jp CustomMovePattern_Done

CustomMovePattern_Done:


	ld a,iyl
	cp prgSpecial
	jr nz,CustomMovePattern_NotBossTarget
	ld a,0:TargetSpritecountdown_Plus1
	or a
	jr z,CustomMovePattern_TargetReset
	dec a
	ld (TargetSpritecountdown_Plus1-1),a
CustomMovePattern_TargetSet:
	ld a,128+9	:HitTargetSprite_Plus1
	ld iyh,a
	jr CustomMovePattern_NotBossTarget
CustomMovePattern_TargetReset:
	ld a,128+8 	:ResetTargetSprite_Plus1
	ld iyh,a
CustomMovePattern_NotBossTarget:
	pop ix
	exx

	ex af,af'

	ld ixl,a	;lifCustom 


ei
ret

CustomMovePatternKill:
	;ex af,af'
	;xor a
	
	ld b,0
	ld c,b
	ld D,b
	;ex af,af'
ret

CustomMovePattern_Init10:
	call CustomMovePattern_Init
	ld a,lifEnemy+10		;New Life
ret

CustomMovePattern_Init:

	xor a

	ld (ix+0),a
	ld (ix+1),a
	ld (ix+2),a
	ld (ix+3),a

	ld a,lifEnemy+6			;New Life

ret



CustomMovePatternGeneric: 

	ld a,(ix+0)
	inc a
	ld (ix+0),a	
ret





limit &3fff
org &3ff0
jp LevelInit; - Level Start &3ff0
jp LevelLoop; - Level loop &3ff3
jp null     ; - Level resume &3ff6
jp null     ; - Level Shutdown &3ff9




limit &FFFF


save direct "T20-SC1.D01",&2800,&1800	;address,size...}[,exec_address]



;Time,type,Sprite,XY (16 px precision)

; Types:
;type XXXX----
;     00000000 A X Y = (0)  add one object A=sprnum, X , Y
;     00000001 Y    	Add one sprite to pos Y Far right (Same sprite as last time
;     0000yyyy A	2-13 add one 24 pixel object far right X=160+24 Y*16 -8 (Same sprite as last time
;     0001xxxx A B = (16) add  xxxx objects
;     0010xxxx X B = (32) add  xxxx objects all on column X
;     0011xxxx X Y S = (48) add  xxxx objects all on column X, Ypos Spaced S apart vertically
;     0100xxxx X Y   = (64) add stars to X,Y (pattern xxxx)
;     0101       Unused
;     0110       Unused
;     0111xxxx  = (112) Read Multiple events at the same time point

;     10000000 M L = (128) Change object movement to M, Life to L
;     10000001 P = (129) Change object Program
;     10000010 L = (130) Change object Life
;     10000011 M = (131) Change object Move
;     10000100 P M L = (132) Change object Program Move and Life
;     10000101 S = (133) Change object Sprite (only works with 0000XXXX )
;     10000110 (134) Add Objects to Front of list first (Background)
;     10000111 (135) Add Objects to Back of list first (Foreground)
;     10001000 L H T (136) = Load HL as next event pointer, change time to T
;     10001001 L H   (137) = Call HL - (untested)
;     10001010 L H   (138) = Load last added object address to address HL
;     10011111 B = Save to bank B
;     1001XXXX 	Load object settings (Prog, Move,Life) from XXXX bank (0-14 - see above 15 is save command)
;		Use this function to create template enemy moves and background object types
;     1010       Unused
;     1011       Unused	
;     1100XXXX   Unused
;     1101XXXX   Unused
;     1110XXXX   Unused
;     1111XXXX   Reprogram memory chunk

;     1111XXXX   Reprogram memory chunk
;     11110000 O B	X X X  = (240) Reprogram palette (B no of Bytes, O = offset; X X X byte data)
;     11110001 O B	X X X  = (240) Reprogram Background (B no of Bytes (up to 41), O = offset; X X X byte data)
;     11110010 LH 	= when an object is shot jump to HL (Akuyou_Object_DecreaseLifeShot is true hitcounter)
;     11110011 1P2	= Scroll rate 1 before P then 2 (1 must be faster than 2)
;     11110100 LH	= Reprogram Custom Move1
;     11110101 LH	= Reprogram Custom Move2

; Life BPxxxxx 		B=hurt by bullets , P hurts player, xxxxxx = Life ... Life decreases either over time or due to hits %00000000 means an immortal object which will only dissapear if it goes ofscreen

;Domoves
;0MYYYXXX	; Linear move
;11ddXXXX	; Background (Slow) move
;100001XX	; Seek player 1 speed -----XX1
;1010DSPP	D = Depth bit, S= Speed, PP Position
