
read "CoreDefs.asm"




limit &E00	
org &50


;
;Rastercolor buffer - 80 bytes (&50
RasterColors_ColorArray1:
	defb 1
	defb 1
	defb 64+20,64+24,64+29,64+11	 :IlluminatedPaletteA_Plus2
RasterColors_ColorArray2:
	defb 1
	defb 1

	defb 64+20,64+12,64+13,64+11	:IlluminatedPaletteB_Plus2
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 12
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray3:
	defb 1
	defb 1
	defb 64+20,64+12,64+13,64+11 :IlluminatedPaletteC_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray4:
	defb 1
	defb 1 
	defb 64+20,64+31,64+14,64+11 :IlluminatedPaletteD_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11



align 256,&00
StarArraySize equ 255
StarArrayPointer: 	
defs StarArraySize*3,&00


ObjectArraySize equ 60
PlayerStarArraySize equ 36

align 256,&00
PlayerStarArrayPointer: 
defs 64,&00
ObjectArrayPointer:
defs 64,&00
align 256,&00
defs 255*5,&00

;defs ObjectArraySize*6,&00
;defs PlayerStarArraySize*3,&00

;align 256,&00

	

Event_SavedSettings:
defs 4*16,&00

CustomRam:
defs 32 ;  Pos-Tick-Pos-Tick ; enough memory for 16 enemies!






RasterColors_ColorArray1Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteAAlt_Plus2
RasterColors_ColorArray2Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteBAlt_Plus2
RasterColors_ColorArray3Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteCAlt_Plus2
RasterColors_ColorArray4Alt:
	defb 1
	defb 1 
	defb &54,&54,&54,&54		 :IlluminatedPaletteDAlt_Plus2

org &E00	
	; Placeholder for the SFX

org &1000
PlayerSprites:
;incbin "Sprites\PLAYER.SPR"


limit &4000
org &1D00
LevelSprites:
incbin "Sprites\LEVEL7.SPR"





limit &3ff0
org &3500


evtSettingsBank_Save equ %10010000+15
evtSettingsBank_Load equ %10010000+0
evtMultipleCommands equ %01110000


evtSetMoveLife     equ 128
evtSetProg	   equ 129
evtSetLife	   equ 130
evtSetMove	   equ 131
evtSetProgMoveLife equ 132
evtSetSprite	   equ 133
evtAddToForeground equ 135
evtAddToBackground equ 134
evtJumpToNewTime   equ 136
evtCallAddress	   equ 137
evtSaveLstObjToAdd equ 138
evtResetPowerup    equ 139
evtSetLevelSpeed   equ 140

evtReprogramPalette 	equ %11110000
evtReprogramBackground 	equ %11110001	
evtReprogramHitHandler 	equ %11110010		
evtReprogramParalax	equ %11110011		

evtReprogramCustomMove1 equ %11110100
evtReprogramCustomMove2 equ %11110101
evtReprogramCustomMove3 equ %11110111
evtReprogramCustomMove4 equ %11111000

evtReprogramCustomProg1 equ %11111001
evtReprogramCustomProg2 equ %11111010
evtReprogramCustomProg3 equ %11111011
evtReprogramCustomProg4 equ %11111100


evtReprogram_PowerupSprites equ %11110110
evtReprogramScrollDirection equ %11111101
evtReprogramObjectFullCustomMoves equ	%11111110

evtSingleSprite equ 0
evtTileSprite equ 48 ;     0011xxxx X Y S = (48) add  xxxx objects all on column X, Ypos Spaced S apart vertically

prgNothing	equ 0
prgSpecial	equ 2
prgBonus 	equ 3
prgMovePlayer	equ 4
prtSpriteAlt	equ 5
prgFireSnail	equ %10000000
prgFireSlow	equ %01100000
prgFireMid	equ %01000000
prgFireMid2	equ %11000000
prgFireFast	equ %00100000
prgFireHyper	equ %10100000
prgCustom1 	equ %11111100			;Custom 1
prgCustom2 	equ %11111101			;Custom 2
prgCustom3 	equ %11111110			;Custom 3
prgCustom4 	equ %11111111			;Custom 4


mveStatic 	equ &24
mveSeaker	equ %10000100
mveWave		equ %10100000
mveWaveSmall	equ %10010000
mveCustom1	equ %11110000
mveCustom2	equ %11100000
mveCustom3	equ %11010000
mveCustom4	equ %10110000

lifCustom       equ 255		; We use 63 as a marker for custom code's INIT - a real life will be set by the custom code
lifEnemy	equ %11000000	;HurtByBullets,Hurts Player
lifTimed	equ %00000000	;Doesnt hurt, dies automatically
lifDeadly	equ %01000000	;Deadly and cant be shot
TwoFrameSprite  equ 128




EventStreamArray:

;defb 1,128,&24,128+64+60		; Move Static


defb 0,evtResetPowerup
defb 0,evtReprogramScrollDirection,1

defb 0,evtReprogramHitHandler				;Install a custom hit handler
defw CustomObjectHitHandler

defb 0,evtReprogramObjectFullCustomMoves
defw CustomMoveHandler

defb 0,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		



; Define the background

defb 0
defb 240+1,0,12*2+1				; (Time,Cmd,Off,Bytes) Load 41 bytes into the background - 41 bytes is the limit
defb 0,0
defb 198,&A0	;1
defb 190,&50	;2
defb 176,&80	;3
defb 170,&20	;4
defb 166,&00	;5
defb 160,&00	;6
defb 36,&20	;7
defb 30,&80	;8
defb 26,&50	;9
defb 20,&A0	;10
defb 02,&F0	;11
defb 0

;We will use 4 Paralax layers
; ---------()- (sky)		%11001000
; ------------ (Far)		%11000100
; -----X---X-- (mid)		%11000010	Bank 1
; []=====[]=== (foreground) 	%11000001	Bank 0




defb 0,evtReprogram_PowerupSprites,128+44,128+43,128+42,128+41	; sprites drone,speed,power,coin

; Background L
defb 0,128+4,1,&25,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,%10010000+15,0				; Save Object settings to Bank 0

defb 0,128+4,1,%11000001,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,evtSettingsBank_Save,1				; Save Object settings to Bank 1


; KabiKami
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,PrgFireMid+12,mveCustom1,lifCustom; Program - Fire Left... Move - wave... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+0		
defb 	evtSettingsBank_Save,2

defb 0,evtReprogramCustomMove1
defw CustomMove1

;white spirit
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,PrgFireMid+12,mveCustom2+1,lifCustom; Program - Fire Left... Move - wave... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+30		
defb 	evtSettingsBank_Save,3

defb 0,evtReprogramCustomMove2
defw CustomMove2

;dark spirit
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,PrgFireMid+14,mveCustom3+2,lifCustom; Program - Fire Left... Move - wave... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+33		
defb 	evtSettingsBank_Save,4

defb 0,evtReprogramCustomMove3
defw CustomMove3


;DekaWooRei
defb 0,evtReprogramCustomMove4
defw CustomMove4



; Flamer
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireSlow+14,mveWave+%00000000,lifEnemy+10	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+32
defb 	evtSettingsBank_Save,5

; BlobberL
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireSlow+9,&23,lifEnemy+10	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+31
defb 	evtSettingsBank_Save,6

; BlobberR
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireSlow+10,&25,lifEnemy+10	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+40
defb 	evtSettingsBank_Save,7

; GhostMan
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireMid2+20,&2D,lifEnemy+8	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+27
defb 	evtSettingsBank_Save,8


; Jelly Fishy
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireFast+20,&1D,lifEnemy+15	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+39
defb 	evtSettingsBank_Save,9


; Fire!,Fly!
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireMid2+12,mveCustom1+2,lifCustom	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+15
defb 	evtSettingsBank_Save,10

; Lumipede
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgFireMid+3,&25,lifEnemy+5	; Program - Fire Left... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,TwoFrameSprite+35
defb 	evtSettingsBank_Save,11


;Stone Bottom
defb 0,evtMultipleCommands +7
defb 	evtSettingsBank_Load +1
defb 	evtSingleSprite,TwoFrameSprite+16 ,0+16+0,199-24	;16 - 17 - 18
defb 	evtSingleSprite,TwoFrameSprite+17 ,0+16+60,199-24	;16 - 17 - 18
defb 	evtSingleSprite,TwoFrameSprite+18 ,0+16+90,199-24	;16 - 17 - 18
defb 	evtSingleSprite,TwoFrameSprite+22 ,0+16+50,24+24	;20 - 22 - 23
defb 	evtSingleSprite,TwoFrameSprite+20 ,0+16+10,24+24	;20 - 22 - 23
defb 	evtSingleSprite,TwoFrameSprite+19 ,0+16+100,24+24	;20 - 22 - 23





;Palette Change
defb 1,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 0
	defb &54,&54,&44,&40

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 32			
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 0				
	defb &54,&54,&44,&40		

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 0				
	defb &54,&54,&44,&40			



;Torch
defb 2,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb 	evtSetProg,0
defb 	evtSingleSprite,TwoFrameSprite+14 ,0+16,24*3+7


;Phosphor Rock
;defb 2,evtMultipleCommands +2
;defb 	evtSettingsBank_Load +0
;defb 	evtSingleSprite,36 ,0+16,199


;	defb 5 
;	defb 136				; Jump to a different level point
;	defw EndOfLevel				; pointer
;	defb 150


;White Spirit
defb 3,evtMultipleCommands +2
defb 	evtSettingsBank_Load +3
defb 	evtSingleSprite,TwoFrameSprite+30 ,0+16,24*4-12



;Stone Bottom
defb 3,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,TwoFrameSprite+17 ,0+16,199	;16 - 17 - 18

; Powerup Drone
defb 5,evtMultipleCommands+2			; 2 commands at the same timepoint
defb 	evtSetProgMoveLife,3,&1C,64+63	; Program - Bitshift Sprite... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4
defb 	evtSingleSprite,TwoFrameSprite+44,20+24,199+24	; 	; Single Object sprite 11 (animated)
defb 15, evtSingleSprite,TwoFrameSprite+44,140+24,199+24	; 	; Single Object sprite 11 (animated)
;
defb 35, evtSingleSprite,TwoFrameSprite+42,80+24,199+24	; 	; Single Object sprite 11 (animated)



;Stone Top
defb 35,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,TwoFrameSprite+20 ,0+16,24	;20 - 22 - 23


;GhostMan Duo
defb 35,evtMultipleCommands +4
defb 	evtSettingsBank_Load +8
defb 	evtSingleSprite+2
defb 	evtSetMove,&1D
defb 	evtSingleSprite+13

; Powerup Rate
defb 45,evtMultipleCommands+2			; 2 commands at the same timepoint
defb 	evtSetProgMoveLife,3,&1C,64+63	; Program - Bitshift Sprite... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4
defb 	evtSingleSprite,TwoFrameSprite+43,20+24,199+24	; 	; Single Object sprite 11 (animated)
defb 55, evtSingleSprite,TwoFrameSprite+43,140+24,199+24	; 	; Single Object sprite 11 (animated)


;Stone Top
defb 55,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,TwoFrameSprite+22 ,0+16,24	;20 - 22 - 23



;Flamer
defb 55,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb 	evtSingleSprite,TwoFrameSprite+32 ,160+24,24*7

;BlobberR
defb 60,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb 	evtSingleSprite+3


;BlobberL
defb 65,evtMultipleCommands +5
defb 	evtSettingsBank_Load +6
defb 	evtSingleSprite,TwoFrameSprite+31 ,160+24,199-16
;rock Down
defb 	evtSettingsBank_Load +0
defb 	evtSetLife,lifEnemy+50
defb	evtTileSprite+5,0+16,24*1,24,5,6,7,8,9


;White Spirit
defb 70,evtMultipleCommands +2
defb 	evtSettingsBank_Load +3
defb 	evtSingleSprite,TwoFrameSprite+30 ,0+16,24*8-12



;Stone Bottom
defb 70,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,TwoFrameSprite+17 ,0+16,199	;16 - 17 - 18



;Flamer
defb 75,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb 	evtSingleSprite,TwoFrameSprite+32 ,160+24,24*7

;Dark Spirit
defb 80,evtMultipleCommands +2
defb 	evtSettingsBank_Load +4
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12


;DekaWooRei
defb 85,evtMultipleCommands +7
defb 	evtSettingsBank_Load +0
defb  evtSetProgMoveLife,prgFireMid+11,mveCustom4+3,LifCustom
;defb 	evtSetProg,prgFireMid+11
;defb 	evtSetMove,mveCustom4+3
;defb 	evtSetLife,LifCustom
defb 	evtSingleSprite,TwoFrameSprite+10 ,160+12,24*3
defb 	evtSingleSprite,TwoFrameSprite+12 ,160+12,24*4
defb 	evtSetProg,0
defb 	evtSingleSprite,TwoFrameSprite+11 ,160+12+12,24*3
defb 	evtSingleSprite,TwoFrameSprite+13 ,160+12+12,24*4


;BlobberL
defb 90,evtMultipleCommands +2
defb 	evtSettingsBank_Load +6
defb 	evtSingleSprite,TwoFrameSprite+31 ,160+24,199-16

;rock up
defb 95,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb 	evtSetLife,lifEnemy+50
defb	evtTileSprite+5,0+16,199-120+24,24,0,1,2,3,4

;BlobberR
defb 100,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb 	evtSingleSprite+3



;Stone Top Mid
defb 100,evtMultipleCommands +2
defb 	evtSettingsBank_Load +1
defb 	evtSingleSprite,TwoFrameSprite+20 ,0+16,24+24	;20 - 22 - 23




;Phosphor Rock
defb 100,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,36 ,0+16,199


;BlobberL
defb 110,evtMultipleCommands +2
defb 	evtSettingsBank_Load +6
defb 	evtSingleSprite,TwoFrameSprite+31 ,160+24,199-16

;BlobberR
defb 115,evtMultipleCommands +2
defb 	evtSettingsBank_Load +7
defb 	evtSingleSprite+3

;DekaWooRei
defb 115,evtMultipleCommands +7
defb 	evtSettingsBank_Load +0
defb  evtSetProgMoveLife,prgFireMid+11,mveCustom4+3,LifCustom
;defb 	evtSetProg,prgFireMid+11
;defb 	evtSetMove,mveCustom4+3
;defb 	evtSetLife,LifCustom
defb 	evtSingleSprite,TwoFrameSprite+10 ,160+12,24*3
defb 	evtSingleSprite,TwoFrameSprite+12 ,160+12,24*4
defb 	evtSetProg,0
defb 	evtSingleSprite,TwoFrameSprite+11 ,160+12+12,24*3
defb 	evtSingleSprite,TwoFrameSprite+13 ,160+12+12,24*4

;Lumipede
defb 120,evtMultipleCommands +4
defb 	evtSettingsBank_Load +11
defb 	evtSingleSprite,TwoFrameSprite+35 ,24-6,199-16
defb 	evtSetProg,prgFireMid+1
defb 	evtSingleSprite,TwoFrameSprite+34 ,24-12,199-16


;Stone Bottom Mid
defb 120,evtMultipleCommands +2
defb 	evtSettingsBank_Load +1
defb 	evtSingleSprite,TwoFrameSprite+17 ,0+16,199-24	;16 - 17 - 18

;Dark Spirit
defb 125,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb   evtSetMove,mveCustom3+5
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12


;Dark Spirit
defb 135,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb    evtSetMove,mveCustom3+6
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12


; Fire!,Fly!
defb 140,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb 	evtSingleSprite+5



;Dark Spirit
defb 145,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb   evtSetMove,mveCustom3+7
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12


;Dark Spirit
defb 155,evtMultipleCommands +2
defb 	evtSettingsBank_Load +4
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12



;Stone Top
defb 155,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,TwoFrameSprite+20 ,0+16,24	;20 - 22 - 23


;Lumipede
defb 160,evtMultipleCommands +4
defb 	evtSettingsBank_Load +11
defb 	evtSingleSprite,TwoFrameSprite+35 ,24-6,199-16
defb 	evtSetProg,prgFireMid+1
defb 	evtSingleSprite,TwoFrameSprite+34 ,24-12,199-16

;rock Down
defb 165,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb 	evtSetLife,lifEnemy+50
defb	evtTileSprite+5,0+16,24*1,24,5,6,7,8,9



;White Spirit
defb 170,evtMultipleCommands +2
defb 	evtSettingsBank_Load +3
defb 	evtSingleSprite,TwoFrameSprite+30 ,0+16,24*8-12


;Stone Bottom
defb 180,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,TwoFrameSprite+17 ,0+16,199	;16 - 17 - 18




;Lumipede
defb 180,evtMultipleCommands +4
defb 	evtSettingsBank_Load +11
defb 	evtSingleSprite,TwoFrameSprite+35 ,24-6,199-16
defb 	evtSetProg,prgFireMid+1
defb 	evtSingleSprite,TwoFrameSprite+34 ,24-12,199-16


; Fire!,Fly!
defb 185,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb 	evtSingleSprite+10


;GhostMan Duo
defb 190,evtMultipleCommands +4
defb 	evtSettingsBank_Load +8
defb 	evtSingleSprite+2
defb 	evtSetMove,&1D
defb 	evtSingleSprite+13


;rock up
defb 195,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb 	evtSetLife,lifEnemy+50
defb	evtTileSprite+5,0+16,199-120+24,24,0,1,2,3,4

;Water
defb 206,evtMultipleCommands +6
defb 	evtAddToBackground
defb 	evtSettingsBank_Load +0
defb 	evtTileSprite+4,16,24,48,38,38,38,38
defb 	evtTileSprite+4,16+6,24,48,38,38,38,38
defb 	evtTileSprite+4,16-6,24,48,38,38,38,38
defb	evtAddToForeground

;Jelly Fishy
defb 206,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb 	evtSingleSprite,TwoFrameSprite+39 ,16,199

;KabiKami
defb 210,evtMultipleCommands +3
defb 	evtSettingsBank_Load +2
defb 	evtSingleSprite,TwoFrameSprite+28 ,0+16,24*3+7
defb 	evtSetLife,lifEnemy+10
defb 211,evtSingleSprite,TwoFrameSprite+29 ,0+16,24*5+7
defb 212,evtSingleSprite,TwoFrameSprite+28 ,0+16,24*7+7


;Jelly Fishy
defb 218,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb 	evtSingleSprite,TwoFrameSprite+39 ,16+48,199

;White Spirit
defb 220,evtMultipleCommands +2
defb 	evtSettingsBank_Load +3
defb 	evtSingleSprite,TwoFrameSprite+30 ,0+16,24*8-12



;Stone Bottom Mid
defb 220,evtMultipleCommands +2
defb 	evtSettingsBank_Load +1
defb 	evtSingleSprite,TwoFrameSprite+17 ,0+16,199-24	;16 - 17 - 18


;Jelly Fishy
defb 230,evtMultipleCommands +3
defb 	evtSettingsBank_Load +9
defb    evtSetProg,prgFireFast+16
defb 	evtSingleSprite,TwoFrameSprite+39 ,16+96,199

; Fire!,Fly!
defb 235,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb 	evtSingleSprite+10


;Jelly Fishy
defb 242,evtMultipleCommands +3
defb 	evtSettingsBank_Load +9
defb    evtSetProg,prgFireFast+16
defb 	evtSingleSprite,TwoFrameSprite+39 ,16+144,199

;Stone Top Mid
defb 250,evtMultipleCommands +2
defb 	evtSettingsBank_Load +1
defb 	evtSingleSprite,TwoFrameSprite+20 ,0+16,24+24	;20 - 22 - 23


; Fire!,Fly!
defb 250,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb 	evtSingleSprite+7

; Fire!,Fly!
defb 1,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb 	evtSingleSprite+3
;evtAddToForeground equ 135
;evtAddToBackground equ 134


;rock Down
defb 1,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb 	evtSetLife,lifEnemy+50
defb	evtTileSprite+5,0+16,24*1,24,5,6,7,8,9




;Water
defb 6,evtMultipleCommands +6
defb 	evtAddToBackground
defb 	evtSettingsBank_Load +0
defb 	evtTileSprite+4,16,24,48,38,38,38,38
defb 	evtTileSprite+4,16+6,24,48,38,38,38,38
defb 	evtTileSprite+4,16-6,24,48,38,38,38,38
defb	evtAddToForeground




;Jelly Fishy
defb 6,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb 	evtSingleSprite,TwoFrameSprite+39 ,16,199


;rock up
defb 10,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb 	evtSetLife,lifEnemy+50
defb	evtTileSprite+5,0+16,199-120+24,24,0,1,2,3,4



; Fire!,Fly!
defb 10,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb 	evtSingleSprite+10

;White Spirit
defb 15,evtMultipleCommands +2
defb 	evtSettingsBank_Load +3
defb 	evtSingleSprite,TwoFrameSprite+30 ,0+16,24*8-12





;Jelly Fishy
defb 18,evtMultipleCommands +2
defb 	evtSettingsBank_Load +9
defb 	evtSingleSprite,TwoFrameSprite+39 ,16+48,199



;Stone Top
defb 25,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,TwoFrameSprite+19 ,0+16,24	;20 - 22 - 23

;GhostMan Duo
defb 25,evtMultipleCommands +4
defb 	evtSettingsBank_Load +8
defb 	evtSingleSprite+2
defb 	evtSetMove,&1D
defb 	evtSingleSprite+13

;Jelly Fishy
defb 30,evtMultipleCommands +3
defb 	evtSettingsBank_Load +9
defb    evtSetProg,prgFireFast+16
defb 	evtSingleSprite,TwoFrameSprite+39 ,16+96,199

;Flamer
defb 35,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb 	evtSingleSprite,TwoFrameSprite+32 ,160+24,24*5


;GhostMan Duo
defb 35,evtMultipleCommands +4
defb 	evtSettingsBank_Load +8
defb 	evtSingleSprite+2
defb 	evtSetMove,&1D
defb 	evtSingleSprite+13


;Stone Bottom
defb 35,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,TwoFrameSprite+18 ,0+16,199	;16 - 17 - 18

;Jelly Fishy
defb 42,evtMultipleCommands +3
defb 	evtSettingsBank_Load +9
defb    evtSetProg,prgFireFast+16
defb 	evtSingleSprite,TwoFrameSprite+39 ,16+144,199


;Dark Spirit
defb 50,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb   evtSetMove,mveCustom3+1
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12

;Dark Spirit
defb 60,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb   evtSetMove,mveCustom3+2
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12

;Flamer
defb 70,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb 	evtSingleSprite,TwoFrameSprite+32 ,160+24,24*3

; Fire!,Fly!
defb 70,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb 	evtSingleSprite+10

;Dark Spirit
defb 80,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb   evtSetMove,mveCustom3+3
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12


;Stone Top
defb 85,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,TwoFrameSprite+22 ,0+16,24	;20 - 22 - 19


;Dark Spirit
defb 90,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb   evtSetMove,mveCustom3+4
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12



;Stone Bottom Mid
defb 90,evtMultipleCommands +2
defb 	evtSettingsBank_Load +1
defb 	evtSingleSprite,TwoFrameSprite+16 ,0+16,199-24	;16 - 17 - 18


;Flamer
defb 100,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb 	evtSingleSprite,TwoFrameSprite+32 ,160+24,24*3

; Fire!,Fly!
defb 100,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb 	evtSingleSprite+4

;Dark Spirit
defb 105,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb   evtSetMove,mveCustom3+5
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12


;Stone Top Mid
defb 110,evtMultipleCommands +2
defb 	evtSettingsBank_Load +1
defb 	evtSingleSprite,TwoFrameSprite+20 ,0+16,24+24	;20 - 22 - 23


;DekaWooRei
defb 110,evtMultipleCommands +7
defb 	evtSettingsBank_Load +0
;defb 	evtSetProg,prgFireMid+11
;defb 	evtSetMove,mveCustom4+6
;defb 	evtSetLife,LifCustom
defb  evtSetProgMoveLife,prgFireMid+11,mveCustom4+6,LifCustom
defb 	evtSingleSprite,TwoFrameSprite+10 ,160+12,24*2
defb 	evtSingleSprite,TwoFrameSprite+12 ,160+12,24*3
defb 	evtSetProg,0
defb 	evtSingleSprite,TwoFrameSprite+11 ,160+12+12,24*2
defb 	evtSingleSprite,TwoFrameSprite+13 ,160+12+12,24*3

;DekaWooRei
defb 110,evtMultipleCommands +7
defb 	evtSettingsBank_Load +0
;defb 	evtSetProg,prgFireMid+11
;defb 	evtSetMove,mveCustom4+7
;defb 	evtSetLife,LifCustom
defb  evtSetProgMoveLife,prgFireMid+11,mveCustom4+7,LifCustom
defb 	evtSingleSprite,TwoFrameSprite+10 ,160+12,24*6
defb 	evtSingleSprite,TwoFrameSprite+12 ,160+12,24*7
defb 	evtSetProg,0
defb 	evtSingleSprite,TwoFrameSprite+11 ,160+12+12,24*6
defb 	evtSingleSprite,TwoFrameSprite+13 ,160+12+12,24*7




;rock up
defb 110,evtMultipleCommands +4
defb 	evtSettingsBank_Load +0
defb EvtSetMove,&25
defb 	evtSetLife,lifEnemy+50
defb	evtTileSprite+5,0+16,199-120+24,24,0,1,2,3,4

;Dark Spirit
defb 115,evtMultipleCommands +3
defb 	evtSettingsBank_Load +4
defb   evtSetMove,mveCustom3+6
defb 	evtSingleSprite,TwoFrameSprite+33 ,0+24,24*7-12


;KabiKami
defb 116,evtMultipleCommands +3
defb 	evtSettingsBank_Load +2
defb 	evtSingleSprite,TwoFrameSprite+28 ,0+16,24*3+7
defb 	evtSetLife,lifEnemy+10
defb 117,evtSingleSprite,TwoFrameSprite+29 ,0+16,24*5+7
defb 118,evtSingleSprite,TwoFrameSprite+28 ,0+16,24*7+7


;rock Down
defb 120,evtMultipleCommands +4
defb 	evtSettingsBank_Load +0
defb EvtSetMove,&25
defb 	evtSetLife,lifEnemy+50
defb	evtTileSprite+5,0+16,24*1,24,5,6,7,8,9



;Flamer
defb 125,evtMultipleCommands +2
defb 	evtSettingsBank_Load +5
defb 	evtSingleSprite,TwoFrameSprite+32 ,160+24,24*3



;Stone Bottom
defb 125,evtMultipleCommands +2
defb 	evtSettingsBank_Load +0
defb 	evtSingleSprite,TwoFrameSprite+18 ,0+16,199	;16 - 17 - 18



;rock up
defb 130,evtMultipleCommands +4
defb 	evtSettingsBank_Load +0
defb EvtSetMove,&25
defb 	evtSetLife,lifEnemy+50
defb	evtTileSprite+5,0+16,199-120+24,24,0,1,2,3,4

; Fire!,Fly!
defb 135,evtMultipleCommands +2
defb 	evtSettingsBank_Load +10
defb 	evtSingleSprite+4




;rock Down
defb 140,evtMultipleCommands +4
defb 	evtSettingsBank_Load +0
defb EvtSetMove,&25
defb 	evtSetLife,lifEnemy+50
defb	evtTileSprite+5,0+16,24*1,24,5,6,7,8,9

defb 140,evtMultipleCommands +3
defb	evtTileSprite+2,199-24,24*1,24,26,24
defb	evtTileSprite+2,199-24,24*1,24,26,24
defb	evtTileSprite+2,199-24,24*1,24,26,24

EndOfLevel:

defb 150+8,evtMultipleCommands +3
defb 	evtSettingsBank_Load +1
defb  	evtSingleSprite,25,4,199
defb 	evtSetProg,0



defb 150+6+9,evtTileSprite+2,4,199-24,24,TwoFrameSprite+26,TwoFrameSprite+24

defb 150+6+9+6,evtTileSprite+2,4,199-24,24,TwoFrameSprite+26,TwoFrameSprite+24

defb 150+6+9+12,evtTileSprite+2,4,199-24,24,TwoFrameSprite+26,TwoFrameSprite+24



defb 150+6+9+18,evtTileSprite+2,4,199-24,24,TwoFrameSprite+26,TwoFrameSprite+24
defb 150+6+9+24,evtTileSprite+2,4,199-24,24,TwoFrameSprite+26,TwoFrameSprite+24
;defb 15,evtTileSprite+2,16,199-24,24,26,24

;defb 18,evtTileSprite+2,16,199-24,24,26,24
defb 150+6+9+30,evtMultipleCommands +2
defb 	evtSettingsBank_Load +1
defb 	evtSingleSprite,23,4,199

;Torch
defb	150+58,evtMultipleCommands +3
defb 	evtSettingsBank_Load +0
defb 	evtSetProg,0
defb 	evtSingleSprite,TwoFrameSprite+14 ,0+16,24*3+7


defb 150+68,%01110000+2			; 3 commands at the same timepoint
defb evtSetProgMoveLife,prgMovePlayer,&24,10
defb 	0,21,80+24,190	; 	; Single Object sprite 11 (animated)




LevelEndAnim:
defb 150+70,%01110000+2			; 3 commands at the same timepoint
defb evtSetProgMoveLife,prgMovePlayer,&24,10
defb 	0,128+	20,140+24,100+24	; 	; Single Object sprite 11 (animated)

defb 150+70,%10001001			;Call a memory location
defw	ClearBadguys
;Palette Change
defb 150+72,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40	





defb 150+73,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

defb 150+73,evtCallAddress			;Call a memory location
defw	EndLevel

;Illuminate

;Palette Change
;defb 2,%01110000+5			; 4 Commands
;	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
;	defb 1
;	defb 1				
;	defb &54,&40,&4C,&4B	IlluminatedPaletteA_Plus2

;	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
;	defb 1
;	defb 1				
;	defb &54,&40,&4C,&4B	IlluminatedPaletteB_Plus2

;	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
;	defb 0
;	defb 1				
;	defb &54,&40,&4C,&4B	IlluminatedPaletteC_Plus2	

;	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
;	defb 1
;	defb 1				
;	defb &54,&40,&4C,&4B	IlluminatedPaletteD_Plus2

;defb 	evtJumpToNewTime
;defw 	&6969		EndIlluminatePointer_Plus2	; pointer
;defb	 &69		EndIlluminateTime_Plus1	; new time




EndLevel:
	pop hl	;
	ld hl,	&0108 				
	jp	Akuyou_ExecuteBootStrap	; Start the game, no return


ClearBadguys:
	ld a,1
	ld i,a
	push hl
	call Akuyou_DoSmartBombCall
	pop hl
ret
LightingChange:
	ld (lightingLast_Plus1-1),a
	or a
	jr z,LightingChange_Dark


	cp 1
	jr z,LightingChange_Red
	cp 2
	jr z,LightingChange_Green
	cp 3
	jr z,LightingChange_Blue
;LightingChange_Action
	;call Akuyou_GetLevelTime

	;ld (EndIlluminatePointer_Plus2-2),hl
	;ld (EndIlluminateTime_Plus1-1),a
	;ld hl,Illuminate
	;ld a,1
	;jp Akuyou_SetLevelTime
LightingChange_Red:


	call EnableRasterColorFlash

	ld h,&4E
	call LightingChange_AltGrey

	ld a,&43	;white
	ld hl,&4E5C
	ld (IlluminatedPaletteA_Plus2-3),hl
	ld a,&43	;white
	ld hl,&4E4C	;high,low
	ld (IlluminatedPaletteB_Plus2-3),hl
	ld (IlluminatedPaletteC_Plus2-3),hl
	jr LightingChange_Part

LightingChange_Green:

	call EnableRasterColorFlash

	ld h,&53
	call LightingChange_AltGrey
	ld hl,&5956
	ld (IlluminatedPaletteA_Plus2-3),hl
	ld hl,&5A56
	ld (IlluminatedPaletteB_Plus2-3),hl
	ld a,&5B
	ld hl,&4246
	ld (IlluminatedPaletteC_Plus2-3),hl
	ld hl,&5246
	jr LightingChange_Part

EnableRasterColorFlash:
	push iy
	ld a,(iy-5)
	ld (PaletteNo_Plus1-1),a
	pop iy
ret
LightingChange_Blue:
	call EnableRasterColorFlash
	ld h,&57
	call LightingChange_AltGrey
	ld hl,&5F44
	ld (IlluminatedPaletteA_Plus2-3),hl
	ld hl,&5355
	ld (IlluminatedPaletteB_Plus2-3),hl
	ld a,&5B
	ld hl,&5B57
	ld (IlluminatedPaletteC_Plus2-3),hl
	jr LightingChange_Part

LightingChange_Dark:
	ld a,64
	ld(PaletteNo_Plus1-1),a
	ld hl,&4454
	ld a,&40
LightingChange_One:
	ld (IlluminatedPaletteA_Plus2-3),hl
	ld (IlluminatedPaletteB_Plus2-3),hl
	ld (IlluminatedPaletteC_Plus2-3),hl
LightingChange_Part:
	ld (IlluminatedPaletteD_Plus2-3),hl

	ld (IlluminatedPaletteA_Plus2-1),a
	ld (IlluminatedPaletteB_Plus2-1),a
	ld (IlluminatedPaletteC_Plus2-1),a
	ld (IlluminatedPaletteD_Plus2-1),a
ret;jr LightingChange_Action

LightingChange_AltGrey:
	ld l,&40
	ld (IlluminatedPaletteAAlt_Plus2-3),hl
	ld (IlluminatedPaletteBAlt_Plus2-3),hl
	ld (IlluminatedPaletteCAlt_Plus2-3),hl
	ld (IlluminatedPaletteDAlt_Plus2-3),hl
	ld a,&4B
	ld (IlluminatedPaletteAAlt_Plus2-1),a
	ld (IlluminatedPaletteBAlt_Plus2-1),a
	ld (IlluminatedPaletteCAlt_Plus2-1),a
	ld (IlluminatedPaletteDAlt_Plus2-1),a
ret

RasterColorsSetPalette1:
	ld a,1
	ld bc,RasterColors_ColorArray1
	ld de,RasterColors_ColorArray2
	ld hl,RasterColors_ColorArray3
	ld ix,RasterColors_ColorArray4
	ld iy,PaletteSwitcher :DisablePaletteSwitcher_Plus2
jp Akuyou_RasterColors_SetPointers

PaletteSwitcher:
	ld a,64:PaletteNo_Plus1
	cpl	
	ld (PaletteNo_Plus1-1),a
	or a
	jp nz,RasterColorsSetPalette1
RasterColorsSetPalette2:
	ld a,1
	ld bc,RasterColors_ColorArray1Alt
	ld de,RasterColors_ColorArray2Alt
	ld hl,RasterColors_ColorArray3Alt
	ld ix,RasterColors_ColorArray4Alt
	ld iy,PaletteSwitcher
jp Akuyou_RasterColors_SetPointers



LevelInit:

	; wipe our memory, to clear out any junk from old levels
	ld de,&51
	ld hl,&50
	ld bc,&5FF
	ld (hl),0
	ldir 

	;Fix up the Alt Palette
	ld hl,&0001
	ld (RasterColors_ColorArray1Alt),hl
	ld (RasterColors_ColorArray2Alt),hl
	ld (RasterColors_ColorArray3Alt),hl
	ld (RasterColors_ColorArray4Alt),hl

	call AkuYou_Player_GetPlayerVars
	ld a,(iy-5)
	ld (PaletteNo_Plus1-1),a
	ld hl,null
	cp 64
	jp nz,LevelInitUsingRasterFlip
	ld (DisablePaletteSwitcher_Plus2-2),hl


LevelInitUsingRasterFlip:
	call RasterColorsSetPalette1

	ld a, StarArraySize
	ld hl,StarArrayPointer
	call AkuYou_StarArrayInit_Enemy 

	ld a, PlayerStarArraySize
	ld hl,PlayerStarArrayPointer
	call AkuYou_StarArrayInit_Player 

	ld a,ObjectArraySize
	ld hl,ObjectArrayPointer
	call AkuYou_ObjectArray_Init

	ld hl,EventStreamArray		;Event Stream
	ld de,Event_SavedSettings	;Saved Settings
	call AkuYou_Event_StreamInit

	ld hl,LevelSprites		
	ld de,PlayerSprites
	call AkuYou_SpritePointerInit

	call AkuYou_Player_GetPlayerVars
	ld a,&98
	ld (iy+1),a
	call Akuyou_Music_Restart

	call Akuyou_ScreenBuffer_Init
	call Akuyou_RasterColors_Init

	;call RasterColors_Reset
LevelLoop:
	ld a,0
	ld (Lighting_Plus1-1),a


	;ld a,128+0
	;ld hl,(BossObject1)
	;call SetSprite

	call Akuyou_Background_Clear
	;ld l,&08
	;call Timer_Stop
	;ld l,&09
	;call Timer_Stop
	;ld a,"B"
	;call &bb5a 


	call Akuyou_EventStream_Process
	;ld l,&0a
	;call Timer_Stop
	;ld a,"S"
	;call &bb5a 


	call Akuyou_ObjectArray_Redraw
	;ld l,&0b
	;call Timer_Stop
	;ld a,"O"
	;call &bb5a 

	call Akuyou_Player_Handler
	;ld l,&0c
	;call Timer_Stop
	;ld a,"P"
	;call &bb5a 



	call Akuyou_StarArray_Redraw
	;ld l,&0d
	;call Timer_Stop
	;ld a,"S"
	;call &bb5a 


	call AkuYou_Player_StarArray_Redraw
	;ld l,&0e
	;call Timer_Stop
	;ld a,"F"
	;call &bb5a 


	call AkuYou_Player_DrawUI

	call Akuyou_PlaySfx
	
	ifdef debug
		call ShowLevelTime
	endif
	call Akuyou_ScreenBuffer_Flip


	ld a,&00 :Lighting_Plus1
	ld b,&00 :lightingLast_Plus1
	cp b
	call nz,LightingChange

	jp LevelLoop

LevelShutdown:

ret


ShowLevelTime:
	;ld hl,&C000
	;call Akuyou_ShowSprite_SetBankAddr
	call Akuyou_SpriteBank_Font

	ld hl,&1001
	call Akuyou_DrawText_LocateSprite

	call Akuyou_GetLevelTime
	push bc	
	call ShowHex
	pop bc
	ld a,b
	call ShowHex
ret


ShowHex:

	push af         ;store original byte value
	rrca            
	rrca
	rrca
	rrca
	call ShowHexDigit
	pop af          ;retrieve original byte value

ShowHexDigit:
;	and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
;	add a,"0"       ;add ASCII for 0. Digits 0...9 become "0"..."9", digits 10..15
;	cp "9"+1        
;	jr c,ShowHexDigitNum     ;if number is in digit range 0...9, display digit
;	add a,"A"-"9"-1 ;modify ASCII value so that digits in the range 10...15
and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
cp &a           ;Less than 10?  Set carry if so
sbc a,&69
daa             ;Because previous instruction was a subtract operation this
                ;is known as 'das' in x86
ShowHexDigitNum:
	jp Akuyou_DrawText_CharSprite   ;display digit

CustomMoveHandler:
	ld a,iyh 
	cp 128+39
	jr z,LightUV
	cp 128+32
	jr z,LightFire
	cp TwoFrameSprite+14
	jr z,LightFire
	cp 36
	jr z,LightPhosphor
	cp 37
	jr z,LightPhosphor
	cp 128+35
	jr z,LightPhosphor
	cp 128+34
	jr z,LightPhosphor
	cp 128+15
	jr z,LightPhosphor

jp Akuyou_DoMoves

LightFire:
	ld a,1
LightUpdate:
	ld (Lighting_Plus1-1),a
jp Akuyou_DoMoves

LightPhosphor:
	ld a,2
;	ld (Lighting_Plus1-1),a
;jp Akuyou_DoMoves
jr LightUpdate

LightUV:
	ld a,3
jr LightUpdate
;	ld (Lighting_Plus1-1),a
;jp Akuyou_DoMoves

CustomObjectHitHandler:

	ld a,ixh
	and %11110000
	cp mveCustom4
	jr nz,CustomObjectHitHandler_Finish	; if this object isn't the boss target, just run the normal routine
	

	ld a,ixl
	cp lifEnemy+3
	jp nc,CustomObjectHitHandler_Finish
	ld a,ixh
	di 
	exx
	push ix
		call GetCustomRam
		xor a
		ld (ix+3),a
	pop ix
	exx
	ld a,1
	ld ixl,a
	ei
CustomObjectHitHandler_Finish:
	jp Akuyou_Object_DecreaseLifeShot



CustomMove1:
	di
	exx
	ld hl,CustomMovePatternGeneric
	ld de,CustomMovePatternWaveb
	ld bc,CustomMovePattern_Init10

jr CustomMovePattern



CustomMove4:
	di
	exx
	ld hl,CustomMovePatternGeneric
	ld de,CustomMovePatternLifeLinkB
	ld bc,CustomMovePattern_InitLifeLink

jr CustomMovePattern

CustomMove2:
	di
	exx
	ld hl,CustomMovePatternGeneric
	ld de,CustomMovePatternCircleb
	ld bc,CustomMovePattern_Init10
jr CustomMovePattern
CustomMove3:
	di
	exx
	ld hl,CustomMovePatternGeneric
	ld de,CustomMovePatternCircleInfiniteb
	ld bc,CustomMovePattern_Init10

jr CustomMovePattern

GetCustomRam:
	and %00001111
		ld hl,CustomRam
			
			ld d,0
			ld e,a
			add hl,de
			add hl,de
			add hl,de
			add hl,de
		push hl
		pop ix
ret

CustomMovePattern:		; B=X C=Y D=Move
	ld (CustomPatternJump_Plus2-2),hl
	ld (CustomPatternbJump_Plus2-2),de
	ld (CustomMovePattern_Init_Plus2-2),bc
	exx



;		ld a,iyl ; Program Code
;		ld a,ixl ;Life  - MOVED INTO af'
;		ld a,iyh ;spr
;		ld (hl),ixh ;Move
;		ld (hl),b ;X
;		ld (hl),c ;Y

		

	ld a,ixl	;lifCustom 
	ex af,af'

	ld a,d
	exx
	push ix


		call GetCustomRam

		call Akuyou_Timer_GetTimer
		ld d,a
		ld a,i	; Level time
		ld e,a


		;dont update more than once per tick! 
		ld a,(ix+1)
		cp e
		jr z,CustomMovePattern_NoTick	
		ld a,e
		ld (ix+1),e

		;see if this is our first run
		ex af,af'
			cp 250
			call nc,CustomMovePattern_Init :CustomMovePattern_Init_Plus2
		ex af,af'


		; here is where we make some moves!
		exx
		call CustomMovePatternGeneric :CustomPatternJump_Plus2
		exx
		;increment the pos
	

CustomMovePattern_NoTick:
		
		; here is where we make some moves!
		exx
		call null :CustomPatternbJump_Plus2


		ld a,b
		cp 160+24
		call NC,CustomMovePatternKill
		exx
		;increment the pos
	


	;	jp CustomMovePattern_Done

CustomMovePattern_Done:


	ld a,iyl
	cp prgSpecial
	jr nz,CustomMovePattern_NotBossTarget
	ld a,0:TargetSpritecountdown_Plus1
	or a
	jr z,CustomMovePattern_TargetReset
	dec a
	ld (TargetSpritecountdown_Plus1-1),a
CustomMovePattern_TargetSet:
	ld a,128+9	:HitTargetSprite_Plus1
	ld iyh,a
	jr CustomMovePattern_NotBossTarget
CustomMovePattern_TargetReset:
	ld a,128+8 	:ResetTargetSprite_Plus1
	ld iyh,a
CustomMovePattern_NotBossTarget:
	pop ix
	exx

	ex af,af'

	ld ixl,a	;lifCustom 


ei
ret

CustomMovePattern_InitImmortal:
	call CustomMovePattern_Init
	ld a,0		;New Life
ret
CustomMovePattern_InitInvincible:
	call CustomMovePattern_Init
	ld a,lifDeadly+63		;New Life

ret

CustomMovePattern_Init10:
	call CustomMovePattern_Init
	ld a,lifEnemy+10		;New Life
ret

CustomMovePattern_InitLifeLink:
	call CustomMovePattern_Init
	ld a,lifEnemy+40		;New Life
	ld (ix+3),a
ret

CustomMovePattern_Init:

	xor a
	;exx
	;B=X
	;C=Y
	;exx

	ld (ix+0),a
	ld (ix+1),a
	ld (ix+2),a
	ld (ix+3),a

	ld a,lifEnemy+6			;New Life

ret



CustomMovePatternGeneric: 

	ld a,(ix+0)
	inc a
	ld (ix+0),a	
ret



CustomMovePatternLifeLinkB:
	ld a,(ix+3)
	and %00111111
	jp z,CustomMovePatternKill

	ld a,(ix+3)
	exx
	ld b,a
	ex af,af'

	cp b
	jr nc,CustomMovePatternLifeLinkGreater
	ld (ix+3),a
	jr CustomMovePatternLifeLinkDone	
CustomMovePatternLifeLinkGreater:
	ld a,b
;	ld (ix+3),a
CustomMovePatternLifeLinkDone:
	ex af,af'
	exx
	dec B
ret

CustomMovePatternWaveB:
	ld a,(ix+0)

	and %00111111
CustomMovePatternWaveContinue
		
	cp 32
	jr C,CustomMovePatternWaveLeft

	inc c
	jr CustomMovePatternWaveDone

CustomMovePatternWaveLeft:
	dec c
	jr CustomMovePatternWaveDone

CustomMovePatternWaveDone:	
	inc b	;
ret

CustomMovePatternKill:
	;ex af,af'
	;xor a
	
	ld b,0
	ld c,b
	ld D,b
	;ex af,af'
ret

;CustomMovePatternCircle: ;
;
;	ld a,(ix+0)
;	inc a
;	ld (ix+0),a	
;ret

CustomMovePatternCircleb:
	;ld a,(ix+2)
	;or a
	;jr nz,CustomMovePatternCirclebMoveLeftDone

	call Akuyou_Timer_GetTimer
	bit 2,a
	jr z,CustomMovePatternCirclebMoveLeftDone

	inc b
	;ld a,(ix+0)
	;cp 192
	;jr nz,CustomMovePatternCirclebMoveLeftDone
	;ld a,1
	;ld (ix+2),a

CustomMovePatternCirclebMoveLeftDone:
	ld a,(ix+0)
	cpl
	;and %11110000
	and %00111100
	rrca
	rrca
	jr CustomMovePatternCircleProcess




CustomMovePatternCircleInfiniteb:
	ld a,(ix+2)

	or a
	jr nz,CustomMovePatternCircleInfinitebMoveLeftDone

	call Akuyou_Timer_GetTimer
	bit 2,a
	jr z,CustomMovePatternCircleInfinitebMoveLeftDone

	inc b
	ld a,(ix+0)
	cp 128
	jr NC,CustomMovePatternCircleInfinitebMoveLeftDone
	ld a,1
	ld (ix+2),a

CustomMovePatternCircleInfinitebMoveLeftDone:
	ld a,(ix+0)
	cpl
	and %01111000
	rrca
	rrca
	rrca
	jr CustomMovePatternCircleProcess




CustomMovePatternCircleProcess:
	exx
	;push bc
	;push hl
		ld hl,CustomMovePatternVector
		ld b,0
		ld c,a
		add hl,bc	;add twice for a two byte address
		add hl,bc
		ld a,(hl)		; read the two bytes in		
		inc hl
		ld h,(hl)
		ld l,a		; hl now is the memory loc of the line
		ld (CircleJump_Plus2-2),hl
	;pop hl
	;pop bc
	exx
	jp CustomMovePatternCircle1:CircleJump_Plus2


CustomMovePatternVector:
defw CustomMovePatternCircle1
defw CustomMovePatternCircle2
defw CustomMovePatternCircle3
defw CustomMovePatternCircle4
defw CustomMovePatternCircle5
defw CustomMovePatternCircle6
defw CustomMovePatternCircle7
defw CustomMovePatternCircle8
defw CustomMovePatternCircle9
defw CustomMovePatternCircle10
defw CustomMovePatternCircle11
defw CustomMovePatternCircle12
defw CustomMovePatternCircle13
defw CustomMovePatternCircle14
defw CustomMovePatternCircle15
defw CustomMovePatternCircle16

CustomMovePatternCircle1:	
	
	dec c	
	dec c
	
CustomMovePatternCircle2:	

	dec c	
	dec c	

CustomMovePatternCircle3:	
	dec b	
	dec b
	jr CustomMovePatternCircleDone

CustomMovePatternCircle5:	

	inc c
	inc c

CustomMovePatternCircle4:	
	dec b	
	dec b
	inc c
	inc c
	jr CustomMovePatternCircleDone
CustomMovePatternCircle6:	
	dec b	

CustomMovePatternCircle7:
	inc c
	inc c	

	inc c	
	inc c
	jr CustomMovePatternCircleDone
CustomMovePatternCircle8:
	inc b
	inc c	
	inc c

	inc c	
	inc c
	jr CustomMovePatternCircleDone
CustomMovePatternCircle9:	

	inc c	
	inc c

CustomMovePatternCircle10:	
	inc b
	inc b	
	inc c	
	inc c	
	jr CustomMovePatternCircleDone


CustomMovePatternCircle13:	
	dec c	
	dec c	
CustomMovePatternCircle12:	

	dec c
	dec c	
CustomMovePatternCircle11:	
	inc b
	inc b	
	jr CustomMovePatternCircleDone
CustomMovePatternCircle14:	
	inc b	
CustomMovePatternCircle15:	
	dec c	
	dec c	
	dec c	
	dec c	
	jr CustomMovePatternCircleDone
CustomMovePatternCircle16:	
	dec b
	dec c	
	dec c	
	dec c	
	dec c	
	jr CustomMovePatternCircleDone

CustomMovePatternCircleDone:
;	ld a,b
;	cp 160+24
;	jp NC,CustomMovePatternKill
ret



CustomProgram1:
	call Akuyou_Timer_GetTimer
	ld a,i	; Level time
	and %00000011
	;rrca
	add 16
	ld iyl,a		; Program Fire
	push bc
	push de
	push iy
	call Akuyou_FireStar
	pop iy
	pop de
	pop bc


	ld a,iyl
	add 4
	ld iyl,a
	jp Akuyou_FireStar


CustomProgram2:
	call Akuyou_Timer_GetTimer
	ld a,i	; Level time
	bit 0,a
	jr z,CustomProgram2_Fire2

	ld a,17
	ld iyl,a
	jp Akuyou_FireStar

CustomProgram2_Fire2:
	ld a,23
	ld iyl,a
	jp Akuyou_FireStar




null:ret

limit &3fff
org &3ff0
jp LevelInit; - Level Start &3ff0
jp LevelLoop; - Level loop &3ff3
jp null     ; - Level resume &3ff6
jp null     ; - Level Shutdown &3ff9


save direct "T20-SC1.D02",&1D00,&2300	;address,size...}[,exec_address]



