


read "CoreDefs.asm"
limit &E00	
org &50


;
;Rastercolor buffer - 80 bytes (&50
RasterColors_ColorArray1:
	defb 1
	defb 1
	defb 64+20,64+24,64+29,64+11	 :IlluminatedPaletteA_Plus2
RasterColors_ColorArray2:
	defb 1
	defb 1

	defb 64+20,64+12,64+13,64+11	:IlluminatedPaletteB_Plus2
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 12
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray3:
	defb 1
	defb 1
	defb 64+20,64+12,64+13,64+11 :IlluminatedPaletteC_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray4:
	defb 1
	defb 1 
	defb 64+20,64+31,64+14,64+11 :IlluminatedPaletteD_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11



align 256,&00
StarArraySize equ 32*3
StarArrayPointer: 	
defs 255*3,&00


ObjectArraySize equ 24
PlayerStarArraySize equ 36

align 256,&00
PlayerStarArrayPointer: 
defs 64,&00
ObjectArrayPointer:
defs 64,&00
align 256,&00
defs 255*5,&00

;defs ObjectArraySize*6,&00
;defs PlayerStarArraySize*3,&00

;align 256,&00

	

Event_SavedSettings:
defs 4*16,&00

CustomRam:
defs 32 ;  Pos-Tick-Pos-Tick ; enough memory for 16 enemies!






RasterColors_ColorArray1Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteAAlt_Plus2
RasterColors_ColorArray2Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteBAlt_Plus2
RasterColors_ColorArray3Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteCAlt_Plus2
RasterColors_ColorArray4Alt:
	defb 1
	defb 1 
	defb &54,&54,&54,&54		 :IlluminatedPaletteDAlt_Plus2

org &E00	
	; Placeholder for the SFX

limit &4000
org &1000
PlayerSprites:
;incbin "Sprites\PLAYER.SPR"

org &1800
align 256,&00
OmegaArraySize equ 256
OmegaArrayPointer1: 	
defs OmegaArraySize*3,&0
OmegaArrayPointer2: 	
defs OmegaArraySize*3,&0
OmegaArrayPointer3: 	
defs OmegaArraySize*3,&0
OmegaArrayPointer4: 	
defs OmegaArraySize*3,&0

limit &FFFF
org &3000
LevelSprites:
;incbin "Sprites\LEVEL7.SPR"
incbin "Sprites\LEVEL9.SPR" ;uses up to &2700
limit &3ff0
org &3400


Background_0:
	ld de,0000
Background_0B:
	jp z,NoSmartBomb	; a=smartbombtime after timer update call
	ld d,ixl
	ld e,d
NoSmartBomb:

	call Akuyou_ScreenBuffer_GetActiveScreen
	di
	add &40
	ld h,a
	ld l,0
	ld b,256

SpFill:
	ld (SpRestoreFill_Plus2-2),sp

SpFillContinue:
	ld sp,hl
	ld hl,retpoint

	jp PushDe32
retpoint:
	ld hl,&0000
	add hl,sp
	ei
	ld sp,&0000:SpRestoreFill_Plus2
	di


	djnz SpFillContinue
	ei

	ret


BossColor0:
	ld de,&FFFF
	ld bc,&0000
ret
BossColor1:
	ld de,&0F0F
	ld bc,&FFFF
ret
BossColor2:
	ld de,&F0F0
	ld bc,&0F0F
ret
BossColor3:
	ld de,&0000
	ld bc,&F0F0
ret
BossLifeBarInit:
	ld (barinitcount_Plus1-1),a
	ld de,&0000
	ld bc,&FFFF
	jr BossLifeBarDisplay
BossLifeBar:
	di


	call Akuyou_ScreenBuffer_GetActiveScreen
	ld hl,&2780 +72
	add h
	ld h,a
	ld ixl,4

	ld a,0:barinitcount_Plus1
	inc a
	cp 32
	jr c,BossLifeBarInit




	ld a,(BossLife)

	and %01100000
	cp  %01100000
	call z,BossColor0
	cp  %01000000
	call z,BossColor1
	cp  %00100000
	call z,BossColor2
	cp  %00000000
	call z,BossColor3


	ld a,(BossLife)
	and %00011111

BossLifeBarDisplay:

	ld (BarFull_Plus2-2),bc
	ld (BarEmpty_Plus2-2),de


	ld b,a
	ld a,32
	sub b
	ld c,a

BossLifeBarLineLoop:	

	push hl
		di
		ld (SpRestoreFillB_Plus2-2),sp
		ld sp,hl
		
		ld a, b
		cp 32
		jp z,BossLifeBarContinue


		ld de,pushde32
		ld a,e
		add b
		ld e,a

		push de
	
			ld de,&0F0F	:BarEmpty_Plus2
			ld hl,BossLifeBarContinue

		ret	;effectively call the pushed DE
BossLifeBarContinue:
		ld a, c
		cp 32
		jp z,BossLifeBarContinueB

		ld de,pushde32
		ld a,e
		add c
		ld e,a

		push de
	
			ld de,&F0F0 	:BarFull_Plus2
			ld hl,BossLifeBarContinueB

		ret	;effectively call the pushed DE

BossLifeBarContinueB:
		ei
		ld sp,&0000:SpRestoreFillB_Plus2

	pop hl

	ld a,8
	add h
	ld h,a
	dec ixl
	jp nz, BossLifeBarLineLoop
ret
align 64,&00

pushde32:push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
jp (hl)

OmegaArray_EngageV2:

	ld b,OmegaArraySize
	ld de,&8000
	ld a,r
	ld e,a
OmegaArray_Engage_LoopV2:

	ld a,(hl)
	or a
	jp z,OmegaArray_EngageV2MoveNext
	and %00001111
	ld c,a

	ld a,(NextShot_Plus1-1)
	inc a 
	ld (NextShot_Plus1-1),a

	and %01110000
	or c

	ld (hl),a
OmegaArray_EngageV2MoveNext:
	inc l
	djnz OmegaArray_Engage_LoopV2

ret

OmegaArray_GetPointer:
	;000BBPPP
	ld e,a
	and %00011000
	cp  %00000000
	jp z,OmegaBank1
	cp  %00001000
	jp z,OmegaBank2
	cp  %00010000
	jp z,OmegaBank3
	cp  %00011000
	jp z,OmegaBank4
OmegaBank1:
	ld hl,OmegaArrayPointer1
	jr OmegaArray_GetPointer_Finish
OmegaBank2:
	ld hl,OmegaArrayPointer2
	jr OmegaArray_GetPointer_Finish
OmegaBank3:
	ld hl,OmegaArrayPointer3
	jr OmegaArray_GetPointer_Finish
OmegaBank4:
	ld hl,OmegaArrayPointer4
	jr OmegaArray_GetPointer_Finish
OmegaArray_GetPointer_Finish:
	ld a,e
	rrca
	rrca
	rrca
	ld e,a
	
 
	add hl,de
ret
OmegaArray_Engage:


	;ld de,&8000
	;ld a,r
	;ld e,a
OmegaArray_Engage_Loop:

	ld a,(hl)
	or a
	jp nz,OmegaArray_Engage_Loop_Skip
	;ld a,(de)
	;ld c,a
	;inc de
	;ld a,(de)
	;inc de
	;xor c
	
	ld a,&0 :NextShot_Plus1
	inc a 
	ld (NextShot_Plus1-1),a
	and %01111110
	inc a
	ld (hl),a
	;ld iyl,a



	;and %00001111
	;inc h
	;ld (hl),a
	inc h
	ld (hl),&80	:OmegaX_Plus1
	inc h
	ld (hl),&80	:OmegaY_Plus1
;	dec h
	dec h
	dec h
OmegaArray_Engage_Loop_Skip:
	inc l
	djnz OmegaArray_Engage_Loop

ret

OmegaArray_Redraw:

	ld a,(NextShot_Plus1-1)
	ld c,a
	ld a,r
	xor c 
	ld (NextShot_Plus1-1),a

call OmegaArray_Init

ld hl,OmegaArrayPointer1
call OmegaArray_RedrawChunk
ld hl,OmegaArrayPointer2
call OmegaArray_RedrawChunk
ld hl,OmegaArrayPointer3
call OmegaArray_RedrawChunk
ld hl,OmegaArrayPointer4
call OmegaArray_RedrawChunk
;call OmegaArray_RedrawChunk
;call OmegaArray_RedrawChunk


ret

OmegaArray_Init:
	call Akuyou_ScreenBuffer_GetActiveScreen 
	ld (GetMemPos_ScreenOffset_Plus1-1),a

	call Akuyou_Timer_GetTimer	;ld a,(Timer_TicksOccured)
	or a
	ret z	; see if game is paused (TicksOccurred = 0 )


	ld a,0:OmegaTick_Plus1
	inc a
	ld (OmegaTick_Plus1-1),a
	ld c,a

	and %00000001

	ld a,%00001111 ;basic move
	jr z,FrameDone
	;ld a,r
	;xor c
	;and %00010000
	;ld (StarLoopTimeSwitch_Plus1-1),a
	;ld a,&7E
	ld a,%01111111 ;advanced move
FrameDone:
	;ld (StarLoopAltMove_Plus1-1),a
ld (StarLoopTimeSwitch_Plus1-1),a
	
;	rrca
;	rrca
;	rrca

;	ld(TimeOffset_Plus1-1),a
;	inc a
;	ld (OmegaTick_Plus1-1),a
;	ld (OmegaTickB_Plus1-1),a
;	ld (OmegaTickB2_Plus1-1),a
	;xor b
	;ld (OmegaTickB_Plus1-1),a
	;Reset the star array to allow more stars to be added
	;ld a,0	
	;ld (StarArrayFullMarker_Plus1-1),a

	; Redraw the enemy star array

	;or B
	;ret z

	;configure the loop for the enemy star array
	ld hl,&0000

	call AkuYou_Player_GetPlayerVars
	;ld iy,Player_Array
	ld a,(iy+4)	;invincibility
	and %11100000	
	jp z,StarArray_PlayerVunrable

	; player invincible
	ld hl,&0818
	jr StarArray_PlayerInvincible
StarArray_PlayerVunrable:
	; load player 1 location

	ld a,(iy+1)
	dec a
	ld (Player1LocX_Plus1-1),a
	inc a
	inc a
	ld (Player1LocXB_Plus1-1),a

	ld a,(iy+0)
	dec a
	ld (Player1LocY_Plus1-1),a
	inc a
	inc a
	ld (Player1LocYB_Plus1-1),a

StarArray_PlayerInvincible:
	ld (CurrentStarArrayCollisions_Plus2-2),hl

	ld a,(OmegaTick_Plus1-1)
	and %00000111
	ret nz


	ld a,(OmegaTick_Plus1-1)
	and %00011000

	cp  %00011000
	jp z,OmegaArray_RedrawA
	cp  %00001000
	jp z,OmegaArray_RedrawB
	cp  %00010000
	jp z,OmegaArray_RedrawC
OmegaArray_RedrawD:
	ld hl,OmegaArrayPointer4
	jp OmegaArray_EngageV2
OmegaArray_RedrawA:
	ld hl,OmegaArrayPointer1
	jp OmegaArray_EngageV2
OmegaArray_RedrawB:
	ld hl,OmegaArrayPointer2
	jp OmegaArray_EngageV2
OmegaArray_RedrawC:
	ld hl,OmegaArrayPointer3
	jp OmegaArray_EngageV2

OmegaArray_RedrawChunk:

	ld bc,OmegaArraySize

	ld (SpRestore_Plus2-2),sp
	di
Starloop2:

	ld a,(hl)	; MX
	and 255 :StarLoopTimeSwitch_Plus1
	jr Z,StarArray_Turbo

	ld (Hlrestore_Plus2-2),hl
	inc h

	;ld a,(hl)StarLoopAltMove_Plus1
	;xor 0 
	ld (MovePointer_Plus2-2),a

	;inc h

	ld B,(hl) ; X
	inc h
	ld C,(hl) ; Y
	
Starloop_NotZero:
PlayerCollisions:

		ld a,c
		cp 0:Player1LocY_Plus1
		jp c,StarLoopP1Skip
		cp 0:Player1LocYB_Plus1
		jp nc,StarLoopP1Skip

		ld a,B
		cp 0:Player1LocX_Plus1
		jp c,StarLoopP1Skip
		cp 0:Player1LocXB_Plus1
		jp nc,StarLoopP1Skip


		nop
		nop :CurrentStarArrayCollisions_Plus2
		ld sp,(SpRestore_Plus2-2)
		call AkuYou_Player_Hit_Injure
		di		
StarLoopP1Skip:
StarCollisionsDone:

		ld de,(MoveArray1) :MovePointer_Plus2
;		pop de 
		ld (OmegaMoves),de

OmegaMoves:	nop
		nop

		;add c 
		ld (hl),c
		dec h
		ld (hl),b 

		bit 0,b
	ex af,af'
			;	call GetMemPos		

;GetMemPos:
		; Input  BC= XY (x=bytes - so 80 across)
		; output HL= screen mem pos
			ld h,0
			ld a,c
			sub 24	
			cp 199			;we are at the bottom of the screen
			jr NC,DoMoves_Kill	;over the page
			ld l,a
	
			add hl,hl 		; table is two bytes so double hl

			ld de,scr_addr_table	; get table
			add hl,de		;add line num
			ld sp,hl
			pop de
			pop hl			
			ld a,b	;get the X col
			sub 24
			cp 160			;we are at the bottom of the screen
			jr NC,DoMoves_Kill	;over the page
			srl a
			ld c,a

			ld b,0:GetMemPos_ScreenOffset_Plus1 ; screen offset

			add hl,bc  	; hl = memory line, bc = X pos = hl is now the location on screen
			ex de,hl

			add hl,bc  	; hl = memory line, bc = X pos = hl is now the location on screen
			;ret ;return memory location in hl
	
	ex af,af'
			;ld bc,&CC33
			jr z,Stars_DrawDot_B2

			ld a,(hl)	;7

			or &33;c;&33	;7	:Stars_Color1a_Plus1
			ld (hl),a

			ex de,hl

			;ld a,(hl)
			;and b;&CC
			;or c;&33		:Stars_Color1b_Plus1
			ld (hl),a

		jp StarArray_Next

Stars_DrawDot_B2:

			ld a,(hl)
			;and b;&33
			or &CC;c;&CC		:Stars_Color2a_Plus1
			ld (hl),a

			ex de,hl

			;ld a,(hl)
			;and b;&33	
			;or c;&CC		:Stars_Color2b_Plus1
			ld (hl),a

StarArray_Next:
	
	ei
	ld sp,&1234 :SpRestore_Plus2
	di

StarArray_Finish:
	ld hl,&0000 :Hlrestore_Plus2
StarArray_Turbo:
	inc l


	jp nz,starloop2

	ld sp,(SpRestore_Plus2-2)
	ei
	ret

DoMoves_Kill:
	ld hl,(Hlrestore_Plus2-2)
	xor a
	ld (hl),a ;MX

	jp StarArray_Turbo

align 256,&00
MoveArray1:
	nop ; Zero marks a dead command

	nop	;L
	dec b	;L

	dec c	;UL
	dec b	;DL

	dec c	;U
	nop	;U

	dec c	;UR
	inc b	;UR

	nop	;R
	inc b	;R

	inc c	;DR
	inc b	;DR 

	inc c	;D
	nop	;D

	inc c	;DL
	dec b	;DL

MoveArray4:


	inc c	;DL
	dec b	;DL
	
	nop	;L
	dec b	;L

	dec c	;UL
	dec b	;DL

	dec c	;U
	nop	;U

	dec c	;UR
	inc b	;UR

	nop	;R
	inc b	;R

	inc c	;DR
	inc b	;DR 

	inc c	;D
	nop	;D

;17 bytes later 1

MoveArray6:

	dec c	;UL
	dec b	;DL

	dec c	;U
	nop	;U

	dec c	;UR
	inc b	;UR

	nop	;R
	inc b	;R

	inc c	;DR
	inc b	;DR 

	inc c	;D
	nop	;D

	inc c	;DL
	dec b	;DL

	nop	;L
	dec b	;L

MoveArrayLR:


	dec b	;DL
	dec b	;DL

	defb &18,&3 ;u

	inc b	;UR
	inc b	;UR

	inc b	;R
	inc b	;R

	inc b	;DR 
	inc b	;DR 

	defb &18,&3 ;d

	dec b	;DL
	dec b	;DL

	dec b	;L
	dec b	;L
MoveArrayUD:



	dec c	;UL
	dec c	;UL

	dec c	;U
	dec c	;U

	dec c	;U
	dec c	;U

	defb &18,&3 ;R

	inc c	;DR
	inc c	;DR

	inc c	;D
	inc c	;D

	inc c	;DL
	inc c	;DL

	defb &18,&3 ;d
MoveArray2:
	;defb &18,&3
	;defb &18,&3
	;defb &18,&3
	;defb &18,&3
	;defb &18,&3
	;defb &18,&3
	;defb &18,&3
	;defb &18,&3

	nop	;L
	dec b	;L

	dec c	;UL
	dec b	;DL

	dec c	;U
	nop	;U

	dec c	;UR
	inc b	;UR

	nop	;R
	inc b	;R

	inc c	;DR
	inc b	;DR 

	inc c	;D
	nop	;D

	inc c	;DL
	dec b	;DL
MoveArray7:
	inc c	;DL
	dec b	;DL

	nop	;L
	dec b	;L

	dec c	;UL
	dec b	;DL

	dec c	;U
	nop	;U

	dec c	;UR
	inc b	;UR

	nop	;R
	inc b	;R

	inc c	;DR
	inc b	;DR 

	inc c	;D
	nop	;D

MoveArray8:

	dec c	;UL
	dec b	;DL

	dec c	;U
	nop	;U

	dec c	;UR
	inc b	;UR

	nop	;R
	inc b	;R

	inc c	;DR
	inc b	;DR 

	inc c	;D
	nop	;D

	inc c	;DL
	dec b	;DL

	nop	;L
	dec b	;L

scr_addr_table:

defb &00,&00,&00,&08,&00,&10,&00,&18,&00,&20,&00,&28,&00,&30,&00,&38;1
defb &50,&00,&50,&08,&50,&10,&50,&18,&50,&20,&50,&28,&50,&30,&50,&38;2
defb &A0,&00,&A0,&08,&A0,&10,&A0,&18,&A0,&20,&A0,&28,&A0,&30,&A0,&38;3
defb &F0,&00,&F0,&08,&F0,&10,&F0,&18,&F0,&20,&F0,&28,&F0,&30,&F0,&38;4
defb &40,&01,&40,&09,&40,&11,&40,&19,&40,&21,&40,&29,&40,&31,&40,&39;5
defb &90,&01,&90,&09,&90,&11,&90,&19,&90,&21,&90,&29,&90,&31,&90,&39;6
defb &E0,&01,&E0,&09,&E0,&11,&E0,&19,&E0,&21,&E0,&29,&E0,&31,&E0,&39;7
defb &30,&02,&30,&0A,&30,&12,&30,&1A,&30,&22,&30,&2A,&30,&32,&30,&3A;8
defb &80,&02,&80,&0A,&80,&12,&80,&1A,&80,&22,&80,&2A,&80,&32,&80,&3A;9
defb &D0,&02,&D0,&0A,&D0,&12,&D0,&1A,&D0,&22,&D0,&2A,&D0,&32,&D0,&3A;10
defb &20,&03,&20,&0B,&20,&13,&20,&1B,&20,&23,&20,&2B,&20,&33,&20,&3B;11
defb &70,&03,&70,&0B,&70,&13,&70,&1B,&70,&23,&70,&2B,&70,&33,&70,&3B;12
defb &C0,&03,&C0,&0B,&C0,&13,&C0,&1B,&C0,&23,&C0,&2B,&C0,&33,&C0,&3B;13
defb &10,&04,&10,&0C,&10,&14,&10,&1C,&10,&24,&10,&2C,&10,&34,&10,&3C;14
defb &60,&04,&60,&0C,&60,&14,&60,&1C,&60,&24,&60,&2C,&60,&34,&60,&3C;15
defb &B0,&04,&B0,&0C,&B0,&14,&B0,&1C,&B0,&24,&B0,&2C,&B0,&34,&B0,&3C;16
defb &00,&05,&00,&0D,&00,&15,&00,&1D,&00,&25,&00,&2D,&00,&35,&00,&3D
defb &50,&05,&50,&0D,&50,&15,&50,&1D,&50,&25,&50,&2D,&50,&35,&50,&3D
defb &A0,&05,&A0,&0D,&A0,&15,&A0,&1D,&A0,&25,&A0,&2D,&A0,&35,&A0,&3D
defb &F0,&05,&F0,&0D,&F0,&15,&F0,&1D,&F0,&25,&F0,&2D,&F0,&35,&F0,&3D;20
defb &40,&06,&40,&0E,&40,&16,&40,&1E,&40,&26,&40,&2E,&40,&36,&40,&3E
defb &90,&06,&90,&0E,&90,&16,&90,&1E,&90,&26,&90,&2E,&90,&36,&90,&3E
defb &E0,&06,&E0,&0E,&E0,&16,&E0,&1E,&E0,&26,&E0,&2E,&E0,&36,&E0,&3E
defb &30,&07,&30,&0F,&30,&17,&30,&1F,&30,&27,&30,&2F,&30,&37,&30,&3F
defb &80,&07,&80,&0F,&80,&17,&80,&1F,&80,&27,&80,&2F,&80,&37,&80,&3F
;,&21



ShowBossText:
	ld a,15 :OnscreenTimer_Plus1
	cp 10
	ret c
	ld bc,BossText :OnscreenTextPointer_Plus2
ShowBossText_StartText:
	;ld hl,&C000
	;call Akuyou_ShowSprite_SetBankAddr
	call Akuyou_SpriteBank_Font
	ld l,4
	ld a,1:BossCharNum_Plus1
	ld i,a	; show up to 255 chars
	
ShowBossText_MoreText:
	ld a,(bc)

	or a
	jp z,ShowBossText_AllOnscreen ; See if we have reached the end of the string

	ld h,a
	inc bc

	push hl
		call Akuyou_DrawText_LocateSprite

		call Akuyou_DrawText_PrintString
	pop hl
	inc l
	inc l
	inc l
	ld a,i
	dec a
	inc bc
	jp nz,ShowBossText_MoreText

	ld a,(bc)
	or a
	jp z,ShowBossText_AllOnscreen ; See if we have reached the end of the string
	ld a,(BossCharNum_Plus1-1)
	inc a
	nop
	nop :ShowTextSpeedup_Plus1
ShowBossTextNoSpeedup:
	ld (BossCharNum_Plus1-1),a

ret
ShowBossText_AllOnscreen:
	ld a,(OnscreenTimer_Plus1-1)
	dec a
	ld (OnscreenTimer_Plus1-1),a

	cp 10
	ret nz
	ld a,0;9; only one page of text
	ld (OnscreenTimer_Plus1-1),a
;	ld a,BossText2End-BossText2-20
	ld a,1
	ld (BossCharNum_Plus1-1),a
ret

BossText: 
db  11,"W A R N I N G ! ! ","!"+&80
db  05,""," "+&80
db  05,""," "+&80

db  05,"A Tiny Enemy is approachin","g"+&80
db  8,"Necromancer: Vengeance","!"+&80
db  05,""," "+&80
db &0

BossText2: 
db  11,"W A R N I N G ! ! ","!"+&80

db  05,"A shit load of enemy fire i","s"+&80
db  13,"approaching",":"+&80
db  05,""," "+&80

db  11,"THE OMEGA ARRAY","!"+&80
db  05,""," "+&80
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
db  2,"Lets see what the Z80 can REALLY do","!"+&80
db &0



evtSettingsBank_Save equ %10010000+15
evtSettingsBank_Load equ %10010000+0
evtMultipleCommands equ %01110000


evtSetMoveLife     equ 128
evtSetProg	   equ 129
evtSetLife	   equ 130
evtSetMove	   equ 131
evtSetProgMoveLife equ 132
evtSetSprite	   equ 133
evtAddToForeground equ 135
evtAddToBackground equ 134
evtJumpToNewTime   equ 136
evtCallAddress	   equ 137
evtSaveLstObjToAdd equ 138
evtResetPowerup    equ 139
evtSetLevelSpeed   equ 140

evtReprogramPalette 	equ %11110000
evtReprogramBackground 	equ %11110001	
evtReprogramHitHandler 	equ %11110010		
evtReprogramParalax	equ %11110011		

evtReprogramCustomMove1 equ %11110100
evtReprogramCustomMove2 equ %11110101
evtReprogramCustomMove3 equ %11110111
evtReprogramCustomMove4 equ %11111000

evtReprogramCustomProg1 equ %11111001
evtReprogramCustomProg2 equ %11111010
evtReprogramCustomProg3 equ %11111011
evtReprogramCustomProg4 equ %11111100


evtReprogram_PowerupSprites equ %11110110
evtReprogramScrollDirection equ %11111101	; 0-Left (Default) 1-Right 2-Up 3-Down
evtReprogramObjectFullCustomMoves equ	%11111110

evtReprogramSmartBombSpecial equ	%11111111

evtSingleSprite equ 0

;Time,type,Sprite,XY (16 px precision)

; Types:
;type XXXX----
;     00000000 A X Y = (0)  add one object A=sprnum, X , Y
;     00000001 Y    	Add one sprite to pos Y Far right (Same sprite as last time
;     0000yyyy A	2-13 add one 24 pixel object far right X=160+24 Y*16 -8 (Same sprite as last time
;     0001xxxx A B = (16) add  xxxx objects
;     0010xxxx X B = (32) add  xxxx objects all on column X
;     0011xxxx X Y S = (48) add  xxxx objects all on column X, Ypos Spaced S apart vertically
;     0100xxxx X Y   = (64) add stars to X,Y (pattern xxxx)
;     0101       Unused
;     0110       Unused
;     0111xxxx  = (112) Read Multiple events at the same time point

;     10000000 M L = (128) Change object movement to M, Life to L
;     10000001 P = (129) Change object Program
;     10000010 L = (130) Change object Life
;     10000011 M = (131) Change object Move
;     10000100 P M L = (132) Change object Program Move and Life
;     10000101 S = (133) Change object Sprite (only works with 0000XXXX )
;     10000110 (134) Add Objects to Front of list first (Background)
;     10000111 (135) Add Objects to Back of list first (Foreground)
;     10001000 L H T (136) = Load HL as next event pointer, change time to T
;     10001001 L H   (137) = Call HL - (untested)
;     10001010 L H   (138) = Load last added object address to address HL
;     10011111 B = Save to bank B
;     1001XXXX 	Load object settings (Prog, Move,Life) from XXXX bank (0-14 - see above 15 is save command)
;		Use this function to create template enemy moves and background object types
;     1010       Unused
;     1011       Unused	
;     1100XXXX   Unused
;     1101XXXX   Unused
;     1110XXXX   Unused
;     1111XXXX   Reprogram memory chunk

;     1111XXXX   Reprogram memory chunk
;     11110000 O B	X X X  = (240) Reprogram palette (B no of Bytes, O = offset; X X X byte data)
;     11110001 O B	X X X  = (240) Reprogram Background (B no of Bytes (up to 41), O = offset; X X X byte data)
;     11110010 LH 	= when an object is shot jump to HL (Akuyou_Object_DecreaseLifeShot is true hitcounter)
;     11110011 1P2	= Scroll rate 1 before P then 2 (1 must be faster than 2)
;     11110100 LH	= Reprogram Custom Move1
;     11110101 LH	= Reprogram Custom Move2

; Life BPxxxxx 		B=hurt by bullets , P hurts player, xxxxxx = Life ... Life decreases either over time or due to hits %00000000 means an immortal object which will only dissapear if it goes ofscreen

;Domoves
;0MYYYXXX	; Linear move
;11ddXXXX	; Background (Slow) move
;100001XX	; Seek player 1 speed -----XX1
;1010DSPP	D = Depth bit, S= Speed, PP Position


evtTileSprite equ 48 ;     0011xxxx X Y S = (48) add  xxxx objects all on column X, Ypos Spaced S apart vertically

prgNothing	equ 0
PrgSpare	equ 1 ;Does not get killed by smartbomb
prgSpecial	equ 2
prgBonus 	equ 3
prgMovePlayer	equ 4
prtSpriteAlt	equ 5

prgCustom1Protected 	equ 8				;Custom 1 - protected from smart bomb

;Not programmed in yet
;prgCustom2Protected 	equ 9				;Custom 2 - protected from smart bomb
;prgCustom3Protected 	equ 10				;Custom 3 - protected from smart bomb
;prgCustom4Protected 	equ 11				;Custom 4 - protected from smart bomb


;All under 31 Do not get killed by smartbomb except 0
prgFireSnail	equ %10000000
prgFireSlow	equ %01100000
prgFireMid	equ %01000000
prgFireMid2	equ %11000000
prgFireFast	equ %00100000
prgFireHyper	equ %10100000

; Fire Patterns

;defw	Stars_AddObject			;0 = just one - Special use only
;defw	Stars_AddBurst_TopLeft		;1
;defw	Stars_AddBurst_BottomLeft	;2
;defw	Stars_AddBurst_TopRight		;3
;defw	Stars_AddBurst_BottomRight	;4
;defw	Stars_AddBurst_Top		;5
;defw	Stars_AddBurst_Bottom		;6
;defw	Stars_AddBurst_Left		;7
;defw	Stars_AddBurst_Right		;8
;defw	Stars_AddBurst_TopWide		;9
;defw	Stars_AddBurst_BottomWide	;10
;defw	Stars_AddBurst_LeftWide		;11
;defw	Stars_AddBurst_RightWide	;12
;defw	Stars_AddBurst	All Dirs	;13
;defw	Stars_AddBurst	All Dirs Small	;14
;defw					;15
;	Fire W				 16 
;	Fire NW				 17
;	Fire N				 18

prgCustom1 	equ %11111100			;Custom 1
prgCustom2 	equ %11111101			;Custom 2
prgCustom3 	equ %11111110			;Custom 3
prgCustom4 	equ %11111111			;Custom 4


mveStatic 	equ &24
mveBackground   equ %11000000
mveSeaker	equ %10000100
mveWave		equ %10100000
;mveWaveSmall	equ %10010000 depricated
mveCustom1	equ %11110000
mveCustom2	equ %11100000
mveCustom3	equ %11010000
mveCustom4	equ %10110000

;	Moves - Regular
;		0	1	2	3	4	5	6	7
;		-4	-3	-2	-1	0	1	2	3
;-4	0	00	01	02	03	 04	05	06	07
;-3	1	08	09	0A	0B	 0C	0D	0E	0F
;-2	2	10	11	12	13	 14	15	16	17
;-1	3	18	19	1A	1B	 1C	1D	1E	1F

;0	4	20	21	22	23	[24]	25	26	27

;1	5	28	29	2A	2B	 2C	2D	2E	2F
;2	6	30	31	32	33	 34	35	36	37
;3	7	38	39	3A	3B	 3C	3D	3E	3F



;	Moves - Fast
;		0	1	2	3	4	5	6	7
;		-4	-3	-2	-1	0	1	2	3
;-4	0	40	41	42	43	 44	45	46	47
;-3	1	48	49	4A	4B	 4C	4D	4E	4F
;-2	2	50	51	52	53	 54	55	56	57
;-1	3	58	59	5A	5B	 5C	5D	5E	5F

;0	4	60	61	62	63	[64]	65	66	67

;1	5	68	69	6A	6B	 6C	6D	6E	6F
;2	6	70	71	72	73	 74	75	76	77
;3	7	78	79	7A	7B	 7C	7D	7E	7F


lifCustom       equ 255		; We use 63 as a marker for custom code's INIT - a real life will be set by the custom code
lifEnemy	equ %11000000	;HurtByBullets,Hurts Player
lifTimed	equ %00000000	;Doesnt hurt, dies automatically
lifDeadly	equ %01000000	;Deadly and cant be shot
TwoFrameSprite  equ 128




EventStreamArray:

;defb 1,128,&24,128+64+60		; Move Static
defb 0,evtAddToBackground

defb 0,evtReprogramScrollDirection,1; 0-Left (Default) 1-Right 2-Up 3-Down

;defb 0,evtResetPowerup
defb 0,evtReprogramScrollDirection,2; 0-Left (Default) 1-Right 2-Up 3-Down

defb 0,evtReprogramHitHandler				;Install a custom hit handler
defw CustomObjectHitHandler


defb 0,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		



; Define the background

defb 0
defb 240+1,0,12*2+1				; (Time,Cmd,Off,Bytes) Load 41 bytes into the background - 41 bytes is the limit
defb 0,0
defb 198,&A0	;1
defb 190,&50	;2
defb 176,&80	;3
defb 170,&20	;4
defb 166,&00	;5
defb 160,&00	;6
defb 36,&20	;7
defb 30,&80	;8
defb 26,&50	;9
defb 20,&A0	;10
defb 02,&F0	;11
defb 0

;We will use 4 Paralax layers
; ---------()- (sky)		%11001000
; ------------ (Far)		%11000100
; -----X---X-- (mid)		%11000010	Bank 1
; []=====[]=== (foreground) 	%11000001	Bank 0



FirstPowerupSprite equ  128+1
defb 0,evtReprogram_PowerupSprites,FirstPowerupSprite+53,FirstPowerupSprite+52,FirstPowerupSprite+51,FirstPowerupSprite	; sprites drone,speed,power,coin

defb 0,evtReprogramScrollDirection,2; 0-Left (Default) 1-Right 2-Up 3-Down

; Background L
defb 0,128+4,1,mveBackground+%00000001,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,evtSettingsBank_Save,0				; Save Object settings to Bank 0

defb 0,128+4,1,mveBackground+%00000010,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,evtSettingsBank_Save,1				; Save Object settings to Bank 1



;Coin
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,3,%10000111,64+63
;defb 	evtSetProgMoveLife,3,&24,64+63
defb 	evtSetSprite,128+1;16		
defb 	evtSettingsBank_Save,3




;Necromancer
defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
defb 	evtSetProgMoveLife,prgCustom1Protected,mveCustom1,lifEnemy+30; Program - Fire Left... Move - wave... Hurt by bullets, hurts player, life 4
defb 	evtSetSprite,128+0;16		
defb 	evtSettingsBank_Save,2

defb 0,evtReprogramCustomMove1
defw CustomMove1


defb 0,evtReprogramCustomProg1
defw CustomProgram1

defb 0,evtReprogramSmartBombSpecial
defw DisableOmegaArray
;Necromancer
;defb 0,evtMultipleCommands+3					; 3 commands at the same timepoint
;defb 	evtSetProgMoveLife,prgCustom1Protected,&24,0; Program - Fire Left... Move - wave... Hurt by bullets, hurts player, life 4
;defb 	evtSetSprite,128+3;16		
;defb 	evtSettingsBank_Save,3



;doors
defb 0,evtMultipleCommands +6
;defb 	evtSingleSprite,TwoFrameSprite+0 ,24+80,24+100
defb 	evtSetProgMoveLife,0,&24,0
defb 	evtSingleSprite,TwoFrameSprite+3 ,24		,24+16+24
defb 	evtSingleSprite,TwoFrameSprite+3 ,24+160-16	,24+16+24
defb 	evtSingleSprite,TwoFrameSprite+5 ,24		,200+24-24
defb 	evtSingleSprite,TwoFrameSprite+5 ,24+160-16	,200+24-24
defb 	evtSingleSprite,TwoFrameSprite+3 ,24+80-8	,100+24-16+24


;Palette Change
defb 1,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 0
	defb &54,&54,&44,&40

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 0			
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 0				
	defb &54,&54,&44,&40		

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 0				
	defb &54,&54,&44,&40			


; Load Palette

	defb 2,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 0				
	defb &54,&5C,&56,&4B	

	defb 240,26*0+6,5*1+1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1	; Switches
	defb 0	;delay			
	defb &54,&5C,&56,&4B	


	defb 240,26*1+6,1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0

	defb 240,26*2+6,5*1+1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1 ; no of switches
	defb 0	;delays			
	defb &54,&5C,&56,&4B		

;defb 2,evtCallAddress			;Start the palette switcher
;defw	RasterColorsStartPalleteFlip




;Necromancer
defb 15,evtMultipleCommands +2
defb 	evtSettingsBank_Load +2
defb 	evtSingleSprite,TwoFrameSprite+0 ,24+160,24+100
;defb 	evtSingleSprite,TwoFrameSprite+0 ,0+16,24*3+7



LevelIdleLoop:
defb 100	
defb 	evtJumpToNewTime			; Jump to a different level point
defw 	LevelIdleLoop				; pointer
defb	 0					; new time



LevelEndAnim:



defb 120+10, evtSettingsBank_Load +3
defb 120+10, evtTileSprite+8, 24,24,24,		128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+11,evtTileSprite+8, 24,200,24,	128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+12,evtTileSprite+8, 24,24,24,		128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+13,evtTileSprite+8, 24,200,24,	128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+14,evtTileSprite+8, 24,24,24,		128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+15,evtTileSprite+8, 24,200,24,	128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+16,evtTileSprite+8, 24,24,24,		128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+17,evtTileSprite+8, 24,200,24,	128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+18,evtTileSprite+8, 24,24,24,		128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+19,evtTileSprite+8, 24,200,24,	128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+20,evtTileSprite+8, 24,24,24,		128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+21,evtTileSprite+8, 24,200,24,	128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+22,evtTileSprite+8, 24,24,24,		128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+23,evtTileSprite+8, 24,200,24,	128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+24,evtTileSprite+8, 24,24,24,		128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1

defb 120+25,evtTileSprite+8, 24,200,24,	128+1,128+1,128+1,128+1,128+1,128+1,128+1,128+1





;defb 160,%01110000+2			; 3 commands at the same timepoint
;defb evtSetProgMoveLife,prgMovePlayer,&24,10
;defb 	0,128+	20,140+24,100+24	; 	; Single Object sprite 11 (animated)

;defb 160,%10001001			;Call a memory location
;defw	ClearBadguys
;Palette Change
defb 162,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40	





defb 163,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

defb 163,evtCallAddress			;Call a memory location
defw	EndLevel

SetStarArrays:
	ld (ArrayMode_Plus1-1),a
	ret z
	cp 1
	jp DisableStarArray
DisableOmegaArray:
	ld de,&0000

	ld hl,OmegaArrayPointer1+256
	ld b,4
	call SpFill

	ld hl,OmegaArrayPointer2+256
	ld b,4
	call SpFill

	ld hl,OmegaArrayPointer3+256
	ld b,4
	call SpFill

	ld hl,OmegaArrayPointer4+256
	ld b,4
	jp SpFill

DisableStarArray:
	ld hl,StarArrayPointer
	ld b,4
	ld de,&0000
	jp SpFill


;defb 	evtJumpToNewTime
;defw 	&6969		EndIlluminatePointer_Plus2	; pointer
;defb	 &69		EndIlluminateTime_Plus1	; new time

BossSprite_Vanish:
BossSprite_Arrive:
	xor a
	ld (OmegaBack_Plus1-1),a

	ld a,128+4
	jr BossSpriteDone
BossSprite_Fire:
	xor a
	ld (OmegaBack_Plus1-1),a
	ld a,8
	ld (OmegaBackB_Plus1-1),a

	ld a,%00001000	:BossNormalFireRate_Plus1
	ld(CustomProgram1TimerTick_Plus1-1),a

	ld a,128+0
	jr BossSpriteDone
BossSprite_Omega:
	ld a,1
	ld (OmegaBack_Plus1-1),a
	

	ld a,%00001000
	ld(CustomProgram1TimerTick_Plus1-1),a

	ld a,0 :nextOmegaTick_Plus1
	inc a
	and %00000011		:OmegaFireRate_Plus1
	ld (nextOmegaTick_Plus1-1),a
	jp nz,OmegaSkipFrame
	
	push bc
	push de

		ld a,0 :nextOmega_Plus1
		inc a
		and %00011111
		ld (nextOmega_Plus1-1),a
		call	OmegaBurstGeneral

	pop de
	pop bc
OmegaSkipFrame:
	ld a,128+2
	jr BossSpriteDone

BossSpriteDone:
	ld iyh,a
	ret


DontShowBoss:
	ld a,(NoMoveCount_Plus1-1)
	dec a
	ld (NoMoveCount_Plus1-1),a
	jr z,MoveBoss
	ret

CustomProgram1:
	;ld a,(BossLife)
	;or a
	ld a,b
	cp 160+24	
	ret z


	call Akuyou_Timer_GetTimer
;	ld a,i
	and 0:CustomProgram1TimerTick_Plus1
	ret z

	ld a,15
	ld iyl,a
	jp Akuyou_FireStar
BossDead:
	ld a,160+24
	ld b,a
ret
CustomMove1:
	ld a,(BossLife)
	or a
	jp z,BossDead

	ld a,b
	cp 160+24	
	jr z,DontShowBoss

	ld a,%00001000
	ld(CustomProgram1TimerTick_Plus1-1),a

	ld a,1 :NoMoveCount_Plus1
	dec a

	ld (NoMoveCount_Plus1-1),a
	cp 90
	jr nc,BossSprite_Arrive
	cp 10 :NormalFireEnable_Plus1
	jr nc,BossSprite_Fire
	cp 100 :OmegaEnable_Plus1
	jr nc,BossSprite_Omega
	cp 5
	jp nc,BossSprite_Vanish
	or a
	ret nz

MoveBoss

	ld a,95
	ld (NoMoveCount_Plus1-1),a

;		ld a,iyl ; Program Code
;		ld a,ixl  ;Life
;		ld a,iyh ;spr
;		ld a,ixh ;Move
;		ld (hl),b ;X
;		ld (hl),c ;Y


;defb 	evtSingleSprite,TwoFrameSprite+3 ,20		,24+16
;defb 	evtSingleSprite,TwoFrameSprite+3 ,24+160-24	,24+16
;defb 	evtSingleSprite,TwoFrameSprite+3 ,20		,200+24-32
;defb 	evtSingleSprite,TwoFrameSprite+3 ,24+160-24	,200+24-32
;defb 	evtSingleSprite,TwoFrameSprite+3 ,24+80-8	,100+24-16
di
exx
ld hl,&8000 :Randpoint_Plus2
inc h
inc l
ld d,(hl)
inc hl
ld a,(hl)
inc hl
ld (Randpoint_Plus2-2),hl
xor d
exx
ei
FindBossPoss:
	and %11100000
	cp  %00100000		
	jr z,Boss1
	cp  %01000000		
	jr z,Boss2
	cp  %01100000		
	jr z,Boss3
	cp  %10000000		
	jr z,Boss4
	cp  %10100000		
	jr z,Boss5
	;cp  %00000000		
	;jp z,BossHide
	sub %00100000
	jp FindBossPoss

BossHide:

	ld a,32
	ld (NoMoveCount_Plus1-1),a

	ld b,160+24
	ld c,2
	jr BossFinish
Boss1:
	ld b,20	+3	+3
	ld c,24+16
jr BossFinish
Boss2:
	ld b,24+160-21	+3
	ld c,24+16	
jr BossFinish
Boss3:
	ld b,20	+3	+3
	ld c,200+24-32	
jr BossFinish
Boss4:
	ld b ,24+160-21	+3
	ld c,200+24-32	
jr BossFinish
Boss5:
	ld b,24+80-8	+3
	ld c,100+24-16	
jr BossFinish

BossFinish:
	ld a,b
	add 4
	ld (OmegaX_Plus1-1),a
	ld a,c
	add 12
	ld (OmegaY_Plus1-1),a
ret
BossLife: defb 32*3
BossLifeB: defb 7
CustomObjectHitHandler:
	ld a,(BossLife)
	or a
	jp z,BossDead

	ld a,iyl
	cp 8
	jp nz,CustomObjectHitHandler_Finish
	

	;boss life is more than 256
	ld a,(BossLifeB)
	dec a
	ld (BossLifeB),a
	ret nz
	ld a,7
	ld (BossLifeB),a
	;update the real boss life
	ld a,(BossLife)
	dec a
	ld (BossLife),a
	cp 90
	jp z,BossMode_EnableOmega
	cp 60
	jp z,BossMode_LongOmega
	cp 30
	jp z,BossMode_OmegaFullPower
	cp 0
	jp z,Boss_Dead
	ret

Boss_Dead:
		push hl
			ld a,2
			call Akuyou_DoSmartBombCall
		
			ld hl,LevelEndAnim
			ld a,120+8
			call Akuyou_SetLevelTime
		pop hl
		ret

BossMode_EnableOmega:
push hl
	ld hl,BossText2
	ld (OnscreenTextPointer_Plus2-2),hl
pop hl
ld a,&3c
ld (ShowTextSpeedup_Plus1-1),a
ld (ShowTextSpeedup_Plus1-2),a
ld a,15
ld (OnscreenTimer_Plus1-1),a

ld a,1
ld (BossCharNum_Plus1-1),a

ld a,70
ld (NormalFireEnable_Plus1-1),a
ld a,10
ld (OmegaEnable_Plus1-1),a
ret

BossMode_LongOmega:
ld a,%00000100
ld (BossNormalFireRate_Plus1-1),a
ld a,80
ld (NormalFireEnable_Plus1-1),a
ld a,10
ld (OmegaEnable_Plus1-1),a
ret

BossMode_OmegaFullPower:
ld a,%00000001
ld (OmegaFireRate_Plus1-1),a
ret

CustomObjectHitHandler_Finish:
	jp Akuyou_Object_DecreaseLifeShot

OmegaBurst:
		ld a,(hl)
		inc hl
		jr OmegaBurstGeneral

OmegaBurstGeneral:
		push hl
			push af
				ld d,0
				call OmegaArray_GetPointer	
				ld b,32
				call OmegaArray_Engage
			pop af
			;ld d,2
			;call OmegaArray_GetPointer	
			;ld c,32
			;call OmegaArray_Engage_Loopb
		pop hl
ret

EndLevel:
	pop hl	;
	ld hl,	&01FB 				;load level 2
	jp	Akuyou_ExecuteBootStrap	; Start the game, no return


ClearBadguys:
	ld a,1
	ld i,a
	push hl
	call Akuyou_DoSmartBombCall
	pop hl
ret


LevelInit:

	; wipe our memory, to clear out any junk from old levels
	ld de,&51
	ld hl,&50
	ld bc,&5FF
	ld (hl),0
	ldir 

	;wipe the omega array
	ld de,OmegaArrayPointer1+1
	ld hl,OmegaArrayPointer1
	ld bc,OmegaArraySize*3*4
	ld (hl),0
	ldir 	

	;Fix up the Alt Palette - not needed if the palette is in the saved level code
	;ld hl,&0001
	;ld (RasterColors_ColorArray1Alt),hl
	;ld (RasterColors_ColorArray2Alt),hl
	;ld (RasterColors_ColorArray3Alt),hl
	;ld (RasterColors_ColorArray4Alt),hl

	call AkuYou_Player_GetPlayerVars
	ld a,(iy-1)
	and 64
	jp z,Detected128k

	ld hl,NormalBackCall	;can't do the compiled sprite back on 64k
	ld (DetailedBackJump_Plus2-2),hl
Detected128k:

	call RasterColorsSetPalette1


	ld a, StarArraySize
	ld hl,StarArrayPointer
	call AkuYou_StarArrayInit_Enemy 

	ld a, PlayerStarArraySize
	ld hl,PlayerStarArrayPointer
	call AkuYou_StarArrayInit_Player 

	ld a,ObjectArraySize
	ld hl,ObjectArrayPointer
	call AkuYou_ObjectArray_Init


	ld hl,LevelSprites		
	ld de,PlayerSprites
	call AkuYou_SpritePointerInit


	ld hl,EventStreamArray		;Event Stream
	ld de,Event_SavedSettings	;Saved Settings
	call AkuYou_Event_StreamInit

	call AkuYou_Player_GetPlayerVars
	ld a,80+24
	ld (iy+1),a
	call Akuyou_Music_Restart

	call Akuyou_ScreenBuffer_Init
	call Akuyou_RasterColors_Init

;	ld d,0
;	call OmegaArray_GetPointer	
;	ld b,32
;	call OmegaArray_Engage

	;ld d,2
	;call OmegaArray_GetPointer	
	;ld c,32
	;call OmegaArray_Engage_Loopb


	;ld hl,OmegaArrayPointer2
	;call OmegaArray_Engage
	;ld hl,OmegaArrayPointer3
	;call OmegaArray_Engage
	;ld hl,OmegaArrayPointer4
	;call OmegaArray_Engage

	
	ld hl,OmegaArrayPointer1+OmegaArraySize*2
	
	;call RasterColors_Reset
LevelLoop:
	

	;ld a,128+0
	;ld hl,(BossObject1)
	;call SetSprite

	;call Akuyou_Background_Clear
	;ld l,&08
	;call Timer_Stop
	;ld l,&09
	;call Timer_Stop
	;ld a,"B"
	;call &bb5a 
	Call Akuyou_Timer_UpdateTimer
	or a
	jp nz,DoBack1	;use basic back during smartbomb
	ld a,0 :OmegaBack_Plus1
	or a
	jp nz,NormalBackB	;use basic back during omega

	;call Akuyou_GetLevelTime
	;cp 4

DetailedBack:
	call &D500	:DetailedBackJump_Plus2
	jr Skipback
NormalBackB:
	
	ld a,6:OmegaBackB_Plus1
	dec a
	jr z,NormalBack
	ld (OmegaBackB_Plus1-1),a

	bit 0,a
	jr z,NormalBack

	ld de,&0F0F
	;halt
	xor a
	call Background_0B
	jr Skipback
NormalBack:
	xor a
DoBack1:
	;halt
	call Background_0
skipback

;halt
;halt
;halt
;halt


	call Akuyou_EventStream_Process
	call Akuyou_ObjectArray_Redraw



	call Akuyou_Player_Handler


	call Akuyou_Timer_GetTimer
	or a
jp z,NoOmegaArray


	ld a,0	:ArrayMode_Plus1
	cp 1
	jp z, NoStarArray
	
	call Akuyou_StarArray_Redraw

NoStarArray:


	cp 2
	jp z, NoOmegaArray

	

	call OmegaArray_Redraw

NoOmegaArray:
	;ld l,&0b
	;call Timer_Stop
	;ld a,"O"
	;call &bb5a 

	call AkuYou_Player_StarArray_Redraw
	;ld l,&0e
	;call Timer_Stop
	;ld a,"F"
	;call &bb5a 


	call AkuYou_Player_DrawUI

	call Akuyou_PlaySfx




	ifdef debug
		call ShowLevelTime
	endif

	call BossLifeBar

	call ShowBossText


	call Akuyou_ScreenBuffer_Flip
	jp LevelLoop
LevelShutdown:

ret


ShowLevelTime:
	;ld hl,&C000
	;call Akuyou_ShowSprite_SetBankAddr
	call Akuyou_SpriteBank_Font

	ld hl,&1001
	call Akuyou_DrawText_LocateSprite

	call Akuyou_GetLevelTime
	push bc	
	call ShowHex
	pop bc
	ld a,b
	call ShowHex
ret


ShowHex:

	push af         ;store original byte value
	rrca            
	rrca
	rrca
	rrca
	call ShowHexDigit
	pop af          ;retrieve original byte value

ShowHexDigit:
;	and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
;	add a,"0"       ;add ASCII for 0. Digits 0...9 become "0"..."9", digits 10..15
;	cp "9"+1        
;	jr c,ShowHexDigitNum     ;if number is in digit range 0...9, display digit
;	add a,"A"-"9"-1 ;modify ASCII value so that digits in the range 10...15
and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
cp &a           ;Less than 10?  Set carry if so
sbc a,&69
daa             ;Because previous instruction was a subtract operation this
                ;is known as 'das' in x86
ShowHexDigitNum:
	jp Akuyou_DrawText_CharSprite   ;display digit


RasterColorsStartPalleteFlip:
	xor a
 	ld (PaletteNo_Plus1-1),a
ret

RasterColorsSetPalette1:
	ld a,1
	ld bc,RasterColors_ColorArray1
	ld de,RasterColors_ColorArray2
	ld hl,RasterColors_ColorArray3
	ld ix,RasterColors_ColorArray4
	ld iy,null
jp Akuyou_RasterColors_SetPointers

PaletteSwitcher:
	ld a,64:PaletteNo_Plus1
	cpl	
	ld (PaletteNo_Plus1-1),a
	or a
	jp nz,RasterColorsSetPalette1
RasterColorsSetPalette2:
	ld a,1
	ld bc,RasterColors_ColorArray1Alt
	ld de,RasterColors_ColorArray2Alt
	ld hl,RasterColors_ColorArray3Alt
	ld ix,RasterColors_ColorArray4Alt
	ld iy,PaletteSwitcher
jp Akuyou_RasterColors_SetPointers


NormalBackCall:
	pop af
jp NormalBack






null:ret

limit &3fff
org &3ff0
jp LevelInit; - Level Start &3ff0
jp LevelLoop; - Level loop &3ff3
jp null     ; - Level resume &3ff6
jp null     ; - Level Shutdown &3ff9


save direct "T29-SC1.D02",&3000,&1000	;address,size...}[,exec_address]



