/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.cpu;

import JCPC.core.Util;
import JCPC.core.device.Device;
import JCPC.core.device.DeviceMapping;

public abstract class Processor
extends Device {
    public int actualAddress;
    protected Device memory;
    protected DeviceMapping[] inputDevice = new DeviceMapping[0];
    protected DeviceMapping[] outputDevice = new DeviceMapping[0];
    protected Device cycleDevice = null;
    protected Device interruptDevice = null;
    protected int interruptPending = 0;
    protected long cycles = 0L;
    protected long cyclesPerSecond;
    protected boolean stopped = false;

    public Processor(String type, long cyclesPerSecond) {
        super(type);
        this.cyclesPerSecond = cyclesPerSecond;
    }

    public final void cycle(int count) {
        while (count > 0) {
            this.cycle();
            --count;
        }
    }

    @Override
    public void cycle() {
        ++this.cycles;
        this.cycleDevice.cycle();
    }

    @Override
    public void reset() {
        this.interruptPending = 0;
        this.cycles = 0L;
    }

    public long getCycles() {
        return this.cycles;
    }

    public abstract void step();

    public abstract void stepOver();

    public void run() {
        this.stopped = false;
        do {
            this.step();
        } while (!this.stopped);
    }

    public void runTo(int address) {
        this.stopped = false;
        do {
            this.step();
        } while (!this.stopped && this.getProgramCounter() != address);
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    public final int readWord(int addr) {
        return this.readByte(addr) + (this.readByte(addr + 1 & 0xFFFF) << 8);
    }

    public final void writeWord(int addr, int value) {
        this.writeByte(addr, value & 0xFF);
        this.writeByte(addr + 1 & 0xFFFF, value >> 8 & 0xFF);
    }

    @Override
    public int readByte(int address) {
        return this.memory.readByte(address);
    }

    @Override
    public int writeByte(int address, int value) {
        return this.memory.writeByte(address, value);
    }

    public final int in(int port) {
        int result = 255;
        for (int i = 0; i < this.inputDevice.length; ++i) {
            result &= this.inputDevice[i].readPort(port);
        }
        return result;
    }

    public final void out(int port, int value) {
        for (int i = 0; i < this.outputDevice.length; ++i) {
            this.outputDevice[i].writePort(port, value);
        }
    }

    public final void setMemoryDevice(Device value) {
        this.memory = value;
    }

    public final Device getMemoryDevice() {
        return this.memory;
    }

    public final void addInputDeviceMapping(DeviceMapping value) {
        this.inputDevice = (DeviceMapping[])Util.arrayInsert(this.inputDevice, this.inputDevice.length, 1, value);
    }

    public final void removeInputDeviceMapping(DeviceMapping value) {
        this.inputDevice = (DeviceMapping[])Util.arrayDeleteElement(this.inputDevice, value);
    }

    public final void addOutputDeviceMapping(DeviceMapping value) {
        this.outputDevice = (DeviceMapping[])Util.arrayInsert(this.outputDevice, this.outputDevice.length, 1, value);
    }

    public final void removeOutputDeviceMapping(DeviceMapping value) {
        this.outputDevice = (DeviceMapping[])Util.arrayDeleteElement(this.outputDevice, value);
    }

    public final void setCycleDevice(Device value) {
        this.cycleDevice = value;
    }

    public final void setInterruptDevice(Device value) {
        this.interruptDevice = value;
    }

    @Override
    public void setInterrupt(int mask) {
        this.interruptPending |= mask;
    }

    @Override
    public void clearInterrupt(int mask) {
        this.interruptPending &= ~mask;
    }

    public abstract String getState();

    public abstract int getProgramCounter();

    public long getCyclesPerSecond() {
        return this.cyclesPerSecond;
    }

    public void setCyclesPerSecond(long value) {
        this.cyclesPerSecond = value;
    }
}

