/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import JCPC.core.device.crtc.Basic6845;
import JCPC.core.device.crtc.CRTCListener;
import JCPC.core.device.crtc.Slider;
import JCPC.core.renderer.MonitorRenderer;
import JCPC.system.cpc.CPC;
import JCPC.system.cpc.CPCMemory;
import JCPC.system.cpc.GraphicsDecoder;
import JCPC.system.cpc.Z80;
import JCPC.ui.Display;
import JCPC.ui.GX4000;
import java.awt.Dimension;

public final class GateArray
extends MonitorRenderer
implements CRTCListener {
    public static final int lowlines = 272;
    public static final int highlines = 544;
    protected int borderHeight;
    protected static final GraphicsDecoder decoder;
    protected final int HOFFSET = 686080;
    protected final int HOFFSEND = 3831808;
    protected Dimension HALF_DISPLAY_SIZE = new Dimension(384, 272);
    protected Dimension FULL_DISPLAY_SIZE = new Dimension(768, 272);
    static int returnmode;
    static int rambank;
    static int smode;
    public static CPC cpc;
    public static Z80 z80;
    public Basic6845 crtc;
    public int InterruptLineCount;
    public int MonitorLineCount;
    public int InterruptSyncCount = 0;
    protected int hSyncCount;
    protected int vSyncCount = 0;
    protected int screenMode = -1;
    public int newMode = 0;
    protected boolean[] isBorder;
    protected boolean[] rendered;
    protected boolean inHSync = false;
    protected boolean outHSync = false;
    public static int[] inks;
    protected byte[] fullMap;
    protected byte[] halfMap;
    protected int offset = 0;
    protected int scanStart = 0;
    protected boolean scanStarted;
    protected Renderer borderRenderer;
    protected Renderer syncRenderer;
    protected Renderer defRenderer;
    protected Renderer startRenderer;
    protected Renderer endRenderer;
    protected Renderer renderer;
    protected int endPix;
    protected int selInk = 0;
    protected boolean render = true;
    protected boolean rendering = true;
    protected int screenData;
    public static byte[] screenmemory;
    protected int Luminance = 255;
    protected static final int[] maTranslate;
    protected static int[] CPCInks;
    protected static int[] CPCInksb;
    protected static int[] GAInks;
    protected int[] palette = new int[]{13, 13, 19, 25, 1, 7, 10, 16, 7, 25, 24, 26, 6, 8, 15, 17, 1, 19, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
    protected static int[] Inks;
    int[] storeColor = new int[32];
    protected static final byte[][] fullMaps;
    protected static int[][] modeTab;
    public int[] LUM = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
    public int[] inkTranslateColor = new int[]{0x636363, 0x636363, 65379, 0xFFFF63, 99, 16711779, 25443, 0xFF6363, 16711779, 0xFFFF63, 0xFFFF00, 0xFEFEFE, 0xFF0000, 0xFF00FF, 16737024, 0xFF63FF, 99, 65379, 65280, 65535, 0, 255, 25344, 25599, 0x630063, 0x63FF63, 6553344, 0x63FFFF, 0x630000, 6488319, 0x636300, 0x6363FF};
    protected static final int[] original;
    boolean isHScroll;
    boolean GateArray_RasterInterruptRequest = false;
    boolean test = true;
    boolean testbars;
    public static int SoftScrollRegister;
    int oldscroll;
    boolean plusdone = true;
    int spritecheck;
    int oldline;
    int pline;
    int lc;
    int llc;
    int pd;
    public boolean simplesprites = true;
    Slider slider;
    int[] ff = new int[]{243, 237, 86, 49, 255, 191, 1, 131, 247, 237, 73, 1, 0, 244, 237, 73};
    int skipsprites;
    int vscroll;
    public static int verticalScroll;
    int[] lines = new int[]{0, 112, 224, 336, 448, 560, 672, 784};
    int ras;
    int borderpixel = 0;
    int maxline;
    int ticker;
    boolean tt;
    public boolean nosprites = false;
    protected int horizontalScroll;
    protected int horizontalScrollMask = 12;
    int p;
    int spriteoffset;
    int spos;
    CPCMemory spritemem;
    public int[] xm = new int[16];
    public int[] ym = new int[16];
    int[] xpos = new int[16];
    int[] ypos = new int[16];
    int ymin;
    int ymax;
    int xmin;
    int xmax;
    int sproffset;
    int pix;
    int crtcX;
    int crtcY;
    int[] result = new int[4];
    int split;
    boolean srendered;
    int pixelcheck;
    boolean[] spriteput = new boolean[16];
    Thread draw;
    boolean spritesput = false;
    int bink = 16;
    int rasterline;
    int stepper;
    int oldra;
    int tsync;
    int spriteRow;
    int activeSprites;
    int[] spriteRows = new int[16];
    int poff;
    boolean simplesprite;
    boolean skippixel;
    int[] spritePixel = new int[16];
    int spriteIndex;
    int[] yz = new int[16];
    int[] xz = new int[16];
    int bpixelx;
    int bpixely;
    int spx;
    int spy;
    int stx;
    int sty;
    int spixel = 0xFFFFFF;
    int reg9;
    boolean[] delay = new boolean[16];
    boolean DEBUG_BORDER = false;
    int dev;
    boolean skipper = false;
    int r3;
    boolean hasscroll;
    int scrolline;
    int ispos;
    protected static final int[] SOFT_SCROLL_MASK;
    int[] pixelmap = new int[16];

    public int getBorder() {
        return inks[16];
    }

    public int getPaper() {
        return inks[0];
    }

    public void resetCPCColours() {
        System.arraycopy(original, 0, this.inkTranslateColor, 0, original.length);
    }

    public void setPlusPalette(int ink, int r, int g, int b) {
        r += r >> 5;
        g += g >> 5;
        b += b >> 5;
        this.setPlusPalette(ink, GateArray.putRGB(r, g, b));
        if (GX4000.debug != null && GX4000.debug.isVisible() && this.storeColor[ink] != r + g + b) {
            GX4000.debug.INK(ink, GateArray.putRGB(r, g, b));
            this.storeColor[ink] = r + g + b;
        }
    }

    public void setPlusPalette(int ink, int value) {
        this.inkTranslateColor[ink] = value;
        this.setInk(ink, ink);
    }

    public void setPalette(int ink, int value) {
        this.inkTranslateColor[GateArray.Inks[ink]] = value;
    }

    public int getVPOS() {
        return this.crtc.getVVPOS();
    }

    public int getHPOS() {
        return this.crtc.getHPOS();
    }

    public GateArray(CPC cpc) {
        super("Amstrad Gate Array");
        this.setCycleFrequency(1000000L);
        GateArray.cpc = cpc;
        z80 = cpc.z80;
        this.crtc = cpc.crtc;
        this.reset();
        this.setHalfSize();
    }

    public void setHalfSize() {
        if (this.defRenderer == null) {
            this.defRenderer = new FullRenderer();
            this.startRenderer = new FullStartRenderer();
            this.endRenderer = new FullEndRenderer();
            this.borderRenderer = new BorderRenderer(16, 16);
            this.syncRenderer = new BorderRenderer(32, 16);
            this.renderer = this.borderRenderer;
        }
    }

    @Override
    public void reset() {
        this.oldline = -1;
        this.spritecheck = -1;
        System.out.println("GateArray reset!");
        this.crtc.reset();
        this.horizontalScroll = 0;
        verticalScroll = 0;
        this.InterruptLineCount = 0;
        this.MonitorLineCount = 0;
        this.InterruptSyncCount = 0;
        this.hSyncCount = 0;
        this.vSyncCount = 0;
        this.screenMode = -1;
        this.GateArray_RasterInterruptRequest = false;
        this.setScreenMode(1);
        for (int i = 0; i < 33; ++i) {
            GateArray.inks[i] = -16777216;
        }
        GateArray.inks[16] = -8355712;
        Display.vscroll = "" + verticalScroll + " - " + this.horizontalScroll;
        SoftScrollRegister = 0;
        this.horizontalScroll = 0;
        verticalScroll = 0;
        if (this.crtc != null) {
            this.crtc.setVerticalScroll(verticalScroll);
            this.crtc.init();
        }
        this.resetCPCColours();
    }

    public void memoryReset() {
        this.oldline = -1;
        this.spritecheck = -1;
        this.InterruptLineCount = 0;
        this.MonitorLineCount = 0;
        SoftScrollRegister = 0;
        this.horizontalScroll = 0;
        verticalScroll = 0;
        this.crtc.setVerticalScroll(verticalScroll);
        this.crtc.init();
        this.resetCPCColours();
        Display.vscroll = "" + verticalScroll + " - " + this.horizontalScroll;
    }

    public void setSelectedInk(int value) {
        this.selInk = (value & 0x1F) < 16 ? value & 0xF : 16;
    }

    public int getSelectedInk() {
        return this.selInk;
    }

    public void setInk(int index, int value) {
        GateArray.CPCInks[index] = GAInks[value & 0x1F];
        GateArray.CPCInksb[index] = value;
        GateArray.inks[index] = this.inkTranslateColor[value & 0x1F];
    }

    public void setBorder(int value) {
        GateArray.CPCInks[16] = GAInks[value & 0x1F];
        GateArray.CPCInksb[16] = value;
        GateArray.inks[16] = this.inkTranslateColor[value & 0x1F];
    }

    public static int getInk(int index) {
        return CPCInks[index];
    }

    public static int getInks(int index) {
        return CPCInksb[index];
    }

    @Override
    public void writePort(int port, int value) {
        if (GateArray.cpc.memory.plus) {
            cpc.getAsic().writePort(port, value);
            return;
        }
        if ((value & 0x80) == 0) {
            if ((value & 0x40) == 0) {
                this.selInk = (value &= 0x1F) < 16 ? value : 16;
            } else {
                GateArray.CPCInks[this.selInk] = GAInks[value & 0x1F];
                GateArray.CPCInksb[this.selInk] = value & 0x1F;
                GateArray.inks[this.selInk] = this.inkTranslateColor[value & 0x1F];
            }
        } else if ((value & 0x40) == 0) {
            GateArray.cpc.asic.romconfig = value;
            GateArray.cpc.asic.setModeAndROMEnable();
        } else {
            GateArray.cpc.memory.setRAMBank(value);
            rambank = value;
        }
    }

    public int getRAMBank() {
        return rambank;
    }

    public int getMode() {
        return returnmode;
    }

    public void setSoftScroll(int value) {
        SoftScrollRegister = value & 0xFF;
        this.horizontalScrollMask = SOFT_SCROLL_MASK[this.screenMode];
        this.horizontalScroll = SoftScrollRegister & 0xF;
        this.isHScroll = this.horizontalScroll != 0;
        verticalScroll = SoftScrollRegister >> 4 & 7;
        this.crtc.setVerticalScroll(verticalScroll);
    }

    public void setScreenMode(int mode) {
        this.screenMode = mode;
        this.fullMap = fullMaps[mode];
        this.horizontalScrollMask = SOFT_SCROLL_MASK[mode];
        this.horizontalScroll = SoftScrollRegister & 0xF;
        this.isHScroll = this.horizontalScroll != 0;
    }

    @Override
    public int getScreenMode() {
        return this.screenMode;
    }

    public static int getSMode() {
        return smode;
    }

    public void GateArray_AcknowledgeInterrupt() {
        this.InterruptLineCount &= 0x1F;
        this.GateArray_RasterInterruptRequest = false;
    }

    public boolean GateArray_GetInterruptRequest() {
        return this.GateArray_RasterInterruptRequest;
    }

    public void GateArray_ClearInterrupt() {
        this.GateArray_RasterInterruptRequest = false;
        z80.Z80_ClearInterruptRequest();
        this.GateArray_ClearInterruptCount();
        cpc.getAsic().ASIC_ClearRasterInterrupt();
    }

    public void GateArray_ClearInterruptCount() {
        this.InterruptLineCount = 0;
    }

    @Override
    public void cycle() {
        if (screenmemory != null) {
            int addr = maTranslate[this.crtc.getMA()] + ((this.crtc.getRA() & 7) << 11);
            this.screenData = (this.screenData & 0xFFFF) << 16 | (screenmemory[addr] & 0xFF) << 8 | screenmemory[addr + 1] & 0xFF;
        }
        if (this.pixels == null) {
            try {
                this.pixels = this.display.getPixels();
            }
            catch (Exception e) {
                this.pixels = new int[208896];
            }
            return;
        }
        if (this.rendered == null) {
            this.rendered = new boolean[this.pixels.length];
        }
        this.crtc.avoidCollision();
        smode = this.screenMode;
        if ((this.hSyncCount == 3 || this.hSyncCount == 4) && this.crtc.CRTCType != 3) {
            this.modeCheck();
        }
        if (this.scanStarted) {
            this.crtc.checkHDisp();
            if (this.hPos < 3831808) {
                this.renderer.render();
            } else {
                this.endRenderer.render();
                this.scanStarted = false;
                this.render = false;
            }
        } else if (this.render && this.hPos >= 686080) {
            this.startRenderer.render();
            this.scanStarted = true;
        }
        this.crtc.cycle();
        if (this.inHSync) {
            ++this.hSyncCount;
            if (this.hSyncCount == 2) {
                this.outHSync = true;
                super.hSyncStart();
            }
            if (this.hSyncCount == 7) {
                this.endHSync();
            }
        }
        this.clock();
    }

    public boolean getVSync() {
        return this.inVSync;
    }

    void checkSlider() {
        if (this.slider == null) {
            this.slider = new Slider();
            this.slider.setVisible(true);
            this.slider.slider.setMaximum(768);
            this.slider.slider.setMinimum(0);
        }
    }

    protected void endHSync() {
        if (this.outHSync) {
            this.modeCheck();
            super.hSyncEnd();
        }
        this.outHSync = false;
    }

    @Override
    public void modeCheck() {
        this.screenMode = this.newMode;
        this.setScreenMode(this.screenMode & 3);
    }

    public int getScroll() {
        return verticalScroll;
    }

    public void ASIC_SetSoftScrollRegister(int value) {
        SoftScrollRegister = value & 0xFF;
        this.horizontalScroll = SoftScrollRegister & 0xF;
        verticalScroll = SoftScrollRegister >> 4 & 7;
        this.crtc.setVerticalScroll(verticalScroll);
        Display.vscroll = "" + verticalScroll + " - " + this.horizontalScroll;
        this.isHScroll = this.horizontalScroll != 0;
    }

    @Override
    public void hSyncStart() {
        this.hSyncCount = 0;
        this.inHSync = true;
        this.renderer = this.syncRenderer;
    }

    @Override
    public void hSync() {
        this.ymax = Basic6845.getR(6) * 8 + this.ymin;
        this.render = this.rendering && this.monitorLine >= -4 && this.monitorLine < 268;
        if (this.render) {
            this.offset = this.scanStart;
            this.scanStart += 768;
            if ((SoftScrollRegister & 0x80) << 1 == 0) {
                this.borderpixel = this.pixels[1];
            }
        }
        if (this.vSyncCount > 0 && --this.vSyncCount == 0) {
            super.vSyncEnd();
        }
        this.scanStarted = false;
    }

    void GateArray_Interrupt() {
        if (GateArray.cpc.memory.plus) {
            if (!cpc.getAsic().ASIC_RasterIntEnabled()) {
                cpc.getAsic().ASIC_SetRasterInterrupt();
                z80.Z80_SetInterruptRequest();
            }
            return;
        }
        z80.Z80_SetInterruptRequest();
    }

    @Override
    public void hSyncEnd() {
        this.debug = cpc.getMode() != 3;
        this.endHSync();
        if (this.InterruptSyncCount == 0) {
            if (++this.InterruptLineCount == 52) {
                this.InterruptLineCount = 0;
                this.GateArray_Interrupt();
                this.GateArray_RasterInterruptRequest = true;
            }
        } else if (this.InterruptSyncCount > 0 && --this.InterruptSyncCount == 0) {
            if (this.InterruptLineCount >= 32) {
                this.GateArray_Interrupt();
                this.GateArray_RasterInterruptRequest = true;
            }
            this.InterruptLineCount = 0;
        }
        this.renderer = this.vSyncCount > 0 ? this.syncRenderer : (this.crtc.isVDisp() && this.crtc.isHDisp() ? this.defRenderer : this.borderRenderer);
    }

    @Override
    public void hDispEnd() {
        this.renderer = this.vSyncCount > 0 || this.crtc.isHSync() ? this.syncRenderer : this.borderRenderer;
    }

    @Override
    public void hDispStart() {
        this.renderer = this.vSyncCount > 0 || this.crtc.isHSync() ? this.syncRenderer : (this.crtc.isVDisp() ? this.defRenderer : this.borderRenderer);
    }

    public void setMonitorLine(int value) {
        this.offset += value * 768;
    }

    public int getLine() {
        return this.monitorLine;
    }

    @Override
    public void vSyncStart() {
        super.vSyncStart();
        this.modeCheck();
        this.vSyncCount = 32;
        this.renderer = this.syncRenderer;
        this.InterruptSyncCount = 2;
        if (this.isBorder == null) {
            return;
        }
        this.ymin = Basic6845.getR(4) - Basic6845.getR(7) - 3;
        this.ymin *= 8;
        if ((this.ymin & 0x100) == 256) {
            this.ymin |= 0xFF00;
        }
        if ((this.ymin & 0x8000) != 0) {
            this.ymin = -(0 - this.ymin & 0x3F);
        }
        int d = 0;
        for (int i = 0; i < this.isBorder.length; i += 4) {
            if (this.isBorder[i]) continue;
            d = i / 768;
            break;
        }
        if (this.ymin >= 0 && d > this.ymin) {
            this.ymin = d;
        }
    }

    @Override
    public void vSyncEnd() {
        this.modeCheck();
    }

    @Override
    public int[] getField() {
        this.result[0] = this.xmin;
        this.result[1] = this.xmax;
        this.result[2] = this.ymin * 2;
        this.result[3] = this.ymax * 2;
        return this.result;
    }

    boolean isScroll() {
        return (SoftScrollRegister & 0x80) << 1 != 0;
    }

    protected void putPixel(int pos, int value) {
        int i;
        if (this.display.DEBUG_SPRITES) {
            this.display.ppixels[pos] = 0;
        }
        if (this.spritemem == null) {
            this.spritemem = (CPCMemory)cpc.getMemory();
        }
        this.poff = pos;
        if (pos == 0) {
            for (i = 0; i < 16; ++i) {
                this.delay[i] = false;
                if (!this.display.DEBUG_SPRITES) continue;
                this.spritemem.putSpriteImg(i);
            }
        }
        if (pos % 768 == 0) {
            this.skippixel = true;
        }
        if (pos % 32 == 0 && !cpc.getAsic().isLocked() && this.renderer == this.defRenderer) {
            for (i = 0; i < 16; ++i) {
                if (this.xm[i] == 0) continue;
                this.setSpriteCoords(i);
            }
            this.simplesprite = this.simplesprites;
            if (!this.display.large) {
                this.simplesprite = true;
            }
        }
        this.pixels[pos += this.screenMode == 2 ? 0 : this.horizontalScroll] = value;
        if (pos % 768 < this.xmin + 16 && this.isScroll()) {
            this.pixels[pos] = inks[this.bink];
            return;
        }
        if (pos % 768 > this.xmax && this.isScroll()) {
            this.pixels[pos] = inks[this.bink];
            return;
        }
        if (this.renderer == this.borderRenderer && this.DEBUG_BORDER) {
            if (pos == 0) {
                this.dev = this.getBorder();
            }
            if (this.pixels[pos] == this.dev) {
                int n = this.pixels[pos] = pos % 8 < 4 ? 0xFF0000 : 0;
            }
        }
        if (!this.nosprites && this.renderer != this.borderRenderer && !cpc.getAsic().isLocked()) {
            if (this.simplesprite) {
                boolean bl = this.skippixel = !this.skippixel;
            }
            if (this.skippixel || !this.simplesprite) {
                this.drawSprite(this.poff);
            }
        }
    }

    public void drawSprite(int pos) {
        this.bpixelx = pos % 768 + 1;
        this.bpixely = pos / 768 + 1;
        this.spriteIndex = 15;
        while (this.spriteIndex >= 0) {
            if (this.xm[this.spriteIndex] != 0) {
                this.yz[this.spriteIndex] = this.ym[this.spriteIndex] << 4;
                this.xz[this.spriteIndex] = this.xm[this.spriteIndex] << 4;
                if (this.xpos[this.spriteIndex] >= this.bpixelx - this.xz[this.spriteIndex] && this.xpos[this.spriteIndex] < this.bpixelx && this.ypos[this.spriteIndex] >= this.bpixely - this.yz[this.spriteIndex] && this.ypos[this.spriteIndex] < this.bpixely) {
                    this.spx = this.xpos[this.spriteIndex] - (this.bpixelx - this.xz[this.spriteIndex]);
                    this.spy = this.ypos[this.spriteIndex] - (this.bpixely - this.yz[this.spriteIndex]);
                    this.spx /= this.xm[this.spriteIndex];
                    this.spy /= this.ym[this.spriteIndex];
                    this.spritePixel[this.spriteIndex] = this.getSpritePixel(this.spx, this.spy, this.spriteIndex);
                    int n = this.pixels[pos] = this.spritePixel[this.spriteIndex] != -1234567890 ? this.spritePixel[this.spriteIndex] : this.pixels[pos];
                    if (this.skippixel && this.simplesprite) {
                        this.pixels[pos - 1] = this.pixels[pos];
                    }
                    if (this.display.DEBUG_SPRITES) {
                        int n2 = this.display.ppixels[pos] = this.spritePixel[this.spriteIndex] != -1234567890 ? -16777216 + this.spritePixel[this.spriteIndex] : this.display.ppixels[pos];
                        if (this.skippixel && this.simplesprite) {
                            this.display.ppixels[pos - 1] = this.display.ppixels[pos];
                        }
                    }
                    this.rendered[pos] = true;
                }
            }
            --this.spriteIndex;
        }
    }

    public int getSprX(int index) {
        return this.xpos[index];
    }

    public int getSprY(int index) {
        return this.ypos[index];
    }

    void setSpriteCoords(int index) {
        this.reg9 = this.crtc.getReg(9);
        this.xpos[index] = this.crtc.getReg(0) < 32 && this.reg9 != 7 ? (this.spritemem.getSpriteX(index) + (this.offset % 768 & 0xFFFFFF00)) % 768 : this.spritemem.getSpriteX(index) + this.xmin;
        if (this.reg9 != 7) {
            this.ypos[index] = this.spritemem.getSpriteY(index) + this.offset / 768;
            this.delay[index] = true;
        } else if (!this.delay[index]) {
            this.ypos[index] = this.spritemem.getSpriteY(index) + this.ymin;
        }
    }

    int getSpritePixel(int x, int y, int i) {
        if (x < 0 || x > 15 || y < 0 || y > 15) {
            return -1234567890;
        }
        return this.spritemem.getSpriteColor(i, 15 - x, 15 - y);
    }

    @Override
    public void vSync(boolean interlace) {
        for (int i = 0; i < this.rendered.length; ++i) {
            this.rendered[i] = false;
        }
        int off = 0;
        int line = 0;
        for (int i = 0; i < this.pixels.length; ++i) {
            if (++off == 768) {
                off = 0;
                ++line;
            }
            if (!this.isBorder[i]) break;
        }
        off = 0;
        line = 0;
        this.xmin = (50 - Basic6845.getR(2)) * 16;
        this.r3 = Basic6845.getR(3) & 0xF;
        if (this.r3 < 6) {
            this.xmin += this.r3 * 8;
        }
        this.r3 = Basic6845.getR(0) - 63;
        this.xmin += this.r3 * 16;
        this.xmax = this.xmin + Basic6845.getR(1) * 16;
        this.offset = 0;
        this.scanStart = 0;
        cpc.vSync();
        this.maxline = 0;
    }

    @Override
    public void vSync() {
        for (int i = 0; i < this.rendered.length; ++i) {
            this.rendered[i] = false;
        }
        this.scanStart = 0;
        try {
            cpc.vSync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void vDispStart() {
    }

    public void setMemory(byte[] value) {
        screenmemory = value;
    }

    public void setRendering(boolean value) {
        this.rendering = value;
        if (!this.rendering) {
            this.scanStarted = false;
            this.render = false;
        }
    }

    public Dimension getDisplaySize(boolean large) {
        return large ? this.FULL_DISPLAY_SIZE : this.HALF_DISPLAY_SIZE;
    }

    @Override
    public void cursor() {
    }

    protected void shiftArray(byte[] bytes, int shift) {
        for (int i = 0; i < shift; ++i) {
            byte last = bytes[bytes.length - 1];
            System.arraycopy(bytes, 0, bytes, 1, bytes.length - 2);
            bytes[0] = last;
        }
    }

    int getX() {
        return this.offset % 768;
    }

    public void resetInks() {
        for (int i = 0; i < 17; ++i) {
            this.setInk(i, GateArray.getInks(i));
        }
    }

    public void resetInkss() {
        for (int i = 0; i < 17; ++i) {
            this.setInk(i, i);
        }
    }

    public void init() {
        this.crtc.init();
    }

    @Override
    public int PEEK(int address) {
        return cpc.PEEK(address);
    }

    @Override
    public void POKE(int address, int value) {
        cpc.POKE(address, value);
    }

    public static int putRGB(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public boolean getOut() {
        return this.endPix != 0;
    }

    public int getLineNumber() {
        return this.crtc.getLineNumber();
    }

    static {
        int mode;
        decoder = new GraphicsDecoder();
        returnmode = 0;
        rambank = 0;
        smode = 1;
        inks = new int[33];
        maTranslate = new int[65536];
        CPCInks = new int[33];
        CPCInksb = new int[33];
        GAInks = new int[]{13, 27, 19, 25, 1, 7, 10, 16, 28, 29, 24, 26, 6, 8, 15, 17, 30, 31, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
        Inks = new int[]{20, 4, 21, 28, 24, 29, 12, 5, 13, 22, 6, 23, 30, 0, 31, 14, 7, 15, 18, 2, 19, 26, 25, 27, 10, 3, 11};
        fullMaps = new byte[4][];
        modeTab = new int[4][256];
        for (mode = 0; mode < 4; ++mode) {
            block7: for (int i = 0; i < 256; ++i) {
                switch (mode) {
                    case 0: {
                        GateArray.modeTab[0][i] = (i & 0x80) >> 7 | (i & 8) >> 2 | (i & 0x20) >> 3 | (i & 1) << 2;
                        continue block7;
                    }
                    case 1: {
                        GateArray.modeTab[1][i] = (i & 0x80) >> 7 | (i & 8) >> 2;
                        continue block7;
                    }
                    case 2: {
                        GateArray.modeTab[2][i] = (i & 0x80) >> 7;
                        continue block7;
                    }
                    case 3: {
                        GateArray.modeTab[3][i] = (i & 0x80) >> 7 | (i & 8) >> 2 | (i & 0x20) >> 3 | (i & 1) << 2;
                    }
                }
            }
        }
        for (mode = 0; mode < 4; ++mode) {
            byte[] full = new byte[0x100000];
            GateArray.fullMaps[mode] = full;
            for (int i = 0; i < 524288; i += 4) {
                int b1 = i >> 11 & 0xFF;
                int b2 = i >> 3 & 0xFF;
                decoder.decodeFull(full, i * 2, mode, b1);
                decoder.decodeFull(full, (i += 4) * 2, mode, b2);
            }
        }
        for (int i = 0; i < maTranslate.length; ++i) {
            int j = i << 1;
            GateArray.maTranslate[i] = j & 0x7FE | (j & 0x6000) << 1;
        }
        original = new int[]{0x636363, 0x636363, 65379, 0xFFFF63, 99, 16711779, 25443, 0xFF6363, 16711779, 0xFFFF63, 0xFFFF00, 0xFEFEFE, 0xFF0000, 0xFF00FF, 16737024, 0xFF63FF, 99, 65379, 65280, 65535, 0, 255, 25344, 25599, 0x630063, 0x63FF63, 6553344, 0x63FFFF, 0x630000, 6488319, 0x636300, 0x6363FF};
        SOFT_SCROLL_MASK = new int[]{12, 14, 15, 12};
    }

    protected class FullEndRenderer
    extends Renderer {
        protected FullEndRenderer() {
        }

        @Override
        public void render() {
            try {
                if (GateArray.this.renderer == GateArray.this.borderRenderer) {
                    int pix = inks[16];
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = true;
                        if (GateArray.this.offset >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, pix);
                    }
                } else if (GateArray.this.renderer == GateArray.this.defRenderer) {
                    int val = (GateArray.this.screenData >> (GateArray.this.screenMode != 2 ? 0 : GateArray.this.horizontalScroll & SOFT_SCROLL_MASK[GateArray.this.screenMode]) & 0xFFFF) << 4;
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = false;
                        if (GateArray.this.offset >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, inks[GateArray.this.fullMap[val++]]);
                    }
                } else {
                    int pix = inks[32];
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = false;
                        if (GateArray.this.offset >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, pix);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class FullStartRenderer
    extends Renderer {
        protected FullStartRenderer() {
        }

        @Override
        public void render() {
            try {
                GateArray.this.endPix = 16 - (GateArray.this.hPos - 686080 >> 12 & 0xF);
                if (GateArray.this.renderer == GateArray.this.borderRenderer) {
                    int pix = inks[16];
                    for (int i = GateArray.this.endPix; i < 16; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = true;
                        if (GateArray.this.offset >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, pix);
                    }
                } else if (GateArray.this.renderer == GateArray.this.defRenderer) {
                    int val = (GateArray.this.screenData >> (GateArray.this.screenMode != 2 ? 0 : GateArray.this.horizontalScroll & SOFT_SCROLL_MASK[GateArray.this.screenMode]) & 0xFFFF) << 4 + GateArray.this.endPix;
                    for (int i = GateArray.this.endPix; i < 16; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = false;
                        if (GateArray.this.offset >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, inks[GateArray.this.fullMap[val++]]);
                    }
                } else {
                    int pix = inks[32];
                    for (int i = GateArray.this.endPix; i < 16; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = false;
                        if (GateArray.this.offset >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, pix);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class FullRenderer
    extends Renderer {
        protected FullRenderer() {
        }

        @Override
        public void render() {
            if (GateArray.this.isBorder == null || GateArray.this.isBorder.length < 1) {
                GateArray.this.isBorder = new boolean[GateArray.this.pixels.length];
            }
            int val = (GateArray.this.screenData >> (GateArray.this.screenMode != 2 ? 0 : GateArray.this.horizontalScroll & SOFT_SCROLL_MASK[GateArray.this.screenMode]) & 0xFFFF) << 4;
            for (int i = 0; i < 16; ++i) {
                GateArray.this.isBorder[GateArray.this.offset] = false;
                if (GateArray.this.offset >= GateArray.this.pixels.length) continue;
                GateArray.this.putPixel(GateArray.this.offset++, inks[GateArray.this.fullMap[val++]]);
            }
        }
    }

    protected class BorderRenderer
    extends Renderer {
        protected int ink;
        protected int width;

        public BorderRenderer(int ink, int width) {
            this.ink = ink;
            this.width = width;
        }

        @Override
        public void render() {
            if (GateArray.this.pixels == null) {
                return;
            }
            if (GateArray.this.isBorder == null || GateArray.this.isBorder.length < 1) {
                GateArray.this.isBorder = new boolean[GateArray.this.pixels.length];
            }
            int pix = inks[this.ink];
            try {
                for (int i = 0; i < this.width; ++i) {
                    if (GateArray.this.offset < GateArray.this.pixels.length) {
                        GateArray.this.putPixel(GateArray.this.offset, pix);
                    }
                    GateArray.this.isBorder[GateArray.this.offset] = true;
                    ++GateArray.this.offset;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract class Renderer {
        protected Renderer() {
        }

        public void render() {
        }
    }
}

