/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.FlatIconButtonUI;
import net.infonode.gui.UIManagerUtil;
import net.infonode.gui.border.HighlightBorder;
import net.infonode.util.ColorUtil;

public class ButtonFactory {
    private static final Border normalBorder = new CompoundBorder(new LineBorder(new Color(70, 70, 70)), new CompoundBorder(new HighlightBorder(), new EmptyBorder(1, 6, 1, 6)));
    private static final Border pressedBorder = new CompoundBorder(new LineBorder(new Color(70, 70, 70)), new CompoundBorder(new HighlightBorder(true), new EmptyBorder(2, 7, 0, 5)));

    private ButtonFactory() {
    }

    private static JButton initButton(final JButton button) {
        button.setMargin(null);
        button.setBorder(normalBorder);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                button.setBorder(pressedBorder);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                button.setBorder(normalBorder);
            }
        });
        return button;
    }

    private static JButton newButton(String text) {
        return ButtonFactory.initButton(new JButton(text));
    }

    private static JButton newButton(Icon icon) {
        return ButtonFactory.initButton(new JButton(icon));
    }

    private static JButton newButton(Icon icon, String text) {
        return ButtonFactory.initButton(new JButton(text, icon));
    }

    public static final JButton createDialogButton(String text, ActionListener action) {
        JButton b = new JButton(text);
        b.setFont(b.getFont().deriveFont(1));
        b.addActionListener(action);
        return b;
    }

    public static final JButton createButton(String text, ActionListener action) {
        return ButtonFactory.createButton(text, true, action);
    }

    public static final JButton createButton(String text, boolean opaque, ActionListener action) {
        JButton b = ButtonFactory.newButton(text);
        b.setOpaque(opaque);
        b.addActionListener(action);
        return b;
    }

    public static final JButton createButton(String iconResource, String text, ActionListener action) {
        URL iconURL = ButtonFactory.class.getClassLoader().getResource(iconResource);
        return ButtonFactory.createButton(iconURL == null ? null : new ImageIcon(iconURL), text, action);
    }

    public static final JButton createButton(Icon icon, String text, ActionListener action) {
        JButton b;
        if (icon != null) {
            b = ButtonFactory.newButton(icon);
            b.setToolTipText(text);
        } else {
            b = ButtonFactory.newButton(text);
        }
        b.addActionListener(action);
        return b;
    }

    public static final JButton createButton(Icon icon, String tooltipText, boolean opaque, ActionListener action) {
        JButton b = ButtonFactory.newButton(icon);
        b.setToolTipText(tooltipText);
        b.addActionListener(action);
        b.setOpaque(opaque);
        return b;
    }

    public static final JButton createFlatHighlightButton(Icon icon, String tooltipText, int padding, ActionListener action) {
        JButton b = new JButton(icon){

            @Override
            public void setUI(ButtonUI ui) {
                super.setUI(new FlatIconButtonUI());
            }
        };
        b.setVerticalAlignment(0);
        b.setToolTipText(tooltipText);
        b.setMargin(new Insets(0, 0, 0, 0));
        new ButtonHighlighter(b, padding);
        b.setRolloverEnabled(true);
        if (action != null) {
            b.addActionListener(action);
        }
        return b;
    }

    public static final void applyButtonHighlighter(JButton b, int padding) {
        b.setVerticalAlignment(0);
        b.setMargin(new Insets(0, 0, 0, 0));
        new ButtonHighlighter(b, padding);
        b.setRolloverEnabled(true);
    }

    public static final JButton createFlatHighlightButton(Icon icon, String tooltipText, int padding, boolean focusable, ActionListener action) {
        JButton b = ButtonFactory.createFlatHighlightButton(icon, tooltipText, padding, action);
        b.setFocusable(focusable);
        return b;
    }

    public static final JButton createHighlightButton(String text, ActionListener action) {
        JButton b = ButtonFactory.newButton(text);
        b.addActionListener(action);
        return b;
    }

    public static final JButton createHighlightButton(Icon icon, ActionListener action) {
        JButton b = ButtonFactory.newButton(icon);
        b.addActionListener(action);
        return b;
    }

    public static final JButton createHighlightButton(Icon icon, String text, ActionListener action) {
        JButton b = ButtonFactory.newButton(icon, text);
        b.addActionListener(action);
        return b;
    }

    public static final JButton createFlatIconHoverButton(Icon icon, Icon hovered, Icon pressed) {
        JButton b = new JButton(icon){

            @Override
            public void setUI(ButtonUI ui) {
                super.setUI(new FlatIconButtonUI());
            }
        };
        b.setPressedIcon(pressed);
        b.setRolloverEnabled(true);
        b.setRolloverIcon(hovered);
        b.setVerticalAlignment(0);
        return b;
    }

    private static class ButtonHighlighter
    implements ComponentListener,
    HierarchyListener {
        private JButton button;
        private Border pressedBorder;
        private Border highlightedBorder;
        private Border normalBorder;
        private boolean rollover;
        private long rolloverStart;

        ButtonHighlighter(JButton button, int padding) {
            this.button = button;
            this.normalBorder = new EmptyBorder(padding + 2, padding + 2, padding + 2, padding + 2);
            this.pressedBorder = new EmptyBorder(padding + 2, padding + 2, padding, padding);
            this.highlightedBorder = new EmptyBorder(padding + 1, padding + 1, padding + 1, padding + 1);
            button.setContentAreaFilled(false);
            this.setNormalState();
            button.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    rollover = System.currentTimeMillis() - rolloverStart > 20L && button.getModel().isRollover();
                    this.update();
                    if (button.getModel().isRollover()) {
                        rolloverStart = 0L;
                    }
                }
            });
            button.addHierarchyListener(this);
            button.addComponentListener(this);
        }

        private void setNormalState() {
            this.button.setBackground(null);
            this.button.setOpaque(false);
            this.button.setBorder(this.normalBorder);
            this.rollover = false;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        private void update() {
            boolean pressed = this.button.getModel().isArmed();
            if (this.button.isEnabled() && (this.rollover || pressed)) {
                this.button.setOpaque(true);
                Color backgroundColor = ComponentUtil.getBackgroundColor(this.button.getParent());
                backgroundColor = backgroundColor == null ? UIManagerUtil.getColor("control", Color.LIGHT_GRAY) : backgroundColor;
                this.button.setBackground(ColorUtil.mult(backgroundColor, pressed ? 0.8 : 1.15));
                this.button.setBorder(pressed ? new CompoundBorder(new LineBorder(ColorUtil.mult(backgroundColor, 0.3)), this.pressedBorder) : new CompoundBorder(new LineBorder(ColorUtil.mult(backgroundColor, 0.5)), this.highlightedBorder));
            } else {
                this.setNormalState();
            }
        }
    }
}

