;-----------------------------------------------------------------------------;
;		  T H E   R A V E N   P C   S O F T W A R E		      ;
;-----------------------------------------------------------------------------;
; Programm	: Simple intro							      ;
; Part		: -							      ;
; Function	: -							      ;
; File type	: .ASM							      ;
; Processor	: 286 and higher					      ;
; Author(s)	: The Brain (P.S.Heijnen)				      ;
; Assistance	: -							      ;
; Version	: 1.0							      ;
; Creation date	: 24-10-1992						      ;
; Last update	: 26-10-1992						      ;
;-----------------------------------------------------------------------------;
		.286
		.MODEL	TINY
		.STACK	100h
		EXTRN	Plaatje : FAR, Font : FAR

; Constants -------------------------------------------------------------------
;
BytesPerLine	equ	80	; Bytes in on one line (80 for 640x200x16 mode)
ScreenHeight	equ	200	; screen is 200 pixels high

; The main programm -----------------------------------------------------------
;
		.CODE
Start:		mov	ah,15			; Store active screen mode
		int	10h
		push	ax
		mov	ax,000Eh		; Set 640*200*16 mode
		int	10h
		push	cs			; DS=CS
		pop	ds
		call	SetPicture
		call	Welcome
		call	ShowRaven
		call	MakeUnder
		call	MainScroll
		pop	ax			; Restore screen mode
		xor	ah,ah
		int	10h
		mov	ah,4Ch			; Return to OS
		int	21h

; Set picture ready -----------------------------------------------------------
;
SetPicture:	mov	ax,0A000h+ScreenHeight*BytesPerLine/16
		mov	es,ax			; ES = logo segment
		call	ClrScr			; Clear logo area
		mov	ax,seg Plaatje		; DS = picture segment
		mov	ds,ax
		mov	si,offset Plaatje	; Copy picture => logo area
		xor	di,di
		mov	bl,10000000b
		mov	cx,320*158/2		; Size of logo = 320 x 158
SetPicture1:	push	cx
		lodsb
		push	ax
		mov	cl,4			; Show high nibble 2 times
		shr	al,cl
		push	ax
		call	SetPicture3
		pop	ax
		call	SetPicture3
		pop	ax
		and	al,15			; Show low nibble 2 times
		push	ax
		call	SetPicture3
		pop	ax
		call	SetPicture3
		pop	cx
		loop	SetPicture1
		push	ds			; Convert nibble font to byte
		pop	es			; font (expand)
		mov	si,offset Font+320*160/2-1
		mov	di,offset Font+320*160-2
		mov	cx,320*160/2
		std
SetPicture2:	lodsb
		mov	ah,al
		and	ah,15			; AH = low nibble
		shr	al,1			; AL = high nibble
		shr	al,1
		shr	al,1
		shr	al,1
		stosw				; Store both
		loop	SetPicture2
		cld
		ret
SetPicture3:	push	ax
		mov	al,8			; Set bit mask
		mov	ah,bl
		out	dx,ax
		mov	al,es:[di]		; Read latches
		pop	ax			; Write color
		stosb
		ror	bl,1			; Next bit
		adc	di,-1			; Restore address when needed
		ret
		
; Show 'The Raven' logo -------------------------------------------------------
;
ShowRaven:	mov	si,offset RavenCol	; Set colors for The Raven logo
		mov	cx,7*3
		mov	al,1
		call	DumpColors
		mov	bx,49*BytesPerLine	; Position logo
		mov	cx,12*16+1		; Position text
ShowRaven1:	call	NewTrace		; Wait for vertical retrace
		mov	ax,bx			; Set logo position
		call	SetBase
		cmp	cx,ScreenHeight*2	; Text below screen?
		jae	ShowRaven2		; Yes => don't move text
		mov	ax,cx			; Set Text position
		push	cx
		call	SetSplit
		pop	cx
		add	cx,2			; Text position+2 (down)
ShowRaven2:	add	bx,BytesPerLine		; Logo position 1 line up
		cmp	bx,(ScreenHeight-ScrollHeight-4)*BytesPerLine
		jb	ShowRaven1
		ret
		
; ----------------------------- WELCOME TEXT ----------------------------------
;
Welcome:	mov	ax,0A000h		; ES = video segment
		mov	es,ax
		push	cs			; DS = CS
		pop	ds
		mov	si,offset WelcomeText	; DS:SI = offset welcome text
		call	Welcome11		; All colors set to black
Welcome1:	mov	bh,1			; Show string
		call	TinyString
		jc	Welcome3		; Stop when end encountered
		push	si			; Fade effect
		call	Welcome5
		pop	si
		call	ClrScr			; Clear screen
		jmp	Welcome1
Welcome2:	xor	ah,ah			; Fetch key
		int	16h
		call	Welcome11		; Black screen
		call	ClrScr			; Clear screen
		pop	ax
		pop	ax
		pop	ax
Welcome3:	mov	si,offset WelcomeTxt2	; Show last line
		mov	bh,1
		call	TinyString
		mov	ax,12*16+1		; Split in middle of screen
		call	SetSplit
		mov	ax,BytesPerLine*88	; Base set to area 
		call	SetBase
		mov	bx,100h
		call	Welcome8
		mov	cx,200			; Wait a few seconds
Welcome4:	call	NewTrace
		loop	Welcome4
		ret
Welcome5:	mov	cl,25
		call	Welcome6
		neg	bh
		mov	cl,150
		call	Welcome7
		ret
Welcome6:	mov	bx,100h
Welcome7:	call	NewTrace
		mov	ah,1
		int	16h
		jnz	Welcome2
		xor	ch,ch
		loop	Welcome7
Welcome8:	mov	cx,64
Welcome9:	add	bl,bh
		push	cx
		call	NewTrace
		mov	dx,3C8h
		mov	al,16
		out	dx,al
		inc	dx
		mov	si,offset WelcomeCol
		mov	cx,8
Welcome10:	push	cx
		lodsb
		mul	bl
		mov	cl,6
		shr	ax,cl
		out	dx,al
		out	dx,al
		out	dx,al
		pop	cx
		loop	Welcome10
		pop	cx
		loop	Welcome9
		ret
Welcome11:	mov	dx,3C8h
		xor	al,al
		out	dx,al
		inc	dx
		mov	cx,24*3
Welcome12:	out	dx,al
		loop	Welcome12
		ret

; Scroll routine for the Raven ------------------------------------------------
;
MainScroll:	in	al,60h
		mov	bx,1
		cli
MainScroll1:	push	ax
		push	bx
		push	bx
		call	WaitTrace
		mov	si,CurCol
		mov	al,1
		mov	cx,7*3
		call	DumpColors
		mov	cl,70
		pop	bx
MainScroll2:	mov	dx,3C8h
		mov	al,0
		out	dx,al
		inc	dx
		mov	al,bh
		out	dx,al
		out	dx,al
		out	dx,al
		mov	dl,0DAh
MainScroll3:	in	al,dx
		test	al,1
		jnz	MainScroll3
		add	bh,bl
		cmp	bh,60
		jb	MainScroll4
		neg	bl
		add	bh,bl
		add	bh,bl
MainScroll4:	in	al,dx
		and	al,1
		jz	MainScroll4
		loop	MainScroll2
		xor	al,al
		mov	si,offset RavenCol-3
		mov	cl,8*3
		call	DumpColors
		call	DoUnder
		call	ScrollMain
		pop	bx
		add	bh,bl
		cmp	bh,60
		jb	MainScroll5
		neg	bl
		add	bh,bl
		add	bh,bl
MainScroll5:	pop	cx
		in	al,60h
		cmp	al,cl
		je	MainScroll1
		sti
		ret


; Show tiny string ------------------------------------------------------------
; in:	DS:SI = offset
;	BH = size : 0=normal, 1=wide(2x)
; out:	nop
; mod:	AX, BL, CX, DX, SI, DI, flags
;
TinyString:	lodsw
		or	ax,ax
		stc
		jz	TinyString2
		mov	dx,ax
TinyString1:	lodsb
		or	al,al
		jz	TinyString2
		call	TinyChar
		inc	dl
		jmp	TinyString1
TinyString2:	ret


; Place tiny letter at specified postion --------------------------------------
; in:	DL, DH = position
;	    AL = character code (32-96)
;	    BH = size : 0=normal, 1=wide(2x)
; out:	nop
; mod:	AX, BL, CX, DI, flags
;
TinyChar:	push	dx
		push	si
		mov	si,dx
		mov	di,ax
		mov	al,dh			; DI = 8 * DH * BytesPerLine
		cbw
		mov	dx,BytesPerLine*8
		mul	dx
		xchg	di,ax
		sub	al,32			; AL = char code - 32
		cbw				; SI = AL * 64 + offset TinyDat
		mov	cx,6
		shl	ax,cl
		add	ax,offset TinyDat
		xchg	si,ax
		cbw				; AX=DL
		or	bh,bh
		jz	TinyChar0
		add	ax,ax
TinyChar0:	add	di,ax
		mov	ah,128
		mov	dx,3CEh
		mov	bl,8
		or	bh,bh
		jz	TinyChar1
		add	bl,bl
TinyChar1:	mov	cl,8
		mov	al,cl			; Set bit mask
		out	dx,ax
TinyChar2:	mov	al,es:[di]		; Read latches
		movsb				; Move pixel
		add	di,BytesPerLine-1
		loop	TinyChar2
		sub	di,8*BytesPerLine
		ror	ah,1
		adc	di,0
		or	bh,bh
		jz	TinyChar3
		test	ah,55h
		jz	TinyChar3
		sub	si,8
TinyChar3:	dec	bl
		jnz	TinyChar1
		pop	si
		pop	dx
		ret


; Scroll routines + data ------------------------------------------------------
;
ScrollHeight	equ	32		; Karakters zijn 32 pixels groot
ScrollWidth	equ	32		; Karakters zijn 32 pixels breed
ScrollLine	equ	163		; Beginlijn van scroll tekst
ScrollCnt	db	1
ScrollAdr	dw	0
ScrollPnt	dw	offset ScrollText
ScrollID	db	47


; Scroll main routine ---------------------------------------------------------
; in:	ES = video segment
; out:	nop
; mod:
;
ScrollMain:	call	Scroll8


; Scroll nieuwe regel naar binnen ---------------------------------------------
; in:	ES = video segment
; out:	nop
; mod:
;
		push	ds
		call	ScrollChar		; Lees nieuwe adres
		mov	ax,seg Font		; DS => font gebied
		mov	ds,ax
		mov	dx,3CEh
		mov	ax,0205h		; Read mode 0, write mode 2
		out	dx,ax
		mov	ax,0003h		; Vervang pixels
		out	dx,ax
		mov	bl,128
		mov	di,(ScrollLine+1)*BytesPerLine-1
ScrollCol0:	mov	ah,bl			; Set mask bit
		mov	al,8
		out	dx,ax
		mov	cx,ScrollHeight
ScrollCol1:	mov	al,es:[di]		; Stel latches in
		movsb				; Stel kleur in (rechts)
		add	di,BytesPerLine-1
		loop	ScrollCol1
		sub	di,ScrollHeight*BytesPerLine
		shr	bl,1
		jnz	ScrollCol0
		pop	ds
		mov	ScrollAdr,si
		ret


; Bepaal adres van huidige pixel patroon --------------------------------------
; in:	nop
; out:	DS:SI = pointer
; mod:	AX, DX, flags
;
ScrollChar:	mov	si,ScrollAdr
		dec	ScrollCnt
		jnz	ScrollChar2
		cmp	ScrollID,47
		jne	ScrollChar3
		mov	ScrollCnt,ScrollWidth/8
		mov	si,ScrollPnt
ScrollChar0:	lodsb
		or	al,al
		jnz	ScrollChar1
		mov	si,offset ScrollText
		lodsb
ScrollChar1:	cmp	al,200
		jb	ScrollChar11
		sub	al,200
		mov	ah,21
		mul	ah
		add	ax,offset ColTab
		mov	CurCol,ax
		jmp	short ScrollChar0
ScrollChar11:	mov	ScrollPnt,si
		dec	al
ScrollChar15:	mov	ScrollID,al
		mov	dx,1024
		xor	ah,ah
		mul	dx
		mov	si,ax
		add	si,offset Font
ScrollChar2:	ret
ScrollChar3:	inc	ScrollCnt
		mov	al,47
		jmp	short ScrollChar15

		
; Verplaats tekst 8 pixels naar links -----------------------------------------
; in:	ES = video segment
; out:	nop
; mod:	ax, cx, dx, si, di, flags
;
Scroll8:	mov	dx,3CEh
		mov	ax,0FF08h	; Mask non of the bits
		out	dx,ax
		mov	ax,0105h	; Set write mode 1, read mode 0
		out	dx,ax
		mov	si,ScrollLine*BytesPerLine+1
		mov	di,ScrollLine*BytesPerLine
		mov	cx,ScrollHeight*BytesPerLine-1
		push	ds
		push	es
		pop	ds
		rep	movsb
		pop	ds
		ret


; Routines for text box under the picture -------------------------------------
;
UnderHeight	equ	11	; This constant determines the hight of the
				; lower text. It must be equal or greater than
				; the highest line number you used!
UnderWait	dw	500	; Timer
UnderLoc	dw	400	; Current text position
UnderDir	db	0	; Direction of text movement


; Set text under logo ready for use -------------------------------------------
; in:	nop
; out:	nop
; mod:	AX, BX, CX, DX, SI, DI, ES, flags
;
MakeUnder:	mov	ax,0A000h		; ES = video segment
		mov	es,ax
		call	ClrScr			; Clear Screen
		mov	al,15			; Show bar above text
		mov	bl,4
		mov	di,2*BytesPerLine
MakeUnder1:	mov	cx,BytesPerLine
		rep	stosb
		sub	al,2
		dec	bl
		jnz	MakeUnder1
		mov	al,9			; Show bar below text
		mov	bl,4
		mov	di,BytesPerLine*(UnderHeight*8+10)
MakeUnder2:	mov	cx,BytesPerLine
		rep	stosb
		add	al,2
		dec	bl
		jnz	MakeUnder2
		mov	si,offset UnderText	; Show title line
		mov	bh,1			; (1 => enlarged)
		call	TinyString
		xor	bh,bh			; Show rest of the text
MakeUnder3:	call	TinyString
		jnc	MakeUnder3		; Repeat until 0,0 encountered
DoUnder4:	ret


; Service routine for text under logo (during scroll) -------------------------
; in:	nop
; out:	nop
; mod:	AX, DX, flags
;
DoUnder:	mov	dx,UnderLoc		; DX = current position of text
		mov	al,UnderDir		; AX = direction (-2, 0, 2)
		cbw
		or	ax,ax			; Move when needed
		jnz	DoUnder1
		dec	UnderWait		; Wait...
		jnz	DoUnder4
		mov	UnderWait,2000
		mov	ax,2			; Dir = 2
		cmp	dx,400
		jne	DoUnder0
		mov	UnderWait,500
		neg	ax			; Dir = -2
DoUnder0:	mov	UnderDir,al
DoUnder1:	add	dx,ax			; Move!
		mov	UnderLoc,dx		; Store position of text
		cmp	dx,400			; Stop moving when end reached
		je	DoUnder2
		cmp	dx,400-(UnderHeight+2)*16
		jne	DoUnder3
DoUnder2:	mov	UnderDir,0		; Stop => direction=0
DoUnder3:	mov	ax,dx			; Set text position
		jmp	SetSplit


; Clear screen ----------------------------------------------------------------
; in:	ES = video segment segment
; out:	nop
; mod:	AX, CX, DX, DI, flags
;
ClrScr:		mov	dx,3CEh			; Clear screen
		mov	ax,0205h		; Set write mode 2
		out	dx,ax
		mov	ax,0003h		; Operation: replace pixels
		out	dx,ax
		mov	ax,0FF08h		; Bit mask (mask none)
		out	dx,ax
		xor	di,di
		mov	cx,BytesPerLine*ScreenHeight
		xor	al,al
		rep	stosb
		ret


; Wait for a new vertical retrace ---------------------------------------------
; in:	nop
; out:	nop
; mod:	AL, DX, flags
;
NewTrace:	call	EndTrace


; Wait for vertical retrace ---------------------------------------------------
; in:	nop
; out:	nop
; mod:	AL, DX, flags
;
WaitTrace:	mov	dx,3DAh
WaitTrace1:	in	al,dx
		test	al,8
		jz	WaitTrace1
		ret


; Wait for end of vertical retrace --------------------------------------------
; in:	nop
; out:	nop
; mod:	AL, DX, flags
;
EndTrace:	mov	dx,3DAh			; Wait for vertical retrace
EndTrace1:	in	al,dx
		test	al,8
		jnz	EndTrace1
		ret


; Set pixel pan ---------------------------------------------------------------
; in:	AL=pan waarde
; out:	nop
; mod:	AL, DX, flags
;
PixelPan:	push	ax
		mov	dx,3DAh
		in	al,dx
		mov	dl,0C0h
		mov	al,33h
		out	dx,al
		pop	ax
		out	dx,al
		ret


; Set split screen line -------------------------------------------------------
; in:	AX=scan line
; out:	nop
; mod:	AX, CX, DX, flags
;
SetSplit:	mov	dx,3D4h
		mov	ch,ah
		mov	ah,18h
		xchg	al,ah
		out	dx,ax
		mov	cl,4
		mov	ah,ch
		and	ah,1
		shl	ah,cl
		mov	al,7
		out	dx,al
		inc	dl
		in	al,dx
		dec	dl
		and	al,0EFh
		or	ah,al
		mov	al,7
		out	dx,ax
		inc	cl
		and	ch,2
		shl	ch,cl
		mov	ah,ch
		mov	al,9
		out	dx,al
		inc	dl
		in	al,dx
		dec	dl
		and	al,0BFh
		or	ah,al
		mov	al,9
		out	dx,ax
		ret


; Dump color table to CRTC ----------------------------------------------------
; in:	AL = color, DS:SI = table, CX = number of colors * 3
; out:	nop
; mod:	AX, CX, DX, flags
;
DumpColors:	mov	dx,3C8h
		out	dx,al
		mov	dl,0C9h
		rep	outsb
		ret


; Set vertical adjust ---------------------------------------------------------
; in:	AX=adjust value
;
VerticalAdj:	mov	dx,BytesPerLine
		mul	dx


; Set base address ------------------------------------------------------------
;
SetBase:	mov	dx,3D4h
		push	ax
		mov	al,12
		out	dx,ax
		pop	ax
		mov	ah,13
		xchg	al,ah
		out	dx,ax
		ret


; Include files & data area ---------------------------------------------------
;
TinyDat:	include tinyfont.asm			; Font for hello text
WelcomeText	db	14,12,'HELLO THERE!',0		; Hello text
		db	9,12,'THE RAVEN PRESENTS...',0
		db	11,12,'A BRAND NEW INTRO',0
		db	0,0
WelcomeTxt2	db	12,0,'DISTURBED VGA!',0
UnderText	db	5,1,'ULTIMATE INTRO FROM THE RAVEN!',0	; text box
		db	30,3,'CONTACT THE RAVEN AT:',0
		db	35,5,'PO.BOX 431',0
		db	31,6,'7570 AK OLDENZAAL',0 
		db	32,7,'THE NETHERLANDS',0
		db	25,9,'TO SWAP OR JUST FOR THE KICKS!',0
		db	5,11,'CODING : THE BRAIN        GPX : DOU'
		db	'BLE D        TEXT : MR FUZZ & MR FAX',0
		dw	0
WelcomeCol	db	3Ch,38h,30h,2Ch,24h,20h,1Ch,14h	; Start text palette
		db	0,0,0
RavenCol	db	18h,10h,18h,34h,24h,34h,2Ch,20h	; Raven logo palette
		db	2Ch,24h,18h,24h,1Ch,14h,1Ch,1Ch
		db	1Ch,34h,08h,28h,28h
ScrollText:	include	text.asm			; Scroll text
		db	0				; Text terminator
CurCol		dw	offset ColTab			; Current scroll color
ColTab:		db	60,60,60,48,56,52,36,52,44,28	; Colors for scroll
		db	44,36,20,40,32,12,36,24,4,32,20
		db	60,60,60,48,52,56,36,44,52,28,36
		db	44,20,32,40,12,24,36,4,20,32,60
		db	60,60,56,48,52,52,36,44,44,28,36
		db	40,20,32,36,12,24,32,4,20,60,0
		db	60,56,0,52,52,0,44,44,0,36,40,0
		db	32,36,0,24,32,0,20,0,0,60,0,0,56
		db	0,0,52,0,0,44,0,0,40,0,0,36,0,0
		db	32,60,0,0,56,0,0,52,0,0,44,0,0
		db	40,0,0,36,0,0,32,0,0,0,60,0,0,56
		db	0,0,52,0,0,44,0,0,40,0,0,36,0,0
		db	32,0

		end	Start
