@cls
@if exist temp goto start
@md temp

:start
@echo *******************************************************************************
@echo Converting resources to linkable object files
@echo *******************************************************************************

@if exist res\inc goto skip_inc
@md res\inc
:skip_inc

@if exist res\obj goto skip_obj
@md res\obj
:skip_obj

@echo y | del res\inc\*.* >NUL
@echo y | del res\obj\*.* >NUL

@set res=gdm
utils\2gdm res\p_t_paso.mod temp\music.gdm
utils\bin2obj temp\music.gdm res\obj\%res%.obj res\inc\%res%.bi * WriteGDM
@if not exist res\obj\%res%.obj goto res_error

@set res=sb2x
utils\bin2obj res\sb2x.mse res\obj\%res%.obj res\inc\%res%.bi * WriteSB2X
@if not exist res\obj\%res%.obj goto res_error

@set res=sb16
utils\bin2obj res\sb16.mse res\obj\%res%.obj res\inc\%res%.bi * WriteSB16
@if not exist res\obj\%res%.obj goto res_error

@set res=gus
utils\bin2obj res\gus.mse res\obj\%res%.obj res\inc\%res%.bi * WriteGUS
@if not exist res\obj\%res%.obj goto res_error

@set res=pal
utils\bin2obj res\grad.pal res\obj\%res%.obj res\inc\%res%.bi GetPal *
@if not exist res\obj\%res%.obj goto res_error

@set res=font
utils\bin2obj res\font.put res\obj\%res%.obj res\inc\%res%.bi GetFont *
@if not exist res\obj\%res%.obj goto res_error

@set res=plasma
utils\bin2obj res\plasma.put res\obj\%res%.obj res\inc\%res%.bi GetPlasma *
@if not exist res\obj\%res%.obj goto res_error

@set res=ibm
utils\bin2obj res\ibm.put res\obj\%res%.obj res\inc\%res%.bi GetIBM *
@if not exist res\obj\%res%.obj goto res_error

@echo.
@echo *******************************************************************************
@echo Compiling intro
@echo *******************************************************************************

utils\bc enough.bas, temp\enough.obj, nul /o
@if not exist temp\enough.obj goto compile_error

@echo.
@echo *******************************************************************************
@echo Linking intro with libraries and resource object files
@echo *******************************************************************************

@echo /f /noe temp\enough.obj+ >temp\link.in
@echo libs\qbx_mse.obj+ >>temp\link.in
@echo libs\dosfile.obj+ >>temp\link.in

@echo libs\noem.obj+ >>temp\link.in
@echo libs\nocom.obj+ >>temp\link.in
@echo libs\smallerr.obj+ >>temp\link.in
@echo res\obj\gdm.obj+ >>temp\link.in
@echo res\obj\sb2x.obj+ >>temp\link.in
@echo res\obj\sb16.obj+ >>temp\link.in
@echo res\obj\gus.obj+ >>temp\link.in
@echo res\obj\pal.obj+ >>temp\link.in
@echo res\obj\font.obj+ >>temp\link.in
@echo res\obj\plasma.obj+ >>temp\link.in
@echo res\obj\ibm.obj >>temp\link.in
@echo temp\enough.exe >>temp\link.in
@echo nul >>temp\link.in
@echo libs\bcom45.lib+ >>temp\link.in
@echo libs\dqb.lib >>temp\link.in
utils\link @temp\link.in
@if not exist temp\enough.exe goto link_error

@echo.
@echo *******************************************************************************
@echo Packing EXE
@echo *******************************************************************************

utils\apack temp\enough.exe enough.exe
@if not exist enough.exe goto pack_error

@echo.
@echo.
@echo *******************************************************************************
@echo SUCCESS!: "ENOUGH.EXE" successfully built.
@echo *******************************************************************************
@goto end


:res_error
@echo.
@echo.
@echo *******************************************************************************
@echo ERROR: Error converting resource "%res%"
@echo *******************************************************************************
@goto end


:compile_error
@echo.
@echo.
@echo *******************************************************************************
@echo ERROR: Error compiling intro
@echo *******************************************************************************
@goto end


:link_error
@echo.
@echo.
@echo *******************************************************************************
@echo ERROR: Error linking intro
@echo *******************************************************************************
@goto end


:pack_error
@echo.
@echo.
@echo *******************************************************************************
@echo ERROR: Error packing EXE
@echo *******************************************************************************
@goto end


:end
@set res=
@echo y | del temp\*.* >NUL
@rd temp
@pause
