
; *
; * Triangle render code for GB/GBC
; * by Jeff Frohwein
; * last edit 9-Jun-99
; *
; * Written with RGBDS
; *

        PUSHS

        SECTION "Low Ram",BSS

FastLineCode        ds 82+82+18+18

        POPS

; *** Efficient high RAM variable storage **

;delse   equ     $ff90
;delde   equ     $ff92

; *** Draw a line using self-modifying code ***
; Entry: [x1] = Start X Coordinate
;        [y1] = Start Y Coordinate
;        [x2] = End X Coordinate
;        [y2] = End Y Coordinate
;        Line is only XOR color. No solid colors in this version.
;
; On the GB this routine can draw ~  150 lines a second.
; On the GBC in 2X speed this routine can draw ~ 300 lines a second.
;   (Average line length of 75 pixels at this rate.)

XorLine:

; find [y2-y1]

        ld      a,[y1]          ; hl = y2 - y1
        ld      l,a
        ld      a,[y2]
        sub     l
        ld      l,a
        ld      a,0
        sbc     a
        ld      h,a

        rlca                    ; Is hl positive ?
        jr      nc,.xline1       ; yes

        xor     a
        ld      [FastLineCode+(YPatch11-mloop1)+1],a
        ld      [FastLineCode+(YPatch12-mloop1)+1],a

        ld      a,$d6   ; sub
        ld      [FastLineCode+(YPatch21-mloop1)],a
        ld      [FastLineCode+(YPatch22-mloop1)],a

        ld      a,$de   ; sbc
        ld      [FastLineCode+(YPatch31-mloop1)],a
        ld      [FastLineCode+(YPatch32-mloop1)],a

        ld      a,$2b   ; dec hl
        ld      [FastLineCode+(YPatch41-mloop1)],a
        ld      [FastLineCode+(YPatch42-mloop1)],a
        ld      [FastLineCode+(YPatch41-mloop1)+1],a
        ld      [FastLineCode+(YPatch42-mloop1)+1],a

        xor     a               ; hl = -hl
        sub     l
        ld      l,a
        jr      .xline1x

.xline1:
        ld      a,$e
        ld      [FastLineCode+(YPatch11-mloop1)+1],a
        ld      [FastLineCode+(YPatch12-mloop1)+1],a

        ld      a,$c6   ; add
        ld      [FastLineCode+(YPatch21-mloop1)],a
        ld      [FastLineCode+(YPatch22-mloop1)],a

        ld      a,$ce   ; adc
        ld      [FastLineCode+(YPatch31-mloop1)],a
        ld      [FastLineCode+(YPatch32-mloop1)],a

        ld      a,$23   ; inc hl
        ld      [FastLineCode+(YPatch41-mloop1)],a
        ld      [FastLineCode+(YPatch42-mloop1)],a
        ld      [FastLineCode+(YPatch41-mloop1)+1],a
        ld      [FastLineCode+(YPatch42-mloop1)+1],a

.xline1x:

; find [x2-x1]

        ld      a,[x1]          ; de = x2 - x1
        ld      e,a
        ld      a,[x2]
        sub     e
        ld      e,a
        ld      a,0
        sbc     a
        ld      d,a

        rlca                    ; Is de positive ?
        jr      nc,.xline2       ; yes

        xor     a       ; rlc b
        ld      [FastLineCode+(XPatch11-mloop1)+1],a
        ld      [FastLineCode+(XPatch12-mloop1)+1],a

        ld      a,$d6   ; sub
        ld      [FastLineCode+(XPatch21-mloop1)],a
        ld      [FastLineCode+(XPatch22-mloop1)],a

        ld      a,$25   ; inc h
        ld      [FastLineCode+(XPatch31-mloop1)],a
        ld      [FastLineCode+(XPatch32-mloop1)],a

        xor     a               ; de = -de
        sub     e
        ld      e,a
;        ld      a,0
;        sbc     d
;        ld      d,a
        jr      .xline2x

.xline2:

        ld      a,8     ; rrc b
        ld      [FastLineCode+(XPatch11-mloop1)+1],a
        ld      [FastLineCode+(XPatch12-mloop1)+1],a

        ld      a,$c6   ; add
        ld      [FastLineCode+(XPatch21-mloop1)],a
        ld      [FastLineCode+(XPatch22-mloop1)],a

        ld      a,$24   ; inc h
        ld      [FastLineCode+(XPatch31-mloop1)],a
        ld      [FastLineCode+(XPatch32-mloop1)],a

.xline2x:

        ld      h,e

; sort [y2-y1] and [x2-x1]

        ld      a,h
        cp      l
        jr      nc,.xline3

        ld      bc,FastLineCode+(mloop2-mloop1)

        ld      h,l     ;exchange h & l
        ld      l,a
        jr      .xline4

.xline3:
        ld      bc,FastLineCode+(loop10-mloop1)

; store dels, delp, delsx, and delsy

.xline4:
        ld      a,c
        ld      [FastLineCode+1],a
        ld      a,b
        ld      [FastLineCode+2],a          ; Save address of routine to execute

;        ld      a,h
;        ld      [dels],a

        ld      a,l

;        ld      [delp],a

; compute initial and inc for error function

;        ld      a,[delp]        ; delse = delp * 2
        add     a,a
        ld      c,a
;        ld      [delse],a
        ld      [FastLineCode+(SPatch11-mloop1)+1],a
        ld      [FastLineCode+(SPatch13-mloop1)+1],a
        ld      a,0
        rla             ; put carry in lsb of A
;        adc     0
        ld      b,a
;        ld      [delse+1],a
        ld      [FastLineCode+(SPatch12-mloop1)+1],a
        ld      [FastLineCode+(SPatch14-mloop1)+1],a

        ld      a,c             ; de = (delp * 2) - dels
        sub     h
        ld      e,a
        ld      a,b
        sbc     0
        ld      d,a

        ld      a,e             ; delde = (delp * 2) - (dels * 2)
        sub     h
;        ld      [delde],a
        ld      [FastLineCode+(DPatch11-mloop1)+1],a
        ld      [FastLineCode+(DPatch13-mloop1)+1],a
        ld      a,d
        sbc     0
;        ld      [delde+1],a
        ld      [FastLineCode+(DPatch12-mloop1)+1],a
        ld      [FastLineCode+(DPatch14-mloop1)+1],a

        push    de

; adjust count

        inc     h
        ld      c,h
        push    bc              ; c = total pixel count

        ld      a,[x1]
	ld	b,a
        ld      a,[y1]
	ld	c,a

; *** Calculate address of a pixel on the screen ***
; Entry: B = X Coordinate
;        C = Y Coordinate

        ld      a,b
        ld      l,b
        srl     l
        srl     l
        srl     l

        rlc     l
        rlc     l
        rlc     l

 if RENDER_TO_VRAM
        ld      h,$40           ; Do this cos for the last multiply
 else
        ld      h,NON_VIDEO_RAM/2
 endc
        add     hl,hl           ; the number can be >256

        ld      d,h
        ld      e,l

        ld      hl,YTable
        ld      b,0
        add     hl,bc
        add     hl,bc
        ld      b,[hl]
        inc     hl
        ld      h,[hl]
        ld      l,b
        add     hl,de
        ld      d,h
        ld      e,l

        pop     bc              ; c = total pixel count

        and     7               ; b = Bitmask[b & 7]
        ld      l,a
        ld      h,0
        ld      a,[hl]
        ld      b,a

;        B = Bit set mask

        ld      h,d
        ld      l,e             ; Put starting screen addr in HL

        pop     de

        jp      FastLineCode

; *** Load this code to RAM so we can modify it ***

mloop1:
        jp      0

; *** "Line is wider than tall" code ***

loop10:
        di
loop11:
        ld      a,[rSTAT]       ; Wait for H/V-Retrace
        bit     1,a
        jr      nz,loop11

        ld      a,[hl]
        xor     b
        ld      [hl+],a

        ld      a,[hl]
        xor     b
        ld      [hl-],a

        ei

; Increment right

XPatch11:
        rrc     b
        jr      nc,skip11

        ld      a,l     ; 4
XPatch21:
        add     16      ; 8
        ld      l,a     ; 4
        jr      nc,skip11
XPatch31:
        inc     h
skip11:

        bit     7,d
        jr      nz,skip13

; Increment down

        ld      a,l
        and     $f
YPatch11:
        cp      $e
        jr      nz,skip12

        ld      a,l
YPatch21:
        add     $30
        ld      l,a
        ld      a,h
YPatch31:
        adc     $01
        ld      h,a     ; hl = hl + $130

skip12:
YPatch41:
        inc     hl
        inc     hl

DPatch11:
;        ld      a,[delde]
        ld      a,0
        add     a,e
	ld	e,a
DPatch12:
        ld      a,0
;        ld      a,[delde+1]
        adc     a,d
	ld	d,a

        dec     c
        jr      nz,loop10

        ret

skip13:
;        ld      a,[delse]
SPatch11:
        ld      a,0
        add     a,e
	ld	e,a
SPatch12:
;        ld      a,[delse+1]
        ld      a,0
        adc     a,d
	ld	d,a

        dec     c
        jr      nz,loop10

        ret

; *** "Line is taller than wide" code ***

mloop2:
loop20:
        di
loop21:
        ld      a,[rSTAT]       ; Wait for H/V-Retrace
        bit     1,a
        jr      nz,loop21

        ld      a,[hl]
        xor     b
        ld      [hl+],a

        ld      a,[hl]
        xor     b
        ld      [hl-],a

        ei

; Increment down
        ld      a,l
        and     $f
YPatch12:
        cp      $e
        jr      nz,skip21

        ld      a,l
YPatch22:
        add     $30
        ld      l,a
        ld      a,h
YPatch32:
        adc     $01
        ld      h,a     ; hl = hl + $130

skip21:
YPatch42:
        inc     hl
        inc     hl


        bit     7,d
        jr      nz,skip23

; Increment right

XPatch12:
        rrc     b
        jr      nc,skip22

        ld      a,l     ; 4
XPatch22:
        add     16      ; 8
        ld      l,a     ; 4
        jr      nc,skip22
XPatch32:
        inc     h
skip22:

DPatch13:
;        ld      a,[delde]
        ld      a,0
        add     a,e
	ld	e,a
DPatch14:
;        ld      a,[delde+1]
        ld      a,0
        adc     a,d
	ld	d,a

        dec     c
        jr      nz,loop20

        ret

skip23:
SPatch13:
;        ld      a,[delse]
        ld      a,0
        add     a,e
	ld	e,a
SPatch14:
;        ld      a,[delse+1]
        ld      a,0
        adc     a,d
	ld	d,a

        dec     c
        jr      nz,loop20

        ret

mloop3:


InstallFastLineCode:

; Copy line drawing code to RAM

        ld      hl,mloop1
        ld      de,FastLineCode
        ld      bc,mloop3-mloop1
        call    mem_Copy

        ret





;; Increment right
;
;        rrc     b
;        jr      nc,.incre
;
;        ld      a,l     ; 4
;        add     16      ; 8
;        ld      l,a     ; 4
;        jr      nc,.incre
;        inc     h
;.incre
;
;; Increment left
;
;        rlc     b
;        jr      nc,.incle
;
;        ld      a,l     ; 4
;        sub     16      ; 8
;        ld      l,a     ; 4
;        jr      nc,.incle
;        dec     h
;.incle
;
;; Increment up
;
;        ld      a,l
;        and     $f
;        cp      $0
;        jr      nz,.incue
;
;        ld      a,l
;        sub     $30
;        ld      l,a
;        ld      a,h
;        sbc     $01
;        ld      h,a     ; hl = hl - $130
;
;.incue
;        dec     hl
;        dec     hl
;
;; Increment down
;
;        ld      a,l
;        and     $f
;        cp      $e
;        jr      nz,.incde
;
;        ld      a,l
;        add     $30
;        ld      l,a
;        ld      a,h
;        adc     $01
;        ld      h,a     ; hl = hl + $130
;
;.incde
;        inc     hl
;        inc     hl