
SetTextureAddress:
        ld      [TexOffset],a
        ret

DisplayTexturedEdgeBuf:

; Search for start of tri

        ld      hl,EdgeBuf
        ld      c,-1
.start2:
        ld      a,[hl+]
        inc     hl
        inc     c
        inc     a
        jr      z,.start2

        dec     hl
        dec     hl

; Render all lines of the tri

        ld      d,h
        ld      e,l

        ld      hl,YTable
        ld      b,0
        add     hl,bc
        add     hl,bc
        ld      a,[hl+]
        ld      c,a
        ld      a,[hl]
        ld      b,a             ; bc = Y addr offset

.mainl2:
        ld      a,[de]
        inc     de
        ld      l,a             ; l = minimum X

        ld      a,[de]
        inc     de
        ld      [maxX],a

        push    de

        push    bc

;.....
; Get start address offset

        ld      a,l
        srl     l
        srl     l
        srl     l

        rlc     l
        rlc     l
        rlc     l

 if RENDER_TO_VRAM
        ld      h,$40           ; Draw to tiles at $8000
 else
        ld      h,NON_VIDEO_RAM/2
 endc

        add     hl,hl           ; the number can be >256

        add     hl,bc

; Get bit positions

        and     7               ; b = Bitmask[b & 7]
        ld      e,a
        ld      d,LEFT_LINE_MASK_ADDR/256
        ld      a,[de]
        ld      [LastBitPos],a

;.....
        ld      a,h
        ld      [LastAdr+1],a
        ld      a,l
        ld      [LastAdr],a

        ld      d,h
        ld      e,l

;.....
; Get end address offset

        ld      a,[maxX]
        ld      l,a
        srl     l
        srl     l
        srl     l

        rlc     l
        rlc     l
        rlc     l

 if RENDER_TO_VRAM
        ld      h,$40           ; Draw to tiles at $8000
 else
        ld      h,NON_VIDEO_RAM/2
 endc

        add     hl,hl           ; the number can be >256

; Get Y address

        add     hl,bc           ; hl = end adr

        and     7
        ld      c,a
        ld      b,RIGHT_LINE_MASK_ADDR/256
        ld      a,[bc]
        ld      b,a             ; b = Bitmask[a & 7]

;.....


; Figure out if start & end pixel locations on this
; line share the same memory address.

        ld      a,l
        sub     e
        ld      e,a
        ld      a,h
        sbc     d
;        ld      d,a

        srl     a
        rr      e

        or      e               ; Same address?
        jr      z,.sameadr      ; yes

;        srl     d
;        rr      e

        srl     e
        srl     e
        srl     e

        push    de

        push    hl

        ld      a,[TexOffset]
        ld      h,a

        ld      a,[hl]
        and     b
        ld      d,a

        ld      a,[hl+]
        cpl
        and     b
        cpl
        ld      e,a

        ld      a,[hl]
        and     b
        ld      c,a

        ld      a,[hl]
        cpl
        and     b
        cpl
        ld      b,a

        pop     hl

        ld      a,[hl]
        or      d
        and     e
        ld      [hl+],a

        ld      a,[hl]
        or      c
        and     b
        ld      [hl],a

        pop     de

        dec     e
        jr      z,.done

        ld      a,[TexOffset]
        ld      b,a

.blitloop:
        ld      a,l
        sub     16+1
        ld      l,a
        jr      nc,.nocarry
        dec     h
.nocarry:

; Get 2 texture bytes

        ld      c,h
        ld      h,b

        ld      a,[hl+]
        ld      d,[hl]
        dec     l

        ld      h,c

; Write 2 texture bytes

        ld      [hl+],a
        ld      [hl],d

        dec     e
        jr      nz,.blitloop

.done:
; Plot first part of line
        ld      a,[LastAdr+1]
        ld      h,a
        ld      a,[LastAdr]
        ld      l,a

        ld      a,[LastBitPos]

        jr      .sameadr2

.sameadr:
        ld      a,[LastBitPos]
        and     b

.sameadr2:
        ld      c,a

        push    hl

        ld      a,[TexOffset]
        ld      h,a

        ld      a,[hl]
        and     c
        ld      d,a

        ld      a,[hl+]
        cpl
        and     c
        cpl
        ld      e,a

        ld      a,[hl]
        and     c
        ld      b,a

        ld      a,[hl]
        cpl
        and     c
        cpl
        ld      c,a

        pop     hl

;.DoEndPixels:

        ld      a,[hl]
        or      d
        and     e
        ld      [hl+],a

        ld      a,[hl]
        or      b
        and     c
        ld      [hl],a

        pop     bc

; Move Y addr offset down one line

        ld      a,c
        and     $f
        cp      $e      ; Are we still on the same tile?
        jr      nz,.incy       ; yes

        ld      a,c     ; no, move to next tile
        add     $30
        ld      c,a
        ld      a,b
        adc     $01
        ld      b,a     ; bc = bc + $130

.incy:
        inc     bc
        inc     bc

        pop     de

        ld      a,[de]
        inc     a               ; Is there another line to render?
        jp      nz,.mainl2      ; yes

        ret