INCLUDE "COUNTER.INC"

ORG 100H

 DB     '.',0,' '

 PUSHA

 PUSH 0A000H-20
 POP ES
@@:
 STOSW
 INC BX
 JNS @B
 PUSH   08000H
 POP    ES
@@:
 STOSW
 INC BX
 JNZ @B

 SHL DI,3
 MOV    BX,SI
 MOV    BP,bits*8-256*8
 MOV    CL,7            ; offset of the title
newpar:
 MOV    DH,01000001B    ; flags for capital letters
newline:
 MOV    AL,0DH
 INT    29H
 MOV    AL,0AH
 INT    29H
 MOV    DL,26           ; max. chars in a line
newchar:
 MOV    AL,8
getbits:
 BT     [BX],BP
 INC    BP
 RCL    AL,1
 JNC    getbits
 CMP    AL,3
 JE     newpar
 JB     symbol
 ADD    AL,91

 LOOP   skip
 INC    CX
 SHL    DI,1
 JB     convert

 DB     03CH            ; opcode CMP AL,0D7H - skiping XLATB
symbol:
 XLATB
skip:
 SHR    DH,1
 JNC    putchar

convert:
 XOR    AL,32
putchar:
 INT    29H
 DEC    DX
 JZ     newline
 CMP    AL,' '
 JE     convert
 CMP    BP,bits*8+231*5-256*8
 JB     newchar

 PUSH   0A000H-20
 POP    DS
 XCHG   SI,AX

@@:
 ADD    SI,64
 MOV    CL,128
 REP    MOVSW
 JNC    @B

 POPA
 PUSH CS
 POP DS
 LEA SI,[BP+SI]

MULTIP:
 PUSH   0A01EH
 POP    ES

MAIN:
 MOV  CX,100*256        ; CL:X offset, CH:Y offset
 CALL ATAN
 CALL ESCAPE
; MOV AX,[COUNTER+1]     ; AX:Counter+1
; SUB AX,[COUNTER0]
; TEST AH,AH
; JNZ exit
 PUSH   WORD [SI]

 MOV    BX,AX
 SHL    BX,4
 MOV    AH,BH
 AND    AX,16384+8192+4096+512+32
 ADD    AX,256*75-16
 TEST   BH,8+4                  ; clear CF
 JZ     NOH
 SALC                           ; clear AL -> no horizontal offset
NOH:
 XCHG   AX,CX                   ; CL:X offset, CH:Y offset
 CALL   ATAN                    ; get the angle
 POP    AX
 ADD    AX,BX                   ; rotating
; SAR    BH,7                    ; bit 8 -> part selection normal or color
 MOV BH,0
 XOR    AX,[SI]
 SHR    AX,10
 JNC    NOBR2
 MOV    AL,CH
 SHR    WORD [SI],10
 JNC    NOBR1
 XOR    AL,8*16                 ; XORing color intesity
NOBR1:
 SHR    AL,4
 NOT    BH
NOBR2:
 AND    AL,BH                   ; part selection normal or color
 STOSB
; MOV    AH,1
; INT    16H
; JZ     MAIN
 JMP MAIN

ATAN:
 MOV    AX,0CCCDH               ; screen modulo trick
 MUL    DI                      ; DL:X coord, DH:Y coord
 SUB    DX,CX                   ; adding the offsets
 MOV    [SI],DX
 FILD   WORD [SI-1]
 FILD   WORD [SI]
 FPATAN
 FIMUL  WORD [MULTIP]
 FISTP  WORD [SI]
exit:
RETN

bits:
 file 'bits7b.bin'
