#include <stdlib.h>
#include "shared.h"
#include "sintb.h"

/* Command table elements */
#define CMDCTRL 0x00
#define CMDLINK 0x01
#define CMDPMOD 0x02
#define CMDCOLR 0x03
#define CMDSRCA 0x04
#define CMDSIZE 0x05
#define CMDXA   0x06
#define CMDYA   0x07
#define CMDXB   0x08
#define CMDYB   0x09
#define CMDXC   0x0A
#define CMDYC   0x0B
#define CMDXD   0x0C
#define CMDYD   0x0D
#define CMDGRDA 0x0E
#define CMDDUMY 0x0F

#define MESH(n) (mesh_flag=(n)?0x0100:0x0000)

#define INT2FIX(a) (((int)(a))<<10)
#define FIX2INT(a) (((int)(a))>>10)

/* Create a 5:5:5 RGB color with the MSB set */
#define COLOR(r,g,b)    (((r)&0x1F)|((g)&0x1F)<<5|((b)&0x1F)<<10|0x8000)


int 	list_index = 1;
uint16 	mesh_flag = 0;
int 	theta = 0;

int pointM[28][3] = {
	{-5,-3,-2},
	{-3,-3,-2},
	{3,-3,-2},
	{5,-1,-2},
	{5,3,-2},
	{3,3,-2},
	{3,-1,-2},
	{1,-1,-2},
	{1,3,-2},
	{-1,3,-2},
	{-1,-1,-2},
	{-3,-1,-2},
	{-3,3,-2},
	{-5,3,-2},
//
	{-5,-3,2},
	{-3,-3,2},
	{3,-3,2},
	{5,-1,2},
	{5,3,2},
	{3,3,2},
	{3,-1,2},
	{1,-1,2},
	{1,3,2},
	{-1,3,2},
	{-1,-1,2},
	{-3,-1,2},
	{-3,3,2},
	{-5,3,2}
};

int pointI[10][3] = {
	{-1,-3,-2},
	{1,-1,-2},
	{1,3,-2},
	{-1,3,-2},
	{-1,-1,-2},
//
	{-1,-3,2},
	{1,-1,2},
	{1,3,2},
	{-1,3,2},
	{-1,-1,2}
};

int pointC[22][3] = {
	{-3,-3,-2},
	{1,-3,-2},
	{3,-1,-2},
	{1,-1,-2},
	{-1,-1,-2},
	{-1,1,-2},
	{3,1,-2},
	{3,3,-2},
	{-1,3,-2},
	{-3,3,-2},
	{-3,-1,-2},
//
	{-3,-3,2},
	{1,-3,2},
	{3,-1,2},
	{1,-1,2},
	{-1,-1,2},
	{-1,1,2},
	{3,1,2},
	{3,3,2},
	{-1,3,2},
	{-3,3,2},
	{-3,-1,2}
};



int faceM[23][4] = {
	{0,1,12,13},
	{1,2,6,11},
	{6,3,4,5},
	{10,7,8,9},
	{2,3,6,6},
	{14,15,26,27},
	{15,16,20,25},
	{20,17,18,19},
	{24,21,22,23},
	{16,17,20,20},
	{0,14,16,2},
	{14,0,13,27},
	{13,27,26,12},
	{11,25,26,12},
	{25,24,10,11},
	{24,10,9,23},
	{9,23,22,8},
	{7,21,22,8},
	{21,20,6,7},
	{20,6,5,19},
	{5,19,18,4},
	{3,17,18,4},
	{2,16,17,3}
};


int faceI[8][4] = {
	{0,1,4,4},
	{1,2,3,4},
	{0,5,6,1},
	{1,6,7,2},
	{3,8,7,2},
	{5,0,3,8},
	{5,6,9,9},
	{6,7,8,9}
};

int faceC[16][4] = {
	{0,1,3,10},
	{1,2,3,3},
	{10,4,8,9},
	{5,6,7,8},
	{11,12,14,21},
	{12,13,14,14},
	{21,15,19,20},
	{16,17,18,19},
	{0,11,12,1},
	{1,12,13,2},
	{4,15,13,2},
	{4,15,16,5},
	{5,16,17,6},
	{6,17,18,7},
	{9,20,18,7},
	{11,0,9,20}
};


typedef struct
{
	int x,y,z;
} point3d;

typedef struct
{
	int p0,p1,p2,p3;
} quadrangle;


point3d camera;
point3d *modelM=(point3d*)&pointM,rotatedM[28],projectedM[28];
quadrangle *letterM=(quadrangle*)&faceM;
int faceOrderM[23];

point3d *modelI=(point3d*)&pointI,rotatedI[10],projectedI[22];
quadrangle *letterI=(quadrangle*)&faceI;
int faceOrderI[8];

point3d *modelC=(point3d*)&pointC,rotatedC[22],projectedC[22];
quadrangle *letterC=(quadrangle*)&faceC;
int faceOrderC[16];

quadrangle faces[47];
point3d allPoints[60];
int faceOrder[47];



/* Clear command list */
void list_clear(void)
{
    uint16 *p = (uint16 *)VDP1_VRAM;
    int i;
    for(i=0;i<16;i++)
        p[i] = 0xFFFF;
    p[CMDCTRL] = 0x4000;
    list_index = 1;
}

/* Add end marker to command list */
void list_end(void)
{
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));
    p[CMDCTRL] = 0x8000;
    list_index++;
}

/* Add system clip to command list */
void list_set_system_clip(int16 x, int16 y)
{
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));

    p[CMDCTRL] = 0x0009; /* Set system clip */
    p[CMDLINK] = 0x0000; /* Jump address */
    p[CMDXC]   = x;
    p[CMDYC]   = y;
    list_index++;
}


/* Add user clip to command list */
void list_set_user_clip(int16 x1, int16 y1, int16 x2, int16 y2)
{
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));

    p[CMDCTRL] = 0x0008; /* Set user clip */
    p[CMDLINK] = 0x0000; /* Jump address */
    p[CMDXA]   = x1;
    p[CMDYA]   = y1;
    p[CMDXC]   = x2;
    p[CMDYC]   = y2;
    list_index++;
}

/* Add local coords to command list */
void list_set_local_coords(int16 x, int16 y)
{
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));

    p[CMDCTRL] = 0x000A; /* Set local coords */
    p[CMDLINK] = 0x0000; /* Jump address */
    p[CMDXA]   = x;
    p[CMDYA]   = y;
    list_index++;
}



/* Add local coords to command list */
void list_polygon(int16 x1, int16 y1, int16 x2, int16 y2, int16 x3, int16 y3, int16 x4, int16 y4, uint16 color, uint32 grda)
{
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));

    p[CMDCTRL] = 0x0004; /* Polygon */
    p[CMDLINK] = 0x0000; /* Jump address */
    p[CMDPMOD] = 0x00C0 | mesh_flag | 0; //4;
    p[CMDCOLR] = color;
    p[CMDXA]   = x1;
    p[CMDYA]   = y1;
    p[CMDXB]   = x2;
    p[CMDYB]   = y2;
    p[CMDXC]   = x3;
    p[CMDYC]   = y3;
    p[CMDXD]   = x4;
    p[CMDYD]   = y4;
    p[CMDGRDA] = grda>>3;
    list_index++;
}


void rotate(point3d *in,point3d *out,int angle,int n)
{
	int i;
	int xr,yr,zr,temp;
	int can,san;

	san = sintb[angle&0xff];
	can = sintb[(angle+0x40)&0xff];

	for (i=0; i<n; i++)
	{
		// About X
		out[i].y = ((in[i].y * can) - (in[i].z * san)); out[i].y=FIX2INT(out[i].y);
		out[i].z = ((in[i].y * san) + (in[i].z * can)); out[i].z=FIX2INT(out[i].z);

		// About Y
		out[i].x = ((in[i].x * can) - (out[i].z * san)); out[i].x=FIX2INT(out[i].x);
		out[i].z = ((in[i].x * san) + (out[i].z * can)); out[i].z=FIX2INT(out[i].z);

		// About Z
		temp = out[i].x;
		out[i].x = ((out[i].x * can) - (out[i].y * san)); out[i].x=FIX2INT(out[i].x);
		out[i].y = ((temp * san) + (out[i].y * can)); out[i].y=FIX2INT(out[i].y);
	}

}


void transform(point3d *in,point3d *out,int xt,int yt,int zt,int n)
{
	int i;

	xt = INT2FIX(xt); yt = INT2FIX(yt); zt = INT2FIX(zt);
	for (i=0; i<n; i++)
	{
		out[i].x = in[i].x + xt;
		out[i].y = in[i].y + yt;
		out[i].z = in[i].z + zt;
	}
}


void project(point3d *in,point3d *out,int n)
{
	int i;

	for (i=0; i<n; i++)
	{
		out[i].x = camera.x + FIX2INT(((in[i].x * camera.z) / (camera.z - FIX2INT(in[i].z))));
		out[i].y = camera.y + FIX2INT(((in[i].y * camera.z) / (camera.z - FIX2INT(in[i].z))));
		out[i].z = in[i].z;
	}
}


int avgZ[64];	// Allow max 64 faces to be sorted
void sort_quads(quadrangle *f,point3d *p,int *order,int n)
{
	int i,j,temp;

	// Initialize arrays
	for (i=0; i<n; i++)
	{
		avgZ[i] = p[f[i].p0].z +
                  p[f[i].p1].z +
                  p[f[i].p2].z +
                  p[f[i].p3].z;
		order[i] = i;
	}


	// Bubble-sort the whole lot.. yeehaw!
	for (i=0; i<n-1; i++)
	{
		for (j=i+1; j<n; j++)
		{
			if (avgZ[j] > avgZ[i])
			{
				temp = avgZ[i]; avgZ[i] = avgZ[j]; avgZ[j] = temp;
				temp = order[i]; order[i] = order[j]; order[j] = temp;
			}
		}
	}
}




int main()
{
	int i,j,k,m;
	uint16 *p;

    vdp_init();
    conio_init();
    //pad_init();

    /* Set up VDP1 to appear under VDP2 graphics (0=hide, 1-7=visible) */
    PRISA = 0x0101;
    PRISB = 0x0101;
    PRISC = 0x0101;
    PRISD = 0x0101;

    /* Set up VDP1 registers */
    TVMR = 0x0000;
    FBCR = 0x0000;
    PTMR = 0x0002;
    EWDR = COLOR(7,7,20);    /* Erase color: gray */
    EWLR = 0x0000;          /* Erase range: (0,0) -> (352,240) */
    EWRR = 0x50DF;


	for (i=0; i<28; i++)
	{
		modelM[i].x = INT2FIX(modelM[i].x * 6);
		modelM[i].y = INT2FIX(modelM[i].y * 6);
		modelM[i].z = INT2FIX(modelM[i].z * 6);
	}
	for (i=0; i<10; i++)
	{
		modelI[i].x = INT2FIX(modelI[i].x * 6);
		modelI[i].y = INT2FIX(modelI[i].y * 6);
		modelI[i].z = INT2FIX(modelI[i].z * 6);
	}
	for (i=0; i<22; i++)
	{
		modelC[i].x = INT2FIX(modelC[i].x * 6);
		modelC[i].y = INT2FIX(modelC[i].y * 6);
		modelC[i].z = INT2FIX(modelC[i].z * 6);
	}

	for (i=0; i<23; i++)
		faces[i] = letterM[i];
	for (i=0; i<8; i++)
	{
		faces[i+23].p0 = letterI[i].p0 + 28;
		faces[i+23].p1 = letterI[i].p1 + 28;
		faces[i+23].p2 = letterI[i].p2 + 28;
		faces[i+23].p3 = letterI[i].p3 + 28;
	}
	for (i=0; i<16; i++)
	{
		faces[i+31].p0 = letterC[i].p0 + 38;
		faces[i+31].p1 = letterC[i].p1 + 38;
		faces[i+31].p2 = letterC[i].p2 + 38;
		faces[i+31].p3 = letterC[i].p3 + 38;
	}

	camera.x = 160; camera.y = 112; camera.z = -200;

    /* Screen on */
    TVMD = 0x8000;

   	/* Make Gouraud shading table */
    p = (uint16 *)0x25C60000;
    p[0] = COLOR(31,0,0);
    p[1] = COLOR(0,31,0);
    p[2] = COLOR(0,0,31);
    p[3] = COLOR(31,31,31);

    list_clear();
    list_end();

    /* Main loop */
    for(;;)
    {
        int i;

        wait_vblank_out();
        wait_vblank_in();

		TVMD = 0x8000;

       	/* Make new list */
        list_clear();
        list_set_system_clip(320, 224);
        list_set_user_clip(0, 0, 320, 224);
        list_set_local_coords(0, 0);

 		rotate(modelM, rotatedM, theta, 28);
		rotate(modelI, rotatedI, theta, 10);
		rotate(modelC, rotatedC, theta++, 22);

		transform(rotatedM,rotatedM,-50,0,0,28);
		transform(rotatedC,rotatedC,35,0,0,22);

		project(rotatedM, projectedM, 28);
		project(rotatedI, projectedI, 10);
		project(rotatedC, projectedC, 22);

		for (i=0; i<28; i++)
			allPoints[i] = projectedM[i];
		for (i=0; i<10; i++)
			allPoints[i+28] = projectedI[i];
		for (i=0; i<22; i++)
			allPoints[i+38] = projectedC[i];

		sort_quads(faces, allPoints, faceOrder, 47);

        MESH(1);
 		for (i=0; i<47; i++)
 		{
			j = faceOrder[i];
			// Check which direction this quad is facing
			if (1)
			{
				k = ((-FIX2INT(avgZ[i])/4)+30);
				list_polygon( \
				allPoints[faces[j].p0].x,allPoints[faces[j].p0].y, \
				allPoints[faces[j].p3].x,allPoints[faces[j].p3].y, \
				allPoints[faces[j].p2].x,allPoints[faces[j].p2].y, \
				allPoints[faces[j].p1].x,allPoints[faces[j].p1].y, \
				COLOR(27*k/90+9,28*k/90+9,30*k/90+10),
				0);
			}
		}

        list_end();
     }

    vdp_shutdown();

	return 0;
}
