// Saturn flags demo
// Mic, 2006

#include <stdlib.h>
#include "shared.h"
#include "sintb.h"
#include "sin1k.h"
#include "flags.h"


/* Command table elements */
#define CMDCTRL 0x00
#define CMDLINK 0x01
#define CMDPMOD 0x02
#define CMDCOLR 0x03
#define CMDSRCA 0x04
#define CMDSIZE 0x05
#define CMDXA   0x06
#define CMDYA   0x07
#define CMDXB   0x08
#define CMDYB   0x09
#define CMDXC   0x0A
#define CMDYC   0x0B
#define CMDXD   0x0C
#define CMDYD   0x0D
#define CMDGRDA 0x0E
#define CMDDUMY 0x0F

/* Sprite color modes */
#define COLMODE_16_LUT	1
#define COLMODE_128 	3
#define COLMODE_256 	4
#define COLMODE_RGB		5

#define CLIP_DISABLED	0
#define CLIP_DRAW_INSIDE 0x400


/* Set the mesh rendering flag */
#define MESH(n) (mesh_flag=(n)?0x0100:0x0000)

/* Convert between integer and fixed point */
#define INT2FIX(a) (((int)(a))<<10)
#define FIX2INT(a) (((int)(a))>>10)

/* Create a 5:5:5 RGB color with the MSB set */
#define COLOR(r,g,b)    (((r)&0x1F)|((g)&0x1F)<<5|((b)&0x1F)<<10|0x8000)


typedef struct {
	int x,y,z;
} point3d;


/* Font data, 96 characters, 4bpp */
extern 		unsigned int adore2_pat[];

char		country[18][12] = {
	"Bahamas",
	"Belgium",
	"Chile",
	"Denmark",
	"Finland",
	"France",
	"Germany",
	"Greece",
	"Iceland",

	"India",

	"Ireland",
	"Italy",
	"Norway",
	"Spain",

	"Sweden",
	"Switzerland",

	"Trinidad",
	"USA"
};

char		*maps[18] = {
	&bahamas[0],
	&belgium[0],
	&chile[0],
	&denmark[0],
	&finland[0],
	&france[0],
	&germany[0],
	&greece[0],
	&iceland[0],
	&india[0],
	&ireland[0],
	&italy[0],
	&norway[0],
	&spain[0],
	&sweden[0],
	&switzerland[0],
	&trinidad[0],
	&usa[0]
};


int 		list_index = 1;
int 		theta      = 0;
int			buffer     = 0;
int			flagnum    = 0;
uint16 		mesh_flag  = 0;
uint16		colorLut[256];



point3d 		vtx[264],flag[264];
point3d			camera;

unsigned short 	ang[2];

unsigned char 	base_col[8] = {7,39,71,103,135,167,199,230};
unsigned char 	basecol;

unsigned char	*map, map_ij;



/* Clear command list */
void list_clear(void) {
    uint16 *p = (uint16 *)VDP1_VRAM;
    int i;
    for(i=0;i<16;i++)
        p[i] = 0xFFFF;
    p[CMDCTRL] = 0x4000;
    list_index = 1;
}


/* Add end marker to command list */
void list_end(void) {
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));
    p[CMDCTRL] = 0x8000;
    list_index++;
}


/* Add system clip to command list */
void list_set_system_clip(int16 x, int16 y) {
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));

    p[CMDCTRL] = 0x0009; /* Set system clip */
    p[CMDLINK] = 0x0000; /* Jump address */
    p[CMDXC]   = x;
    p[CMDYC]   = y;
    list_index++;
}


/* Add user clip to command list */
void list_set_user_clip(int16 x1, int16 y1, int16 x2, int16 y2) {
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));

    p[CMDCTRL] = 0x0008; /* Set user clip */
    p[CMDLINK] = 0x0000; /* Jump address */
    p[CMDXA]   = x1;
    p[CMDYA]   = y1;
    p[CMDXC]   = x2;
    p[CMDYC]   = y2;
    list_index++;
}


/* Add local coords to command list */
void list_set_local_coords(int16 x, int16 y) {
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));

    p[CMDCTRL] = 0x000A; /* Set local coords */
    p[CMDLINK] = 0x0000; /* Jump address */
    p[CMDXA]   = x;
    p[CMDYA]   = y;
    list_index++;
}



/* Add local coords to command list */
void list_normal_sprite(int16 x1, int16 y1, int16 width, int16 height, uint32 source, int16 colmode,
                        uint32 coltbl) {
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));

    p[CMDCTRL] = 0x0000; /* Distorted sprite, RGB mode */
    p[CMDLINK] = 0x0000; /* Jump address */
    p[CMDPMOD] = CLIP_DRAW_INSIDE | 0x0080 | mesh_flag | ((colmode&7)<<3);
    p[CMDCOLR] = coltbl>>3;
    p[CMDSRCA] = source>>3;
    p[CMDSIZE] = (((width>>3)&0x3F)<<8)|(height&0xFF);
    p[CMDXA]   = x1;
    p[CMDYA]   = y1;
    list_index++;
}


/* Add local coords to command list */
void list_distorted_sprite(int16 x1, int16 y1, int16 x2, int16 y2, int16 x3, int16 y3,
                           int16 x4, int16 y4, uint32 source, int16 colmode, uint32 coltbl,
                           int w, int h,int16 clipmode) {
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));

    p[CMDCTRL] = 0x0002; /* Distorted sprite, RGB mode */
    p[CMDLINK] = 0x0000; /* Jump address */
    p[CMDPMOD] = clipmode | 0x0080 | mesh_flag | ((colmode&7)<<3);
    p[CMDCOLR] = coltbl>>3;
    p[CMDSRCA] = (source>>3);
    p[CMDSIZE] = (((w>>3)&0x3F)<<8)|(h&0xFF);
    p[CMDXA]   = x1;
    p[CMDYA]   = y1;
    p[CMDXB]   = x2;
    p[CMDYB]   = y2;
    p[CMDXC]   = x3;
    p[CMDYC]   = y3;
    p[CMDXD]   = x4;
    p[CMDYD]   = y4;
    list_index++;
}


/* Add local coords to command list */
void list_polygon(int16 x1, int16 y1, int16 x2, int16 y2, int16 x3, int16 y3, int16 x4, int16 y4,
                  uint16 color, uint32 grda) {
    uint16 *p = (uint16 *)(VDP1_VRAM + (list_index << 5));

    p[CMDCTRL] = 0x0004; /* Polygon */
    p[CMDLINK] = 0x0000; /* Jump address */
    p[CMDPMOD] = 0x00C0 | mesh_flag | 0; //4;
    p[CMDCOLR] = color;
    p[CMDXA]   = x1;
    p[CMDYA]   = y1;
    p[CMDXB]   = x2;
    p[CMDYB]   = y2;
    p[CMDXC]   = x3;
    p[CMDYC]   = y3;
    p[CMDXD]   = x4;
    p[CMDYD]   = y4;
    p[CMDGRDA] = grda>>3;
    list_index++;
}



/* Project the points to screen space */
void project(point3d *in, point3d *out, int n) {
	int i;

	for (i=0; i<n; i++) {
		out[i].x = camera.x + FIX2INT(((in[i].x * camera.z) / (camera.z - FIX2INT(in[i].z))));
		out[i].y = camera.y + FIX2INT(((in[i].y * camera.z) / (camera.z - FIX2INT(in[i].z))));
		out[i].z = in[i].z;
	}
}


/* Print a string at a given position on the screen using sprites */
void draw_text(char *txt, int xpos, int ypos) {
	int i,x,y;
	static int p=0;

	x = 0;

	for (i=0; i<strlen(txt); i++) {
		/* Draw normal characters */
		list_normal_sprite(xpos+x, ypos, 8, 8, 0x50000+((txt[i]-' ')<<5), COLMODE_16_LUT, 0x54000);
		x += 8;
	}
}



/* Switch to another flag */
void switch_flag(int i) {
	if ((i>=0)&&(i<18)) {
		map = maps[i];
		flagnum = i;
	}
}




int main() {
	int i,j,k,m,x,y;
	int xadd,yadd;
	int sizeX,sizeY;
	int iMul22,jMul66;
	uint16 *p,*p2;
	uint16 joy_old,joy_new,joy_delta;
	unsigned short xan,yan,zan,xan2;
	unsigned int *lp;

    vdp_init();
    conio_init();
    pad_init();

    /* Set up VDP1 to appear under VDP2 graphics (0=hide, 1-7=visible) */
    PRISA = 0x0101;
    PRISB = 0x0101;
    PRISC = 0x0101;
    PRISD = 0x0101;

    /* Set up VDP1 registers */
    TVMR = 0x0000;
    FBCR = 0x0000;
    PTMR = 0x0002;
    EWDR = COLOR(0,0,4);    /* Erase color */
    EWLR = 0x0000;          /* Erase range: (0,0) -> (352,240) */
    EWRR = 0x50DF;

	/* Set up the lookup tables for the flag */
  	for (i=0; i<32; i++) {
   		colorLut[i]    = (i<<10)|0x8000;
   		colorLut[i+32] = i|0x8000;
   		colorLut[i+64] = (i<<10)|(i<<5)|i|0x8000;
   		colorLut[i+96] = ((i/3)<<10)|((i/3)<<5)|(i/3)|0x8000;
   		colorLut[i+128]= (((i>>1)+(i>>2)+(i>>3))<<5)|0x8000;
   		colorLut[i+160]= (i<<10)|(i<<5)|i|0x8000;
   		colorLut[i+192]= ((i&30)<<4)|i|0x8000;
   		colorLut[i+224]= (i<<5)|i|0x8000;
  	}

	/* Load the font */
	lp = (unsigned int*)0x25C50000;
	for (i=0; i<0x300; i++)
		*(lp++) = adore2_pat[i];

	/* Set up a palette for the text */
	p = (uint16*)0x25C54000;
	*(p++) = 0;
	for (i=0; i<4; i++) {
		*(p + i) = COLOR(i*8+7,31,31);
		*(p + (7-i)) = COLOR(i*8+7,i*4+19,31);
	}


	camera.x = 48; camera.y = 32; camera.z = -256;

	flagnum = 0;
	joy_old = joy_delta = 0;
  	map = &bahamas[0];

  	ang[0] = ang[1] = 0;


    /* Screen on */
    TVMD = 0x8000;


    list_clear();
    list_end();

    /* Main loop */
    for(;;) {

   		sizeX = 0;
   		xan2 = ang[0];  yan = ang[1];

		/* Place some points along three sine curves. Factors are
		   scaled by 2^10. */
    	for (i=0; i<22; i++) {
       		yadd = FIX2INT(4301 * sin1k[yan&0x3ff]);
       		xan  = xan2;

       		k     = 0;
       		sizeY = 0;
       		for (j=0; j<12; j++) {
          		zan  = xan+(xan>>1)+yan;
          		xadd = FIX2INT(6656 * sin1k[xan & 0x3ff]);

          		vtx[k + i].x = 47104 + sizeX + xadd;
          		vtx[k + i].y = 40960 + sizeY + yadd;
          		vtx[k + i].z = FIX2INT(9728 * sin1k[zan & 0x3ff]);

          		xan   += 45;
          		sizeY += 6707;
          		k     += 22;
       		}
       		yan   += 50;
       		sizeX += 7168;
    	}

		/* Get screen coordinates */
    	project(vtx, flag, 264);


       	FBCR = 0x0001;

        /* Poll joypad */
        joy_old = joy_new;
        joy_new = pad_read(0);
        joy_delta = (joy_new ^ joy_old) & joy_new;

      	if(joy_delta & PAD_LBUTTON)
      		switch_flag(flagnum-1);
      	else if(joy_delta & PAD_RBUTTON)
      		switch_flag(flagnum+1);

		/* Wait for next vblank */
        wait_vblank_out();
        wait_vblank_in();


		TVMD = 0x8000;

      	/* Make new list */
        list_clear();
        list_set_system_clip(320, 224);
        list_set_user_clip(0, 0, 320, 224);
        list_set_local_coords(0, 0);

		/* Turn mesh rendering off */
        MESH(0);

		/* Draw some text on the screen */
		draw_text(country[flagnum],160-(strlen(country[flagnum])<<2),28);
		draw_text("L: Previous",32,192);
		draw_text("R: Next",236,192);

		/* Now render the flag, quad by quad */
    	iMul22 = 0;
    	for (i=0; i<11; i++) {
      		for (j=0; j<21; j++) {
         		map_ij = map[iMul22+j];
         		if (map_ij) {
					/* Get base color and shade */
            		basecol = base_col[map_ij-1];
            		k = ((vtx[iMul22+j].z + 9730)/926)+5;
            		if (k>24) k=24;

					list_polygon(flag[iMul22+j].x,   flag[iMul22+j].y,
					             flag[iMul22+j+1].x, flag[iMul22+j+1].y,
					             flag[iMul22+j+23].x,flag[iMul22+j+23].y,
					             flag[iMul22+j+22].x,flag[iMul22+j+22].y,
                  				 colorLut[basecol+k], 0);
         		}
      		}
      		iMul22 += 22;
    	}

     	ang[0] += 1;
    	ang[1] += 2;

        list_end();
	}

    vdp_shutdown();

	return 0;
}
