! Thinner - Saturn version
! Mic, 2008


	.text
	.global	_start

_start:
	mov.l	RAMCTL,r11
	mov.l	RAMCTL_mask,r6
	mov.w	@r11,r0
	and	r0,r6
	mov.w	r6,@r11
	
	! Set up palette
	mov 	#0,r3
	mov 	#0,r1
	mov 	#0,r2
	mov.l 	colortb,r9
	mov 	#4,r4
	mov.l 	VDP2_CRAM,r8
	mov.w	BIT15,r12
_setpal:
	mov 	#64,r5
_setpal2:
	mov 	r2,r6
	shlr2 	r6
	shll2 	r6
	shll8	r6
	mov 	r1,r7
	shlr2 	r7
	shll2 	r7
	shll2 	r7
	shll 	r7
	or 	r7,r6
	mov 	r3,r7
	shlr2 	r7
	or 	r7,r6
	or 	r12,r6
	mov.w 	r6,@r8
	add 	#2,r8
	mov.w	@r9,r0
	add	r0,r3
	mov.w	@(2,r9),r0
	add	r0,r1
	mov.w	@(4,r9),r0
	dt	r5
	bf/s	_setpal2
	add	r0,r2
	mov.w	@r9,r0
	sub	r0,r3
	mov.w	@(2,r9),r0
	sub	r0,r1
	mov.w	@(4,r9),r0
	sub	r0,r2
	dt	r4
	bf/s	_setpal
	add	#6,r9
	
	mov	#0x40,r8
	shll2	r8
	add 	#0x2e,r11	!Point to MPOFN
	mov	#0,r2
	mov.w	r2,@r11
	add 	#0x3c,r11	! Point to ZMXIN0
	mov.w 	r2,@-r11	! Clear SCYDN0
	mov.w 	r2,@-r11	! SCYIN0
	mov.w 	r2,@-r11	! SCXDN0
	mov.w 	r2,@-r11	! SCXIN0
	add 	#-72,r11	! Point to CHCTLA
	mov	#0x12,r2
	mov.w	r2,@r11
	add	#-8,r11		! Point to BGON
	add	#1,r8
	mov.w	r8,@r11
	add	#-32,r11	! Point to TVMD
	mov.w	r12,@r11
	add 	#4,r11		! Point to TVSTAT
	
_main_loop:

	mov.l	sintb,r0
	mov.l 	vscreen,r5

	mov	#224,r1
	extu.b	r1,r1
_yloop:
	mov	#80,r2
	shll2	r2
_xloop:
	mov	r13,r6
	add	r6,r6
	sub	r8,r6
	mov	r1,r7
	sub	r6,r7
	add	r2,r7
	sub	r12,r7
	extu.b	r7,r7
	add	r7,r7
	mov.w	@(r0,r7),r9
	
	mov	r12,r7
	add	r1,r7
	mov	r13,r6
	add	r2,r6
	add	r6,r6
	sub	r6,r7
	extu.b	r7,r7
	add	r7,r7
	mov.w	@(r0,r7),r6
	add	r6,r9

	extu.b	r2,r7
	add	r7,r7
	mov.w	@(r0,r7),r6
	add	r1,r6
	sub	r2,r6
	add	r14,r6
	extu.b	r6,r6
	add	r6,r6
	mov	r6,r8
	mov.w	@(r0,r6),r7
	add	r7,r9
	
	shlr2	r9
	shlr	r9
	mov.b	r9,@r5

	dt	r2
	bf/s	_xloop
	add	#1,r5
	dt	r1
	bf	_yloop	

_wait_vbl_over:
	mov.w	@r11,r0
	tst	#8,r0	
	bf	_wait_vbl_over
_wait_vbl_start:
	mov.w	@r11,r0
	tst	#8,r0
	bt	_wait_vbl_start

! Copy the 320x224 offscreen buffer to BG0 (which is 512x256)

	mov.l	vscreen,r3
	mov.l	VDP2_VRAM,r8
	mov	#224,r6
	extu.b	r6,r6
	mov	#192,r7
	extu.b	r7,r7
_copy_to_vram_y:
	mov	#80,r2
_copy_to_vram_x:
	mov.l	@r3+,r1
	mov.l	r1,@r8
	dt	r2	
	bf/s	_copy_to_vram_x
	add	#4,r8
	dt	r6
	bf/s	_copy_to_vram_y
	add	r7,r8
	
	
	add	#1,r14
	add	#-1,r12
	add	#1,r13
	extu.b	r12,r12
	bra	_main_loop
	extu.b	r13,r13
	

BIT15:
	.word 0x8000

	.align 2	
RAMCTL:
	.long	0x25f8000e
RAMCTL_mask:
	.long	0xcfff
VDP2_CRAM:
	.long	0x25f00000
vscreen:
	.long	_vscreen
VDP2_VRAM:
	.long	0x25e00000
sintb:
	.long _sintb	
colortb:
	.long _colortb
	
_sintb:
.word 0,11,22,33,44,55,66,77,88,98,108,119,129,139,148,158,167,176,184,193
.word 201,208,216,223,230,236,242,248,253,258,263,267,271,274,277,280,282
.word 284,285,286,287,287,287,287,286,285,283,282,279,277,274,271,267,264
.word 260,255,251,246,241,236,231,225,219,214,208,201,195,189,182,176,169
.word 163,156,149,143,136,130,123,117,110,104,98,92,86,80,74,69,63,58,53
.word 48,43,39,34,30,26,23,19,16,13,10,7,5,3,0,-1,-3,-4,-6,-7,-7,-8,-9,-9
.word -9,-9,-9,-9,-8,-8,-7,-7,-6,-5,-4,-3,-2,-1,-1,0,1,2,3,4,5,6,6,7,7,8
.word 8,8,8,8,8,7,6,6,5,3,2,0,-1,-4,-6,-8,-11,-14,-17,-20,-24,-27,-31,-35
.word -40,-44,-49,-54,-59,-64,-70,-75,-81,-87,-93,-99,-105,-111,-118,-124
.word -131,-137,-144,-150,-157,-164,-170,-177,-183,-190,-196,-202,-208,-215
.word -220,-226,-232,-237,-242,-247,-252,-256,-261,-265,-268,-272,-275,-278
.word -280,-283,-284,-286,-287,-288,-288,-288,-288,-287,-286,-285,-283,-281
.word -278,-275,-272,-268,-264,-259,-254,-249,-243,-237,-231,-224,-217,-209
.word -202,-194,-185,-177,-168,-159,-149,-140,-130,-120,-109,-99,-89,-78
.word -67,-56,-45,-34,-23,-12

_colortb:
.word 2,0,1
.word 0,2,1
.word -1,-1,0
.word -1,-1,-2


.comm	_vscreen,71680,4
	

	