//--------------------------------------------------------------------------//
// iq . 2003 . code for the Paradise 64 kb intro by RGBA                    //
//--------------------------------------------------------------------------//

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#endif
#include <GL/gl.h>
#include "glext.h"
#ifdef LINUX
#include <GL/glx.h>
#endif
#ifdef IRIX
#include <GL/glx.h>
#endif

//--- d a t a ---------------------------------------------------------------

#include "ext.h"

static const char *funcNames = {
    "glCreateProgram\0"
    "glCreateShader\0"
    "glShaderSource\0"
    "glCompileShader\0"
    "glAttachShader\0"
    "glLinkProgram\0"
    "glUseProgram\0"
    "glUniform4fv\0"
    "glUniform1i\0"
    "glGetUniformLocation\0"
    //--
    "glBindRenderbufferEXT\0"
    "glRenderbufferStorageEXT\0"
    "glBindFramebufferEXT\0"
    "glFramebufferTexture2DEXT\0"
    "glFramebufferRenderbufferEXT\0"
    //--
    "glActiveTexture\0"
    //--
    #ifdef DEBUG
    "glGetObjectParameterivARB\0"
    "glGetInfoLogARB\0"
    "glCheckFramebufferStatusEXT"
    #endif
    };

void *myglfunc[NUMFUNCIONES];

int EXT_Init( void )
{
    const char *str = funcNames;
    for( int i=0; i<NUMFUNCIONES; i++ )
    {
        myglfunc[i] = wglGetProcAddress( str );
        if( !myglfunc[i] ) return( 0 );
        for(;*str++;); 
    }

    return( 1 );
}
