/*  SFontTR: a simple hack on simple font-library called SFont :)
    
	For SFontTR:
	Copyright (C) 2005 Ozan Emirhan Bayyurt
    License: GPL or LGPL (at your choice)
    WWW: http://ozanemirhan.blogspot.com

	For Original SFont library:
	Copyright (C) 2003 Karl Bartel
	License: GPL or LGPL (at your choice)
	WWW: http://www.linux-games.com/sfont/

    This program is free software; you can redistribute it and/or modify        
    it under the terms of the GNU General Public License as published by        
    the Free Software Foundation; either version 2 of the License, or           
    (at your option) any later version.                                         
                                                                                
    This program is distributed in the hope that it will be useful,       
    but WITHOUT ANY WARRANTY; without even the implied warranty of              
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
    GNU General Public License for more details.                
                                                                               
    You should have received a copy of the GNU General Public License           
    along with this program; if not, write to the Free Software                 
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   

    Ozan Emirhan Bayyurt
    ragnor_whr@yahoo.com												
*/                                                                            

/************************************************************************ 
*          SFONTTR - SDL Font Library by Ozan Emirhan Bayyurt           *
*                                                                       *
*  One day i neeeded turkish characters with SFont. But SFont supports  *
*  only  standart ascii chars. So i tweaked the library and created     *
*  this. SFontTR supports turkish characters and maybe it support some  *
*  other language-specific characters, i don't know. Try and tell me    *
*  the results.	Except for turkish (and maybe some other :)) character  *
*  support, it still uses the old functions, etc. So you don't need to  *
*  learn any new stuff. Cheers :).                                      *
*  One more thing. I don't want to use SDL_Image library wtih SFont so	*
*  i changed the font file format to bmp. Still API didn't change.      *
*                                                                       *
************************************************************************/

/************************************************************************ 
*    SFONT - SDL Font Library by Karl Bartel <karlb@gmx.net>            *
*                                                                       *
*  All functions are explained below. For further information, take a   *
*  look at the example files, the links at the SFont web site, or       *
*  contact me, if you problem isn' addressed anywhere.                  *
*                                                                       *
************************************************************************/

#ifndef SFONT_H
#define SFONT_H

#include <SDL.h>

#ifdef __cplusplus 
extern "C" {
#endif

// Delcare one variable of this type for each font you are using.
// To load the fonts, load the font image into YourFont->Surface
// and call InitFont( YourFont );
typedef struct {
	SDL_Surface *Surface;	
	int CharPos[4096];
	int MaxPos;
} SFont_Font;

// Initializes the font
// Font: this contains the suface with the font.
//       The Surface must be loaded before calling this function
SFont_Font* SFont_InitFont (SDL_Surface *Font);

// Frees the font
// Font: The font to free
//       The font must be loaded before using this function.
void SFont_FreeFont(SFont_Font* Font);

// Blits a string to a surface
// Destination: the suface you want to blit to
// text: a string containing the text you want to blit.
void SFont_Write(SDL_Surface *Surface, const SFont_Font *Font, int x, int y,
				 const char *text);

// Returns the width of "text" in pixels
int SFont_TextWidth(const SFont_Font* Font, const char *text);
// Returns the height of "text" in pixels (which is always equal to Font->Surface->h)
int SFont_TextHeight(const SFont_Font* Font);

// Blits a string to Surface with centered x position
void SFont_WriteCenter(SDL_Surface *Surface, const SFont_Font* Font, int y,
					   const char *text);

#ifdef __cplusplus
}
#endif

#endif /* SFONT_H */
