;1982
;ZX Spectrum 48, 256b intro
;code - .ded^RMDA
;21.10.2021, Russia, Samara

;duration: 1 min 50 sec. + infinite loop with different patterns

;how to build:
;use SjASMplus https://github.com/z00m128/sjasmplus
;sjasmplus.exe 1982.asm

;code footprint:
;31b - Reset FX
;39b - Print two text strings
;08b - Delay
;60b - Text strings data
;95b - Save/load FX
;13b - RRC (HL) scroll
;10b - Initializations, loops, and other additional payload
;---------------------------------------------------------------
;powered by https://zxn.ru and https://skoolkid.github.io/rom/

	DEVICE	ZXSPECTRUM48

	org	#fbf8		;48K edition - 64504 / #fbf8
;!!!	org	#7bf8		;16K edition - 31736 / #7bf8

begin:	di
	ld	b,3

;-------'Reset' FX forked from original ROM routine-------------
reset:	
	ld	h,#fa		;48kb edition
;!!!	ld	h,#7a		;16kb edition + standart font

	ld	sp,hl
	ld	a,#3f
	ld	r,a
	out	(#fe),a
ramfill:
	ld	(hl),#02
	dec	hl
	cp	h
	jr	nz,ramfill
ramdec:
	ex	(sp),hl		;+19T delay
	ex	(sp),hl		;+19T delay
	inc	hl
	dec	(hl)
	dec	(hl)
	jr	z,ramdec

	djnz	reset

;-------Set screen attributes-----------------------------------
attrs:	ld	(hl),#38	;INK 0, PAPER 7
	dec	hl
	ld	a,h
	cp	#57
	jr 	nz,attrs

;-------Print two text strings----------------------------------
	ld	hl,text1
	call	text		;print 1st text string + delay
	call	text		;print 2nd text string + delay

;-------Set flash attribute on 'F'------------------------------
	ld	h,#5a		;ld	a,%11111000
	ld	(hl),l		;ld	(#5af7),a

;-------Modified 'SAVE' routine from ROM------------------------
;This one do nothing but visual and audio FX of loading/saving.
;Some original comments and LABELS from ROM disassembly.
;Of coz it is possible to save some bytes here and there...

	ld	d,#1b
	ld	ixh,#40		;ld	ix,#4000
SA_BYTES:
 	ld	h,#0c		;This constant will give a leader of about 2 seconds for a program/data block.
SA_FLAG:
	inc	de		;The 'length' is incremented and the 'base address' reduced to allow for the flag.
	dec	ix

;A loop is now entered to create the pulses of the leader. Both the 'MIC on' and the 'MIC off' pulses are 2,168 T states in length. The color of the border changes from red to cyan with each 'edge'.
;Note: an 'edge' will be a transition either from 'on' to 'off', or from 'off' to 'on'.

SA_LEADER:
	djnz	SA_LEADER	;The main timing period.
	out	(#fe),a		;MIC on/off, border red/cyan, on each pass.
	xor	#0f		;xor H is interesting but... TAKOE
	ld	b,#a4		;The main timing constant.
	dec	l		;Decrease the low counter.
	jr	nz,SA_LEADER	;Jump back for another pulse.
	dec	b		;Allow for the longer path (reduce by 13 T states).
	dec	h		;Decrease the high counter.
	jr	nz,SA_LEADER	;Jump back for another pulse until completion of the leader.

;A sync pulse is now sent.

SA_SYNC_1:
	djnz	SA_SYNC_1	;MIC off for 667 T states from 'OUT to OUT'.
	out	(#fe),a		;MIC on and red.
	ld	a,#0d		;Signal 'MIC off and cyan'.
	ld	b,#37		;MIC on for 735 T States from 'OUT to OUT'.
SA_SYNC_2:
	djnz	SA_SYNC_2
	out	(#fe),a		;Now MIC off and border cyan.
;The header v. program/data flag will be the first byte to be saved.

	ld	bc,#3b0e	;+3B is a timing constant; +0E signals 'MIC off and yellow'.
	ld	l,a
	jr	SA_START	;Jump forward into the saving loop.

;The byte saving loop is now entered. The first byte to be saved is the flag; this is followed by the actual data bytes and the final byte sent is the parity byte that is built up by considering the values of all the earlier bytes.

SA_LOOP:
	ld	a,d		;The 'length' counter is tested and the jump taken when it has reached zero.
	or	e
	jr	z,SA_LOOP_P
	ld	l,a
SA_LOOP_P:
	ld	a,h		;Fetch the current 'parity'.
	xor	l		;Include the present byte.
SA_START:
	ld	h,a		;1 byte saver but sound not so random	;Restore the 'parity'. Note that on entry here the 'flag' value initializes 'parity'.
	ld	a,#01		;Signal 'MIC on and blue'.
	scf			;1 byte saver ; Set the carry flag. This will act as a 'marker' for the 8 bits of a byte.
	jr	SA_8_BITS	;Jump forward.

;When it is time to send the 'parity' byte then it is transferred to the L register for saving.
;The following inner loop produces the actual pulses. The loop is entered at SA_BIT_1 with the type of the bit to be saved indicated by the carry flag. Two passes of the loop are made for each bit thereby making an 'off pulse' and an 'on pulse'. The pulses for a reset bit are shorter by 855 T states.

SA_BIT_2:
	ld	a,c		;Come here on the second pass and fetch 'MIC off and yellow'.
	bit	7,b		;Set the zero flag to show 'second pass'.
SA_BIT_1:	
	djnz	SA_BIT_1	;The main timing loop; always 801 T states on a second pass.
	jr	nc,SA_OUT	;Jump, taking the shorter path, if saving a '0'.
	ld	b,#42		;However if saving a '1' then add 855 T states.
SA_SET:	
	djnz	SA_SET
SA_OUT:	out	(#fe),a		;On the first pass 'MIC on and blue' and on the second pass 'MIC off and yellow'.
	ld	b,#3e		;Set the timing constant for the second pass.
	jr	nz,SA_BIT_2	;Jump back at the end of the first pass; otherwise reclaim 13 T states.
	dec	b
	xor	a		;Clear the carry flag and set A to hold +01 (MIC on and blue) before continuing into the '8 bit loop'.
	inc	a

;The '8 bit loop' is entered initially with the whole byte in the L register and the carry flag set. However it is re-entered after each bit has been saved until the point is reached when the 'marker' passes to the carry flag leaving the L register empty.

SA_8_BITS:
	rl	l		;Move bit 7 to the carry and the 'marker' leftwards.
	jr	nz,SA_BIT_1	;Save the bit unless finished with the byte.
	dec	de		;Decrease the 'counter'.
;---------------------------------------------------------------
	ld	a,r
	and	e
	ld	(ix+1),a
;---------------------------------------------------------------
	inc	ix		;Advance the 'base address'.
	ld	b,#31		;Set the timing constant for the first bit of the next byte.
	ld	a,d		;Otherwise test the 'counter' and jump back even if it has reached zero (so as to send the 'parity' byte).
	inc	a
	jr	nz,SA_LOOP
;-------End of 'SAVE' sequnce-----------------------------------

;-------Final roll FX-------------------------------------------
roll:	ld	h,#57		
roll2:	rrc	(hl)
	dec	hl
	dec	l
	dec	hl
	cp	h
	jr	nz,roll2
	dec	d
	jr	nz,roll
	jp	begin

;-------Print string routine------------------------------------
text:	ld	de,#50e1
textp:	ld	a,(hl)
	inc	hl		;INC HL here provide actual HL for next message
	or	a		;END of text control 
				;There are steps for optimization here:
				;-1 byte if ADC A,A + no need to ADD A,A later
				;-1 byte if JR C,DELAY and END of text control via BIT7
	jr	z,delay		;both of them known, but not used in this intro.

	push	hl

;-------Character > font calculation----------------------------
; 	rlca		;1) TURBO90.ROM edition - https://zxpress.ru/book_articles.php?id=326
;	add	hl,hl	;2) Alone Coder edition - http://zxpress.ru/article.php?id=8880
	add	a,a	;3) "Ded approved" edition
	ld	l,a
	ld	h,#0f		;for system font at #3d00
;!!!	ld	h,#1f		;for custom font at #7d00
	add	hl,hl
	add	hl,hl

;-------Print one character-------------------------------------
	ld	b,8
	push	de	
bytepr:	ld	a,(hl)
	ld	(de),a
	inc	d
	inc	l
	djnz	bytepr
	pop	de
	pop	hl
;---------------------------------------------------------------
	inc	e
	jr	textp

;-------Delay routine-------------------------------------------
delay:	defb	#16	;on the first pass this is LD D,#10 + CP
delay1:	djnz	delay1  ;on the second pass this is just DJNZ
	dec	de
	ld	a,d
	or	e
	jr	nz,delay1
	ret

;---------------------------------------------------------------
text1:	defm	#7F," 1982 Sinclair Research Ltd"
	defb	0                               ;29
text2:	defm	"Start tape, then press F to..."
	defb	0                               ;31
;---------------------------------------------------------------

finish:	
	SAVESNA	"1982.sna", begin
	SAVEBIN	"1982.bin", begin, finish-begin
	EMPTYTRD"1982.trd","1982"
	SAVETRD	"1982.trd","1982.C",begin,finish-begin
;-------=RMDA=---------------------------------------------[eof]

;!!! copy font section before FINISH to build intro + font

;-------ZX Spectrum default font from ROM-----------------------
	defs	8,0		;align font to #xx00
zxfont:
	defb #00,#00,#00,#00,#00,#00,#00,#00 ;SPACE
	defs 8,0;	defb #00,#10,#10,#10,#10,#00,#10,#00 ;!
	defs 8,0;	defb #00,#24,#24,#00,#00,#00,#00,#00 ;"
	defs 8,0;	defb #00,#24,#7e,#24,#24,#7e,#24,#00 ;#
	defs 8,0;	defb #00,#08,#3e,#28,#3e,#0a,#3e,#08 ;$
	defs 8,0;	defb #00,#62,#64,#08,#10,#26,#46,#00 ;%
	defs 8,0;	defb #00,#10,#28,#10,#2a,#44,#3a,#00 ;&
	defs 8,0;	defb #00,#08,#10,#00,#00,#00,#00,#00 ;'
	defs 8,0;	defb #00,#04,#08,#08,#08,#08,#04,#00 ;(
	defs 8,0;	defb #00,#20,#10,#10,#10,#10,#20,#00 ;)
	defs 8,0;	defb #00,#00,#14,#08,#3e,#08,#14,#00 ;*
	defs 8,0;	defb #00,#00,#08,#08,#3e,#08,#08,#00 ;+
	defs 8,0;	defb #00,#00,#00,#00,#00,#08,#08,#10 ;,
	defs 8,0;	defb #00,#00,#00,#00,#3e,#00,#00,#00 ;-
	defb #00,#00,#00,#00,#00,#18,#18,#00 ;.
	defs 8,0;	defb #00,#00,#02,#04,#08,#10,#20,#00 ;/
	defs 8,0;	defb #00,#3c,#46,#4a,#52,#62,#3c,#00 ;0
	defb #00,#18,#28,#08,#08,#08,#3e,#00 ;1
	defb #00,#3c,#42,#02,#3c,#40,#7e,#00 ;2	
	defs 8,0;	defb #00,#3c,#42,#0c,#02,#42,#3c,#00 ;3
	defs 8,0;	defb #00,#08,#18,#28,#48,#7e,#08,#00 ;4
	defs 8,0;	defb #00,#7e,#40,#7c,#02,#42,#3c,#00 ;5
	defs 8,0;	defb #00,#3c,#40,#7c,#42,#42,#3c,#00 ;6
	defs 8,0;	defb #00,#7e,#02,#04,#08,#10,#10,#00 ;7
	defb #00,#3c,#42,#3c,#42,#42,#3c,#00 ;8
	defb #00,#3c,#42,#42,#3e,#02,#3c,#00 ;9
	defs 8,0;	defb #00,#00,#00,#10,#00,#00,#10,#00 ;:
	defs 8,0;	defb #00,#00,#10,#00,#00,#10,#10,#20 ;;
	defs 8,0;	defb #00,#00,#04,#08,#10,#08,#04,#00 ;<
	defs 8,0;	defb #00,#00,#00,#3e,#00,#3e,#00,#00 ;=
	defs 8,0;	defb #00,#00,#10,#08,#04,#08,#10,#00 ;>
	defs 8,0;	defb #00,#3c,#42,#04,#08,#00,#08,#00 ;?
	defs 8,0;	defb #00,#3c,#4a,#56,#5e,#40,#3c,#00 ;@
	defs 8,0;	defb #00,#3c,#42,#42,#7e,#42,#42,#00 ;A
	defs 8,0;	defb #00,#7c,#42,#7c,#42,#42,#7c,#00 ;B
	defs 8,0;	defb #00,#3c,#42,#40,#40,#42,#3c,#00 ;C
	defs 8,0;	defb #00,#78,#44,#42,#42,#44,#78,#00 ;D
	defs 8,0;	defb #00,#7e,#40,#7c,#40,#40,#7e,#00 ;E
	defb #00,#7e,#40,#7c,#40,#40,#40,#00 ;F
	defs 8,0;	defb #00,#3c,#42,#40,#4e,#42,#3c,#00 ;G
	defs 8,0;	defb #00,#42,#42,#7e,#42,#42,#42,#00 ;H
	defs 8,0;	defb #00,#3e,#08,#08,#08,#08,#3e,#00 ;I
	defs 8,0;	defb #00,#02,#02,#02,#42,#42,#3c,#00 ;J
	defs 8,0;	defb #00,#44,#48,#70,#48,#44,#42,#00 ;K
	defb #00,#40,#40,#40,#40,#40,#7e,#00 ;L
	defs 8,0;	defb #00,#42,#66,#5a,#42,#42,#42,#00 ;M
	defs 8,0;	defb #00,#42,#62,#52,#4a,#46,#42,#00 ;N
	defs 8,0;	defb #00,#3c,#42,#42,#42,#42,#3c,#00 ;O
	defs 8,0;	defb #00,#7c,#42,#42,#7c,#40,#40,#00 ;P
	defs 8,0;	defb #00,#3c,#42,#42,#52,#4a,#3c,#00 ;Q
	defb #00,#7c,#42,#42,#7c,#44,#42,#00 ;R
	defb #00,#3c,#40,#3c,#02,#42,#3c,#00 ;S
	defs 8,0;	defb #00,#fe,#10,#10,#10,#10,#10,#00 ;T
	defs 8,0;	defb #00,#42,#42,#42,#42,#42,#3c,#00 ;U
	defs 8,0;	defb #00,#42,#42,#42,#42,#24,#18,#00 ;V
	defs 8,0;	defb #00,#42,#42,#42,#42,#5a,#24,#00 ;W
	defs 8,0;	defb #00,#42,#24,#18,#18,#24,#42,#00 ;X
	defs 8,0;	defb #00,#82,#44,#28,#10,#10,#10,#00 ;Y
	defs 8,0;	defb #00,#7e,#04,#08,#10,#20,#7e,#00 ;Z
	defs 8,0;	defb #00,#0e,#08,#08,#08,#08,#0e,#00 ;[
	defs 8,0;	defb #00,#00,#40,#20,#10,#08,#04,#00 ;\
	defs 8,0;	defb #00,#70,#10,#10,#10,#10,#70,#00 ;]
	defs 8,0;	defb #00,#10,#38,#54,#10,#10,#10,#00 ;^
	defs 8,0;	defb #00,#00,#00,#00,#00,#00,#00,#ff ;_
	defs 8,0;	defb #00,#1c,#22,#78,#20,#20,#7e,#00 ;pound
	defb #00,#00,#38,#04,#3c,#44,#3c,#00 ;a
	defs 8,0;	defb #00,#20,#20,#3c,#22,#22,#3c,#00 ;b
	defb #00,#00,#1c,#20,#20,#20,#1c,#00 ;c
	defb #00,#04,#04,#3c,#44,#44,#3c,#00 ;d
	defb #00,#00,#38,#44,#78,#40,#3c,#00 ;e
	defs 8,0;	defb #00,#0c,#10,#18,#10,#10,#10,#00 ;f
	defs 8,0;	defb #00,#00,#3c,#44,#44,#3c,#04,#38 ;g
	defb #00,#40,#40,#78,#44,#44,#44,#00 ;h
	defb #00,#10,#00,#30,#10,#10,#38,#00 ;i
	defs 8,0;	defb #00,#04,#00,#04,#04,#04,#24,#18 ;j
	defs 8,0;	defb #00,#20,#28,#30,#30,#28,#24,#00 ;k
	defb #00,#10,#10,#10,#10,#10,#0c,#00 ;l
	defs 8,0;	defb #00,#00,#68,#54,#54,#54,#54,#00 ;m
	defb #00,#00,#78,#44,#44,#44,#44,#00 ;n
	defb #00,#00,#38,#44,#44,#44,#38,#00 ;o
	defb #00,#00,#78,#44,#44,#78,#40,#40 ;p
	defs 8,0;	defb #00,#00,#3c,#44,#44,#3c,#04,#06 ;q
	defb #00,#00,#1c,#20,#20,#20,#20,#00 ;r
	defb #00,#00,#38,#40,#38,#04,#78,#00 ;s
	defb #00,#10,#38,#10,#10,#10,#0c,#00 ;t
	defs 8,0;	defb #00,#00,#44,#44,#44,#44,#38,#00 ;u
	defs 8,0;	defb #00,#00,#44,#44,#28,#28,#10,#00 ;v
	defs 8,0;	defb #00,#00,#44,#54,#54,#54,#28,#00 ;w
	defs 8,0;	defb #00,#00,#44,#28,#10,#28,#44,#00 ;x
	defs 8,0;	defb #00,#00,#44,#44,#44,#3c,#04,#38 ;y
	defs 8,0;	defb #00,#00,#7c,#08,#10,#20,#7c,#00 ;z
	defs 8,0;	defb #00,#0e,#08,#30,#08,#08,#0e,#00 ;{
	defs 8,0;	defb #00,#08,#08,#08,#08,#08,#08,#00 ;|
	defs 8,0;	defb #00,#70,#10,#0c,#10,#10,#70,#00 ;}
	defs 8,0;	defb #00,#14,#28,#00,#00,#00,#00,#00 ;~
	defb #3c,#42,#99,#a1,#a1,#99,#42,#3c ;(c)
;-------end of ZX Spectrum default font from ROM----------------
