@ **** Nintendo include files ****

#include "gba.h"

@#include "AgbDefine.s"
@#include "AgbMemoryMap.s"
@#include "AgbSyscallDefine.s"


@ **** CONSTANTS ****

WELL_SB       =  8  @ screenbase for the well
SPIRAL_SB     =  9  @ screenbase for the spiral background
TEXT_SB       = 10  @ screenbase for the score & lines text

NO_CHANNELS   =  8  @ number of wav channels

DEF_FALLSPEED = 30  @ fall every 30th frame (until 64 lines cleared)
DOWNFALL      =  2  @ if pressing down, fall every 2nd frame
LRFIRST       = 10  @ after first left/right press, wait 10 frames before next move
LRNEXT        =  5  @ after second left/right press, wait 5 frames before next move

FX_rotate     = 11  @ sample when rotating a piece
FX_move       = 12  @ sample when moving a piece left/right
FX_drop       = 13  @ sample when piece has been put down (no lines cleared)
FX_clear      = 14  @ sample when clearing 1-3 lines
FX_tetris     = 15  @ sample when clearing 4 lines
FX_gameover   = 16  @ sample when game over

cosTable      = (EX_WRAM_END-0x5000)   @ start of cos/sin table

BUFSIZE       = 352     @ 352 samples are played each frame 
PLAYFREQ      = 21025   @ Playing frequency

G_SAW         = 0   @ Wav type SAW
G_SQU         = 1   @ Wav type SQUARE
G_NOI         = 2   @ Wav type NOISE

@ **** STRUCTURES ****

@ Software mixing structure

MIX_VOL    =  0
MIX_POS    =  4
MIX_END    =  8
MIX_FREQ   = 12
MIX_CNT    = 16
@MIX_START  = 20  @ Loop feature removed
MIX_SIZEOF = 32

@ Sample structure

SMP_OFS    =  0
SMP_LEN    =  4
@SMP_LOOP   =  8  @ Loop feature removed
SMP_SIZEOF = 16

@ Channel structure (song player)

CH_PATSTART =  0  @ r4
CH_PATPOS   =  4  @ r5
CH_POS      =  8  @ r6
CH_CURSMP   = 12  @ r7
CH_DEFVOL   = 16  @ r8
CH_VOLENV   = 20  @ r9
CH_CNT      = 24
CH_SIZEOF   = 28

@ Song structure (song player)

SONG_DATA    =  0  @ r2
SONG_NOCH    =  4  @ r3
SONG_BPM     =  8  @ r4
SONG_SPEED   = 12  @ r5
SONG_TICK    = 16  @ r6
SONG_TICKCNT = 20  @ r7
SONG_NOTELEN = 24
SONG_CH      = 36
SONG_SIZEOF  = SONG_CH+CH_SIZEOF*NO_CHANNELS

@ Sample info structure

SI_FREQ     =  0
SI_PITCH    =  2
SI_AMP      =  3
SI_SUSTAIN  =  4
SI_RELEASE  =  6
SI_CUT      =  8
SI_RES      =  9
SI_CUT_ENV  = 10
SI_RES_ENV  = 12
SI_FLAG     = 13
SI_SIZEOF   = 14

@ **** MACROS ****


@ r0 = src, r1=dest
.macro dmacopy size
	ldr	r2,=((\size)>>1) | DMA_ENABLE | DMA_16BIT_BUS
	add r3,r11,#OFFSET_REG_DMA3
	stmia r3,{r0-r2}
.endm

@ r0 = src, r1=dest
.macro dmacopy4 size
	ldr	r6,=((\size)>>1) | DMA_ENABLE | DMA_16BIT_BUS
	add r7,r11,#OFFSET_REG_DMA3
	stmia r7,{r4-r6}
.endm

@ r0 = data, r1=dest
.macro dmaclear size
	strh r0,[r1]
	mov r0,r1
	ldr	r2,=((\size)>>1) | DMA_ENABLE | DMA_16BIT_BUS | DMA_TIMMING_IMM | DMA_DEST_INC | DMA_SRC_FIX
	add r3,r11,#OFFSET_REG_DMA3
	stmia r3,{r0-r2}
.endm

#define W(lo,hi) ((lo) | ((hi)<<8))
