;****************************************************************
;*                                                              *
;*                            GB4Real                           *
;*                                                              *
;*                           Version 1                          *
;*                                                              *
;* This is the include-file for GB4Real. Please see GB4REAL.Z80 *
;* for more info.                                               *
;*                                                              *
;****************************************************************



WaitForVRAM: MACRO
;*********************************
;* Wait until VRAM is available. * 
;* A is destroyed.               *
;*********************************

  ldh a,[$41] 
  and 2
  jr nz,@-4     ; Wait for retrace

ENDM



vld: MACRO
;************************************
;* video ld: makes sure VRAM is     *
;* available before writing a byte. *
;************************************

  IF (STRLWR("\2") == "a")
    push af
    WaitForVRAM
    pop af
  ELSE
    WaitForVRAM
  ENDC

  ld \1,\2

ENDM



SetupSpriteHandler: MACRO
;*****************************
;* sets up a sprite handler. *
;*****************************

  ;* check params *

  IF (STRCMP(STRUPR("\2"), "MANUAL") != 0) && (STRCMP(STRUPR("\2"), "AUTO") != 0) 
    FAIL "Parameter 2 should be either AUTO or MANUAL"
  ENDC

  
  ;* Copy handler to high ram *

  ld c,.SpriteCopyEnd\@-.SpriteCopy\@
  ld hl,$FF80
  ld de,.SpriteCopy\@
.L2\@:
  ld a,[de]
  inc de
  ld [hl+],a
  dec c
  jr nz, .L2\@


  ;* when in AUTO, set up the int *

  IF (STRCMP(STRUPR("\2"), "AUTO") == 0)
    di

    PUSHS
    SECTION "V-Blank int (GB4Real)", HOME[$0040]
      jp $FF80                  ; set V-Blank vector
    POPS

    ld hl, $FFFF                ; Get current enabled ints
    ld a,[hl]
    or $01                      ; Enable V-Blank
    ld [hl],a

    ei
  ENDC

  ;* pass over copied function *
  jr .L3\@



.SpriteCopy\@:
;***************************************
;* [Internal] pump sprites to OAM-ram. *
;***************************************

  IF (STRCMP(STRUPR("\2"), "AUTO") == 0)
    push af
  ELSE
    WaitForVRAM
  ENDC

  ld a, \1 >> 8
  ldh [$46],a
  ld a,$28
.Wait\@:
    dec a
  jr nz,.Wait\@

  IF (STRCMP(STRUPR("\2"), "AUTO") == 0)
    pop af
    reti
  ELSE
    ret
  ENDC

.SpriteCopyEnd\@:

.L3\@:

ENDM


SpriteRefresh: MACRO
;**********************
;* Refreshes OAM-ram. *
;**********************
  call $FF80
ENDM


;**********************************
;*         MAIN FUNCTIONS         *
;**********************************

 GLOBAL CleanUp
