;
;                *****************************************
;                ***                                   ***
;                ***            MegaMan_X's            ***
;                ***                                   ***
;                ***           Terminator  2           ***
;                ***        Digital Audio Demo         ***
;                ***                                   ***
;                ***             Coded for:            ***
;                ***   GameBoy Demo Competition 1998   ***
;                ***                                   ***
;                ***         Special thanks to:        ***
;                ***  Carolco Pictures (great movie!)  ***
;                ***  Anders Granlund (playback code)  ***
;                ***                                   ***
;                *****************************************
;
;
; Coded for:
; Advanced GameBoy IDE v0.70 and up
;
; Code donated to public domain.
; Please don't ask any question, I don't have time.
; Please don't ask me to convert this listing for GBDK or anything else,
; as I only know how to code for my own assembler.
;
; Copyrights:
; - Terminator 2 (title, image, music) copyright (C) 199x Carolco Pictures.
; - This listing copyright (C) 1998 MegaMan_X, donated to public domain.
; - Advanced GameBoy IDE is copyright (C) 1996,1997,1998 MegaMan_X.
; - Advanced PCX to GameBoy converter is copyright (C) 1997,1998 MegaMan_X.
; - All images copyright (C) their respective owners.
; - GameBoy, GameBoy Pocket and Super GameBoy are trademarks (TM) of Nintendo
;
 
;*** Variables ************************************************************
                                                                           
; samp_cnt_h       .equ CD00h
; samp_cnt_l       .equ CD01h
; samp_pos_h       .equ CD02h
; samp_pos_l       .equ CD03h
; bank_nbr         .equ CD04h
                             
;*** RST 00h ***
.org  0000h
 ret
    
;*** RST 08h ***
.org  0008h
 ret
    
;*** RST 10h ***
.org  0010h
 ret
    
;*** RST 18h ***
.org  0018h
 ret
    
;*** RST 20h ***
.org  0020h
 ret
    
;*** RST 28h ***
.org  0028h
 ret
    
;*** RST 30h ***
.org  0030h
 push AF
 mov  A,11010001b       ; Set BG & Window Tile Data to [8000h]
 mov  [FF40h],A
 mov  A,072d            ; Set LCDC IRQ at line 72
 mov  [FF45h],A
 pop  AF
 ret
    
;*** RST 38h ***
;.org  0038h
; ret
     
;*** Vertical blanking IRQ ***
.org  0040h
 rst  30h
 reti
     
;*** LCD status IRQ ***
.org  0048h
 jmp  @LCD_int
              
;*** Timer owerflow IRQ ***
.org  0050h
 jmp  @TIMER_int
                
;*** Serial transfer completion IRQ ***
.org  0058h
; reti
      
;*** GamePad IRQ ***
.org  0060h
; reti
      
;*** LCD interrupt routine (from 0048h) *************************************
.org 0068h
LCD_int:
 push AF
LCD_int_Loop:
 mov  A,[FF41h]
 bit  A.1
 jnz  @LCD_int_Loop
 mov  A,11000001b
 mov  [FF40h],A
 pop  AF
 reti
     
     
;*** GameBoy "Boot Sector" **************************************************
                                                                             
.org 0101h
 jmp @Start
           
.binfile "NINLOGO.BIN"  ; Use original logo for GB compatibility
                                                                
.dt "MEGAMAN_X T2DEMO"  ; GamePak name (16 characters)
.dw C0DEh               ; New Licensee Code (two digits)
                        ; C0DE = MegaMan_X
.db 00h                 ; Super GameBoy Features (00 = none, 03h = SGB)
.db 00h                 ; ROM Only
.db 00h                 ; ROM Size 32k
.db 00h                 ; RAM Size  0k
.db 01h                 ; Destination code (00h = Japan, 01h = Other)
.db 33h                 ; Old Licensee Code (one digit / 33h = see new code)
.db 01h                 ; Version
                                 
                                 
;*** Begin ******************************************************************
Start:
.org  0150h
           
 di
   
 mov  SP,FFF4h          ; Init stack ptr
                                        
;*** [FFFFh] Interrupts Enable (0:Off / 1:On) ***
; bit4 - GamePad IRQ
; bit3 - Serial I/O Transfer Complete
; bit2 - Timer Overflow
; bit1 - LCDC
; bit0 - VBlank
 mov  A,00000011b       ; Enable LCDC & VBlank IRQs
 mov  [FFFFh],A
               
;*** [FF40h] - LCD Control ***
; LCD Controller          0:Off / 1:On
; Window Tile Map         0:[9800h]-[9BFFh] / 1:[9C00h]-[9FFFh]
; Window Display          0:Off / 1:On
; BG & Window Tile Data   0:[8800h]-[97FFh] / 1:[8000h]-[8FFFh]
; Background Tile Map     0:[9800h]-[9BFFh] / 1:[9C00h]-[9FFFh]
; Sprites Size            0:8x8 / 1:16x8
; Sprites Display         0:Off / 1:On
; Background Display      0:Off / 1:On
 mov  A,01010001b
 mov  [FF40h],A
               
;*** [FF41h] - LCDC Status ***
 mov  A,01000100b       ; Make IRQ when refresh line = [FF45h]
 mov  [FF41h],A
               
 call @SetStuff         ; Set Palette, Background & Window position
 call @SetTiles1        ; Set Background Tile Map (first 240 tiles)
 call @SetTiles2        ; Set Background Tile Map (last 120 tiles)
                                                                  
;*** LCD Control ***
 mov  A,11010001b
 mov  [FF40h],A
               
 ei
   
 call @BackgroundOff
                    
Loop:
     
 mov  BC,@MMX-Presents
 call @CopyFadeIn
 call @FadeOut
              
 mov  BC,@T2-Title
 call @CopyFadeIn
 call @FadeOut
              
 call @SetTiles3        ; Clear last 120 tiles
 mov  BC,@T800
 call @CopyFadeIn
                 
 mov  A,00000101b       ; LCDC,VBlank and Timer ints
 mov  [FFFFh],A
               
 call @StartMusic
                 
Main:
 jmp  @Main
           
           
;*** Copy & Fade-in picture *************************************************
CopyFadeIn:
 call @CopyTiles
 call @BackgroundOn
 call @BgFadeIn
 ret
    
    
;*** Copy & Fade-out picture ************************************************
FadeOut:
 mov  C,12h
 call @CtrDelay
 call @BgFadeOut
 call @BackgroundOff
 ret
    
    
;*** Background Fade-out ****************************************************
BgFadeOut:
 push AF
 push BC
        
 mov  A,00000110b
 mov  [FF47h],A
               
 mov  C,01h
 call @CtrDelay
               
 mov  A,00000001b
 mov  [FF47h],A
               
 mov  C,01h
 call @CtrDelay
               
 mov  A,00000000b
 mov  [FF47h],A
               
 pop  BC
 pop  AF
 ret
    
    
;*** Background Fade-in *****************************************************
BgFadeIn:
 push AF
 push BC
        
 mov  A,00000001b
 mov  [FF47h],A
               
 mov  C,01h
 call @CtrDelay
               
 mov  A,00000110b
 mov  [FF47h],A
               
 mov  C,01h
 call @CtrDelay
               
 mov  A,00011011b
 mov  [FF47h],A
               
 pop  BC
 pop  AF
 ret
    
;*** Register-based delay (Entry = C) ***************************************
CtrDelay:
 push HL
CtrDelayLoop1:
 mov  H,7Fh
CtrDelayLoop2:
 mov  L,FFh
CtrDelayLoop3:
 dec  L
 jnz  @CtrDelayLoop3
 dec  H
 jnz  @CtrDelayLoop2
 dec  C
 jnz  @CtrDelayLoop1
 pop  HL
 ret
    
    
;*** Set everyting off to get ready to copy new background data *************
                                                                             
BackgroundOff:
 di
 mov A,01010001b        ; LCD Off, Background On Tile=8000h Map=9800h
 mov [FF40h],A
 ret
    
    
;*** Set everyting on (LCD, background, interrupts) *************************
                                                                             
BackgroundOn:
 mov A,11010001b        ; LCD On, Background On Tile=8000h Map=9800h
 mov [FF40h],A
 ei
 ret
    
    
;*** Set Window Position at bottom of screen ********************************
                                                                             
SetStuff:
 xor  A
 mov  [FF42h],A         ; Background Scroll Y = 0
 mov  [FF43h],A         ; Background Scroll X = 0
 mov  A,00000000b       ; Set Background palette
 mov  [FF47h],A
 ret
    
    
;****************************************************************************
                                                                             
CopyTiles:
; Copy 360 Tiles to [8000h]-[9680h]
 mov  HL,8000h
 mov  DE,1780h          ; 360 Tiles * 16 bytes/tile = 5760d/1680h bytes
CopyTilesLoop:
 mov  A,[BC]
 mov  [HL],A
 inc  HL
 inc  BC
 dec  E
 jnz  @CopyTilesLoop
 dec  D
 jnz  @CopyTilesLoop
                    
 ret
    
    
;*** Set Background Tiles - First 240 Tiles *********************************
                                                                             
SetTiles1:
 mov  DE,000Ch
 mov  HL,9800h
 mov  A,00h             ; Start at Tile 0
 mov  C,012d            ; 12 tiles high
LoopSetTiles:
 mov  B,020d            ; 20 tiles wide
LoopSetTiles2:
 mov  [HL],A
 inc  HL
 inc  A
 dec  B
 jnz  @LoopSetTiles2
 add  HL,DE
 dec  C
 jnz  @LoopSetTiles
 ret
    
    
;*** Set Background Tiles - Last 120 Tiles **********************************
SetTiles2:
 mov  DE,000Ch
 mov  HL,9980h
 mov  A,240d            ; Start at Tile 240
 mov  C,006d            ; 6 tiles high
LoopSetTiles3:
 mov  B,020d            ; 20 tiles wide
LoopSetTiles4:
 mov  [HL],A
 inc  HL
 inc  A
 dec  B
 jnz  @LoopSetTiles4
 add  HL,DE
 dec  C
 jnz  @LoopSetTiles3
 ret
    
    
;*** Clears Background Tiles - Last 120 Tiles *******************************
SetTiles3:
 mov  DE,000Ch
 mov  HL,9980h
 xor  A                 ; Clear = Tile 0
 mov  C,006d            ; 6 tiles high
LoopSetTiles3b:
 mov  B,020d            ; 20 tiles wide
LoopSetTiles4b:
 mov  [HL],A
 inc  HL
 dec  B
 jnz  @LoopSetTiles4b
 add  HL,DE
 dec  C
 jnz  @LoopSetTiles3b
 ret
    
;*** Routine to start playing digital audio *********************************
StartMusic:
 di
   
 mov  A,01h             ; Bank pointer to Bank #1
 mov  [CD04h],A
               
;--- Set the length of the sample ---
 mov  HL,72A2h          ; Set sample length (divided by 16)
 mov  A,H
 mov  [CD00h],A         ; store [samp_cnt_h]
 mov  A,L
 mov  [CD01h],A         ; store [samp_cnt_l]
                                            
;--- Reset sample "playing position" ---
 mov  HL,@WaveFile      ; Start at beginning of GBWave file (ROM Bank 1)
 mov  A,H
 mov  [CD02h],A         ; store [samp_pos_h]
 mov  A,L
 mov  [CD03h],A         ; store [samp_pos_l]
                                            
 mov  A,84h
 mov  [FF26h],A         ; Set sound-on flag
 xor  A
 mov  [FF1Ah],A         ; Sound3 - stop
 mov  [FF25h],A         ; No sound output
 mov  A,77h
 mov  [FF24h],A         ; Sound channel control
 mov  A,FFh
 mov  [FF25h],A         ; All sounds on
 mov  A,FFh
 mov  [FF1Bh],A         ; Sound3 length
 mov  A,20h
 mov  [FF1Ch],A         ; Wave duty
                                   
;---- 8 KHz freq ----
 mov  A,00000000b       ; Lower 8 bits of frequency
 mov  [FF1Dh],A
 mov  A,240d            ; 256-16
 mov  [FF06h],A         ; Divide = 16
 mov  A,004d
 mov  [FF07h],A         ; Set timer frequency at 4096 Hz
;---------------------
                      
 ei                     ; Turn on interrupts to start play dig. audio!
                                                                      
 ret
    
    
;****************************************************************************
;*** Interrupt routine, plays digital audio in a loop ***********************
;****************************************************************************
                                                                             
TIMER_int:
          
 push AF
 push BC
 push DE
 push HL
        
 mov  A,[CD02h]         ; get [samp_pos_h]
 mov  H,A
 mov  A,[CD03h]         ; get [samp_pos_l]
 mov  L,A               ; HL = sample position
                                              
 mov  DE,FF30h          ; Wave buffer I guess?
 mov  B,016d            ; 16 bytes / sample-pack
 xor  A                 ; mov A,00h
 mov  [FF1Ah],A         ; Sound3 off
load_samp:
 mov  A,[HL]
 inc  HL
 mov  [DE],A
 inc  DE
 dec  B
 jnz  @load_samp
                
 mov  A,H
 cmp  80h               ; at end of bank?
 jnz  @Update_samp_pos
; mov  A,L
; cmp  FFh
; jnz  @Update_samp_pos
                       
 mov  HL,4000h          ; Yes, go back to 4000h
 mov  A,40h             ; Store new position into RAM
 mov  [CD02h],A
 mov  A,00h
 mov  [CD03h],A
               
 mov  A,[CD04h]         ; Get/inc/set bank number
 inc  A
 mov  [CD04h],A
 mov  [2000h],A         ; Select ROM Bank [CD04h]
                                                 
;--- Update samp_pos ---
Update_samp_pos:
 mov  A,H
 mov  [CD02h],A         ; store [samp_pos_h]
 mov  A,L
 mov  [CD03h],A         ; store [samp_pos_l]
                                            
;--- Update samp_cnt ---
 mov  A,[CD00h]         ; get [samp_cnt_h]
 mov  H,A
 mov  A,[CD01h]         ; get [samp_cnt_l]
 mov  L,A
 dec  HL
 mov  A,H
 mov  [CD00h],A         ; store [samp_cnt_h]
 mov  A,L
 mov  [CD01h],A         ; store [samp_cnt_l]
                                            
 inc  HL
        
 mov  A,H
 or   L
 cmp  00h               ; All samples played?
 jnz  @noressamp        ; No, goto "noressamp"
                                              
;--- Loop sample ---
                    
 mov  HL,72A2h          ; Set sample length
 mov  A,L
 mov  [CD01h],A         ; store [samp_cnt_l]
 mov  A,H
 mov  [CD00h],A         ; store [samp_cnt_h]
                                            
 mov  HL,@WaveFile      ; Start at beginning of GBWave file (ROM Bank 1)
                                                                        
 mov  A,01h             ; Select ROM Bank #1
 mov  [2000h],A
               
 mov  A,H
 mov  [CD02h],A         ; store [samp_pos_h]
 mov  A,L
 mov  [CD03h],A         ; store [samp_pos_l]
                                            
noressamp:
 mov  A,84h
 mov  [FF26h],A         ; Sound On
 mov  A,80h
 mov  [FF1Ah],A         ; Sound3 ON
 mov  A,10000111b
 mov  [FF1Eh],A         ; Set initial + higher bits of freq
                                                           
 pop  HL
 pop  DE
 pop  BC
 pop  AF
        
 reti
     
     
;*** Images Data ************************************************************
                                                                             
MMX-Presents:
.binfile "T2-MMX.bin"
                     
T2-Title:
.binfile "T800b.bin"
                    
T800:
.binfile "T2-Title.bin"
                       
                       
;*** Wave Data **************************************************************
.org 4000h
          
WaveFile:
;.binfile "T2-Title.gbw"
