; 
; Copyright (c) 2014, Antonio Nio Daz (AntonioND)
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
; 
; * Redistributions of source code must retain the above copyright notice, this
;   list of conditions and the following disclaimer.
; 
; * Redistributions in binary form must reproduce the above copyright notice,
;   this list of conditions and the following disclaimer in the documentation
;   and/or other materials provided with the distribution.
; 
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
; CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
; OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
; OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
; 

	INCLUDE	"hardware.inc"
	INCLUDE "header.inc"

MAP_TEMP_1			EQU	$D000
MAP_TEMP_2			EQU	$D400 ; ($D000 + 32*32)

;-------------------------------------------------------------------------------------------------

; More or less based on this:
; http://www.flipcode.com/archives/The_Art_of_Demomaking-Issue_07_Bump_Mapping.shtml

	SECTION "BUMP_DATA", DATA, BANK[4]

bump_palettes:
	DW $0000,$0000,$0000,$0000
	DW $0000,$0000,$0000,$1CE7
	DW $0000,$0000,$1CE7,$3DEF
	DW $0000,$1CE7,$3DEF,$7FFF

bump_tiles::
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $00,$00,$00,$00,$00,$00,$00,$00
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $F0,$00,$F0,$00,$F0,$00,$F0,$00
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $00,$F0,$00,$F0,$00,$F0,$00,$F0
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $0F,$00,$0F,$00,$0F,$00,$0F,$00
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $0F,$F0,$0F,$F0,$0F,$F0,$0F,$F0
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $FF,$F0,$FF,$F0,$FF,$F0,$FF,$F0
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $00,$0F,$00,$0F,$00,$0F,$00,$0F
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $F0,$0F,$F0,$0F,$F0,$0F,$F0,$0F
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $F0,$FF,$F0,$FF,$F0,$FF,$F0,$FF
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $FF,$0F,$FF,$0F,$FF,$0F,$FF,$0F
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $0F,$FF,$0F,$FF,$0F,$FF,$0F,$FF
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

;	SECTION "BUMP_DATA_2",ROMX[$4000],BANK[4]

bump_deltas_table_1: ; [dx,dy]
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E
DB $10,$0D,$10,$0C,$10,$0C,$10,$0C,$10,$0C,$10,$0C,$10,$0C,$10,$0C,$10,$0D,$10,$0E,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$0F,$0D,$0F,$0E
DB $10,$0F,$10,$0F,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$11,$0E,$11,$0C,$10,$0C,$10,$0E,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$0E,$0D,$0F,$0E,$10,$10,$10,$10
DB $10,$11,$10,$13,$10,$13,$10,$14,$10,$14,$10,$14,$10,$14,$10,$13,$10,$12,$10,$10,$12,$0F,$12,$0D,$10,$0B,$10,$0F,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$0E,$0E,$0E,$10,$10,$10,$10,$10,$12,$11,$14
DB $11,$13,$10,$12,$10,$11,$10,$11,$10,$10,$10,$11,$10,$11,$0F,$12,$0F,$14,$10,$14,$10,$13,$11,$10,$13,$0F,$11,$0C,$10,$0D,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$0D,$0F,$0F,$10,$10,$10,$11,$11,$13,$11,$12,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$11,$0E,$13,$0F,$14,$10,$12,$13,$10,$12,$0C,$10,$0D
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$0E,$0F,$0F,$10,$10,$11,$12,$12,$13,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0D,$11,$0E,$14,$10,$13,$13,$10,$13,$0D
DB $10,$0E,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$0E,$0F,$0F,$10,$10,$12,$12,$12,$12,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0D,$13,$10,$13,$14,$10
DB $13,$0D,$10,$0F,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$10,$0E,$0E,$10,$10,$12,$11,$12,$12,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0D,$13,$10,$12
DB $15,$10,$11,$0C,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$0E,$10,$10,$11,$10,$13,$12,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0C,$10,$0C
DB $10,$0C,$10,$0F,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0C,$10,$0B,$10,$0C,$10,$10,$10,$10,$10,$10,$0B,$10,$0E,$14
DB $11,$10,$15,$0F,$10,$0E,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0E,$0F,$10,$10,$13,$12,$10,$10,$10,$10,$10,$10,$0F,$10,$0D,$0D,$10,$0E,$10,$10
DB $13,$0E,$11,$0D,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0D,$0C,$10,$0E,$11,$0F,$13,$0D,$10,$0D,$10,$10,$10,$10,$0F,$10,$0B,$11
DB $10,$13,$14,$10,$13,$0D,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0C,$0F,$10,$10,$13,$10,$12,$11,$10,$10,$10,$10,$10,$10,$0C,$10,$0F,$0F,$10,$10,$10,$10
DB $11,$10,$14,$0F,$10,$10,$10,$10,$10,$10,$10,$10,$0B,$0F,$0F,$0F,$10,$10,$10,$10,$12,$10,$14,$0F,$10,$10,$10,$10,$10,$10,$0D,$10
DB $0D,$12,$11,$10,$15,$0F,$10,$0F,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$0E,$10,$0E,$0F,$10,$10,$14,$11,$10,$10,$10,$10,$10,$10,$10,$10,$0C,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$15,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0A,$10,$10,$10,$10,$10,$10,$10,$11,$10,$16,$11,$10,$10,$10,$10,$10,$10,$0F,$10
DB $0A,$10,$10,$12,$15,$10,$12,$0F,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0F,$10,$12,$10,$13,$11,$10,$10,$10,$10,$10,$10,$10,$10,$0C,$10,$0F,$13,$10,$10,$10,$10
DB $11,$11,$15,$13,$10,$10,$10,$10,$10,$10,$10,$10,$0A,$10,$10,$14,$10,$11,$10,$10,$12,$11,$15,$13,$10,$10,$10,$10,$10,$10,$10,$10
DB $0C,$10,$0E,$12,$13,$10,$14,$0F,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$0C,$10,$10,$10,$13,$10,$11,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$10,$0D,$12,$10,$15,$10,$15
DB $13,$15,$11,$11,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$10,$0C,$12,$10,$15,$11,$16,$14,$15,$11,$11,$10,$10,$10,$10,$10,$10,$10,$10
DB $0E,$10,$0C,$11,$11,$10,$15,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$0F,$10,$0C,$10,$10,$10,$14,$10,$11,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$11
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$11,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $0F,$10,$0B,$10,$10,$10,$16,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$0F,$10,$0C,$10,$10,$10,$14,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $0F,$10,$0A,$10,$10,$10,$16,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$0F,$10,$0C,$10,$10,$10,$14,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0D,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0D,$10,$10,$10,$10
DB $0F,$10,$0A,$10,$10,$10,$16,$10,$11,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$0F,$10,$0C,$10,$10,$10,$14,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$10,$0F,$13,$0D,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$10,$0D,$13,$0F,$10,$10,$10,$10
DB $0F,$10,$0A,$10,$10,$10,$16,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$0F,$10,$0C,$10,$10,$10,$15,$10,$10,$10,$10,$10,$10,$10,$0C,$10,$0F,$11,$15,$0F,$10,$0F,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0A,$0E,$13,$10,$14,$11,$10,$10,$10,$10
DB $0F,$10,$0B,$0F,$10,$10,$16,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$0B,$10,$10,$10,$14,$10,$11,$0F,$10,$10,$10,$10,$0D,$10,$0C,$11,$15,$10,$12,$0D,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0C,$0D,$15,$10,$12,$11,$10,$10,$10,$10
DB $0E,$10,$0C,$0F,$11,$10,$15,$11,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$0C,$10,$0E,$11,$13,$10,$13,$0E,$10,$10,$10,$10,$0F,$10,$0A,$11,$11,$12,$15,$0F,$10,$0D,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0B,$0C,$10,$0F,$16,$12,$10,$10,$10,$10,$10,$10
DB $0C,$10,$0D,$0E,$13,$10,$14,$11,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0D,$12,$11,$10,$15,$0F,$10,$0F,$10,$10,$10,$10,$0C,$10,$0E,$13,$13,$10,$14,$0D,$10,$0C
DB $10,$0F,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$0C,$0B,$0E,$0E,$13,$11,$13,$13,$10,$10,$10,$10,$10,$10
DB $0A,$0E,$10,$10,$14,$10,$12,$11,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0B,$11,$10,$12,$14,$10,$12,$0D,$10,$10,$10,$10,$0F,$10,$0B,$11,$10,$14,$12,$10,$13,$0E
DB $11,$0B,$10,$0C,$10,$0D,$10,$0E,$10,$0E,$10,$0E,$10,$0D,$0F,$0C,$0D,$0B,$0E,$0E,$11,$10,$15,$14,$10,$10,$10,$10,$10,$10,$0D,$10
DB $0C,$0D,$10,$10,$15,$13,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0C,$10,$0D,$13,$12,$10,$15,$0E,$10,$0D,$10,$10,$10,$10,$0E,$10,$0C,$12,$10,$14,$10,$10
DB $12,$10,$11,$0E,$10,$0C,$10,$0B,$10,$0B,$10,$0B,$0F,$0C,$0E,$0E,$10,$10,$10,$11,$14,$15,$12,$12,$10,$10,$10,$10,$10,$10,$0B,$0C
DB $0F,$0F,$14,$11,$13,$12,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0B,$11,$10,$13,$13,$10,$13,$0D,$10,$0E,$10,$10,$10,$10,$0E,$10,$0C,$12,$10,$15
DB $10,$13,$10,$11,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$11,$11,$13,$14,$15,$12,$12,$10,$10,$10,$10,$10,$10,$0C,$0D,$0E,$0E
DB $11,$10,$15,$14,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0C,$13,$10,$12,$14,$10,$12,$0C,$10,$0E,$10,$10,$10,$10,$0F,$10,$0D,$11
DB $0E,$14,$0F,$16,$10,$15,$10,$14,$10,$14,$10,$14,$11,$15,$12,$15,$13,$13,$11,$11,$10,$10,$10,$10,$10,$10,$0D,$0D,$0C,$0C,$10,$10
DB $15,$13,$12,$12,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0C,$10,$0E,$14,$10,$12,$14,$10,$12,$0C,$10,$0D,$10,$10,$10,$10,$10,$10
DB $10,$10,$0F,$10,$10,$12,$10,$12,$10,$13,$11,$12,$11,$11,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$0C,$0C,$0C,$10,$10,$13,$13
DB $13,$13,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0C,$10,$0E,$14,$10,$12,$13,$10,$13,$0D,$10,$0B,$10,$0E,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$0C,$0B,$0E,$0E,$10,$10,$13,$13,$13,$13
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0C,$10,$0E,$14,$10,$14,$11,$10,$13,$0F,$12,$0B,$10,$0B
DB $10,$0D,$10,$0E,$10,$0F,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0E,$10,$0D,$0E,$0B,$0D,$0C,$0F,$0F,$10,$11,$13,$14,$13,$13,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0D,$13,$10,$15,$10,$13,$11,$10,$12,$0F
DB $11,$0D,$10,$0B,$10,$0A,$10,$0A,$10,$0A,$10,$0A,$0F,$0A,$0F,$0B,$0E,$0D,$0F,$0F,$10,$10,$11,$13,$14,$15,$12,$12,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0D,$11,$0E,$14,$10,$15,$10,$14
DB $10,$12,$10,$11,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$11,$10,$12,$10,$14,$12,$15,$13,$13,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$0E,$11,$0F,$13
DB $0F,$15,$10,$16,$10,$16,$10,$16,$10,$16,$10,$16,$10,$16,$11,$16,$11,$15,$12,$13,$10,$11,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$11,$10,$11,$10,$11,$10,$11,$10,$11,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

bump_deltas_table_2: ; [dx,dy]
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$10,$0C,$10,$0C,$10,$0C,$10,$0C,$10,$0E,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$0E,$10,$0E,$10,$0E,$10,$0E,$10,$0E,$10,$0E,$10,$0F,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E
DB $10,$0D,$10,$0C,$10,$0C,$10,$0D,$10,$0F,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$0E,$0A,$0F,$0B,$10,$0D,$10,$0D,$10,$0D,$12,$0D,$12,$0B,$10,$09,$10,$0D,$10,$10,$0E,$10
DB $10,$0B,$10,$0B,$10,$0B,$10,$0B,$10,$0B,$10,$0B,$11,$0A,$10,$09,$10,$0F,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$0E,$0A,$0F,$0B
DB $10,$0C,$10,$0D,$10,$0D,$12,$0C,$11,$0A,$10,$0A,$10,$0F,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$0F,$0E,$0B,$0A,$0F,$0F,$10,$10,$10,$13,$10,$15,$10,$14,$10,$12,$10,$10,$14,$10,$13,$0E,$10,$10,$09,$10
DB $10,$10,$10,$10,$10,$12,$10,$13,$10,$13,$10,$12,$10,$10,$15,$10,$11,$0A,$10,$0F,$10,$10,$10,$10,$0F,$0F,$0B,$0A,$0F,$0F,$10,$10
DB $10,$13,$10,$14,$10,$14,$10,$12,$11,$10,$15,$0F,$11,$0F,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$0E,$10,$0B,$0C,$10,$10,$10,$12,$13,$16,$12,$14,$0F,$12,$0F,$13,$0E,$15,$10,$17,$11,$13,$16,$10,$10,$10,$09,$10
DB $10,$10,$12,$10,$11,$13,$10,$14,$0F,$14,$0E,$15,$10,$16,$10,$10,$16,$10,$11,$0F,$10,$10,$0F,$10,$0A,$0C,$10,$10,$10,$11,$13,$16
DB $11,$14,$10,$13,$0F,$13,$0E,$15,$10,$16,$15,$11,$12,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$0A,$0D,$10,$10,$12,$10,$15,$15,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0E,$14,$16,$15,$10,$10,$09,$10
DB $10,$10,$15,$10,$12,$10,$10,$10,$10,$10,$0F,$10,$0A,$11,$10,$10,$15,$10,$12,$10,$10,$10,$0A,$0E,$0F,$0F,$11,$10,$15,$14,$11,$11
DB $10,$10,$10,$10,$10,$10,$0F,$10,$0B,$11,$14,$16,$12,$11,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$0C,$10,$0D,$0D,$10,$10,$17,$13,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0F,$10,$11,$11,$10,$10,$09,$10
DB $10,$10,$15,$10,$12,$10,$10,$10,$10,$10,$10,$10,$09,$0F,$10,$10,$15,$10,$12,$12,$0E,$10,$0B,$0D,$10,$10,$15,$11,$12,$12,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$09,$10,$10,$10,$13,$10,$14,$12,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$09,$10
DB $10,$10,$15,$10,$12,$0D,$10,$0C,$10,$0C,$0F,$0C,$0A,$0A,$10,$10,$17,$14,$10,$10,$0B,$10,$0E,$0F,$11,$10,$16,$12,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$09,$0F,$10,$10,$15,$10,$12,$11,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$09,$10
DB $10,$10,$12,$10,$11,$0E,$10,$0D,$10,$0D,$0D,$0D,$10,$10,$14,$11,$13,$11,$10,$10,$09,$10,$10,$10,$13,$10,$14,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $0E,$10,$0B,$10,$10,$10,$17,$10,$10,$0F,$10,$10,$10,$10,$10,$10,$10,$0A,$10,$09,$10,$09,$10,$09,$10,$09,$10,$0A,$10,$10,$09,$10
DB $10,$10,$10,$10,$10,$12,$10,$13,$10,$13,$10,$13,$11,$11,$15,$0F,$11,$0A,$10,$0E,$09,$10,$10,$10,$14,$10,$13,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $0E,$10,$0B,$11,$10,$10,$15,$10,$12,$10,$10,$10,$10,$10,$0A,$10,$0F,$11,$10,$11,$10,$11,$10,$11,$11,$10,$16,$10,$10,$10,$09,$10
DB $10,$10,$12,$10,$11,$13,$10,$14,$10,$14,$0E,$14,$0F,$16,$10,$12,$15,$10,$12,$0D,$09,$10,$10,$10,$14,$10,$13,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$09,$10,$10,$10,$15,$10,$12,$0E,$10,$10,$10,$10,$0C,$10,$0F,$14,$10,$16,$10,$16,$0F,$14,$11,$10,$16,$10,$10,$10,$09,$10
DB $10,$10,$15,$10,$12,$10,$10,$10,$10,$10,$10,$10,$0B,$10,$0E,$13,$12,$10,$15,$0E,$09,$10,$10,$11,$13,$10,$14,$0E,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$09,$10,$10,$12,$13,$10,$14,$0D,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$10,$0B,$10,$11,$10,$16,$10,$10,$10,$09,$10
DB $10,$10,$15,$10,$12,$10,$10,$10,$10,$10,$10,$10,$0E,$10,$0B,$10,$10,$10,$17,$10,$0A,$10,$0F,$13,$11,$10,$16,$0F,$10,$0E,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$0B,$10,$0E,$14,$10,$10,$17,$10,$10,$0B,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$10,$0B,$10,$11,$10,$16,$10,$10,$10,$09,$10
DB $10,$10,$15,$10,$12,$10,$10,$10,$10,$10,$10,$10,$0E,$10,$0B,$0C,$10,$10,$17,$11,$0D,$10,$0C,$13,$10,$10,$15,$10,$12,$0C,$10,$0F
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0B,$10,$0E,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$0F,$10,$0A,$11,$10,$13,$12,$10,$15,$0E,$10,$0A,$10,$0C,$10,$0E,$10,$0E,$0E,$0D,$0B,$0D,$11,$10,$16,$10,$10,$10,$09,$10
DB $10,$10,$15,$10,$12,$0D,$10,$0C,$10,$0C,$10,$0B,$0A,$09,$0F,$0F,$11,$10,$16,$14,$10,$10,$09,$10,$10,$15,$11,$10,$15,$0F,$11,$0A
DB $10,$0C,$10,$0E,$10,$0E,$10,$0C,$0B,$09,$13,$0E,$12,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$0C,$10,$0D,$14,$10,$15,$11,$10,$12,$0F,$12,$0D,$10,$0B,$0F,$0B,$0E,$0C,$0E,$0E,$11,$10,$16,$12,$10,$10,$09,$10
DB $10,$10,$12,$10,$11,$0E,$10,$0D,$0F,$0D,$0E,$0E,$10,$10,$10,$10,$16,$15,$11,$11,$10,$10,$0E,$10,$0B,$12,$10,$15,$10,$10,$13,$10
DB $12,$0D,$10,$0B,$0E,$0B,$0D,$0D,$10,$10,$15,$10,$12,$11,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$0E,$10,$0B,$12,$10,$17,$10,$14,$10,$12,$10,$11,$10,$11,$10,$12,$10,$14,$13,$17,$14,$14,$10,$10,$09,$10
DB $10,$13,$10,$13,$10,$13,$10,$13,$10,$13,$10,$15,$10,$15,$14,$17,$12,$12,$10,$10,$10,$10,$10,$10,$0E,$10,$0B,$12,$10,$16,$10,$15
DB $10,$13,$10,$11,$10,$11,$10,$13,$10,$16,$16,$17,$11,$11,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0D,$10,$0E,$13,$10,$15,$10,$16,$11,$16,$12,$15,$12,$13,$10,$10,$10,$10,$10,$10,$0C,$10
DB $10,$14,$10,$14,$10,$14,$10,$14,$12,$14,$10,$12,$12,$12,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$0E,$10,$0F,$12
DB $0E,$14,$10,$16,$12,$16,$12,$14,$11,$11,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
DB $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	SECTION "BUMP_DATA_3",ROMX[$4000],BANK[4]

bump_intensity_table_1:
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

bump_intensity_table_2:
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$00,$00,$00
DB $00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00,$00
DB $00,$00,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$00,$00
DB $00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00
DB $00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00
DB $00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00
DB $00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00
DB $00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00
DB $00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00
DB $00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00
DB $00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00
DB $00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00
DB $00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00
DB $00,$00,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$00,$00
DB $00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00,$00
DB $00,$00,$00,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;-------------------------------------------------------------------------------------------------

	SECTION	"Bump_Vars",BSS

; ---------------------------

bump_exit_demo:	DS	1 ; set to 1 to exit this effect
bump_event_count:	DS	2
bump_current_event:	DS	2 ; pointer to the next event

bump_coord_x:	DS	1
bump_coord_y:	DS	1

bump_has_to_update_pal:	DS	1
bump_has_to_update_bgs_dma:	DS	1
bump_current_pal:		DS	1

bump_deltas_table_current:	DS	2 ; pointer to current delta_table. LSB first

bump_movement_count_x:	DS	1
bump_movement_count_y:	DS	1

;-------------------------------------------------------------------------------------------------

	SECTION "Bump", CODE, BANK[4]

;----------------------------------------------

bump_init_variables:

	ld	a,0
	ld	[bump_coord_x],a
	ld	[bump_coord_y],a
	
	ld	[bump_movement_count_x],a
	ld	[bump_movement_count_y],a
	
	ld	[bump_has_to_update_pal],a
	ld	[bump_current_pal],a
	ld	[bump_has_to_update_bgs_dma],a
	
	ld	a,bump_deltas_table_1 & $FF
	ld	[bump_deltas_table_current+0],a
	ld	a,bump_deltas_table_1 >> 8
	ld	[bump_deltas_table_current+1],a
	
	ld	a,0
	ld	[bump_event_count],a
	ld	[bump_event_count+1],a
	
	ld	hl,_event_table_bump
	ld	a,h
	ld	[bump_current_event],a
	ld	a,l
	ld	[bump_current_event+1],a

	ret

;----------------------------------------------

_event_exit_bump_demo:
	ld	a,1
	ld	[bump_exit_demo],a
	ret

_event_bump_set_pal_0:
	ld	a,1
	ld	[bump_has_to_update_pal],a
	ld	a,0
	ld	[bump_current_pal],a
	ret

_event_bump_set_pal_1:
	ld	a,1
	ld	[bump_has_to_update_pal],a
	ld	a,1
	ld	[bump_current_pal],a
	ret

_event_bump_set_pal_2:
	ld	a,1
	ld	[bump_has_to_update_pal],a
	ld	a,2
	ld	[bump_current_pal],a
	ret

_event_bump_set_pal_3:
	ld	a,1
	ld	[bump_has_to_update_pal],a
	ld	a,3
	ld	[bump_current_pal],a
	ret

_event_bump_set_table_1:
	ld	a,bump_deltas_table_1 & $FF
	ld	[bump_deltas_table_current+0],a
	ld	a,bump_deltas_table_1 >> 8
	ld	[bump_deltas_table_current+1],a
	ret
	
_event_bump_set_table_2:
	ld	a,bump_deltas_table_2 & $FF
	ld	[bump_deltas_table_current+0],a
	ld	a,bump_deltas_table_2 >> 8
	ld	[bump_deltas_table_current+1],a
	ret
	
;-------------------

_event_table_bump:
	
	DW	0,_event_bump_set_table_2
	
	DW	2,_event_bump_set_pal_0
	DW	4,_event_bump_set_pal_1
	DW	6,_event_bump_set_pal_2
	DW	8,_event_bump_set_pal_3
	
	DW	102,_event_bump_set_pal_3
	DW	104,_event_bump_set_pal_2
	DW	106,_event_bump_set_pal_1
	DW	108,_event_bump_set_pal_0

	DW	110,_event_bump_set_table_1
	
	DW	112,_event_bump_set_pal_0
	DW	114,_event_bump_set_pal_1
	DW	116,_event_bump_set_pal_2
	DW	118,_event_bump_set_pal_3
	
	DW	212,_event_bump_set_pal_3
	DW	214,_event_bump_set_pal_2
	DW	216,_event_bump_set_pal_1
	DW	218,_event_bump_set_pal_0
	
	DW	220,_event_exit_bump_demo
	
	DW	$FFFF,$0000 ; No more events! Don't remove this line!

;----------------------------------------------

bump_handle_events:
	
	; Handle events
	; -------------
	
	ld	a,[bump_event_count]
	ld	e,a
	ld	a,[bump_event_count+1]
	ld	d,a
	
	; Start of checking
	
	ld	a,[bump_current_event]
	ld	h,a
	ld	a,[bump_current_event+1]
	ld	l,a
	
	ld	c,[hl]
	inc hl
	ld	b,[hl] ; bc = event counter trigger
	ld	a,c
	and	a,b
	cp	a,$FF ; if both are $FF, exit checking
	jr	z,._exit_check_events
	
	ld	a,d
	cp	a,b
	jr	nz,._exit_check_events
	
	ld	a,e
	cp	a,c
	jr	nz,._exit_check_events
	
	inc	hl
	
	ld	c,[hl]
	inc hl
	ld	b,[hl] ; bc = ptr to function
	inc	hl ; hl = ptr to next event
	
	ld	a,h
	ld	[bump_current_event],a
	ld	a,l
	ld	[bump_current_event+1],a ; save pointer to next event
	
	ld	h,b
	ld	l,c ; hl = ptr to function
	
	CALL_HL
._exit_check_events:

	; Now, handle functions...
	; ------------------------

	ld	a,[bump_movement_count_x]
	add	a,9
	ld	[bump_movement_count_x],a
	
	ld	l,a
	ld	h,Sine>>8
	ld	a,[hl]
	sra	a
	sra	a
	sra	a
	sra	a
	ld	b,a
	sra	a
	add	a,b
	sub	a,20
	ld	[bump_coord_x],a
	
	ld	a,[bump_movement_count_y]
	add	a,11
	ld	[bump_movement_count_y],a
	
	ld	l,a
	ld	h,Cosine>>8
	ld	a,[hl]
	sra	a
	sra	a
	sra	a
	sra	a
	ld	b,a
	sra	a
	add	a,b
	sub	a,18
	ld	[bump_coord_y],a

	
	IF	0
	ld	a,[joy_held]
	and	a,PAD_UP
	jr	z,.notup
	
	ld	a,[bump_coord_y]
	inc	a
	ld	[bump_coord_y],a
	
.notup:
	
	ld	a,[joy_held]
	and	a,PAD_DOWN
	jr	z,.notdown
	
	ld	a,[bump_coord_y]
	dec	a
	ld	[bump_coord_y],a
	
.notdown:

	ld	a,[joy_held]
	and	a,PAD_LEFT
	jr	z,.notleft
	
	ld	a,[bump_coord_x]
	inc	a
	ld	[bump_coord_x],a
	
.notleft:
	
	ld	a,[joy_held]
	and	a,PAD_RIGHT
	jr	z,.notright
	
	ld	a,[bump_coord_x]
	dec	a
	ld	[bump_coord_x],a
	
.notright:
	ENDC
	
	; More checks here
	
	; ...
	
	; Increase counter
	; ----------------
	
	ld	a,[bump_event_count]
	ld	l,a
	ld	a,[bump_event_count+1]
	ld	h,a
	
	inc	hl
	
	ld	a,l
	ld	[bump_event_count],a
	ld	a,h
	ld	[bump_event_count+1],a
	
	ret

;----------------------------------------------

bump_palette_refresh:
	
	ld	a,[bump_has_to_update_pal]
	and	a,a
	ret	z
	
	xor	a,a
	ld	[bump_has_to_update_pal],a
	
	ld	a,[bump_current_pal]
	
	ld	l,a
	ld	h,0
	add	hl,hl
	add	hl,hl
	add	hl,hl ; hl = a * 8
	
	ld	de,bump_palettes
	add	hl,de  ; hl = bump_palettes + a * 8
	
	ld	a,$80 ; pal 0, auto increment
	ld	[rBCPS],a
	
	ld	c,8
.repeat:
	ld	a,[hl+]
	ld	[rBCPD],a
	dec	c
	jr	nz,.repeat
	
	ret

;-------------------------------------------------------------------------------------

bump_get_subtile_texture_from_coords: ; b = x, c = y -> returns d,e = subtiles 1, 2

	ld	e,b
	ld	d,0 ; de = x
	
	ld	l,c
	ld	h,0
	
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl ; hl = y * 64
	
	add	hl,de ; hl = y * 64 + x
	
	add	hl,hl ; hl = ( y * 64 + x ) * 2
	
	ld	a,[bump_deltas_table_current+0]
	ld	e,a
	ld	a,[bump_deltas_table_current+1]
	ld	d,a

	;ld	de,bump_deltas_table_1
	add	hl,de ; hl = bump_deltas_table + ( y * 64 + x ) * 2
	
	ld	a,[hl+] ; a = dx
	add	a,b ; a = dx + x
	push	hl
	ld	hl,bump_coord_x
	add	a,[hl] ; add displacement
	pop	hl
	cp	a,31
	jr	c,.valid1
	ld	de,$0000
	ret
.valid1:
	
	ld	d,a ; d = dx + x
	
	ld	a,[hl]  ; a = dy
	add	a,c	; a = dy + y
	ld	hl,bump_coord_y
	add	a,[hl] ; add displacement
	cp	a,31
	jr	c,.valid2
	ld	de,$0000
	ret
.valid2:
	
	ld	l,a
	ld	h,0 ; hl = dy + y
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl ; hl = (dy + y) * 32
	ld	a,d
	or	a,l
	ld	l,a ; hl = (dy + y) * 32 + dx + x
	
	ld	de,bump_intensity_table_1
	add	hl,de ; hl = bump_intensity_table + (dy + y) * 32 + dx + x
	ld	a,[hl]
	
	ld	de,32*32 ; bump_intensity_table_2 is next to bump_intensity_table_1
	add	hl,de
	ld	e,[hl]
	
	ld	d,a

	ret


;-------------------------------------------------------------------------------------

bump_map_handle:
	
	; Wait until maps are copied to VRAM
	
	ld	a,[bump_has_to_update_bgs_dma]
	and	a,a
	jr	z,.update
	
	halt
	jr	bump_map_handle
	
.update:
	
	; Calculate effect
	; ----------------
	
	ld	c,0 ; c = y
.loopy
	ld	b,0 ; b = x
.loopx
	push	bc
	
	;----
	
	; Get 4 subtiles
	
	sla	b
	sla	c
	
	push	bc
	call	bump_get_subtile_texture_from_coords	
	pop	bc
	push	de ; save tiles
	
	push	bc
	inc	b
	call	bump_get_subtile_texture_from_coords	
	pop	bc
	push	de ; save tiles

	inc	c
	push	bc
	call	bump_get_subtile_texture_from_coords
	pop	bc
	push	de ; save tiles
	
	inc	b
	call	bump_get_subtile_texture_from_coords
	
	; Reconstruct tile
	
	ld	a,d
	rla
	rla
	ld	b,a ; b = combined 1
	
	ld	a,e
	rla
	rla
	ld	c,a ; c = combined 2
	
	pop	de
	
	ld	a,b
	or	a,d
	rla
	rla
	ld	b,a ; b = combined 1
	
	ld	a,c
	or	a,e
	rla
	rla
	ld	c,a ; c = combined 2
	
	pop	de
	
	ld	a,b
	or	a,d
	rla
	rla
	ld	b,a ; b = combined 1
	
	ld	a,c
	or	a,e
	rla
	rla
	ld	c,a ; c = combined 2
	
	pop	de
	
	ld	a,b
	or	a,d
	ld	d,a ; d = combined 1
	
	ld	a,c
	or	a,e
	ld	e,a ; e = combined 2
	
	; d = combined 1
	; e = combined 2
	
	; Set tile to temp buffer
	
	pop	bc
	push	bc
	
	push	de
	ld	d,MAP_TEMP_1 >> 8
	ld	e,b ; de = base + x
	
	ld	l,c
	ld	h,$00 ; hl = y
	
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl ; hl = y * 32
	
	add	hl,de ; hl = base + x + (y * 32)
	pop	de

	ld	[hl],d ; write combined 1
	
	ld	a,e ; save combined 2
	
	ld	de,32*32 ; MAP_TEMP_2 is next to MAP_TEMP_1
	add	hl,de
	
	ld	[hl],a  ; write combined 2

	;----
	
	pop	bc
	
	inc	b
	ld	a,20
	cp	a,b
	jr	nz,.loopx
	
	inc	c
	ld	a,18
	cp	a,c
	jr	nz,.loopy
	
	; Tell the VBL handler to copy maps to VRAM
	
	ld	a,1
	ld	[bump_has_to_update_bgs_dma],a
	
	ret

;-------------------------------------------------------------------------------------

bump_map_update_bgs:
	
	ld	a,[bump_has_to_update_bgs_dma]
	and	a,a
	ret	z
	
	ld	a,0
	ld	[bump_has_to_update_bgs_dma],a
	
	ld	[rVBK],a
	DMA_COPY	MAP_TEMP_1,$9800,32*20,0 ; src, dst, size, is_hdma

	DMA_COPY	MAP_TEMP_2,$9C00,32*20,0 ; src, dst, size, is_hdma

	ret

;-------------------------------------------------------------------
;-                              OTHER                              -
;-------------------------------------------------------------------

bump_vbl_handler:
	
	ld	a,[rLCDC]
	xor	a,LCDCF_BG9C00
	ld	[rLCDC],a
	
	call	bump_palette_refresh
	
	call	bump_map_update_bgs
	
	LONG_CALL	gbt_update

	ret

;----------------------------------------------
	
	GLOBAL Bump
	
Bump:

	; ----	
	
	ld	a,1
	ld	[rVBK],a
	
	ld	bc,32*32*2 ; the 2 maps
	ld	d,0
	ld	hl,$9800
	call	vram_memset ; bc = size    d = value    hl = dest address

	; ----	
	
	call	bump_init_variables
	
	ld	a,0
	ld	[rVBK],a

	ld	bc,128
	ld	hl,bump_tiles
	ld	de,256 ;  de = start index
	call	vram_copy_tiles
	ld	bc,128
	ld	de,128 ;  de = start index
	call	vram_copy_tiles

	call	bump_map_handle
	
	call	wait_vbl
	
	call	bump_map_update_bgs
	
	ld	a,LCDCF_ON|LCDCF_BG8800|LCDCF_BG9800 ; configuration
	ld	[rLCDC],a
	
	; Configure IRQs
	
	ld	a,$01
	ld	[rIE],a
	
	ld	bc,bump_vbl_handler
	call	irq_set_VBL

	; Refresh screen

	call	wait_vbl
	
	; START	

.loop: ; Main loop
	
	call	bump_handle_events
	
	call	bump_map_handle

	call	wait_vbl
	
	ld	a,[bump_exit_demo]
	and	a,a
	jr	z,.loop

	; Exit...
	; -------
	
	call	demo_config_default
	
	ret

