; 
; Copyright (c) 2014, Antonio Nio Daz (AntonioND)
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
; 
; * Redistributions of source code must retain the above copyright notice, this
;   list of conditions and the following disclaimer.
; 
; * Redistributions in binary form must reproduce the above copyright notice,
;   this list of conditions and the following disclaimer in the documentation
;   and/or other materials provided with the distribution.
; 
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
; CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
; OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
; OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
; 

	INCLUDE	"hardware.inc"
	INCLUDE "header.inc"

MAP_TEMP			EQU	$D000
ATTR_MAP_TEMP		EQU	$D400 ;($D000 + 32*32)

TRAIN_ENABLE_BIRDS	EQU	1

;-------------------------------------------------------------------------------------------------

	SECTION "TRAIN_DATA", DATA, BANK[5]

jordi_train_palettes:
	DW	9023,6719,9533,7411
	DW	6719,6623,5471,191
	DW	25438,31437,32297,32072
	DW	27550,23257,12721,4166
	DW	1798,23257,12721,4166
	DW	346,243,1198,4135
	DW	749,1632,3489,5351
	DW	6815,6719,2495,5503

jordi_train_map: ; 128x20, rows
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$07,$07
DB $07,$07,$07,$07,$07,$02,$06,$02,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$02
DB $03,$04,$05,$07,$07,$07,$07,$07,$07,$07
DB $07,$05,$02,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$05,$02,$07,$07,$07,$07,$07,$07
DB $02,$06,$02,$07,$02,$06,$04,$02,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$05,$02,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$05,$03,$06,$04,$02,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$02,$06,$02,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$08,$09,$0A,$0B,$07,$07,$07,$07
DB $07,$07,$07,$07,$87,$07,$7E,$7F,$07,$8E
DB $07,$79,$7A,$79,$7A,$82,$86,$85,$8A,$8B
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$6F,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$0C,$0D
DB $0E,$0F,$10,$11,$12,$07,$07,$07,$07,$07
DB $07,$91,$88,$90,$81,$80,$07,$8F,$07,$7B
DB $7C,$7B,$7D,$89,$83,$84,$8C,$8D,$91,$88
DB $90,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$70
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $13,$14,$15,$1C,$1D,$1E,$1F,$14,$1B,$14
DB $21,$1E,$1F,$20,$13,$14,$15,$16,$17,$18
DB $19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21,$22
DB $23,$24,$25,$26,$27,$21,$1D,$1F,$20,$20
DB $25,$26,$15,$16,$2E,$1B,$14,$21,$1C,$1D
DB $21,$1C,$1C,$1F,$20,$16,$1E,$1F,$20,$21
DB $22,$23,$24,$25,$26,$27,$25,$1D,$1F,$20
DB $21,$22,$23,$24,$1F,$20,$21,$20,$25,$26
DB $15,$16,$2E,$1B,$14,$21,$1C,$1D,$1F,$21
DB $20,$21,$1F,$20,$21,$20,$07,$07,$13,$14
DB $15,$16,$14,$21,$1C,$1D,$1F,$20,$15,$16
DB $2E,$1B,$21,$1D,$1F,$20,$20,$25,$19,$1A
DB $1B,$07,$1D,$1F,$20,$21,$22,$23,$28,$38
DB $2A,$32,$39,$37,$2E,$2F,$30,$31,$32,$33
DB $34,$35,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F
DB $30,$31,$32,$33,$34,$35,$36,$37,$38,$39
DB $3A,$3B,$3C,$35,$2E,$34,$35,$35,$32,$33
DB $37,$38,$39,$30,$31,$32,$38,$39,$3A,$38
DB $39,$35,$39,$37,$2E,$2F,$30,$31,$37,$38
DB $39,$30,$31,$2E,$2F,$33,$31,$35,$36,$37
DB $38,$39,$2F,$30,$31,$35,$32,$33,$37,$38
DB $39,$30,$31,$32,$38,$31,$31,$36,$35,$36
DB $2F,$30,$31,$35,$17,$18,$31,$31,$36,$31
DB $35,$36,$36,$37,$31,$36,$31,$36,$33,$31
DB $35,$36,$2F,$33,$31,$33,$31,$32,$36,$31
DB $33,$31,$35,$36,$37,$38,$4F,$50,$51,$52
DB $41,$42,$3F,$40,$41,$42,$3F,$40,$41,$42
DB $3F,$40,$41,$52,$51,$50,$4F,$4F,$50,$51
DB $52,$41,$42,$3F,$40,$41,$42,$3F,$40,$41
DB $42,$3F,$40,$41,$52,$51,$50,$4F,$4F,$50
DB $51,$52,$41,$42,$3F,$40,$41,$42,$3F,$40
DB $41,$42,$3F,$40,$41,$52,$51,$50,$4F,$4F
DB $50,$51,$52,$41,$42,$3F,$40,$41,$42,$3F
DB $40,$41,$42,$3F,$40,$41,$52,$51,$50,$4F
DB $4F,$50,$51,$52,$41,$42,$3F,$40,$41,$42
DB $3F,$40,$41,$42,$3F,$40,$41,$52,$51,$50
DB $4F,$4F,$50,$51,$52,$41,$42,$3F,$40,$41
DB $42,$3F,$40,$41,$42,$3F,$40,$41,$52,$3F
DB $40,$41,$50,$4F,$53,$54,$55,$56,$47,$48
DB $45,$46,$47,$48,$45,$46,$47,$48,$45,$46
DB $47,$56,$55,$54,$53,$53,$54,$55,$56,$47
DB $48,$45,$46,$47,$48,$45,$46,$47,$48,$45
DB $46,$47,$56,$55,$54,$53,$53,$54,$55,$56
DB $47,$48,$45,$46,$47,$48,$45,$46,$47,$48
DB $45,$46,$47,$56,$55,$54,$53,$53,$54,$55
DB $56,$47,$48,$45,$46,$47,$48,$45,$46,$47
DB $48,$45,$46,$47,$56,$55,$54,$53,$53,$54
DB $55,$56,$47,$48,$45,$46,$47,$48,$45,$46
DB $47,$48,$45,$46,$47,$56,$55,$54,$53,$53
DB $54,$55,$56,$47,$48,$45,$46,$47,$48,$45
DB $46,$47,$48,$45,$46,$47,$56,$45,$46,$47
DB $54,$53,$57,$58,$59,$5A,$4D,$4E,$78,$4C
DB $4D,$4E,$78,$4C,$4D,$4E,$78,$4C,$4D,$5A
DB $59,$58,$57,$57,$58,$59,$5A,$4D,$4E,$78
DB $4C,$4D,$4E,$78,$4C,$4D,$4E,$78,$4C,$4D
DB $5A,$59,$58,$57,$57,$58,$59,$5A,$4D,$4E
DB $78,$4C,$4D,$4E,$78,$4C,$4D,$4E,$78,$4C
DB $4D,$5A,$59,$58,$57,$57,$58,$59,$5A,$4D
DB $4E,$78,$4C,$4D,$4E,$78,$4C,$4D,$4E,$78
DB $4C,$4D,$5A,$59,$58,$57,$57,$58,$59,$5A
DB $4D,$4E,$78,$4C,$4D,$4E,$78,$4C,$4D,$4E
DB $78,$4C,$4D,$5A,$59,$58,$57,$57,$58,$59
DB $5A,$4D,$4E,$78,$4C,$4D,$4E,$78,$4C,$4D
DB $4E,$78,$4C,$4D,$5A,$78,$4C,$4D,$58,$57
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C
DB $5B,$5C,$5B,$5C,$5B,$5C,$5B,$5C,$5D,$5E
DB $5F,$5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E,$5F
DB $5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E,$5F,$5D
DB $5E,$5F,$5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E
DB $5F,$5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E,$5F
DB $5D,$5E,$5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E
DB $5F,$5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E,$5F
DB $5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E,$5F,$5D
DB $5E,$5F,$5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E
DB $5F,$5D,$5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E
DB $5F,$5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E,$5F
DB $5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E,$5F,$5D
DB $5E,$5F,$5D,$5E,$5F,$5D,$5E,$5F,$5D,$5E
DB $5F,$5D,$5D,$5E,$5F,$5D,$60,$61,$62,$60
DB $61,$62,$60,$61,$62,$60,$61,$62,$60,$61
DB $62,$60,$61,$62,$60,$61,$62,$60,$61,$62
DB $60,$61,$62,$60,$61,$62,$60,$61,$62,$60
DB $61,$62,$60,$61,$62,$60,$61,$62,$60,$61
DB $60,$61,$62,$60,$61,$62,$60,$61,$62,$60
DB $61,$62,$60,$61,$62,$60,$61,$62,$60,$61
DB $62,$60,$61,$62,$60,$61,$62,$60,$61,$62
DB $60,$61,$62,$60,$61,$62,$60,$61,$62,$60
DB $60,$61,$62,$60,$61,$62,$60,$61,$62,$60
DB $61,$62,$60,$61,$62,$60,$61,$62,$60,$61
DB $62,$60,$61,$62,$60,$61,$62,$60,$61,$62
DB $60,$61,$62,$60,$61,$62,$60,$61,$62,$60
DB $60,$61,$62,$60,$63,$64,$65,$63,$64,$65
DB $63,$64,$65,$63,$64,$65,$63,$64,$65,$63
DB $64,$65,$63,$64,$65,$63,$64,$65,$63,$64
DB $65,$63,$64,$65,$63,$64,$65,$63,$64,$65
DB $63,$64,$65,$63,$64,$65,$63,$64,$63,$64
DB $65,$63,$64,$65,$63,$64,$65,$63,$64,$65
DB $63,$64,$65,$63,$64,$65,$63,$64,$65,$63
DB $64,$65,$63,$64,$65,$63,$64,$65,$63,$64
DB $65,$63,$64,$65,$63,$64,$65,$63,$63,$64
DB $65,$63,$64,$65,$63,$64,$65,$63,$64,$65
DB $63,$64,$65,$63,$64,$65,$63,$64,$65,$63
DB $64,$65,$63,$64,$65,$63,$64,$65,$63,$64
DB $65,$63,$64,$65,$63,$64,$65,$63,$63,$64
DB $65,$63,$6A,$6B,$69,$6A,$6B,$69,$6A,$6B
DB $69,$6A,$6B,$69,$6A,$6B,$69,$6A,$69,$6A
DB $6B,$69,$6A,$6B,$69,$6A,$6B,$69,$6A,$6B
DB $6A,$6B,$69,$6A,$6B,$69,$6A,$6B,$69,$6A
DB $6B,$69,$6A,$6B,$69,$6A,$69,$6A,$6B,$69
DB $6A,$6B,$69,$6A,$6B,$69,$6A,$6B,$6A,$6B
DB $69,$6A,$6B,$69,$6A,$6B,$69,$6A,$6B,$69
DB $6A,$6B,$69,$6A,$69,$6A,$6B,$69,$6A,$6B
DB $69,$6A,$6B,$69,$6A,$6B,$6A,$6B,$69,$6A
DB $6B,$69,$6A,$6B,$69,$6A,$6B,$69,$6A,$6B
DB $69,$6A,$69,$6A,$6B,$69,$6A,$6B,$69,$6A
DB $6B,$69,$6A,$6B,$6A,$6B,$69,$6A,$6B,$69
DB $6A,$6B,$69,$6A,$6B,$69,$6A,$6B,$69,$6A
DB $6D,$6E,$6D,$6E,$6B,$6C,$6D,$6E,$6D,$6E
DB $6B,$6C,$6D,$6E,$6D,$6E,$6B,$6C,$6D,$6E
DB $6D,$6E,$6B,$6C,$6D,$6E,$6D,$6E,$6D,$6E
DB $6D,$6E,$6B,$6C,$6D,$6E,$6D,$6E,$6B,$6C
DB $6D,$6E,$6D,$6E,$6B,$6C,$6D,$6E,$6D,$6E
DB $6B,$6C,$6D,$6E,$6D,$6E,$6D,$6E,$6D,$6E
DB $6B,$6C,$6D,$6E,$6D,$6E,$6B,$6C,$6D,$6E
DB $6D,$6E,$6B,$6C,$6D,$6E,$6D,$6E,$6B,$6C
DB $6D,$6E,$6D,$6E,$6D,$6E,$6D,$6E,$6B,$6C
DB $6D,$6E,$6D,$6E,$6B,$6C,$6D,$6E,$6D,$6E
DB $6B,$6C,$6D,$6E,$6D,$6E,$6B,$6C,$6D,$6E
DB $6D,$6E,$6D,$6E,$6D,$6E,$6B,$6C,$6D,$6E
DB $6D,$6E,$6B,$6C,$6D,$6E,$6D,$6E,$71,$72
DB $73,$74,$71,$72,$73,$74,$71,$72,$73,$74
DB $71,$72,$73,$74,$71,$72,$73,$74,$71,$72
DB $73,$74,$71,$72,$73,$74,$71,$72,$73,$74
DB $71,$72,$73,$74,$71,$72,$73,$74,$71,$72
DB $73,$74,$71,$72,$73,$74,$71,$72,$73,$74
DB $71,$72,$73,$74,$71,$72,$73,$74,$71,$72
DB $73,$74,$71,$72,$73,$74,$71,$72,$73,$74
DB $71,$72,$73,$74,$71,$72,$73,$74,$71,$72
DB $73,$74,$71,$72,$73,$74,$71,$72,$73,$74
DB $71,$72,$73,$74,$71,$72,$73,$74,$71,$72
DB $73,$74,$71,$72,$73,$74,$71,$72,$73,$74
DB $71,$72,$73,$74,$71,$72,$73,$74,$71,$72
DB $73,$74,$71,$72,$73,$74,$77,$75,$76,$71
DB $72,$77,$75,$76,$77,$75,$76,$77,$75,$76
DB $71,$72,$77,$75,$76,$77,$75,$76,$77,$75
DB $76,$77,$75,$76,$77,$75,$76,$71,$72,$77
DB $75,$76,$77,$75,$76,$77,$75,$76,$71,$72
DB $77,$75,$76,$77,$75,$76,$77,$75,$76,$77
DB $75,$76,$77,$75,$76,$71,$72,$77,$75,$76
DB $77,$75,$76,$77,$75,$76,$71,$72,$77,$75
DB $76,$77,$75,$76,$77,$75,$76,$77,$75,$76
DB $77,$75,$76,$71,$72,$77,$75,$76,$77,$75
DB $76,$77,$75,$76,$71,$72,$77,$75,$76,$77
DB $75,$76,$77,$75,$76,$77,$75,$76,$77,$75
DB $76,$71,$72,$77,$75,$76,$77,$75,$76,$77
DB $75,$76,$71,$72,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00

jordi_train_attr: ; 128x20, rows
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$00,$00,$20,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$00
DB $00,$00,$20,$01,$01,$01,$01,$01,$01,$01
DB $01,$00,$20,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$00,$20,$01,$01,$01,$01,$01,$01
DB $00,$00,$20,$01,$00,$00,$20,$20,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$00,$20,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$00,$00,$00,$20,$20,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$00,$00,$20,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$07,$01,$07,$07,$01,$07
DB $01,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$07,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$07,$07,$07,$07,$07,$01,$07,$01,$07
DB $07,$07,$07,$07,$07,$07,$07,$07,$07,$07
DB $27,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$07
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $27,$20,$00,$00,$00,$00,$00,$00,$20,$20
DB $00,$20,$20,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$20,$20
DB $00,$00,$00,$00,$00,$20,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$01,$01,$00,$00
DB $00,$00,$00,$20,$20,$20,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$20,$20,$00,$00
DB $00,$01,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $07,$00,$00,$00,$20,$20,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$20,$20,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$20,$20,$20,$00,$20,$00,$00
DB $00,$00,$00,$00,$00,$00,$20,$00,$00,$00
DB $00,$00,$20,$20,$00,$20,$20,$20,$20,$00
DB $00,$00,$00,$00,$00,$20,$20,$20,$00,$00
DB $20,$00,$00,$00,$00,$00,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$23,$23,$23,$23,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$23,$23,$23,$23,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$23,$23,$23,$23,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$23,$23,$23,$23
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$23,$23,$23
DB $23,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$23,$03
DB $03,$03,$23,$23,$04,$04,$04,$04,$04,$04
DB $04,$04,$04,$04,$04,$04,$04,$04,$04,$04
DB $04,$24,$24,$24,$24,$04,$04,$04,$04,$04
DB $04,$04,$04,$04,$04,$04,$04,$04,$04,$04
DB $04,$04,$24,$24,$24,$24,$04,$04,$04,$04
DB $04,$04,$04,$04,$04,$04,$04,$04,$04,$04
DB $04,$04,$04,$24,$24,$24,$24,$04,$04,$04
DB $04,$04,$04,$04,$04,$04,$04,$04,$04,$04
DB $04,$04,$04,$04,$24,$24,$24,$24,$04,$04
DB $04,$04,$04,$04,$04,$04,$04,$04,$04,$04
DB $04,$04,$04,$04,$04,$24,$24,$24,$24,$04
DB $04,$04,$04,$04,$04,$04,$04,$04,$04,$04
DB $04,$04,$04,$04,$04,$04,$24,$04,$04,$04
DB $24,$24,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$23
DB $23,$23,$23,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $23,$23,$23,$23,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$23,$23,$23,$23,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$23,$23,$23,$23,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$23,$23,$23,$23,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$23,$03,$03,$03,$23,$23
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$05,$05
DB $05,$05,$05,$05,$05,$05,$05,$05,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$00,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$00
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$00,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$00,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$00
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$00,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$00,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$00,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02

jordi_train_tiles: ; 146 tiles
DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
DB $FF,$FF,$FF,$FF,$00,$FF,$00,$FF
DB $FF,$00,$FF,$00,$00,$00,$00,$00
DB $FF,$00,$FC,$00,$F0,$00,$C0,$00
DB $04,$00,$FF,$00,$FF,$00,$FF,$00
DB $3F,$00,$1F,$00,$00,$00,$00,$00
DB $C0,$00,$80,$00,$FF,$00,$FE,$00
DB $FE,$00,$FC,$00,$38,$00,$00,$00
DB $00,$00,$EF,$00,$FF,$00,$FF,$00
DB $FF,$00,$F8,$00,$F8,$00,$E0,$00
DB $FC,$00,$F0,$00,$9F,$00,$00,$00
DB $FC,$00,$F8,$00,$00,$00,$00,$00
DB $03,$00,$01,$00,$FF,$00,$7F,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $00,$03,$00,$07,$00,$1F,$7F,$00
DB $00,$00,$1F,$1F,$7F,$7F,$FF,$FF
DB $00,$FF,$00,$FF,$00,$FF,$FF,$00
DB $00,$00,$F0,$F0,$F8,$F8,$FE,$FE
DB $00,$FF,$00,$FF,$00,$FF,$FF,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$C0,$00,$F0,$FC,$00
DB $00,$00,$00,$00,$01,$00,$1F,$00
DB $E0,$00,$00,$00,$00,$00,$00,$00
DB $01,$00,$1F,$00,$FF,$00,$F8,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $FF,$00,$FE,$00,$C7,$00,$0C,$00
DB $30,$00,$00,$00,$00,$00,$00,$00
DB $FF,$00,$DF,$00,$16,$00,$16,$00
DB $12,$00,$20,$00,$00,$00,$00,$00
DB $EA,$00,$E0,$00,$E2,$00,$31,$00
DB $10,$00,$00,$00,$00,$00,$00,$00
DB $CF,$00,$60,$00,$E0,$00,$F8,$00
DB $04,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$C0,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $FF,$18,$FF,$38,$FF,$3A,$17,$0E
DB $FF,$00,$FF,$00,$FF,$00,$EF,$70
DB $ED,$76,$EC,$77,$EC,$7F,$E4,$E6
DB $FF,$00,$FF,$00,$E1,$18,$FF,$18
DB $F9,$18,$E1,$1F,$80,$7F,$27,$78
DB $FF,$00,$FF,$00,$FF,$00,$F8,$67
DB $F5,$7A,$E0,$FF,$6B,$F4,$60,$FF
DB $FC,$0F,$C0,$21,$FE,$00,$3F,$C0
DB $BB,$5C,$30,$DE,$31,$DC,$33,$D8
DB $60,$80,$10,$E0,$18,$E0,$12,$6C
DB $12,$0C,$F2,$0C,$F2,$0C,$92,$6C
DB $EF,$10,$EE,$10,$EE,$10,$06,$00
DB $76,$82,$76,$86,$07,$F7,$74,$84
DB $55,$AA,$08,$00,$3E,$00,$1C,$00
DB $26,$00,$00,$00,$7E,$E1,$3E,$3F
DB $7F,$80,$7F,$00,$7F,$00,$7F,$00
DB $7F,$01,$7F,$31,$FF,$3D,$F8,$F8
DB $FF,$00,$E0,$00,$CE,$1E,$80,$01
DB $9C,$BD,$80,$81,$9C,$A1,$00,$86
DB $FF,$E0,$3F,$60,$3F,$E0,$3F,$EF
DB $C3,$03,$C3,$03,$C7,$FF,$01,$01
DB $E0,$18,$E7,$18,$E6,$18,$E2,$18
DB $E1,$58,$F8,$DF,$00,$C8,$67,$C0
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $FF,$00,$FF,$0C,$3F,$0C,$27,$07
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $FF,$00,$C0,$03,$40,$03,$42,$3F
DB $FF,$00,$FF,$00,$FF,$30,$E6,$79
DB $E6,$79,$E5,$7F,$E0,$70,$E7,$F2
DB $FF,$00,$FF,$00,$FF,$20,$0F,$81
DB $0F,$83,$5B,$FF,$0F,$0F,$E0,$40
DB $FF,$00,$FF,$00,$FF,$00,$FF,$70
DB $FF,$F0,$FF,$F0,$C1,$FE,$2E,$7F
DB $FF,$00,$FF,$00,$C1,$30,$C1,$31
DB $C1,$31,$C1,$71,$F8,$FF,$6D,$FE
DB $FF,$00,$FF,$00,$FE,$01,$FC,$1A
DB $FC,$FA,$FF,$FC,$1C,$FF,$F7,$39
DB $FF,$00,$FF,$00,$0F,$F0,$0F,$30
DB $01,$3E,$FF,$00,$01,$00,$7D,$00
DB $FF,$00,$FF,$00,$AB,$54,$01,$80
DB $15,$A0,$41,$A4,$61,$9C,$01,$80
DB $2D,$C6,$0D,$16,$21,$C2,$B1,$7E
DB $A1,$C2,$B1,$FE,$A1,$C2,$B1,$FE
DB $0C,$3E,$80,$BF,$80,$A0,$00,$3F
DB $1F,$20,$1F,$36,$00,$20,$1F,$20
DB $00,$7F,$27,$F8,$00,$00,$00,$FF
DB $7E,$81,$7E,$AD,$00,$00,$7E,$81
DB $2B,$F4,$20,$FF,$00,$00,$00,$FE
DB $FC,$02,$FC,$5A,$00,$00,$FC,$02
DB $27,$C0,$3F,$C1,$3E,$C3,$30,$DE
DB $31,$DC,$23,$C0,$3F,$C0,$3F,$C1
DB $12,$EC,$12,$8C,$72,$0C,$F2,$0C
DB $D2,$2C,$92,$6C,$92,$EC,$12,$EC
DB $70,$84,$06,$F0,$73,$84,$77,$84
DB $03,$F4,$77,$84,$77,$84,$07,$F4
DB $00,$00,$00,$20,$00,$20,$80,$00
DB $80,$00,$80,$20,$80,$20,$80,$00
DB $78,$78,$7F,$7F,$40,$7F,$00,$7F
DB $5E,$7F,$00,$1F,$60,$00,$7F,$00
DB $1B,$A4,$80,$86,$9B,$A4,$00,$86
DB $9B,$A4,$00,$86,$1B,$24,$80,$06
DB $6C,$91,$00,$01,$6C,$91,$01,$01
DB $6C,$91,$01,$01,$6D,$91,$01,$01
DB $6C,$C7,$67,$C3,$6C,$C7,$67,$C3
DB $6C,$C7,$67,$C3,$6C,$C7,$67,$C3
DB $BF,$3F,$21,$20,$A1,$20,$21,$20
DB $A1,$20,$31,$3F,$BE,$01,$3E,$1D
DB $C0,$C3,$C2,$7F,$C0,$43,$DC,$60
DB $DC,$43,$DC,$C0,$1C,$E3,$5C,$E0
DB $E0,$F0,$F0,$F0,$E7,$F2,$10,$10
DB $10,$F0,$17,$12,$10,$F0,$10,$10
DB $00,$08,$09,$0A,$E8,$4C,$0C,$0E
DB $0E,$0F,$EF,$4C,$0E,$0F,$0F,$0C
DB $00,$3F,$17,$DF,$01,$1E,$07,$0E
DB $95,$68,$F4,$08,$94,$6F,$F4,$08
DB $6C,$FF,$85,$06,$8E,$3F,$86,$07
DB $84,$07,$0C,$3F,$00,$07,$00,$07
DB $17,$F9,$F9,$39,$00,$81,$01,$A1
DB $00,$A1,$00,$81,$00,$A1,$00,$A1
DB $65,$18,$01,$00,$00,$01,$7C,$01
DB $64,$19,$00,$01,$00,$01,$7C,$01
DB $BF,$FE,$00,$00,$9A,$04,$1A,$04
DB $80,$00,$00,$00,$9A,$04,$1A,$04
DB $C0,$E0,$C0,$E0,$C0,$60,$CF,$60
DB $48,$E7,$4F,$E0,$5C,$E3,$4B,$E7
DB $00,$00,$00,$00,$00,$00,$FF,$00
DB $00,$FF,$FF,$00,$1F,$E0,$EF,$F0
DB $00,$00,$03,$00,$00,$00,$FF,$00
DB $00,$FF,$FF,$00,$BF,$7F,$36,$C9
DB $00,$00,$00,$00,$00,$00,$FF,$00
DB $00,$FF,$FF,$00,$FC,$03,$FB,$87
DB $00,$00,$00,$00,$00,$00,$FF,$00
DB $00,$FF,$FF,$00,$00,$FF,$BD,$FF
DB $00,$00,$00,$00,$00,$00,$FF,$00
DB $00,$FF,$FF,$00,$1F,$E0,$EF,$F0
DB $5B,$E7,$5B,$E7,$5A,$E7,$58,$E7
DB $58,$E7,$54,$EB,$40,$E0,$40,$E0
DB $EF,$F0,$EF,$F0,$8F,$F0,$0F,$F0
DB $0F,$F0,$19,$E6,$00,$00,$00,$00
DB $7E,$B7,$7E,$B7,$48,$B7,$48,$B7
DB $48,$B7,$48,$B7,$B6,$FF,$80,$80
DB $7B,$87,$7B,$87,$7A,$87,$78,$87
DB $78,$87,$4C,$B3,$80,$80,$80,$80
DB $BD,$FF,$BD,$FF,$52,$BD,$42,$BD
DB $42,$BD,$00,$FF,$00,$00,$00,$00
DB $EF,$F0,$EF,$F0,$8F,$F0,$0F,$F0
DB $0F,$F0,$19,$E6,$00,$00,$00,$00
DB $5F,$E0,$5F,$E0,$5F,$E0,$5F,$E0
DB $4B,$F4,$E0,$FF,$FE,$FF,$FF,$FF
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $EF,$10,$00,$FF,$64,$FF,$FF,$0E
DB $76,$89,$76,$89,$80,$00,$80,$7F
DB $FF,$00,$00,$FF,$CF,$FF,$FF,$1F
DB $7F,$80,$7F,$80,$FF,$00,$FF,$00
DB $FB,$04,$00,$FF,$CF,$3F,$FF,$FF
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $FF,$00,$00,$FF,$FF,$FF,$FF,$FF
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $EF,$10,$00,$FF,$FF,$FF,$FF,$FF
DB $80,$C0,$80,$80,$80,$80,$BF,$80
DB $A0,$9F,$BF,$80,$F0,$8F,$AF,$90
DB $00,$00,$00,$00,$00,$00,$FF,$00
DB $00,$FF,$FF,$00,$E7,$1C,$67,$9C
DB $00,$00,$03,$00,$00,$00,$FF,$00
DB $00,$FF,$FF,$00,$BF,$7F,$36,$C9
DB $00,$00,$00,$00,$00,$00,$FF,$00
DB $00,$FF,$FF,$00,$FC,$03,$FB,$87
DB $EF,$96,$EF,$96,$EB,$96,$EB,$96
DB $E9,$96,$EF,$90,$80,$FF,$D0,$90
DB $7F,$80,$7F,$80,$7F,$80,$7F,$80
DB $7F,$80,$73,$8C,$40,$A0,$80,$80
DB $7E,$B7,$7E,$B7,$48,$B7,$48,$B7
DB $48,$B7,$48,$B7,$B6,$FF,$80,$80
DB $7B,$87,$7B,$87,$7A,$87,$78,$87
DB $78,$87,$4C,$B3,$80,$80,$80,$80
DB $D0,$BF,$EF,$90,$F0,$80,$B0,$CF
DB $DF,$E0,$C0,$FF,$FB,$F3,$FF,$FF
DB $BF,$C0,$7F,$80,$FF,$00,$FF,$00
DB $FF,$00,$00,$FF,$33,$FF,$FF,$87
DB $76,$89,$76,$89,$80,$00,$80,$7F
DB $FF,$00,$00,$FF,$33,$FF,$FF,$87
DB $7F,$80,$7F,$80,$FF,$00,$FF,$00
DB $FB,$04,$00,$FF,$CF,$3F,$FF,$FF
DB $00,$3F,$60,$20,$FF,$20,$5F,$20
DB $FF,$7F,$FF,$7F,$E0,$7F,$7F,$C0
DB $00,$FF,$00,$00,$FF,$00,$FF,$00
DB $FF,$FF,$FF,$FF,$00,$FF,$FF,$00
DB $BE,$7B,$94,$32,$20,$12,$67,$00
DB $66,$21,$AD,$63,$77,$EF,$FF,$FF
DB $6D,$EB,$C6,$61,$8C,$43,$55,$8A
DB $13,$88,$F2,$09,$26,$DD,$9C,$FF
DB $AE,$7B,$86,$32,$20,$12,$67,$00
DB $66,$21,$AE,$61,$35,$FF,$FF,$FF
DB $FF,$FF,$CF,$DF,$73,$EF,$B9,$63
DB $18,$67,$C7,$02,$61,$BE,$00,$BC
DB $FF,$FF,$5D,$7F,$0D,$FB,$EC,$98
DB $A2,$D7,$72,$CE,$10,$8F,$00,$FC
DB $FF,$FF,$F3,$F3,$31,$AF,$38,$64
DB $88,$47,$5F,$32,$61,$A8,$00,$FF
DB $35,$C2,$F9,$00,$C6,$39,$00,$FF
DB $9A,$61,$0F,$F0,$90,$0F,$76,$81
DB $6C,$03,$9E,$60,$07,$F8,$CE,$31
DB $01,$FE,$E6,$01,$0C,$F0,$5E,$81
DB $53,$8C,$F9,$00,$E6,$19,$70,$8F
DB $17,$60,$C0,$3F,$B3,$0C,$28,$C7
DB $1C,$E3,$F8,$07,$A3,$1C,$FC,$03
DB $23,$C0,$FF,$00,$C5,$3A,$F0,$0F
DB $FC,$03,$0F,$F0,$F9,$06,$9A,$61
DB $FE,$01,$0C,$F3,$E7,$18,$43,$BC
DB $FF,$00,$C0,$3F,$67,$18,$C9,$30
DB $7F,$80,$0F,$F0,$C3,$3C,$FF,$00
DB $FC,$03,$0F,$F0,$F9,$06,$1E,$E1
DB $FE,$01,$08,$F4,$E3,$10,$07,$D8
DB $FF,$00,$CC,$33,$87,$78,$C9,$30
DB $7F,$80,$CF,$F0,$92,$7D,$9F,$60
DB $1E,$E1,$FB,$04,$AC,$1F,$08,$F4
DB $3F,$C0,$FF,$00,$85,$62,$F4,$0F
DB $D7,$28,$49,$86,$36,$0D,$EF,$10
DB $07,$F8,$18,$E7,$61,$FF,$A6,$1C
DB $33,$FC,$E7,$18,$30,$CF,$5C,$E7
DB $6C,$1A,$15,$E2,$CF,$30,$FC,$03
DB $F7,$0B,$30,$CF,$03,$E5,$B0,$0F
DB $22,$0D,$9B,$44,$2F,$D0,$F0,$0F
DB $EF,$00,$EF,$00,$EF,$10,$FF,$00
DB $CF,$30,$EF,$00,$CF,$30,$FF,$00
DB $CF,$20,$EF,$10,$D7,$20,$AF,$70
DB $87,$78,$33,$C0,$7D,$00,$FE,$00
DB $E7,$18,$00,$FF,$C4,$FC,$D3,$30
DB $51,$C0,$48,$34,$03,$E8,$C3,$3C
DB $00,$FF,$0A,$15,$65,$1E,$87,$7B
DB $9F,$20,$3E,$C1,$F0,$0F,$35,$FB
DB $E7,$18,$00,$FF,$CC,$30,$D9,$20
DB $6F,$80,$4B,$34,$17,$E8,$C3,$3C
DB $00,$FF,$EA,$15,$E5,$1A,$C6,$F8
DB $FF,$78,$3F,$C3,$F0,$0F,$37,$C8
DB $C4,$FC,$D3,$30,$41,$C0,$40,$24
DB $03,$E8,$C1,$38,$E7,$18,$0E,$F1
DB $60,$FF,$3A,$3D,$6F,$16,$E7,$18
DB $B3,$0C,$3E,$C1,$F0,$0F,$35,$FB
DB $F0,$0F,$BF,$60,$7E,$01,$FC,$00
DB $38,$C1,$CF,$00,$0D,$30,$19,$E6
DB $76,$89,$76,$89,$80,$00,$80,$7F
DB $FF,$00,$00,$FF,$FF,$FF,$FF,$FF
DB $0B,$0B,$D7,$6B,$43,$6B,$D7,$6B
DB $43,$6B,$CF,$6B,$47,$02,$83,$5E
DB $FF,$E0,$7F,$A0,$7F,$A0,$7F,$A0
DB $7F,$A0,$7F,$A0,$FF,$E0,$FF,$E0
DB $53,$0A,$9B,$46,$53,$0A,$9B,$46
DB $53,$0B,$7D,$02,$EB,$00,$7F,$00
DB $FF,$E0,$FF,$E0,$FF,$E0,$FF,$FF
DB $28,$29,$55,$AA,$09,$20,$FF,$00
DB $FF,$E0,$FF,$E0,$FF,$E0,$7F,$E0
DB $BF,$E0,$7F,$A0,$DF,$20,$DF,$20
DB $FF,$00,$FF,$00,$FF,$20,$EF,$30
DB $97,$79,$46,$99,$09,$0E,$FA,$04
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $FF,$00,$77,$88,$4B,$FC,$6D,$5E
DB $A1,$63,$75,$23,$23,$41,$FD,$22
DB $67,$01,$FD,$02,$EF,$00,$FF,$00
DB $0A,$04,$9B,$04,$0C,$00,$FB,$04
DB $0C,$00,$FF,$00,$1C,$00,$FF,$00
DB $FF,$00,$FF,$00,$E3,$0C,$C1,$16
DB $D5,$12,$9E,$23,$AB,$33,$8B,$33
DB $FF,$00,$C8,$00,$FF,$00,$C9,$00
DB $FF,$00,$89,$00,$FF,$00,$13,$01
DB $97,$B8,$D7,$B8,$97,$B8,$D7,$B8
DB $D3,$BC,$E3,$9C,$D1,$2E,$FD,$02
DB $FF,$00,$17,$38,$97,$B8,$97,$B8
DB $97,$B8,$97,$B8,$97,$B8,$97,$B8
DB $FF,$00,$E7,$04,$C8,$00,$C8,$00
DB $FF,$00,$C8,$00,$FF,$00,$C8,$00
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $2B,$1F,$27,$19,$61,$1F,$27,$19
DB $6B,$15,$BF,$00,$6F,$11,$FF,$00
DB $00,$0F,$7F,$0F,$05,$0A,$6F,$00
DB $2A,$25,$47,$20,$2C,$71,$21,$62
DB $0C,$71,$45,$62,$AD,$70,$BB,$20
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $FF,$00,$80,$18,$00,$31,$00,$31
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $FF,$00,$01,$C6,$00,$8F,$00,$8F
DB $FF,$00,$20,$00,$FF,$00,$20,$00
DB $FF,$00,$B2,$00,$FF,$00,$7A,$00
DB $FF,$1E,$89,$1F,$E9,$1F,$89,$1F
DB $E9,$1F,$BC,$0B,$F7,$09,$FD,$02
DB $F7,$08,$F7,$08,$F7,$08,$F7,$08
DB $FB,$04,$C3,$04,$C3,$04,$CF,$0C
DB $81,$3A,$81,$0A,$81,$0A,$87,$06
DB $00,$15,$0C,$11,$53,$04,$AE,$41
DB $FF,$00,$FD,$02,$A0,$5F,$E0,$05
DB $3E,$C1,$E5,$C0,$3F,$C0,$FF,$40
DB $FF,$00,$FF,$00,$FF,$00,$FF,$00
DB $F0,$00,$FE,$00,$F0,$00,$FE,$00

IF	TRAIN_ENABLE_BIRDS == 1
jordi_bird_tiles: ; 12 tiles
DB $00,$00,$01,$01,$02,$03,$05,$06
DB $07,$04,$03,$04,$03,$04,$07,$04
DB $05,$06,$1D,$3A,$7A,$45,$3E,$2F
DB $11,$11,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $B0,$B0,$78,$C8,$BC,$54,$FE,$0E
DB $F0,$18,$D0,$30,$20,$E0,$C0,$C0
DB $40,$40,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$03,$02
DB $05,$06,$19,$3E,$7A,$45,$3E,$2F
DB $11,$11,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $30,$30,$78,$48,$BC,$D4,$DE,$2E
DB $D0,$38,$F0,$10,$F0,$10,$F8,$88
DB $5C,$64,$18,$18,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$01,$03,$02,$07,$04
DB $07,$04,$1C,$3B,$3A,$45,$1E,$2F
DB $11,$11,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $30,$30,$F8,$C8,$BC,$54,$DE,$2E
DB $D0,$38,$D0,$30,$20,$E0,$C0,$C0
DB $40,$40,$00,$00,$00,$00,$00,$00

jordi_bird_palettes:
	DW	0,$7FFF,$318C,$0000 ; 3DEF,$0000
ENDC

;-------------------------------------------------------------------------------------------------

	SECTION	"Train_Vars",BSS

; ---------------------------

train_exit_demo:	DS	1 ; when 1, exit this part of the demo

train_event_count:	DS	2
train_current_event:	DS	2 ; pointer to the next event

; ---------------------------

train_scroll_tile_clouds:		DS	1
train_scroll_tile_mountain:		DS	1
train_scroll_tile_buildings:	DS	1
train_scroll_tile_train:		DS	1
train_scroll_tile_floor:		DS	1
train_scroll_tile_grass:		DS	1
train_scroll_tile_water_1:		DS	1
train_scroll_tile_water_2:		DS	1
train_scroll_tile_water_3:		DS	1
train_scroll_tile_water_4:		DS	1
train_scroll_tile_water_5:		DS	1
train_scroll_tile_water_6:		DS	1

train_scroll_scx_clouds:		DS	2
train_scroll_scx_mountain:		DS	2
train_scroll_scx_buildings:		DS	2
train_scroll_scx_train:			DS	2
train_scroll_scx_floor:			DS	2
train_scroll_scx_grass:			DS	2
train_scroll_scx_water_1:		DS	2
train_scroll_scx_water_2:		DS	2
train_scroll_scx_water_3:		DS	2
train_scroll_scx_water_4:		DS	2
train_scroll_scx_water_5:		DS	2
train_scroll_scx_water_6:		DS	2

; Speed must be <= 8*256 (= 2048)
TRAIN_SCROLL_SPEED_CLOUDS		EQU	32
TRAIN_SCROLL_SPEED_MOUNTAIN		EQU	64
TRAIN_SCROLL_SPEED_BUILDING		EQU	192
TRAIN_SCROLL_SPEED_TRAIN:		DS	2 ; This starts as TRAIN_SCROLL_MAX_SPEED
TRAIN_SCROLL_SPEED_FLOOR		EQU	512
TRAIN_SCROLL_SPEED_GRASS		EQU	576
TRAIN_SCROLL_SPEED_WATER_1		EQU	640 
TRAIN_SCROLL_SPEED_WATER_2		EQU	768 
TRAIN_SCROLL_SPEED_WATER_3		EQU	896 ; 896
TRAIN_SCROLL_SPEED_WATER_4		EQU	1024 ; 1024
TRAIN_SCROLL_SPEED_WATER_5		EQU	1280 ; 1152
TRAIN_SCROLL_SPEED_WATER_6		EQU	1536 ; 1280

TRAIN_SCROLL_MAX_SPEED			EQU	-64
TRAIN_SCROLL_MIN_SPEED			EQU 64
;TRAIN_SCROLL_MIN_SPEED			EQU TRAIN_SCROLL_SPEED_FLOOR ; stopped = same speed as floor

train_acelerate:				DS	1
; if 1, speed will go from TRAIN_SCROLL_MIN_SPEED to TRAIN_SCROLL_MAX_SPEED
; if 0, speed will go from TRAIN_SCROLL_MAX_SPEED to TRAIN_SCROLL_MIN_SPEED

; ---------------------------

IF	TRAIN_ENABLE_BIRDS == 1
train_bird_enabled:			DS	1*3
train_bird_frame:			DS	1*3
train_bird_ticks_to_change:	DS	1*3
train_bird_speed_x:			DS	2*3
train_bird_speed_y:			DS	2*3
train_bird_x:				DS	2*3
train_bird_y:				DS	2*3
ENDC

;-------------------------------------------------------------------------------------------------

	SECTION "Train", CODE, BANK[5]

;----------------------------------------------

train_init_variables:

	xor	a,a
	ld	[train_scroll_tile_clouds],a
	ld	[train_scroll_tile_mountain],a
	ld	[train_scroll_tile_buildings],a
	ld	[train_scroll_tile_train],a
	ld	[train_scroll_tile_floor],a
	ld	[train_scroll_tile_grass],a
	ld	[train_scroll_tile_water_1],a
	ld	[train_scroll_tile_water_2],a
	ld	[train_scroll_tile_water_3],a
	ld	[train_scroll_tile_water_4],a
	ld	[train_scroll_tile_water_5],a
	ld	[train_scroll_tile_water_6],a
	
	xor	a,a
	ld	[train_scroll_scx_clouds+0],a
	ld	[train_scroll_scx_clouds+1],a
	ld	[train_scroll_scx_mountain+0],a
	ld	[train_scroll_scx_mountain+1],a
	ld	[train_scroll_scx_buildings+0],a
	ld	[train_scroll_scx_buildings+1],a
	ld	[train_scroll_scx_train+0],a
	ld	[train_scroll_scx_train+1],a
	ld	[train_scroll_scx_floor+0],a
	ld	[train_scroll_scx_floor+1],a
	ld	[train_scroll_scx_grass+0],a
	ld	[train_scroll_scx_grass+1],a
	ld	[train_scroll_scx_water_1+0],a
	ld	[train_scroll_scx_water_1+1],a
	ld	[train_scroll_scx_water_2+0],a
	ld	[train_scroll_scx_water_2+1],a
	ld	[train_scroll_scx_water_3+0],a
	ld	[train_scroll_scx_water_3+1],a
	ld	[train_scroll_scx_water_4+0],a
	ld	[train_scroll_scx_water_4+1],a
	ld	[train_scroll_scx_water_5+0],a
	ld	[train_scroll_scx_water_5+1],a
	ld	[train_scroll_scx_water_6+0],a
	ld	[train_scroll_scx_water_6+1],a

IF	TRAIN_ENABLE_BIRDS == 1
	xor	a,a
	ld	[train_bird_enabled+0],a
	ld	[train_bird_enabled+1],a
	ld	[train_bird_enabled+2],a
ENDC

	ld	a,TRAIN_SCROLL_MIN_SPEED&$FF
	ld	[TRAIN_SCROLL_SPEED_TRAIN+0],a
	ld	a,TRAIN_SCROLL_MIN_SPEED>>8
	ld	[TRAIN_SCROLL_SPEED_TRAIN+1],a
	
	ld	a,0
	ld	[train_acelerate],a
	
	; -----------

	ld	a,0
	ld	[train_exit_demo],a
	
	ld	a,0
	ld	[train_event_count],a
	ld	[train_event_count+1],a
	
	ld	hl,_event_table_train
	ld	a,h
	ld	[train_current_event],a
	ld	a,l
	ld	[train_current_event+1],a

	ret

;----------------------------------------------

_event_exit_train_demo:
	ld	a,1
	ld	[train_exit_demo],a
	ret

_event_train_acelerate:
	ld	a,1
	ld	[train_acelerate],a
	ret

_event_train_decelerate:
	ld	a,0
	ld	[train_acelerate],a
	ret

_event_train_enable_1_bird:
	
	call	train_birds_configure_1
	
	ret

_event_train_enable_3_birds:
	
	call	train_birds_configure_3
	
	ret

;-------------------

_event_table_train:
	
	DW	1,_event_train_enable_1_bird
	
	DW	100,_event_train_acelerate
	DW	400,_event_train_decelerate
	
	DW	800,_event_train_enable_3_birds
	
	DW	1000,_event_train_acelerate
	DW	1400,_event_train_decelerate
	DW	1450,_event_train_acelerate
	
	DW	1600,_event_exit_train_demo

	DW	$FFFF,$0000 ; No more events! Don't remove this line!

;----------------------------------------------

train_handle_events:
	
	; Handle events
	; -------------
	
	ld	a,[train_event_count]
	ld	e,a
	ld	a,[train_event_count+1]
	ld	d,a
	
	; Start of checking
	
	ld	a,[train_current_event]
	ld	h,a
	ld	a,[train_current_event+1]
	ld	l,a
	
	ld	c,[hl]
	inc hl
	ld	b,[hl] ; bc = event counter trigger
	ld	a,c
	and	a,b
	cp	a,$FF ; if both are $FF, exit checking
	jr	z,._exit_check_events
	
	ld	a,d
	cp	a,b
	jr	nz,._exit_check_events
	
	ld	a,e
	cp	a,c
	jr	nz,._exit_check_events
	
	inc	hl
	
	ld	c,[hl]
	inc hl
	ld	b,[hl] ; bc = ptr to function
	inc	hl ; hl = ptr to next event
	
	ld	a,h
	ld	[train_current_event],a
	ld	a,l
	ld	[train_current_event+1],a ; save pointer to next event
	
	ld	h,b
	ld	l,c ; hl = ptr to function
	
	CALL_HL
._exit_check_events:

	; Now, handle functions...
	; ------------------------
	
	; More checks here
	
	; ...
	
	; Increase counter
	; ----------------
	
	ld	a,[train_event_count]
	ld	l,a
	ld	a,[train_event_count+1]
	ld	h,a
	
	inc	hl
	
	ld	a,l
	ld	[train_event_count],a
	ld	a,h
	ld	[train_event_count+1],a
	
	ret

;----------------------------------------------

; train_memcopy_src_dst()    b = size    hl = src    de = dst

train_memcopy_src_dst:

	ld	a,[hl]
	ld	[de],a
	
	ld	a,b ; save b
	
	ld	bc,128
	add	hl,bc ; increase source
	push	hl
	
	ld	hl,32
	add	hl,de ; increase dest
	ld	e,l
	ld	d,h
	
	pop	hl
	
	ld	b,a ; restore b
	
	dec	b
	jr	nz,train_memcopy_src_dst
	
	ret

;----------------------------------------------

train_copy_column: ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)
	
	push	bc
	
	ld	a,c
	
	ld	c,0
	srl	b
	rr	c
	or	a,c
	ld	c,a ; bc = (y << 7) | x
	
	ld	a,d ; a = number of tiles to copy (going down)
	
	ld	hl,jordi_train_map
	add	hl,bc ; hl = jordi_train_map + (y << 7) | x
	ld	e,l
	ld	d,h  ; de = jordi_train_map + (y << 7) | x
	
	ld	hl,jordi_train_attr
	add	hl,bc ; hl = jordi_train_attr + (y << 7) | x
	
	pop	bc
	
	; a = number of tiles to copy (going down)
	; bc = yx
	; de = jordi_train_map + (y << 7) | x
	; hl = jordi_train_attr + (y << 7) | x
	
	push	af
	push	hl
	
	ld	a,31
	and	a,c ; a = x & 31
	ld	h,0
	ld	l,b ; hl = y
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl ; hl = y << 5
	or	a,l
	ld	l,a ; hl = (y << 5) | x
	
	ld	bc,MAP_TEMP
	add	hl,bc ; hl = MAP_TEMP + ((y << 5) | x)
	ld	b,h
	ld	c,l ; bc = MAP_TEMP + ((y << 5) | x)
	
	pop	hl	
	pop	af
	
	; a = number of tiles to copy (going down)
	; bc = MAP_TEMP + ((y << 5) | x)
	; de = jordi_train_map + (y << 7) | x
	; hl = jordi_train_attr + (y << 7) | x
	
	; Copy tiles first
	; ----------------
	
	push	hl
	push	bc
	push	af
	
	ld	h,d
	ld	l,e ; hl = jordi_train_map + (y << 7) | x
	
	ld	d,b
	ld	e,c ; de = MAP_TEMP + ((y << 5) | x)
	
	ld	b,a
	
	ld	c,128
	
	call	train_memcopy_src_dst ; b = size    hl = source    de = dest
	
	pop	bc
	pop	de
	pop	hl
	
	; b = number of tiles to copy (going down)
	; de = MAP_TEMP + ((y << 5) | x)
	; hl = jordi_train_attr + (y << 7) | x
	
	push	hl
	ld	hl,ATTR_MAP_TEMP - MAP_TEMP
	add	hl,de
	ld	d,h
	ld	e,l ; hl = ATTR_MAP_TEMP + ((y << 5) | x)
	pop	hl
	
	; b = number of tiles to copy (going down)
	; de = ATTR_MAP_TEMP + ((y << 5) | x)
	; hl = jordi_train_attr + (y << 7) | x
	
	; Copy attr
	; ---------
	
	ld	c,128

	call	train_memcopy_src_dst ; b = size    hl = source    de = dest
	
	ret

;----------------------------------------------

train_palette_load:
	
	ld	b,$90
	call	wait_ly
	
	ld	hl,jordi_train_palettes
	
	ld	a,0
	call	bg_set_palette
	ld	a,1
	call	bg_set_palette
	ld	a,2
	call	bg_set_palette
	ld	a,3
	call	bg_set_palette
	ld	a,4
	call	bg_set_palette
	ld	a,5
	call	bg_set_palette
	ld	a,6
	call	bg_set_palette
	ld	a,7
	call	bg_set_palette

IF	TRAIN_ENABLE_BIRDS == 1
	ld	hl,jordi_bird_palettes
	ld	a,0
	call	spr_set_palette
ENDC

	ret
	
;----------------------------------------------

train_load_maps:
	
	ld	a,0
	ld	[rVBK],a
	
	ld	hl,jordi_train_map
	ld	de,MAP_TEMP
	ld	a,20 ; 18 + 2 extra rows
.loop_tiles:
	push	af
	
	ld	b,32
	call	memcopy_fast
	
	; now increase src by 96 to align columns
	
	push	de
	ld	de,96
	add	hl,de
	pop	de
	
	pop	af
	dec	a
	jr	nz,.loop_tiles
	
	; ----------------
	
	ld	a,1
	ld	[rVBK],a
	
	ld	hl,jordi_train_attr
	ld	de,ATTR_MAP_TEMP
	ld	a,20 ; 18 + 2 extra rows
.loop_attr:
	push	af
	
	ld	b,32
	call	memcopy_fast
	
	; now increase src by 96 to align columns
	
	push	de
	ld	de,96
	add	hl,de
	pop	de
	
	pop	af
	dec	a
	jr	nz,.loop_attr
	
	; ----------------
	
	ld	a,0
	ld	[rVBK],a

	ret

;----------------------------------------------

train_update_scrolls:

	; Clouds
	; ------
	
	ld	a,[train_scroll_scx_clouds+0]
	ld	e,a
	ld	a,[train_scroll_scx_clouds+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_CLOUDS
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_clouds+0],a
	ld	a,h
	ld	[train_scroll_scx_clouds+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_clouds
	
	ld	a,[train_scroll_tile_clouds]
	inc	a
	and	a,127
	ld	[train_scroll_tile_clouds],a
	
.notchanged_clouds:
	
	ld	a,[train_scroll_tile_clouds]
	add	a,21
	and	a,127
	ld	b,0
	ld	c,a
	ld	d,3
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)
	
	; Mountain
	; --------
	
	ld	a,[train_scroll_scx_mountain+0]
	ld	e,a
	ld	a,[train_scroll_scx_mountain+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_MOUNTAIN
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_mountain+0],a
	ld	a,h
	ld	[train_scroll_scx_mountain+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_mountain
	
	ld	a,[train_scroll_tile_mountain]
	inc	a
	and	a,127
	ld	[train_scroll_tile_mountain],a
	
.notchanged_mountain:

	ld	a,[train_scroll_tile_mountain]
	add	a,21
	and	a,127
	ld	b,3
	ld	c,a
	ld	d,2
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)
	
	; Buildings
	; ---------
	
	ld	a,[train_scroll_scx_buildings+0]
	ld	e,a
	ld	a,[train_scroll_scx_buildings+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_BUILDING
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_buildings+0],a
	ld	a,h
	ld	[train_scroll_scx_buildings+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_buildings
	
	ld	a,[train_scroll_tile_buildings]
	inc	a
	and	a,127
	ld	[train_scroll_tile_buildings],a

	ld	a,[train_scroll_tile_buildings]
	add	a,21
	and	a,127
	ld	b,5
	ld	c,a
	ld	d,2
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)

.notchanged_buildings:

	; Train
	; -----

	ld	a,[train_scroll_scx_train+0]
	ld	l,a
	ld	a,[train_scroll_scx_train+1]
	ld	h,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	a,[TRAIN_SCROLL_SPEED_TRAIN+0]
	ld	e,a
	ld	a,[TRAIN_SCROLL_SPEED_TRAIN+1]
	ld	d,a
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_train+0],a
	ld	a,h
	ld	[train_scroll_scx_train+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_train
	
	ld	a,[train_scroll_tile_train]
	
	bit	7,d
	jr	z,._train_speed_positive
	
	; Speed is negative
	dec	a
	and	a,127
	ld	[train_scroll_tile_train],a

	add	a,-1
	and	a,127
	ld	b,7
	ld	c,a
	ld	d,3
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)

	jr	.end_check_speed_train

._train_speed_positive:
	; Speed is positive
	inc	a
	and	a,127
	ld	[train_scroll_tile_train],a

	ld	a,[train_scroll_tile_train]
	add	a,21
	and	a,127
	ld	b,7
	ld	c,a
	ld	d,3
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)

.end_check_speed_train:
.notchanged_train:

	; Floor
	; -----
	
	ld	a,[train_scroll_scx_floor+0]
	ld	e,a
	ld	a,[train_scroll_scx_floor+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_FLOOR
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_floor+0],a
	ld	a,h
	ld	[train_scroll_scx_floor+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_floor
	
	ld	a,[train_scroll_tile_floor]
	inc	a
	and	a,127
	ld	[train_scroll_tile_floor],a
	
	ld	a,[train_scroll_tile_floor]
	add	a,21
	and	a,127
	ld	b,10
	ld	c,a
	ld	d,1
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)

.notchanged_floor:

	; Grass
	; -----
	
	ld	a,[train_scroll_scx_grass+0]
	ld	e,a
	ld	a,[train_scroll_scx_grass+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_GRASS
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_grass+0],a
	ld	a,h
	ld	[train_scroll_scx_grass+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_grass
	
	ld	a,[train_scroll_tile_grass]
	inc	a
	and	a,127
	ld	[train_scroll_tile_grass],a
	
	ld	a,[train_scroll_tile_grass]
	add	a,21
	and	a,127
	ld	b,11
	ld	c,a
	ld	d,1
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)

.notchanged_grass:

	; Water 1
	; -------
	
	ld	a,[train_scroll_scx_water_1+0]
	ld	e,a
	ld	a,[train_scroll_scx_water_1+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_WATER_1
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_water_1+0],a
	ld	a,h
	ld	[train_scroll_scx_water_1+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_water_1
	
	ld	a,[train_scroll_tile_water_1]
	inc	a
	and	a,127
	ld	[train_scroll_tile_water_1],a
	
.notchanged_water_1:

	ld	a,[train_scroll_tile_water_1]
	add	a,21
	and	a,127
	ld	b,12
	ld	c,a
	ld	d,1
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)
	
	; Water 2
	; -------
	
	ld	a,[train_scroll_scx_water_2+0]
	ld	e,a
	ld	a,[train_scroll_scx_water_2+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_WATER_2
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_water_2+0],a
	ld	a,h
	ld	[train_scroll_scx_water_2+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_water_2
	
	ld	a,[train_scroll_tile_water_2]
	inc	a
	and	a,127
	ld	[train_scroll_tile_water_2],a
	
.notchanged_water_2:

	ld	a,[train_scroll_tile_water_2]
	add	a,21
	and	a,127
	ld	b,13
	ld	c,a
	ld	d,1
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)
	
	; Water 3
	; -------
	
	ld	a,[train_scroll_scx_water_3+0]
	ld	e,a
	ld	a,[train_scroll_scx_water_3+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_WATER_3
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_water_3+0],a
	ld	a,h
	ld	[train_scroll_scx_water_3+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_water_3
	
	ld	a,[train_scroll_tile_water_3]
	inc	a
	and	a,127
	ld	[train_scroll_tile_water_3],a
	
.notchanged_water_3:

	ld	a,[train_scroll_tile_water_3]
	add	a,21
	and	a,127
	ld	b,14
	ld	c,a
	ld	d,1
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)
	
	; Water 4
	; -------
	
	ld	a,[train_scroll_scx_water_4+0]
	ld	e,a
	ld	a,[train_scroll_scx_water_4+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_WATER_4
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_water_4+0],a
	ld	a,h
	ld	[train_scroll_scx_water_4+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_water_4
	
	ld	a,[train_scroll_tile_water_4]
	inc	a
	and	a,127
	ld	[train_scroll_tile_water_4],a
	
.notchanged_water_4:

	ld	a,[train_scroll_tile_water_4]
	add	a,21
	and	a,127
	ld	b,15
	ld	c,a
	ld	d,1
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)
	
	; Water 5
	; -------
	
	ld	a,[train_scroll_scx_water_5+0]
	ld	e,a
	ld	a,[train_scroll_scx_water_5+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_WATER_5
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_water_5+0],a
	ld	a,h
	ld	[train_scroll_scx_water_5+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_water_5
	
	ld	a,[train_scroll_tile_water_5]
	inc	a
	and	a,127
	ld	[train_scroll_tile_water_5],a
	
.notchanged_water_5:

	ld	a,[train_scroll_tile_water_5]
	add	a,21
	and	a,127
	ld	b,16
	ld	c,a
	ld	d,1
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)
	
	; Water 6
	; -------
	
	ld	a,[train_scroll_scx_water_6+0]
	ld	e,a
	ld	a,[train_scroll_scx_water_6+1]
	ld	d,a
	and	a,$F8 ; remove lower 7 bits
	ld	b,a ; save in b
	
	ld	hl,TRAIN_SCROLL_SPEED_WATER_6
	add	hl,de
	
	ld	a,l
	ld	[train_scroll_scx_water_6+0],a
	ld	a,h
	ld	[train_scroll_scx_water_6+1],a
	
	and	a,$F8 ; remove lower 7 bits
	
	cp	a,b ; check if higher byte has changed to update tile number
	jr	z,.notchanged_water_6
	
	ld	a,[train_scroll_tile_water_6]
	inc	a
	and	a,127
	ld	[train_scroll_tile_water_6],a
	
.notchanged_water_6:

	ld	a,[train_scroll_tile_water_6]
	add	a,21
	and	a,127
	ld	b,17
	ld	c,a
	ld	d,1
	call	train_copy_column ; b = y (0-10) , c = x (0-127) , d = number of tiles to copy (going down)
	
	; Finished!
	; ---------
	
	ret

;----------------------------------------------

train_handle_aceleration:
	
	ld	a,[TRAIN_SCROLL_SPEED_TRAIN+0]
	ld	l,a
	ld	a,[TRAIN_SCROLL_SPEED_TRAIN+1]
	ld	h,a ; hl = speed
	
	ld	a,[train_acelerate]
	and	a,a
	jr	z,.deccelerate
	
	; Acelerate - from TRAIN_SCROLL_MIN_SPEED to TRAIN_SCROLL_MAX_SPEED
	
	ld	bc,$FFFF ; set speed: -1 -> speed is reversed
	ld	de,TRAIN_SCROLL_MAX_SPEED ; set limit
	jr	.check_limits
	
.deccelerate: 
	
	; Decelerate - from TRAIN_SCROLL_MAX_SPEED to TRAIN_SCROLL_MIN_SPEED
	
	ld	bc,$0001 ; set speed: +1 -> speed is reversed
	ld	de,TRAIN_SCROLL_MIN_SPEED ; set limit
	
.check_limits:

	; If limit, return
	
	ld	a,d
	cp	a,h
	jr	nz,.not_equal
	ld	a,e
	cp	a,l
	ret	z ; both equal, return
	
.not_equal
	; If not, update speed
	
	add	hl,bc
	add	hl,bc
	
	ld	a,l
	ld	[TRAIN_SCROLL_SPEED_TRAIN+0],a
	ld	a,h
	ld	[TRAIN_SCROLL_SPEED_TRAIN+1],a
	
	ret
	
;----------------------------------------------

train_map_update_bg_attr:

	ld	a,1
	ld	[rVBK],a

	DMA_COPY	ATTR_MAP_TEMP,$9800,32*20,0 ; src, dst, size, is_hdma
	
	ld	a,0
	ld	[rVBK],a

	DMA_COPY	MAP_TEMP,$9800,32*20,0 ; src, dst, size, is_hdma
	
	ret

;-------------------------------------------------------------------
;-                              BIRDS                              -
;-------------------------------------------------------------------

IF	TRAIN_ENABLE_BIRDS == 1

TRAIN_BIRD_ENABLE: MACRO ; \1 = number, \2 = start x, \3 = start y coordinate
	
	ld	bc,$0000
	ld	l,((\1)*2)+0
	call	sprite_set_xy
	ld	bc,$0000
	ld	l,((\1)*2)+1
	call	sprite_set_xy
	
	ld	a,0
	ld	l,((\1)*2)+0
	call	sprite_set_tile
	ld	a,2
	ld	l,((\1)*2)+1
	call	sprite_set_tile
	
	; --------------
	
	ld	a,0
	ld	[train_bird_frame+(\1)],a
	
	ld	a,5
	ld	[train_bird_ticks_to_change+(\1)],a
	
	ld	a,$80
	ld	[train_bird_speed_x+((\1)*2)+0],a
	ld	a,$FF
	ld	[train_bird_speed_x+((\1)*2)+1],a
	
	ld	a,0
	ld	[train_bird_speed_y+((\1)*2)+0],a
	ld	a,0
	ld	[train_bird_speed_y+((\1)*2)+1],a
	
	ld	a,0
	ld	[train_bird_y+((\1)*2)+0],a
	ld	a,\3
	ld	[train_bird_y+((\1)*2)+1],a
	
	ld	a,0
	ld	[train_bird_x+((\1)*2)+0],a
	ld	a,\2
	ld	[train_bird_x+((\1)*2)+1],a
	
	ld	a,1
	ld	[train_bird_enabled+(\1)],a
ENDM

;-------------------------------

train_birds_configure_1:
	
	TRAIN_BIRD_ENABLE	0,160+8,40
	
	ret

;-------------------------------

train_birds_configure_3:

	TRAIN_BIRD_ENABLE	0,160+8,40
	TRAIN_BIRD_ENABLE	1,208+8,56
	TRAIN_BIRD_ENABLE	2,184+8,88

	ret

;-------------------------------

TRAIN_BIRD_HANDLE:	MACRO ; \1 = number
	
	ld	a,[train_bird_enabled+(\1)]
	and	a,a
	jp	z,.bird_disabled\@
	
	; Update position
	; ---------------
	
	; Update X
	
	ld	a,[train_bird_speed_x+((\1)*2)+0]
	ld	l,a
	ld	a,[train_bird_speed_x+((\1)*2)+1]
	ld	h,a
	
	ld	a,[train_bird_x+((\1)*2)+0]
	ld	e,a
	ld	a,[train_bird_x+((\1)*2)+1]
	ld	d,a
	
	add	hl,de
	
	ld	a,l
	ld	[train_bird_x+((\1)*2)+0],a
	ld	a,h
	ld	[train_bird_x+((\1)*2)+1],a
	
	; Update Y
	
	ld	a,[train_bird_speed_y+((\1)*2)+0]
	ld	l,a
	ld	a,[train_bird_speed_y+((\1)*2)+1]
	ld	h,a
	
	ld	a,[train_bird_y+((\1)*2)+0]
	ld	e,a
	ld	a,[train_bird_y+((\1)*2)+1]
	ld	d,a
	
	add	hl,de
	
	ld	a,l
	ld	[train_bird_y+((\1)*2)+0],a
	ld	a,h
	ld	[train_bird_y+((\1)*2)+1],a
	
	; Update animation
	; ----------------

	ld	a,[train_bird_ticks_to_change+(\1)]
	dec	a
	ld	[train_bird_ticks_to_change+(\1)],a
	
	jr	nz,.dont_change\@
	
	ld	a,5
	ld	[train_bird_ticks_to_change+(\1)],a
	
	ld	a,[train_bird_frame+(\1)]
	inc	a
	cp	a,3
	jr	nz,.not_end\@
	
	call	GetRandom
	and	a,31
	add	a,8
	ld	[train_bird_ticks_to_change+(\1)],a
	
	ld	a,0
	
.not_end\@:
	ld	[train_bird_frame+(\1)],a

.dont_change\@:
	
	; Update speed based on animation
	; -------------------------------
	
	ld	a,$20
	ld	[train_bird_speed_y+((\1)*2)+0],a
	ld	a,$00
	ld	[train_bird_speed_y+((\1)*2)+1],a
	
	ld	a,[train_bird_frame+(\1)]
	cp	a,1
	jr	nz,.skip\@
	ld	a,$80
	ld	[train_bird_speed_y+((\1)*2)+0],a
	ld	a,$FF
	ld	[train_bird_speed_y+((\1)*2)+1],a
.skip\@:
	cp	a,2
	jr	nz,.skipa\@
	ld	a,$E0
	ld	[train_bird_speed_y+((\1)*2)+0],a
	ld	a,$FF
	ld	[train_bird_speed_y+((\1)*2)+1],a
.skipa\@:

	ld	a,$80
	ld	[train_bird_speed_x+((\1)*2)+0],a
	ld	a,$FF
	ld	[train_bird_speed_x+((\1)*2)+1],a
	
	ld	a,[train_bird_frame+(\1)]
	cp	a,1
	jr	nz,.skip2\@
	ld	a,$C0
	ld	[train_bird_speed_x+((\1)*2)+0],a
	ld	a,$00
	ld	[train_bird_speed_x+((\1)*2)+1],a
.skip2\@:

	; Update sprites
	; --------------
	
	; Position
	
	ld	a,[train_bird_x+((\1)*2)+1]
	ld	b,a
	ld	a,[train_bird_y+((\1)*2)+1]
	ld	c,a
	push	bc
	ld	l,((\1)*2)+0
	call	sprite_set_xy
	pop	bc
	
	ld	a,8
	add	a,b
	ld	b,a ; add 8 to x
	ld	l,((\1)*2)+1
	call	sprite_set_xy
	
	; Tiles
	
	ld	a,[train_bird_frame+(\1)]
	and	a,3
	sla	a
	sla	a
	ld	l,((\1)*2)+0
	call	sprite_set_tile
	
	ld	a,[train_bird_frame+(\1)]
	and	a,3
	sla	a
	add	a,1
	sla	a
	ld	l,((\1)*2)+1
	call	sprite_set_tile
	
	; Done
	; ----

.bird_disabled\@:

ENDM

;-------------------------------

train_birds_handle:
	
	TRAIN_BIRD_HANDLE	0
	TRAIN_BIRD_HANDLE	1
	TRAIN_BIRD_HANDLE	2
	
	ret

ENDC

;-------------------------------------------------------------------
;-                              OTHER                              -
;-------------------------------------------------------------------

train_lcd_handler:

	ld	a,[rLY]
	
	cp	a,(3*8)-1 ; Mountain?
	jr	nz,.not_mountain
	
	call	wait_screen_blank
	
	ld	a,[train_scroll_scx_mountain+1]
	ld	[rSCX],a
	ld	a,(5*8)-1
	ld	[rLYC],a
	ret
	
.not_mountain:
	
	cp	a,(5*8)-1 ; Buildings?
	jr	nz,.not_buildings

	call	wait_screen_blank

	ld	a,[train_scroll_scx_buildings+1]
	ld	[rSCX],a
	ld	a,(7*8)-1
	ld	[rLYC],a
	ret

.not_buildings:
	
	cp	a,(7*8)-1 ; Train?
	jr	nz,.not_train
	
	call	wait_screen_blank

	ld	a,[train_scroll_scx_train+1]
	ld	[rSCX],a	
	ld	a,(10*8)-1
	ld	[rLYC],a
	ret

.not_train:
	
	cp	a,(10*8)-1 ; Floor?
	jr	nz,.not_floor
	
	call	wait_screen_blank

	ld	a,[train_scroll_scx_floor+1]
	ld	[rSCX],a
	ld	a,(11*8)-1
	ld	[rLYC],a
	ret

.not_floor:
	
	cp	a,(11*8)-1 ; Grass?
	jr	nz,.not_grass
	
	call	wait_screen_blank

	ld	a,[train_scroll_scx_grass+1]
	ld	[rSCX],a
	ld	a,(12*8)-1
	ld	[rLYC],a
	ret

.not_grass:

	cp	a,(12*8)-1 ; Water 1?
	jr	nz,.not_water_1
	
	call	wait_screen_blank

	ld	a,[train_scroll_scx_water_1+1]
	ld	[rSCX],a
	ld	a,(13*8)-1
	ld	[rLYC],a
	ret

.not_water_1:
	
	cp	a,(13*8)-1 ; Water 2?
	jr	nz,.not_water_2
	
	call	wait_screen_blank

	ld	a,[train_scroll_scx_water_2+1]
	ld	[rSCX],a
	ld	a,(14*8)-1
	ld	[rLYC],a
	ret

.not_water_2:

	cp	a,(14*8)-1 ; Water 3?
	jr	nz,.not_water_3
	
	call	wait_screen_blank

	ld	a,[train_scroll_scx_water_3+1]
	ld	[rSCX],a
	ld	a,(15*8)-1
	ld	[rLYC],a
	ret

.not_water_3:
	
	cp	a,(15*8)-1 ; Water 4?
	jr	nz,.not_water_4
	
	call	wait_screen_blank

	ld	a,[train_scroll_scx_water_4+1]
	ld	[rSCX],a
	ld	a,(16*8)-1
	ld	[rLYC],a
	ret

.not_water_4:

	cp	a,(16*8)-1 ; Water 5?
	jr	nz,.not_water_5
	
	call	wait_screen_blank

	ld	a,[train_scroll_scx_water_5+1]
	ld	[rSCX],a
	ld	a,(17*8)-1
	ld	[rLYC],a
	ret

.not_water_5:

	; Water 6
	
	call	wait_screen_blank

	ld	a,[train_scroll_scx_water_6+1]
	ld	[rSCX],a

	ret

;----------------------------------------------

train_vbl_handler:

IF	TRAIN_ENABLE_BIRDS == 1
	call	refresh_OAM
ENDC

	call	train_map_update_bg_attr
	
	ld	a,[train_scroll_scx_clouds+1]
	ld	[rSCX],a
	ld	a,(3*8)-1
	ld	[rLYC],a ; first IRQ happens at this line
	
	LONG_CALL	gbt_update

	ret

;----------------------------------------------
	
	GLOBAL Train
	
Train:
	
	ld	a,LCDCF_ON|LCDCF_BG8800|LCDCF_BG9800 ; configuration
	ld	[rLCDC],a
	
	ld	a,0
	ld	[rVBK],a
	
	ld	bc,128
	ld	hl,jordi_train_tiles
	ld	de,256 ;  de = start index
	call	vram_copy_tiles
	ld	bc,146-128
	ld	de,128 ;  de = start index
	call	vram_copy_tiles

IF	TRAIN_ENABLE_BIRDS == 1
	ld	bc,12
	ld	hl,jordi_bird_tiles
	ld	de,$0000 ;  de = start index
	call	vram_copy_tiles
ENDC

	call	train_load_maps

	call	train_init_variables
	
	call	wait_vbl
	
	call	train_map_update_bg_attr

	call	wait_vbl
	
	call	train_palette_load

IF	TRAIN_ENABLE_BIRDS == 1	
	ld	a,LCDCF_ON|LCDCF_BG8800|LCDCF_BG9800|LCDCF_OBJON|LCDCF_OBJ16 ; configuration
	ld	[rLCDC],a
ENDC

	ld	bc,train_vbl_handler
	call	irq_set_VBL
	
	ld	bc,train_lcd_handler
	call	irq_set_LCD
	
	ld	a,[train_scroll_scx_clouds+1]
	ld	[rSCX],a
	ld	a,(3*8)-1
	ld	[rLYC],a ; first IRQ happens at this line
	
	ld	a,STATF_LYC
	ld	[rSTAT],a
	
	ld	a,0
	ld	[rIF],a
	
	ld	a,$03
	ld	[rIE],a
	
	; START	
	
.loop: ; Main loop

	call	train_update_scrolls
	call	train_handle_aceleration
IF	TRAIN_ENABLE_BIRDS == 1
	call	train_birds_handle
ENDC
	call	train_handle_events
	
	call	wait_vbl
	
	ld	a,[train_exit_demo]
	and	a,a
	jr	z,.loop
	
	; Exit...
	; -------
	
	call	demo_config_default
	
	ret

;-------------------------------------------------------------------
